/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

final class RelationRoleEditor {
    private RelationRoleEditor() {
    }

    static void editRole(Relation relation, PropertiesDialog.MemberInfo memberInfo) {
        if (MainApplication.getLayerManager().getActiveDataLayer().isLocked()) {
            return;
        }
        SubclassFilteredCollection<IRelationMember<?>, RelationMember> members = Utils.filteredCollection(memberInfo.getRole(), RelationMember.class);
        String oldRole = memberInfo.getRoleString();
        DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();
        String newRole = JOptionPane.showInputDialog("<html>" + I18n.tr("Change role for {0} in relation {1}", formatter.formatAsHtmlUnorderedList(Utils.transform(members, RelationMember::getMember), 5), formatter.formatAsHtmlUnorderedList(relation)), (Object)oldRole);
        if (newRole == null || oldRole.equals(newRole) || I18n.tr("<different>", new Object[0]).equals(newRole)) {
            return;
        }
        List<RelationMember> newMembers = relation.getMembers();
        newMembers.replaceAll(m -> members.contains(m) ? new RelationMember(Utils.strip(newRole), m.getMember()) : m);
        UndoRedoHandler.getInstance().add(new ChangeMembersCommand(relation, newMembers));
    }
}

