/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.sdedit.diagram.LifelineFlag;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Cross;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Figure;
import net.sf.sdedit.drawable.LabeledBox;
import net.sf.sdedit.drawable.Line;
import net.sf.sdedit.drawable.Rectangle;
import net.sf.sdedit.util.Direction;
import net.sf.sdedit.util.Grep;

public final class Lifeline
implements Comparable<Lifeline> {
    public static final String ACTOR = "Actor";
    private final Direction direction;
    private final String name;
    private final String type;
    private final String label;
    private final Lifeline root;
    private Lifeline parent;
    private Lifeline leftChild;
    private Lifeline rightChild;
    private boolean active;
    private boolean alive;
    private final int level;
    private final int sideLevel;
    private final SequenceDiagram diagram;
    private ExtensibleDrawable view;
    private final Drawable head;
    private Cross cross;
    private int thread;
    private Line lastLine;
    private int rectangleBottom;
    private final List<ExtensibleDrawable> allViews;
    private Grep.Region nameRegion;
    private boolean destroyed;
    private Set<LifelineFlag> flags;

    public String toString() {
        String string = this.name + ":" + this.type;
        if (this.label.length() > 0) {
            string = string + " \"" + this.label + "\" ";
        }
        if (!this.alive) {
            string = "/" + string;
        }
        if (this.flags.size() > 0) {
            string = string + " [" + LifelineFlag.toString(this.flags) + "]";
        }
        return string;
    }

    public Lifeline(String name, String type, String label, boolean alive, Set<LifelineFlag> flags, SequenceDiagram diagram) {
        this.diagram = diagram;
        this.name = name;
        this.type = type;
        this.direction = Direction.CENTER;
        this.alive = alive;
        this.thread = 0;
        this.level = 0;
        this.flags = flags;
        this.label = label;
        this.parent = null;
        this.root = this;
        this.sideLevel = 0;
        this.rectangleBottom = 0;
        this.allViews = new LinkedList<ExtensibleDrawable>();
        if (type.equals(ACTOR)) {
            this.head = new Figure(this, label, diagram.getVerticalPosition(), !this.is(LifelineFlag.ROLE));
            this.view = new Rectangle(this.computeDrawableWidth(), this);
            this.active = true;
        } else if (this.is(LifelineFlag.PROCESS)) {
            this.head = new LabeledBox(this, label, diagram.getVerticalPosition(), this.is(LifelineFlag.ANONYMOUS), !this.is(LifelineFlag.ROLE));
            this.view = new Rectangle(this.computeDrawableWidth(), this);
            this.active = true;
        } else {
            this.head = new LabeledBox(this, label, diagram.getVerticalPosition(), this.is(LifelineFlag.ANONYMOUS), !this.is(LifelineFlag.ROLE));
            this.view = new Line(1, this);
            this.active = false;
        }
        this.view.setTop(this.head.getTop() + this.head.getHeight());
        this.head.setVisible(alive);
        this.view.setVisible(alive);
        this.addView(this.view);
    }

    public boolean is(LifelineFlag flag) {
        return flag.in(this.flags);
    }

    private Lifeline(Lifeline root, Direction direction, int thread) {
        this.name = root.name;
        this.type = root.type;
        this.direction = direction;
        this.root = root;
        this.thread = thread;
        this.flags = new HashSet<LifelineFlag>(root.flags);
        this.label = root.label;
        this.flags.remove((Object)LifelineFlag.AUTOMATIC);
        this.flags.remove((Object)LifelineFlag.THREAD);
        this.flags.remove((Object)LifelineFlag.PROCESS);
        this.diagram = root.diagram;
        this.alive = true;
        this.parent = root;
        this.level = root.getAllLifelines().size();
        this.allViews = null;
        if (direction == Direction.LEFT) {
            while (this.parent.leftChild != null) {
                this.parent = this.parent.leftChild;
            }
            this.parent.leftChild = this;
        } else {
            while (this.parent.rightChild != null) {
                this.parent = this.parent.rightChild;
            }
            this.parent.rightChild = this;
        }
        this.sideLevel = this.parent.sideLevel + 1;
        this.active = false;
        this.view = new Rectangle(this.computeDrawableWidth(), this);
        this.head = null;
    }

    public void addView(ExtensibleDrawable view) {
        this.root.allViews.add(view);
    }

    public List<ExtensibleDrawable> getAllViews() {
        int lineTop = Integer.MAX_VALUE;
        int lineBottom = -1;
        Drawable mainLine = null;
        for (ExtensibleDrawable view : this.allViews) {
            if (!(view instanceof Line)) continue;
            Line line = (Line)view;
            if (mainLine == null) {
                mainLine = line;
                line.setMainLine(true);
            }
            lineTop = Math.min(lineTop, line.getTop());
            lineBottom = Math.max(lineBottom, line.getBottom());
        }
        if (mainLine != null) {
            mainLine.setTop(lineTop);
            mainLine.setBottom(lineBottom);
        }
        return this.allViews;
    }

    public int getCallLevel() {
        int callLevel = 0;
        for (Lifeline line : this.getRoot().getAllLifelines()) {
            if (line == this || this.thread != line.thread) continue;
            ++callLevel;
        }
        return callLevel;
    }

    public boolean hasThread() {
        return this.is(LifelineFlag.THREAD);
    }

    public void setThread(int thread) {
        this.thread = thread;
    }

    public int getThread() {
        return this.thread;
    }

    public int getUniqueThread() {
        int t = -1;
        for (Lifeline line : this.getAllLifelines()) {
            if (!line.isActive()) continue;
            if (t == -1) {
                t = line.getThread();
                continue;
            }
            if (t == line.getThread()) continue;
            return -1;
        }
        return t;
    }

    public Lifeline getLeftmost() {
        Lifeline left = this.root;
        while (left.leftChild != null) {
            left = left.leftChild;
        }
        return left;
    }

    public Lifeline getRightmost() {
        Lifeline right = this.root;
        while (right.rightChild != null) {
            right = right.rightChild;
        }
        return right;
    }

    public Lifeline getRoot() {
        return this.root;
    }

    public boolean isAlwaysActive() {
        return this.type.equals(ACTOR) || this.is(LifelineFlag.PROCESS);
    }

    public List<Lifeline> getAllLifelines() {
        ArrayList<Lifeline> list = new ArrayList<Lifeline>();
        list.add(this);
        Lifeline line = this.leftChild;
        while (line != null) {
            list.add(line);
            line = line.leftChild;
        }
        line = this.rightChild;
        while (line != null) {
            list.add(line);
            line = line.rightChild;
        }
        return list;
    }

    public Lifeline getLastInThread(int thread) {
        Lifeline last = null;
        for (Lifeline lifeline : this.getAllLifelines()) {
            if (lifeline.getThread() != thread || last != null && lifeline.level <= last.level) continue;
            last = lifeline;
        }
        return last;
    }

    public Lifeline getRightNeighbour() {
        int pos = this.getPosition();
        if (pos < this.diagram.getNumberOfLifelines() - 1) {
            Lifeline right = this.diagram.getLifelineAt(pos + 1);
            while (right.leftChild != null) {
                right = right.leftChild;
            }
            return right;
        }
        return null;
    }

    public Lifeline getLeftNeighbour() {
        int pos = this.getPosition();
        if (pos > 0) {
            Lifeline left = this.diagram.getLifelineAt(pos - 1);
            while (left.rightChild != null) {
                left = left.rightChild;
            }
            return left;
        }
        return null;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void giveBirth() {
        this.alive = true;
        this.head.setVisible(true);
        this.view.setVisible(true);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getPosition() {
        return this.diagram.getPositionOf(this);
    }

    public int getSideLevel() {
        return this.sideLevel;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Lifeline addActivity(Lifeline caller, int thread) {
        Direction theDirection = caller == null ? Direction.RIGHT : (caller.getName().equals(this.getName()) ? (caller.getDirection() == Direction.CENTER ? Direction.RIGHT : (this.getDirection() == Direction.CENTER ? caller.getDirection() : this.getDirection())) : (caller.getPosition() < this.getPosition() ? Direction.LEFT : Direction.RIGHT));
        return new Lifeline(this.root, theDirection, thread);
    }

    public void finish() {
        this.setActive(false);
        this.getRoot().setRectangleBottom(this.diagram.getVerticalPosition());
    }

    public void terminate() {
        ExtensibleDrawable _view;
        if (!this.alive) {
            throw new IllegalStateException("cannot terminate lifeline " + this.name + ", it is not alive");
        }
        ExtensibleDrawable extensibleDrawable = _view = this.lastLine != null ? this.lastLine : this.view;
        if (this.is(LifelineFlag.AUTOMATIC)) {
            int bottom = Math.max(this.rectangleBottom, this.diagram.getVerticalPosition());
            this.cross = new Cross(this);
            int y = (bottom += 6) + this.cross.getHeight();
            if (y > this.diagram.getVerticalPosition()) {
                this.diagram.extendLifelines(y - this.diagram.getVerticalPosition());
            }
            this.cross.setTop(bottom);
            this.diagram.getPaintDevice().addExtraordinary(this.cross);
            _view.setBottom(bottom);
        }
        this.alive = false;
    }

    public void dispose() {
        if (this.active) {
            throw new IllegalStateException("lifeline is still active");
        }
        if (this.getRoot() == this) {
            throw new IllegalStateException("lifeline cannot be disposed");
        }
        switch (this.direction) {
            case LEFT: {
                this.parent.leftChild = this.leftChild;
                if (this.leftChild == null) break;
                this.leftChild.parent = this.parent;
                break;
            }
            case RIGHT: {
                this.parent.rightChild = this.rightChild;
                if (this.rightChild == null) break;
                this.rightChild.parent = this.parent;
                break;
            }
            case CENTER: {
                throw new IllegalStateException("The lifeline is not root, but has center direction");
            }
        }
        this.getRoot().setRectangleBottom(this.diagram.getVerticalPosition());
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this != this.getRoot()) {
            if (active) {
                this.view.setTop(this.parent.getView().getTop() + this.parent.getView().getHeight());
                this.view.setHeight(0);
            }
            return;
        }
        int y = this.view.getTop() + this.view.getHeight();
        if (active) {
            this.view = new Rectangle(this.computeDrawableWidth(), this);
        } else {
            this.view = new Line(1, this);
            this.lastLine = (Line)this.view;
        }
        this.view.setTop(y);
    }

    public void setRectangleBottom(int bottom) {
        this.rectangleBottom = Math.max(this.rectangleBottom, bottom);
    }

    public SequenceDiagram getDiagram() {
        return this.diagram;
    }

    public ExtensibleDrawable getView() {
        return this.view;
    }

    public Drawable getHead() {
        return this.head;
    }

    public boolean isAnonymous() {
        return this.is(LifelineFlag.ANONYMOUS);
    }

    private int computeDrawableWidth() {
        return this.sideLevel == 0 ? this.diagram.getConfiguration().getMainLifelineWidth() : this.diagram.getConfiguration().getSubLifelineWidth();
    }

    public boolean isExternal() {
        return this.is(LifelineFlag.EXTERNAL);
    }

    public void destroy() {
        this.diagram.removeLifeline(this.getName());
        this.cross = new Cross(this);
        this.diagram.getPaintDevice().addExtraordinary(this.cross);
    }

    public Cross getCross() {
        return this.cross;
    }

    @Override
    public int compareTo(Lifeline lifeline) {
        return this.name.compareTo(lifeline.name);
    }

    public void setNameRegion(Grep.Region region) {
        this.nameRegion = region;
    }

    public Grep.Region getNameRegion() {
        return this.nameRegion;
    }

    public boolean isVariable() {
        return this.is(LifelineFlag.VARIABLE);
    }

    public boolean isAutodestroy() {
        return this.is(LifelineFlag.AUTOMATIC);
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }
}

