# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function

__metaclass__ = type

from ansible_collections.junipernetworks.junos.tests.unit.compat.mock import (
    patch,
    MagicMock,
)
from ansible_collections.junipernetworks.junos.plugins.modules import (
    junos_bgp_address_family,
)
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import (
    set_module_args,
)
from .junos_module import TestJunosModule, load_fixture


class TestJunosBgp_address_familyModule(TestJunosModule):
    module = junos_bgp_address_family

    def setUp(self):
        super(TestJunosBgp_address_familyModule, self).setUp()
        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration"
        )
        self.lock_configuration = self.mock_lock_configuration.start()
        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration"
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()
        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_address_family.bgp_address_family.load_config"
        )
        self.load_config = self.mock_load_config.start()

        self.mock_validate_config = patch(
            "ansible_collections.ansible.netcommon.plugins.module_utils.network.common.utils.validate_config"
        )
        self.validate_config = self.mock_validate_config.start()

        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_address_family.bgp_address_family.commit_configuration"
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()

        self.mock_get_connection = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.bgp_address_family.bgp_address_family."
            "Bgp_address_familyFacts.get_connection"
        )
        self.get_connection = self.mock_get_connection.start()

        self.conn = self.get_connection()
        self.conn.get = MagicMock()

        self.mock_get_xml_dict = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts."
            "bgp_address_family.bgp_address_family.Bgp_address_familyFacts._get_xml_dict"
        )
        self._get_xml_dict = self.mock_get_xml_dict.start()

    def tearDown(self):
        super(TestJunosBgp_address_familyModule, self).tearDown()
        self.mock_get_connection.stop()
        self.mock_load_config.stop()
        self.mock_validate_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()

    def load_fixtures(self, commands=None, format="text", changed=False):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_address_family_config.cfg"
        )
        if changed:
            self.load_config.return_value = load_fixture(
                "get_configuration_rpc_reply_diff.txt"
            )
        else:
            self.load_config.return_value = None

    def test_junos_bgp_address_family_add(self):
        set_module_args(
            dict(
                config=dict(
                    address_family=[
                        dict(
                            afi="evpn",
                            af_type=[dict(type="flow", damping=True)],
                        )
                    ]
                ),
                state="merged",
            )
        )

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:family><nc:evpn><nc:flow><nc:damping/></nc:flow></nc:evpn></nc:family></nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]

        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_address_family_merged_idempotent(self):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_address_family_config.cfg"
        )
        src = load_fixture("junos_bgp_address_family.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=dict(
                    address_family=[
                        dict(
                            afi="evpn",
                            af_type=[dict(type="flow", damping=True)],
                        )
                    ]
                ),
                state="merged",
            )
        )
        self.execute_module(changed=False, commands=[])

    def test_junos_bgp_group_address_family_add(self):
        set_module_args(
            dict(
                config=dict(
                    groups=[
                        dict(
                            name="external",
                            address_family=[
                                dict(
                                    afi="evpn",
                                    af_type=[dict(type="flow", damping=True)],
                                )
                            ],
                        )
                    ],
                    address_family=[
                        dict(
                            afi="evpn",
                            af_type=[dict(type="flow", damping=True)],
                        )
                    ],
                ),
                state="merged",
            )
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp>'
            "<nc:group><nc:name>external</nc:name>"
            "<nc:family><nc:evpn><nc:flow><nc:damping/>"
            "</nc:flow></nc:evpn></nc:family></nc:group>"
            "<nc:family><nc:evpn><nc:flow><nc:damping/></nc:flow></nc:evpn>"
            "</nc:family></nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]

        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_bgp_group_address_family_rep(self):
        set_module_args(
            dict(
                config=dict(
                    groups=[
                        dict(
                            name="external",
                            address_family=[
                                dict(
                                    afi="evpn",
                                    af_type=[dict(type="flow", damping=True)],
                                )
                            ],
                        )
                    ],
                    address_family=[
                        dict(
                            afi="evpn",
                            af_type=[dict(type="flow", damping=True)],
                        )
                    ],
                ),
                state="replaced",
            )
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp>'
            "<nc:group><nc:name>external</nc:name>"
            "<nc:family><nc:evpn><nc:flow><nc:damping/>"
            "</nc:flow></nc:evpn></nc:family></nc:group>"
            "<nc:family><nc:evpn><nc:flow><nc:damping/></nc:flow></nc:evpn>"
            "</nc:family></nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_bgp_address_family_rep_idempotent(self):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_address_family_config.cfg"
        )
        src = load_fixture("junos_bgp_address_family.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=dict(
                    groups=[
                        dict(
                            name="external",
                            address_family=[
                                dict(
                                    afi="evpn",
                                    af_type=[dict(type="flow", damping=True)],
                                )
                            ],
                        )
                    ],
                    address_family=[
                        dict(
                            afi="evpn",
                            af_type=[dict(type="flow", damping=True)],
                        )
                    ],
                ),
                state="replaced",
            )
        )

        self.execute_module(changed=False, commands=[])
