/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns;

import java.awt.Image;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.columns.ui.CopyDataToOtherColumnUI;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CopyDataToOtherColumn
implements AttributeColumnsManipulator {
    Column targetColumn;

    public void execute(Table table, Column column) {
        if (this.targetColumn != null && this.targetColumn != column) {
            ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).copyColumnDataToOtherColumn(table, column, this.targetColumn);
            ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).refreshCurrentTable();
        }
    }

    public String getName() {
        return NbBundle.getMessage(CopyDataToOtherColumn.class, (String)"CopyDataToOtherColumn.name");
    }

    public String getDescription() {
        return "";
    }

    public boolean canManipulateColumn(Table table, Column column) {
        return true;
    }

    public AttributeColumnsManipulatorUI getUI(Table table, Column column) {
        return new CopyDataToOtherColumnUI();
    }

    public int getType() {
        return 0;
    }

    public int getPosition() {
        return 200;
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/gephi/datalab/plugin/manipulators/resources/table-duplicate-column.png");
    }

    public Column getTargetColumn() {
        return this.targetColumn;
    }

    public void setTargetColumn(Column targetColumn) {
        this.targetColumn = targetColumn;
    }
}

