# Imported via `make aws_managed_policies`
aws_managed_policies_data = """
{
    "APIGatewayServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/APIGatewayServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-20T17:23:10+00:00",
        "DefaultVersionId": "v8",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "elasticloadbalancing:AddListenerCertificates",
                        "elasticloadbalancing:RemoveListenerCertificates",
                        "elasticloadbalancing:ModifyListener",
                        "elasticloadbalancing:DescribeListeners",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "xray:PutTraceSegments",
                        "xray:PutTelemetryRecords",
                        "xray:GetSamplingTargets",
                        "xray:GetSamplingRules",
                        "logs:CreateLogDelivery",
                        "logs:GetLogDelivery",
                        "logs:UpdateLogDelivery",
                        "logs:DeleteLogDelivery",
                        "logs:ListLogDeliveries",
                        "servicediscovery:DiscoverInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "firehose:DescribeDeliveryStream",
                        "firehose:PutRecord",
                        "firehose:PutRecordBatch"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:firehose:*:*:deliverystream/amazon-apigateway-*"
                },
                {
                    "Action": [
                        "acm:DescribeCertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:acm:*:*:certificate/*"
                },
                {
                    "Action": "ec2:CreateNetworkInterfacePermission",
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:network-interface/*"
                },
                {
                    "Action": "ec2:CreateTags",
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": [
                                "Owner",
                                "VpcLinkId"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:network-interface/*"
                },
                {
                    "Action": [
                        "ec2:ModifyNetworkInterfaceAttribute",
                        "ec2:DeleteNetworkInterface",
                        "ec2:AssignPrivateIpAddresses",
                        "ec2:CreateNetworkInterface",
                        "ec2:DeleteNetworkInterfacePermission",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeNetworkInterfaceAttribute",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeNetworkInterfacePermissions",
                        "ec2:UnassignPrivateIpAddresses",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeSecurityGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "servicediscovery:GetNamespace",
                    "Effect": "Allow",
                    "Resource": "arn:aws:servicediscovery:*:*:namespace/*"
                },
                {
                    "Action": "servicediscovery:GetService",
                    "Effect": "Allow",
                    "Resource": "arn:aws:servicediscovery:*:*:service/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQQDZNLDBF2ULTWK6",
        "PolicyName": "APIGatewayServiceRolePolicy",
        "UpdateDate": "2020-02-25T20:24:49+00:00",
        "VersionId": "v8"
    },
    "AWSAccountActivityAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSAccountActivityAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:18+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-portal:ViewBilling"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQRYCWMFX5J3E333K",
        "PolicyName": "AWSAccountActivityAccess",
        "UpdateDate": "2015-02-06T18:41:18+00:00",
        "VersionId": "v1"
    },
    "AWSAccountUsageReportAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSAccountUsageReportAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:19+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-portal:ViewUsage"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJLIB4VSBVO47ZSBB6",
        "PolicyName": "AWSAccountUsageReportAccess",
        "UpdateDate": "2015-02-06T18:41:19+00:00",
        "VersionId": "v1"
    },
    "AWSAgentlessDiscoveryService": {
        "Arn": "arn:aws:iam::aws:policy/AWSAgentlessDiscoveryService",
        "AttachmentCount": 0,
        "CreateDate": "2016-08-02T01:35:11+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "awsconnector:RegisterConnector",
                        "awsconnector:GetConnectorHealth"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:GetUser",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::connector-platform-upgrade-info/*",
                        "arn:aws:s3:::connector-platform-upgrade-info",
                        "arn:aws:s3:::connector-platform-upgrade-bundles/*",
                        "arn:aws:s3:::connector-platform-upgrade-bundles",
                        "arn:aws:s3:::connector-platform-release-notes/*",
                        "arn:aws:s3:::connector-platform-release-notes",
                        "arn:aws:s3:::prod.agentless.discovery.connector.upgrade/*",
                        "arn:aws:s3:::prod.agentless.discovery.connector.upgrade"
                    ]
                },
                {
                    "Action": [
                        "s3:PutObject",
                        "s3:PutObjectAcl"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::import-to-ec2-connector-debug-logs/*"
                    ]
                },
                {
                    "Action": [
                        "SNS:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:metrics-sns-topic-for-*"
                },
                {
                    "Action": [
                        "Discovery:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "Discovery"
                },
                {
                    "Action": [
                        "arsenal:RegisterOnPremisesAgent"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "arsenal"
                },
                {
                    "Action": [
                        "mgh:GetHomeRegion"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIA3DIL7BYQ35ISM4K",
        "PolicyName": "AWSAgentlessDiscoveryService",
        "UpdateDate": "2020-02-24T23:08:23+00:00",
        "VersionId": "v2"
    },
    "AWSAppMeshEnvoyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSAppMeshEnvoyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-07-03T21:29:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appmesh:StreamAggregatedResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4PMG6ZGSZZ",
        "PolicyName": "AWSAppMeshEnvoyAccess",
        "UpdateDate": "2019-07-03T21:29:37+00:00",
        "VersionId": "v1"
    },
    "AWSAppMeshFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSAppMeshFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-04-16T17:50:40+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appmesh:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": [
                                "appmesh.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/appmesh.amazonaws.com/AWSServiceRoleForAppMesh"
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:DescribeStack*",
                        "cloudformation:UpdateStack"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/AWSAppMesh-GettingStarted-*"
                },
                {
                    "Action": [
                        "acm:ListCertificates",
                        "acm:DescribeCertificate",
                        "acm-pca:DescribeCertificateAuthority",
                        "acm-pca:ListCertificateAuthorities"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "servicediscovery:ListNamespaces",
                        "servicediscovery:ListServices",
                        "servicediscovery:ListInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4ILVZ5BWFU",
        "PolicyName": "AWSAppMeshFullAccess",
        "UpdateDate": "2021-01-07T19:54:08+00:00",
        "VersionId": "v6"
    },
    "AWSAppMeshPreviewEnvoyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSAppMeshPreviewEnvoyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-05T23:32:39+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appmesh-preview:StreamAggregatedResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4NKURE3R2M",
        "PolicyName": "AWSAppMeshPreviewEnvoyAccess",
        "UpdateDate": "2019-08-05T23:32:39+00:00",
        "VersionId": "v1"
    },
    "AWSAppMeshPreviewServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSAppMeshPreviewServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-19T19:07:00+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "servicediscovery:DiscoverInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CloudMapServiceDiscovery"
                },
                {
                    "Action": [
                        "acm:DescribeCertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ACMCertificateVerification"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FAQWKJYPJ",
        "PolicyName": "AWSAppMeshPreviewServiceRolePolicy",
        "UpdateDate": "2019-08-21T21:06:29+00:00",
        "VersionId": "v3"
    },
    "AWSAppMeshReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSAppMeshReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2019-04-16T17:51:11+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appmesh:Describe*",
                        "appmesh:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloudformation:DescribeStack*"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/AWSAppMesh-GettingStarted-*"
                },
                {
                    "Action": [
                        "acm:ListCertificates",
                        "acm:DescribeCertificate",
                        "acm-pca:DescribeCertificateAuthority",
                        "acm-pca:ListCertificateAuthorities"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "servicediscovery:ListNamespaces",
                        "servicediscovery:ListServices",
                        "servicediscovery:ListInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HOPFCIWXP",
        "PolicyName": "AWSAppMeshReadOnly",
        "UpdateDate": "2021-01-07T19:53:16+00:00",
        "VersionId": "v5"
    },
    "AWSAppMeshServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSAppMeshServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-03T18:30:51+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "servicediscovery:DiscoverInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CloudMapServiceDiscovery"
                },
                {
                    "Action": [
                        "acm:DescribeCertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ACMCertificateVerification"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4B5IHMMEND",
        "PolicyName": "AWSAppMeshServiceRolePolicy",
        "UpdateDate": "2019-09-10T22:44:43+00:00",
        "VersionId": "v2"
    },
    "AWSAppSyncAdministrator": {
        "Arn": "arn:aws:iam::aws:policy/AWSAppSyncAdministrator",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-20T21:20:28+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appsync:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "appsync.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "appsync.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:DeleteServiceLinkedRole",
                        "iam:GetServiceLinkedRoleDeletionStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/appsync.amazonaws.com/AWSServiceRoleForAppSync*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJBYY36AJPXTTWIXCY",
        "PolicyName": "AWSAppSyncAdministrator",
        "UpdateDate": "2019-11-04T19:23:49+00:00",
        "VersionId": "v2"
    },
    "AWSAppSyncInvokeFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSAppSyncInvokeFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-20T21:21:20+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appsync:GraphQL",
                        "appsync:GetGraphqlApi",
                        "appsync:ListGraphqlApis",
                        "appsync:ListApiKeys"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAILMPWRRZN27MPE3VM",
        "PolicyName": "AWSAppSyncInvokeFullAccess",
        "UpdateDate": "2018-03-20T21:21:20+00:00",
        "VersionId": "v1"
    },
    "AWSAppSyncPushToCloudWatchLogs": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSAppSyncPushToCloudWatchLogs",
        "AttachmentCount": 0,
        "CreateDate": "2018-04-09T19:38:55+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIWN7WNO34HLMJPUQS",
        "PolicyName": "AWSAppSyncPushToCloudWatchLogs",
        "UpdateDate": "2018-04-09T19:38:55+00:00",
        "VersionId": "v1"
    },
    "AWSAppSyncSchemaAuthor": {
        "Arn": "arn:aws:iam::aws:policy/AWSAppSyncSchemaAuthor",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-20T21:21:06+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appsync:GraphQL",
                        "appsync:CreateResolver",
                        "appsync:CreateType",
                        "appsync:DeleteResolver",
                        "appsync:DeleteType",
                        "appsync:GetResolver",
                        "appsync:GetType",
                        "appsync:GetDataSource",
                        "appsync:GetSchemaCreationStatus",
                        "appsync:GetIntrospectionSchema",
                        "appsync:GetGraphqlApi",
                        "appsync:ListTypes",
                        "appsync:ListApiKeys",
                        "appsync:ListResolvers",
                        "appsync:ListDataSources",
                        "appsync:ListGraphqlApis",
                        "appsync:StartSchemaCreation",
                        "appsync:UpdateResolver",
                        "appsync:UpdateType"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIUCF5WVTOFQXFKY5E",
        "PolicyName": "AWSAppSyncSchemaAuthor",
        "UpdateDate": "2018-03-20T21:21:06+00:00",
        "VersionId": "v1"
    },
    "AWSAppSyncServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSAppSyncServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-01-21T19:56:53+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "xray:PutTraceSegments",
                        "xray:PutTelemetryRecords",
                        "xray:GetSamplingTargets",
                        "xray:GetSamplingRules",
                        "xray:GetSamplingStatisticSummaries"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IKBIQXBOO",
        "PolicyName": "AWSAppSyncServiceRolePolicy",
        "UpdateDate": "2020-01-21T19:56:53+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoScalingCustomResourcePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoScalingCustomResourcePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-04T23:22:44+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "execute-api:Invoke",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJYTKXPX6DO32Z4XXA",
        "PolicyName": "AWSApplicationAutoScalingCustomResourcePolicy",
        "UpdateDate": "2018-06-04T23:22:44+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingAppStreamFleetPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingAppStreamFleetPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-20T19:04:06+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "appstream:UpdateFleet",
                        "appstream:DescribeFleets",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIRI724OWKP56ZG62M",
        "PolicyName": "AWSApplicationAutoscalingAppStreamFleetPolicy",
        "UpdateDate": "2017-10-20T19:04:06+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingCassandraTablePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingCassandraTablePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-03-18T22:49:23+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "cassandra:Select",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:*:cassandra:*:*:/keyspace/system/table/*",
                        "arn:*:cassandra:*:*:/keyspace/system_schema/table/*",
                        "arn:*:cassandra:*:*:/keyspace/system_schema_mcs/table/*"
                    ]
                },
                {
                    "Action": [
                        "cassandra:Alter",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BOOOZAOTV",
        "PolicyName": "AWSApplicationAutoscalingCassandraTablePolicy",
        "UpdateDate": "2020-03-18T22:49:23+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingComprehendEndpointPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingComprehendEndpointPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-14T18:39:07+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "comprehend:UpdateEndpoint",
                        "comprehend:DescribeEndpoint",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HD4ODS6K6",
        "PolicyName": "AWSApplicationAutoscalingComprehendEndpointPolicy",
        "UpdateDate": "2019-11-14T18:39:07+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingDynamoDBTablePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingDynamoDBTablePolicy",
        "AttachmentCount": 1,
        "CreateDate": "2017-10-20T21:34:57+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dynamodb:DescribeTable",
                        "dynamodb:UpdateTable",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJOVQMDI3JFCBW4LFO",
        "PolicyName": "AWSApplicationAutoscalingDynamoDBTablePolicy",
        "UpdateDate": "2017-10-20T21:34:57+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingEC2SpotFleetRequestPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingEC2SpotFleetRequestPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-25T18:23:27+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeSpotFleetRequests",
                        "ec2:ModifySpotFleetRequest",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJNRH3VE3WW4Q4RDTU",
        "PolicyName": "AWSApplicationAutoscalingEC2SpotFleetRequestPolicy",
        "UpdateDate": "2017-10-25T18:23:27+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingECSServicePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingECSServicePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-25T23:53:08+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ecs:DescribeServices",
                        "ecs:UpdateService",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJFXLLV7AKH5PSFOYG",
        "PolicyName": "AWSApplicationAutoscalingECSServicePolicy",
        "UpdateDate": "2017-10-25T23:53:08+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingEMRInstanceGroupPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingEMRInstanceGroupPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-26T00:57:39+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "elasticmapreduce:ListInstanceGroups",
                        "elasticmapreduce:ModifyInstanceGroups",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIQ6M5Z7LQY2YSG2JS",
        "PolicyName": "AWSApplicationAutoscalingEMRInstanceGroupPolicy",
        "UpdateDate": "2017-10-26T00:57:39+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingKafkaClusterPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingKafkaClusterPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-24T18:36:01+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "kafka:DescribeCluster",
                        "kafka:DescribeClusterOperation",
                        "kafka:UpdateBrokerStorage",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FTCIZBJA2",
        "PolicyName": "AWSApplicationAutoscalingKafkaClusterPolicy",
        "UpdateDate": "2020-08-24T18:36:01+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingLambdaConcurrencyPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingLambdaConcurrencyPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-10-21T20:04:17+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "lambda:PutProvisionedConcurrencyConfig",
                        "lambda:GetProvisionedConcurrencyConfig",
                        "lambda:DeleteProvisionedConcurrencyConfig",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KIR2KPJCU",
        "PolicyName": "AWSApplicationAutoscalingLambdaConcurrencyPolicy",
        "UpdateDate": "2019-10-21T20:04:17+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationAutoscalingRDSClusterPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingRDSClusterPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-17T17:46:56+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "rds:AddTagsToResource",
                        "rds:CreateDBInstance",
                        "rds:DeleteDBInstance",
                        "rds:DescribeDBClusters",
                        "rds:DescribeDBInstances",
                        "rds:ModifyDBCluster",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": "rds.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ7XS52I27Q2JVKALU",
        "PolicyName": "AWSApplicationAutoscalingRDSClusterPolicy",
        "UpdateDate": "2018-08-07T19:14:24+00:00",
        "VersionId": "v3"
    },
    "AWSApplicationAutoscalingSageMakerEndpointPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSApplicationAutoscalingSageMakerEndpointPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-02-06T19:58:21+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sagemaker:DescribeEndpoint",
                        "sagemaker:DescribeEndpointConfig",
                        "sagemaker:UpdateEndpointWeightsAndCapacities",
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI5DBEBNRZQ4SXYTAW",
        "PolicyName": "AWSApplicationAutoscalingSageMakerEndpointPolicy",
        "UpdateDate": "2018-02-06T19:58:21+00:00",
        "VersionId": "v1"
    },
    "AWSApplicationDiscoveryAgentAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSApplicationDiscoveryAgentAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-05-11T21:38:47+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "arsenal:RegisterOnPremisesAgent"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "mgh:GetHomeRegion"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAICZIOVAGC6JPF3WHC",
        "PolicyName": "AWSApplicationDiscoveryAgentAccess",
        "UpdateDate": "2020-02-24T22:26:45+00:00",
        "VersionId": "v2"
    },
    "AWSApplicationDiscoveryServiceFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSApplicationDiscoveryServiceFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-05-11T21:30:50+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mgh:*",
                        "discovery:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "continuousexport.discovery.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
                },
                {
                    "Action": [
                        "iam:DeleteServiceLinkedRole",
                        "iam:GetServiceLinkedRoleDeletionStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "migrationhub.amazonaws.com",
                                "dmsintegration.migrationhub.amazonaws.com",
                                "smsintegration.migrationhub.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJBNJEA6ZXM2SBOPDU",
        "PolicyName": "AWSApplicationDiscoveryServiceFullAccess",
        "UpdateDate": "2019-06-19T21:21:26+00:00",
        "VersionId": "v4"
    },
    "AWSArtifactAccountSync": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSArtifactAccountSync",
        "AttachmentCount": 0,
        "CreateDate": "2018-04-10T23:04:33+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:ListAccounts",
                        "organizations:DescribeOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJMVPXRWZJZWDTYDNC",
        "PolicyName": "AWSArtifactAccountSync",
        "UpdateDate": "2018-04-10T23:04:33+00:00",
        "VersionId": "v1"
    },
    "AWSAuditManagerAdministratorAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSAuditManagerAdministratorAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-11T20:02:42+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "auditmanager:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AuditManagerAccess"
                },
                {
                    "Action": [
                        "organizations:ListAccountsForParent",
                        "organizations:ListAccounts",
                        "organizations:DescribeOrganization",
                        "organizations:DescribeOrganizationalUnit",
                        "organizations:DescribeAccount",
                        "organizations:ListParents",
                        "organizations:ListChildren"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "OrganizationsAccess"
                },
                {
                    "Action": [
                        "organizations:RegisterDelegatedAdministrator",
                        "organizations:DeregisterDelegatedAdministrator",
                        "organizations:EnableAWSServiceAccess"
                    ],
                    "Condition": {
                        "StringLikeIfExists": {
                            "organizations:ServicePrincipal": [
                                "auditmanager.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowOnlyAuditManagerIntegration"
                },
                {
                    "Action": [
                        "iam:GetUser",
                        "iam:ListUsers",
                        "iam:ListRoles"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "IAMAccess"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "auditmanager.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/auditmanager.amazonaws.com/AWSServiceRoleForAuditManager*",
                    "Sid": "IAMAccessCreateSLR"
                },
                {
                    "Action": [
                        "iam:DeleteServiceLinkedRole",
                        "iam:UpdateRoleDescription",
                        "iam:GetServiceLinkedRoleDeletionStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/auditmanager.amazonaws.com/AWSServiceRoleForAuditManager*",
                    "Sid": "IAMAccessManageSLR"
                },
                {
                    "Action": [
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "S3Access"
                },
                {
                    "Action": [
                        "kms:DescribeKey",
                        "kms:ListKeys",
                        "kms:ListAliases"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "KmsAccess"
                },
                {
                    "Action": [
                        "kms:CreateGrant"
                    ],
                    "Condition": {
                        "Bool": {
                            "kms:GrantIsForAWSResource": "true"
                        },
                        "StringLike": {
                            "kms:ViaService": "auditmanager.*.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "KmsCreateGrantAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSAccess"
                },
                {
                    "Action": [
                        "events:PutRule"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "events:detail-type": "Security Hub Findings - Imported",
                            "events:source": "aws.securityhub"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CreateEventsAccess"
                },
                {
                    "Action": [
                        "events:DeleteRule",
                        "events:DescribeRule",
                        "events:EnableRule",
                        "events:DisableRule",
                        "events:ListTargetsByRule",
                        "events:PutTargets",
                        "events:RemoveTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
                    "Sid": "EventsAccess"
                },
                {
                    "Action": [
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "TagAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4EBAFCQQJX",
        "PolicyName": "AWSAuditManagerAdministratorAccess",
        "UpdateDate": "2020-12-11T20:02:42+00:00",
        "VersionId": "v1"
    },
    "AWSAuditManagerServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSAuditManagerServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-08T15:12:12+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "license-manager:ListLicenseConfigurations",
                        "license-manager:ListAssociationsForLicenseConfiguration",
                        "license-manager:ListUsageForLicenseConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "LicenseManagerAccess"
                },
                {
                    "Action": [
                        "iam:GenerateCredentialReport",
                        "iam:GetAccountSummary",
                        "iam:ListPolicies",
                        "iam:GetAccountPasswordPolicy",
                        "iam:ListUsers",
                        "iam:ListUserPolicies",
                        "iam:ListRoles",
                        "iam:ListRolePolicies",
                        "iam:ListGroups",
                        "iam:ListGroupPolicies",
                        "iam:ListEntitiesForPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "IAMAccess"
                },
                {
                    "Action": [
                        "ec2:DescribeInstances",
                        "ec2:DescribeFlowLogs",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeNetworkAcls",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeVpcEndpoints"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "EC2Access"
                },
                {
                    "Action": [
                        "cloudtrail:DescribeTrails"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CloudtrailAccess"
                },
                {
                    "Action": [
                        "config:DescribeDeliveryChannels",
                        "config:ListDiscoveredResources",
                        "config:DescribeConfigRules"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ConfigAccess"
                },
                {
                    "Action": [
                        "securityhub:DescribeStandards"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SecurityHubAccess"
                },
                {
                    "Action": [
                        "kms:ListKeys",
                        "kms:DescribeKey",
                        "kms:ListGrants"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "KMSAccess"
                },
                {
                    "Action": [
                        "cloudwatch:DescribeAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CloudwatchAccess"
                },
                {
                    "Action": [
                        "s3:GetLifecycleConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "S3Access"
                },
                {
                    "Action": [
                        "events:DescribeRule"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "EventBridgeAccess"
                },
                {
                    "Action": [
                        "waf:ListActivatedRulesInRuleGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "WAFAccess"
                },
                {
                    "Action": [
                        "guardduty:ListDetectors"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "GuardDutyAccess"
                },
                {
                    "Action": [
                        "route53:GetQueryLoggingConfig"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "Route53Access"
                },
                {
                    "Action": [
                        "organizations:DescribePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "OrganizationsAccess"
                },
                {
                    "Action": [
                        "cognito-idp:DescribeUserPool"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CognitoAccess"
                },
                {
                    "Action": [
                        "elasticfilesystem:DescribeFileSystems"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "EFSAccess"
                },
                {
                    "Action": [
                        "events:PutRule"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "events:detail-type": "Security Hub Findings - Imported",
                            "events:source": "aws.securityhub"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CreateEventsAccess"
                },
                {
                    "Action": [
                        "events:DeleteRule",
                        "events:DescribeRule",
                        "events:EnableRule",
                        "events:DisableRule",
                        "events:ListTargetsByRule",
                        "events:PutTargets",
                        "events:RemoveTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:events:*:*:rule/AuditManagerSecurityHubFindingsReceiver",
                    "Sid": "EventsAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4C5N52UWST",
        "PolicyName": "AWSAuditManagerServiceRolePolicy",
        "UpdateDate": "2020-12-08T15:12:12+00:00",
        "VersionId": "v1"
    },
    "AWSAutoScalingPlansEC2AutoScalingPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSAutoScalingPlansEC2AutoScalingPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-08-23T22:46:59+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudwatch:GetMetricData",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeScheduledActions",
                        "autoscaling:BatchPutScheduledUpdateGroupAction",
                        "autoscaling:BatchDeleteScheduledAction"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIXWLPZPD4RYBM3JSU",
        "PolicyName": "AWSAutoScalingPlansEC2AutoScalingPolicy",
        "UpdateDate": "2018-08-23T22:46:59+00:00",
        "VersionId": "v1"
    },
    "AWSBackupFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSBackupFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-18T22:21:52+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": "backup:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "backup-storage:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "rds:DescribeDBSnapshots",
                        "rds:ListTagsForResource",
                        "rds:DescribeDBInstances",
                        "rds:describeDBEngineVersions",
                        "rds:describeOptionGroups",
                        "rds:describeOrderableDBInstanceOptions",
                        "rds:describeDBSubnetGroups",
                        "rds:describeDBClusterSnapshots",
                        "rds:describeDBClusters",
                        "rds:describeDBParameterGroups",
                        "rds:describeDBClusterParameterGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "rds:DeleteDBSnapshot",
                        "rds:DeleteDBClusterSnapshot"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "backup.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dynamodb:ListBackups",
                        "dynamodb:ListTables"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dynamodb:DeleteBackup"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "backup.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "elasticfilesystem:DescribeFilesystems"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:elasticfilesystem:*:*:file-system/*"
                },
                {
                    "Action": [
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeVolumes",
                        "ec2:describeAvailabilityZones",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeImages",
                        "ec2:DescribeSubnets",
                        "ec2:DescribePlacementGroups",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceTypes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:DeleteSnapshot",
                        "ec2:DeregisterImage"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "backup.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "tag:GetTagKeys",
                        "tag:GetTagValues",
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "storagegateway:DescribeCachediSCSIVolumes",
                        "storagegateway:DescribeStorediSCSIVolumes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:gateway/*/volume/*"
                },
                {
                    "Action": [
                        "storagegateway:ListGateways"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:*"
                },
                {
                    "Action": [
                        "storagegateway:DescribeGatewayInformation",
                        "storagegateway:ListVolumes",
                        "storagegateway:ListLocalDisks"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:gateway/*"
                },
                {
                    "Action": [
                        "iam:ListRoles",
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": "backup.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/*AwsBackup*",
                        "arn:aws:iam::*:role/*AWSBackup*"
                    ]
                },
                {
                    "Action": "organizations:DescribeOrganization",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:ListKeys",
                        "kms:DescribeKey",
                        "kms:GenerateDataKey",
                        "kms:ListAliases"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:CreateGrant"
                    ],
                    "Condition": {
                        "Bool": {
                            "kms:GrantIsForAWSResource": true
                        },
                        "ForAnyValue:StringEquals": {
                            "kms:EncryptionContextKeys": "aws:backup:backup-vault"
                        },
                        "StringLike": {
                            "kms:ViaService": "backup.*.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ssm:CancelCommand",
                        "ssm:GetCommandInvocation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ssm:SendCommand",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": "fsx:DescribeFileSystems",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "fsx:DescribeBackups",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "fsx:DeleteBackup",
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "backup.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:backup/*"
                },
                {
                    "Action": "ds:DescribeDirectories",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4LL52EIPJX",
        "PolicyName": "AWSBackupFullAccess",
        "UpdateDate": "2020-11-09T16:49:24+00:00",
        "VersionId": "v6"
    },
    "AWSBackupOperatorAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSBackupOperatorAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-18T22:23:17+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "backup:Get*",
                        "backup:List*",
                        "backup:Describe*",
                        "backup:CreateBackupSelection",
                        "backup:DeleteBackupSelection",
                        "backup:GetRecoveryPointRestoreMetadata",
                        "backup:StartBackupJob",
                        "backup:StartRestoreJob",
                        "backup:StartCopyJob"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "rds:DescribeDBSnapshots",
                        "rds:ListTagsForResource",
                        "rds:DescribeDBInstances",
                        "rds:describeDBSnapshots",
                        "rds:describeDBEngineVersions",
                        "rds:describeOptionGroups",
                        "rds:describeOrderableDBInstanceOptions",
                        "rds:describeDBSubnetGroups",
                        "rds:DescribeDBClusterSnapshots",
                        "rds:DescribeDBClusters",
                        "rds:DescribeDBParameterGroups",
                        "rds:DescribeDBClusterParameterGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dynamodb:ListBackups",
                        "dynamodb:ListTables"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "elasticfilesystem:DescribeFilesystems"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:elasticfilesystem:*:*:file-system/*"
                },
                {
                    "Action": [
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeVolumes",
                        "ec2:describeAvailabilityZones",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeImages",
                        "ec2:DescribeSubnets",
                        "ec2:DescribePlacementGroups",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceTypes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "tag:GetTagKeys",
                        "tag:GetTagValues",
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "storagegateway:DescribeCachediSCSIVolumes",
                        "storagegateway:DescribeStorediSCSIVolumes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:gateway/*/volume/*"
                },
                {
                    "Action": [
                        "storagegateway:ListGateways"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:*"
                },
                {
                    "Action": [
                        "storagegateway:DescribeGatewayInformation",
                        "storagegateway:ListVolumes",
                        "storagegateway:ListLocalDisks"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:gateway/*"
                },
                {
                    "Action": [
                        "iam:ListRoles",
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": "backup.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/*AwsBackup*",
                        "arn:aws:iam::*:role/*AWSBackup*"
                    ]
                },
                {
                    "Action": "organizations:DescribeOrganization",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ssm:CancelCommand",
                        "ssm:GetCommandInvocation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ssm:SendCommand",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": "fsx:DescribeBackups",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:backup/*"
                },
                {
                    "Action": "fsx:DescribeFileSystems",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:file-system/*"
                },
                {
                    "Action": "ds:DescribeDirectories",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KHXVYMY4O",
        "PolicyName": "AWSBackupOperatorAccess",
        "UpdateDate": "2020-11-09T16:43:44+00:00",
        "VersionId": "v6"
    },
    "AWSBackupOrganizationAdminAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSBackupOrganizationAdminAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-24T16:23:14+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:DisableAWSServiceAccess",
                        "organizations:EnableAWSServiceAccess"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "organizations:ServicePrincipal": [
                                "backup.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "organizations:AttachPolicy",
                        "organizations:ListPoliciesForTarget",
                        "organizations:ListTargetsForPolicy",
                        "organizations:DetachPolicy",
                        "organizations:DisablePolicyType",
                        "organizations:DescribePolicy",
                        "organizations:DescribeEffectivePolicy",
                        "organizations:ListPolicies",
                        "organizations:EnablePolicyType",
                        "organizations:CreatePolicy",
                        "organizations:UpdatePolicy",
                        "organizations:DeletePolicy"
                    ],
                    "Condition": {
                        "StringLikeIfExists": {
                            "organizations:PolicyType": [
                                "BACKUP_POLICY"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "organizations:ListRoots",
                        "organizations:ListParents",
                        "organizations:ListAWSServiceAccessForOrganization",
                        "organizations:ListAccountsForParent",
                        "organizations:ListAccounts",
                        "organizations:DescribeOrganization",
                        "organizations:ListOrganizationalUnitsForParent",
                        "organizations:ListChildren",
                        "organizations:DescribeAccount",
                        "organizations:DescribeOrganizationalUnit"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4E5BC3XLFS",
        "PolicyName": "AWSBackupOrganizationAdminAccess",
        "UpdateDate": "2020-11-24T22:09:43+00:00",
        "VersionId": "v2"
    },
    "AWSBackupServiceLinkedRolePolicyForBackup": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSBackupServiceLinkedRolePolicyForBackup",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-02T23:08:40+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "elasticfilesystem:Backup",
                        "elasticfilesystem:DescribeTags"
                    ],
                    "Condition": {
                        "StringLike": {
                            "aws:ResourceTag/aws:elasticfilesystem:default-backup": "enabled"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:elasticfilesystem:*:*:file-system/*"
                },
                {
                    "Action": [
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:CreateTags",
                    "Condition": {
                        "StringEquals": {
                            "ec2:CreateAction": "CopySnapshot"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::snapshot/*"
                },
                {
                    "Action": "ec2:CreateTags",
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": [
                                "AWSBackupManagedResource"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*::image/*",
                        "arn:aws:ec2:*::snapshot/*"
                    ]
                },
                {
                    "Action": "ec2:CreateTags",
                    "Condition": {
                        "Null": {
                            "ec2:ResourceTag/AWSBackupManagedResource": "false"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*::image/*",
                        "arn:aws:ec2:*::snapshot/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeImages",
                        "rds:DescribeDBSnapshots",
                        "rds:DescribeDBClusterSnapshots"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:CopySnapshot",
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::snapshot/*"
                },
                {
                    "Action": "ec2:CopyImage",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:DeregisterImage",
                        "ec2:DeleteSnapshot"
                    ],
                    "Condition": {
                        "Null": {
                            "ec2:ResourceTag/AWSBackupManagedResource": "false"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "rds:AddTagsToResource",
                        "rds:CopyDBSnapshot",
                        "rds:DeleteDBSnapshot"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:rds:*:*:snapshot:awsbackup:*"
                },
                {
                    "Action": [
                        "rds:AddTagsToResource",
                        "rds:CopyDBClusterSnapshot",
                        "rds:DeleteDBClusterSnapshot"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:rds:*:*:cluster-snapshot:awsbackup:*"
                },
                {
                    "Action": "kms:DescribeKey",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:ListGrants",
                        "kms:ReEncryptFrom",
                        "kms:GenerateDataKeyWithoutPlaintext"
                    ],
                    "Condition": {
                        "StringLike": {
                            "kms:ViaService": [
                                "ec2.*.amazonaws.com",
                                "rds.*.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "kms:CreateGrant",
                    "Condition": {
                        "Bool": {
                            "kms:GrantIsForAWSResource": "true"
                        },
                        "StringLike": {
                            "kms:ViaService": [
                                "ec2.*.amazonaws.com",
                                "rds.*.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4ONJBD4ZY2",
        "PolicyName": "AWSBackupServiceLinkedRolePolicyForBackup",
        "UpdateDate": "2020-11-10T18:37:51+00:00",
        "VersionId": "v2"
    },
    "AWSBackupServiceLinkedRolePolicyForBackupTest": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSBackupServiceLinkedRolePolicyForBackupTest",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-12T17:37:29+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "elasticfilesystem:Backup",
                        "elasticfilesystem:DescribeTags"
                    ],
                    "Condition": {
                        "StringLike": {
                            "aws:ResourceTag/aws:elasticfilesystem:default-backup": "enabled"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:elasticfilesystem:*:*:file-system/*"
                },
                {
                    "Action": [
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KMHRZD5LV",
        "PolicyName": "AWSBackupServiceLinkedRolePolicyForBackupTest",
        "UpdateDate": "2020-05-12T17:37:29+00:00",
        "VersionId": "v1"
    },
    "AWSBackupServiceRolePolicyForBackup": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSBackupServiceRolePolicyForBackup",
        "AttachmentCount": 0,
        "CreateDate": "2019-01-10T21:01:28+00:00",
        "DefaultVersionId": "v8",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dynamodb:DescribeTable",
                        "dynamodb:CreateBackup"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:dynamodb:*:*:table/*"
                },
                {
                    "Action": [
                        "dynamodb:DescribeBackup",
                        "dynamodb:DeleteBackup"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:dynamodb:*:*:table/*/backup/*"
                },
                {
                    "Action": [
                        "rds:AddTagsToResource",
                        "rds:ListTagsForResource",
                        "rds:DescribeDBSnapshots",
                        "rds:CreateDBSnapshot",
                        "rds:CopyDBSnapshot",
                        "rds:DescribeDBInstances",
                        "rds:CreateDBClusterSnapshot",
                        "rds:DescribeDBClusters",
                        "rds:DescribeDBClusterSnapshots",
                        "rds:CopyDBClusterSnapshot"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "rds:DeleteDBSnapshot",
                        "rds:ModifyDBSnapshotAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:rds:*:*:snapshot:awsbackup:*"
                    ]
                },
                {
                    "Action": [
                        "rds:DeleteDBClusterSnapshot",
                        "rds:ModifyDBClusterSnapshotAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:rds:*:*:cluster-snapshot:awsbackup:*"
                    ]
                },
                {
                    "Action": [
                        "storagegateway:CreateSnapshot",
                        "storagegateway:ListTagsForResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:gateway/*/volume/*"
                },
                {
                    "Action": [
                        "ec2:CopySnapshot"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::snapshot/*"
                },
                {
                    "Action": [
                        "ec2:CopyImage"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteSnapshot"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::snapshot/*"
                },
                {
                    "Action": [
                        "ec2:CreateImage",
                        "ec2:DeregisterImage"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:image/*"
                },
                {
                    "Action": [
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeTags",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceAttribute",
                        "ec2:DescribeInstanceCreditSpecifications",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeElasticGpus",
                        "ec2:DescribeSpotInstanceRequests"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:ModifySnapshotAttribute",
                        "ec2:ModifyImageAttribute"
                    ],
                    "Condition": {
                        "Null": {
                            "aws:ResourceTag/aws:backup:source-resource": "false"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "backup:DescribeBackupVault",
                        "backup:CopyIntoBackupVault"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:backup:*:*:backup-vault:*"
                },
                {
                    "Action": [
                        "backup:CopyFromBackupVault"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "elasticfilesystem:Backup",
                        "elasticfilesystem:DescribeTags"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:elasticfilesystem:*:*:file-system/*"
                },
                {
                    "Action": [
                        "ec2:CreateSnapshot",
                        "ec2:DeleteSnapshot",
                        "ec2:DescribeVolumes",
                        "ec2:DescribeSnapshots"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*::snapshot/*",
                        "arn:aws:ec2:*:*:volume/*"
                    ]
                },
                {
                    "Action": "kms:DescribeKey",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "kms:CreateGrant",
                    "Condition": {
                        "Bool": {
                            "kms:GrantIsForAWSResource": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:GenerateDataKeyWithoutPlaintext"
                    ],
                    "Condition": {
                        "StringLike": {
                            "kms:ViaService": [
                                "ec2.*.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:kms:*:*:key/*"
                },
                {
                    "Action": [
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ssm:CancelCommand",
                        "ssm:GetCommandInvocation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ssm:SendCommand",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/AWSEC2-CreateVssSnapshot",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": "fsx:DescribeBackups",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:backup/*"
                },
                {
                    "Action": "fsx:CreateBackup",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:fsx:*:*:file-system/*",
                        "arn:aws:fsx:*:*:backup/*"
                    ]
                },
                {
                    "Action": "fsx:DescribeFileSystems",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:file-system/*"
                },
                {
                    "Action": "fsx:ListTagsForResource",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:file-system/*"
                },
                {
                    "Action": "fsx:DeleteBackup",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:backup/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIOOYZSLZZXWFJJ5N2",
        "PolicyName": "AWSBackupServiceRolePolicyForBackup",
        "UpdateDate": "2020-11-18T23:16:27+00:00",
        "VersionId": "v8"
    },
    "AWSBackupServiceRolePolicyForRestores": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSBackupServiceRolePolicyForRestores",
        "AttachmentCount": 0,
        "CreateDate": "2019-01-12T00:23:54+00:00",
        "DefaultVersionId": "v7",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dynamodb:Scan",
                        "dynamodb:Query",
                        "dynamodb:UpdateItem",
                        "dynamodb:PutItem",
                        "dynamodb:GetItem",
                        "dynamodb:DeleteItem",
                        "dynamodb:BatchWriteItem",
                        "dynamodb:DescribeTable"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:dynamodb:*:*:table/*"
                },
                {
                    "Action": [
                        "dynamodb:RestoreTableFromBackup"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:dynamodb:*:*:table/*/backup/*"
                },
                {
                    "Action": [
                        "ec2:CreateVolume",
                        "ec2:DeleteVolume"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*::snapshot/*",
                        "arn:aws:ec2:*:*:volume/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeVolumes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "storagegateway:DeleteVolume",
                        "storagegateway:DescribeCachediSCSIVolumes",
                        "storagegateway:DescribeStorediSCSIVolumes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:gateway/*/volume/*"
                },
                {
                    "Action": [
                        "storagegateway:DescribeGatewayInformation",
                        "storagegateway:CreateStorediSCSIVolume",
                        "storagegateway:CreateCachediSCSIVolume"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:gateway/*"
                },
                {
                    "Action": [
                        "storagegateway:ListVolumes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:storagegateway:*:*:*"
                },
                {
                    "Action": [
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBSnapshots",
                        "rds:ListTagsForResource",
                        "rds:RestoreDBInstanceFromDBSnapshot",
                        "rds:DeleteDBInstance",
                        "rds:AddTagsToResource",
                        "rds:DescribeDBClusters",
                        "rds:RestoreDBClusterFromSnapshot",
                        "rds:DeleteDBCluster"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "elasticfilesystem:Restore",
                        "elasticfilesystem:CreateFilesystem",
                        "elasticfilesystem:DescribeFilesystems",
                        "elasticfilesystem:DeleteFilesystem"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:elasticfilesystem:*:*:file-system/*"
                },
                {
                    "Action": "kms:DescribeKey",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:Decrypt",
                        "kms:Encrypt",
                        "kms:GenerateDataKey",
                        "kms:ReEncryptTo",
                        "kms:ReEncryptFrom"
                    ],
                    "Condition": {
                        "StringLike": {
                            "kms:ViaService": [
                                "dynamodb.*.amazonaws.com",
                                "ec2.*.amazonaws.com",
                                "elasticfilesystem.*.amazonaws.com",
                                "rds.*.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "kms:CreateGrant",
                    "Condition": {
                        "Bool": {
                            "kms:GrantIsForAWSResource": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": [
                        "fsx:CreateFileSystemFromBackup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:fsx:*:*:file-system/*",
                        "arn:aws:fsx:*:*:backup/*"
                    ]
                },
                {
                    "Action": "fsx:DescribeFileSystems",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:file-system/*"
                },
                {
                    "Action": "fsx:DescribeBackups",
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:backup/*"
                },
                {
                    "Action": [
                        "fsx:DeleteFileSystem",
                        "fsx:UntagResource"
                    ],
                    "Condition": {
                        "Null": {
                            "aws:ResourceTag/aws:backup:source-resource": "false"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:file-system/*"
                },
                {
                    "Action": "ds:DescribeDirectories",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJZCCL6F2WPVOUXZKI",
        "PolicyName": "AWSBackupServiceRolePolicyForRestores",
        "UpdateDate": "2020-11-09T16:52:12+00:00",
        "VersionId": "v7"
    },
    "AWSBatchFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSBatchFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-06T19:35:42+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "batch:*",
                        "cloudwatch:GetMetricStatistics",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeImages",
                        "ec2:DescribeLaunchTemplates",
                        "ec2:DescribeLaunchTemplateVersions",
                        "ecs:DescribeClusters",
                        "ecs:Describe*",
                        "ecs:List*",
                        "logs:Describe*",
                        "logs:Get*",
                        "logs:TestMetricFilter",
                        "logs:FilterLogEvents",
                        "iam:ListInstanceProfiles",
                        "iam:ListRoles"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSBatchServiceRole",
                        "arn:aws:iam::*:role/service-role/AWSBatchServiceRole",
                        "arn:aws:iam::*:role/ecsInstanceRole",
                        "arn:aws:iam::*:instance-profile/ecsInstanceRole",
                        "arn:aws:iam::*:role/iaws-ec2-spot-fleet-role",
                        "arn:aws:iam::*:role/aws-ec2-spot-fleet-role",
                        "arn:aws:iam::*:role/AWSBatchJobRole*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ7K2KIWB3HZVK3CUO",
        "PolicyName": "AWSBatchFullAccess",
        "UpdateDate": "2018-11-05T21:09:23+00:00",
        "VersionId": "v5"
    },
    "AWSBatchServiceEventTargetRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSBatchServiceEventTargetRole",
        "AttachmentCount": 0,
        "CreateDate": "2018-02-28T22:31:13+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "batch:SubmitJob"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAICVHHZ6XHNMA6VE3Q",
        "PolicyName": "AWSBatchServiceEventTargetRole",
        "UpdateDate": "2018-02-28T22:31:13+00:00",
        "VersionId": "v1"
    },
    "AWSBatchServiceRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSBatchServiceRole",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-06T19:36:24+00:00",
        "DefaultVersionId": "v11",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceAttribute",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeImages",
                        "ec2:DescribeImageAttribute",
                        "ec2:DescribeSpotInstanceRequests",
                        "ec2:DescribeSpotFleetInstances",
                        "ec2:DescribeSpotFleetRequests",
                        "ec2:DescribeSpotPriceHistory",
                        "ec2:DescribeVpcClassicLink",
                        "ec2:DescribeLaunchTemplateVersions",
                        "ec2:CreateLaunchTemplate",
                        "ec2:DeleteLaunchTemplate",
                        "ec2:RequestSpotFleet",
                        "ec2:CancelSpotFleetRequests",
                        "ec2:ModifySpotFleetRequest",
                        "ec2:TerminateInstances",
                        "ec2:RunInstances",
                        "autoscaling:DescribeAccountLimits",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeLaunchConfigurations",
                        "autoscaling:DescribeAutoScalingInstances",
                        "autoscaling:CreateLaunchConfiguration",
                        "autoscaling:CreateAutoScalingGroup",
                        "autoscaling:UpdateAutoScalingGroup",
                        "autoscaling:SetDesiredCapacity",
                        "autoscaling:DeleteLaunchConfiguration",
                        "autoscaling:DeleteAutoScalingGroup",
                        "autoscaling:CreateOrUpdateTags",
                        "autoscaling:SuspendProcesses",
                        "autoscaling:PutNotificationConfiguration",
                        "autoscaling:TerminateInstanceInAutoScalingGroup",
                        "ecs:DescribeClusters",
                        "ecs:DescribeContainerInstances",
                        "ecs:DescribeTaskDefinition",
                        "ecs:DescribeTasks",
                        "ecs:ListAccountSettings",
                        "ecs:ListClusters",
                        "ecs:ListContainerInstances",
                        "ecs:ListTaskDefinitionFamilies",
                        "ecs:ListTaskDefinitions",
                        "ecs:ListTasks",
                        "ecs:CreateCluster",
                        "ecs:DeleteCluster",
                        "ecs:RegisterTaskDefinition",
                        "ecs:DeregisterTaskDefinition",
                        "ecs:RunTask",
                        "ecs:StartTask",
                        "ecs:StopTask",
                        "ecs:UpdateContainerAgent",
                        "ecs:DeregisterContainerInstance",
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                        "logs:DescribeLogGroups",
                        "iam:GetInstanceProfile",
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ecs:TagResource",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ecs:*:*:task/*_Batch_*"
                    ]
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ec2.amazonaws.com.cn",
                                "ecs-tasks.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "spot.amazonaws.com",
                                "spotfleet.amazonaws.com",
                                "autoscaling.amazonaws.com",
                                "ecs.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:CreateAction": "RunInstances"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIUETIXPCKASQJURFE",
        "PolicyName": "AWSBatchServiceRole",
        "UpdateDate": "2020-11-23T18:19:27+00:00",
        "VersionId": "v11"
    },
    "AWSBillingReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSBillingReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-27T20:08:51+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-portal:ViewBilling"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4LJ3OSZ5SX",
        "PolicyName": "AWSBillingReadOnlyAccess",
        "UpdateDate": "2020-08-27T20:08:51+00:00",
        "VersionId": "v1"
    },
    "AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM": {
        "Arn": "arn:aws:iam::aws:policy/AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM",
        "AttachmentCount": 0,
        "CreateDate": "2020-10-15T17:20:48+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeInstanceStatus",
                        "ec2:StartInstances",
                        "ec2:StopInstances",
                        "rds:DescribeDBInstances",
                        "rds:StartDBInstance",
                        "rds:StopDBInstance"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "ssm.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ssm:StartAutomationExecution"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KIUIYBT2X",
        "PolicyName": "AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM",
        "UpdateDate": "2020-10-15T17:20:48+00:00",
        "VersionId": "v1"
    },
    "AWSBudgetsActionsWithAWSResourceControlAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSBudgetsActionsWithAWSResourceControlAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-10-15T17:19:12+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "budgets:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-portal:ViewBilling"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "budgets.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-portal:ModifyBilling",
                        "ec2:DescribeInstances",
                        "iam:ListGroups",
                        "iam:ListPolicies",
                        "iam:ListRoles",
                        "iam:ListUsers",
                        "organizations:ListAccounts",
                        "organizations:ListOrganizationalUnitsForParent",
                        "organizations:ListPolicies",
                        "organizations:ListRoots",
                        "rds:DescribeDBInstances",
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4AHTKKGHHS",
        "PolicyName": "AWSBudgetsActionsWithAWSResourceControlAccess",
        "UpdateDate": "2020-10-15T17:19:12+00:00",
        "VersionId": "v1"
    },
    "AWSBudgetsReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSBudgetsReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-10-15T17:18:28+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-portal:ViewBilling",
                        "budgets:ViewBudget",
                        "budgets:Describe*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4EZCFS6BHW",
        "PolicyName": "AWSBudgetsReadOnlyAccess",
        "UpdateDate": "2020-10-15T17:18:28+00:00",
        "VersionId": "v1"
    },
    "AWSCertificateManagerFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCertificateManagerFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-01-21T17:02:36+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "acm.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/acm.amazonaws.com/AWSServiceRoleForCertificateManager*"
                },
                {
                    "Action": [
                        "iam:DeleteServiceLinkedRole",
                        "iam:GetServiceLinkedRoleDeletionStatus",
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/acm.amazonaws.com/AWSServiceRoleForCertificateManager*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJYCHABBP6VQIVBCBQ",
        "PolicyName": "AWSCertificateManagerFullAccess",
        "UpdateDate": "2020-08-17T22:18:28+00:00",
        "VersionId": "v2"
    },
    "AWSCertificateManagerPrivateCAAuditor": {
        "Arn": "arn:aws:iam::aws:policy/AWSCertificateManagerPrivateCAAuditor",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-23T16:51:08+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm-pca:CreateCertificateAuthorityAuditReport",
                        "acm-pca:DescribeCertificateAuthority",
                        "acm-pca:DescribeCertificateAuthorityAuditReport",
                        "acm-pca:GetCertificateAuthorityCsr",
                        "acm-pca:GetCertificateAuthorityCertificate",
                        "acm-pca:GetCertificate",
                        "acm-pca:GetPolicy",
                        "acm-pca:ListPermissions",
                        "acm-pca:ListTags"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:acm-pca:*:*:certificate-authority/*"
                },
                {
                    "Action": [
                        "acm-pca:ListCertificateAuthorities"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJW77VE4UEBJ4PEXEY",
        "PolicyName": "AWSCertificateManagerPrivateCAAuditor",
        "UpdateDate": "2020-08-17T22:54:12+00:00",
        "VersionId": "v4"
    },
    "AWSCertificateManagerPrivateCAFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCertificateManagerPrivateCAFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-23T16:54:50+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm-pca:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIRTQUC55CREAWFLBG",
        "PolicyName": "AWSCertificateManagerPrivateCAFullAccess",
        "UpdateDate": "2018-10-23T16:54:50+00:00",
        "VersionId": "v1"
    },
    "AWSCertificateManagerPrivateCAPrivilegedUser": {
        "Arn": "arn:aws:iam::aws:policy/AWSCertificateManagerPrivateCAPrivilegedUser",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-20T17:43:13+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm-pca:IssueCertificate"
                    ],
                    "Condition": {
                        "StringLike": {
                            "acm-pca:TemplateArn": [
                                "arn:aws:acm-pca:::template/*CACertificate*/V*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:acm-pca:*:*:certificate-authority/*"
                },
                {
                    "Action": [
                        "acm-pca:IssueCertificate"
                    ],
                    "Condition": {
                        "StringNotLike": {
                            "acm-pca:TemplateArn": [
                                "arn:aws:acm-pca:::template/*CACertificate*/V*"
                            ]
                        }
                    },
                    "Effect": "Deny",
                    "Resource": "arn:aws:acm-pca:*:*:certificate-authority/*"
                },
                {
                    "Action": [
                        "acm-pca:RevokeCertificate",
                        "acm-pca:GetCertificate",
                        "acm-pca:ListPermissions"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:acm-pca:*:*:certificate-authority/*"
                },
                {
                    "Action": [
                        "acm-pca:ListCertificateAuthorities"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4EQ6CWU5X5",
        "PolicyName": "AWSCertificateManagerPrivateCAPrivilegedUser",
        "UpdateDate": "2019-06-20T17:43:13+00:00",
        "VersionId": "v1"
    },
    "AWSCertificateManagerPrivateCAReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSCertificateManagerPrivateCAReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-23T16:57:04+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": {
                "Action": [
                    "acm-pca:DescribeCertificateAuthority",
                    "acm-pca:DescribeCertificateAuthorityAuditReport",
                    "acm-pca:ListCertificateAuthorities",
                    "acm-pca:GetCertificateAuthorityCsr",
                    "acm-pca:GetCertificateAuthorityCertificate",
                    "acm-pca:GetCertificate",
                    "acm-pca:GetPolicy",
                    "acm-pca:ListPermissions",
                    "acm-pca:ListTags"
                ],
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQAQT3WIXOXY7TD4A",
        "PolicyName": "AWSCertificateManagerPrivateCAReadOnly",
        "UpdateDate": "2020-08-17T22:54:22+00:00",
        "VersionId": "v3"
    },
    "AWSCertificateManagerPrivateCAUser": {
        "Arn": "arn:aws:iam::aws:policy/AWSCertificateManagerPrivateCAUser",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-23T16:53:33+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm-pca:IssueCertificate"
                    ],
                    "Condition": {
                        "StringLike": {
                            "acm-pca:TemplateArn": [
                                "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:acm-pca:*:*:certificate-authority/*"
                },
                {
                    "Action": [
                        "acm-pca:IssueCertificate"
                    ],
                    "Condition": {
                        "StringNotLike": {
                            "acm-pca:TemplateArn": [
                                "arn:aws:acm-pca:::template/EndEntityCertificate/V*"
                            ]
                        }
                    },
                    "Effect": "Deny",
                    "Resource": "arn:aws:acm-pca:*:*:certificate-authority/*"
                },
                {
                    "Action": [
                        "acm-pca:RevokeCertificate",
                        "acm-pca:GetCertificate",
                        "acm-pca:ListPermissions"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:acm-pca:*:*:certificate-authority/*"
                },
                {
                    "Action": [
                        "acm-pca:ListCertificateAuthorities"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJBXCSJJULLMRWSNII",
        "PolicyName": "AWSCertificateManagerPrivateCAUser",
        "UpdateDate": "2019-06-20T17:42:37+00:00",
        "VersionId": "v4"
    },
    "AWSCertificateManagerReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSCertificateManagerReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2016-01-21T17:07:33+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": {
                "Action": [
                    "acm:DescribeCertificate",
                    "acm:ListCertificates",
                    "acm:GetCertificate",
                    "acm:ListTagsForCertificate"
                ],
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI4GSWX6S4MESJ3EWC",
        "PolicyName": "AWSCertificateManagerReadOnly",
        "UpdateDate": "2016-04-21T15:08:16+00:00",
        "VersionId": "v2"
    },
    "AWSChatbotServiceLinkedRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSChatbotServiceLinkedRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-18T16:39:50+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sns:ListSubscriptionsByTopic",
                        "sns:ListTopics",
                        "sns:Unsubscribe",
                        "sns:Subscribe",
                        "sns:ListSubscriptions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:PutLogEvents",
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:CreateLogGroup",
                        "logs:DescribeLogGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/chatbot/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4ID4WRYKST",
        "PolicyName": "AWSChatbotServiceLinkedRolePolicy",
        "UpdateDate": "2019-11-18T16:39:50+00:00",
        "VersionId": "v1"
    },
    "AWSCloud9Administrator": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloud9Administrator",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-30T16:17:28+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloud9:*",
                        "iam:GetUser",
                        "iam:ListUsers",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSubnets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "cloud9.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ssm:StartSession",
                    "Condition": {
                        "StringEquals": {
                            "aws:CalledViaFirst": "cloud9.amazonaws.com"
                        },
                        "StringLike": {
                            "ssm:resourceTag/aws:cloud9:environment": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": [
                        "ssm:StartSession"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIQ4KWP455WDTCBGWK",
        "PolicyName": "AWSCloud9Administrator",
        "UpdateDate": "2020-07-29T06:28:54+00:00",
        "VersionId": "v2"
    },
    "AWSCloud9EnvironmentMember": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloud9EnvironmentMember",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-30T16:18:28+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloud9:GetUserSettings",
                        "cloud9:UpdateUserSettings",
                        "iam:GetUser",
                        "iam:ListUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloud9:DescribeEnvironmentMemberships"
                    ],
                    "Condition": {
                        "Null": {
                            "cloud9:EnvironmentId": "true",
                            "cloud9:UserArn": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "ssm:StartSession",
                    "Condition": {
                        "StringEquals": {
                            "aws:CalledViaFirst": "cloud9.amazonaws.com"
                        },
                        "StringLike": {
                            "ssm:resourceTag/aws:cloud9:environment": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": [
                        "ssm:StartSession"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI54ULAIPVT5HFTYGK",
        "PolicyName": "AWSCloud9EnvironmentMember",
        "UpdateDate": "2020-07-29T06:29:08+00:00",
        "VersionId": "v2"
    },
    "AWSCloud9SSMInstanceProfile": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloud9SSMInstanceProfile",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-14T11:40:49+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ssmmessages:CreateControlChannel",
                        "ssmmessages:CreateDataChannel",
                        "ssmmessages:OpenControlChannel",
                        "ssmmessages:OpenDataChannel",
                        "ssm:UpdateInstanceInformation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IQOSNAKW6",
        "PolicyName": "AWSCloud9SSMInstanceProfile",
        "UpdateDate": "2020-05-14T11:40:49+00:00",
        "VersionId": "v1"
    },
    "AWSCloud9ServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSCloud9ServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-30T13:44:08+00:00",
        "DefaultVersionId": "v7",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:RunInstances",
                        "ec2:CreateSecurityGroup",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceStatus",
                        "cloudformation:CreateStack",
                        "cloudformation:DescribeStacks",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStackResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:TerminateInstances",
                        "ec2:DeleteSecurityGroup",
                        "ec2:AuthorizeSecurityGroupIngress"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloudformation:DeleteStack"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/aws-cloud9-*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringLike": {
                            "aws:RequestTag/Name": "aws-cloud9-*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*",
                        "arn:aws:ec2:*:*:security-group/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:StartInstances",
                        "ec2:StopInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-name": "aws-cloud9-*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:ListInstanceProfiles",
                        "iam:GetInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:instance-profile/cloud9/*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": "ec2.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/service-role/AWSCloud9SSMAccessRole"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJFXGCBXQIZATFZ4YG",
        "PolicyName": "AWSCloud9ServiceRolePolicy",
        "UpdateDate": "2020-10-06T12:43:49+00:00",
        "VersionId": "v7"
    },
    "AWSCloud9User": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloud9User",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-30T16:16:17+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloud9:ValidateEnvironmentName",
                        "cloud9:UpdateUserSettings",
                        "cloud9:GetUserSettings",
                        "iam:GetUser",
                        "iam:ListUsers",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSubnets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloud9:CreateEnvironmentEC2",
                        "cloud9:CreateEnvironmentSSH"
                    ],
                    "Condition": {
                        "Null": {
                            "cloud9:OwnerArn": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloud9:GetUserPublicKey"
                    ],
                    "Condition": {
                        "Null": {
                            "cloud9:UserArn": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloud9:DescribeEnvironmentMemberships"
                    ],
                    "Condition": {
                        "Null": {
                            "cloud9:EnvironmentId": "true",
                            "cloud9:UserArn": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "cloud9.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ssm:StartSession",
                    "Condition": {
                        "StringEquals": {
                            "aws:CalledViaFirst": "cloud9.amazonaws.com"
                        },
                        "StringLike": {
                            "ssm:resourceTag/aws:cloud9:environment": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": [
                        "ssm:StartSession"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJPFGFWQF67QVARP6U",
        "PolicyName": "AWSCloud9User",
        "UpdateDate": "2020-07-29T06:26:43+00:00",
        "VersionId": "v4"
    },
    "AWSCloudFormationFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudFormationFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-07-26T21:50:35+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4CRR3ZS723",
        "PolicyName": "AWSCloudFormationFullAccess",
        "UpdateDate": "2019-07-26T21:50:35+00:00",
        "VersionId": "v1"
    },
    "AWSCloudFormationReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudFormationReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:39:49+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:Describe*",
                        "cloudformation:EstimateTemplateCost",
                        "cloudformation:Get*",
                        "cloudformation:List*",
                        "cloudformation:ValidateTemplate",
                        "cloudformation:Detect*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJWVBEE4I2POWLODLW",
        "PolicyName": "AWSCloudFormationReadOnlyAccess",
        "UpdateDate": "2019-11-13T17:40:07+00:00",
        "VersionId": "v4"
    },
    "AWSCloudFrontLogger": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSCloudFrontLogger",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-12T20:15:23+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/cloudfront/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIOI7RPKLCNINBTRP4",
        "PolicyName": "AWSCloudFrontLogger",
        "UpdateDate": "2019-11-22T19:33:51+00:00",
        "VersionId": "v2"
    },
    "AWSCloudHSMFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudHSMFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:39:51+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "cloudhsm:*",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIMBQYQZM7F63DA2UU",
        "PolicyName": "AWSCloudHSMFullAccess",
        "UpdateDate": "2015-02-06T18:39:51+00:00",
        "VersionId": "v1"
    },
    "AWSCloudHSMReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudHSMReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:39:52+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudhsm:Get*",
                        "cloudhsm:List*",
                        "cloudhsm:Describe*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAISVCBSY7YDBOT67KE",
        "PolicyName": "AWSCloudHSMReadOnlyAccess",
        "UpdateDate": "2015-02-06T18:39:52+00:00",
        "VersionId": "v1"
    },
    "AWSCloudHSMRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSCloudHSMRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:23+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CreateNetworkInterface",
                        "ec2:CreateTags",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeNetworkInterfaceAttribute",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DetachNetworkInterface"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI7QIUU4GC66SF26WE",
        "PolicyName": "AWSCloudHSMRole",
        "UpdateDate": "2015-02-06T18:41:23+00:00",
        "VersionId": "v1"
    },
    "AWSCloudMapDiscoverInstanceAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudMapDiscoverInstanceAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-29T00:02:42+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "servicediscovery:DiscoverInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIPRD7PYYQVYPDME4K",
        "PolicyName": "AWSCloudMapDiscoverInstanceAccess",
        "UpdateDate": "2018-11-29T00:02:42+00:00",
        "VersionId": "v1"
    },
    "AWSCloudMapFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudMapFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-28T23:57:31+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "route53:GetHostedZone",
                        "route53:ListHostedZonesByName",
                        "route53:CreateHostedZone",
                        "route53:DeleteHostedZone",
                        "route53:ChangeResourceRecordSets",
                        "route53:CreateHealthCheck",
                        "route53:GetHealthCheck",
                        "route53:DeleteHealthCheck",
                        "route53:UpdateHealthCheck",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeRegions",
                        "ec2:DescribeInstances",
                        "servicediscovery:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIZPIMAQZJS3WUXUJM",
        "PolicyName": "AWSCloudMapFullAccess",
        "UpdateDate": "2020-07-29T19:15:35+00:00",
        "VersionId": "v2"
    },
    "AWSCloudMapReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudMapReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-28T23:45:26+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "servicediscovery:Get*",
                        "servicediscovery:List*",
                        "servicediscovery:DiscoverInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIOHISHKLCJTVQQL5E",
        "PolicyName": "AWSCloudMapReadOnlyAccess",
        "UpdateDate": "2018-11-28T23:45:26+00:00",
        "VersionId": "v1"
    },
    "AWSCloudMapRegisterInstanceAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudMapRegisterInstanceAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-29T00:04:57+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "route53:GetHostedZone",
                        "route53:ListHostedZonesByName",
                        "route53:ChangeResourceRecordSets",
                        "route53:CreateHealthCheck",
                        "route53:GetHealthCheck",
                        "route53:DeleteHealthCheck",
                        "route53:UpdateHealthCheck",
                        "servicediscovery:Get*",
                        "servicediscovery:List*",
                        "servicediscovery:RegisterInstance",
                        "servicediscovery:DeregisterInstance",
                        "servicediscovery:DiscoverInstances",
                        "ec2:DescribeInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI4P5Z5HXVWJ75WQBC",
        "PolicyName": "AWSCloudMapRegisterInstanceAccess",
        "UpdateDate": "2020-07-29T17:57:24+00:00",
        "VersionId": "v2"
    },
    "AWSCloudShellFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudShellFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T18:07:44+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudshell:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HEDUXFSA3",
        "PolicyName": "AWSCloudShellFullAccess",
        "UpdateDate": "2020-12-15T18:07:44+00:00",
        "VersionId": "v1"
    },
    "AWSCloudTrailReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudTrailReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:39:59+00:00",
        "DefaultVersionId": "v9",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetBucketLocation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloudtrail:GetTrail",
                        "cloudtrail:GetTrailStatus",
                        "cloudtrail:DescribeTrails",
                        "cloudtrail:ListTrails",
                        "cloudtrail:LookupEvents",
                        "cloudtrail:ListTags",
                        "cloudtrail:ListPublicKeys",
                        "cloudtrail:GetEventSelectors",
                        "cloudtrail:GetInsightSelectors",
                        "s3:ListAllMyBuckets",
                        "kms:ListAliases",
                        "lambda:ListFunctions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJDU7KJADWBSEQ3E7S",
        "PolicyName": "AWSCloudTrailReadOnlyAccess",
        "UpdateDate": "2019-11-20T21:06:49+00:00",
        "VersionId": "v9"
    },
    "AWSCloudTrail_FullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCloudTrail_FullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-10-08T23:41:15+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sns:AddPermission",
                        "sns:CreateTopic",
                        "sns:SetTopicAttributes",
                        "sns:GetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sns:*:*:aws-cloudtrail-logs*"
                    ]
                },
                {
                    "Action": [
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:CreateBucket",
                        "s3:PutBucketPolicy",
                        "s3:PutBucketPublicAccessBlock"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-cloudtrail-logs*"
                    ]
                },
                {
                    "Action": [
                        "s3:ListAllMyBuckets",
                        "s3:GetBucketLocation",
                        "s3:GetBucketPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "cloudtrail:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:CreateLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:aws-cloudtrail-logs*"
                    ]
                },
                {
                    "Action": [
                        "iam:ListRoles",
                        "iam:GetRolePolicy",
                        "iam:GetUser"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "cloudtrail.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:CreateKey",
                        "kms:CreateAlias",
                        "kms:ListKeys",
                        "kms:ListAliases"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "lambda:ListFunctions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dynamodb:ListGlobalTables",
                        "dynamodb:ListTables"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4CA4SIJQAM",
        "PolicyName": "AWSCloudTrail_FullAccess",
        "UpdateDate": "2021-02-22T19:01:00+00:00",
        "VersionId": "v3"
    },
    "AWSCodeArtifactAdminAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeArtifactAdminAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-16T23:53:23+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codeartifact:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "sts:GetServiceBearerToken",
                    "Condition": {
                        "StringEquals": {
                            "sts:AWSServiceName": "codeartifact.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MBONPJNI5",
        "PolicyName": "AWSCodeArtifactAdminAccess",
        "UpdateDate": "2020-06-16T23:53:23+00:00",
        "VersionId": "v1"
    },
    "AWSCodeArtifactReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeArtifactReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-25T21:23:52+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codeartifact:Describe*",
                        "codeartifact:Get*",
                        "codeartifact:List*",
                        "codeartifact:ReadFromRepository"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "sts:GetServiceBearerToken",
                    "Condition": {
                        "StringEquals": {
                            "sts:AWSServiceName": "codeartifact.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4PVTKOJHFB",
        "PolicyName": "AWSCodeArtifactReadOnlyAccess",
        "UpdateDate": "2020-06-25T21:23:52+00:00",
        "VersionId": "v1"
    },
    "AWSCodeBuildAdminAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeBuildAdminAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-01T19:04:44+00:00",
        "DefaultVersionId": "v12",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codebuild:*",
                        "codecommit:GetBranch",
                        "codecommit:GetCommit",
                        "codecommit:GetRepository",
                        "codecommit:ListBranches",
                        "codecommit:ListRepositories",
                        "cloudwatch:GetMetricStatistics",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ecr:DescribeRepositories",
                        "ecr:ListImages",
                        "elasticfilesystem:DescribeFileSystems",
                        "events:DeleteRule",
                        "events:DescribeRule",
                        "events:DisableRule",
                        "events:EnableRule",
                        "events:ListTargetsByRule",
                        "events:ListRuleNamesByTarget",
                        "events:PutRule",
                        "events:PutTargets",
                        "events:RemoveTargets",
                        "logs:GetLogEvents",
                        "s3:GetBucketLocation",
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:DeleteLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/codebuild/*:log-stream:*"
                },
                {
                    "Action": [
                        "ssm:PutParameter"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ssm:*:*:parameter/CodeBuild/*"
                },
                {
                    "Action": [
                        "ssm:StartSession"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ecs:*:*:task/*/*"
                },
                {
                    "Action": [
                        "codestar-connections:CreateConnection",
                        "codestar-connections:DeleteConnection",
                        "codestar-connections:UpdateConnectionInstallation",
                        "codestar-connections:TagResource",
                        "codestar-connections:UntagResource",
                        "codestar-connections:ListConnections",
                        "codestar-connections:ListInstallationTargets",
                        "codestar-connections:ListTagsForResource",
                        "codestar-connections:GetConnection",
                        "codestar-connections:GetIndividualAccessToken",
                        "codestar-connections:GetInstallationUrl",
                        "codestar-connections:PassConnection",
                        "codestar-connections:StartOAuthHandshake",
                        "codestar-connections:UseConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*",
                    "Sid": "CodeStarConnectionsReadWriteAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:DeleteNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codebuild:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListEventTypes",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:SetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:codestar-notifications*",
                    "Sid": "CodeStarNotificationsSNSTopicCreateAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics",
                        "sns:GetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSTopicListAccess"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQJGIOIE3CD2TQXDS",
        "PolicyName": "AWSCodeBuildAdminAccess",
        "UpdateDate": "2020-09-14T16:03:39+00:00",
        "VersionId": "v12"
    },
    "AWSCodeBuildDeveloperAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeBuildDeveloperAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-01T19:02:32+00:00",
        "DefaultVersionId": "v13",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codebuild:StartBuild",
                        "codebuild:StopBuild",
                        "codebuild:StartBuildBatch",
                        "codebuild:StopBuildBatch",
                        "codebuild:RetryBuild",
                        "codebuild:RetryBuildBatch",
                        "codebuild:BatchGet*",
                        "codebuild:GetResourcePolicy",
                        "codebuild:DescribeTestCases",
                        "codebuild:DescribeCodeCoverages",
                        "codebuild:List*",
                        "codecommit:GetBranch",
                        "codecommit:GetCommit",
                        "codecommit:GetRepository",
                        "codecommit:ListBranches",
                        "cloudwatch:GetMetricStatistics",
                        "events:DescribeRule",
                        "events:ListTargetsByRule",
                        "events:ListRuleNamesByTarget",
                        "logs:GetLogEvents",
                        "s3:GetBucketLocation",
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ssm:PutParameter"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ssm:*:*:parameter/CodeBuild/*"
                },
                {
                    "Action": [
                        "ssm:StartSession"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ecs:*:*:task/*/*"
                },
                {
                    "Action": [
                        "codestar-connections:ListConnections",
                        "codestar-connections:GetConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*",
                    "Sid": "CodeStarConnectionsUserAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codebuild:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListEventTypes",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics",
                        "sns:GetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSTopicListAccess"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIMKTMR34XSBQW45HS",
        "PolicyName": "AWSCodeBuildDeveloperAccess",
        "UpdateDate": "2020-09-14T16:03:44+00:00",
        "VersionId": "v13"
    },
    "AWSCodeBuildReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeBuildReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-01T19:03:41+00:00",
        "DefaultVersionId": "v11",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codebuild:BatchGet*",
                        "codebuild:GetResourcePolicy",
                        "codebuild:List*",
                        "codebuild:DescribeTestCases",
                        "codebuild:DescribeCodeCoverages",
                        "codecommit:GetBranch",
                        "codecommit:GetCommit",
                        "codecommit:GetRepository",
                        "cloudwatch:GetMetricStatistics",
                        "events:DescribeRule",
                        "events:ListTargetsByRule",
                        "events:ListRuleNamesByTarget",
                        "logs:GetLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codestar-connections:ListConnections",
                        "codestar-connections:GetConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*",
                    "Sid": "CodeStarConnectionsUserAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:DescribeNotificationRule"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codebuild:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsPowerUserAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListEventTypes",
                        "codestar-notifications:ListTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJIZZWN6557F5HVP2K",
        "PolicyName": "AWSCodeBuildReadOnlyAccess",
        "UpdateDate": "2020-09-14T16:04:04+00:00",
        "VersionId": "v11"
    },
    "AWSCodeCommitFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeCommitFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-07-09T17:02:19+00:00",
        "DefaultVersionId": "v9",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codecommit:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "events:DeleteRule",
                        "events:DescribeRule",
                        "events:DisableRule",
                        "events:EnableRule",
                        "events:PutRule",
                        "events:PutTargets",
                        "events:RemoveTargets",
                        "events:ListTargetsByRule"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:events:*:*:rule/codecommit*",
                    "Sid": "CloudWatchEventsCodeCommitRulesAccess"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:DeleteTopic",
                        "sns:Subscribe",
                        "sns:Unsubscribe",
                        "sns:SetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:codecommit*",
                    "Sid": "SNSTopicAndSubscriptionAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics",
                        "sns:ListSubscriptionsByTopic",
                        "sns:GetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSTopicAndSubscriptionReadAccess"
                },
                {
                    "Action": [
                        "lambda:ListFunctions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "LambdaReadOnlyListAccess"
                },
                {
                    "Action": [
                        "iam:ListUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "IAMReadOnlyListAccess"
                },
                {
                    "Action": [
                        "iam:ListAccessKeys",
                        "iam:ListSSHPublicKeys",
                        "iam:ListServiceSpecificCredentials"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:user/${aws:username}",
                    "Sid": "IAMReadOnlyConsoleAccess"
                },
                {
                    "Action": [
                        "iam:DeleteSSHPublicKey",
                        "iam:GetSSHPublicKey",
                        "iam:ListSSHPublicKeys",
                        "iam:UpdateSSHPublicKey",
                        "iam:UploadSSHPublicKey"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:user/${aws:username}",
                    "Sid": "IAMUserSSHKeys"
                },
                {
                    "Action": [
                        "iam:CreateServiceSpecificCredential",
                        "iam:UpdateServiceSpecificCredential",
                        "iam:DeleteServiceSpecificCredential",
                        "iam:ResetServiceSpecificCredential"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:user/${aws:username}",
                    "Sid": "IAMSelfManageServiceSpecificCredentials"
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:DeleteNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codecommit:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource",
                        "codestar-notifications:ListEventTypes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:SetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:codestar-notifications*",
                    "Sid": "CodeStarNotificationsSNSTopicCreateAccess"
                },
                {
                    "Action": [
                        "codeguru-reviewer:AssociateRepository",
                        "codeguru-reviewer:DescribeRepositoryAssociation",
                        "codeguru-reviewer:ListRepositoryAssociations",
                        "codeguru-reviewer:DisassociateRepository",
                        "codeguru-reviewer:DescribeCodeReview",
                        "codeguru-reviewer:ListCodeReviews"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AmazonCodeGuruReviewerFullAccess"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "codeguru-reviewer.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
                    "Sid": "AmazonCodeGuruReviewerSLRCreation"
                },
                {
                    "Action": [
                        "events:PutRule",
                        "events:PutTargets",
                        "events:DeleteRule",
                        "events:RemoveTargets"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "events:ManagedBy": "codeguru-reviewer.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CloudWatchEventsManagedRules"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                },
                {
                    "Action": [
                        "codestar-connections:ListConnections",
                        "codestar-connections:GetConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*",
                    "Sid": "CodeStarConnectionsReadOnlyAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI4VCZ3XPIZLQ5NZV2",
        "PolicyName": "AWSCodeCommitFullAccess",
        "UpdateDate": "2020-07-30T23:17:35+00:00",
        "VersionId": "v9"
    },
    "AWSCodeCommitPowerUser": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeCommitPowerUser",
        "AttachmentCount": 0,
        "CreateDate": "2015-07-09T17:06:49+00:00",
        "DefaultVersionId": "v14",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codecommit:AssociateApprovalRuleTemplateWithRepository",
                        "codecommit:BatchAssociateApprovalRuleTemplateWithRepositories",
                        "codecommit:BatchDisassociateApprovalRuleTemplateFromRepositories",
                        "codecommit:BatchGet*",
                        "codecommit:BatchDescribe*",
                        "codecommit:Create*",
                        "codecommit:DeleteBranch",
                        "codecommit:DeleteFile",
                        "codecommit:Describe*",
                        "codecommit:DisassociateApprovalRuleTemplateFromRepository",
                        "codecommit:EvaluatePullRequestApprovalRules",
                        "codecommit:Get*",
                        "codecommit:List*",
                        "codecommit:Merge*",
                        "codecommit:OverridePullRequestApprovalRules",
                        "codecommit:Put*",
                        "codecommit:Post*",
                        "codecommit:TagResource",
                        "codecommit:Test*",
                        "codecommit:UntagResource",
                        "codecommit:Update*",
                        "codecommit:GitPull",
                        "codecommit:GitPush"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "events:DeleteRule",
                        "events:DescribeRule",
                        "events:DisableRule",
                        "events:EnableRule",
                        "events:PutRule",
                        "events:PutTargets",
                        "events:RemoveTargets",
                        "events:ListTargetsByRule"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:events:*:*:rule/codecommit*",
                    "Sid": "CloudWatchEventsCodeCommitRulesAccess"
                },
                {
                    "Action": [
                        "sns:Subscribe",
                        "sns:Unsubscribe"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:codecommit*",
                    "Sid": "SNSTopicAndSubscriptionAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics",
                        "sns:ListSubscriptionsByTopic",
                        "sns:GetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSTopicAndSubscriptionReadAccess"
                },
                {
                    "Action": [
                        "lambda:ListFunctions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "LambdaReadOnlyListAccess"
                },
                {
                    "Action": [
                        "iam:ListUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "IAMReadOnlyListAccess"
                },
                {
                    "Action": [
                        "iam:ListAccessKeys",
                        "iam:ListSSHPublicKeys",
                        "iam:ListServiceSpecificCredentials"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:user/${aws:username}",
                    "Sid": "IAMReadOnlyConsoleAccess"
                },
                {
                    "Action": [
                        "iam:DeleteSSHPublicKey",
                        "iam:GetSSHPublicKey",
                        "iam:ListSSHPublicKeys",
                        "iam:UpdateSSHPublicKey",
                        "iam:UploadSSHPublicKey"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:user/${aws:username}",
                    "Sid": "IAMUserSSHKeys"
                },
                {
                    "Action": [
                        "iam:CreateServiceSpecificCredential",
                        "iam:UpdateServiceSpecificCredential",
                        "iam:DeleteServiceSpecificCredential",
                        "iam:ResetServiceSpecificCredential"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:user/${aws:username}",
                    "Sid": "IAMSelfManageServiceSpecificCredentials"
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codecommit:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource",
                        "codestar-notifications:ListEventTypes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                },
                {
                    "Action": [
                        "codeguru-reviewer:AssociateRepository",
                        "codeguru-reviewer:DescribeRepositoryAssociation",
                        "codeguru-reviewer:ListRepositoryAssociations",
                        "codeguru-reviewer:DisassociateRepository",
                        "codeguru-reviewer:DescribeCodeReview",
                        "codeguru-reviewer:ListCodeReviews"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AmazonCodeGuruReviewerFullAccess"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "codeguru-reviewer.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/codeguru-reviewer.amazonaws.com/AWSServiceRoleForAmazonCodeGuruReviewer",
                    "Sid": "AmazonCodeGuruReviewerSLRCreation"
                },
                {
                    "Action": [
                        "events:PutRule",
                        "events:PutTargets",
                        "events:DeleteRule",
                        "events:RemoveTargets"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "events:ManagedBy": "codeguru-reviewer.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CloudWatchEventsManagedRules"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                },
                {
                    "Action": [
                        "codestar-connections:ListConnections",
                        "codestar-connections:GetConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*",
                    "Sid": "CodeStarConnectionsReadOnlyAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI4UIINUVGB5SEC57G",
        "PolicyName": "AWSCodeCommitPowerUser",
        "UpdateDate": "2020-07-30T23:12:48+00:00",
        "VersionId": "v14"
    },
    "AWSCodeCommitReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeCommitReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2015-07-09T17:05:06+00:00",
        "DefaultVersionId": "v10",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codecommit:BatchGet*",
                        "codecommit:BatchDescribe*",
                        "codecommit:Describe*",
                        "codecommit:EvaluatePullRequestApprovalRules",
                        "codecommit:Get*",
                        "codecommit:List*",
                        "codecommit:GitPull"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "events:DescribeRule",
                        "events:ListTargetsByRule"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:events:*:*:rule/codecommit*",
                    "Sid": "CloudWatchEventsCodeCommitRulesReadOnlyAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics",
                        "sns:ListSubscriptionsByTopic",
                        "sns:GetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSSubscriptionAccess"
                },
                {
                    "Action": [
                        "lambda:ListFunctions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "LambdaReadOnlyListAccess"
                },
                {
                    "Action": [
                        "iam:ListUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "IAMReadOnlyListAccess"
                },
                {
                    "Action": [
                        "iam:ListAccessKeys",
                        "iam:ListSSHPublicKeys",
                        "iam:ListServiceSpecificCredentials",
                        "iam:ListAccessKeys",
                        "iam:GetSSHPublicKey"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:user/${aws:username}",
                    "Sid": "IAMReadOnlyConsoleAccess"
                },
                {
                    "Action": [
                        "codestar-connections:ListConnections",
                        "codestar-connections:GetConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*",
                    "Sid": "CodeStarConnectionsReadOnlyAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:DescribeNotificationRule"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codecommit:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadOnlyAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListEventTypes",
                        "codestar-notifications:ListTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                },
                {
                    "Action": [
                        "codeguru-reviewer:DescribeRepositoryAssociation",
                        "codeguru-reviewer:ListRepositoryAssociations",
                        "codeguru-reviewer:DescribeCodeReview",
                        "codeguru-reviewer:ListCodeReviews"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AmazonCodeGuruReviewerReadOnlyAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJACNSXR7Z2VLJW3D6",
        "PolicyName": "AWSCodeCommitReadOnly",
        "UpdateDate": "2020-07-30T23:08:05+00:00",
        "VersionId": "v10"
    },
    "AWSCodeDeployDeployerAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeDeployDeployerAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-05-19T18:18:43+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codedeploy:Batch*",
                        "codedeploy:CreateDeployment",
                        "codedeploy:Get*",
                        "codedeploy:List*",
                        "codedeploy:RegisterApplicationRevision"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codedeploy:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource",
                        "codestar-notifications:ListEventTypes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSTopicListAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJUWEPOMGLMVXJAPUI",
        "PolicyName": "AWSCodeDeployDeployerAccess",
        "UpdateDate": "2020-04-02T16:16:11+00:00",
        "VersionId": "v3"
    },
    "AWSCodeDeployFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeDeployFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-05-19T18:13:23+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": "codedeploy:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:DeleteNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codedeploy:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource",
                        "codestar-notifications:ListEventTypes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:SetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:codestar-notifications*",
                    "Sid": "CodeStarNotificationsSNSTopicCreateAccess"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                },
                {
                    "Action": [
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SNSTopicListAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIONKN3TJZUKXCHXWC",
        "PolicyName": "AWSCodeDeployFullAccess",
        "UpdateDate": "2020-04-02T16:14:47+00:00",
        "VersionId": "v3"
    },
    "AWSCodeDeployReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeDeployReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-05-19T18:21:32+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codedeploy:Batch*",
                        "codedeploy:Get*",
                        "codedeploy:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codestar-notifications:DescribeNotificationRule"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codedeploy:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsPowerUserAccess"
                },
                {
                    "Action": [
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListEventTypes",
                        "codestar-notifications:ListTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsListAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAILZHHKCKB4NE7XOIQ",
        "PolicyName": "AWSCodeDeployReadOnlyAccess",
        "UpdateDate": "2020-04-02T16:20:09+00:00",
        "VersionId": "v3"
    },
    "AWSCodeDeployRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-05-04T18:05:37+00:00",
        "DefaultVersionId": "v8",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "autoscaling:CompleteLifecycleAction",
                        "autoscaling:DeleteLifecycleHook",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeLifecycleHooks",
                        "autoscaling:PutLifecycleHook",
                        "autoscaling:RecordLifecycleActionHeartbeat",
                        "autoscaling:CreateAutoScalingGroup",
                        "autoscaling:UpdateAutoScalingGroup",
                        "autoscaling:EnableMetricsCollection",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribePolicies",
                        "autoscaling:DescribeScheduledActions",
                        "autoscaling:DescribeNotificationConfigurations",
                        "autoscaling:DescribeLifecycleHooks",
                        "autoscaling:SuspendProcesses",
                        "autoscaling:ResumeProcesses",
                        "autoscaling:AttachLoadBalancers",
                        "autoscaling:AttachLoadBalancerTargetGroups",
                        "autoscaling:PutScalingPolicy",
                        "autoscaling:PutScheduledUpdateGroupAction",
                        "autoscaling:PutNotificationConfiguration",
                        "autoscaling:PutLifecycleHook",
                        "autoscaling:DescribeScalingActivities",
                        "autoscaling:DeleteAutoScalingGroup",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceStatus",
                        "ec2:TerminateInstances",
                        "tag:GetResources",
                        "sns:Publish",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:PutMetricAlarm",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
                        "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
                        "elasticloadbalancing:DescribeTargetGroups",
                        "elasticloadbalancing:DescribeTargetHealth",
                        "elasticloadbalancing:RegisterTargets",
                        "elasticloadbalancing:DeregisterTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ2NKMKD73QS5NBFLA",
        "PolicyName": "AWSCodeDeployRole",
        "UpdateDate": "2020-05-19T17:11:39+00:00",
        "VersionId": "v8"
    },
    "AWSCodeDeployRoleForCloudFormation": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRoleForCloudFormation",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-19T17:12:52+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "lambda:InvokeFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:lambda:*:*:function:CodeDeployHook_*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4CO24UTMFH",
        "PolicyName": "AWSCodeDeployRoleForCloudFormation",
        "UpdateDate": "2020-05-19T17:12:52+00:00",
        "VersionId": "v1"
    },
    "AWSCodeDeployRoleForECS": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeDeployRoleForECS",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-27T20:40:57+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ecs:DescribeServices",
                        "ecs:CreateTaskSet",
                        "ecs:UpdateServicePrimaryTaskSet",
                        "ecs:DeleteTaskSet",
                        "elasticloadbalancing:DescribeTargetGroups",
                        "elasticloadbalancing:DescribeListeners",
                        "elasticloadbalancing:ModifyListener",
                        "elasticloadbalancing:DescribeRules",
                        "elasticloadbalancing:ModifyRule",
                        "lambda:InvokeFunction",
                        "cloudwatch:DescribeAlarms",
                        "sns:Publish",
                        "s3:GetObject",
                        "s3:GetObjectVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "ecs-tasks.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIIL3KXEKRGEN2HFIO",
        "PolicyName": "AWSCodeDeployRoleForECS",
        "UpdateDate": "2019-09-23T22:37:46+00:00",
        "VersionId": "v3"
    },
    "AWSCodeDeployRoleForECSLimited": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeDeployRoleForECSLimited",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-27T20:42:42+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ecs:DescribeServices",
                        "ecs:CreateTaskSet",
                        "ecs:UpdateServicePrimaryTaskSet",
                        "ecs:DeleteTaskSet",
                        "cloudwatch:DescribeAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:CodeDeployTopic_*"
                },
                {
                    "Action": [
                        "elasticloadbalancing:DescribeTargetGroups",
                        "elasticloadbalancing:DescribeListeners",
                        "elasticloadbalancing:ModifyListener",
                        "elasticloadbalancing:DescribeRules",
                        "elasticloadbalancing:ModifyRule"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "lambda:InvokeFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:lambda:*:*:function:CodeDeployHook_*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetObjectVersion"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "s3:ExistingObjectTag/UseWithCodeDeploy": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "ecs-tasks.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/ecsTaskExecutionRole",
                        "arn:aws:iam::*:role/ECSTaskExecution*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ6Z7L2IOXEFFOGD2M",
        "PolicyName": "AWSCodeDeployRoleForECSLimited",
        "UpdateDate": "2019-09-23T22:10:29+00:00",
        "VersionId": "v3"
    },
    "AWSCodeDeployRoleForLambda": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRoleForLambda",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-28T14:05:44+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudwatch:DescribeAlarms",
                        "lambda:UpdateAlias",
                        "lambda:GetAlias",
                        "lambda:GetProvisionedConcurrencyConfig",
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetObjectVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*/CodeDeploy/*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetObjectVersion"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "s3:ExistingObjectTag/UseWithCodeDeploy": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "lambda:InvokeFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:lambda:*:*:function:CodeDeployHook_*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJA3RQZIKNOSJ4ZQSA",
        "PolicyName": "AWSCodeDeployRoleForLambda",
        "UpdateDate": "2019-12-03T19:53:10+00:00",
        "VersionId": "v3"
    },
    "AWSCodeDeployRoleForLambdaLimited": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRoleForLambdaLimited",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-17T17:14:14+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudwatch:DescribeAlarms",
                        "lambda:UpdateAlias",
                        "lambda:GetAlias",
                        "lambda:GetProvisionedConcurrencyConfig"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetObjectVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*/CodeDeploy/*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetObjectVersion"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "s3:ExistingObjectTag/UseWithCodeDeploy": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "lambda:InvokeFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:lambda:*:*:function:CodeDeployHook_*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4C55RUFGEB",
        "PolicyName": "AWSCodeDeployRoleForLambdaLimited",
        "UpdateDate": "2020-08-17T17:14:14+00:00",
        "VersionId": "v1"
    },
    "AWSCodePipelineApproverAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodePipelineApproverAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-07-28T18:59:17+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codepipeline:GetPipeline",
                        "codepipeline:GetPipelineState",
                        "codepipeline:GetPipelineExecution",
                        "codepipeline:ListPipelineExecutions",
                        "codepipeline:ListPipelines",
                        "codepipeline:PutApprovalResult"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAICXNWK42SQ6LMDXM2",
        "PolicyName": "AWSCodePipelineApproverAccess",
        "UpdateDate": "2017-08-02T17:24:58+00:00",
        "VersionId": "v3"
    },
    "AWSCodePipelineCustomActionAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodePipelineCustomActionAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-07-09T17:02:54+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codepipeline:AcknowledgeJob",
                        "codepipeline:GetJobDetails",
                        "codepipeline:PollForJobs",
                        "codepipeline:PutJobFailureResult",
                        "codepipeline:PutJobSuccessResult"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJFW5Z32BTVF76VCYC",
        "PolicyName": "AWSCodePipelineCustomActionAccess",
        "UpdateDate": "2015-07-09T17:02:54+00:00",
        "VersionId": "v1"
    },
    "AWSCodePipelineFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodePipelineFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-07-09T16:58:07+00:00",
        "DefaultVersionId": "v10",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codepipeline:*",
                        "cloudformation:DescribeStacks",
                        "cloudformation:ListChangeSets",
                        "cloudtrail:CreateTrail",
                        "cloudtrail:DescribeTrails",
                        "cloudtrail:GetEventSelectors",
                        "cloudtrail:PutEventSelectors",
                        "cloudtrail:StartLogging",
                        "codebuild:BatchGetProjects",
                        "codebuild:CreateProject",
                        "codebuild:ListCuratedEnvironmentImages",
                        "codebuild:ListProjects",
                        "codecommit:GetBranch",
                        "codecommit:GetRepositoryTriggers",
                        "codecommit:ListBranches",
                        "codecommit:ListRepositories",
                        "codecommit:PutRepositoryTriggers",
                        "codecommit:GetReferences",
                        "codedeploy:GetApplication",
                        "codedeploy:BatchGetApplications",
                        "codedeploy:GetDeploymentGroup",
                        "codedeploy:BatchGetDeploymentGroups",
                        "codedeploy:ListApplications",
                        "codedeploy:ListDeploymentGroups",
                        "devicefarm:GetDevicePool",
                        "devicefarm:GetProject",
                        "devicefarm:ListDevicePools",
                        "devicefarm:ListProjects",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ecr:DescribeRepositories",
                        "ecr:ListImages",
                        "ecs:ListClusters",
                        "ecs:ListServices",
                        "elasticbeanstalk:DescribeApplications",
                        "elasticbeanstalk:DescribeEnvironments",
                        "iam:ListRoles",
                        "iam:GetRole",
                        "lambda:GetFunctionConfiguration",
                        "lambda:ListFunctions",
                        "events:ListRules",
                        "events:ListTargetsByRule",
                        "events:DescribeRule",
                        "opsworks:DescribeApps",
                        "opsworks:DescribeLayers",
                        "opsworks:DescribeStacks",
                        "s3:GetBucketPolicy",
                        "s3:GetBucketVersioning",
                        "s3:GetObjectVersion",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket",
                        "sns:ListTopics",
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource",
                        "codestar-notifications:ListEventTypes",
                        "states:ListStateMachines"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:CreateBucket",
                        "s3:PutBucketPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3::*:codepipeline-*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "events.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/service-role/cwe-role-*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "codepipeline.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "events:PutRule",
                        "events:PutTargets",
                        "events:DeleteRule",
                        "events:DisableRule",
                        "events:RemoveTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:events:*:*:rule/codepipeline-*"
                    ]
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:DeleteNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codepipeline:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:SetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:codestar-notifications*",
                    "Sid": "CodeStarNotificationsSNSTopicCreateAccess"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJP5LH77KSAT2KHQGG",
        "PolicyName": "AWSCodePipelineFullAccess",
        "UpdateDate": "2020-05-21T22:03:13+00:00",
        "VersionId": "v10"
    },
    "AWSCodePipelineReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodePipelineReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-07-09T16:43:57+00:00",
        "DefaultVersionId": "v9",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codepipeline:GetPipeline",
                        "codepipeline:GetPipelineState",
                        "codepipeline:GetPipelineExecution",
                        "codepipeline:ListPipelineExecutions",
                        "codepipeline:ListActionExecutions",
                        "codepipeline:ListActionTypes",
                        "codepipeline:ListPipelines",
                        "codepipeline:ListTagsForResource",
                        "iam:ListRoles",
                        "s3:GetBucketPolicy",
                        "s3:GetObject",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket",
                        "codecommit:ListBranches",
                        "codecommit:ListRepositories",
                        "codedeploy:GetApplication",
                        "codedeploy:GetDeploymentGroup",
                        "codedeploy:ListApplications",
                        "codedeploy:ListDeploymentGroups",
                        "elasticbeanstalk:DescribeApplications",
                        "elasticbeanstalk:DescribeEnvironments",
                        "lambda:GetFunctionConfiguration",
                        "lambda:ListFunctions",
                        "opsworks:DescribeApps",
                        "opsworks:DescribeLayers",
                        "opsworks:DescribeStacks",
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListEventTypes",
                        "codestar-notifications:ListTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codestar-notifications:DescribeNotificationRule"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codepipeline:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadOnlyAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAILFKZXIBOTNC5TO2Q",
        "PolicyName": "AWSCodePipelineReadOnlyAccess",
        "UpdateDate": "2020-03-26T16:07:17+00:00",
        "VersionId": "v9"
    },
    "AWSCodePipeline_FullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodePipeline_FullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-03T22:38:28+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codepipeline:*",
                        "cloudformation:DescribeStacks",
                        "cloudformation:ListChangeSets",
                        "cloudtrail:DescribeTrails",
                        "codebuild:BatchGetProjects",
                        "codebuild:CreateProject",
                        "codebuild:ListCuratedEnvironmentImages",
                        "codebuild:ListProjects",
                        "codecommit:ListBranches",
                        "codecommit:GetReferences",
                        "codecommit:ListRepositories",
                        "codedeploy:BatchGetDeploymentGroups",
                        "codedeploy:ListApplications",
                        "codedeploy:ListDeploymentGroups",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ecr:DescribeRepositories",
                        "ecr:ListImages",
                        "ecs:ListClusters",
                        "ecs:ListServices",
                        "elasticbeanstalk:DescribeApplications",
                        "elasticbeanstalk:DescribeEnvironments",
                        "iam:ListRoles",
                        "iam:GetRole",
                        "lambda:ListFunctions",
                        "events:ListRules",
                        "events:ListTargetsByRule",
                        "events:DescribeRule",
                        "opsworks:DescribeApps",
                        "opsworks:DescribeLayers",
                        "opsworks:DescribeStacks",
                        "s3:ListAllMyBuckets",
                        "sns:ListTopics",
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListTargets",
                        "codestar-notifications:ListTagsforResource",
                        "codestar-notifications:ListEventTypes",
                        "states:ListStateMachines"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:GetBucketPolicy",
                        "s3:GetBucketVersioning",
                        "s3:GetObjectVersion",
                        "s3:CreateBucket",
                        "s3:PutBucketPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3::*:codepipeline-*"
                },
                {
                    "Action": [
                        "cloudtrail:PutEventSelectors",
                        "cloudtrail:CreateTrail",
                        "cloudtrail:GetEventSelectors",
                        "cloudtrail:StartLogging"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudtrail:*:*:trail/codepipeline-source-trail"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "events.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/service-role/cwe-role-*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "codepipeline.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "events:PutRule",
                        "events:PutTargets",
                        "events:DeleteRule",
                        "events:DisableRule",
                        "events:RemoveTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:events:*:*:rule/codepipeline-*"
                    ]
                },
                {
                    "Action": [
                        "codestar-notifications:CreateNotificationRule",
                        "codestar-notifications:DescribeNotificationRule",
                        "codestar-notifications:UpdateNotificationRule",
                        "codestar-notifications:DeleteNotificationRule",
                        "codestar-notifications:Subscribe",
                        "codestar-notifications:Unsubscribe"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codepipeline:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadWriteAccess"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:SetTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:codestar-notifications*",
                    "Sid": "CodeStarNotificationsSNSTopicCreateAccess"
                },
                {
                    "Action": [
                        "chatbot:DescribeSlackChannelConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsChatbotAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4A6ZKP3LKA",
        "PolicyName": "AWSCodePipeline_FullAccess",
        "UpdateDate": "2020-08-03T22:38:28+00:00",
        "VersionId": "v1"
    },
    "AWSCodePipeline_ReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodePipeline_ReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-03T22:25:17+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codepipeline:GetPipeline",
                        "codepipeline:GetPipelineState",
                        "codepipeline:GetPipelineExecution",
                        "codepipeline:ListPipelineExecutions",
                        "codepipeline:ListActionExecutions",
                        "codepipeline:ListActionTypes",
                        "codepipeline:ListPipelines",
                        "codepipeline:ListTagsForResource",
                        "s3:ListAllMyBuckets",
                        "codestar-notifications:ListNotificationRules",
                        "codestar-notifications:ListEventTypes",
                        "codestar-notifications:ListTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:GetBucketPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3::*:codepipeline-*"
                },
                {
                    "Action": [
                        "codestar-notifications:DescribeNotificationRule"
                    ],
                    "Condition": {
                        "StringLike": {
                            "codestar-notifications:NotificationsForResource": "arn:aws:codepipeline:*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarNotificationsReadOnlyAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IGBTPGT6W",
        "PolicyName": "AWSCodePipeline_ReadOnlyAccess",
        "UpdateDate": "2020-08-03T22:25:17+00:00",
        "VersionId": "v1"
    },
    "AWSCodeStarFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSCodeStarFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-04-19T16:23:19+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "codestar:*",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSubnets",
                        "cloud9:DescribeEnvironment*",
                        "cloud9:ValidateEnvironmentName"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "CodeStarEC2"
                },
                {
                    "Action": [
                        "cloudformation:DescribeStack*",
                        "cloudformation:GetTemplateSummary"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/awscodestar-*"
                    ],
                    "Sid": "CodeStarCF"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIXI233TFUGLZOJBEC",
        "PolicyName": "AWSCodeStarFullAccess",
        "UpdateDate": "2018-01-10T21:54:06+00:00",
        "VersionId": "v2"
    },
    "AWSCodeStarNotificationsServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSCodeStarNotificationsServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-05T16:10:21+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "events:PutTargets",
                        "events:PutRule",
                        "events:DescribeRule"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:events:*:*:rule/awscodestarnotifications-*"
                },
                {
                    "Action": [
                        "sns:CreateTopic"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:CodeStarNotifications-*"
                },
                {
                    "Action": [
                        "codecommit:GetCommentsForPullRequest",
                        "codecommit:GetCommentsForComparedCommit",
                        "chatbot:DescribeSlackChannelConfigurations",
                        "chatbot:UpdateSlackChannelConfiguration",
                        "codecommit:GetDifferences",
                        "codepipeline:ListActionExecutions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codecommit:GetFile"
                    ],
                    "Condition": {
                        "StringNotEquals": {
                            "aws:ResourceTag/ExcludeFileContentFromNotifications": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BGRXOB2GH",
        "PolicyName": "AWSCodeStarNotificationsServiceRolePolicy",
        "UpdateDate": "2020-03-19T16:01:55+00:00",
        "VersionId": "v4"
    },
    "AWSCodeStarServiceRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSCodeStarServiceRole",
        "AttachmentCount": 0,
        "CreateDate": "2017-04-19T15:20:50+00:00",
        "DefaultVersionId": "v10",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "events:PutTargets",
                        "events:RemoveTargets",
                        "events:PutRule",
                        "events:DeleteRule",
                        "events:DescribeRule"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:events:*:*:rule/awscodestar-*"
                    ],
                    "Sid": "ProjectEventRules"
                },
                {
                    "Action": [
                        "cloudformation:*Stack*",
                        "cloudformation:CreateChangeSet",
                        "cloudformation:ExecuteChangeSet",
                        "cloudformation:DeleteChangeSet",
                        "cloudformation:GetTemplate"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/awscodestar-*",
                        "arn:aws:cloudformation:*:*:stack/awseb-*",
                        "arn:aws:cloudformation:*:*:stack/aws-cloud9-*",
                        "arn:aws:cloudformation:*:aws:transform/CodeStar*"
                    ],
                    "Sid": "ProjectStack"
                },
                {
                    "Action": [
                        "cloudformation:GetTemplateSummary",
                        "cloudformation:DescribeChangeSet"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ProjectStackTemplate"
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::awscodestar-*/*"
                    ],
                    "Sid": "ProjectQuickstarts"
                },
                {
                    "Action": [
                        "s3:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-codestar-*",
                        "arn:aws:s3:::aws-codestar-*/*",
                        "arn:aws:s3:::elasticbeanstalk-*",
                        "arn:aws:s3:::elasticbeanstalk-*/*"
                    ],
                    "Sid": "ProjectS3Buckets"
                },
                {
                    "Action": [
                        "codestar:*",
                        "codecommit:*",
                        "codepipeline:*",
                        "codedeploy:*",
                        "codebuild:*",
                        "ec2:RunInstances",
                        "autoscaling:*",
                        "cloudwatch:Put*",
                        "ec2:*",
                        "elasticbeanstalk:*",
                        "elasticloadbalancing:*",
                        "iam:ListRoles",
                        "logs:*",
                        "sns:*",
                        "cloud9:CreateEnvironmentEC2",
                        "cloud9:DeleteEnvironment",
                        "cloud9:DescribeEnvironment*",
                        "cloud9:ListEnvironments"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ProjectServices"
                },
                {
                    "Action": [
                        "iam:AttachRolePolicy",
                        "iam:CreateRole",
                        "iam:DeleteRole",
                        "iam:DeleteRolePolicy",
                        "iam:DetachRolePolicy",
                        "iam:GetRole",
                        "iam:PassRole",
                        "iam:GetRolePolicy",
                        "iam:PutRolePolicy",
                        "iam:SetDefaultPolicyVersion",
                        "iam:CreatePolicy",
                        "iam:DeletePolicy",
                        "iam:AddRoleToInstanceProfile",
                        "iam:CreateInstanceProfile",
                        "iam:DeleteInstanceProfile",
                        "iam:RemoveRoleFromInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/CodeStarWorker*",
                        "arn:aws:iam::*:policy/CodeStarWorker*",
                        "arn:aws:iam::*:instance-profile/awscodestar-*"
                    ],
                    "Sid": "ProjectWorkerRoles"
                },
                {
                    "Action": [
                        "iam:AttachUserPolicy",
                        "iam:DetachUserPolicy"
                    ],
                    "Condition": {
                        "ArnEquals": {
                            "iam:PolicyArn": [
                                "arn:aws:iam::*:policy/CodeStar_*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ProjectTeamMembers"
                },
                {
                    "Action": [
                        "iam:CreatePolicy",
                        "iam:DeletePolicy",
                        "iam:CreatePolicyVersion",
                        "iam:DeletePolicyVersion",
                        "iam:ListEntitiesForPolicy",
                        "iam:ListPolicyVersions",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:policy/CodeStar_*"
                    ],
                    "Sid": "ProjectRoles"
                },
                {
                    "Action": [
                        "iam:ListAttachedRolePolicies"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-codestar-service-role",
                        "arn:aws:iam::*:role/service-role/aws-codestar-service-role"
                    ],
                    "Sid": "InspectServiceRole"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "cloud9.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "IAMLinkRole"
                },
                {
                    "Action": [
                        "config:DescribeConfigRules"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DescribeConfigRuleForARN"
                },
                {
                    "Action": [
                        "codestar-connections:UseConnection",
                        "codestar-connections:GetConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ProjectCodeStarConnections"
                },
                {
                    "Action": "codestar-connections:PassConnection",
                    "Condition": {
                        "ForAnyValue:StringEqualsIfExists": {
                            "codestar-connections:PassedToService": "codepipeline.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ProjectCodeStarConnectionsPassConnections"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIN6D4M2KD3NBOC4M4",
        "PolicyName": "AWSCodeStarServiceRole",
        "UpdateDate": "2021-02-15T22:25:37+00:00",
        "VersionId": "v10"
    },
    "AWSCompromisedKeyQuarantine": {
        "Arn": "arn:aws:iam::aws:policy/AWSCompromisedKeyQuarantine",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-11T18:04:13+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iam:AttachGroupPolicy",
                        "iam:AttachRolePolicy",
                        "iam:AttachUserPolicy",
                        "iam:ChangePassword",
                        "iam:CreateAccessKey",
                        "iam:CreateInstanceProfile",
                        "iam:CreateLoginProfile",
                        "iam:CreateRole",
                        "iam:CreateUser",
                        "iam:DetachUserPolicy",
                        "iam:PutUserPermissionsBoundary",
                        "iam:PutUserPolicy",
                        "iam:UpdateAccessKey",
                        "iam:UpdateAccountPasswordPolicy",
                        "iam:UpdateUser",
                        "ec2:RequestSpotInstances",
                        "ec2:RunInstances",
                        "ec2:StartInstances",
                        "organizations:CreateAccount",
                        "organizations:CreateOrganization",
                        "organizations:InviteAccountToOrganization",
                        "lambda:CreateFunction",
                        "lightsail:Create*",
                        "lightsail:Start*",
                        "lightsail:Delete*",
                        "lightsail:Update*",
                        "lightsail:GetInstanceAccessDetails",
                        "lightsail:DownloadDefaultKeyPair"
                    ],
                    "Effect": "Deny",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4PLD3NKX4L",
        "PolicyName": "AWSCompromisedKeyQuarantine",
        "UpdateDate": "2020-08-11T18:04:13+00:00",
        "VersionId": "v1"
    },
    "AWSConfigMultiAccountSetupPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSConfigMultiAccountSetupPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-17T18:03:16+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "config:PutConfigRule",
                        "config:DeleteConfigRule"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:config:*:*:config-rule/aws-service-rule/config-multiaccountsetup.amazonaws.com/*"
                },
                {
                    "Action": [
                        "config:DescribeConfigurationRecorders"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "organizations:ListAccounts",
                        "organizations:DescribeOrganization",
                        "organizations:ListAWSServiceAccessForOrganization",
                        "organizations:DescribeAccount"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "config:PutConformancePack",
                        "config:DeleteConformancePack",
                        "config:DescribeConformancePackStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:config:*:*:conformance-pack/aws-service-conformance-pack/config-multiaccountsetup.amazonaws.com/*"
                },
                {
                    "Action": [
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "config-conforms.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/config-conforms.amazonaws.com/AWSServiceRoleForConfigConforms"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "ssm.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4L5NAGNGTD",
        "PolicyName": "AWSConfigMultiAccountSetupPolicy",
        "UpdateDate": "2020-05-21T22:59:26+00:00",
        "VersionId": "v4"
    },
    "AWSConfigRemediationServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSConfigRemediationServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-18T21:21:35+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ssm:GetDocument",
                        "ssm:DescribeDocument",
                        "ssm:StartAutomationExecution"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "ssm.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BC7ZOM6NP",
        "PolicyName": "AWSConfigRemediationServiceRolePolicy",
        "UpdateDate": "2019-06-18T21:21:35+00:00",
        "VersionId": "v1"
    },
    "AWSConfigRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSConfigRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-04-02T17:36:23+00:00",
        "DefaultVersionId": "v36",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm:DescribeCertificate",
                        "acm:ListCertificates",
                        "acm:ListTagsForCertificate",
                        "application-autoscaling:DescribeScalableTargets",
                        "application-autoscaling:DescribeScalingPolicies",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeLaunchConfigurations",
                        "autoscaling:DescribeLifecycleHooks",
                        "autoscaling:DescribePolicies",
                        "autoscaling:DescribeScheduledActions",
                        "autoscaling:DescribeTags",
                        "backup:ListBackupPlans",
                        "backup:ListBackupSelections",
                        "backup:GetBackupSelection",
                        "cloudfront:ListTagsForResource",
                        "cloudformation:describeType",
                        "cloudformation:listTypes",
                        "cloudtrail:DescribeTrails",
                        "cloudtrail:GetEventSelectors",
                        "cloudtrail:GetTrailStatus",
                        "cloudtrail:ListTags",
                        "cloudwatch:DescribeAlarms",
                        "codepipeline:GetPipeline",
                        "codepipeline:GetPipelineState",
                        "codepipeline:ListPipelines",
                        "config:BatchGet*",
                        "config:Describe*",
                        "config:Get*",
                        "config:List*",
                        "config:Put*",
                        "config:Select*",
                        "dax:DescribeClusters",
                        "dms:DescribeReplicationInstances",
                        "dynamodb:DescribeContinuousBackups",
                        "dynamodb:DescribeLimits",
                        "dynamodb:DescribeTable",
                        "dynamodb:ListTables",
                        "dynamodb:ListTagsOfResource",
                        "ec2:Describe*",
                        "ec2:GetEbsEncryptionByDefault",
                        "ecr:DescribeRepositories",
                        "ecr:GetLifecyclePolicy",
                        "ecr:GetRepositoryPolicy",
                        "ecr:ListTagsForResource",
                        "ecs:DescribeClusters",
                        "ecs:DescribeServices",
                        "ecs:DescribeTaskDefinition",
                        "ecs:DescribeTaskSets",
                        "ecs:ListClusters",
                        "ecs:ListServices",
                        "ecs:ListTagsForResource",
                        "ecs:ListTaskDefinitions",
                        "eks:DescribeCluster",
                        "eks:DescribeNodegroup",
                        "eks:ListClusters",
                        "eks:ListNodegroups",
                        "elasticache:DescribeCacheClusters",
                        "elasticache:DescribeReplicationGroups",
                        "elasticfilesystem:DescribeFileSystems",
                        "elasticfilesystem:DescribeLifecycleConfiguration",
                        "elasticfilesystem:DescribeMountTargets",
                        "elasticfilesystem:DescribeMountTargetSecurityGroups",
                        "elasticloadbalancing:DescribeListeners",
                        "elasticloadbalancing:DescribeLoadBalancerAttributes",
                        "elasticloadbalancing:DescribeLoadBalancerPolicies",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeRules",
                        "elasticloadbalancing:DescribeTags",
                        "elasticmapreduce:DescribeCluster",
                        "elasticmapreduce:DescribeSecurityConfiguration",
                        "elasticmapreduce:GetBlockPublicAccessConfiguration",
                        "elasticmapreduce:ListClusters",
                        "elasticmapreduce:ListInstances",
                        "es:DescribeElasticsearchDomain",
                        "es:DescribeElasticsearchDomains",
                        "es:ListDomainNames",
                        "es:ListTags",
                        "guardduty:GetDetector",
                        "guardduty:GetFindings",
                        "guardduty:GetMasterAccount",
                        "guardduty:ListDetectors",
                        "guardduty:ListFindings",
                        "iam:GenerateCredentialReport",
                        "iam:GetAccountAuthorizationDetails",
                        "iam:GetAccountPasswordPolicy",
                        "iam:GetAccountSummary",
                        "iam:GetCredentialReport",
                        "iam:GetGroup",
                        "iam:GetGroupPolicy",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:GetUser",
                        "iam:GetUserPolicy",
                        "iam:ListAttachedGroupPolicies",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListAttachedUserPolicies",
                        "iam:ListEntitiesForPolicy",
                        "iam:ListGroupPolicies",
                        "iam:ListGroupsForUser",
                        "iam:ListInstanceProfilesForRole",
                        "iam:ListPolicyVersions",
                        "iam:ListRolePolicies",
                        "iam:ListUserPolicies",
                        "iam:ListVirtualMFADevices",
                        "kms:DescribeKey",
                        "kms:GetKeyPolicy",
                        "kms:GetKeyRotationStatus",
                        "kms:ListKeys",
                        "kms:ListResourceTags",
                        "lambda:GetAlias",
                        "lambda:GetFunction",
                        "lambda:GetPolicy",
                        "lambda:ListAliases",
                        "lambda:ListFunctions",
                        "logs:DescribeLogGroups",
                        "organizations:DescribeOrganization",
                        "rds:DescribeDBClusters",
                        "rds:DescribeDBClusterSnapshotAttributes",
                        "rds:DescribeDBClusterSnapshots",
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBSecurityGroups",
                        "rds:DescribeDBSnapshotAttributes",
                        "rds:DescribeDBSnapshots",
                        "rds:DescribeDBSubnetGroups",
                        "rds:DescribeEventSubscriptions",
                        "rds:ListTagsForResource",
                        "redshift:DescribeClusterParameterGroups",
                        "redshift:DescribeClusterParameters",
                        "redshift:DescribeClusterSecurityGroups",
                        "redshift:DescribeClusterSnapshots",
                        "redshift:DescribeClusterSubnetGroups",
                        "redshift:DescribeClusters",
                        "redshift:DescribeEventSubscriptions",
                        "redshift:DescribeLoggingStatus",
                        "s3:GetAccelerateConfiguration",
                        "s3:GetAccountPublicAccessBlock",
                        "s3:GetBucketAcl",
                        "s3:GetBucketCORS",
                        "s3:GetBucketLocation",
                        "s3:GetBucketLogging",
                        "s3:GetBucketNotification",
                        "s3:GetBucketObjectLockConfiguration",
                        "s3:GetBucketPolicy",
                        "s3:GetBucketPublicAccessBlock",
                        "s3:GetBucketRequestPayment",
                        "s3:GetBucketTagging",
                        "s3:GetBucketVersioning",
                        "s3:GetBucketWebsite",
                        "s3:GetEncryptionConfiguration",
                        "s3:GetLifecycleConfiguration",
                        "s3:GetObject",
                        "s3:GetReplicationConfiguration",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket",
                        "sagemaker:DescribeEndpointConfig",
                        "sagemaker:DescribeNotebookInstance",
                        "sagemaker:ListEndpointConfigs",
                        "sagemaker:ListNotebookInstances",
                        "secretsmanager:ListSecrets",
                        "secretsmanager:ListSecretVersionIds",
                        "securityhub:describeHub",
                        "shield:DescribeDRTAccess",
                        "shield:DescribeProtection",
                        "shield:DescribeSubscription",
                        "sns:GetTopicAttributes",
                        "sns:ListSubscriptions",
                        "sns:ListTagsForResource",
                        "sns:ListTopics",
                        "sqs:GetQueueAttributes",
                        "sqs:ListQueues",
                        "sqs:ListQueueTags",
                        "ssm:DescribeAutomationExecutions",
                        "ssm:DescribeDocument",
                        "ssm:GetAutomationExecution",
                        "ssm:GetDocument",
                        "storagegateway:ListGateways",
                        "storagegateway:ListVolumes",
                        "support:DescribeCases",
                        "tag:GetResources",
                        "waf:GetLoggingConfiguration",
                        "waf:GetWebACL",
                        "wafv2:GetLoggingConfiguration",
                        "waf-regional:GetLoggingConfiguration",
                        "waf-regional:GetWebACL",
                        "waf-regional:GetWebACLForResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIQRXRDRGJUA33ELIO",
        "PolicyName": "AWSConfigRole",
        "UpdateDate": "2021-01-29T19:22:20+00:00",
        "VersionId": "v36"
    },
    "AWSConfigRoleForOrganizations": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSConfigRoleForOrganizations",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-19T22:53:01+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:ListAccounts",
                        "organizations:DescribeOrganization",
                        "organizations:ListAWSServiceAccessForOrganization",
                        "organizations:ListDelegatedAdministrators"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIEHGYAUTHXSXZAW2E",
        "PolicyName": "AWSConfigRoleForOrganizations",
        "UpdateDate": "2020-11-24T20:19:13+00:00",
        "VersionId": "v2"
    },
    "AWSConfigRulesExecutionRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSConfigRulesExecutionRole",
        "AttachmentCount": 0,
        "CreateDate": "2016-03-25T17:59:36+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*/AWSLogs/*/Config/*"
                },
                {
                    "Action": [
                        "config:Put*",
                        "config:Get*",
                        "config:List*",
                        "config:Describe*",
                        "config:BatchGet*",
                        "config:Select*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJUB3KIKTA4PU4OYAA",
        "PolicyName": "AWSConfigRulesExecutionRole",
        "UpdateDate": "2019-05-13T21:33:30+00:00",
        "VersionId": "v3"
    },
    "AWSConfigServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSConfigServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-05-30T23:31:46+00:00",
        "DefaultVersionId": "v22",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm:DescribeCertificate",
                        "acm:ListCertificates",
                        "acm:ListTagsForCertificate",
                        "application-autoscaling:DescribeScalableTargets",
                        "application-autoscaling:DescribeScalingPolicies",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeLaunchConfigurations",
                        "autoscaling:DescribeLifecycleHooks",
                        "autoscaling:DescribePolicies",
                        "autoscaling:DescribeScheduledActions",
                        "autoscaling:DescribeTags",
                        "backup:ListBackupPlans",
                        "backup:ListBackupSelections",
                        "backup:GetBackupSelection",
                        "cloudfront:ListTagsForResource",
                        "cloudformation:describeType",
                        "cloudformation:listTypes",
                        "cloudtrail:DescribeTrails",
                        "cloudtrail:GetEventSelectors",
                        "cloudtrail:GetTrailStatus",
                        "cloudtrail:ListTags",
                        "cloudwatch:DescribeAlarms",
                        "codepipeline:GetPipeline",
                        "codepipeline:GetPipelineState",
                        "codepipeline:ListPipelines",
                        "config:BatchGet*",
                        "config:Describe*",
                        "config:Get*",
                        "config:List*",
                        "config:Put*",
                        "config:Select*",
                        "dax:DescribeClusters",
                        "dms:DescribeReplicationInstances",
                        "dynamodb:DescribeContinuousBackups",
                        "dynamodb:DescribeLimits",
                        "dynamodb:DescribeTable",
                        "dynamodb:ListTables",
                        "dynamodb:ListTagsOfResource",
                        "ec2:Describe*",
                        "ec2:GetEbsEncryptionByDefault",
                        "ecr:DescribeRepositories",
                        "ecr:GetLifecyclePolicy",
                        "ecr:GetRepositoryPolicy",
                        "ecr:ListTagsForResource",
                        "ecs:DescribeClusters",
                        "ecs:DescribeServices",
                        "ecs:DescribeTaskDefinition",
                        "ecs:DescribeTaskSets",
                        "ecs:ListClusters",
                        "ecs:ListServices",
                        "ecs:ListTagsForResource",
                        "ecs:ListTaskDefinitions",
                        "eks:DescribeCluster",
                        "eks:DescribeNodegroup",
                        "eks:ListClusters",
                        "eks:ListNodegroups",
                        "elasticache:DescribeCacheClusters",
                        "elasticache:DescribeReplicationGroups",
                        "elasticfilesystem:DescribeFileSystems",
                        "elasticfilesystem:DescribeLifecycleConfiguration",
                        "elasticfilesystem:DescribeMountTargets",
                        "elasticfilesystem:DescribeMountTargetSecurityGroups",
                        "elasticloadbalancing:DescribeListeners",
                        "elasticloadbalancing:DescribeLoadBalancerAttributes",
                        "elasticloadbalancing:DescribeLoadBalancerPolicies",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeRules",
                        "elasticloadbalancing:DescribeTags",
                        "elasticmapreduce:DescribeCluster",
                        "elasticmapreduce:DescribeSecurityConfiguration",
                        "elasticmapreduce:GetBlockPublicAccessConfiguration",
                        "elasticmapreduce:ListClusters",
                        "elasticmapreduce:ListInstances",
                        "es:DescribeElasticsearchDomain",
                        "es:DescribeElasticsearchDomains",
                        "es:ListDomainNames",
                        "es:ListTags",
                        "guardduty:GetDetector",
                        "guardduty:GetFindings",
                        "guardduty:GetMasterAccount",
                        "guardduty:ListDetectors",
                        "guardduty:ListFindings",
                        "iam:GenerateCredentialReport",
                        "iam:GetAccountAuthorizationDetails",
                        "iam:GetAccountPasswordPolicy",
                        "iam:GetAccountSummary",
                        "iam:GetCredentialReport",
                        "iam:GetGroup",
                        "iam:GetGroupPolicy",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:GetUser",
                        "iam:GetUserPolicy",
                        "iam:ListAttachedGroupPolicies",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListAttachedUserPolicies",
                        "iam:ListEntitiesForPolicy",
                        "iam:ListGroupPolicies",
                        "iam:ListGroupsForUser",
                        "iam:ListInstanceProfilesForRole",
                        "iam:ListPolicyVersions",
                        "iam:ListRolePolicies",
                        "iam:ListUserPolicies",
                        "iam:ListVirtualMFADevices",
                        "kms:DescribeKey",
                        "kms:GetKeyPolicy",
                        "kms:GetKeyRotationStatus",
                        "kms:ListKeys",
                        "kms:ListResourceTags",
                        "lambda:GetAlias",
                        "lambda:GetFunction",
                        "lambda:GetPolicy",
                        "lambda:ListAliases",
                        "lambda:ListFunctions",
                        "logs:DescribeLogGroups",
                        "organizations:DescribeOrganization",
                        "rds:DescribeDBClusters",
                        "rds:DescribeDBClusterSnapshotAttributes",
                        "rds:DescribeDBClusterSnapshots",
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBSecurityGroups",
                        "rds:DescribeDBSnapshotAttributes",
                        "rds:DescribeDBSnapshots",
                        "rds:DescribeDBSubnetGroups",
                        "rds:DescribeEventSubscriptions",
                        "rds:ListTagsForResource",
                        "redshift:DescribeClusterParameterGroups",
                        "redshift:DescribeClusterParameters",
                        "redshift:DescribeClusterSecurityGroups",
                        "redshift:DescribeClusterSnapshots",
                        "redshift:DescribeClusterSubnetGroups",
                        "redshift:DescribeClusters",
                        "redshift:DescribeEventSubscriptions",
                        "redshift:DescribeLoggingStatus",
                        "s3:GetAccelerateConfiguration",
                        "s3:GetAccountPublicAccessBlock",
                        "s3:GetBucketAcl",
                        "s3:GetBucketCORS",
                        "s3:GetBucketLocation",
                        "s3:GetBucketLogging",
                        "s3:GetBucketNotification",
                        "s3:GetBucketObjectLockConfiguration",
                        "s3:GetBucketPolicy",
                        "s3:GetBucketPublicAccessBlock",
                        "s3:GetBucketRequestPayment",
                        "s3:GetBucketTagging",
                        "s3:GetBucketVersioning",
                        "s3:GetBucketWebsite",
                        "s3:GetEncryptionConfiguration",
                        "s3:GetLifecycleConfiguration",
                        "s3:GetReplicationConfiguration",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket",
                        "sagemaker:DescribeEndpointConfig",
                        "sagemaker:DescribeNotebookInstance",
                        "sagemaker:ListEndpointConfigs",
                        "sagemaker:ListNotebookInstances",
                        "secretsmanager:ListSecrets",
                        "secretsmanager:ListSecretVersionIds",
                        "securityhub:describeHub",
                        "shield:DescribeDRTAccess",
                        "shield:DescribeProtection",
                        "shield:DescribeSubscription",
                        "sns:GetTopicAttributes",
                        "sns:ListSubscriptions",
                        "sns:ListTagsForResource",
                        "sns:ListTopics",
                        "sqs:GetQueueAttributes",
                        "sqs:ListQueues",
                        "sqs:ListQueueTags",
                        "ssm:DescribeAutomationExecutions",
                        "ssm:DescribeDocument",
                        "ssm:GetAutomationExecution",
                        "ssm:GetDocument",
                        "storagegateway:ListGateways",
                        "storagegateway:ListVolumes",
                        "support:DescribeCases",
                        "tag:GetResources",
                        "waf:GetLoggingConfiguration",
                        "waf:GetWebACL",
                        "wafv2:GetLoggingConfiguration",
                        "waf-regional:GetLoggingConfiguration",
                        "waf-regional:GetWebACL",
                        "waf-regional:GetWebACLForResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJUCWFHNZER665LLQQ",
        "PolicyName": "AWSConfigServiceRolePolicy",
        "UpdateDate": "2021-01-29T19:19:53+00:00",
        "VersionId": "v22"
    },
    "AWSConfigUserAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSConfigUserAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-18T19:38:41+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "config:Get*",
                        "config:Describe*",
                        "config:Deliver*",
                        "config:List*",
                        "config:Select*",
                        "tag:GetResources",
                        "tag:GetTagKeys",
                        "cloudtrail:DescribeTrails",
                        "cloudtrail:GetTrailStatus",
                        "cloudtrail:LookupEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIWTTSFJ7KKJE3MWGA",
        "PolicyName": "AWSConfigUserAccess",
        "UpdateDate": "2019-03-18T20:27:47+00:00",
        "VersionId": "v4"
    },
    "AWSConnector": {
        "Arn": "arn:aws:iam::aws:policy/AWSConnector",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-11T17:14:31+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": "iam:GetUser",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:CreateBucket",
                        "s3:DeleteBucket",
                        "s3:DeleteObject",
                        "s3:GetBucketLocation",
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:PutObject",
                        "s3:PutObjectAcl",
                        "s3:AbortMultipartUpload",
                        "s3:ListBucketMultipartUploads",
                        "s3:ListMultipartUploadParts"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::import-to-ec2-*"
                },
                {
                    "Action": [
                        "ec2:CancelConversionTask",
                        "ec2:CancelExportTask",
                        "ec2:CreateImage",
                        "ec2:CreateInstanceExportTask",
                        "ec2:CreateTags",
                        "ec2:CreateVolume",
                        "ec2:DeleteTags",
                        "ec2:DeleteVolume",
                        "ec2:DescribeConversionTasks",
                        "ec2:DescribeExportTasks",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstanceAttribute",
                        "ec2:DescribeInstanceStatus",
                        "ec2:DescribeInstances",
                        "ec2:DescribeRegions",
                        "ec2:DescribeTags",
                        "ec2:DetachVolume",
                        "ec2:ImportInstance",
                        "ec2:ImportVolume",
                        "ec2:ModifyInstanceAttribute",
                        "ec2:RunInstances",
                        "ec2:StartInstances",
                        "ec2:StopInstances",
                        "ec2:TerminateInstances",
                        "ec2:ImportImage",
                        "ec2:DescribeImportImageTasks",
                        "ec2:DeregisterImage",
                        "ec2:DescribeSnapshots",
                        "ec2:DeleteSnapshot",
                        "ec2:CancelImportTask",
                        "ec2:ImportSnapshot",
                        "ec2:DescribeImportSnapshotTasks"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "SNS:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:metrics-sns-topic-for-*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ6YATONJHICG3DJ3U",
        "PolicyName": "AWSConnector",
        "UpdateDate": "2015-09-28T19:50:38+00:00",
        "VersionId": "v3"
    },
    "AWSControlTowerServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSControlTowerServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-05-03T18:19:11+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:CreateStackInstances",
                        "cloudformation:CreateStackSet",
                        "cloudformation:DeleteStack",
                        "cloudformation:DeleteStackInstances",
                        "cloudformation:DeleteStackSet",
                        "cloudformation:DescribeStackInstance",
                        "cloudformation:DescribeStacks",
                        "cloudformation:DescribeStackSet",
                        "cloudformation:DescribeStackSetOperation",
                        "cloudformation:ListStackInstances",
                        "cloudformation:UpdateStack",
                        "cloudformation:UpdateStackInstances",
                        "cloudformation:UpdateStackSet"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:type/resource/AWS-IAM-Role"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:CreateStackInstances",
                        "cloudformation:CreateStackSet",
                        "cloudformation:DeleteStack",
                        "cloudformation:DeleteStackInstances",
                        "cloudformation:DeleteStackSet",
                        "cloudformation:DescribeStackInstance",
                        "cloudformation:DescribeStacks",
                        "cloudformation:DescribeStackSet",
                        "cloudformation:DescribeStackSetOperation",
                        "cloudformation:GetTemplate",
                        "cloudformation:ListStackInstances",
                        "cloudformation:UpdateStack",
                        "cloudformation:UpdateStackInstances",
                        "cloudformation:UpdateStackSet"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/AWSControlTower*/*",
                        "arn:aws:cloudformation:*:*:stack/StackSet-AWSControlTower*/*",
                        "arn:aws:cloudformation:*:*:stackset/AWSControlTower*:*",
                        "arn:aws:cloudformation:*:*:stackset-target/AWSControlTower*/*"
                    ]
                },
                {
                    "Action": [
                        "cloudtrail:CreateTrail",
                        "cloudtrail:DeleteTrail",
                        "cloudtrail:GetTrailStatus",
                        "cloudtrail:StartLogging",
                        "cloudtrail:StopLogging",
                        "cloudtrail:UpdateTrail",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                        "logs:PutRetentionPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:aws-controltower/CloudTrailLogs:*",
                        "arn:aws:cloudtrail:*:*:trail/aws-controltower*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-controltower*/*"
                    ]
                },
                {
                    "Action": [
                        "sts:AssumeRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSControlTowerExecution"
                    ]
                },
                {
                    "Action": [
                        "cloudtrail:DescribeTrails",
                        "ec2:DescribeAvailabilityZones",
                        "iam:ListRoles",
                        "logs:CreateLogGroup",
                        "logs:DescribeLogGroups",
                        "organizations:CreateAccount",
                        "organizations:DescribeAccount",
                        "organizations:DescribeCreateAccountStatus",
                        "organizations:DescribeOrganization",
                        "organizations:DescribeOrganizationalUnit",
                        "organizations:DescribePolicy",
                        "organizations:ListAccounts",
                        "organizations:ListAccountsForParent",
                        "organizations:ListAWSServiceAccessForOrganization",
                        "organizations:ListChildren",
                        "organizations:ListOrganizationalUnitsForParent",
                        "organizations:ListParents",
                        "organizations:ListPoliciesForTarget",
                        "organizations:ListTargetsForPolicy",
                        "organizations:ListRoots",
                        "organizations:MoveAccount",
                        "servicecatalog:AssociatePrincipalWithPortfolio"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "iam:GetUser",
                        "iam:ListAttachedRolePolicies",
                        "iam:GetRolePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/service-role/AWSControlTowerStackSetRole",
                        "arn:aws:iam::*:role/service-role/AWSControlTowerCloudTrailRole",
                        "arn:aws:iam::*:role/service-role/AWSControlTowerConfigAggregatorRoleForOrganizations"
                    ]
                },
                {
                    "Action": [
                        "config:DeleteConfigurationAggregator",
                        "config:PutConfigurationAggregator",
                        "config:TagResource"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:ResourceTag/aws-control-tower": "managed-by-control-tower"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "organizations:EnableAWSServiceAccess",
                    "Condition": {
                        "StringLike": {
                            "organizations:ServicePrincipal": "config.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MW35THVLF",
        "PolicyName": "AWSControlTowerServiceRolePolicy",
        "UpdateDate": "2020-11-10T21:08:05+00:00",
        "VersionId": "v6"
    },
    "AWSDataExchangeFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataExchangeFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-13T19:27:59+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dataexchange:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "s3:GetObject",
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "dataexchange.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*aws-data-exchange*"
                },
                {
                    "Action": "s3:GetObject",
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "dataexchange.amazonaws.com"
                            ]
                        },
                        "StringEqualsIgnoreCase": {
                            "s3:ExistingObjectTag/AWSDataExchange": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:PutObject",
                        "s3:PutObjectAcl"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "dataexchange.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*aws-data-exchange*"
                },
                {
                    "Action": [
                        "s3:GetBucketLocation",
                        "s3:ListBucket",
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:DescribeEntity",
                        "aws-marketplace:ListEntities",
                        "aws-marketplace:StartChangeSet",
                        "aws-marketplace:ListChangeSets",
                        "aws-marketplace:DescribeChangeSet",
                        "aws-marketplace:CancelChangeSet",
                        "aws-marketplace:GetAgreementApprovalRequest",
                        "aws-marketplace:ListAgreementApprovalRequests",
                        "aws-marketplace:AcceptAgreementApprovalRequest",
                        "aws-marketplace:RejectAgreementApprovalRequest",
                        "aws-marketplace:UpdateAgreementApprovalRequest"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:Subscribe",
                        "aws-marketplace:Unsubscribe",
                        "aws-marketplace:ViewSubscriptions",
                        "aws-marketplace:GetAgreementRequest",
                        "aws-marketplace:ListAgreementRequests",
                        "aws-marketplace:CancelAgreementRequest"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:DescribeKey",
                        "kms:ListAliases",
                        "kms:ListKeys"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MPDTDB3FH",
        "PolicyName": "AWSDataExchangeFullAccess",
        "UpdateDate": "2021-01-19T19:42:47+00:00",
        "VersionId": "v3"
    },
    "AWSDataExchangeProviderFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataExchangeProviderFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-13T19:27:55+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dataexchange:CreateDataSet",
                        "dataexchange:CreateRevision",
                        "dataexchange:CreateAsset",
                        "dataexchange:Get*",
                        "dataexchange:Update*",
                        "dataexchange:List*",
                        "dataexchange:Delete*",
                        "dataexchange:TagResource",
                        "dataexchange:UntagResource",
                        "tag:GetTagKeys",
                        "tag:GetTagValues"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dataexchange:CreateJob",
                        "dataexchange:StartJob",
                        "dataexchange:CancelJob"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "dataexchange:JobType": [
                                "IMPORT_ASSETS_FROM_S3",
                                "IMPORT_ASSET_FROM_SIGNED_URL",
                                "EXPORT_ASSETS_TO_S3",
                                "EXPORT_ASSET_TO_SIGNED_URL"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "s3:GetObject",
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "dataexchange.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*aws-data-exchange*"
                },
                {
                    "Action": "s3:GetObject",
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "dataexchange.amazonaws.com"
                            ]
                        },
                        "StringEqualsIgnoreCase": {
                            "s3:ExistingObjectTag/AWSDataExchange": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:PutObject",
                        "s3:PutObjectAcl"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "dataexchange.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*aws-data-exchange*"
                },
                {
                    "Action": [
                        "s3:GetBucketLocation",
                        "s3:ListBucket",
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:DescribeEntity",
                        "aws-marketplace:ListEntities",
                        "aws-marketplace:DescribeChangeSet",
                        "aws-marketplace:ListChangeSets",
                        "aws-marketplace:StartChangeSet",
                        "aws-marketplace:CancelChangeSet",
                        "aws-marketplace:GetAgreementApprovalRequest",
                        "aws-marketplace:ListAgreementApprovalRequests",
                        "aws-marketplace:AcceptAgreementApprovalRequest",
                        "aws-marketplace:RejectAgreementApprovalRequest",
                        "aws-marketplace:UpdateAgreementApprovalRequest"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:DescribeKey",
                        "kms:ListAliases",
                        "kms:ListKeys"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MQSUGZZPZ",
        "PolicyName": "AWSDataExchangeProviderFullAccess",
        "UpdateDate": "2021-01-14T21:20:09+00:00",
        "VersionId": "v5"
    },
    "AWSDataExchangeReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataExchangeReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-13T19:27:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dataexchange:Get*",
                        "dataexchange:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:ViewSubscriptions",
                        "aws-marketplace:GetAgreementRequest",
                        "aws-marketplace:ListAgreementRequests",
                        "aws-marketplace:GetAgreementApprovalRequest",
                        "aws-marketplace:ListAgreementApprovalRequests",
                        "aws-marketplace:DescribeEntity",
                        "aws-marketplace:ListEntities",
                        "aws-marketplace:DescribeChangeSet",
                        "aws-marketplace:ListChangeSets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4DQNFEZURI",
        "PolicyName": "AWSDataExchangeReadOnly",
        "UpdateDate": "2019-11-13T19:27:37+00:00",
        "VersionId": "v1"
    },
    "AWSDataExchangeSubscriberFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataExchangeSubscriberFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-13T19:27:52+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dataexchange:Get*",
                        "dataexchange:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dataexchange:CreateJob",
                        "dataexchange:StartJob",
                        "dataexchange:CancelJob"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "dataexchange:JobType": [
                                "EXPORT_ASSETS_TO_S3",
                                "EXPORT_ASSET_TO_SIGNED_URL",
                                "EXPORT_REVISIONS_TO_S3"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "s3:GetObject",
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:CalledVia": [
                                "dataexchange.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*aws-data-exchange*"
                },
                {
                    "Action": [
                        "s3:GetBucketLocation",
                        "s3:ListBucket",
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:Subscribe",
                        "aws-marketplace:Unsubscribe",
                        "aws-marketplace:ViewSubscriptions",
                        "aws-marketplace:GetAgreementRequest",
                        "aws-marketplace:ListAgreementRequests",
                        "aws-marketplace:CancelAgreementRequest"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:DescribeKey",
                        "kms:ListAliases",
                        "kms:ListKeys"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MAWRW4GF7",
        "PolicyName": "AWSDataExchangeSubscriberFullAccess",
        "UpdateDate": "2021-02-08T23:34:25+00:00",
        "VersionId": "v4"
    },
    "AWSDataLifecycleManagerServiceRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSDataLifecycleManagerServiceRole",
        "AttachmentCount": 0,
        "CreateDate": "2018-07-06T19:34:16+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CreateSnapshot",
                        "ec2:CreateSnapshots",
                        "ec2:DeleteSnapshot",
                        "ec2:DescribeInstances",
                        "ec2:DescribeVolumes",
                        "ec2:DescribeSnapshots",
                        "ec2:EnableFastSnapshotRestores",
                        "ec2:DescribeFastSnapshotRestores",
                        "ec2:DisableFastSnapshotRestores",
                        "ec2:CopySnapshot",
                        "ec2:ModifySnapshotAttribute",
                        "ec2:DescribeSnapshotAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::snapshot/*"
                },
                {
                    "Action": [
                        "events:PutRule",
                        "events:DeleteRule",
                        "events:DescribeRule",
                        "events:EnableRule",
                        "events:DisableRule",
                        "events:ListTargetsByRule",
                        "events:PutTargets",
                        "events:RemoveTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:events:*:*:rule/AwsDataLifecycleRule.managed-cwe.*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIZRLOKFUFE7YXQOJS",
        "PolicyName": "AWSDataLifecycleManagerServiceRole",
        "UpdateDate": "2020-12-11T18:15:06+00:00",
        "VersionId": "v6"
    },
    "AWSDataLifecycleManagerServiceRoleForAMIManagement": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSDataLifecycleManagerServiceRoleForAMIManagement",
        "AttachmentCount": 0,
        "CreateDate": "2020-10-21T19:39:41+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "ec2:CreateTags",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*::snapshot/*",
                        "arn:aws:ec2:*::image/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeImageAttribute",
                        "ec2:DescribeVolumes",
                        "ec2:DescribeSnapshots"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:DeleteSnapshot",
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::snapshot/*"
                },
                {
                    "Action": [
                        "ec2:ResetImageAttribute",
                        "ec2:DeregisterImage",
                        "ec2:CreateImage",
                        "ec2:CopyImage",
                        "ec2:ModifyImageAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MG6O7FWSP",
        "PolicyName": "AWSDataLifecycleManagerServiceRoleForAMIManagement",
        "UpdateDate": "2020-10-21T19:39:41+00:00",
        "VersionId": "v1"
    },
    "AWSDataPipelineRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSDataPipelineRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:24+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudwatch:*",
                        "datapipeline:DescribeObjects",
                        "datapipeline:EvaluateExpression",
                        "dynamodb:BatchGetItem",
                        "dynamodb:DescribeTable",
                        "dynamodb:GetItem",
                        "dynamodb:Query",
                        "dynamodb:Scan",
                        "dynamodb:UpdateTable",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CancelSpotInstanceRequests",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateTags",
                        "ec2:DeleteTags",
                        "ec2:Describe*",
                        "ec2:ModifyImageAttribute",
                        "ec2:ModifyInstanceAttribute",
                        "ec2:RequestSpotInstances",
                        "ec2:RunInstances",
                        "ec2:StartInstances",
                        "ec2:StopInstances",
                        "ec2:TerminateInstances",
                        "ec2:AuthorizeSecurityGroupEgress",
                        "ec2:DeleteSecurityGroup",
                        "ec2:RevokeSecurityGroupEgress",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:CreateNetworkInterface",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DetachNetworkInterface",
                        "elasticmapreduce:*",
                        "iam:GetInstanceProfile",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListRolePolicies",
                        "iam:ListInstanceProfiles",
                        "iam:PassRole",
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBSecurityGroups",
                        "redshift:DescribeClusters",
                        "redshift:DescribeClusterSecurityGroups",
                        "s3:CreateBucket",
                        "s3:DeleteObject",
                        "s3:Get*",
                        "s3:List*",
                        "s3:Put*",
                        "sdb:BatchPutAttributes",
                        "sdb:Select*",
                        "sns:GetTopicAttributes",
                        "sns:ListTopics",
                        "sns:Publish",
                        "sns:Subscribe",
                        "sns:Unsubscribe",
                        "sqs:CreateQueue",
                        "sqs:Delete*",
                        "sqs:GetQueue*",
                        "sqs:PurgeQueue",
                        "sqs:ReceiveMessage"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": [
                                "elasticmapreduce.amazonaws.com",
                                "spot.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIKCP6XS3ESGF4GLO2",
        "PolicyName": "AWSDataPipelineRole",
        "UpdateDate": "2017-12-22T23:43:28+00:00",
        "VersionId": "v6"
    },
    "AWSDataPipeline_FullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataPipeline_FullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-01-19T23:14:54+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:List*",
                        "dynamodb:DescribeTable",
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBSecurityGroups",
                        "redshift:DescribeClusters",
                        "redshift:DescribeClusterSecurityGroups",
                        "sns:ListTopics",
                        "sns:Subscribe",
                        "iam:ListRoles",
                        "iam:GetRolePolicy",
                        "iam:GetInstanceProfile",
                        "iam:ListInstanceProfiles",
                        "datapipeline:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "iam:PassRole",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/DataPipelineDefaultResourceRole",
                        "arn:aws:iam::*:role/DataPipelineDefaultRole"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIXOFIG7RSBMRPHXJ4",
        "PolicyName": "AWSDataPipeline_FullAccess",
        "UpdateDate": "2017-08-17T18:48:39+00:00",
        "VersionId": "v2"
    },
    "AWSDataPipeline_PowerUser": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataPipeline_PowerUser",
        "AttachmentCount": 0,
        "CreateDate": "2017-01-19T23:16:46+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:List*",
                        "dynamodb:DescribeTable",
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBSecurityGroups",
                        "redshift:DescribeClusters",
                        "redshift:DescribeClusterSecurityGroups",
                        "sns:ListTopics",
                        "iam:ListRoles",
                        "iam:GetRolePolicy",
                        "iam:GetInstanceProfile",
                        "iam:ListInstanceProfiles",
                        "datapipeline:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "iam:PassRole",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/DataPipelineDefaultResourceRole",
                        "arn:aws:iam::*:role/DataPipelineDefaultRole"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIMXGLVY6DVR24VTYS",
        "PolicyName": "AWSDataPipeline_PowerUser",
        "UpdateDate": "2017-08-17T18:49:42+00:00",
        "VersionId": "v2"
    },
    "AWSDataSyncFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataSyncFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-01-18T19:40:36+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "datasync:*",
                        "ec2:CreateNetworkInterface",
                        "ec2:CreateNetworkInterfacePermission",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:ModifyNetworkInterfaceAttribute",
                        "fsx:DescribeFileSystems",
                        "elasticfilesystem:DescribeFileSystems",
                        "elasticfilesystem:DescribeMountTargets",
                        "iam:GetRole",
                        "iam:ListRoles",
                        "logs:CreateLogGroup",
                        "logs:DescribeLogGroups",
                        "logs:DescribeResourcePolicies",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "datasync.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJGOHCDUQULZJKDGT4",
        "PolicyName": "AWSDataSyncFullAccess",
        "UpdateDate": "2020-06-30T17:58:58+00:00",
        "VersionId": "v3"
    },
    "AWSDataSyncReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDataSyncReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-01-18T19:18:44+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "datasync:Describe*",
                        "datasync:List*",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "elasticfilesystem:DescribeFileSystems",
                        "elasticfilesystem:DescribeMountTargets",
                        "fsx:DescribeFileSystems",
                        "iam:GetRole",
                        "iam:ListRoles",
                        "logs:DescribeLogGroups",
                        "logs:DescribeResourcePolicies",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJRYVEZEDR7ZEAGYLY",
        "PolicyName": "AWSDataSyncReadOnlyAccess",
        "UpdateDate": "2020-06-30T17:59:22+00:00",
        "VersionId": "v3"
    },
    "AWSDeepLensLambdaFunctionAccessPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSDeepLensLambdaFunctionAccessPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-29T15:47:18+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:ListBucket",
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::deeplens*/*",
                        "arn:aws:s3:::deeplens*"
                    ],
                    "Sid": "DeepLensS3ObjectAccess"
                },
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:PutLogEvents",
                        "logs:CreateLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/greengrass/*",
                    "Sid": "DeepLensGreenGrassCloudWatchAccess"
                },
                {
                    "Action": [
                        "deeplens:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensAccess"
                },
                {
                    "Action": [
                        "kinesisvideo:DescribeStream",
                        "kinesisvideo:CreateStream",
                        "kinesisvideo:GetDataEndpoint",
                        "kinesisvideo:PutMedia"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensKinesisVideoAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIKIEE4PRM54V4G3ZG",
        "PolicyName": "AWSDeepLensLambdaFunctionAccessPolicy",
        "UpdateDate": "2019-06-11T23:11:55+00:00",
        "VersionId": "v4"
    },
    "AWSDeepLensServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSDeepLensServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-29T15:46:36+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:CreateThing",
                        "iot:DeleteThing",
                        "iot:DeleteThingShadow",
                        "iot:DescribeThing",
                        "iot:GetThingShadow",
                        "iot:UpdateThing",
                        "iot:UpdateThingShadow"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/deeplens*"
                    ],
                    "Sid": "DeepLensIoTThingAccess"
                },
                {
                    "Action": [
                        "iot:AttachThingPrincipal",
                        "iot:DetachThingPrincipal",
                        "iot:UpdateCertificate",
                        "iot:DeleteCertificate",
                        "iot:DetachPrincipalPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/deeplens*",
                        "arn:aws:iot:*:*:cert/*"
                    ],
                    "Sid": "DeepLensIoTCertificateAccess"
                },
                {
                    "Action": [
                        "iot:CreateKeysAndCertificate",
                        "iot:CreatePolicy",
                        "iot:CreatePolicyVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensIoTCreateCertificateAndPolicyAccess"
                },
                {
                    "Action": [
                        "iot:AttachPrincipalPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:policy/deeplens*",
                        "arn:aws:iot:*:*:cert/*"
                    ],
                    "Sid": "DeepLensIoTAttachCertificatePolicyAccess"
                },
                {
                    "Action": [
                        "iot:GetThingShadow",
                        "iot:UpdateThingShadow"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/deeplens*"
                    ],
                    "Sid": "DeepLensIoTDataAccess"
                },
                {
                    "Action": [
                        "iot:DescribeEndpoint"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensIoTEndpointAccess"
                },
                {
                    "Action": [
                        "deeplens:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensAccess"
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::deeplens*"
                    ],
                    "Sid": "DeepLensS3ObjectAccess"
                },
                {
                    "Action": [
                        "s3:DeleteBucket",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::deeplens*"
                    ],
                    "Sid": "DeepLensS3Buckets"
                },
                {
                    "Action": [
                        "s3:CreateBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensCreateS3Buckets"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "greengrass.amazonaws.com",
                                "sagemaker.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensIAMPassRoleAccess"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEqualsIfExists": {
                            "iam:PassedToService": "lambda.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSDeepLens*",
                        "arn:aws:iam::*:role/service-role/AWSDeepLens*"
                    ],
                    "Sid": "DeepLensIAMLambdaPassRoleAccess"
                },
                {
                    "Action": [
                        "greengrass:AssociateRoleToGroup",
                        "greengrass:AssociateServiceRoleToAccount",
                        "greengrass:CreateResourceDefinition",
                        "greengrass:CreateResourceDefinitionVersion",
                        "greengrass:CreateCoreDefinition",
                        "greengrass:CreateCoreDefinitionVersion",
                        "greengrass:CreateDeployment",
                        "greengrass:CreateFunctionDefinition",
                        "greengrass:CreateFunctionDefinitionVersion",
                        "greengrass:CreateGroup",
                        "greengrass:CreateGroupCertificateAuthority",
                        "greengrass:CreateGroupVersion",
                        "greengrass:CreateLoggerDefinition",
                        "greengrass:CreateLoggerDefinitionVersion",
                        "greengrass:CreateSubscriptionDefinition",
                        "greengrass:CreateSubscriptionDefinitionVersion",
                        "greengrass:DeleteCoreDefinition",
                        "greengrass:DeleteFunctionDefinition",
                        "greengrass:DeleteGroup",
                        "greengrass:DeleteLoggerDefinition",
                        "greengrass:DeleteSubscriptionDefinition",
                        "greengrass:DisassociateRoleFromGroup",
                        "greengrass:DisassociateServiceRoleFromAccount",
                        "greengrass:GetAssociatedRole",
                        "greengrass:GetConnectivityInfo",
                        "greengrass:GetCoreDefinition",
                        "greengrass:GetCoreDefinitionVersion",
                        "greengrass:GetDeploymentStatus",
                        "greengrass:GetDeviceDefinition",
                        "greengrass:GetDeviceDefinitionVersion",
                        "greengrass:GetFunctionDefinition",
                        "greengrass:GetFunctionDefinitionVersion",
                        "greengrass:GetGroup",
                        "greengrass:GetGroupCertificateAuthority",
                        "greengrass:GetGroupCertificateConfiguration",
                        "greengrass:GetGroupVersion",
                        "greengrass:GetLoggerDefinition",
                        "greengrass:GetLoggerDefinitionVersion",
                        "greengrass:GetResourceDefinition",
                        "greengrass:GetServiceRoleForAccount",
                        "greengrass:GetSubscriptionDefinition",
                        "greengrass:GetSubscriptionDefinitionVersion",
                        "greengrass:ListCoreDefinitionVersions",
                        "greengrass:ListCoreDefinitions",
                        "greengrass:ListDeployments",
                        "greengrass:ListDeviceDefinitionVersions",
                        "greengrass:ListDeviceDefinitions",
                        "greengrass:ListFunctionDefinitionVersions",
                        "greengrass:ListFunctionDefinitions",
                        "greengrass:ListGroupCertificateAuthorities",
                        "greengrass:ListGroupVersions",
                        "greengrass:ListGroups",
                        "greengrass:ListLoggerDefinitionVersions",
                        "greengrass:ListLoggerDefinitions",
                        "greengrass:ListSubscriptionDefinitionVersions",
                        "greengrass:ListSubscriptionDefinitions",
                        "greengrass:ResetDeployments",
                        "greengrass:UpdateConnectivityInfo",
                        "greengrass:UpdateCoreDefinition",
                        "greengrass:UpdateDeviceDefinition",
                        "greengrass:UpdateFunctionDefinition",
                        "greengrass:UpdateGroup",
                        "greengrass:UpdateGroupCertificateConfiguration",
                        "greengrass:UpdateLoggerDefinition",
                        "greengrass:UpdateSubscriptionDefinition",
                        "greengrass:UpdateResourceDefinition"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensGreenGrassAccess"
                },
                {
                    "Action": [
                        "lambda:CreateFunction",
                        "lambda:DeleteFunction",
                        "lambda:GetFunction",
                        "lambda:GetFunctionConfiguration",
                        "lambda:ListFunctions",
                        "lambda:ListVersionsByFunction",
                        "lambda:PublishVersion",
                        "lambda:UpdateFunctionCode",
                        "lambda:UpdateFunctionConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:deeplens*"
                    ],
                    "Sid": "DeepLensLambdaAdminFunctionAccess"
                },
                {
                    "Action": [
                        "lambda:GetFunction",
                        "lambda:GetFunctionConfiguration",
                        "lambda:ListFunctions",
                        "lambda:ListVersionsByFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:*"
                    ],
                    "Sid": "DeepLensLambdaUsersFunctionAccess"
                },
                {
                    "Action": [
                        "sagemaker:CreateTrainingJob",
                        "sagemaker:DescribeTrainingJob",
                        "sagemaker:StopTrainingJob"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sagemaker:*:*:training-job/deeplens*"
                    ],
                    "Sid": "DeepLensSageMakerWriteAccess"
                },
                {
                    "Action": [
                        "sagemaker:DescribeTrainingJob"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sagemaker:*:*:training-job/*"
                    ],
                    "Sid": "DeepLensSageMakerReadAccess"
                },
                {
                    "Action": [
                        "kinesisvideo:CreateStream",
                        "kinesisvideo:DescribeStream",
                        "kinesisvideo:DeleteStream"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:kinesisvideo:*:*:stream/deeplens*/*"
                    ],
                    "Sid": "DeepLensKinesisVideoStreamAccess"
                },
                {
                    "Action": [
                        "kinesisvideo:GetDataEndpoint"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "DeepLensKinesisVideoEndpointAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJK2Z2S7FPJFCYGR72",
        "PolicyName": "AWSDeepLensServiceRolePolicy",
        "UpdateDate": "2019-09-25T19:25:06+00:00",
        "VersionId": "v6"
    },
    "AWSDeepRacerCloudFormationAccessPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSDeepRacerCloudFormationAccessPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-02-28T21:59:49+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:AllocateAddress",
                        "ec2:AttachInternetGateway",
                        "ec2:AssociateRouteTable",
                        "ec2:AuthorizeSecurityGroupEgress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CreateInternetGateway",
                        "ec2:CreateNatGateway",
                        "ec2:CreateNetworkAcl",
                        "ec2:CreateNetworkAclEntry",
                        "ec2:CreateRoute",
                        "ec2:CreateRouteTable",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateSubnet",
                        "ec2:CreateTags",
                        "ec2:CreateVpc",
                        "ec2:CreateVpcEndpoint",
                        "ec2:DeleteInternetGateway",
                        "ec2:DeleteNatGateway",
                        "ec2:DeleteNetworkAcl",
                        "ec2:DeleteNetworkAclEntry",
                        "ec2:DeleteRoute",
                        "ec2:DeleteRouteTable",
                        "ec2:DeleteSecurityGroup",
                        "ec2:DeleteSubnet",
                        "ec2:DeleteTags",
                        "ec2:DeleteVpc",
                        "ec2:DeleteVpcEndpoints",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeInternetGateways",
                        "ec2:DescribeNatGateways",
                        "ec2:DescribeNetworkAcls",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeTags",
                        "ec2:DescribeVpcEndpoints",
                        "ec2:DescribeVpcs",
                        "ec2:DetachInternetGateway",
                        "ec2:DisassociateRouteTable",
                        "ec2:ModifySubnetAttribute",
                        "ec2:ModifyVpcAttribute",
                        "ec2:ReleaseAddress",
                        "ec2:ReplaceNetworkAclAssociation",
                        "ec2:RevokeSecurityGroupEgress",
                        "ec2:RevokeSecurityGroupIngress"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLikeIfExists": {
                            "iam:PassedToService": "lambda.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/service-role/AWSDeepRacerLambdaAccessRole"
                },
                {
                    "Action": [
                        "lambda:CreateFunction",
                        "lambda:GetFunction",
                        "lambda:DeleteFunction",
                        "lambda:TagResource",
                        "lambda:UpdateFunctionCode"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:*DeepRacer*",
                        "arn:aws:lambda:*:*:function:*Deepracer*",
                        "arn:aws:lambda:*:*:function:*deepracer*"
                    ]
                },
                {
                    "Action": [
                        "s3:PutBucketPolicy",
                        "s3:CreateBucket",
                        "s3:ListBucket",
                        "s3:GetBucketAcl",
                        "s3:DeleteBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*DeepRacer*",
                        "arn:aws:s3:::*Deepracer*",
                        "arn:aws:s3:::*deepracer*"
                    ]
                },
                {
                    "Action": [
                        "robomaker:CreateSimulationApplication",
                        "robomaker:CreateSimulationApplicationVersion",
                        "robomaker:DeleteSimulationApplication",
                        "robomaker:DescribeSimulationApplication",
                        "robomaker:ListSimulationApplications",
                        "robomaker:TagResource",
                        "robomaker:UpdateSimulationApplication"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:robomaker:*:*:/createSimulationApplication",
                        "arn:aws:robomaker:*:*:simulation-application/deepracer*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJYG7FM75UF5CW5ICS",
        "PolicyName": "AWSDeepRacerCloudFormationAccessPolicy",
        "UpdateDate": "2019-06-14T17:02:04+00:00",
        "VersionId": "v2"
    },
    "AWSDeepRacerFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDeepRacerFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-10-05T22:03:10+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:DeleteObject",
                        "s3:DeleteObjectVersion",
                        "s3:GetBucketPolicy",
                        "s3:PutBucketPolicy",
                        "s3:ListBucket",
                        "s3:GetBucketAcl",
                        "s3:GetObject",
                        "s3:GetObjectVersion",
                        "s3:GetObjectAcl",
                        "s3:GetBucketLocation"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*DeepRacer*",
                        "arn:aws:s3:::*Deepracer*",
                        "arn:aws:s3:::*deepracer*",
                        "arn:aws:s3:::dr-*",
                        "arn:aws:s3:::*DeepRacer*/*",
                        "arn:aws:s3:::*Deepracer*/*",
                        "arn:aws:s3:::*deepracer*/*",
                        "arn:aws:s3:::dr-*/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4JFTOPTVBM",
        "PolicyName": "AWSDeepRacerFullAccess",
        "UpdateDate": "2020-10-05T22:03:10+00:00",
        "VersionId": "v1"
    },
    "AWSDeepRacerRoboMakerAccessPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSDeepRacerRoboMakerAccessPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-02-28T21:59:58+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "robomaker:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloudwatch:PutMetricData",
                        "ec2:CreateNetworkInterfacePermission",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeVpcs"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/aws/robomaker/SimulationJobs",
                        "arn:aws:logs:*:*:log-group:/aws/robomaker/SimulationJobs:log-stream:*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetBucketLocation",
                        "s3:ListBucket",
                        "s3:ListAllMyBuckets",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*DeepRacer*",
                        "arn:aws:s3:::*Deepracer*",
                        "arn:aws:s3:::*deepracer*",
                        "arn:aws:s3:::dr-*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Condition": {
                        "StringEqualsIgnoreCase": {
                            "s3:ExistingObjectTag/DeepRacer": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kinesisvideo:CreateStream",
                        "kinesisvideo:DescribeStream",
                        "kinesisvideo:GetDataEndpoint",
                        "kinesisvideo:PutMedia",
                        "kinesisvideo:TagStream"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:kinesisvideo:*:*:stream/dr-*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIUKGYRTDCUFOMRGAM",
        "PolicyName": "AWSDeepRacerRoboMakerAccessPolicy",
        "UpdateDate": "2019-02-28T21:59:58+00:00",
        "VersionId": "v1"
    },
    "AWSDeepRacerServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSDeepRacerServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-02-28T21:58:09+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "deepracer:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "robomaker:*",
                        "sagemaker:*",
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "cloudformation:ListStackResources",
                        "cloudformation:DescribeStacks",
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:DescribeStackResource",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DetectStackDrift",
                        "cloudformation:DescribeStackDriftDetectionStatus",
                        "cloudformation:DescribeStackResourceDrifts"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "robomaker.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSDeepRacer*",
                        "arn:aws:iam::*:role/service-role/AWSDeepRacer*"
                    ]
                },
                {
                    "Action": [
                        "cloudwatch:GetMetricData",
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:GetLogEvents",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "lambda:CreateFunction",
                        "lambda:DeleteFunction",
                        "lambda:GetFunction",
                        "lambda:InvokeFunction",
                        "lambda:UpdateFunctionCode"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:*DeepRacer*",
                        "arn:aws:lambda:*:*:function:*Deepracer*",
                        "arn:aws:lambda:*:*:function:*deepracer*",
                        "arn:aws:lambda:*:*:function:*dr-*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetBucketLocation",
                        "s3:DeleteObject",
                        "s3:ListBucket",
                        "s3:PutObject",
                        "s3:PutBucketPolicy",
                        "s3:GetBucketAcl"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*DeepRacer*",
                        "arn:aws:s3:::*Deepracer*",
                        "arn:aws:s3:::*deepracer*",
                        "arn:aws:s3:::dr-*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Condition": {
                        "StringEqualsIgnoreCase": {
                            "s3:ExistingObjectTag/DeepRacer": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kinesisvideo:CreateStream",
                        "kinesisvideo:DeleteStream",
                        "kinesisvideo:DescribeStream",
                        "kinesisvideo:GetDataEndpoint",
                        "kinesisvideo:GetHLSStreamingSessionURL",
                        "kinesisvideo:GetMedia",
                        "kinesisvideo:PutMedia",
                        "kinesisvideo:TagStream"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:kinesisvideo:*:*:stream/dr-*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJTUAQLIAVBJ7LZ32S",
        "PolicyName": "AWSDeepRacerServiceRolePolicy",
        "UpdateDate": "2019-06-12T20:55:34+00:00",
        "VersionId": "v3"
    },
    "AWSDenyAll": {
        "Arn": "arn:aws:iam::aws:policy/AWSDenyAll",
        "AttachmentCount": 0,
        "CreateDate": "2019-05-01T22:36:14+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "*"
                    ],
                    "Effect": "Deny",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4P43IUQ5E5",
        "PolicyName": "AWSDenyAll",
        "UpdateDate": "2019-05-01T22:36:14+00:00",
        "VersionId": "v1"
    },
    "AWSDeviceFarmFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDeviceFarmFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-07-13T16:37:38+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "devicefarm:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJO7KEDP4VYJPNT5UW",
        "PolicyName": "AWSDeviceFarmFullAccess",
        "UpdateDate": "2015-07-13T16:37:38+00:00",
        "VersionId": "v1"
    },
    "AWSDirectConnectFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDirectConnectFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:07+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "directconnect:*",
                        "ec2:DescribeVpnGateways",
                        "ec2:DescribeTransitGateways"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQF2QKZSK74KTIHOW",
        "PolicyName": "AWSDirectConnectFullAccess",
        "UpdateDate": "2019-04-30T15:29:29+00:00",
        "VersionId": "v3"
    },
    "AWSDirectConnectReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDirectConnectReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:08+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "directconnect:Describe*",
                        "directconnect:List*",
                        "ec2:DescribeVpnGateways",
                        "ec2:DescribeTransitGateways"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI23HZ27SI6FQMGNQ2",
        "PolicyName": "AWSDirectConnectReadOnlyAccess",
        "UpdateDate": "2020-05-18T18:48:22+00:00",
        "VersionId": "v4"
    },
    "AWSDirectConnectServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSDirectConnectServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2021-01-14T18:35:27+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "secretsmanager:DescribeSecret",
                        "secretsmanager:ListSecretVersionIds",
                        "secretsmanager:GetSecretValue"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:secretsmanager:*:*:secret:*directconnect*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4O7743JCTQ",
        "PolicyName": "AWSDirectConnectServiceRolePolicy",
        "UpdateDate": "2021-01-14T18:35:27+00:00",
        "VersionId": "v1"
    },
    "AWSDirectoryServiceFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDirectoryServiceFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:11+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ds:*",
                        "ec2:AuthorizeSecurityGroupEgress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CreateNetworkInterface",
                        "ec2:CreateSecurityGroup",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DeleteSecurityGroup",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:RevokeSecurityGroupEgress",
                        "ec2:RevokeSecurityGroupIngress",
                        "ec2:DescribeSecurityGroups",
                        "sns:GetTopicAttributes",
                        "sns:ListSubscriptions",
                        "sns:ListSubscriptionsByTopic",
                        "sns:ListTopics",
                        "iam:ListRoles",
                        "organizations:ListAccountsForParent",
                        "organizations:ListRoots",
                        "organizations:ListAccounts",
                        "organizations:DescribeOrganization",
                        "organizations:DescribeAccount",
                        "organizations:ListOrganizationalUnitsForParent",
                        "organizations:ListAWSServiceAccessForOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:DeleteTopic",
                        "sns:SetTopicAttributes",
                        "sns:Subscribe",
                        "sns:Unsubscribe"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:DirectoryMonitoring*"
                },
                {
                    "Action": [
                        "organizations:EnableAWSServiceAccess",
                        "organizations:DisableAWSServiceAccess"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "organizations:ServicePrincipal": "ds.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:security-group/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAINAW5ANUWTH3R4ANI",
        "PolicyName": "AWSDirectoryServiceFullAccess",
        "UpdateDate": "2020-11-24T23:24:10+00:00",
        "VersionId": "v5"
    },
    "AWSDirectoryServiceReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSDirectoryServiceReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:12+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ds:Check*",
                        "ds:Describe*",
                        "ds:Get*",
                        "ds:List*",
                        "ds:Verify*",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "sns:ListTopics",
                        "sns:GetTopicAttributes",
                        "sns:ListSubscriptions",
                        "sns:ListSubscriptionsByTopic",
                        "organizations:DescribeAccount",
                        "organizations:DescribeOrganization",
                        "organizations:ListAWSServiceAccessForOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIHWYO6WSDNCG64M2W",
        "PolicyName": "AWSDirectoryServiceReadOnlyAccess",
        "UpdateDate": "2018-09-25T21:54:01+00:00",
        "VersionId": "v4"
    },
    "AWSDiscoveryContinuousExportFirehosePolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSDiscoveryContinuousExportFirehosePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-08-09T18:29:39+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:GetTableVersions"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:AbortMultipartUpload",
                        "s3:GetBucketLocation",
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:ListBucketMultipartUploads",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-application-discovery-service-*",
                        "arn:aws:s3:::aws-application-discovery-service-*/*"
                    ]
                },
                {
                    "Action": [
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/aws/application-discovery-service/firehose:log-stream:*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIX6FHUTEUNXYDFZ7C",
        "PolicyName": "AWSDiscoveryContinuousExportFirehosePolicy",
        "UpdateDate": "2018-08-09T18:29:39+00:00",
        "VersionId": "v1"
    },
    "AWSEC2FleetServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSEC2FleetServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-21T00:08:55+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeImages",
                        "ec2:DescribeSubnets",
                        "ec2:RequestSpotInstances",
                        "ec2:DescribeInstanceStatus",
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "spot.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "EC2SpotManagement"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ec2.amazonaws.com.cn"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*",
                        "arn:aws:ec2:*:*:spot-instances-request/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:CreateAction": "RunInstances"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:volume/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:ec2:fleet-id": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJCL355O4TC27CPKVC",
        "PolicyName": "AWSEC2FleetServiceRolePolicy",
        "UpdateDate": "2020-05-04T20:10:31+00:00",
        "VersionId": "v3"
    },
    "AWSEC2SpotFleetServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSEC2SpotFleetServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-23T19:13:06+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeImages",
                        "ec2:DescribeSubnets",
                        "ec2:RequestSpotInstances",
                        "ec2:DescribeInstanceStatus",
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ec2.amazonaws.com.cn"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*",
                        "arn:aws:ec2:*:*:spot-instances-request/*",
                        "arn:aws:ec2:*:*:spot-fleet-request/*",
                        "arn:aws:ec2:*:*:volume/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:ec2spot:fleet-request-id": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "elasticloadbalancing:RegisterInstancesWithLoadBalancer"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:elasticloadbalancing:*:*:loadbalancer/*"
                    ]
                },
                {
                    "Action": [
                        "elasticloadbalancing:RegisterTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:elasticloadbalancing:*:*:*/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAILWCVTZD57EMYWMBO",
        "PolicyName": "AWSEC2SpotFleetServiceRolePolicy",
        "UpdateDate": "2020-03-16T19:16:21+00:00",
        "VersionId": "v4"
    },
    "AWSEC2SpotServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSEC2SpotServiceRolePolicy",
        "AttachmentCount": 1,
        "CreateDate": "2017-09-18T18:51:54+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeInstances",
                        "ec2:StartInstances",
                        "ec2:StopInstances",
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Condition": {
                        "StringNotEquals": {
                            "ec2:InstanceMarketType": "spot"
                        }
                    },
                    "Effect": "Deny",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ec2.amazonaws.com.cn"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:CreateAction": "RunInstances"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIZJJBQNXQYVKTEXGM",
        "PolicyName": "AWSEC2SpotServiceRolePolicy",
        "UpdateDate": "2018-12-12T00:13:51+00:00",
        "VersionId": "v4"
    },
    "AWSElasticBeanstalkCustomPlatformforEC2Role": {
        "Arn": "arn:aws:iam::aws:policy/AWSElasticBeanstalkCustomPlatformforEC2Role",
        "AttachmentCount": 0,
        "CreateDate": "2017-02-21T22:50:30+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:AttachVolume",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CopyImage",
                        "ec2:CreateImage",
                        "ec2:CreateKeypair",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateSnapshot",
                        "ec2:CreateTags",
                        "ec2:CreateVolume",
                        "ec2:DeleteKeypair",
                        "ec2:DeleteSecurityGroup",
                        "ec2:DeleteSnapshot",
                        "ec2:DeleteVolume",
                        "ec2:DeregisterImage",
                        "ec2:DescribeImageAttribute",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeRegions",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeTags",
                        "ec2:DescribeVolumes",
                        "ec2:DetachVolume",
                        "ec2:GetPasswordData",
                        "ec2:ModifyImageAttribute",
                        "ec2:ModifyInstanceAttribute",
                        "ec2:ModifySnapshotAttribute",
                        "ec2:RegisterImage",
                        "ec2:RunInstances",
                        "ec2:StopInstances",
                        "ec2:TerminateInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "EC2Access"
                },
                {
                    "Action": [
                        "s3:Get*",
                        "s3:List*",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::elasticbeanstalk-*",
                        "arn:aws:s3:::elasticbeanstalk-*/*"
                    ],
                    "Sid": "BucketAccess"
                },
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                        "logs:DescribeLogStreams"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/platform/*",
                    "Sid": "CloudWatchLogsAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJRVFXSS6LEIQGBKDY",
        "PolicyName": "AWSElasticBeanstalkCustomPlatformforEC2Role",
        "UpdateDate": "2017-02-21T22:50:30+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkEnhancedHealth": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkEnhancedHealth",
        "AttachmentCount": 0,
        "CreateDate": "2016-02-08T23:17:27+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeTargetHealth",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceStatus",
                        "ec2:GetConsoleOutput",
                        "ec2:AssociateAddress",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeSecurityGroups",
                        "sqs:GetQueueAttributes",
                        "sqs:GetQueueUrl",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeAutoScalingInstances",
                        "autoscaling:DescribeScalingActivities",
                        "autoscaling:DescribeNotificationConfigurations",
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "logs:DescribeLogStreams",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*:log-stream:*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIH5EFJNMOGUUTKLFE",
        "PolicyName": "AWSElasticBeanstalkEnhancedHealth",
        "UpdateDate": "2018-04-09T22:12:53+00:00",
        "VersionId": "v4"
    },
    "AWSElasticBeanstalkFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSElasticBeanstalkFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:18+00:00",
        "DefaultVersionId": "v8",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "elasticbeanstalk:*",
                        "ec2:*",
                        "ecs:*",
                        "ecr:*",
                        "elasticloadbalancing:*",
                        "autoscaling:*",
                        "cloudwatch:*",
                        "s3:*",
                        "sns:*",
                        "cloudformation:*",
                        "dynamodb:*",
                        "rds:*",
                        "sqs:*",
                        "logs:*",
                        "iam:GetPolicyVersion",
                        "iam:GetRole",
                        "iam:PassRole",
                        "iam:ListRolePolicies",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListInstanceProfiles",
                        "iam:ListRoles",
                        "iam:ListServerCertificates",
                        "acm:DescribeCertificate",
                        "acm:ListCertificates",
                        "codebuild:CreateProject",
                        "codebuild:DeleteProject",
                        "codebuild:BatchGetBuilds",
                        "codebuild:StartBuild"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:AddRoleToInstanceProfile",
                        "iam:CreateInstanceProfile",
                        "iam:CreateRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-elasticbeanstalk*",
                        "arn:aws:iam::*:instance-profile/aws-elasticbeanstalk*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "autoscaling.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/autoscaling.amazonaws.com/AWSServiceRoleForAutoScaling*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "elasticbeanstalk.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "elasticloadbalancing.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/elasticloadbalancing.amazonaws.com/AWSServiceRoleForElasticLoadBalancing*"
                    ]
                },
                {
                    "Action": [
                        "iam:AttachRolePolicy"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PolicyArn": [
                                "arn:aws:iam::aws:policy/AWSElasticBeanstalk*",
                                "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalk*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-elasticbeanstalk*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIZYX2YLLBW2LJVUFW",
        "PolicyName": "AWSElasticBeanstalkFullAccess",
        "UpdateDate": "2019-07-10T19:27:59+00:00",
        "VersionId": "v8"
    },
    "AWSElasticBeanstalkMaintenance": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSElasticBeanstalkMaintenance",
        "AttachmentCount": 0,
        "CreateDate": "2019-01-11T23:22:52+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:CreateChangeSet",
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:ExecuteChangeSet",
                        "cloudformation:DeleteChangeSet",
                        "cloudformation:ListChangeSets",
                        "cloudformation:DescribeStacks"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/awseb-*",
                        "arn:aws:cloudformation:*:*:stack/eb-*"
                    ],
                    "Sid": "AllowCloudformationChangeSetOperationsOnElasticBeanstalkStacks"
                },
                {
                    "Action": "elasticloadbalancing:DescribeLoadBalancers",
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowElasticBeanstalkStacksUpdateExecuteSuccessfully"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQPH22XGBH2VV2LSW",
        "PolicyName": "AWSElasticBeanstalkMaintenance",
        "UpdateDate": "2019-06-04T17:48:27+00:00",
        "VersionId": "v2"
    },
    "AWSElasticBeanstalkManagedUpdatesServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSElasticBeanstalkManagedUpdatesServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-21T22:35:06+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringLikeIfExists": {
                            "iam:PassedToService": [
                                "elasticbeanstalk.amazonaws.com",
                                "ec2.amazonaws.com",
                                "autoscaling.amazonaws.com",
                                "elasticloadbalancing.amazonaws.com",
                                "ecs.amazonaws.com",
                                "cloudformation.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowPassRoleToElasticBeanstalkAndDownstreamServices"
                },
                {
                    "Action": [
                        "ec2:releaseAddress",
                        "ec2:allocateAddress",
                        "ec2:DisassociateAddress",
                        "ec2:AssociateAddress"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SingleInstanceAPIs"
                },
                {
                    "Action": [
                        "ecs:RegisterTaskDefinition",
                        "ecs:DeRegisterTaskDefinition",
                        "ecs:List*",
                        "ecs:Describe*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ECS"
                },
                {
                    "Action": [
                        "elasticbeanstalk:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ElasticBeanstalkAPIs"
                },
                {
                    "Action": [
                        "cloudformation:Describe*",
                        "cloudformation:List*",
                        "ec2:Describe*",
                        "autoscaling:Describe*",
                        "elasticloadbalancing:Describe*",
                        "logs:DescribeLogGroups",
                        "sns:GetTopicAttributes",
                        "sns:ListSubscriptionsByTopic"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ReadOnlyAPIs"
                },
                {
                    "Action": [
                        "autoscaling:AttachInstances",
                        "autoscaling:CreateAutoScalingGroup",
                        "autoscaling:CreateLaunchConfiguration",
                        "autoscaling:DeleteAutoScalingGroup",
                        "autoscaling:DeleteLaunchConfiguration",
                        "autoscaling:DeleteScheduledAction",
                        "autoscaling:DetachInstances",
                        "autoscaling:PutNotificationConfiguration",
                        "autoscaling:PutScalingPolicy",
                        "autoscaling:PutScheduledUpdateGroupAction",
                        "autoscaling:ResumeProcesses",
                        "autoscaling:SuspendProcesses",
                        "autoscaling:TerminateInstanceInAutoScalingGroup",
                        "autoscaling:UpdateAutoScalingGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
                        "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*",
                        "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/eb-*",
                        "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/eb-*"
                    ],
                    "Sid": "ASG"
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:CancelUpdateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:GetTemplate",
                        "cloudformation:UpdateStack"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/awseb-e-*",
                        "arn:aws:cloudformation:*:*:stack/eb-*"
                    ],
                    "Sid": "CFN"
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-id": [
                                "arn:aws:cloudformation:*:*:stack/awseb-e-*",
                                "arn:aws:cloudformation:*:*:stack/eb-*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*",
                    "Sid": "EC2"
                },
                {
                    "Action": [
                        "s3:DeleteObject",
                        "s3:GetObject",
                        "s3:GetObjectAcl",
                        "s3:GetObjectVersion",
                        "s3:GetObjectVersionAcl",
                        "s3:PutObject",
                        "s3:PutObjectAcl",
                        "s3:PutObjectVersionAcl"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::elasticbeanstalk-*/*",
                    "Sid": "S3Obj"
                },
                {
                    "Action": [
                        "s3:GetBucketLocation",
                        "s3:GetBucketPolicy",
                        "s3:ListBucket",
                        "s3:PutBucketPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::elasticbeanstalk-*",
                    "Sid": "S3Bucket"
                },
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:DeleteLogGroup",
                        "logs:PutRetentionPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
                    "Sid": "CWL"
                },
                {
                    "Action": [
                        "elasticloadbalancing:RegisterTargets",
                        "elasticloadbalancing:DeRegisterTargets",
                        "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
                        "elasticloadbalancing:RegisterInstancesWithLoadBalancer"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
                        "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-e-*",
                        "arn:aws:elasticloadbalancing:*:*:targetgroup/eb-*",
                        "arn:aws:elasticloadbalancing:*:*:loadbalancer/eb-*"
                    ],
                    "Sid": "ELB"
                },
                {
                    "Action": [
                        "sns:CreateTopic"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:ElasticBeanstalkNotifications-Environment-*",
                    "Sid": "SNS"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HVFNJB4NR",
        "PolicyName": "AWSElasticBeanstalkManagedUpdatesServiceRolePolicy",
        "UpdateDate": "2020-12-11T18:21:32+00:00",
        "VersionId": "v5"
    },
    "AWSElasticBeanstalkMulticontainerDocker": {
        "Arn": "arn:aws:iam::aws:policy/AWSElasticBeanstalkMulticontainerDocker",
        "AttachmentCount": 0,
        "CreateDate": "2016-02-08T23:15:29+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ecs:Poll",
                        "ecs:StartTask",
                        "ecs:StopTask",
                        "ecs:DiscoverPollEndpoint",
                        "ecs:StartTelemetrySession",
                        "ecs:RegisterContainerInstance",
                        "ecs:DeregisterContainerInstance",
                        "ecs:DescribeContainerInstances",
                        "ecs:Submit*",
                        "ecs:DescribeTasks"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ECSAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ45SBYG72SD6SHJEY",
        "PolicyName": "AWSElasticBeanstalkMulticontainerDocker",
        "UpdateDate": "2016-06-06T23:45:37+00:00",
        "VersionId": "v2"
    },
    "AWSElasticBeanstalkReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSElasticBeanstalkReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2021-01-22T19:02:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "acm:ListCertificates",
                        "autoscaling:DescribeAccountLimits",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeAutoScalingInstances",
                        "autoscaling:DescribeLaunchConfigurations",
                        "autoscaling:DescribePolicies",
                        "autoscaling:DescribeLoadBalancers",
                        "autoscaling:DescribeNotificationConfigurations",
                        "autoscaling:DescribeScalingActivities",
                        "autoscaling:DescribeScheduledActions",
                        "cloudformation:DescribeStackResource",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DescribeStacks",
                        "cloudformation:GetTemplate",
                        "cloudformation:ListStackResources",
                        "cloudformation:ListStacks",
                        "cloudformation:ValidateTemplate",
                        "cloudtrail:LookupEvents",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:GetMetricStatistics",
                        "cloudwatch:ListMetrics",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstanceAttribute",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceStatus",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeLaunchTemplateVersions",
                        "ec2:DescribeLaunchTemplates",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeSpotInstanceRequests",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "elasticbeanstalk:Check*",
                        "elasticbeanstalk:Describe*",
                        "elasticbeanstalk:List*",
                        "elasticbeanstalk:RequestEnvironmentInfo",
                        "elasticbeanstalk:RetrieveEnvironmentInfo",
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeSSLPolicies",
                        "elasticloadbalancing:DescribeTargetGroups",
                        "elasticloadbalancing:DescribeTargetHealth",
                        "iam:GetRole",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListInstanceProfiles",
                        "iam:ListRolePolicies",
                        "iam:ListRoles",
                        "iam:ListServerCertificates",
                        "rds:DescribeDBEngineVersions",
                        "rds:DescribeDBInstances",
                        "rds:DescribeOrderableDBInstanceOptions",
                        "rds:DescribeDBSnapshots",
                        "s3:ListAllMyBuckets",
                        "sns:ListSubscriptionsByTopic",
                        "sns:ListTopics",
                        "sqs:ListQueues"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowAPIs"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:GetObjectAcl",
                        "s3:GetObjectVersion",
                        "s3:GetObjectVersionAcl",
                        "s3:GetBucketLocation",
                        "s3:GetBucketPolicy",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::elasticbeanstalk-*",
                    "Sid": "AllowS3"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BYFSOYIWH",
        "PolicyName": "AWSElasticBeanstalkReadOnly",
        "UpdateDate": "2021-01-22T19:02:37+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSElasticBeanstalkReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:19+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "elasticbeanstalk:Check*",
                        "elasticbeanstalk:Describe*",
                        "elasticbeanstalk:List*",
                        "elasticbeanstalk:RequestEnvironmentInfo",
                        "elasticbeanstalk:RetrieveEnvironmentInfo",
                        "ec2:Describe*",
                        "elasticloadbalancing:Describe*",
                        "autoscaling:Describe*",
                        "cloudwatch:Describe*",
                        "cloudwatch:List*",
                        "cloudwatch:Get*",
                        "s3:Get*",
                        "s3:List*",
                        "sns:Get*",
                        "sns:List*",
                        "cloudformation:Describe*",
                        "cloudformation:Get*",
                        "cloudformation:List*",
                        "cloudformation:Validate*",
                        "cloudformation:Estimate*",
                        "rds:Describe*",
                        "sqs:Get*",
                        "sqs:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI47KNGXDAXFD4SDHG",
        "PolicyName": "AWSElasticBeanstalkReadOnlyAccess",
        "UpdateDate": "2015-02-06T18:40:19+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkRoleCWL": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkRoleCWL",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-05T21:49:06+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:DeleteLogGroup",
                        "logs:PutRetentionPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
                    "Sid": "AllowCWL"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4G4S2QMTW3",
        "PolicyName": "AWSElasticBeanstalkRoleCWL",
        "UpdateDate": "2020-06-05T21:49:06+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkRoleCore": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkRoleCore",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-05T21:48:24+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-id": "arn:aws:cloudformation:*:*:stack/awseb-e-*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*",
                    "Sid": "TerminateInstances"
                },
                {
                    "Action": [
                        "ec2:ReleaseAddress",
                        "ec2:AllocateAddress",
                        "ec2:DisassociateAddress",
                        "ec2:AssociateAddress",
                        "ec2:CreateTags",
                        "ec2:DeleteTags",
                        "ec2:CreateSecurityGroup",
                        "ec2:DeleteSecurityGroup",
                        "ec2:AuthorizeSecurityGroup*",
                        "ec2:RevokeSecurityGroup*",
                        "ec2:CreateLaunchTemplate*",
                        "ec2:DeleteLaunchTemplate*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "EC2"
                },
                {
                    "Action": "ec2:RunInstances",
                    "Condition": {
                        "ArnLike": {
                            "ec2:LaunchTemplate": "arn:aws:ec2:*:*:launch-template/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "LTRunInstances"
                },
                {
                    "Action": [
                        "autoscaling:AttachInstances",
                        "autoscaling:*LoadBalancer*",
                        "autoscaling:*AutoScalingGroup",
                        "autoscaling:*LaunchConfiguration",
                        "autoscaling:DeleteScheduledAction",
                        "autoscaling:DetachInstances",
                        "autoscaling:PutNotificationConfiguration",
                        "autoscaling:PutScalingPolicy",
                        "autoscaling:PutScheduledUpdateGroupAction",
                        "autoscaling:ResumeProcesses",
                        "autoscaling:SuspendProcesses",
                        "autoscaling:*Tags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/awseb-e-*",
                        "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/awseb-e-*"
                    ],
                    "Sid": "ASG"
                },
                {
                    "Action": [
                        "autoscaling:DeletePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "ASGPolicy"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "elasticbeanstalk.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk*"
                    ],
                    "Sid": "EBSLR"
                },
                {
                    "Action": [
                        "s3:Delete*",
                        "s3:Get*",
                        "s3:Put*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::elasticbeanstalk-*/*",
                        "arn:aws:s3:::elasticbeanstalk-env-resources-*/*"
                    ],
                    "Sid": "S3Obj"
                },
                {
                    "Action": [
                        "s3:GetBucket*",
                        "s3:ListBucket",
                        "s3:PutBucketPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::elasticbeanstalk-*",
                    "Sid": "S3Bucket"
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:GetTemplate",
                        "cloudformation:ListStackResources",
                        "cloudformation:UpdateStack",
                        "cloudformation:ContinueUpdateRollback",
                        "cloudformation:CancelUpdateStack"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/awseb-e-*",
                    "Sid": "CFN"
                },
                {
                    "Action": [
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DeleteAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudwatch:*:*:alarm:awseb-*",
                    "Sid": "CloudWatch"
                },
                {
                    "Action": [
                        "elasticloadbalancing:Create*",
                        "elasticloadbalancing:Delete*",
                        "elasticloadbalancing:Modify*",
                        "elasticloadbalancing:RegisterTargets",
                        "elasticloadbalancing:DeRegisterTargets",
                        "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
                        "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
                        "elasticloadbalancing:*Tags",
                        "elasticloadbalancing:ConfigureHealthCheck",
                        "elasticloadbalancing:SetRulePriorities",
                        "elasticloadbalancing:SetLoadBalancerPoliciesOfListener"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:elasticloadbalancing:*:*:targetgroup/awseb-*",
                        "arn:aws:elasticloadbalancing:*:*:loadbalancer/awseb-*",
                        "arn:aws:elasticloadbalancing:*:*:loadbalancer/app/awseb-*/*",
                        "arn:aws:elasticloadbalancing:*:*:loadbalancer/net/awseb-*/*",
                        "arn:aws:elasticloadbalancing:*:*:listener/awseb-*",
                        "arn:aws:elasticloadbalancing:*:*:listener/app/awseb-*",
                        "arn:aws:elasticloadbalancing:*:*:listener/net/awseb-*",
                        "arn:aws:elasticloadbalancing:*:*:listener-rule/app/awseb-*/*/*/*"
                    ],
                    "Sid": "ELB"
                },
                {
                    "Action": [
                        "autoscaling:Describe*",
                        "cloudformation:Describe*",
                        "logs:Describe*",
                        "ec2:Describe*",
                        "ecs:Describe*",
                        "ecs:List*",
                        "elasticloadbalancing:Describe*",
                        "rds:Describe*",
                        "sns:List*",
                        "iam:List*",
                        "acm:Describe*",
                        "acm:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "ListAPIs"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "elasticbeanstalk.amazonaws.com",
                                "ec2.amazonaws.com",
                                "autoscaling.amazonaws.com",
                                "elasticloadbalancing.amazonaws.com",
                                "ecs.amazonaws.com",
                                "cloudformation.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-elasticbeanstalk-*",
                    "Sid": "AllowPassRole"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OXQ5DMW6K",
        "PolicyName": "AWSElasticBeanstalkRoleCore",
        "UpdateDate": "2020-09-09T20:31:14+00:00",
        "VersionId": "v2"
    },
    "AWSElasticBeanstalkRoleECS": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkRoleECS",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-05T21:47:27+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ecs:CreateCluster",
                        "ecs:DeleteCluster",
                        "ecs:RegisterTaskDefinition",
                        "ecs:DeRegisterTaskDefinition"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AllowECS"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4ORP4E3ZEZ",
        "PolicyName": "AWSElasticBeanstalkRoleECS",
        "UpdateDate": "2020-06-05T21:47:27+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkRoleRDS": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkRoleRDS",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-05T21:46:55+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "rds:CreateDBSecurityGroup",
                        "rds:DeleteDBSecurityGroup",
                        "rds:AuthorizeDBSecurityGroupIngress",
                        "rds:CreateDBInstance",
                        "rds:ModifyDBInstance",
                        "rds:DeleteDBInstance"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:rds:*:*:secgrp:awseb-e-*",
                        "arn:aws:rds:*:*:db:*"
                    ],
                    "Sid": "AllowRDS"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4G5JWEESE4",
        "PolicyName": "AWSElasticBeanstalkRoleRDS",
        "UpdateDate": "2020-06-05T21:46:55+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkRoleSNS": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkRoleSNS",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-05T21:46:22+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:SetTopicAttributes",
                        "sns:DeleteTopic"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sns:*:*:ElasticBeanstalkNotifications-*"
                    ],
                    "Sid": "AllowBeanstalkManageSNS"
                },
                {
                    "Action": [
                        "sns:GetTopicAttributes",
                        "sns:Subscribe",
                        "sns:Unsubscribe",
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowSNSPublish"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4PARPZJ2UZ",
        "PolicyName": "AWSElasticBeanstalkRoleSNS",
        "UpdateDate": "2020-06-05T21:46:22+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkRoleWorkerTier": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkRoleWorkerTier",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-05T21:43:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sqs:TagQueue",
                        "sqs:DeleteQueue",
                        "sqs:GetQueueAttributes",
                        "sqs:CreateQueue"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sqs:*:*:awseb-e-*",
                    "Sid": "AllowSQS"
                },
                {
                    "Action": [
                        "dynamodb:CreateTable",
                        "dynamodb:TagResource",
                        "dynamodb:DescribeTable",
                        "dynamodb:DeleteTable"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:dynamodb:*:*:table/awseb-e-*",
                    "Sid": "AllowDDB"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4LTO4NS2Z5",
        "PolicyName": "AWSElasticBeanstalkRoleWorkerTier",
        "UpdateDate": "2020-06-05T21:43:37+00:00",
        "VersionId": "v1"
    },
    "AWSElasticBeanstalkService": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkService",
        "AttachmentCount": 0,
        "CreateDate": "2016-04-11T20:27:23+00:00",
        "DefaultVersionId": "v16",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/awseb-*",
                        "arn:aws:cloudformation:*:*:stack/eb-*"
                    ],
                    "Sid": "AllowCloudformationOperationsOnElasticBeanstalkStacks"
                },
                {
                    "Action": [
                        "logs:DeleteLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
                    ],
                    "Sid": "AllowDeleteCloudwatchLogGroups"
                },
                {
                    "Action": [
                        "s3:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::elasticbeanstalk-*",
                        "arn:aws:s3:::elasticbeanstalk-*/*"
                    ],
                    "Sid": "AllowS3OperationsOnElasticBeanstalkBuckets"
                },
                {
                    "Action": "ec2:RunInstances",
                    "Condition": {
                        "ArnLike": {
                            "ec2:LaunchTemplate": "arn:aws:ec2:*:*:launch-template/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowLaunchTemplateRunInstances"
                },
                {
                    "Action": [
                        "autoscaling:AttachInstances",
                        "autoscaling:CreateAutoScalingGroup",
                        "autoscaling:CreateLaunchConfiguration",
                        "autoscaling:DeleteLaunchConfiguration",
                        "autoscaling:DeleteAutoScalingGroup",
                        "autoscaling:DeleteScheduledAction",
                        "autoscaling:DescribeAccountLimits",
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeAutoScalingInstances",
                        "autoscaling:DescribeLaunchConfigurations",
                        "autoscaling:DescribeLoadBalancers",
                        "autoscaling:DescribeNotificationConfigurations",
                        "autoscaling:DescribeScalingActivities",
                        "autoscaling:DescribeScheduledActions",
                        "autoscaling:DetachInstances",
                        "autoscaling:DeletePolicy",
                        "autoscaling:PutScalingPolicy",
                        "autoscaling:PutScheduledUpdateGroupAction",
                        "autoscaling:PutNotificationConfiguration",
                        "autoscaling:ResumeProcesses",
                        "autoscaling:SetDesiredCapacity",
                        "autoscaling:SuspendProcesses",
                        "autoscaling:TerminateInstanceInAutoScalingGroup",
                        "autoscaling:UpdateAutoScalingGroup",
                        "cloudwatch:PutMetricAlarm",
                        "ec2:AssociateAddress",
                        "ec2:AllocateAddress",
                        "ec2:AuthorizeSecurityGroupEgress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CreateLaunchTemplate",
                        "ec2:CreateLaunchTemplateVersion",
                        "ec2:DescribeLaunchTemplates",
                        "ec2:DescribeLaunchTemplateVersions",
                        "ec2:DeleteLaunchTemplate",
                        "ec2:DeleteLaunchTemplateVersions",
                        "ec2:CreateSecurityGroup",
                        "ec2:DeleteSecurityGroup",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeInstanceAttribute",
                        "ec2:DescribeSpotInstanceRequests",
                        "ec2:DescribeVpcClassicLink",
                        "ec2:DisassociateAddress",
                        "ec2:ReleaseAddress",
                        "ec2:RevokeSecurityGroupEgress",
                        "ec2:RevokeSecurityGroupIngress",
                        "ec2:TerminateInstances",
                        "ecs:CreateCluster",
                        "ecs:DeleteCluster",
                        "ecs:DescribeClusters",
                        "ecs:RegisterTaskDefinition",
                        "elasticbeanstalk:*",
                        "elasticloadbalancing:ApplySecurityGroupsToLoadBalancer",
                        "elasticloadbalancing:ConfigureHealthCheck",
                        "elasticloadbalancing:CreateLoadBalancer",
                        "elasticloadbalancing:DeleteLoadBalancer",
                        "elasticloadbalancing:DeregisterInstancesFromLoadBalancer",
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeTargetHealth",
                        "elasticloadbalancing:RegisterInstancesWithLoadBalancer",
                        "elasticloadbalancing:DescribeTargetGroups",
                        "elasticloadbalancing:RegisterTargets",
                        "elasticloadbalancing:DeregisterTargets",
                        "iam:ListRoles",
                        "iam:PassRole",
                        "logs:CreateLogGroup",
                        "logs:PutRetentionPolicy",
                        "logs:DescribeLogGroups",
                        "rds:DescribeDBEngineVersions",
                        "rds:DescribeDBInstances",
                        "rds:DescribeOrderableDBInstanceOptions",
                        "s3:GetObject",
                        "s3:GetObjectAcl",
                        "s3:ListBucket",
                        "sns:CreateTopic",
                        "sns:GetTopicAttributes",
                        "sns:ListSubscriptionsByTopic",
                        "sns:Subscribe",
                        "sns:SetTopicAttributes",
                        "sqs:GetQueueAttributes",
                        "sqs:GetQueueUrl",
                        "codebuild:CreateProject",
                        "codebuild:DeleteProject",
                        "codebuild:BatchGetBuilds",
                        "codebuild:StartBuild"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AllowOperations"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJKQ5SN74ZQ4WASXBM",
        "PolicyName": "AWSElasticBeanstalkService",
        "UpdateDate": "2019-06-14T23:18:46+00:00",
        "VersionId": "v16"
    },
    "AWSElasticBeanstalkServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSElasticBeanstalkServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-09-13T23:46:37+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeStackResource",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DescribeStacks"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/awseb-*",
                        "arn:aws:cloudformation:*:*:stack/eb-*"
                    ],
                    "Sid": "AllowCloudformationReadOperationsOnElasticBeanstalkStacks"
                },
                {
                    "Action": [
                        "autoscaling:DescribeAutoScalingGroups",
                        "autoscaling:DescribeAutoScalingInstances",
                        "autoscaling:DescribeNotificationConfigurations",
                        "autoscaling:DescribeScalingActivities",
                        "autoscaling:PutNotificationConfiguration",
                        "ec2:DescribeInstanceStatus",
                        "ec2:AssociateAddress",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeInstances",
                        "ec2:DescribeSecurityGroups",
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeTargetHealth",
                        "elasticloadbalancing:DescribeTargetGroups",
                        "lambda:GetFunction",
                        "sqs:GetQueueAttributes",
                        "sqs:GetQueueUrl",
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AllowOperations"
                },
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:DescribeLogGroups",
                        "logs:DescribeLogStreams",
                        "logs:DeleteLogGroup",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk/*",
                    "Sid": "AllowOperationsOnHealthStreamingLogs"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIID62QSI3OSIPQXTM",
        "PolicyName": "AWSElasticBeanstalkServiceRolePolicy",
        "UpdateDate": "2019-06-06T21:59:51+00:00",
        "VersionId": "v6"
    },
    "AWSElasticBeanstalkWebTier": {
        "Arn": "arn:aws:iam::aws:policy/AWSElasticBeanstalkWebTier",
        "AttachmentCount": 0,
        "CreateDate": "2016-02-08T23:08:54+00:00",
        "DefaultVersionId": "v7",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:Get*",
                        "s3:List*",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::elasticbeanstalk-*",
                        "arn:aws:s3:::elasticbeanstalk-*/*"
                    ],
                    "Sid": "BucketAccess"
                },
                {
                    "Action": [
                        "xray:PutTraceSegments",
                        "xray:PutTelemetryRecords",
                        "xray:GetSamplingRules",
                        "xray:GetSamplingTargets",
                        "xray:GetSamplingStatisticSummaries"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "XRayAccess"
                },
                {
                    "Action": [
                        "logs:PutLogEvents",
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:DescribeLogGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
                    ],
                    "Sid": "CloudWatchLogsAccess"
                },
                {
                    "Action": [
                        "elasticbeanstalk:PutInstanceStatistics"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:elasticbeanstalk:*:*:application/*",
                        "arn:aws:elasticbeanstalk:*:*:environment/*"
                    ],
                    "Sid": "ElasticBeanstalkHealthAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIUF4325SJYOREKW3A",
        "PolicyName": "AWSElasticBeanstalkWebTier",
        "UpdateDate": "2020-09-09T19:38:36+00:00",
        "VersionId": "v7"
    },
    "AWSElasticBeanstalkWorkerTier": {
        "Arn": "arn:aws:iam::aws:policy/AWSElasticBeanstalkWorkerTier",
        "AttachmentCount": 0,
        "CreateDate": "2016-02-08T23:12:02+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudwatch:PutMetricData"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "MetricsAccess"
                },
                {
                    "Action": [
                        "xray:PutTraceSegments",
                        "xray:PutTelemetryRecords",
                        "xray:GetSamplingRules",
                        "xray:GetSamplingTargets",
                        "xray:GetSamplingStatisticSummaries"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "XRayAccess"
                },
                {
                    "Action": [
                        "sqs:ChangeMessageVisibility",
                        "sqs:DeleteMessage",
                        "sqs:ReceiveMessage",
                        "sqs:SendMessage"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "QueueAccess"
                },
                {
                    "Action": [
                        "s3:Get*",
                        "s3:List*",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::elasticbeanstalk-*",
                        "arn:aws:s3:::elasticbeanstalk-*/*"
                    ],
                    "Sid": "BucketAccess"
                },
                {
                    "Action": [
                        "dynamodb:BatchGetItem",
                        "dynamodb:BatchWriteItem",
                        "dynamodb:DeleteItem",
                        "dynamodb:GetItem",
                        "dynamodb:PutItem",
                        "dynamodb:Query",
                        "dynamodb:Scan",
                        "dynamodb:UpdateItem"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:dynamodb:*:*:table/*-stack-AWSEBWorkerCronLeaderRegistry*"
                    ],
                    "Sid": "DynamoPeriodicTasks"
                },
                {
                    "Action": [
                        "logs:PutLogEvents",
                        "logs:CreateLogStream"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
                    ],
                    "Sid": "CloudWatchLogsAccess"
                },
                {
                    "Action": [
                        "elasticbeanstalk:PutInstanceStatistics"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:elasticbeanstalk:*:*:application/*",
                        "arn:aws:elasticbeanstalk:*:*:environment/*"
                    ],
                    "Sid": "ElasticBeanstalkHealthAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQDLBRSJVKVF4JMSK",
        "PolicyName": "AWSElasticBeanstalkWorkerTier",
        "UpdateDate": "2020-09-09T19:53:40+00:00",
        "VersionId": "v6"
    },
    "AWSElasticLoadBalancingClassicServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSElasticLoadBalancingClassicServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-09-19T22:36:18+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeAddresses",
                        "ec2:DescribeInstances",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeInternetGateways",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeClassicLinkInstances",
                        "ec2:DescribeVpcClassicLink",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateNetworkInterface",
                        "ec2:DeleteNetworkInterface",
                        "ec2:ModifyNetworkInterfaceAttribute",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:AssociateAddress",
                        "ec2:DisassociateAddress",
                        "ec2:AttachNetworkInterface",
                        "ec2:DetachNetworkInterface",
                        "ec2:AssignPrivateIpAddresses",
                        "ec2:AssignIpv6Addresses",
                        "ec2:UnassignIpv6Addresses"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIUMWW3QP7DPZPNVU4",
        "PolicyName": "AWSElasticLoadBalancingClassicServiceRolePolicy",
        "UpdateDate": "2019-10-07T23:04:27+00:00",
        "VersionId": "v2"
    },
    "AWSElasticLoadBalancingServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSElasticLoadBalancingServiceRolePolicy",
        "AttachmentCount": 1,
        "CreateDate": "2017-09-19T22:19:04+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeAddresses",
                        "ec2:DescribeCoipPools",
                        "ec2:DescribeInstances",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeInternetGateways",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeClassicLinkInstances",
                        "ec2:DescribeVpcClassicLink",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateNetworkInterface",
                        "ec2:DeleteNetworkInterface",
                        "ec2:GetCoipPoolUsage",
                        "ec2:ModifyNetworkInterfaceAttribute",
                        "ec2:AllocateAddress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:AssociateAddress",
                        "ec2:DisassociateAddress",
                        "ec2:AttachNetworkInterface",
                        "ec2:DetachNetworkInterface",
                        "ec2:AssignPrivateIpAddresses",
                        "ec2:AssignIpv6Addresses",
                        "ec2:ReleaseAddress",
                        "ec2:UnassignIpv6Addresses",
                        "logs:CreateLogDelivery",
                        "logs:GetLogDelivery",
                        "logs:UpdateLogDelivery",
                        "logs:DeleteLogDelivery",
                        "logs:ListLogDeliveries",
                        "outposts:GetOutpostInstanceTypes"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIMHWGGSRHLOQUICJQ",
        "PolicyName": "AWSElasticLoadBalancingServiceRolePolicy",
        "UpdateDate": "2020-05-19T16:40:28+00:00",
        "VersionId": "v6"
    },
    "AWSElementalMediaConvertFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaConvertFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-25T19:25:35+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mediaconvert:*",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "mediaconvert.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIXDREOCL6LV7RBJWC",
        "PolicyName": "AWSElementalMediaConvertFullAccess",
        "UpdateDate": "2019-06-10T22:52:25+00:00",
        "VersionId": "v2"
    },
    "AWSElementalMediaConvertReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaConvertReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-25T19:25:14+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mediaconvert:Get*",
                        "mediaconvert:List*",
                        "mediaconvert:DescribeEndpoints",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJSXYOBSLJN3JEDO42",
        "PolicyName": "AWSElementalMediaConvertReadOnly",
        "UpdateDate": "2019-06-10T22:52:18+00:00",
        "VersionId": "v2"
    },
    "AWSElementalMediaLiveFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaLiveFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-07-08T17:07:14+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": {
                "Action": "medialive:*",
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4K5KSJBKUE",
        "PolicyName": "AWSElementalMediaLiveFullAccess",
        "UpdateDate": "2020-07-08T17:07:14+00:00",
        "VersionId": "v1"
    },
    "AWSElementalMediaLiveReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaLiveReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2020-07-08T16:38:07+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": {
                "Action": [
                    "medialive:List*",
                    "medialive:Describe*"
                ],
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4L7DTGZPRO",
        "PolicyName": "AWSElementalMediaLiveReadOnly",
        "UpdateDate": "2020-07-08T16:38:07+00:00",
        "VersionId": "v1"
    },
    "AWSElementalMediaPackageFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaPackageFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-12-29T23:39:52+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": {
                "Action": "mediapackage:*",
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIYI6IYR3JRFAVNQHC",
        "PolicyName": "AWSElementalMediaPackageFullAccess",
        "UpdateDate": "2017-12-29T23:39:52+00:00",
        "VersionId": "v1"
    },
    "AWSElementalMediaPackageReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaPackageReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2017-12-30T00:04:29+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": {
                "Action": [
                    "mediapackage:List*",
                    "mediapackage:Describe*"
                ],
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ42DVTPUHKXNYZQCO",
        "PolicyName": "AWSElementalMediaPackageReadOnly",
        "UpdateDate": "2017-12-30T00:04:29+00:00",
        "VersionId": "v1"
    },
    "AWSElementalMediaStoreFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaStoreFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-05T23:15:31+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mediastore:*"
                    ],
                    "Condition": {
                        "Bool": {
                            "aws:SecureTransport": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJZFYFW2QXSNK7OH6Y",
        "PolicyName": "AWSElementalMediaStoreFullAccess",
        "UpdateDate": "2018-03-05T23:15:31+00:00",
        "VersionId": "v1"
    },
    "AWSElementalMediaStoreReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSElementalMediaStoreReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-08T19:48:22+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mediastore:Get*",
                        "mediastore:List*",
                        "mediastore:Describe*"
                    ],
                    "Condition": {
                        "Bool": {
                            "aws:SecureTransport": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI4EFXRATQYOFTAEFM",
        "PolicyName": "AWSElementalMediaStoreReadOnly",
        "UpdateDate": "2018-03-08T19:48:22+00:00",
        "VersionId": "v1"
    },
    "AWSEnhancedClassicNetworkingMangementPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSEnhancedClassicNetworkingMangementPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-09-20T17:29:09+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeInstances",
                        "ec2:DescribeSecurityGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI7T4V2HZTS72QVO52",
        "PolicyName": "AWSEnhancedClassicNetworkingMangementPolicy",
        "UpdateDate": "2017-09-20T17:29:09+00:00",
        "VersionId": "v1"
    },
    "AWSFMAdminFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSFMAdminFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-05-09T18:06:18+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "fms:*",
                        "waf:*",
                        "waf-regional:*",
                        "elasticloadbalancing:SetWebACL",
                        "organizations:DescribeOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJLAGM5X6WSNPF4EAQ",
        "PolicyName": "AWSFMAdminFullAccess",
        "UpdateDate": "2018-05-09T18:06:18+00:00",
        "VersionId": "v1"
    },
    "AWSFMAdminReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSFMAdminReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-05-09T20:07:39+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "fms:Get*",
                        "fms:List*",
                        "waf:Get*",
                        "waf:List*",
                        "waf-regional:Get*",
                        "waf-regional:List*",
                        "organizations:DescribeOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJA3UKVVBN62QFIKLW",
        "PolicyName": "AWSFMAdminReadOnlyAccess",
        "UpdateDate": "2018-05-09T20:07:39+00:00",
        "VersionId": "v1"
    },
    "AWSFMMemberReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSFMMemberReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-05-09T21:05:29+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "fms:GetAdminAccount",
                        "waf:Get*",
                        "waf:List*",
                        "waf-regional:Get*",
                        "waf-regional:List*",
                        "organizations:DescribeOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIB2IVAQ4XXNHHA3DW",
        "PolicyName": "AWSFMMemberReadOnlyAccess",
        "UpdateDate": "2018-05-09T21:05:29+00:00",
        "VersionId": "v1"
    },
    "AWSForWordPressPluginPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSForWordPressPluginPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-10-30T00:27:46+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "polly:SynthesizeSpeech",
                        "polly:DescribeVoices",
                        "translate:TranslateText"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "Permissions1"
                },
                {
                    "Action": [
                        "s3:ListBucket",
                        "s3:GetBucketAcl",
                        "s3:GetBucketPolicy",
                        "s3:PutObject",
                        "s3:DeleteObject",
                        "s3:CreateBucket",
                        "s3:PutObjectAcl"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::audio_for_wordpress*",
                        "arn:aws:s3:::audio-for-wordpress*"
                    ],
                    "Sid": "Permissions2"
                },
                {
                    "Action": [
                        "acm:AddTagsToCertificate",
                        "acm:DescribeCertificate",
                        "acm:RequestCertificate",
                        "cloudformation:CreateStack",
                        "cloudfront:ListDistributions"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:RequestedRegion": "us-east-1"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "Permissions3"
                },
                {
                    "Action": [
                        "acm:DeleteCertificate",
                        "cloudformation:DeleteStack",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:UpdateStack",
                        "cloudfront:CreateDistribution",
                        "cloudfront:CreateInvalidation",
                        "cloudfront:DeleteDistribution",
                        "cloudfront:GetDistribution",
                        "cloudfront:GetInvalidation",
                        "cloudfront:TagResource",
                        "cloudfront:UpdateDistribution"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:ResourceTag/createdBy": "AWSForWordPressPlugin"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "Permissions4"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KEKYXDWNJ",
        "PolicyName": "AWSForWordPressPluginPolicy",
        "UpdateDate": "2020-01-20T23:20:47+00:00",
        "VersionId": "v2"
    },
    "AWSGlobalAcceleratorSLRPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSGlobalAcceleratorSLRPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-04-05T19:39:13+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CreateNetworkInterface",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInternetGateways",
                        "ec2:DescribeSubnets",
                        "ec2:ModifyNetworkInterfaceAttribute",
                        "ec2:DeleteNetworkInterface"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:DeleteSecurityGroup",
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/AWSServiceName": "GlobalAccelerator"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateSecurityGroup",
                        "ec2:DescribeSecurityGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "elasticloadbalancing:DescribeLoadBalancers",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:CreateTags",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:network-interface/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4EJ5ZEQR2C",
        "PolicyName": "AWSGlobalAcceleratorSLRPolicy",
        "UpdateDate": "2019-10-14T21:05:22+00:00",
        "VersionId": "v4"
    },
    "AWSGlueConsoleFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSGlueConsoleFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-08-14T13:37:39+00:00",
        "DefaultVersionId": "v12",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:*",
                        "redshift:DescribeClusters",
                        "redshift:DescribeClusterSubnetGroups",
                        "iam:ListRoles",
                        "iam:ListUsers",
                        "iam:ListGroups",
                        "iam:ListRolePolicies",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:ListAttachedRolePolicies",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeVpcEndpoints",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeVpcAttribute",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeInstances",
                        "ec2:DescribeImages",
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBClusters",
                        "rds:DescribeDBSubnetGroups",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket",
                        "s3:GetBucketAcl",
                        "s3:GetBucketLocation",
                        "cloudformation:DescribeStacks",
                        "cloudformation:GetTemplateSummary",
                        "dynamodb:ListTables",
                        "kms:ListAliases",
                        "kms:DescribeKey",
                        "cloudwatch:GetMetricData",
                        "cloudwatch:ListDashboards"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-glue-*/*",
                        "arn:aws:s3:::*/*aws-glue-*/*",
                        "arn:aws:s3:::aws-glue-*"
                    ]
                },
                {
                    "Action": [
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:CreateBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-glue-*"
                    ]
                },
                {
                    "Action": [
                        "logs:GetLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:/aws-glue/*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/aws-glue*/*"
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*",
                        "arn:aws:ec2:*:*:key-pair/*",
                        "arn:aws:ec2:*:*:image/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:subnet/*",
                        "arn:aws:ec2:*:*:volume/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances",
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/aws:cloudformation:logical-id": "ZeppelinInstance"
                        },
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-id": "arn:aws:cloudformation:*:*:stack/aws-glue-*/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "glue.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSGlueServiceRole*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSGlueServiceNotebookRole*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "glue.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/service-role/AWSGlueServiceRole*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJNZGDEOD7MISOVSVI",
        "PolicyName": "AWSGlueConsoleFullAccess",
        "UpdateDate": "2019-02-11T19:49:01+00:00",
        "VersionId": "v12"
    },
    "AWSGlueConsoleSageMakerNotebookFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSGlueConsoleSageMakerNotebookFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-05T17:52:35+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:*",
                        "redshift:DescribeClusters",
                        "redshift:DescribeClusterSubnetGroups",
                        "iam:ListRoles",
                        "iam:ListRolePolicies",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:ListAttachedRolePolicies",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeVpcEndpoints",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeVpcAttribute",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeInstances",
                        "ec2:DescribeImages",
                        "ec2:CreateNetworkInterface",
                        "ec2:AttachNetworkInterface",
                        "ec2:ModifyNetworkInterfaceAttribute",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeInternetGateways",
                        "ec2:DescribeNetworkInterfaces",
                        "rds:DescribeDBInstances",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket",
                        "s3:GetBucketAcl",
                        "s3:GetBucketLocation",
                        "cloudformation:DescribeStacks",
                        "cloudformation:GetTemplateSummary",
                        "dynamodb:ListTables",
                        "kms:ListAliases",
                        "kms:DescribeKey",
                        "sagemaker:ListNotebookInstances",
                        "cloudformation:ListStacks",
                        "cloudwatch:GetMetricData",
                        "cloudwatch:ListDashboards"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-glue-*/*",
                        "arn:aws:s3:::*/*aws-glue-*/*",
                        "arn:aws:s3:::aws-glue-*"
                    ]
                },
                {
                    "Action": [
                        "s3:CreateBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-glue-*"
                    ]
                },
                {
                    "Action": [
                        "logs:GetLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:/aws-glue/*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/aws-glue*/*"
                },
                {
                    "Action": [
                        "sagemaker:CreatePresignedNotebookInstanceUrl",
                        "sagemaker:CreateNotebookInstance",
                        "sagemaker:DeleteNotebookInstance",
                        "sagemaker:DescribeNotebookInstance",
                        "sagemaker:StartNotebookInstance",
                        "sagemaker:StopNotebookInstance",
                        "sagemaker:UpdateNotebookInstance",
                        "sagemaker:ListTags"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sagemaker:*:*:notebook-instance/aws-glue-*"
                },
                {
                    "Action": [
                        "sagemaker:DescribeNotebookInstanceLifecycleConfig",
                        "sagemaker:CreateNotebookInstanceLifecycleConfig",
                        "sagemaker:DeleteNotebookInstanceLifecycleConfig",
                        "sagemaker:ListNotebookInstanceLifecycleConfigs"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sagemaker:*:*:notebook-instance-lifecycle-config/aws-glue-*"
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*",
                        "arn:aws:ec2:*:*:key-pair/*",
                        "arn:aws:ec2:*:*:image/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:subnet/*",
                        "arn:aws:ec2:*:*:volume/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances",
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/aws:cloudformation:logical-id": "ZeppelinInstance"
                        },
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-id": "arn:aws:cloudformation:*:*:stack/aws-glue-*/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "tag:GetResources"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:TagKeys": "aws-glue-*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "glue.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSGlueServiceRole*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSGlueServiceNotebookRole*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "sagemaker.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSGlueServiceSageMakerNotebookRole*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "glue.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/service-role/AWSGlueServiceRole*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJELFOHJC42QS3ZSYY",
        "PolicyName": "AWSGlueConsoleSageMakerNotebookFullAccess",
        "UpdateDate": "2019-09-26T17:14:11+00:00",
        "VersionId": "v2"
    },
    "AWSGlueDataBrewServiceRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSGlueDataBrewServiceRole",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-04T21:26:50+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:GetDatabases",
                        "glue:GetPartitions",
                        "glue:GetTable",
                        "glue:GetTables",
                        "glue:GetConnection"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:ListBucket",
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::databrew-public-datasets-*"
                    ]
                },
                {
                    "Action": [
                        "ec2:DescribeVpcEndpoints",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcAttribute",
                        "ec2:CreateNetworkInterface"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "ec2:DeleteNetworkInterface",
                    "Condition": {
                        "StringLike": {
                            "aws:ResourceTag/aws-glue-service-resource": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": [
                                "aws-glue-service-resource"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:security-group/*"
                    ]
                },
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/aws-glue-databrew/*"
                    ]
                },
                {
                    "Action": [
                        "lakeformation:GetDataAccess"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HSXDEANHC",
        "PolicyName": "AWSGlueDataBrewServiceRole",
        "UpdateDate": "2020-12-04T21:26:50+00:00",
        "VersionId": "v1"
    },
    "AWSGlueSchemaRegistryFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSGlueSchemaRegistryFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-20T00:19:00+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:CreateRegistry",
                        "glue:UpdateRegistry",
                        "glue:DeleteRegistry",
                        "glue:GetRegistry",
                        "glue:ListRegistries",
                        "glue:CreateSchema",
                        "glue:UpdateSchema",
                        "glue:DeleteSchema",
                        "glue:GetSchema",
                        "glue:ListSchemas",
                        "glue:RegisterSchemaVersion",
                        "glue:DeleteSchemaVersions",
                        "glue:GetSchemaByDefinition",
                        "glue:GetSchemaVersion",
                        "glue:GetSchemaVersionsDiff",
                        "glue:ListSchemaVersions",
                        "glue:CheckSchemaVersionValidity",
                        "glue:PutSchemaVersionMetadata",
                        "glue:RemoveSchemaVersionMetadata",
                        "glue:QuerySchemaVersionMetadata"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AWSGlueSchemaRegistryFullAccess"
                },
                {
                    "Action": [
                        "glue:GetTags",
                        "glue:TagResource",
                        "glue:UnTagResource"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:glue:*:*:schema/*",
                        "arn:aws:glue:*:*:registry/*"
                    ],
                    "Sid": "AWSGlueSchemaRegistryTagsFullAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4H2OHGXA4A",
        "PolicyName": "AWSGlueSchemaRegistryFullAccess",
        "UpdateDate": "2020-11-20T00:19:00+00:00",
        "VersionId": "v1"
    },
    "AWSGlueSchemaRegistryReadonlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSGlueSchemaRegistryReadonlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-20T00:20:06+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:GetRegistry",
                        "glue:ListRegistries",
                        "glue:GetSchema",
                        "glue:ListSchemas",
                        "glue:GetSchemaByDefinition",
                        "glue:GetSchemaVersion",
                        "glue:ListSchemaVersions",
                        "glue:GetSchemaVersionsDiff",
                        "glue:CheckSchemaVersionValidity",
                        "glue:QuerySchemaVersionMetadata",
                        "glue:GetTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AWSGlueSchemaRegistryReadonlyAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4B2SFYL4LZ",
        "PolicyName": "AWSGlueSchemaRegistryReadonlyAccess",
        "UpdateDate": "2020-11-20T00:20:06+00:00",
        "VersionId": "v1"
    },
    "AWSGlueServiceNotebookRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSGlueServiceNotebookRole",
        "AttachmentCount": 0,
        "CreateDate": "2017-08-14T13:37:42+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:CreateDatabase",
                        "glue:CreatePartition",
                        "glue:CreateTable",
                        "glue:DeleteDatabase",
                        "glue:DeletePartition",
                        "glue:DeleteTable",
                        "glue:GetDatabase",
                        "glue:GetDatabases",
                        "glue:GetPartition",
                        "glue:GetPartitions",
                        "glue:GetTable",
                        "glue:GetTableVersions",
                        "glue:GetTables",
                        "glue:UpdateDatabase",
                        "glue:UpdatePartition",
                        "glue:UpdateTable",
                        "glue:CreateConnection",
                        "glue:CreateJob",
                        "glue:DeleteConnection",
                        "glue:DeleteJob",
                        "glue:GetConnection",
                        "glue:GetConnections",
                        "glue:GetDevEndpoint",
                        "glue:GetDevEndpoints",
                        "glue:GetJob",
                        "glue:GetJobs",
                        "glue:UpdateJob",
                        "glue:BatchDeleteConnection",
                        "glue:UpdateConnection",
                        "glue:GetUserDefinedFunction",
                        "glue:UpdateUserDefinedFunction",
                        "glue:GetUserDefinedFunctions",
                        "glue:DeleteUserDefinedFunction",
                        "glue:CreateUserDefinedFunction",
                        "glue:BatchGetPartition",
                        "glue:BatchDeletePartition",
                        "glue:BatchCreatePartition",
                        "glue:BatchDeleteTable",
                        "glue:UpdateDevEndpoint",
                        "s3:GetBucketLocation",
                        "s3:ListBucket",
                        "s3:ListAllMyBuckets",
                        "s3:GetBucketAcl"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::crawler-public*",
                        "arn:aws:s3:::aws-glue*"
                    ]
                },
                {
                    "Action": [
                        "s3:PutObject",
                        "s3:DeleteObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-glue*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": [
                                "aws-glue-service-resource"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIMRC6VZUHJYCTKWFI",
        "PolicyName": "AWSGlueServiceNotebookRole",
        "UpdateDate": "2019-10-07T18:05:54+00:00",
        "VersionId": "v3"
    },
    "AWSGlueServiceRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole",
        "AttachmentCount": 0,
        "CreateDate": "2017-08-14T13:37:21+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "glue:*",
                        "s3:GetBucketLocation",
                        "s3:ListBucket",
                        "s3:ListAllMyBuckets",
                        "s3:GetBucketAcl",
                        "ec2:DescribeVpcEndpoints",
                        "ec2:DescribeRouteTables",
                        "ec2:CreateNetworkInterface",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcAttribute",
                        "iam:ListRolePolicies",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "cloudwatch:PutMetricData"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:CreateBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-glue-*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject",
                        "s3:DeleteObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-glue-*/*",
                        "arn:aws:s3:::*/*aws-glue-*/*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::crawler-public*",
                        "arn:aws:s3:::aws-glue-*"
                    ]
                },
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:/aws-glue/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": [
                                "aws-glue-service-resource"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIRUJCPEBPMEZFAS32",
        "PolicyName": "AWSGlueServiceRole",
        "UpdateDate": "2018-06-25T18:23:09+00:00",
        "VersionId": "v4"
    },
    "AWSGrafanaAccountAdministrator": {
        "Arn": "arn:aws:iam::aws:policy/AWSGrafanaAccountAdministrator",
        "AttachmentCount": 0,
        "CreateDate": "2021-02-23T00:20:38+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iam:ListRoles"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AWSGrafanaOrganizationAdmin"
                },
                {
                    "Action": "iam:GetRole",
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/*",
                    "Sid": "GrafanaIAMGetRolePermission"
                },
                {
                    "Action": [
                        "grafana:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:grafana:*:*:/workspaces*",
                    "Sid": "AWSGrafanaPermissions"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": "grafana.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/*",
                    "Sid": "GrafanaIAMPassRolePermission"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "sso.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO",
                    "Sid": "SSOSLRPermission"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KHVCM25DH",
        "PolicyName": "AWSGrafanaAccountAdministrator",
        "UpdateDate": "2021-02-23T00:20:38+00:00",
        "VersionId": "v1"
    },
    "AWSGrafanaConsoleReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSGrafanaConsoleReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2021-02-23T00:10:40+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "grafana:DescribeWorkspace",
                        "grafana:ListPermissions",
                        "grafana:ListWorkspaces"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:grafana:*:*:/workspaces*",
                    "Sid": "AWSGrafanaConsoleReadOnlyAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OHSWBMKNF",
        "PolicyName": "AWSGrafanaConsoleReadOnlyAccess",
        "UpdateDate": "2021-02-23T00:10:40+00:00",
        "VersionId": "v1"
    },
    "AWSGrafanaWorkspacePermissionManagement": {
        "Arn": "arn:aws:iam::aws:policy/AWSGrafanaWorkspacePermissionManagement",
        "AttachmentCount": 0,
        "CreateDate": "2021-02-23T00:15:54+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "grafana:DescribeWorkspace",
                        "grafana:UpdatePermissions",
                        "grafana:ListPermissions",
                        "grafana:ListWorkspaces"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:grafana:*:*:/workspaces*",
                    "Sid": "AWSGrafanaPermissions"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4G37QQNGZW",
        "PolicyName": "AWSGrafanaWorkspacePermissionManagement",
        "UpdateDate": "2021-02-23T00:15:54+00:00",
        "VersionId": "v1"
    },
    "AWSGreengrassFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSGreengrassFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-05-03T00:47:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "greengrass:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJWPV6OBK4QONH4J3O",
        "PolicyName": "AWSGreengrassFullAccess",
        "UpdateDate": "2017-05-03T00:47:37+00:00",
        "VersionId": "v1"
    },
    "AWSGreengrassReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSGreengrassReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-30T16:01:43+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "greengrass:List*",
                        "greengrass:Get*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJLSKLXFVTQTZ5GY3I",
        "PolicyName": "AWSGreengrassReadOnlyAccess",
        "UpdateDate": "2018-10-30T16:01:43+00:00",
        "VersionId": "v1"
    },
    "AWSGreengrassResourceAccessRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-02-14T21:17:24+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:DeleteThingShadow",
                        "iot:GetThingShadow",
                        "iot:UpdateThingShadow"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/GG_*",
                        "arn:aws:iot:*:*:thing/*-gcm",
                        "arn:aws:iot:*:*:thing/*-gda",
                        "arn:aws:iot:*:*:thing/*-gci"
                    ],
                    "Sid": "AllowGreengrassAccessToShadows"
                },
                {
                    "Action": [
                        "iot:DescribeThing"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iot:*:*:thing/*",
                    "Sid": "AllowGreengrassToDescribeThings"
                },
                {
                    "Action": [
                        "iot:DescribeCertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iot:*:*:cert/*",
                    "Sid": "AllowGreengrassToDescribeCertificates"
                },
                {
                    "Action": [
                        "greengrass:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowGreengrassToCallGreengrassServices"
                },
                {
                    "Action": [
                        "lambda:GetFunction",
                        "lambda:GetFunctionConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowGreengrassToGetLambdaFunctions"
                },
                {
                    "Action": [
                        "secretsmanager:GetSecretValue"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:secretsmanager:*:*:secret:greengrass-*",
                    "Sid": "AllowGreengrassToGetGreengrassSecrets"
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*Greengrass*",
                        "arn:aws:s3:::*GreenGrass*",
                        "arn:aws:s3:::*greengrass*",
                        "arn:aws:s3:::*Sagemaker*",
                        "arn:aws:s3:::*SageMaker*",
                        "arn:aws:s3:::*sagemaker*"
                    ],
                    "Sid": "AllowGreengrassAccessToS3Objects"
                },
                {
                    "Action": [
                        "s3:GetBucketLocation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowGreengrassAccessToS3BucketLocation"
                },
                {
                    "Action": [
                        "sagemaker:DescribeTrainingJob"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sagemaker:*:*:training-job/*"
                    ],
                    "Sid": "AllowGreengrassAccessToSageMakerTrainingJobs"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJPKEIMB6YMXDEVRTM",
        "PolicyName": "AWSGreengrassResourceAccessRolePolicy",
        "UpdateDate": "2018-11-14T00:35:02+00:00",
        "VersionId": "v5"
    },
    "AWSHealthFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSHealthFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-06T12:30:31+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:EnableAWSServiceAccess",
                        "organizations:DisableAWSServiceAccess"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "organizations:ServicePrincipal": "health.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "health:*",
                        "organizations:ListAccounts",
                        "organizations:ListParents",
                        "organizations:DescribeAccount",
                        "organizations:ListDelegatedAdministrators"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "health.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI3CUMPCPEUPCSXC4Y",
        "PolicyName": "AWSHealthFullAccess",
        "UpdateDate": "2020-11-16T18:11:34+00:00",
        "VersionId": "v3"
    },
    "AWSIQContractServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSIQContractServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-22T19:28:39+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:Subscribe"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4E26ATDUIP",
        "PolicyName": "AWSIQContractServiceRolePolicy",
        "UpdateDate": "2019-08-22T19:28:39+00:00",
        "VersionId": "v1"
    },
    "AWSIQFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIQFullAccess",
        "AttachmentCount": 1,
        "CreateDate": "2019-04-04T23:13:42+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iq:*",
                        "iq-permission:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "permission.iq.amazonaws.com",
                                "contract.iq.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4P4TAHETXT",
        "PolicyName": "AWSIQFullAccess",
        "UpdateDate": "2019-09-25T20:22:34+00:00",
        "VersionId": "v2"
    },
    "AWSIQPermissionServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSIQPermissionServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-22T19:36:29+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iam:DeleteRole",
                        "iam:ListAttachedRolePolicies"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSIQPermission-*"
                },
                {
                    "Action": [
                        "iam:AttachRolePolicy"
                    ],
                    "Condition": {
                        "ArnEquals": {
                            "iam:PolicyARN": "arn:aws:iam::aws:policy/AWSDenyAll"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSIQPermission-*"
                },
                {
                    "Action": [
                        "iam:DetachRolePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/AWSIQPermission-*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4J77DMGFZ5",
        "PolicyName": "AWSIQPermissionServiceRolePolicy",
        "UpdateDate": "2019-08-22T19:36:29+00:00",
        "VersionId": "v1"
    },
    "AWSImageBuilderFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSImageBuilderFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-12-20T18:25:12+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "imagebuilder:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:*imagebuilder*"
                },
                {
                    "Action": [
                        "license-manager:ListLicenseConfigurations",
                        "license-manager:ListLicenseSpecificationsForResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
                },
                {
                    "Action": [
                        "iam:GetInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:instance-profile/*imagebuilder*"
                },
                {
                    "Action": [
                        "iam:ListInstanceProfiles",
                        "iam:ListRoles"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "ec2.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:instance-profile/*imagebuilder*",
                        "arn:aws:iam::*:role/*imagebuilder*"
                    ]
                },
                {
                    "Action": [
                        "s3:ListAllMyBuckets",
                        "s3:GetBucketLocation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3::*:*imagebuilder*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "imagebuilder.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
                },
                {
                    "Action": [
                        "ec2:DescribeImages",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeRegions",
                        "ec2:DescribeVolumes",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeSecurityGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4EO4HCSNZH",
        "PolicyName": "AWSImageBuilderFullAccess",
        "UpdateDate": "2019-12-20T18:25:12+00:00",
        "VersionId": "v1"
    },
    "AWSImageBuilderReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSImageBuilderReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-12-19T22:29:23+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "imagebuilder:Get*",
                        "imagebuilder:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/imagebuilder.amazonaws.com/AWSServiceRoleForImageBuilder"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OD5TC5BXP",
        "PolicyName": "AWSImageBuilderReadOnlyAccess",
        "UpdateDate": "2019-12-19T22:29:23+00:00",
        "VersionId": "v1"
    },
    "AWSImportExportFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSImportExportFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:43+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "importexport:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJCQCT4JGTLC6722MQ",
        "PolicyName": "AWSImportExportFullAccess",
        "UpdateDate": "2015-02-06T18:40:43+00:00",
        "VersionId": "v1"
    },
    "AWSImportExportReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSImportExportReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:42+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "importexport:ListJobs",
                        "importexport:GetStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJNTV4OG52ESYZHCNK",
        "PolicyName": "AWSImportExportReadOnlyAccess",
        "UpdateDate": "2015-02-06T18:40:42+00:00",
        "VersionId": "v1"
    },
    "AWSIoT1ClickFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoT1ClickFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-05-11T22:10:14+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot1click:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJPQNJPDUDESCCAMIA",
        "PolicyName": "AWSIoT1ClickFullAccess",
        "UpdateDate": "2018-05-11T22:10:14+00:00",
        "VersionId": "v1"
    },
    "AWSIoT1ClickReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoT1ClickReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-05-11T21:49:24+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot1click:Describe*",
                        "iot1click:Get*",
                        "iot1click:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI35VTLD3EBNY2JGXS",
        "PolicyName": "AWSIoT1ClickReadOnlyAccess",
        "UpdateDate": "2018-05-11T21:49:24+00:00",
        "VersionId": "v1"
    },
    "AWSIoTAnalyticsFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTAnalyticsFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-18T23:02:45+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotanalytics:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ7FB5ZEKQN445QGKY",
        "PolicyName": "AWSIoTAnalyticsFullAccess",
        "UpdateDate": "2018-06-18T23:02:45+00:00",
        "VersionId": "v1"
    },
    "AWSIoTAnalyticsReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTAnalyticsReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-18T21:37:49+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotanalytics:Describe*",
                        "iotanalytics:List*",
                        "iotanalytics:Get*",
                        "iotanalytics:SampleChannelData"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ3Z4LYBELMXGFLGMI",
        "PolicyName": "AWSIoTAnalyticsReadOnlyAccess",
        "UpdateDate": "2018-06-18T21:37:49+00:00",
        "VersionId": "v1"
    },
    "AWSIoTConfigAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTConfigAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-10-27T21:52:07+00:00",
        "DefaultVersionId": "v9",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:AcceptCertificateTransfer",
                        "iot:AddThingToThingGroup",
                        "iot:AssociateTargetsWithJob",
                        "iot:AttachPolicy",
                        "iot:AttachPrincipalPolicy",
                        "iot:AttachThingPrincipal",
                        "iot:CancelCertificateTransfer",
                        "iot:CancelJob",
                        "iot:CancelJobExecution",
                        "iot:ClearDefaultAuthorizer",
                        "iot:CreateAuthorizer",
                        "iot:CreateCertificateFromCsr",
                        "iot:CreateJob",
                        "iot:CreateKeysAndCertificate",
                        "iot:CreateOTAUpdate",
                        "iot:CreatePolicy",
                        "iot:CreatePolicyVersion",
                        "iot:CreateRoleAlias",
                        "iot:CreateStream",
                        "iot:CreateThing",
                        "iot:CreateThingGroup",
                        "iot:CreateThingType",
                        "iot:CreateTopicRule",
                        "iot:DeleteAuthorizer",
                        "iot:DeleteCACertificate",
                        "iot:DeleteCertificate",
                        "iot:DeleteJob",
                        "iot:DeleteJobExecution",
                        "iot:DeleteOTAUpdate",
                        "iot:DeletePolicy",
                        "iot:DeletePolicyVersion",
                        "iot:DeleteRegistrationCode",
                        "iot:DeleteRoleAlias",
                        "iot:DeleteStream",
                        "iot:DeleteThing",
                        "iot:DeleteThingGroup",
                        "iot:DeleteThingType",
                        "iot:DeleteTopicRule",
                        "iot:DeleteV2LoggingLevel",
                        "iot:DeprecateThingType",
                        "iot:DescribeAuthorizer",
                        "iot:DescribeCACertificate",
                        "iot:DescribeCertificate",
                        "iot:DescribeDefaultAuthorizer",
                        "iot:DescribeEndpoint",
                        "iot:DescribeEventConfigurations",
                        "iot:DescribeIndex",
                        "iot:DescribeJob",
                        "iot:DescribeJobExecution",
                        "iot:DescribeRoleAlias",
                        "iot:DescribeStream",
                        "iot:DescribeThing",
                        "iot:DescribeThingGroup",
                        "iot:DescribeThingRegistrationTask",
                        "iot:DescribeThingType",
                        "iot:DetachPolicy",
                        "iot:DetachPrincipalPolicy",
                        "iot:DetachThingPrincipal",
                        "iot:DisableTopicRule",
                        "iot:EnableTopicRule",
                        "iot:GetEffectivePolicies",
                        "iot:GetIndexingConfiguration",
                        "iot:GetJobDocument",
                        "iot:GetLoggingOptions",
                        "iot:GetOTAUpdate",
                        "iot:GetPolicy",
                        "iot:GetPolicyVersion",
                        "iot:GetRegistrationCode",
                        "iot:GetTopicRule",
                        "iot:GetV2LoggingOptions",
                        "iot:ListAttachedPolicies",
                        "iot:ListAuthorizers",
                        "iot:ListCACertificates",
                        "iot:ListCertificates",
                        "iot:ListCertificatesByCA",
                        "iot:ListIndices",
                        "iot:ListJobExecutionsForJob",
                        "iot:ListJobExecutionsForThing",
                        "iot:ListJobs",
                        "iot:ListOTAUpdates",
                        "iot:ListOutgoingCertificates",
                        "iot:ListPolicies",
                        "iot:ListPolicyPrincipals",
                        "iot:ListPolicyVersions",
                        "iot:ListPrincipalPolicies",
                        "iot:ListPrincipalThings",
                        "iot:ListRoleAliases",
                        "iot:ListStreams",
                        "iot:ListTargetsForPolicy",
                        "iot:ListThingGroups",
                        "iot:ListThingGroupsForThing",
                        "iot:ListThingPrincipals",
                        "iot:ListThingRegistrationTaskReports",
                        "iot:ListThingRegistrationTasks",
                        "iot:ListThings",
                        "iot:ListThingsInThingGroup",
                        "iot:ListThingTypes",
                        "iot:ListTopicRules",
                        "iot:ListV2LoggingLevels",
                        "iot:RegisterCACertificate",
                        "iot:RegisterCertificate",
                        "iot:RegisterThing",
                        "iot:RejectCertificateTransfer",
                        "iot:RemoveThingFromThingGroup",
                        "iot:ReplaceTopicRule",
                        "iot:SearchIndex",
                        "iot:SetDefaultAuthorizer",
                        "iot:SetDefaultPolicyVersion",
                        "iot:SetLoggingOptions",
                        "iot:SetV2LoggingLevel",
                        "iot:SetV2LoggingOptions",
                        "iot:StartThingRegistrationTask",
                        "iot:StopThingRegistrationTask",
                        "iot:TestAuthorization",
                        "iot:TestInvokeAuthorizer",
                        "iot:TransferCertificate",
                        "iot:UpdateAuthorizer",
                        "iot:UpdateCACertificate",
                        "iot:UpdateCertificate",
                        "iot:UpdateEventConfigurations",
                        "iot:UpdateIndexingConfiguration",
                        "iot:UpdateRoleAlias",
                        "iot:UpdateStream",
                        "iot:UpdateThing",
                        "iot:UpdateThingGroup",
                        "iot:UpdateThingGroupsForThing",
                        "iot:UpdateAccountAuditConfiguration",
                        "iot:DescribeAccountAuditConfiguration",
                        "iot:DeleteAccountAuditConfiguration",
                        "iot:StartOnDemandAuditTask",
                        "iot:CancelAuditTask",
                        "iot:DescribeAuditTask",
                        "iot:ListAuditTasks",
                        "iot:CreateScheduledAudit",
                        "iot:UpdateScheduledAudit",
                        "iot:DeleteScheduledAudit",
                        "iot:DescribeScheduledAudit",
                        "iot:ListScheduledAudits",
                        "iot:ListAuditFindings",
                        "iot:CreateSecurityProfile",
                        "iot:DescribeSecurityProfile",
                        "iot:UpdateSecurityProfile",
                        "iot:DeleteSecurityProfile",
                        "iot:AttachSecurityProfile",
                        "iot:DetachSecurityProfile",
                        "iot:ListSecurityProfiles",
                        "iot:ListSecurityProfilesForTarget",
                        "iot:ListTargetsForSecurityProfile",
                        "iot:ListActiveViolations",
                        "iot:ListViolationEvents",
                        "iot:ValidateSecurityProfileBehaviors"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIWWGD4LM4EMXNRL7I",
        "PolicyName": "AWSIoTConfigAccess",
        "UpdateDate": "2019-09-27T20:48:00+00:00",
        "VersionId": "v9"
    },
    "AWSIoTConfigReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTConfigReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-10-27T21:52:31+00:00",
        "DefaultVersionId": "v8",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:DescribeAuthorizer",
                        "iot:DescribeCACertificate",
                        "iot:DescribeCertificate",
                        "iot:DescribeDefaultAuthorizer",
                        "iot:DescribeEndpoint",
                        "iot:DescribeEventConfigurations",
                        "iot:DescribeIndex",
                        "iot:DescribeJob",
                        "iot:DescribeJobExecution",
                        "iot:DescribeRoleAlias",
                        "iot:DescribeStream",
                        "iot:DescribeThing",
                        "iot:DescribeThingGroup",
                        "iot:DescribeThingRegistrationTask",
                        "iot:DescribeThingType",
                        "iot:GetEffectivePolicies",
                        "iot:GetIndexingConfiguration",
                        "iot:GetJobDocument",
                        "iot:GetLoggingOptions",
                        "iot:GetOTAUpdate",
                        "iot:GetPolicy",
                        "iot:GetPolicyVersion",
                        "iot:GetRegistrationCode",
                        "iot:GetTopicRule",
                        "iot:GetV2LoggingOptions",
                        "iot:ListAttachedPolicies",
                        "iot:ListAuthorizers",
                        "iot:ListCACertificates",
                        "iot:ListCertificates",
                        "iot:ListCertificatesByCA",
                        "iot:ListIndices",
                        "iot:ListJobExecutionsForJob",
                        "iot:ListJobExecutionsForThing",
                        "iot:ListJobs",
                        "iot:ListOTAUpdates",
                        "iot:ListOutgoingCertificates",
                        "iot:ListPolicies",
                        "iot:ListPolicyPrincipals",
                        "iot:ListPolicyVersions",
                        "iot:ListPrincipalPolicies",
                        "iot:ListPrincipalThings",
                        "iot:ListRoleAliases",
                        "iot:ListStreams",
                        "iot:ListTargetsForPolicy",
                        "iot:ListThingGroups",
                        "iot:ListThingGroupsForThing",
                        "iot:ListThingPrincipals",
                        "iot:ListThingRegistrationTaskReports",
                        "iot:ListThingRegistrationTasks",
                        "iot:ListThings",
                        "iot:ListThingsInThingGroup",
                        "iot:ListThingTypes",
                        "iot:ListTopicRules",
                        "iot:ListV2LoggingLevels",
                        "iot:SearchIndex",
                        "iot:TestAuthorization",
                        "iot:TestInvokeAuthorizer",
                        "iot:DescribeAccountAuditConfiguration",
                        "iot:DescribeAuditTask",
                        "iot:ListAuditTasks",
                        "iot:DescribeScheduledAudit",
                        "iot:ListScheduledAudits",
                        "iot:ListAuditFindings",
                        "iot:DescribeSecurityProfile",
                        "iot:ListSecurityProfiles",
                        "iot:ListSecurityProfilesForTarget",
                        "iot:ListTargetsForSecurityProfile",
                        "iot:ListActiveViolations",
                        "iot:ListViolationEvents",
                        "iot:ValidateSecurityProfileBehaviors"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJHENEMXGX4XMFOIOI",
        "PolicyName": "AWSIoTConfigReadOnlyAccess",
        "UpdateDate": "2019-09-27T20:52:40+00:00",
        "VersionId": "v8"
    },
    "AWSIoTDataAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTDataAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-10-27T21:51:18+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:Connect",
                        "iot:Publish",
                        "iot:Subscribe",
                        "iot:Receive",
                        "iot:GetThingShadow",
                        "iot:UpdateThingShadow",
                        "iot:DeleteThingShadow"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJM2KI2UJDR24XPS2K",
        "PolicyName": "AWSIoTDataAccess",
        "UpdateDate": "2017-11-16T18:24:11+00:00",
        "VersionId": "v2"
    },
    "AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-07T17:55:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:ListPrincipalThings",
                        "iot:AddThingToThingGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HEHG3RV6B",
        "PolicyName": "AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction",
        "UpdateDate": "2019-08-07T17:55:37+00:00",
        "VersionId": "v1"
    },
    "AWSIoTDeviceDefenderAudit": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTDeviceDefenderAudit",
        "AttachmentCount": 0,
        "CreateDate": "2018-07-18T21:17:40+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:GetLoggingOptions",
                        "iot:GetV2LoggingOptions",
                        "iot:ListCACertificates",
                        "iot:ListCertificates",
                        "iot:DescribeCACertificate",
                        "iot:DescribeCertificate",
                        "iot:ListPolicies",
                        "iot:GetPolicy",
                        "iot:GetEffectivePolicies",
                        "iot:ListRoleAliases",
                        "iot:DescribeRoleAlias",
                        "cognito-identity:GetIdentityPoolRoles",
                        "iam:ListRolePolicies",
                        "iam:ListAttachedRolePolicies",
                        "iam:GetRole",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion",
                        "iam:GetRolePolicy",
                        "iam:GenerateServiceLastAccessedDetails",
                        "iam:GetServiceLastAccessedDetails"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJKUN6OAGIHZ66TRKO",
        "PolicyName": "AWSIoTDeviceDefenderAudit",
        "UpdateDate": "2019-11-25T23:52:43+00:00",
        "VersionId": "v3"
    },
    "AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-07T17:04:07+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:SetV2LoggingOptions"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "iot.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4G34KP2NLZ",
        "PolicyName": "AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction",
        "UpdateDate": "2019-08-07T17:04:07+00:00",
        "VersionId": "v1"
    },
    "AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-07T17:04:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4GZL2FL6JV",
        "PolicyName": "AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction",
        "UpdateDate": "2019-08-07T17:04:37+00:00",
        "VersionId": "v1"
    },
    "AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-07T17:04:57+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:CreatePolicyVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HN4VCIBCR",
        "PolicyName": "AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction",
        "UpdateDate": "2019-08-07T17:04:57+00:00",
        "VersionId": "v1"
    },
    "AWSIoTDeviceDefenderUpdateCACertMitigationAction": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTDeviceDefenderUpdateCACertMitigationAction",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-07T17:05:49+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:UpdateCACertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KLBGET6KX",
        "PolicyName": "AWSIoTDeviceDefenderUpdateCACertMitigationAction",
        "UpdateDate": "2019-08-07T17:05:49+00:00",
        "VersionId": "v1"
    },
    "AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-07T17:06:00+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:UpdateCertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KB4AHFGEB",
        "PolicyName": "AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction",
        "UpdateDate": "2019-08-07T17:06:00+00:00",
        "VersionId": "v1"
    },
    "AWSIoTDeviceTesterForFreeRTOSFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTDeviceTesterForFreeRTOSFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-02-12T20:33:53+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "iot.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/idt-*",
                    "Sid": "VisualEditor0"
                },
                {
                    "Action": [
                        "iot:DeleteThing",
                        "iot:AttachThingPrincipal",
                        "iot:DeleteCertificate",
                        "iot:GetRegistrationCode",
                        "iot:CreatePolicy",
                        "iot:UpdateCACertificate",
                        "s3:ListBucket",
                        "iot:DescribeEndpoint",
                        "iot:CreateOTAUpdate",
                        "iot:CreateStream",
                        "signer:ListSigningJobs",
                        "acm:ListCertificates",
                        "iot:CreateKeysAndCertificate",
                        "iot:UpdateCertificate",
                        "iot:CreateCertificateFromCsr",
                        "iot:DetachThingPrincipal",
                        "iot:RegisterCACertificate",
                        "iot:CreateThing",
                        "freertos:ListHardwarePlatforms",
                        "iam:ListRoles",
                        "iot:RegisterCertificate",
                        "iot:DeleteCACertificate",
                        "signer:PutSigningProfile",
                        "s3:ListAllMyBuckets",
                        "signer:ListSigningPlatforms",
                        "iot-device-tester:SendMetrics",
                        "iot-device-tester:SupportedVersion",
                        "iot-device-tester:LatestIdt",
                        "iot-device-tester:CheckVersion",
                        "iot-device-tester:DownloadTestSuite"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "VisualEditor1"
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "signer:StartSigningJob",
                        "acm:GetCertificate",
                        "signer:DescribeSigningJob",
                        "s3:CreateBucket",
                        "execute-api:Invoke",
                        "s3:DeleteBucket",
                        "s3:PutBucketVersioning",
                        "signer:CancelSigningProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:execute-api:us-east-1:098862408343:9xpmnvs5h4/prod/POST/metrics",
                        "arn:aws:signer:*:*:/signing-profiles/*",
                        "arn:aws:signer:*:*:/signing-jobs/*",
                        "arn:aws:iam::*:role/idt-*",
                        "arn:aws:acm:*:*:certificate/*",
                        "arn:aws:s3:::idt-*",
                        "arn:aws:s3:::afr-ota*"
                    ],
                    "Sid": "VisualEditor2"
                },
                {
                    "Action": [
                        "iot:DeleteStream",
                        "iot:DeleteCertificate",
                        "iot:AttachPolicy",
                        "iot:DetachPolicy",
                        "iot:DeletePolicy",
                        "s3:ListBucketVersions",
                        "iot:UpdateCertificate",
                        "iot:GetOTAUpdate",
                        "iot:DeleteOTAUpdate",
                        "iot:DescribeJobExecution"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::afr-ota*",
                        "arn:aws:iot:*:*:thinggroup/idt*",
                        "arn:aws:iam::*:role/idt-*"
                    ],
                    "Sid": "VisualEditor3"
                },
                {
                    "Action": [
                        "iot:DeleteCertificate",
                        "iot:AttachPolicy",
                        "iot:DetachPolicy",
                        "s3:DeleteObjectVersion",
                        "iot:DeleteOTAUpdate",
                        "s3:PutObject",
                        "s3:GetObject",
                        "iot:DeleteStream",
                        "iot:DeletePolicy",
                        "s3:DeleteObject",
                        "iot:UpdateCertificate",
                        "iot:GetOTAUpdate",
                        "s3:GetObjectVersion",
                        "iot:DescribeJobExecution"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::afr-ota*/*",
                        "arn:aws:s3:::idt-*/*",
                        "arn:aws:iot:*:*:policy/idt*",
                        "arn:aws:iam::*:role/idt-*",
                        "arn:aws:iot:*:*:otaupdate/idt*",
                        "arn:aws:iot:*:*:thing/idt*",
                        "arn:aws:iot:*:*:cert/*",
                        "arn:aws:iot:*:*:job/*",
                        "arn:aws:iot:*:*:stream/*"
                    ],
                    "Sid": "VisualEditor4"
                },
                {
                    "Action": [
                        "s3:PutObject",
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::afr-ota*/*",
                        "arn:aws:s3:::idt-*/*"
                    ],
                    "Sid": "VisualEditor5"
                },
                {
                    "Action": [
                        "iot:CancelJobExecution"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:job/*",
                        "arn:aws:iot:*:*:thing/idt*"
                    ],
                    "Sid": "VisualEditor6"
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/Owner": "IoTDeviceTester"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ],
                    "Sid": "VisualEditor7"
                },
                {
                    "Action": [
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:DeleteSecurityGroup"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/Owner": "IoTDeviceTester"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:security-group/*"
                    ],
                    "Sid": "VisualEditor8"
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:RequestTag/Owner": "IoTDeviceTester"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ],
                    "Sid": "VisualEditor9"
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:image/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:volume/*",
                        "arn:aws:ec2:*:*:key-pair/*",
                        "arn:aws:ec2:*:*:placement-group/*",
                        "arn:aws:ec2:*:*:snapshot/*",
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:subnet/*"
                    ],
                    "Sid": "VisualEditor10"
                },
                {
                    "Action": [
                        "ec2:CreateSecurityGroup"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:RequestTag/Owner": "IoTDeviceTester"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:security-group/*"
                    ],
                    "Sid": "VisualEditor11"
                },
                {
                    "Action": [
                        "ec2:DescribeInstances",
                        "ec2:DescribeSecurityGroups",
                        "ssm:DescribeParameters",
                        "ssm:GetParameters"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "VisualEditor12"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:TagKeys": [
                                "Owner"
                            ],
                            "ec2:CreateAction": [
                                "RunInstances",
                                "CreateSecurityGroup"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:instance/*"
                    ],
                    "Sid": "VisualEditor13"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4ADNJ2YUUH",
        "PolicyName": "AWSIoTDeviceTesterForFreeRTOSFullAccess",
        "UpdateDate": "2020-12-15T18:03:46+00:00",
        "VersionId": "v5"
    },
    "AWSIoTDeviceTesterForGreengrassFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTDeviceTesterForGreengrassFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-02-20T21:21:27+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "iot.amazonaws.com",
                                "lambda.amazonaws.com",
                                "greengrass.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/idt-*",
                    "Sid": "VisualEditor1"
                },
                {
                    "Action": [
                        "lambda:CreateFunction",
                        "iot:DeleteCertificate",
                        "lambda:DeleteFunction",
                        "execute-api:Invoke",
                        "iot:UpdateCertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:execute-api:us-east-1:098862408343:9xpmnvs5h4/prod/POST/metrics",
                        "arn:aws:lambda:*:*:function:idt-*",
                        "arn:aws:iot:*:*:cert/*"
                    ],
                    "Sid": "VisualEditor2"
                },
                {
                    "Action": [
                        "iot:CreateThing",
                        "iot:DeleteThing"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/idt-*",
                        "arn:aws:iot:*:*:cert/*"
                    ],
                    "Sid": "VisualEditor3"
                },
                {
                    "Action": [
                        "iot:AttachPolicy",
                        "iot:DetachPolicy",
                        "iot:DeletePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:policy/idt-*",
                        "arn:aws:iot:*:*:cert/*"
                    ],
                    "Sid": "VisualEditor4"
                },
                {
                    "Action": [
                        "iot:CreateJob",
                        "iot:DescribeJob",
                        "iot:DescribeJobExecution",
                        "iot:DeleteJob"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/idt-*",
                        "arn:aws:iot:*:*:job/*"
                    ],
                    "Sid": "VisualEditor5"
                },
                {
                    "Action": [
                        "iot:DescribeEndpoint",
                        "greengrass:*",
                        "iam:ListAttachedRolePolicies",
                        "iot:CreatePolicy",
                        "iot:GetThingShadow",
                        "iot:CreateKeysAndCertificate",
                        "iot:ListThings",
                        "iot:UpdateThingShadow",
                        "iot:CreateCertificateFromCsr",
                        "iot-device-tester:SendMetrics",
                        "iot-device-tester:SupportedVersion",
                        "iot-device-tester:LatestIdt",
                        "iot-device-tester:CheckVersion",
                        "iot-device-tester:DownloadTestSuite"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "VisualEditor6"
                },
                {
                    "Action": [
                        "iot:DetachThingPrincipal",
                        "iot:AttachThingPrincipal"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/idt-*",
                        "arn:aws:iot:*:*:cert/*"
                    ],
                    "Sid": "VisualEditor7"
                },
                {
                    "Action": [
                        "s3:PutObject",
                        "s3:DeleteObjectVersion",
                        "s3:ListBucketVersions",
                        "s3:CreateBucket",
                        "s3:DeleteObject",
                        "s3:DeleteBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::idt*",
                    "Sid": "VisualEditor8"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4ORKVZSPY7",
        "PolicyName": "AWSIoTDeviceTesterForGreengrassFullAccess",
        "UpdateDate": "2020-06-25T17:01:56+00:00",
        "VersionId": "v4"
    },
    "AWSIoTEventsFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTEventsFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-01-10T22:51:57+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotevents:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJGA726P7LVUWJZ2LM",
        "PolicyName": "AWSIoTEventsFullAccess",
        "UpdateDate": "2019-01-10T22:51:57+00:00",
        "VersionId": "v1"
    },
    "AWSIoTEventsReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTEventsReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-01-10T22:50:08+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotevents:Describe*",
                        "iotevents:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJYJFNAR7CN5JW52PG",
        "PolicyName": "AWSIoTEventsReadOnlyAccess",
        "UpdateDate": "2019-09-23T17:22:04+00:00",
        "VersionId": "v2"
    },
    "AWSIoTFleetHubFederationAccess": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTFleetHubFederationAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T08:08:05+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:DescribeIndex",
                        "iot:DescribeThingGroup",
                        "iot:GetBucketsAggregation",
                        "iot:GetCardinality",
                        "iot:GetIndexingConfiguration",
                        "iot:GetPercentiles",
                        "iot:GetStatistics",
                        "iot:SearchIndex",
                        "iot:CreateFleetMetric",
                        "iot:ListFleetMetrics",
                        "iot:DeleteFleetMetric",
                        "iot:DescribeFleetMetric",
                        "iot:UpdateFleetMetric",
                        "iotfleethub:ListDashboards",
                        "iotfleethub:DescribeDashboard",
                        "iotfleethub:DescribeApplication",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:GetMetricData",
                        "cloudwatch:ListMetrics",
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "sns:CreateTopic",
                        "sns:DeleteTopic",
                        "sns:ListSubscriptionsByTopic",
                        "sns:Subscribe",
                        "sns:Unsubscribe"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:iotfleethub*"
                },
                {
                    "Action": [
                        "cloudwatch:PutMetricAlarm",
                        "cloudwatch:DeleteAlarms",
                        "cloudwatch:DescribeAlarmHistory"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudwatch:*:*:iotfleethub*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4H4EGQA254",
        "PolicyName": "AWSIoTFleetHubFederationAccess",
        "UpdateDate": "2020-12-15T08:08:05+00:00",
        "VersionId": "v1"
    },
    "AWSIoTFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-10-08T15:19:49+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJU2FPGG6PQWN72V2G",
        "PolicyName": "AWSIoTFullAccess",
        "UpdateDate": "2015-10-08T15:19:49+00:00",
        "VersionId": "v1"
    },
    "AWSIoTLogging": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTLogging",
        "AttachmentCount": 0,
        "CreateDate": "2015-10-08T15:17:25+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                        "logs:PutMetricFilter",
                        "logs:PutRetentionPolicy",
                        "logs:GetLogEvents",
                        "logs:DeleteLogStream"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI6R6Z2FHHGS454W7W",
        "PolicyName": "AWSIoTLogging",
        "UpdateDate": "2015-10-08T15:17:25+00:00",
        "VersionId": "v1"
    },
    "AWSIoTOTAUpdate": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTOTAUpdate",
        "AttachmentCount": 0,
        "CreateDate": "2017-12-20T20:36:53+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": {
                "Action": [
                    "iot:CreateJob",
                    "signer:DescribeSigningJob"
                ],
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJLJYWX53STBZFPUEY",
        "PolicyName": "AWSIoTOTAUpdate",
        "UpdateDate": "2017-12-20T20:36:53+00:00",
        "VersionId": "v1"
    },
    "AWSIoTRuleActions": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTRuleActions",
        "AttachmentCount": 0,
        "CreateDate": "2015-10-08T15:14:51+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": {
                "Action": [
                    "dynamodb:PutItem",
                    "kinesis:PutRecord",
                    "iot:Publish",
                    "s3:PutObject",
                    "sns:Publish",
                    "sqs:SendMessage*",
                    "cloudwatch:SetAlarmState",
                    "cloudwatch:PutMetricData",
                    "es:ESHttpPut",
                    "firehose:PutRecord"
                ],
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJEZ6FS7BUZVUHMOKY",
        "PolicyName": "AWSIoTRuleActions",
        "UpdateDate": "2018-01-16T19:28:19+00:00",
        "VersionId": "v2"
    },
    "AWSIoTSiteWiseConsoleFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTSiteWiseConsoleFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-05-31T21:37:49+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "iotsitewise:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iotanalytics:List*",
                        "iotanalytics:Describe*",
                        "iotanalytics:Create*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iot:DescribeEndpoint",
                        "iot:GetThingShadow"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "greengrass:GetGroup",
                        "greengrass:GetGroupVersion",
                        "greengrass:GetCoreDefinitionVersion",
                        "greengrass:ListGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "secretsmanager:ListSecrets",
                        "secretsmanager:CreateSecret"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "secretsmanager:UpdateSecret"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:secretsmanager:*:*:secret:greengrass-*"
                },
                {
                    "Action": [
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "iotsitewise.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/iotsitewise.amazonaws.com/AWSServiceRoleForIoTSiteWise*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "iotsitewise.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/iotsitewise.amazonaws.com/AWSServiceRoleForIoTSiteWise*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4K7KP5VA7F",
        "PolicyName": "AWSIoTSiteWiseConsoleFullAccess",
        "UpdateDate": "2019-05-31T21:37:49+00:00",
        "VersionId": "v1"
    },
    "AWSIoTSiteWiseFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTSiteWiseFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-12-04T20:53:39+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotsitewise:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAILUK3XBM6TZ5Q3PX2",
        "PolicyName": "AWSIoTSiteWiseFullAccess",
        "UpdateDate": "2018-12-04T20:53:39+00:00",
        "VersionId": "v1"
    },
    "AWSIoTSiteWiseMonitorPortalAccess": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTSiteWiseMonitorPortalAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-19T20:01:21+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotsitewise:CreateProject",
                        "iotsitewise:DescribeProject",
                        "iotsitewise:UpdateProject",
                        "iotsitewise:DeleteProject",
                        "iotsitewise:ListProjects",
                        "iotsitewise:BatchAssociateProjectAssets",
                        "iotsitewise:BatchDisassociateProjectAssets",
                        "iotsitewise:ListProjectAssets",
                        "iotsitewise:CreateDashboard",
                        "iotsitewise:DescribeDashboard",
                        "iotsitewise:UpdateDashboard",
                        "iotsitewise:DeleteDashboard",
                        "iotsitewise:ListDashboards",
                        "iotsitewise:CreateAccessPolicy",
                        "iotsitewise:DescribeAccessPolicy",
                        "iotsitewise:UpdateAccessPolicy",
                        "iotsitewise:DeleteAccessPolicy",
                        "iotsitewise:ListAccessPolicies",
                        "iotsitewise:DescribeAsset",
                        "iotsitewise:ListAssets",
                        "iotsitewise:ListAssociatedAssets",
                        "iotsitewise:DescribeAssetProperty",
                        "iotsitewise:GetAssetPropertyValue",
                        "iotsitewise:GetAssetPropertyValueHistory",
                        "iotsitewise:GetAssetPropertyAggregates",
                        "sso-directory:DescribeUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4E6CZDALWJ",
        "PolicyName": "AWSIoTSiteWiseMonitorPortalAccess",
        "UpdateDate": "2020-05-19T20:01:21+00:00",
        "VersionId": "v1"
    },
    "AWSIoTSiteWiseMonitorServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSIoTSiteWiseMonitorServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-14T00:59:10+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotsitewise:CreateProject",
                        "iotsitewise:DescribeProject",
                        "iotsitewise:UpdateProject",
                        "iotsitewise:DeleteProject",
                        "iotsitewise:ListProjects",
                        "iotsitewise:BatchAssociateProjectAssets",
                        "iotsitewise:BatchDisassociateProjectAssets",
                        "iotsitewise:ListProjectAssets",
                        "iotsitewise:CreateDashboard",
                        "iotsitewise:DescribeDashboard",
                        "iotsitewise:UpdateDashboard",
                        "iotsitewise:DeleteDashboard",
                        "iotsitewise:ListDashboards",
                        "iotsitewise:CreateAccessPolicy",
                        "iotsitewise:DescribeAccessPolicy",
                        "iotsitewise:UpdateAccessPolicy",
                        "iotsitewise:DeleteAccessPolicy",
                        "iotsitewise:ListAccessPolicies",
                        "iotsitewise:DescribeAsset",
                        "iotsitewise:ListAssets",
                        "iotsitewise:ListAssociatedAssets",
                        "iotsitewise:DescribeAssetProperty",
                        "iotsitewise:GetAssetPropertyValue",
                        "iotsitewise:GetAssetPropertyValueHistory",
                        "iotsitewise:GetAssetPropertyAggregates",
                        "sso-directory:DescribeUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4CR556M6Y5",
        "PolicyName": "AWSIoTSiteWiseMonitorServiceRolePolicy",
        "UpdateDate": "2019-12-13T22:19:25+00:00",
        "VersionId": "v2"
    },
    "AWSIoTSiteWiseReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTSiteWiseReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-12-04T20:55:11+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotsitewise:Describe*",
                        "iotsitewise:List*",
                        "iotsitewise:Get*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJLHEAFKME2QL64WKK",
        "PolicyName": "AWSIoTSiteWiseReadOnlyAccess",
        "UpdateDate": "2018-12-04T20:55:11+00:00",
        "VersionId": "v1"
    },
    "AWSIoTThingsRegistration": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSIoTThingsRegistration",
        "AttachmentCount": 0,
        "CreateDate": "2017-12-01T20:21:52+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:AddThingToThingGroup",
                        "iot:AttachPolicy",
                        "iot:AttachPrincipalPolicy",
                        "iot:AttachThingPrincipal",
                        "iot:CreateCertificateFromCsr",
                        "iot:CreatePolicy",
                        "iot:CreateThing",
                        "iot:DescribeCertificate",
                        "iot:DescribeThing",
                        "iot:DescribeThingGroup",
                        "iot:DescribeThingType",
                        "iot:DetachPolicy",
                        "iot:DetachThingPrincipal",
                        "iot:GetPolicy",
                        "iot:ListAttachedPolicies",
                        "iot:ListPolicyPrincipals",
                        "iot:ListPrincipalPolicies",
                        "iot:ListPrincipalThings",
                        "iot:ListTargetsForPolicy",
                        "iot:ListThingGroupsForThing",
                        "iot:ListThingPrincipals",
                        "iot:RegisterCertificate",
                        "iot:RegisterThing",
                        "iot:RemoveThingFromThingGroup",
                        "iot:UpdateCertificate",
                        "iot:UpdateThing",
                        "iot:UpdateThingGroupsForThing",
                        "iot:AddThingToBillingGroup",
                        "iot:DescribeBillingGroup",
                        "iot:RemoveThingFromBillingGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI3YQXTC5XAEVTJNEU",
        "PolicyName": "AWSIoTThingsRegistration",
        "UpdateDate": "2020-10-05T19:20:12+00:00",
        "VersionId": "v3"
    },
    "AWSIoTWirelessDataAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTWirelessDataAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T15:31:39+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotwireless:SendDataToWirelessDevice"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HH6GBXNUO",
        "PolicyName": "AWSIoTWirelessDataAccess",
        "UpdateDate": "2020-12-15T15:31:39+00:00",
        "VersionId": "v1"
    },
    "AWSIoTWirelessFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTWirelessFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T15:27:57+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotwireless:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4L5RZVVSRQ",
        "PolicyName": "AWSIoTWirelessFullAccess",
        "UpdateDate": "2020-12-15T15:27:57+00:00",
        "VersionId": "v1"
    },
    "AWSIoTWirelessFullPublishAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTWirelessFullPublishAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T15:29:59+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:DescribeEndpoint",
                        "iot:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4JSRC2FZ22",
        "PolicyName": "AWSIoTWirelessFullPublishAccess",
        "UpdateDate": "2020-12-15T15:29:59+00:00",
        "VersionId": "v1"
    },
    "AWSIoTWirelessGatewayCertManager": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTWirelessGatewayCertManager",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T15:30:48+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:CreateKeysAndCertificate",
                        "iot:DescribeCertificate",
                        "iot:ListCertificates"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "IoTWirelessGatewayCertManager"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4O6BH33Y6U",
        "PolicyName": "AWSIoTWirelessGatewayCertManager",
        "UpdateDate": "2020-12-15T15:30:48+00:00",
        "VersionId": "v1"
    },
    "AWSIoTWirelessLogging": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTWirelessLogging",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T15:32:40+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:DescribeLogGroups",
                        "logs:DescribeLogStreams",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/iotwireless*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4L3X44AIHR",
        "PolicyName": "AWSIoTWirelessLogging",
        "UpdateDate": "2020-12-15T15:32:40+00:00",
        "VersionId": "v1"
    },
    "AWSIoTWirelessReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSIoTWirelessReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-15T15:28:56+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotwireless:List*",
                        "iotwireless:Get*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FJYYSL3ZA",
        "PolicyName": "AWSIoTWirelessReadOnlyAccess",
        "UpdateDate": "2020-12-15T15:28:56+00:00",
        "VersionId": "v1"
    },
    "AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-14T20:10:53+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudhsm:Describe*",
                        "ec2:CreateNetworkInterface",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CreateSecurityGroup",
                        "ec2:DescribeSecurityGroups",
                        "ec2:RevokeSecurityGroupEgress",
                        "ec2:DeleteSecurityGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIADMJEHVVYK5AUQOO",
        "PolicyName": "AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy",
        "UpdateDate": "2018-11-14T20:10:53+00:00",
        "VersionId": "v1"
    },
    "AWSKeyManagementServicePowerUser": {
        "Arn": "arn:aws:iam::aws:policy/AWSKeyManagementServicePowerUser",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:40+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "kms:CreateAlias",
                        "kms:CreateKey",
                        "kms:DeleteAlias",
                        "kms:Describe*",
                        "kms:GenerateRandom",
                        "kms:Get*",
                        "kms:List*",
                        "kms:TagResource",
                        "kms:UntagResource",
                        "iam:ListGroups",
                        "iam:ListRoles",
                        "iam:ListUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJNPP7PPPPMJRV2SA4",
        "PolicyName": "AWSKeyManagementServicePowerUser",
        "UpdateDate": "2017-03-07T00:55:11+00:00",
        "VersionId": "v2"
    },
    "AWSLakeFormationCrossAccountManager": {
        "Arn": "arn:aws:iam::aws:policy/AWSLakeFormationCrossAccountManager",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-04T20:59:46+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ram:CreateResourceShare"
                    ],
                    "Condition": {
                        "StringLikeIfExists": {
                            "ram:RequestedResourceType": [
                                "glue:Table",
                                "glue:Database",
                                "glue:Catalog"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ram:UpdateResourceShare",
                        "ram:DeleteResourceShare"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ram:ResourceShareName": [
                                "LakeFormation*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "glue:PutResourcePolicy",
                        "glue:DeleteResourcePolicy",
                        "organizations:DescribeOrganization",
                        "organizations:DescribeAccount",
                        "ram:Get*",
                        "ram:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "organizations:ListRoots",
                        "organizations:ListAccountsForParent",
                        "organizations:ListOrganizationalUnitsForParent"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4HPT7Y7QL3",
        "PolicyName": "AWSLakeFormationCrossAccountManager",
        "UpdateDate": "2020-12-07T23:11:36+00:00",
        "VersionId": "v3"
    },
    "AWSLakeFormationDataAdmin": {
        "Arn": "arn:aws:iam::aws:policy/AWSLakeFormationDataAdmin",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-08T17:33:44+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "lakeformation:*",
                        "cloudtrail:DescribeTrails",
                        "cloudtrail:LookupEvents",
                        "glue:GetDatabase",
                        "glue:GetDatabases",
                        "glue:CreateDatabase",
                        "glue:UpdateDatabase",
                        "glue:DeleteDatabase",
                        "glue:GetConnections",
                        "glue:SearchTables",
                        "glue:GetTable",
                        "glue:CreateTable",
                        "glue:UpdateTable",
                        "glue:DeleteTable",
                        "glue:GetTableVersions",
                        "glue:GetPartitions",
                        "glue:GetTables",
                        "glue:GetWorkflow",
                        "glue:ListWorkflows",
                        "glue:BatchGetWorkflows",
                        "glue:DeleteWorkflow",
                        "glue:GetWorkflowRuns",
                        "glue:StartWorkflowRun",
                        "glue:GetWorkflow",
                        "s3:ListBucket",
                        "s3:GetBucketLocation",
                        "s3:ListAllMyBuckets",
                        "s3:GetBucketAcl",
                        "iam:ListUsers",
                        "iam:ListRoles",
                        "iam:GetRole",
                        "iam:GetRolePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "lakeformation:PutDataLakeSettings"
                    ],
                    "Effect": "Deny",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OWCH3ENIA",
        "PolicyName": "AWSLakeFormationDataAdmin",
        "UpdateDate": "2019-12-16T22:41:40+00:00",
        "VersionId": "v2"
    },
    "AWSLambdaBasicExecutionRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-04-09T15:03:43+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJNCQGXC42545SKXIK",
        "PolicyName": "AWSLambdaBasicExecutionRole",
        "UpdateDate": "2015-04-09T15:03:43+00:00",
        "VersionId": "v1"
    },
    "AWSLambdaDynamoDBExecutionRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaDynamoDBExecutionRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-04-09T15:09:29+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dynamodb:DescribeStream",
                        "dynamodb:GetRecords",
                        "dynamodb:GetShardIterator",
                        "dynamodb:ListStreams",
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIP7WNAGMIPYNW4WQG",
        "PolicyName": "AWSLambdaDynamoDBExecutionRole",
        "UpdateDate": "2015-04-09T15:09:29+00:00",
        "VersionId": "v1"
    },
    "AWSLambdaENIManagementAccess": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaENIManagementAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-06T00:37:27+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CreateNetworkInterface",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DeleteNetworkInterface",
                        "ec2:AssignPrivateIpAddresses",
                        "ec2:UnassignPrivateIpAddresses"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJXAW2Q3KPTURUT2QC",
        "PolicyName": "AWSLambdaENIManagementAccess",
        "UpdateDate": "2020-10-01T20:07:26+00:00",
        "VersionId": "v2"
    },
    "AWSLambdaExecute": {
        "Arn": "arn:aws:iam::aws:policy/AWSLambdaExecute",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:46+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJE5FX7FQZSU5XAKGO",
        "PolicyName": "AWSLambdaExecute",
        "UpdateDate": "2015-02-06T18:40:46+00:00",
        "VersionId": "v1"
    },
    "AWSLambdaFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSLambdaFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:45+00:00",
        "DefaultVersionId": "v8",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DescribeStacks",
                        "cloudformation:GetTemplate",
                        "cloudformation:ListStackResources",
                        "cloudwatch:*",
                        "cognito-identity:ListIdentityPools",
                        "cognito-sync:GetCognitoEvents",
                        "cognito-sync:SetCognitoEvents",
                        "dynamodb:*",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "events:*",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListRolePolicies",
                        "iam:ListRoles",
                        "iam:PassRole",
                        "iot:AttachPrincipalPolicy",
                        "iot:AttachThingPrincipal",
                        "iot:CreateKeysAndCertificate",
                        "iot:CreatePolicy",
                        "iot:CreateThing",
                        "iot:CreateTopicRule",
                        "iot:DescribeEndpoint",
                        "iot:GetTopicRule",
                        "iot:ListPolicies",
                        "iot:ListThings",
                        "iot:ListTopicRules",
                        "iot:ReplaceTopicRule",
                        "kinesis:DescribeStream",
                        "kinesis:ListStreams",
                        "kinesis:PutRecord",
                        "kms:ListAliases",
                        "lambda:*",
                        "logs:*",
                        "s3:*",
                        "sns:ListSubscriptions",
                        "sns:ListSubscriptionsByTopic",
                        "sns:ListTopics",
                        "sns:Publish",
                        "sns:Subscribe",
                        "sns:Unsubscribe",
                        "sqs:ListQueues",
                        "sqs:SendMessage",
                        "tag:GetResources",
                        "xray:PutTelemetryRecords",
                        "xray:PutTraceSegments"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI6E2CYYMI4XI7AA5K",
        "PolicyName": "AWSLambdaFullAccess",
        "UpdateDate": "2017-11-27T23:22:38+00:00",
        "VersionId": "v8"
    },
    "AWSLambdaInvocation-DynamoDB": {
        "Arn": "arn:aws:iam::aws:policy/AWSLambdaInvocation-DynamoDB",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:47+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "lambda:InvokeFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dynamodb:DescribeStream",
                        "dynamodb:GetRecords",
                        "dynamodb:GetShardIterator",
                        "dynamodb:ListStreams"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJTHQ3EKCQALQDYG5G",
        "PolicyName": "AWSLambdaInvocation-DynamoDB",
        "UpdateDate": "2015-02-06T18:40:47+00:00",
        "VersionId": "v1"
    },
    "AWSLambdaKinesisExecutionRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaKinesisExecutionRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-04-09T15:14:16+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "kinesis:DescribeStream",
                        "kinesis:DescribeStreamSummary",
                        "kinesis:GetRecords",
                        "kinesis:GetShardIterator",
                        "kinesis:ListShards",
                        "kinesis:ListStreams",
                        "kinesis:SubscribeToShard",
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJHOLKJPXV4GBRMJUQ",
        "PolicyName": "AWSLambdaKinesisExecutionRole",
        "UpdateDate": "2018-11-19T20:09:24+00:00",
        "VersionId": "v2"
    },
    "AWSLambdaMSKExecutionRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaMSKExecutionRole",
        "AttachmentCount": 0,
        "CreateDate": "2020-08-11T17:35:05+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "kafka:DescribeCluster",
                        "kafka:GetBootstrapBrokers",
                        "ec2:CreateNetworkInterface",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeVpcs",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeSecurityGroups",
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FHMXOHIS5",
        "PolicyName": "AWSLambdaMSKExecutionRole",
        "UpdateDate": "2020-08-11T17:35:05+00:00",
        "VersionId": "v1"
    },
    "AWSLambdaReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSLambdaReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:44+00:00",
        "DefaultVersionId": "v8",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DescribeStacks",
                        "cloudformation:GetTemplate",
                        "cloudformation:ListStackResources",
                        "cloudwatch:Describe*",
                        "cloudwatch:Get*",
                        "cloudwatch:List*",
                        "cognito-identity:ListIdentityPools",
                        "cognito-sync:GetCognitoEvents",
                        "dynamodb:BatchGetItem",
                        "dynamodb:DescribeStream",
                        "dynamodb:DescribeTable",
                        "dynamodb:GetItem",
                        "dynamodb:ListStreams",
                        "dynamodb:ListTables",
                        "dynamodb:Query",
                        "dynamodb:Scan",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "events:Describe*",
                        "events:List*",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListRolePolicies",
                        "iam:ListRoles",
                        "iot:DescribeEndpoint",
                        "iot:GetTopicRule",
                        "iot:ListPolicies",
                        "iot:ListThings",
                        "iot:ListTopicRules",
                        "kinesis:DescribeStream",
                        "kinesis:ListStreams",
                        "kms:ListAliases",
                        "lambda:Get*",
                        "lambda:List*",
                        "logs:DescribeLogGroups",
                        "logs:DescribeLogStreams",
                        "logs:DescribeMetricFilters",
                        "logs:GetLogEvents",
                        "s3:Get*",
                        "s3:List*",
                        "sns:ListSubscriptions",
                        "sns:ListSubscriptionsByTopic",
                        "sns:ListTopics",
                        "sqs:ListQueues",
                        "tag:GetResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJLDG7J3CGUHFN4YN6",
        "PolicyName": "AWSLambdaReadOnlyAccess",
        "UpdateDate": "2018-09-06T18:04:54+00:00",
        "VersionId": "v8"
    },
    "AWSLambdaReplicator": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSLambdaReplicator",
        "AttachmentCount": 0,
        "CreateDate": "2017-05-23T17:53:03+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "lambda:CreateFunction",
                        "lambda:DeleteFunction",
                        "lambda:DisableReplication"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:*"
                    ],
                    "Sid": "LambdaCreateDeletePermission"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLikeIfExists": {
                            "iam:PassedToService": "lambda.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "IamPassRolePermission"
                },
                {
                    "Action": [
                        "cloudfront:ListDistributionsByLambdaFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "CloudFrontListDistributions"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIIQFXZNNLL3E2HKTG",
        "PolicyName": "AWSLambdaReplicator",
        "UpdateDate": "2017-12-08T00:17:54+00:00",
        "VersionId": "v3"
    },
    "AWSLambdaRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaRole",
        "AttachmentCount": 1,
        "CreateDate": "2015-02-06T18:41:28+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "lambda:InvokeFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJX4DPCRGTC4NFDUXI",
        "PolicyName": "AWSLambdaRole",
        "UpdateDate": "2015-02-06T18:41:28+00:00",
        "VersionId": "v1"
    },
    "AWSLambdaSQSQueueExecutionRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaSQSQueueExecutionRole",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-14T21:50:45+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sqs:ReceiveMessage",
                        "sqs:DeleteMessage",
                        "sqs:GetQueueAttributes",
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJFWJZI6JNND4TSELK",
        "PolicyName": "AWSLambdaSQSQueueExecutionRole",
        "UpdateDate": "2018-06-14T21:50:45+00:00",
        "VersionId": "v1"
    },
    "AWSLambdaVPCAccessExecutionRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole",
        "AttachmentCount": 0,
        "CreateDate": "2016-02-11T23:15:26+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                        "ec2:CreateNetworkInterface",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DeleteNetworkInterface",
                        "ec2:AssignPrivateIpAddresses",
                        "ec2:UnassignPrivateIpAddresses"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJVTME3YLVNL72YR2K",
        "PolicyName": "AWSLambdaVPCAccessExecutionRole",
        "UpdateDate": "2020-10-15T22:53:03+00:00",
        "VersionId": "v2"
    },
    "AWSLambda_FullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSLambda_FullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-17T21:14:08+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeStacks",
                        "cloudformation:ListStackResources",
                        "cloudwatch:ListMetrics",
                        "cloudwatch:GetMetricData",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "kms:ListAliases",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListRolePolicies",
                        "iam:ListRoles",
                        "lambda:*",
                        "logs:DescribeLogGroups",
                        "states:DescribeStateMachine",
                        "states:ListStateMachines",
                        "tag:GetResources",
                        "xray:GetTraceSummaries",
                        "xray:BatchGetTraces"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "lambda.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:DescribeLogStreams",
                        "logs:GetLogEvents",
                        "logs:FilterLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/lambda/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OXQPYWZ5D",
        "PolicyName": "AWSLambda_FullAccess",
        "UpdateDate": "2020-11-17T21:14:08+00:00",
        "VersionId": "v1"
    },
    "AWSLambda_ReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSLambda_ReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-17T21:10:32+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeStacks",
                        "cloudformation:ListStackResources",
                        "cloudwatch:GetMetricData",
                        "cloudwatch:ListMetrics",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "kms:ListAliases",
                        "iam:GetPolicy",
                        "iam:GetPolicyVersion",
                        "iam:GetRole",
                        "iam:GetRolePolicy",
                        "iam:ListAttachedRolePolicies",
                        "iam:ListRolePolicies",
                        "iam:ListRoles",
                        "logs:DescribeLogGroups",
                        "lambda:Get*",
                        "lambda:List*",
                        "states:DescribeStateMachine",
                        "states:ListStateMachines",
                        "tag:GetResources",
                        "xray:GetTraceSummaries",
                        "xray:BatchGetTraces"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:DescribeLogStreams",
                        "logs:GetLogEvents",
                        "logs:FilterLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/lambda/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IERNVMNPE",
        "PolicyName": "AWSLambda_ReadOnlyAccess",
        "UpdateDate": "2020-11-17T21:10:32+00:00",
        "VersionId": "v1"
    },
    "AWSLicenseManagerMasterAccountRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSLicenseManagerMasterAccountRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-26T19:03:51+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:GetBucketLocation",
                        "s3:ListBucket",
                        "s3:GetLifecycleConfiguration",
                        "s3:PutLifecycleConfiguration",
                        "s3:GetBucketPolicy",
                        "s3:PutBucketPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-license-manager-service-*"
                    ],
                    "Sid": "S3BucketPermissions"
                },
                {
                    "Action": [
                        "s3:AbortMultipartUpload",
                        "s3:PutObject",
                        "s3:GetObject",
                        "s3:ListBucketMultipartUploads",
                        "s3:ListMultipartUploadParts"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-license-manager-service-*"
                    ],
                    "Sid": "S3ObjectPermissions1"
                },
                {
                    "Action": [
                        "s3:DeleteObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-license-manager-service-*/resource_sync/*"
                    ],
                    "Sid": "S3ObjectPermissions2"
                },
                {
                    "Action": [
                        "athena:GetQueryExecution",
                        "athena:GetQueryResults",
                        "athena:StartQueryExecution"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AthenaPermissions"
                },
                {
                    "Action": [
                        "glue:GetTable",
                        "glue:GetPartition",
                        "glue:GetPartitions"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "GluePermissions"
                },
                {
                    "Action": [
                        "organizations:DescribeOrganization",
                        "organizations:ListAccounts",
                        "organizations:DescribeAccount",
                        "organizations:ListChildren",
                        "organizations:ListParents",
                        "organizations:ListAccountsForParent",
                        "organizations:ListRoots",
                        "organizations:ListAWSServiceAccessForOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "OrganizationPermissions"
                },
                {
                    "Action": [
                        "ram:GetResourceShares",
                        "ram:GetResourceShareAssociations",
                        "ram:TagResource"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "RAMPermissions1"
                },
                {
                    "Action": [
                        "ram:CreateResourceShare"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:RequestTag/Service": "LicenseManager"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "RAMPermissions2"
                },
                {
                    "Action": [
                        "ram:AssociateResourceShare",
                        "ram:DisassociateResourceShare",
                        "ram:UpdateResourceShare",
                        "ram:DeleteResourceShare"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ram:ResourceTag/Service": "LicenseManager"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "RAMPermissions3"
                },
                {
                    "Action": [
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "IAMGetRoles"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "cloudformation.amazonaws.com",
                                "glue.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/LicenseManagerServiceResourceDataSyncRole*"
                    ],
                    "Sid": "IAMPassRoles"
                },
                {
                    "Action": [
                        "cloudformation:UpdateStack",
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:DescribeStacks"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/LicenseManagerCrossAccountCloudDiscoveryStack/*"
                    ],
                    "Sid": "CloudformationPermission"
                },
                {
                    "Action": [
                        "glue:CreateTable",
                        "glue:UpdateTable",
                        "glue:DeleteTable",
                        "glue:UpdateJob",
                        "glue:UpdateCrawler"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:glue:*:*:catalog",
                        "arn:aws:glue:*:*:crawler/LicenseManagerResourceSynDataCrawler",
                        "arn:aws:glue:*:*:job/LicenseManagerResourceSynDataProcessJob",
                        "arn:aws:glue:*:*:table/license_manager_resource_inventory_db/*",
                        "arn:aws:glue:*:*:table/license_manager_resource_sync/*",
                        "arn:aws:glue:*:*:database/license_manager_resource_inventory_db",
                        "arn:aws:glue:*:*:database/license_manager_resource_sync"
                    ],
                    "Sid": "GlueUpdatePermissions"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIJE2NOZW2BDEHYUH2",
        "PolicyName": "AWSLicenseManagerMasterAccountRolePolicy",
        "UpdateDate": "2019-08-29T22:56:41+00:00",
        "VersionId": "v3"
    },
    "AWSLicenseManagerMemberAccountRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSLicenseManagerMemberAccountRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-26T19:04:32+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "license-manager:UpdateLicenseSpecificationsForResource",
                        "license-manager:GetLicenseConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "LicenseManagerPermissions"
                },
                {
                    "Action": [
                        "ssm:ListInventoryEntries",
                        "ssm:GetInventory",
                        "ssm:CreateAssociation",
                        "ssm:CreateResourceDataSync",
                        "ssm:DeleteResourceDataSync",
                        "ssm:ListResourceDataSync",
                        "ssm:ListAssociations"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "SSMPermissions"
                },
                {
                    "Action": [
                        "ram:AcceptResourceShareInvitation",
                        "ram:GetResourceShareInvitations"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "RAMPermissions"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJZTYEY2LEGBYAVUY4",
        "PolicyName": "AWSLicenseManagerMemberAccountRolePolicy",
        "UpdateDate": "2019-11-15T22:09:32+00:00",
        "VersionId": "v2"
    },
    "AWSLicenseManagerServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSLicenseManagerServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-26T19:02:53+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:GetBucketLocation",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-license-manager-service-*"
                    ],
                    "Sid": "S3BucketPermissions1"
                },
                {
                    "Action": [
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "S3BucketPermissions2"
                },
                {
                    "Action": [
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-license-manager-service-*"
                    ],
                    "Sid": "S3ObjectPermissions"
                },
                {
                    "Action": [
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sns:*:*:aws-license-manager-service-*"
                    ],
                    "Sid": "SNSAccountPermissions"
                },
                {
                    "Action": [
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "SNSTopicPermissions"
                },
                {
                    "Action": [
                        "ec2:DescribeInstances",
                        "ec2:DescribeImages",
                        "ec2:DescribeHosts"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "EC2Permissions"
                },
                {
                    "Action": [
                        "ssm:ListInventoryEntries",
                        "ssm:GetInventory",
                        "ssm:CreateAssociation"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "SSMPermissions"
                },
                {
                    "Action": [
                        "organizations:ListAWSServiceAccessForOrganization",
                        "organizations:DescribeOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "OrganizationPermissions"
                },
                {
                    "Action": [
                        "license-manager:GetServiceSettings",
                        "license-manager:GetLicense*",
                        "license-manager:UpdateLicenseSpecificationsForResource",
                        "license-manager:ListUsageForLicenseConfiguration",
                        "license-manager:ListDistributedGrants"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "LicenseManagerPermissions"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIM7JPETWHTYNBQSZE",
        "PolicyName": "AWSLicenseManagerServiceRolePolicy",
        "UpdateDate": "2020-12-03T08:38:18+00:00",
        "VersionId": "v3"
    },
    "AWSMarketplaceAmiIngestion": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceAmiIngestion",
        "AttachmentCount": 0,
        "CreateDate": "2020-09-25T20:55:10+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:ModifySnapshotAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:us-east-1::snapshot/snap-*"
                },
                {
                    "Action": [
                        "ec2:DescribeImageAttribute",
                        "ec2:DescribeImages",
                        "ec2:DescribeSnapshotAttribute",
                        "ec2:ModifyImageAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4AV3OZYWEM",
        "PolicyName": "AWSMarketplaceAmiIngestion",
        "UpdateDate": "2020-09-25T20:55:10+00:00",
        "VersionId": "v1"
    },
    "AWSMarketplaceFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-11T17:21:45+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:*",
                        "cloudformation:CreateStack",
                        "cloudformation:DescribeStackResource",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DescribeStacks",
                        "cloudformation:List*",
                        "ec2:AuthorizeSecurityGroupEgress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateTags",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAddresses",
                        "ec2:DeleteSecurityGroup",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeTags",
                        "ec2:DescribeVpcs",
                        "ec2:RunInstances",
                        "ec2:StartInstances",
                        "ec2:StopInstances",
                        "ec2:TerminateInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CopyImage",
                        "ec2:DeregisterImage",
                        "ec2:DescribeSnapshots",
                        "ec2:DeleteSnapshot",
                        "ec2:CreateImage",
                        "ec2:DescribeInstanceStatus",
                        "ssm:GetAutomationExecution",
                        "ssm:UpdateDocumentDefaultVersion",
                        "ssm:CreateDocument",
                        "ssm:StartAutomationExecution",
                        "ssm:ListDocuments",
                        "ssm:UpdateDocument",
                        "ssm:DescribeDocument",
                        "sns:ListTopics",
                        "sns:GetTopicAttributes",
                        "sns:CreateTopic",
                        "iam:GetRole",
                        "iam:GetInstanceProfile",
                        "iam:ListRoles",
                        "iam:ListInstanceProfiles"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:ListBucket",
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*image-build*"
                    ]
                },
                {
                    "Action": [
                        "sns:Publish",
                        "sns:setTopicAttributes"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sns:*:*:*image-build*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ssm.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI2DV5ULJSO2FYVPYG",
        "PolicyName": "AWSMarketplaceFullAccess",
        "UpdateDate": "2018-08-08T21:13:02+00:00",
        "VersionId": "v3"
    },
    "AWSMarketplaceGetEntitlements": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceGetEntitlements",
        "AttachmentCount": 0,
        "CreateDate": "2017-03-27T19:37:24+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:GetEntitlements"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJLPIMQE4WMHDC2K7C",
        "PolicyName": "AWSMarketplaceGetEntitlements",
        "UpdateDate": "2017-03-27T19:37:24+00:00",
        "VersionId": "v1"
    },
    "AWSMarketplaceImageBuildFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceImageBuildFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-07-31T23:29:49+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:ListBuilds",
                        "aws-marketplace:StartBuild",
                        "aws-marketplace:DescribeBuilds"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:TerminateInstances",
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/marketplace-image-build:build-id": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ssm.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/*Automation*",
                        "arn:aws:iam::*:role/*Instance*"
                    ]
                },
                {
                    "Action": [
                        "ssm:GetAutomationExecution",
                        "ssm:CreateDocument",
                        "ssm:StartAutomationExecution",
                        "ssm:ListDocuments",
                        "ssm:UpdateDocument",
                        "ssm:UpdateDocumentDefaultVersion",
                        "ssm:DescribeDocument",
                        "ec2:DeregisterImage",
                        "ec2:CopyImage",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeImages",
                        "ec2:DescribeSubnets",
                        "ec2:DeleteSnapshot",
                        "ec2:CreateImage",
                        "ec2:RunInstances",
                        "ec2:DescribeInstanceStatus",
                        "sns:GetTopicAttributes",
                        "iam:GetRole",
                        "iam:GetInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*image-build*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*::image/*",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sns:*:*:*image-build*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI4QBMJWC3BNHBHN6I",
        "PolicyName": "AWSMarketplaceImageBuildFullAccess",
        "UpdateDate": "2018-08-08T21:11:59+00:00",
        "VersionId": "v2"
    },
    "AWSMarketplaceLicenseManagementServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSMarketplaceLicenseManagementServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-03T08:33:40+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:DescribeOrganization",
                        "license-manager:ListReceivedGrants",
                        "license-manager:ListDistributedGrants",
                        "license-manager:GetGrant",
                        "license-manager:CreateGrant",
                        "license-manager:CreateGrantVersion",
                        "license-manager:DeleteGrant",
                        "license-manager:AcceptGrant"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AllowLicenseManagerActions"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4DTCV6FSO7",
        "PolicyName": "AWSMarketplaceLicenseManagementServiceRolePolicy",
        "UpdateDate": "2020-12-03T08:33:40+00:00",
        "VersionId": "v1"
    },
    "AWSMarketplaceManageSubscriptions": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceManageSubscriptions",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:32+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:ViewSubscriptions",
                        "aws-marketplace:Subscribe",
                        "aws-marketplace:Unsubscribe"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:CreatePrivateMarketplaceRequests",
                        "aws-marketplace:ListPrivateMarketplaceRequests",
                        "aws-marketplace:DescribePrivateMarketplaceRequests"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJRDW2WIFN7QLUAKBQ",
        "PolicyName": "AWSMarketplaceManageSubscriptions",
        "UpdateDate": "2019-10-28T21:49:43+00:00",
        "VersionId": "v2"
    },
    "AWSMarketplaceMeteringFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceMeteringFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-03-17T22:39:22+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:MeterUsage"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ65YJPG7CC7LDXNA6",
        "PolicyName": "AWSMarketplaceMeteringFullAccess",
        "UpdateDate": "2016-03-17T22:39:22+00:00",
        "VersionId": "v1"
    },
    "AWSMarketplaceMeteringRegisterUsage": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceMeteringRegisterUsage",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-21T01:17:54+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:RegisterUsage"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OIHJX73MZ",
        "PolicyName": "AWSMarketplaceMeteringRegisterUsage",
        "UpdateDate": "2019-11-21T01:17:54+00:00",
        "VersionId": "v1"
    },
    "AWSMarketplaceProcurementSystemAdminFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceProcurementSystemAdminFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-25T13:07:47+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:PutProcurementSystemConfiguration",
                        "aws-marketplace:DescribeProcurementSystemConfiguration",
                        "organizations:Describe*",
                        "organizations:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FIYNR3TC4",
        "PolicyName": "AWSMarketplaceProcurementSystemAdminFullAccess",
        "UpdateDate": "2019-06-25T13:07:47+00:00",
        "VersionId": "v1"
    },
    "AWSMarketplaceRead-only": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceRead-only",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:31+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:ViewSubscriptions",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:ListBuilds",
                        "aws-marketplace:DescribeBuilds",
                        "iam:ListRoles",
                        "iam:ListInstanceProfiles",
                        "sns:GetTopicAttributes",
                        "sns:ListTopics"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:ListPrivateMarketplaceRequests",
                        "aws-marketplace:DescribePrivateMarketplaceRequests"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJOOM6LETKURTJ3XZ2",
        "PolicyName": "AWSMarketplaceRead-only",
        "UpdateDate": "2019-10-28T21:51:31+00:00",
        "VersionId": "v3"
    },
    "AWSMarketplaceSellerFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceSellerFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-07-02T20:40:09+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace-management:uploadFiles",
                        "aws-marketplace-management:viewMarketing",
                        "aws-marketplace-management:viewReports",
                        "aws-marketplace-management:viewSupport",
                        "aws-marketplace-management:viewSettings",
                        "aws-marketplace:ListChangeSets",
                        "aws-marketplace:DescribeChangeSet",
                        "aws-marketplace:StartChangeSet",
                        "aws-marketplace:CancelChangeSet",
                        "aws-marketplace:ListEntities",
                        "aws-marketplace:DescribeEntity",
                        "aws-marketplace:ListTasks",
                        "aws-marketplace:DescribeTask",
                        "aws-marketplace:UpdateTask",
                        "aws-marketplace:CompleteTask",
                        "ec2:DescribeImages",
                        "ec2:DescribeSnapshots",
                        "ec2:ModifyImageAttribute",
                        "ec2:ModifySnapshotAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "aws-marketplace:SearchAgreements",
                        "aws-marketplace:DescribeAgreement",
                        "aws-marketplace:GetAgreementTerms"
                    ],
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws-marketplace:AgreementType": [
                                "PurchaseAgreement"
                            ]
                        },
                        "StringEquals": {
                            "aws-marketplace:PartyType": "Proposer"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "assets.marketplace.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4JF7OFUANW",
        "PolicyName": "AWSMarketplaceSellerFullAccess",
        "UpdateDate": "2020-10-09T22:23:38+00:00",
        "VersionId": "v4"
    },
    "AWSMarketplaceSellerProductsFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceSellerProductsFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-07-02T21:06:25+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:ListChangeSets",
                        "aws-marketplace:DescribeChangeSet",
                        "aws-marketplace:StartChangeSet",
                        "aws-marketplace:CancelChangeSet",
                        "aws-marketplace:ListEntities",
                        "aws-marketplace:DescribeEntity",
                        "aws-marketplace:ListTasks",
                        "aws-marketplace:DescribeTask",
                        "aws-marketplace:UpdateTask",
                        "aws-marketplace:CompleteTask",
                        "ec2:DescribeImages",
                        "ec2:DescribeSnapshots",
                        "ec2:ModifyImageAttribute",
                        "ec2:ModifySnapshotAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "assets.marketplace.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4DS2YFEG4N",
        "PolicyName": "AWSMarketplaceSellerProductsFullAccess",
        "UpdateDate": "2020-10-09T22:22:38+00:00",
        "VersionId": "v3"
    },
    "AWSMarketplaceSellerProductsReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSMarketplaceSellerProductsReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2019-07-02T21:40:47+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:ListChangeSets",
                        "aws-marketplace:DescribeChangeSet",
                        "aws-marketplace:ListEntities",
                        "aws-marketplace:DescribeEntity",
                        "aws-marketplace:ListTasks",
                        "aws-marketplace:DescribeTask",
                        "ec2:DescribeImages",
                        "ec2:DescribeSnapshots"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4K5Y2Q5F7D",
        "PolicyName": "AWSMarketplaceSellerProductsReadOnly",
        "UpdateDate": "2020-03-05T23:11:53+00:00",
        "VersionId": "v2"
    },
    "AWSMigrationHubDMSAccess": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSMigrationHubDMSAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-08-14T14:00:06+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mgh:CreateProgressUpdateStream"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:mgh:*:*:progressUpdateStream/DMS"
                },
                {
                    "Action": [
                        "mgh:AssociateCreatedArtifact",
                        "mgh:DescribeMigrationTask",
                        "mgh:DisassociateCreatedArtifact",
                        "mgh:ImportMigrationTask",
                        "mgh:ListCreatedArtifacts",
                        "mgh:NotifyMigrationTaskState",
                        "mgh:PutResourceAttributes",
                        "mgh:NotifyApplicationState",
                        "mgh:DescribeApplicationState",
                        "mgh:AssociateDiscoveredResource",
                        "mgh:DisassociateDiscoveredResource",
                        "mgh:ListDiscoveredResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:mgh:*:*:progressUpdateStream/DMS/*"
                },
                {
                    "Action": [
                        "mgh:ListMigrationTasks",
                        "mgh:GetHomeRegion"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIUQB56VA4JHLN7G2W",
        "PolicyName": "AWSMigrationHubDMSAccess",
        "UpdateDate": "2019-10-07T17:51:53+00:00",
        "VersionId": "v2"
    },
    "AWSMigrationHubDiscoveryAccess": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSMigrationHubDiscoveryAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-08-14T13:30:51+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "discovery:ListConfigurations",
                        "discovery:DescribeConfigurations"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "ec2:CreateTags",
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": "aws:migrationhub:source-id"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*",
                        "arn:aws:ec2:*:*:image/*",
                        "arn:aws:ec2:*:*:volume/*"
                    ]
                },
                {
                    "Action": "dms:AddTagsToResource",
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": "aws:migrationhub:source-id"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:dms:*:*:endpoint:*"
                    ]
                },
                {
                    "Action": [
                        "ec2:DescribeInstanceAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAITRMRLSV7JAL6YIGG",
        "PolicyName": "AWSMigrationHubDiscoveryAccess",
        "UpdateDate": "2020-08-06T17:34:42+00:00",
        "VersionId": "v3"
    },
    "AWSMigrationHubFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMigrationHubFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-08-14T14:02:54+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mgh:*",
                        "discovery:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "continuousexport.discovery.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
                },
                {
                    "Action": [
                        "iam:DeleteServiceLinkedRole",
                        "iam:GetServiceLinkedRoleDeletionStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/continuousexport.discovery.amazonaws.com/AWSServiceRoleForApplicationDiscoveryServiceContinuousExport*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "migrationhub.amazonaws.com",
                                "dmsintegration.migrationhub.amazonaws.com",
                                "smsintegration.migrationhub.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ4A2SZKHUYHDYIGOK",
        "PolicyName": "AWSMigrationHubFullAccess",
        "UpdateDate": "2019-06-19T21:14:41+00:00",
        "VersionId": "v4"
    },
    "AWSMigrationHubSMSAccess": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSMigrationHubSMSAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-08-14T13:57:54+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "mgh:CreateProgressUpdateStream"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:mgh:*:*:progressUpdateStream/SMS"
                },
                {
                    "Action": [
                        "mgh:AssociateCreatedArtifact",
                        "mgh:DescribeMigrationTask",
                        "mgh:DisassociateCreatedArtifact",
                        "mgh:ImportMigrationTask",
                        "mgh:ListCreatedArtifacts",
                        "mgh:NotifyMigrationTaskState",
                        "mgh:PutResourceAttributes",
                        "mgh:NotifyApplicationState",
                        "mgh:DescribeApplicationState",
                        "mgh:AssociateDiscoveredResource",
                        "mgh:DisassociateDiscoveredResource",
                        "mgh:ListDiscoveredResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:mgh:*:*:progressUpdateStream/SMS/*"
                },
                {
                    "Action": [
                        "mgh:ListMigrationTasks",
                        "mgh:GetHomeRegion"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIWQYYT6TSVIRJO4TY",
        "PolicyName": "AWSMigrationHubSMSAccess",
        "UpdateDate": "2019-10-07T18:01:22+00:00",
        "VersionId": "v2"
    },
    "AWSMobileHub_FullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSMobileHub_FullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-01-05T19:56:01+00:00",
        "DefaultVersionId": "v14",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "apigateway:GET",
                        "apigateway:POST",
                        "cloudfront:GetDistribution",
                        "devicefarm:CreateProject",
                        "devicefarm:ListJobs",
                        "devicefarm:ListRuns",
                        "devicefarm:GetProject",
                        "devicefarm:GetRun",
                        "devicefarm:ListArtifacts",
                        "devicefarm:ListProjects",
                        "devicefarm:ScheduleRun",
                        "dynamodb:DescribeTable",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "iam:ListSAMLProviders",
                        "lambda:ListFunctions",
                        "sns:ListTopics",
                        "lex:GetIntent",
                        "lex:GetIntents",
                        "lex:GetSlotType",
                        "lex:GetSlotTypes",
                        "lex:GetBot",
                        "lex:GetBots",
                        "lex:GetBotAlias",
                        "lex:GetBotAliases",
                        "mobilehub:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*/aws-my-sample-app*.zip"
                },
                {
                    "Action": [
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*-mobilehub-*/*"
                },
                {
                    "Action": [
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*-mobilehub-*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIJLU43R6AGRBK76DM",
        "PolicyName": "AWSMobileHub_FullAccess",
        "UpdateDate": "2019-12-19T23:15:52+00:00",
        "VersionId": "v14"
    },
    "AWSMobileHub_ReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSMobileHub_ReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2016-01-05T19:55:48+00:00",
        "DefaultVersionId": "v10",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dynamodb:DescribeTable",
                        "iam:ListSAMLProviders",
                        "lambda:ListFunctions",
                        "sns:ListTopics",
                        "lex:GetIntent",
                        "lex:GetIntents",
                        "lex:GetSlotType",
                        "lex:GetSlotTypes",
                        "lex:GetBot",
                        "lex:GetBots",
                        "lex:GetBotAlias",
                        "lex:GetBotAliases",
                        "mobilehub:ExportProject",
                        "mobilehub:GenerateProjectParameters",
                        "mobilehub:GetProject",
                        "mobilehub:SynchronizeProject",
                        "mobilehub:GetProjectSnapshot",
                        "mobilehub:ListProjectSnapshots",
                        "mobilehub:ListAvailableConnectors",
                        "mobilehub:ListAvailableFeatures",
                        "mobilehub:ListAvailableRegions",
                        "mobilehub:ListProjects",
                        "mobilehub:ValidateProject",
                        "mobilehub:VerifyServiceRole",
                        "mobilehub:DescribeBundle",
                        "mobilehub:ExportBundle",
                        "mobilehub:ListBundles"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::*/aws-my-sample-app*.zip"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIBXVYVL3PWQFBZFGW",
        "PolicyName": "AWSMobileHub_ReadOnly",
        "UpdateDate": "2018-07-23T21:59:05+00:00",
        "VersionId": "v10"
    },
    "AWSNetworkFirewallServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSNetworkFirewallServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-17T17:17:26+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:CreateVpcEndpoint",
                        "ec2:DescribeVpcEndpoints"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:RequestTag/AWSNetworkFirewallManaged": "true",
                            "ec2:CreateAction": "CreateVpcEndpoint"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:vpc-endpoint/*"
                },
                {
                    "Action": [
                        "ec2:DeleteVpcEndpoints"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:ResourceTag/AWSNetworkFirewallManaged": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4DF6QQZAL3",
        "PolicyName": "AWSNetworkFirewallServiceRolePolicy",
        "UpdateDate": "2020-11-17T17:17:26+00:00",
        "VersionId": "v1"
    },
    "AWSNetworkManagerFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSNetworkManagerFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-12-03T17:37:58+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "networkmanager:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "networkmanager.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4ARXJ4NU7I",
        "PolicyName": "AWSNetworkManagerFullAccess",
        "UpdateDate": "2019-12-03T17:37:58+00:00",
        "VersionId": "v1"
    },
    "AWSNetworkManagerReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSNetworkManagerReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-12-03T17:35:05+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "networkmanager:Describe*",
                        "networkmanager:Get*",
                        "networkmanager:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4LZFJOS62Z",
        "PolicyName": "AWSNetworkManagerReadOnlyAccess",
        "UpdateDate": "2019-12-03T17:35:05+00:00",
        "VersionId": "v1"
    },
    "AWSNetworkManagerServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSNetworkManagerServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-12-03T14:03:35+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "directconnect:DescribeConnections",
                        "directconnect:DescribeDirectConnectGatewayAttachments",
                        "directconnect:DescribeLocations",
                        "directconnect:DescribeVirtualInterfaces",
                        "ec2:DescribeCustomerGateways",
                        "ec2:DescribeTransitGatewayAttachments",
                        "ec2:DescribeTransitGatewayRouteTables",
                        "ec2:DescribeTransitGateways",
                        "ec2:DescribeVpnConnections",
                        "ec2:GetTransitGatewayRouteTableAssociations",
                        "ec2:SearchTransitGatewayRoutes",
                        "ec2:DescribeTransitGatewayPeeringAttachments",
                        "ec2:DescribeTransitGatewayConnects",
                        "ec2:DescribeTransitGatewayConnectPeers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4B346KOB7I",
        "PolicyName": "AWSNetworkManagerServiceRolePolicy",
        "UpdateDate": "2020-12-10T12:06:22+00:00",
        "VersionId": "v3"
    },
    "AWSOpsWorksCMInstanceProfileRole": {
        "Arn": "arn:aws:iam::aws:policy/AWSOpsWorksCMInstanceProfileRole",
        "AttachmentCount": 0,
        "CreateDate": "2016-11-24T09:48:22+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeStackResource",
                        "cloudformation:SignalResource"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:AbortMultipartUpload",
                        "s3:DeleteObject",
                        "s3:GetObject",
                        "s3:ListAllMyBuckets",
                        "s3:ListBucket",
                        "s3:ListMultipartUploadParts",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::aws-opsworks-cm-*"
                },
                {
                    "Action": "acm:GetCertificate",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "secretsmanager:GetSecretValue",
                    "Effect": "Allow",
                    "Resource": "arn:aws:secretsmanager:*:*:aws-opsworks-cm-secrets-*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAICSU3OSHCURP2WIZW",
        "PolicyName": "AWSOpsWorksCMInstanceProfileRole",
        "UpdateDate": "2021-01-12T09:37:42+00:00",
        "VersionId": "v4"
    },
    "AWSOpsWorksCMServiceRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSOpsWorksCMServiceRole",
        "AttachmentCount": 0,
        "CreateDate": "2016-11-24T09:49:46+00:00",
        "DefaultVersionId": "v13",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:CreateBucket",
                        "s3:DeleteObject",
                        "s3:DeleteBucket",
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:PutBucketPolicy",
                        "s3:PutObject",
                        "s3:GetBucketTagging",
                        "s3:PutBucketTagging"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-opsworks-cm-*"
                    ]
                },
                {
                    "Action": [
                        "tag:UntagResources",
                        "tag:TagResources"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ssm:DescribeInstanceInformation",
                        "ssm:GetCommandInvocation",
                        "ssm:ListCommandInvocations",
                        "ssm:ListCommands"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ssm:SendCommand"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ssm:resourceTag/aws:cloudformation:stack-name": "aws-opsworks-cm-*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ssm:SendCommand"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*::document/*",
                        "arn:aws:s3:::aws-opsworks-cm-*"
                    ]
                },
                {
                    "Action": [
                        "ec2:AllocateAddress",
                        "ec2:AssociateAddress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CreateImage",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateSnapshot",
                        "ec2:CreateTags",
                        "ec2:DeleteSecurityGroup",
                        "ec2:DeleteSnapshot",
                        "ec2:DeregisterImage",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstanceStatus",
                        "ec2:DescribeInstances",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeSubnets",
                        "ec2:DisassociateAddress",
                        "ec2:ReleaseAddress",
                        "ec2:RunInstances",
                        "ec2:StopInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances",
                        "ec2:RebootInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-name": "aws-opsworks-cm-*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "opsworks-cm:DeleteServer",
                        "opsworks-cm:StartMaintenance"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:opsworks-cm:*:*:server/*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DescribeStacks",
                        "cloudformation:UpdateStack"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/aws-opsworks-cm-*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-opsworks-cm-*",
                        "arn:aws:iam::*:role/service-role/aws-opsworks-cm-*"
                    ]
                },
                {
                    "Action": [
                        "acm:DeleteCertificate",
                        "acm:ImportCertificate"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "secretsmanager:CreateSecret",
                        "secretsmanager:GetSecretValue",
                        "secretsmanager:UpdateSecret",
                        "secretsmanager:DeleteSecret",
                        "secretsmanager:TagResource",
                        "secretsmanager:UntagResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:secretsmanager:*:*:aws-opsworks-cm-secrets-*"
                },
                {
                    "Action": "ec2:DeleteTags",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*",
                        "arn:aws:ec2:*:*:elastic-ip/*",
                        "arn:aws:ec2:*:*:security-group/*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ6I6MPGJE62URSHCO",
        "PolicyName": "AWSOpsWorksCMServiceRole",
        "UpdateDate": "2021-01-06T15:08:35+00:00",
        "VersionId": "v13"
    },
    "AWSOpsWorksCloudWatchLogs": {
        "Arn": "arn:aws:iam::aws:policy/AWSOpsWorksCloudWatchLogs",
        "AttachmentCount": 0,
        "CreateDate": "2017-03-30T17:47:19+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                        "logs:DescribeLogStreams"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJXFIK7WABAY5CPXM4",
        "PolicyName": "AWSOpsWorksCloudWatchLogs",
        "UpdateDate": "2017-03-30T17:47:19+00:00",
        "VersionId": "v1"
    },
    "AWSOpsWorksFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSOpsWorksFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:40:48+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "opsworks:*",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "iam:GetRolePolicy",
                        "iam:ListInstanceProfiles",
                        "iam:ListRoles",
                        "iam:ListUsers",
                        "iam:PassRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAICN26VXMXASXKOQCG",
        "PolicyName": "AWSOpsWorksFullAccess",
        "UpdateDate": "2015-02-06T18:40:48+00:00",
        "VersionId": "v1"
    },
    "AWSOpsWorksInstanceRegistration": {
        "Arn": "arn:aws:iam::aws:policy/AWSOpsWorksInstanceRegistration",
        "AttachmentCount": 0,
        "CreateDate": "2016-06-03T14:23:15+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "opsworks:DescribeStackProvisioningParameters",
                        "opsworks:DescribeStacks",
                        "opsworks:RegisterInstance"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJG3LCPVNI4WDZCIMU",
        "PolicyName": "AWSOpsWorksInstanceRegistration",
        "UpdateDate": "2016-06-03T14:23:15+00:00",
        "VersionId": "v1"
    },
    "AWSOpsWorksRegisterCLI_EC2": {
        "Arn": "arn:aws:iam::aws:policy/AWSOpsWorksRegisterCLI_EC2",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-18T15:56:17+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "opsworks:AssignInstance",
                        "opsworks:CreateLayer",
                        "opsworks:DeregisterInstance",
                        "opsworks:DescribeInstances",
                        "opsworks:DescribeStackProvisioningParameters",
                        "opsworks:DescribeStacks",
                        "opsworks:UnassignInstance"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:DescribeInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4NCE3CMCRC",
        "PolicyName": "AWSOpsWorksRegisterCLI_EC2",
        "UpdateDate": "2019-06-18T15:56:17+00:00",
        "VersionId": "v1"
    },
    "AWSOpsWorksRegisterCLI_OnPremises": {
        "Arn": "arn:aws:iam::aws:policy/AWSOpsWorksRegisterCLI_OnPremises",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-18T15:33:16+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "opsworks:AssignInstance",
                        "opsworks:CreateLayer",
                        "opsworks:DeregisterInstance",
                        "opsworks:DescribeInstances",
                        "opsworks:DescribeStackProvisioningParameters",
                        "opsworks:DescribeStacks",
                        "opsworks:UnassignInstance"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:DescribeInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateGroup",
                        "iam:AddUserToGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:group/AWS/OpsWorks/OpsWorks-*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateUser",
                        "iam:CreateAccessKey"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:user/AWS/OpsWorks/OpsWorks-*"
                    ]
                },
                {
                    "Action": [
                        "iam:AttachUserPolicy"
                    ],
                    "Condition": {
                        "ArnEquals": {
                            "iam:PolicyARN": "arn:aws:iam::aws:policy/AWSOpsWorksInstanceRegistration"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:user/AWS/OpsWorks/OpsWorks-*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4EZJ5DYEPG",
        "PolicyName": "AWSOpsWorksRegisterCLI_OnPremises",
        "UpdateDate": "2019-06-18T15:33:16+00:00",
        "VersionId": "v1"
    },
    "AWSOpsWorksRole": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSOpsWorksRole",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:27+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudwatch:GetMetricStatistics",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeInstances",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "iam:GetRolePolicy",
                        "iam:ListInstanceProfiles",
                        "iam:ListRoles",
                        "iam:ListUsers",
                        "iam:PassRole",
                        "opsworks:*",
                        "rds:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIDUTMOKHJFAPJV45W",
        "PolicyName": "AWSOpsWorksRole",
        "UpdateDate": "2015-02-06T18:41:27+00:00",
        "VersionId": "v1"
    },
    "AWSOpsWorks_FullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSOpsWorks_FullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2021-01-22T16:29:08+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudwatch:GetMetricStatistics",
                        "ec2:DescribeAccountAttributes",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeInstances",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "elasticloadbalancing:DescribeInstanceHealth",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "iam:GetRolePolicy",
                        "iam:ListInstanceProfiles",
                        "iam:ListRoles",
                        "iam:ListUsers",
                        "opsworks:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "opsworks.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4D626GOURR",
        "PolicyName": "AWSOpsWorks_FullAccess",
        "UpdateDate": "2021-01-22T16:29:08+00:00",
        "VersionId": "v1"
    },
    "AWSOrganizationsFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSOrganizationsFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-06T20:31:57+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "organizations:*",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJZXBNRCJKNLQHSB5M",
        "PolicyName": "AWSOrganizationsFullAccess",
        "UpdateDate": "2018-11-06T20:31:57+00:00",
        "VersionId": "v1"
    },
    "AWSOrganizationsReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSOrganizationsReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-06T20:32:38+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:Describe*",
                        "organizations:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJY5RQATUV77PEPVOM",
        "PolicyName": "AWSOrganizationsReadOnlyAccess",
        "UpdateDate": "2018-11-06T20:32:38+00:00",
        "VersionId": "v1"
    },
    "AWSOrganizationsServiceTrustPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSOrganizationsServiceTrustPolicy",
        "AttachmentCount": 1,
        "CreateDate": "2017-10-10T23:04:07+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iam:DeleteRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/organizations.amazonaws.com/*"
                    ],
                    "Sid": "AllowDeletionOfServiceLinkedRoleForOrganizations"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowCreationOfServiceLinkedRoles"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIQH6ROMVVECFVRJPK",
        "PolicyName": "AWSOrganizationsServiceTrustPolicy",
        "UpdateDate": "2017-11-01T06:01:18+00:00",
        "VersionId": "v2"
    },
    "AWSOutpostsServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSOutpostsServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-09T22:55:56+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSecurityGroups",
                        "ec2:CreateNetworkInterface",
                        "ec2:CreateSecurityGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4NM7FW2RO7",
        "PolicyName": "AWSOutpostsServiceRolePolicy",
        "UpdateDate": "2020-11-09T22:55:56+00:00",
        "VersionId": "v1"
    },
    "AWSPanoramaApplianceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSPanoramaApplianceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-01T13:13:18+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/panorama_device*:log-stream:*",
                    "Sid": "PanoramaDeviceCreateLogStream"
                },
                {
                    "Action": "logs:CreateLogGroup",
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/panorama_device*",
                    "Sid": "PanoramaDeviceCreateLogGroup"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4CWIHTBB4Y",
        "PolicyName": "AWSPanoramaApplianceRolePolicy",
        "UpdateDate": "2020-12-01T13:13:18+00:00",
        "VersionId": "v1"
    },
    "AWSPanoramaFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSPanoramaFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-01T13:12:47+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "panorama:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IAPULBSWQ",
        "PolicyName": "AWSPanoramaFullAccess",
        "UpdateDate": "2020-12-01T13:12:47+00:00",
        "VersionId": "v1"
    },
    "AWSPanoramaGreengrassGroupRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSPanoramaGreengrassGroupRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-01T13:10:22+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:ListBucket",
                        "s3:GetBucket*",
                        "s3:GetObject",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*aws-panorama*"
                    ],
                    "Sid": "PanoramaS3Access"
                },
                {
                    "Action": "cloudwatch:PutDashboard",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudwatch::*:dashboard/panorama*"
                    ],
                    "Sid": "PanoramaCLoudWatchPutDashboard"
                },
                {
                    "Action": "cloudwatch:PutMetricData",
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "PanoramaCloudWatchPutMetricData"
                },
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:PutLogEvents",
                        "logs:CreateLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/greengrass/*",
                    "Sid": "PanoramaGreenGrassCloudWatchAccess"
                },
                {
                    "Action": [
                        "panorama:*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "PanoramaAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IRCPXKCEG",
        "PolicyName": "AWSPanoramaGreengrassGroupRolePolicy",
        "UpdateDate": "2021-01-06T19:30:35+00:00",
        "VersionId": "v2"
    },
    "AWSPanoramaSageMakerRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSPanoramaSageMakerRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-01T13:13:54+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject",
                        "s3:GetBucket*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*aws-panorama*"
                    ],
                    "Sid": "PanoramaSageMakerS3Access"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4O23KYQMI2",
        "PolicyName": "AWSPanoramaSageMakerRolePolicy",
        "UpdateDate": "2020-12-01T13:13:54+00:00",
        "VersionId": "v1"
    },
    "AWSPanoramaServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSPanoramaServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-01T13:14:43+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iot:CreateThing",
                        "iot:DeleteThing",
                        "iot:DeleteThingShadow",
                        "iot:DescribeThing",
                        "iot:GetThingShadow",
                        "iot:UpdateThing",
                        "iot:UpdateThingShadow"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/panorama*"
                    ],
                    "Sid": "PanoramaIoTThingAccess"
                },
                {
                    "Action": [
                        "iot:AttachThingPrincipal",
                        "iot:DetachThingPrincipal",
                        "iot:UpdateCertificate",
                        "iot:DeleteCertificate",
                        "iot:AttachPrincipalPolicy",
                        "iot:DetachPrincipalPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:thing/panorama*",
                        "arn:aws:iot:*:*:cert/*"
                    ],
                    "Sid": "PanoramaIoTCertificateAccess"
                },
                {
                    "Action": [
                        "iot:CreateKeysAndCertificate",
                        "iot:CreatePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "PanoramaIoTCreateCertificateAndPolicyAccess"
                },
                {
                    "Action": [
                        "iot:CreatePolicyVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:policy/panorama*"
                    ],
                    "Sid": "PanoramaIoTCreatePolicyVersionAccess"
                },
                {
                    "Action": [
                        "iot:DescribeJobExecution",
                        "iot:CreateJob",
                        "iot:DeleteJob"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:job/panorama*",
                        "arn:aws:iot:*:*:thing/panorama*"
                    ],
                    "Sid": "PanoramaIoTJobAccess"
                },
                {
                    "Action": [
                        "iot:DescribeEndpoint"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "PanoramaIoTEndpointAccess"
                },
                {
                    "Action": [
                        "panorama:Describe*",
                        "panorama:List*",
                        "panorama:Get*"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "PanoramaAccess"
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject",
                        "s3:DeleteObject",
                        "s3:DeleteBucket",
                        "s3:ListBucket",
                        "s3:GetBucket*",
                        "s3:CreateBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*aws-panorama*"
                    ],
                    "Sid": "PanoramaS3Access"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "sagemaker.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSPanoramaSageMakerRole",
                        "arn:aws:iam::*:role/service-role/AWSPanoramaSageMakerRole"
                    ],
                    "Sid": "PanoramaIAMPassSageMakerRoleAccess"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "greengrass.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSPanoramaGreengrassGroupRole",
                        "arn:aws:iam::*:role/service-role/AWSPanoramaGreengrassGroupRole",
                        "arn:aws:iam::*:role/AWSPanoramaGreengrassRole",
                        "arn:aws:iam::*:role/service-role/AWSPanoramaGreengrassRole"
                    ],
                    "Sid": "PanoramaIAMPassGreengrassRoleAccess"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEqualsIfExists": {
                            "iam:PassedToService": "iot.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSPanoramaApplianceRole",
                        "arn:aws:iam::*:role/service-role/AWSPanoramaApplianceRole"
                    ],
                    "Sid": "PanoramaIAMPassIoTRoleAccess"
                },
                {
                    "Action": [
                        "greengrass:AssociateRoleToGroup",
                        "greengrass:AssociateServiceRoleToAccount",
                        "greengrass:CreateResourceDefinition",
                        "greengrass:CreateResourceDefinitionVersion",
                        "greengrass:CreateCoreDefinition",
                        "greengrass:CreateCoreDefinitionVersion",
                        "greengrass:CreateDeployment",
                        "greengrass:CreateFunctionDefinition",
                        "greengrass:CreateFunctionDefinitionVersion",
                        "greengrass:CreateGroup",
                        "greengrass:CreateGroupCertificateAuthority",
                        "greengrass:CreateGroupVersion",
                        "greengrass:CreateLoggerDefinition",
                        "greengrass:CreateLoggerDefinitionVersion",
                        "greengrass:CreateSubscriptionDefinition",
                        "greengrass:CreateSubscriptionDefinitionVersion",
                        "greengrass:DeleteCoreDefinition",
                        "greengrass:DeleteFunctionDefinition",
                        "greengrass:DeleteResourceDefinition",
                        "greengrass:DeleteGroup",
                        "greengrass:DeleteLoggerDefinition",
                        "greengrass:DeleteSubscriptionDefinition",
                        "greengrass:DisassociateRoleFromGroup",
                        "greengrass:DisassociateServiceRoleFromAccount",
                        "greengrass:GetAssociatedRole",
                        "greengrass:GetConnectivityInfo",
                        "greengrass:GetCoreDefinition",
                        "greengrass:GetCoreDefinitionVersion",
                        "greengrass:GetDeploymentStatus",
                        "greengrass:GetDeviceDefinition",
                        "greengrass:GetDeviceDefinitionVersion",
                        "greengrass:GetFunctionDefinition",
                        "greengrass:GetFunctionDefinitionVersion",
                        "greengrass:GetGroup",
                        "greengrass:GetGroupCertificateAuthority",
                        "greengrass:GetGroupCertificateConfiguration",
                        "greengrass:GetGroupVersion",
                        "greengrass:GetLoggerDefinition",
                        "greengrass:GetLoggerDefinitionVersion",
                        "greengrass:GetResourceDefinition",
                        "greengrass:GetServiceRoleForAccount",
                        "greengrass:GetSubscriptionDefinition",
                        "greengrass:GetSubscriptionDefinitionVersion",
                        "greengrass:ListCoreDefinitionVersions",
                        "greengrass:ListCoreDefinitions",
                        "greengrass:ListDeployments",
                        "greengrass:ListDeviceDefinitionVersions",
                        "greengrass:ListDeviceDefinitions",
                        "greengrass:ListFunctionDefinitionVersions",
                        "greengrass:ListFunctionDefinitions",
                        "greengrass:ListGroupCertificateAuthorities",
                        "greengrass:ListGroupVersions",
                        "greengrass:ListGroups",
                        "greengrass:ListLoggerDefinitionVersions",
                        "greengrass:ListLoggerDefinitions",
                        "greengrass:ListSubscriptionDefinitionVersions",
                        "greengrass:ListSubscriptionDefinitions",
                        "greengrass:ResetDeployments",
                        "greengrass:UpdateConnectivityInfo",
                        "greengrass:UpdateCoreDefinition",
                        "greengrass:UpdateDeviceDefinition",
                        "greengrass:UpdateFunctionDefinition",
                        "greengrass:UpdateGroup",
                        "greengrass:UpdateGroupCertificateConfiguration",
                        "greengrass:UpdateLoggerDefinition",
                        "greengrass:UpdateSubscriptionDefinition",
                        "greengrass:UpdateResourceDefinition"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "PanoramaGreenGrassAccess"
                },
                {
                    "Action": [
                        "lambda:GetFunction",
                        "lambda:GetFunctionConfiguration",
                        "lambda:ListFunctions",
                        "lambda:ListVersionsByFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:*"
                    ],
                    "Sid": "PanoramaLambdaUsersFunctionAccess"
                },
                {
                    "Action": [
                        "sagemaker:CreateTrainingJob",
                        "sagemaker:StopTrainingJob",
                        "sagemaker:CreateCompilationJob",
                        "sagemaker:DescribeCompilationJob",
                        "sagemaker:StopCompilationJob"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sagemaker:*:*:training-job/panorama*",
                        "arn:aws:sagemaker:*:*:compilation-job/panorama*"
                    ],
                    "Sid": "PanoramaSageMakerWriteAccess"
                },
                {
                    "Action": [
                        "sagemaker:ListCompilationJobs"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "PanoramaSageMakerListAccess"
                },
                {
                    "Action": [
                        "sagemaker:DescribeTrainingJob"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sagemaker:*:*:training-job/*"
                    ],
                    "Sid": "PanoramaSageMakerReadAccess"
                },
                {
                    "Action": [
                        "iot:AttachPolicy",
                        "iot:CreateRoleAlias"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iot:*:*:policy/panorama*",
                        "arn:aws:iot:*:*:rolealias/panorama*"
                    ],
                    "Sid": "PanoramaCWLogsAccess"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4G7G35B6C5",
        "PolicyName": "AWSPanoramaServiceRolePolicy",
        "UpdateDate": "2020-12-01T13:14:43+00:00",
        "VersionId": "v1"
    },
    "AWSPriceListServiceFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSPriceListServiceFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-22T00:36:27+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "pricing:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIADJ4GBYNHKABML3Q",
        "PolicyName": "AWSPriceListServiceFullAccess",
        "UpdateDate": "2017-11-22T00:36:27+00:00",
        "VersionId": "v1"
    },
    "AWSPrivateMarketplaceAdminFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSPrivateMarketplaceAdminFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-27T16:32:32+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:CreatePrivateMarketplace",
                        "aws-marketplace:StartPrivateMarketplace",
                        "aws-marketplace:StopPrivateMarketplace",
                        "aws-marketplace:DescribePrivateMarketplaceStatus",
                        "aws-marketplace:AssociateProductsWithPrivateMarketplace",
                        "aws-marketplace:DisassociateProductsFromPrivateMarketplace",
                        "aws-marketplace:ListPrivateMarketplaceProducts",
                        "aws-marketplace:DescribePrivateMarketplaceProducts",
                        "aws-marketplace:ListPrivateMarketplaceRequests",
                        "aws-marketplace:DescribePrivateMarketplaceRequests",
                        "aws-marketplace:UpdatePrivateMarketplaceSettings",
                        "aws-marketplace:DescribePrivateMarketplaceSettings",
                        "aws-marketplace:CreatePrivateMarketplaceProfile",
                        "aws-marketplace:UpdatePrivateMarketplaceProfile",
                        "aws-marketplace:DescribePrivateMarketplaceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "aws-marketplace:ListEntities",
                        "aws-marketplace:DescribeEntity",
                        "aws-marketplace:StartChangeSet",
                        "aws-marketplace:ListChangeSets",
                        "aws-marketplace:DescribeChangeSet",
                        "aws-marketplace:CancelChangeSet"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ6VRZDDCYDOVCOCEI",
        "PolicyName": "AWSPrivateMarketplaceAdminFullAccess",
        "UpdateDate": "2020-12-03T15:12:31+00:00",
        "VersionId": "v3"
    },
    "AWSPrivateMarketplaceRequests": {
        "Arn": "arn:aws:iam::aws:policy/AWSPrivateMarketplaceRequests",
        "AttachmentCount": 0,
        "CreateDate": "2019-10-28T21:44:03+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-marketplace:CreatePrivateMarketplaceRequests",
                        "aws-marketplace:ListPrivateMarketplaceRequests",
                        "aws-marketplace:DescribePrivateMarketplaceRequests"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4AV6W3DAIW",
        "PolicyName": "AWSPrivateMarketplaceRequests",
        "UpdateDate": "2019-10-28T21:44:03+00:00",
        "VersionId": "v1"
    },
    "AWSProtonDeveloperAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSProtonDeveloperAccess",
        "AttachmentCount": 0,
        "CreateDate": "2021-02-17T19:02:08+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "proton:ListServiceTemplates",
                        "proton:ListServiceTemplateMajorVersions",
                        "proton:ListServiceTemplateMinorVersions",
                        "proton:ListServices",
                        "proton:ListServiceInstances",
                        "proton:ListEnvironments",
                        "proton:GetServiceTemplate",
                        "proton:GetServiceTemplateMajorVersion",
                        "proton:GetServiceTemplateMinorVersion",
                        "proton:GetService",
                        "proton:GetServiceInstance",
                        "proton:GetEnvironment",
                        "proton:CreateService",
                        "proton:UpdateService",
                        "proton:UpdateServiceInstance",
                        "proton:UpdateServicePipeline",
                        "proton:DeleteService",
                        "codestar-connections:ListConnections"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codestar-connections:PassConnection"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "codestar-connections:PassedToService": "proton.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FWOFPRNSU",
        "PolicyName": "AWSProtonDeveloperAccess",
        "UpdateDate": "2021-02-17T19:02:08+00:00",
        "VersionId": "v1"
    },
    "AWSProtonFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSProtonFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2021-02-17T19:07:18+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "proton:*",
                        "codestar-connections:ListConnections",
                        "kms:ListAliases",
                        "kms:DescribeKey"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:CreateGrant"
                    ],
                    "Condition": {
                        "StringLike": {
                            "kms:ViaService": "proton.*.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "proton.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "codestar-connections:PassConnection"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "codestar-connections:PassedToService": "proton.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:codestar-connections:*:*:connection/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IOK6P734E",
        "PolicyName": "AWSProtonFullAccess",
        "UpdateDate": "2021-02-17T19:07:18+00:00",
        "VersionId": "v1"
    },
    "AWSProtonReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSProtonReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2021-02-17T19:09:12+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": {
                "Action": [
                    "proton:List*",
                    "proton:Get*"
                ],
                "Effect": "Allow",
                "Resource": "*"
            },
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4DW2EHEZB3",
        "PolicyName": "AWSProtonReadOnlyAccess",
        "UpdateDate": "2021-02-17T19:09:12+00:00",
        "VersionId": "v1"
    },
    "AWSPurchaseOrdersServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSPurchaseOrdersServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-06T18:15:47+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "aws-portal:*Billing",
                        "awsbillingconsole:*Billing",
                        "purchase-orders:*PurchaseOrders"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KQXTYO5FP",
        "PolicyName": "AWSPurchaseOrdersServiceRolePolicy",
        "UpdateDate": "2020-05-06T18:15:47+00:00",
        "VersionId": "v1"
    },
    "AWSQuickSightDescribeRDS": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSQuickSightDescribeRDS",
        "AttachmentCount": 0,
        "CreateDate": "2015-11-10T23:24:50+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "rds:Describe*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJU5J6OAMCJD3OO76O",
        "PolicyName": "AWSQuickSightDescribeRDS",
        "UpdateDate": "2015-11-10T23:24:50+00:00",
        "VersionId": "v1"
    },
    "AWSQuickSightDescribeRedshift": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSQuickSightDescribeRedshift",
        "AttachmentCount": 0,
        "CreateDate": "2015-11-10T23:25:01+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "redshift:Describe*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJFEM6MLSLTW4ZNBW2",
        "PolicyName": "AWSQuickSightDescribeRedshift",
        "UpdateDate": "2015-11-10T23:25:01+00:00",
        "VersionId": "v1"
    },
    "AWSQuickSightElasticsearchPolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSQuickSightElasticsearchPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-09-09T17:27:19+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "es:ESHttpGet"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:es:*:*:domain/*/",
                        "arn:aws:es:*:*:domain/*/_cluster/settings",
                        "arn:aws:es:*:*:domain/*/_cat/indices"
                    ]
                },
                {
                    "Action": "es:ListDomainNames",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "es:DescribeElasticsearchDomain"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:es:*:*:domain/*"
                    ]
                },
                {
                    "Action": [
                        "es:ESHttpPost",
                        "es:ESHttpGet"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:es:*:*:domain/*/_opendistro/_sql"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BLUM3JVIN",
        "PolicyName": "AWSQuickSightElasticsearchPolicy",
        "UpdateDate": "2020-10-15T17:09:55+00:00",
        "VersionId": "v2"
    },
    "AWSQuickSightIoTAnalyticsAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSQuickSightIoTAnalyticsAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-11-29T17:00:54+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iotanalytics:ListDatasets",
                        "iotanalytics:DescribeDataset",
                        "iotanalytics:GetDatasetContent"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJIZNDRUTKCN5HLZOE",
        "PolicyName": "AWSQuickSightIoTAnalyticsAccess",
        "UpdateDate": "2017-11-29T17:00:54+00:00",
        "VersionId": "v1"
    },
    "AWSQuickSightListIAM": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSQuickSightListIAM",
        "AttachmentCount": 0,
        "CreateDate": "2015-11-10T23:25:07+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iam:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI3CH5UUWZN4EKGILO",
        "PolicyName": "AWSQuickSightListIAM",
        "UpdateDate": "2015-11-10T23:25:07+00:00",
        "VersionId": "v1"
    },
    "AWSQuickSightSageMakerPolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSQuickSightSageMakerPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-01-17T17:18:13+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sagemaker:DescribeTransformJob",
                        "sagemaker:StopTransformJob",
                        "sagemaker:CreateTransformJob"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:sagemaker:*:*:transform-job/quicksight-auto-generated-*"
                },
                {
                    "Action": "sagemaker:ListModels",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "s3:GetObject",
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::quicksight-ml.*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MCLBVDT2I",
        "PolicyName": "AWSQuickSightSageMakerPolicy",
        "UpdateDate": "2020-01-17T17:18:13+00:00",
        "VersionId": "v1"
    },
    "AWSQuickSightTimestreamPolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSQuickSightTimestreamPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-09-30T21:47:03+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "timestream:Select",
                        "timestream:CancelQuery",
                        "timestream:ListTables",
                        "timestream:ListDatabases",
                        "timestream:ListMeasures",
                        "timestream:DescribeTable",
                        "timestream:DescribeDatabase",
                        "timestream:SelectValues",
                        "timestream:DescribeEndpoints"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4CFKVDHQJH",
        "PolicyName": "AWSQuickSightTimestreamPolicy",
        "UpdateDate": "2020-09-30T21:47:03+00:00",
        "VersionId": "v1"
    },
    "AWSQuicksightAthenaAccess": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSQuicksightAthenaAccess",
        "AttachmentCount": 0,
        "CreateDate": "2016-12-09T02:31:03+00:00",
        "DefaultVersionId": "v9",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "athena:BatchGetQueryExecution",
                        "athena:CancelQueryExecution",
                        "athena:GetCatalogs",
                        "athena:GetExecutionEngine",
                        "athena:GetExecutionEngines",
                        "athena:GetNamespace",
                        "athena:GetNamespaces",
                        "athena:GetQueryExecution",
                        "athena:GetQueryExecutions",
                        "athena:GetQueryResults",
                        "athena:GetQueryResultsStream",
                        "athena:GetTable",
                        "athena:GetTables",
                        "athena:ListQueryExecutions",
                        "athena:RunQuery",
                        "athena:StartQueryExecution",
                        "athena:StopQueryExecution",
                        "athena:ListWorkGroups",
                        "athena:ListEngineVersions",
                        "athena:GetWorkGroup",
                        "athena:GetDataCatalog",
                        "athena:GetDatabase",
                        "athena:GetTableMetadata",
                        "athena:ListDataCatalogs",
                        "athena:ListDatabases",
                        "athena:ListTableMetadata"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "glue:CreateDatabase",
                        "glue:DeleteDatabase",
                        "glue:GetDatabase",
                        "glue:GetDatabases",
                        "glue:UpdateDatabase",
                        "glue:CreateTable",
                        "glue:DeleteTable",
                        "glue:BatchDeleteTable",
                        "glue:UpdateTable",
                        "glue:GetTable",
                        "glue:GetTables",
                        "glue:BatchCreatePartition",
                        "glue:CreatePartition",
                        "glue:DeletePartition",
                        "glue:BatchDeletePartition",
                        "glue:UpdatePartition",
                        "glue:GetPartition",
                        "glue:GetPartitions",
                        "glue:BatchGetPartition"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetBucketLocation",
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:ListBucketMultipartUploads",
                        "s3:ListMultipartUploadParts",
                        "s3:AbortMultipartUpload",
                        "s3:CreateBucket",
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-athena-query-results-*"
                    ]
                },
                {
                    "Action": [
                        "lakeformation:GetDataAccess"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI4JB77JXFQXDWNRPM",
        "PolicyName": "AWSQuicksightAthenaAccess",
        "UpdateDate": "2021-01-29T02:07:58+00:00",
        "VersionId": "v9"
    },
    "AWSResourceAccessManagerFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSResourceAccessManagerFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-06-04T17:28:22+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ram:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FYRGF63DP",
        "PolicyName": "AWSResourceAccessManagerFullAccess",
        "UpdateDate": "2019-06-04T17:28:22+00:00",
        "VersionId": "v1"
    },
    "AWSResourceAccessManagerReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSResourceAccessManagerReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-12-09T20:58:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ram:Get*",
                        "ram:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BQV2LHYJY",
        "PolicyName": "AWSResourceAccessManagerReadOnlyAccess",
        "UpdateDate": "2019-12-09T20:58:37+00:00",
        "VersionId": "v1"
    },
    "AWSResourceAccessManagerResourceShareParticipantAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSResourceAccessManagerResourceShareParticipantAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-12-09T20:41:37+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ram:AcceptResourceShareInvitation",
                        "ram:GetResourcePolicies",
                        "ram:GetResourceShareInvitations",
                        "ram:GetResourceShares",
                        "ram:ListPendingInvitationResources",
                        "ram:ListPrincipals",
                        "ram:ListResources",
                        "ram:RejectResourceShareInvitation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4LIFEGGUIU",
        "PolicyName": "AWSResourceAccessManagerResourceShareParticipantAccess",
        "UpdateDate": "2019-12-09T20:41:37+00:00",
        "VersionId": "v1"
    },
    "AWSResourceAccessManagerServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSResourceAccessManagerServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-14T19:28:28+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:DescribeAccount",
                        "organizations:DescribeOrganization",
                        "organizations:DescribeOrganizationalUnit",
                        "organizations:ListAccounts",
                        "organizations:ListAccountsForParent",
                        "organizations:ListChildren",
                        "organizations:ListOrganizationalUnitsForParent",
                        "organizations:ListParents",
                        "organizations:ListRoots"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:DeleteRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/ram.amazonaws.com/*"
                    ],
                    "Sid": "AllowDeletionOfServiceLinkedRoleForResourceAccessManager"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJU667A3V5UAXC4YNE",
        "PolicyName": "AWSResourceAccessManagerServiceRolePolicy",
        "UpdateDate": "2018-11-14T19:28:28+00:00",
        "VersionId": "v1"
    },
    "AWSResourceGroupsReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSResourceGroupsReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-03-07T10:27:04+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "resource-groups:Get*",
                        "resource-groups:List*",
                        "resource-groups:Search*",
                        "tag:Get*",
                        "cloudformation:DescribeStacks",
                        "cloudformation:ListStackResources",
                        "ec2:DescribeInstances",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeVolumes",
                        "ec2:DescribeVpcs",
                        "elasticache:DescribeCacheClusters",
                        "elasticache:DescribeSnapshots",
                        "elasticache:ListTagsForResource",
                        "elasticbeanstalk:DescribeEnvironments",
                        "elasticmapreduce:DescribeCluster",
                        "elasticmapreduce:ListClusters",
                        "glacier:ListVaults",
                        "glacier:DescribeVault",
                        "glacier:ListTagsForVault",
                        "kinesis:ListStreams",
                        "kinesis:DescribeStream",
                        "kinesis:ListTagsForStream",
                        "opsworks:DescribeStacks",
                        "opsworks:ListTags",
                        "rds:DescribeDBInstances",
                        "rds:DescribeDBSnapshots",
                        "rds:ListTagsForResource",
                        "redshift:DescribeClusters",
                        "redshift:DescribeTags",
                        "route53domains:ListDomains",
                        "route53:ListHealthChecks",
                        "route53:GetHealthCheck",
                        "route53:ListHostedZones",
                        "route53:GetHostedZone",
                        "route53:ListTagsForResource",
                        "storagegateway:ListGateways",
                        "storagegateway:DescribeGatewayInformation",
                        "storagegateway:ListTagsForResource",
                        "s3:ListAllMyBuckets",
                        "s3:GetBucketTagging",
                        "elasticloadbalancing:DescribeLoadBalancers",
                        "elasticloadbalancing:DescribeTags",
                        "ssm:ListDocuments"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIXFKM2WGBJAEWMFEG",
        "PolicyName": "AWSResourceGroupsReadOnlyAccess",
        "UpdateDate": "2019-02-05T17:56:25+00:00",
        "VersionId": "v2"
    },
    "AWSRoboMakerReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSRoboMakerReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-26T05:30:50+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "robomaker:List*",
                        "robomaker:BatchDescribe*",
                        "robomaker:Describe*",
                        "robomaker:Get*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "VisualEditor0"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIXFHP2ALXXGGECYJI",
        "PolicyName": "AWSRoboMakerReadOnlyAccess",
        "UpdateDate": "2020-08-28T23:10:18+00:00",
        "VersionId": "v2"
    },
    "AWSRoboMakerServicePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSRoboMakerServicePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-26T06:30:08+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CreateNetworkInterfacePermission",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSecurityGroups",
                        "greengrass:CreateDeployment",
                        "greengrass:CreateGroupVersion",
                        "greengrass:CreateFunctionDefinition",
                        "greengrass:CreateFunctionDefinitionVersion",
                        "greengrass:GetDeploymentStatus",
                        "greengrass:GetGroup",
                        "greengrass:GetGroupVersion",
                        "greengrass:GetCoreDefinitionVersion",
                        "greengrass:GetFunctionDefinitionVersion",
                        "greengrass:GetAssociatedRole",
                        "lambda:CreateFunction",
                        "robomaker:CreateSimulationJob",
                        "robomaker:CancelSimulationJob"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "robomaker:TagResource"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:robomaker:*:*:/createsimulationjob",
                        "arn:aws:robomaker:*:*:simulation-job/*"
                    ]
                },
                {
                    "Action": [
                        "lambda:UpdateFunctionCode",
                        "lambda:GetFunction",
                        "lambda:UpdateFunctionConfiguration",
                        "lambda:DeleteFunction",
                        "lambda:ListVersionsByFunction",
                        "lambda:GetAlias",
                        "lambda:UpdateAlias",
                        "lambda:CreateAlias",
                        "lambda:DeleteAlias"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:lambda:*:*:function:aws-robomaker-*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "lambda.amazonaws.com",
                                "robomaker.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJYLVVUUQMAEEZ3ZNY",
        "PolicyName": "AWSRoboMakerServicePolicy",
        "UpdateDate": "2020-08-04T20:38:08+00:00",
        "VersionId": "v5"
    },
    "AWSRoboMakerServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSRoboMakerServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-26T05:33:19+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CreateNetworkInterfacePermission",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DeleteNetworkInterface",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeSecurityGroups",
                        "greengrass:CreateDeployment",
                        "greengrass:CreateGroupVersion",
                        "greengrass:CreateFunctionDefinition",
                        "greengrass:CreateFunctionDefinitionVersion",
                        "greengrass:GetDeploymentStatus",
                        "greengrass:GetGroup",
                        "greengrass:GetGroupVersion",
                        "greengrass:GetCoreDefinitionVersion",
                        "greengrass:GetFunctionDefinitionVersion",
                        "greengrass:GetAssociatedRole",
                        "lambda:CreateFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "lambda:UpdateFunctionCode",
                        "lambda:GetFunction",
                        "lambda:UpdateFunctionConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:lambda:*:*:function:aws-robomaker-*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEqualsIfExists": {
                            "iam:PassedToService": "lambda.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIOSFFLBBLCTKS3ATC",
        "PolicyName": "AWSRoboMakerServiceRolePolicy",
        "UpdateDate": "2018-11-26T05:33:19+00:00",
        "VersionId": "v1"
    },
    "AWSRoboMaker_FullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSRoboMaker_FullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-09-10T18:34:18+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "robomaker:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "s3:GetObject",
                    "Condition": {
                        "StringEquals": {
                            "aws:CalledViaFirst": "robomaker.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "robomaker.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FACURHLCA",
        "PolicyName": "AWSRoboMaker_FullAccess",
        "UpdateDate": "2020-09-10T18:34:18+00:00",
        "VersionId": "v1"
    },
    "AWSSSODirectoryAdministrator": {
        "Arn": "arn:aws:iam::aws:policy/AWSSSODirectoryAdministrator",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-31T23:54:00+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sso-directory:*",
                        "sso:ListDirectoryAssociations"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AWSSSODirectoryAdministrator"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAI2TCZRD7WRD5D2E2Q",
        "PolicyName": "AWSSSODirectoryAdministrator",
        "UpdateDate": "2020-08-18T17:17:40+00:00",
        "VersionId": "v2"
    },
    "AWSSSODirectoryReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSSSODirectoryReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2018-10-31T23:49:32+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sso-directory:Search*",
                        "sso-directory:Describe*",
                        "sso-directory:List*",
                        "sso-directory:Get*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AWSSSODirectoryReadOnly"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJDPMQELJXZD2NC6JG",
        "PolicyName": "AWSSSODirectoryReadOnly",
        "UpdateDate": "2019-11-26T22:37:16+00:00",
        "VersionId": "v2"
    },
    "AWSSSOMasterAccountAdministrator": {
        "Arn": "arn:aws:iam::aws:policy/AWSSSOMasterAccountAdministrator",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-27T20:36:51+00:00",
        "DefaultVersionId": "v3",
        "Document": {
            "Statement": [
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": "sso.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO",
                    "Sid": "AWSSSOMasterAccountAdministrator"
                },
                {
                    "Action": [
                        "ds:DescribeTrusts",
                        "ds:UnauthorizeApplication",
                        "ds:DescribeDirectories",
                        "ds:AuthorizeApplication",
                        "iam:ListPolicies",
                        "organizations:EnableAWSServiceAccess",
                        "organizations:ListRoots",
                        "organizations:ListAccounts",
                        "organizations:ListOrganizationalUnitsForParent",
                        "organizations:ListAccountsForParent",
                        "organizations:DescribeOrganization",
                        "organizations:ListChildren",
                        "organizations:DescribeAccount",
                        "organizations:ListParents",
                        "sso:*",
                        "sso-directory:DescribeDirectory",
                        "ds:CreateAlias"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AWSSSOMemberAccountAdministrator"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIHXAQZIS3GOYIETUC",
        "PolicyName": "AWSSSOMasterAccountAdministrator",
        "UpdateDate": "2018-10-17T20:41:20+00:00",
        "VersionId": "v3"
    },
    "AWSSSOMemberAccountAdministrator": {
        "Arn": "arn:aws:iam::aws:policy/AWSSSOMemberAccountAdministrator",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-27T20:45:42+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ds:DescribeDirectories",
                        "ds:AuthorizeApplication",
                        "ds:UnauthorizeApplication",
                        "ds:DescribeTrusts",
                        "iam:ListPolicies",
                        "organizations:EnableAWSServiceAccess",
                        "organizations:DescribeOrganization",
                        "organizations:DescribeAccount",
                        "organizations:ListRoots",
                        "organizations:ListAccounts",
                        "organizations:ListAccountsForParent",
                        "organizations:ListParents",
                        "organizations:ListChildren",
                        "organizations:ListOrganizationalUnitsForParent",
                        "sso:*",
                        "sso-directory:DescribeDirectory",
                        "ds:CreateAlias"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AWSSSOMemberAccountAdministrator"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIQYHEY7KJWXZFNDPY",
        "PolicyName": "AWSSSOMemberAccountAdministrator",
        "UpdateDate": "2018-10-17T20:35:52+00:00",
        "VersionId": "v2"
    },
    "AWSSSOReadOnly": {
        "Arn": "arn:aws:iam::aws:policy/AWSSSOReadOnly",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-27T20:24:34+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ds:DescribeDirectories",
                        "ds:DescribeTrusts",
                        "iam:ListPolicies",
                        "organizations:DescribeOrganization",
                        "organizations:DescribeAccount",
                        "organizations:ListParents",
                        "organizations:ListChildren",
                        "organizations:ListAccounts",
                        "organizations:ListRoots",
                        "organizations:ListAccountsForParent",
                        "organizations:ListOrganizationalUnitsForParent",
                        "sso:Describe*",
                        "sso:Get*",
                        "sso:List*",
                        "sso:Search*",
                        "sso-directory:DescribeDirectory"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AWSSSOReadOnly"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJBSMEEZXFDMKMY43I",
        "PolicyName": "AWSSSOReadOnly",
        "UpdateDate": "2020-09-10T21:26:29+00:00",
        "VersionId": "v6"
    },
    "AWSSSOServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSSSOServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2017-12-05T18:36:15+00:00",
        "DefaultVersionId": "v13",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "iam:AttachRolePolicy",
                        "iam:CreateRole",
                        "iam:PutRolePolicy",
                        "iam:UpdateRole",
                        "iam:UpdateRoleDescription",
                        "iam:UpdateAssumeRolePolicy"
                    ],
                    "Condition": {
                        "StringNotEquals": {
                            "aws:PrincipalOrgMasterAccountId": "${aws:PrincipalAccount}"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-reserved/sso.amazonaws.com/*"
                    ],
                    "Sid": "IAMRoleProvisioningActions"
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "iam:ListRoles"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "IAMRoleReadActions"
                },
                {
                    "Action": [
                        "iam:DeleteRole",
                        "iam:DeleteRolePolicy",
                        "iam:DetachRolePolicy",
                        "iam:ListRolePolicies",
                        "iam:ListAttachedRolePolicies"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-reserved/sso.amazonaws.com/*"
                    ],
                    "Sid": "IAMRoleCleanupActions"
                },
                {
                    "Action": [
                        "iam:DeleteServiceLinkedRole",
                        "iam:GetServiceLinkedRoleDeletionStatus",
                        "iam:DeleteRole",
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/sso.amazonaws.com/AWSServiceRoleForSSO"
                    ],
                    "Sid": "IAMSLRCleanupActions"
                },
                {
                    "Action": [
                        "iam:CreateSAMLProvider",
                        "iam:UpdateSAMLProvider"
                    ],
                    "Condition": {
                        "StringNotEquals": {
                            "aws:PrincipalOrgMasterAccountId": "${aws:PrincipalAccount}"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:saml-provider/AWSSSO_*"
                    ],
                    "Sid": "IAMSAMLProviderProvisioningActions"
                },
                {
                    "Action": [
                        "iam:DeleteSAMLProvider",
                        "iam:GetSAMLProvider"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:saml-provider/AWSSSO_*"
                    ],
                    "Sid": "IAMSAMLProviderCleanupActions"
                },
                {
                    "Action": [
                        "organizations:DescribeAccount",
                        "organizations:DescribeOrganization",
                        "organizations:ListAccounts"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ds:UnauthorizeApplication"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AllowUnauthAppForDirectory"
                },
                {
                    "Action": [
                        "ds:DescribeDirectories",
                        "ds:DescribeTrusts"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AllowDescribeForDirectory"
                },
                {
                    "Action": [
                        "identitystore:DescribeUser",
                        "identitystore:DescribeGroup",
                        "identitystore:ListGroups",
                        "identitystore:ListUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ],
                    "Sid": "AllowDescribeAndListOperationsOnIdentitySource"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIJ52KSWOD4GI54XP2",
        "PolicyName": "AWSSSOServiceRolePolicy",
        "UpdateDate": "2020-11-19T00:02:00+00:00",
        "VersionId": "v13"
    },
    "AWSSavingsPlansFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSSavingsPlansFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-06T22:45:18+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "savingsplans:*",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4NDDOS76AO",
        "PolicyName": "AWSSavingsPlansFullAccess",
        "UpdateDate": "2019-11-06T22:45:18+00:00",
        "VersionId": "v1"
    },
    "AWSSavingsPlansReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSSavingsPlansReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-06T22:45:10+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "savingsplans:Describe*",
                        "savingsplans:List*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OQ26WIHJ5",
        "PolicyName": "AWSSavingsPlansReadOnlyAccess",
        "UpdateDate": "2019-11-06T22:45:10+00:00",
        "VersionId": "v1"
    },
    "AWSSecurityHubFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSSecurityHubFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-27T23:54:34+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "securityhub:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringLike": {
                            "iam:AWSServiceName": "securityhub.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ4262VZCA4HPBZSO6",
        "PolicyName": "AWSSecurityHubFullAccess",
        "UpdateDate": "2018-11-27T23:54:34+00:00",
        "VersionId": "v1"
    },
    "AWSSecurityHubReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSSecurityHubReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-28T01:34:29+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "securityhub:Get*",
                        "securityhub:List*",
                        "securityhub:Describe*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIEBAQNOFUCLFJ3UHG",
        "PolicyName": "AWSSecurityHubReadOnlyAccess",
        "UpdateDate": "2019-06-25T22:45:52+00:00",
        "VersionId": "v2"
    },
    "AWSSecurityHubServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSSecurityHubServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-27T23:47:51+00:00",
        "DefaultVersionId": "v7",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudtrail:DescribeTrails",
                        "cloudtrail:GetTrailStatus",
                        "cloudtrail:GetEventSelectors",
                        "cloudwatch:DescribeAlarms",
                        "cloudwatch:DescribeAlarmsForMetric",
                        "logs:DescribeMetricFilters",
                        "sns:ListSubscriptionsByTopic",
                        "config:DescribeConfigurationRecorders",
                        "config:DescribeConfigurationRecorderStatus",
                        "config:DescribeConfigRules",
                        "config:BatchGetResourceConfig",
                        "config:SelectResourceConfig",
                        "iam:GenerateCredentialReport",
                        "iam:GetCredentialReport",
                        "organizations:ListAccounts",
                        "organizations:DescribeAccount",
                        "organizations:DescribeOrganization"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "config:PutConfigRule",
                        "config:DeleteConfigRule",
                        "config:GetComplianceDetailsByConfigRule",
                        "config:DescribeConfigRuleEvaluationStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:config:*:*:config-rule/aws-service-rule/*securityhub*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJQPCESDDYDLLSOGYO",
        "PolicyName": "AWSSecurityHubServiceRolePolicy",
        "UpdateDate": "2020-09-21T19:59:01+00:00",
        "VersionId": "v7"
    },
    "AWSServiceCatalogAdminFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSServiceCatalogAdminFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-02-15T17:19:40+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStacks",
                        "cloudformation:SetStackPolicy",
                        "cloudformation:UpdateStack",
                        "cloudformation:CreateChangeSet",
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:ExecuteChangeSet",
                        "cloudformation:ListChangeSets",
                        "cloudformation:DeleteChangeSet",
                        "cloudformation:ListStackResources",
                        "cloudformation:TagResource",
                        "cloudformation:CreateStackSet",
                        "cloudformation:CreateStackInstances",
                        "cloudformation:UpdateStackSet",
                        "cloudformation:UpdateStackInstances",
                        "cloudformation:DeleteStackSet",
                        "cloudformation:DeleteStackInstances",
                        "cloudformation:DescribeStackSet",
                        "cloudformation:DescribeStackInstance",
                        "cloudformation:DescribeStackSetOperation",
                        "cloudformation:ListStackInstances",
                        "cloudformation:ListStackSetOperations",
                        "cloudformation:ListStackSetOperationResults"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/SC-*",
                        "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
                        "arn:aws:cloudformation:*:*:changeSet/SC-*",
                        "arn:aws:cloudformation:*:*:stackset/SC-*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:CreateUploadBucket",
                        "cloudformation:GetTemplateSummary",
                        "cloudformation:ValidateTemplate",
                        "iam:GetGroup",
                        "iam:GetRole",
                        "iam:GetUser",
                        "iam:ListGroups",
                        "iam:ListRoles",
                        "iam:ListUsers",
                        "servicecatalog:*",
                        "ssm:DescribeDocument",
                        "ssm:GetAutomationExecution",
                        "ssm:ListDocuments",
                        "ssm:ListDocumentVersions",
                        "config:DescribeConfigurationRecorders",
                        "config:DescribeConfigurationRecorderStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "servicecatalog.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJWLJU4BZ7AQUJSBVM",
        "PolicyName": "AWSServiceCatalogAdminFullAccess",
        "UpdateDate": "2019-02-06T01:57:54+00:00",
        "VersionId": "v5"
    },
    "AWSServiceCatalogAdminReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSServiceCatalogAdminReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-10-25T18:53:38+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStacks",
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:ListChangeSets",
                        "cloudformation:ListStackResources",
                        "cloudformation:DescribeStackSet",
                        "cloudformation:DescribeStackInstance",
                        "cloudformation:DescribeStackSetOperation",
                        "cloudformation:ListStackInstances",
                        "cloudformation:ListStackSetOperations",
                        "cloudformation:ListStackSetOperationResults"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/SC-*",
                        "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
                        "arn:aws:cloudformation:*:*:changeSet/SC-*",
                        "arn:aws:cloudformation:*:*:stackset/SC-*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:GetTemplateSummary",
                        "iam:GetGroup",
                        "iam:GetRole",
                        "iam:GetUser",
                        "iam:ListGroups",
                        "iam:ListRoles",
                        "iam:ListUsers",
                        "servicecatalog:Get*",
                        "servicecatalog:List*",
                        "servicecatalog:Describe*",
                        "servicecatalog:ScanProvisionedProducts",
                        "servicecatalog:Search*",
                        "ssm:DescribeDocument",
                        "ssm:GetAutomationExecution",
                        "ssm:ListDocuments",
                        "ssm:ListDocumentVersions",
                        "config:DescribeConfigurationRecorders",
                        "config:DescribeConfigurationRecorderStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MC6ZR7YFX",
        "PolicyName": "AWSServiceCatalogAdminReadOnlyAccess",
        "UpdateDate": "2019-10-25T18:53:38+00:00",
        "VersionId": "v1"
    },
    "AWSServiceCatalogAppRegistryFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSServiceCatalogAppRegistryFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-12T22:25:58+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeStacks",
                        "servicecatalog:CreateApplication",
                        "servicecatalog:GetApplication",
                        "servicecatalog:UpdateApplication",
                        "servicecatalog:DeleteApplication",
                        "servicecatalog:ListApplications",
                        "servicecatalog:AssociateResource",
                        "servicecatalog:DisassociateResource",
                        "servicecatalog:ListAssociatedResources",
                        "servicecatalog:AssociateAttributeGroup",
                        "servicecatalog:DisassociateAttributeGroup",
                        "servicecatalog:ListAssociatedAttributeGroups",
                        "servicecatalog:CreateAttributeGroup",
                        "servicecatalog:UpdateAttributeGroup",
                        "servicecatalog:DeleteAttributeGroup",
                        "servicecatalog:GetAttributeGroup",
                        "servicecatalog:ListAttributeGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4N2G3EPAYN",
        "PolicyName": "AWSServiceCatalogAppRegistryFullAccess",
        "UpdateDate": "2020-11-12T22:25:58+00:00",
        "VersionId": "v1"
    },
    "AWSServiceCatalogAppRegistryReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSServiceCatalogAppRegistryReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-11-12T22:34:32+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "servicecatalog:GetApplication",
                        "servicecatalog:ListApplications",
                        "servicecatalog:ListAssociatedResources",
                        "servicecatalog:ListAssociatedAttributeGroups",
                        "servicecatalog:GetAttributeGroup",
                        "servicecatalog:ListAttributeGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4M3SSCJCST",
        "PolicyName": "AWSServiceCatalogAppRegistryReadOnlyAccess",
        "UpdateDate": "2020-11-12T22:34:32+00:00",
        "VersionId": "v1"
    },
    "AWSServiceCatalogEndUserFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSServiceCatalogEndUserFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2018-02-15T17:22:32+00:00",
        "DefaultVersionId": "v7",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStacks",
                        "cloudformation:SetStackPolicy",
                        "cloudformation:ValidateTemplate",
                        "cloudformation:UpdateStack",
                        "cloudformation:CreateChangeSet",
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:ExecuteChangeSet",
                        "cloudformation:ListChangeSets",
                        "cloudformation:DeleteChangeSet",
                        "cloudformation:TagResource",
                        "cloudformation:CreateStackSet",
                        "cloudformation:CreateStackInstances",
                        "cloudformation:UpdateStackSet",
                        "cloudformation:UpdateStackInstances",
                        "cloudformation:DeleteStackSet",
                        "cloudformation:DeleteStackInstances",
                        "cloudformation:DescribeStackSet",
                        "cloudformation:DescribeStackInstance",
                        "cloudformation:DescribeStackSetOperation",
                        "cloudformation:ListStackInstances",
                        "cloudformation:ListStackResources",
                        "cloudformation:ListStackSetOperations",
                        "cloudformation:ListStackSetOperationResults"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/SC-*",
                        "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
                        "arn:aws:cloudformation:*:*:changeSet/SC-*",
                        "arn:aws:cloudformation:*:*:stackset/SC-*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:GetTemplateSummary",
                        "servicecatalog:DescribeProduct",
                        "servicecatalog:DescribeProductView",
                        "servicecatalog:DescribeProvisioningParameters",
                        "servicecatalog:ListLaunchPaths",
                        "servicecatalog:ProvisionProduct",
                        "servicecatalog:SearchProducts",
                        "ssm:DescribeDocument",
                        "ssm:GetAutomationExecution",
                        "config:DescribeConfigurationRecorders",
                        "config:DescribeConfigurationRecorderStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "servicecatalog:DescribeProvisionedProduct",
                        "servicecatalog:DescribeRecord",
                        "servicecatalog:ListRecordHistory",
                        "servicecatalog:ListStackInstancesForProvisionedProduct",
                        "servicecatalog:ScanProvisionedProducts",
                        "servicecatalog:TerminateProvisionedProduct",
                        "servicecatalog:UpdateProvisionedProduct",
                        "servicecatalog:SearchProvisionedProducts",
                        "servicecatalog:CreateProvisionedProductPlan",
                        "servicecatalog:DescribeProvisionedProductPlan",
                        "servicecatalog:ExecuteProvisionedProductPlan",
                        "servicecatalog:DeleteProvisionedProductPlan",
                        "servicecatalog:ListProvisionedProductPlans",
                        "servicecatalog:ListServiceActionsForProvisioningArtifact",
                        "servicecatalog:ExecuteProvisionedProductServiceAction",
                        "servicecatalog:DescribeServiceActionExecutionParameters"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "servicecatalog:userLevel": "self"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJTLLC4DGDMTZB54M4",
        "PolicyName": "AWSServiceCatalogEndUserFullAccess",
        "UpdateDate": "2019-07-10T20:30:52+00:00",
        "VersionId": "v7"
    },
    "AWSServiceCatalogEndUserReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSServiceCatalogEndUserReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2019-10-25T18:49:34+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStacks",
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:ListChangeSets",
                        "cloudformation:DescribeStackSet",
                        "cloudformation:DescribeStackInstance",
                        "cloudformation:DescribeStackSetOperation",
                        "cloudformation:ListStackInstances",
                        "cloudformation:ListStackResources",
                        "cloudformation:ListStackSetOperations",
                        "cloudformation:ListStackSetOperationResults"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/SC-*",
                        "arn:aws:cloudformation:*:*:stack/StackSet-SC-*",
                        "arn:aws:cloudformation:*:*:changeSet/SC-*",
                        "arn:aws:cloudformation:*:*:stackset/SC-*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:GetTemplateSummary",
                        "servicecatalog:DescribeProduct",
                        "servicecatalog:DescribeProductView",
                        "servicecatalog:DescribeProvisioningParameters",
                        "servicecatalog:ListLaunchPaths",
                        "servicecatalog:SearchProducts",
                        "ssm:DescribeDocument",
                        "ssm:GetAutomationExecution",
                        "config:DescribeConfigurationRecorders",
                        "config:DescribeConfigurationRecorderStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "servicecatalog:DescribeProvisionedProduct",
                        "servicecatalog:DescribeRecord",
                        "servicecatalog:ListRecordHistory",
                        "servicecatalog:ListStackInstancesForProvisionedProduct",
                        "servicecatalog:ScanProvisionedProducts",
                        "servicecatalog:SearchProvisionedProducts",
                        "servicecatalog:DescribeProvisionedProductPlan",
                        "servicecatalog:ListProvisionedProductPlans",
                        "servicecatalog:ListServiceActionsForProvisioningArtifact",
                        "servicecatalog:DescribeServiceActionExecutionParameters"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "servicecatalog:userLevel": "self"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4IWYKXJJED",
        "PolicyName": "AWSServiceCatalogEndUserReadOnlyAccess",
        "UpdateDate": "2019-10-25T18:49:34+00:00",
        "VersionId": "v1"
    },
    "AWSServiceRoleForAmazonEKSNodegroup": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForAmazonEKSNodegroup",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-07T01:34:26+00:00",
        "DefaultVersionId": "v5",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:RevokeSecurityGroupIngress",
                        "ec2:AuthorizeSecurityGroupEgress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:DescribeInstances",
                        "ec2:RevokeSecurityGroupEgress",
                        "ec2:DeleteSecurityGroup"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/eks": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SharedSecurityGroupRelatedPermissions"
                },
                {
                    "Action": [
                        "ec2:RevokeSecurityGroupIngress",
                        "ec2:AuthorizeSecurityGroupEgress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:DescribeInstances",
                        "ec2:RevokeSecurityGroupEgress",
                        "ec2:DeleteSecurityGroup"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/eks:nodegroup-name": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "EKSCreatedSecurityGroupRelatedPermissions"
                },
                {
                    "Action": [
                        "ec2:DeleteLaunchTemplate",
                        "ec2:CreateLaunchTemplateVersion"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/eks:nodegroup-name": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "LaunchTemplateRelatedPermissions"
                },
                {
                    "Action": [
                        "autoscaling:UpdateAutoScalingGroup",
                        "autoscaling:DeleteAutoScalingGroup",
                        "autoscaling:TerminateInstanceInAutoScalingGroup",
                        "autoscaling:CompleteLifecycleAction",
                        "autoscaling:PutLifecycleHook",
                        "autoscaling:PutNotificationConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:autoscaling:*:*:*:autoScalingGroupName/eks-*",
                    "Sid": "AutoscalingRelatedPermissions"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "autoscaling.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowAutoscalingToCreateSLR"
                },
                {
                    "Action": [
                        "autoscaling:CreateOrUpdateTags",
                        "autoscaling:CreateAutoScalingGroup"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:TagKeys": [
                                "eks",
                                "eks:cluster-name",
                                "eks:nodegroup-name"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowASGCreationByEKS"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "autoscaling.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowPassRoleToAutoscaling"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEqualsIfExists": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ec2.amazonaws.com.cn"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowPassRoleToEC2"
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "ec2:CreateLaunchTemplate",
                        "ec2:DescribeInstances",
                        "iam:GetInstanceProfile",
                        "ec2:DescribeLaunchTemplates",
                        "autoscaling:DescribeAutoScalingGroups",
                        "ec2:CreateSecurityGroup",
                        "ec2:DescribeLaunchTemplateVersions",
                        "ec2:RunInstances",
                        "ec2:DescribeSecurityGroups",
                        "ec2:GetConsoleOutput",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeSubnets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "PermissionsToManageResourcesForNodegroups"
                },
                {
                    "Action": [
                        "iam:CreateInstanceProfile",
                        "iam:DeleteInstanceProfile",
                        "iam:RemoveRoleFromInstanceProfile",
                        "iam:AddRoleToInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:instance-profile/eks-*",
                    "Sid": "PermissionsToCreateAndManageInstanceProfiles"
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Condition": {
                        "ForAnyValue:StringLike": {
                            "aws:TagKeys": [
                                "eks",
                                "eks:cluster-name",
                                "eks:nodegroup-name",
                                "kubernetes.io/cluster/*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "PermissionsToManageEKSAndKubernetesTags"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KH2AAMJJG",
        "PolicyName": "AWSServiceRoleForAmazonEKSNodegroup",
        "UpdateDate": "2020-08-31T19:07:38+00:00",
        "VersionId": "v5"
    },
    "AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-10-01T09:49:01+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ssm:CreateOpsItem"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4M4BX2KX5V",
        "PolicyName": "AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy",
        "UpdateDate": "2020-10-01T09:49:01+00:00",
        "VersionId": "v1"
    },
    "AWSServiceRoleForCodeGuru-Profiler": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForCodeGuru-Profiler",
        "AttachmentCount": 0,
        "CreateDate": "2020-06-26T22:04:26+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "AllowSNSPublishToSendNotifications"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4GNVXVLNQT",
        "PolicyName": "AWSServiceRoleForCodeGuru-Profiler",
        "UpdateDate": "2020-06-26T22:04:26+00:00",
        "VersionId": "v1"
    },
    "AWSServiceRoleForEC2ScheduledInstances": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForEC2ScheduledInstances",
        "AttachmentCount": 0,
        "CreateDate": "2017-10-12T18:31:55+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "aws:TagKeys": [
                                "aws:ec2sri:scheduledInstanceId"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:ec2sri:scheduledInstanceId": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ7Y4TT63D6QBKCY4O",
        "PolicyName": "AWSServiceRoleForEC2ScheduledInstances",
        "UpdateDate": "2017-10-12T18:31:55+00:00",
        "VersionId": "v1"
    },
    "AWSServiceRoleForImageBuilder": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForImageBuilder",
        "AttachmentCount": 0,
        "CreateDate": "2019-11-29T22:02:13+00:00",
        "DefaultVersionId": "v12",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*::image/*",
                        "arn:aws:ec2:*::snapshot/*",
                        "arn:aws:ec2:*:*:subnet/*",
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:key-pair/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "aws:RequestTag/CreatedBy": "EC2 Image Builder"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:volume/*",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ec2.amazonaws.com.cn"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:StopInstances",
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "ec2:ResourceTag/CreatedBy": "EC2 Image Builder"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CopyImage",
                        "ec2:CreateImage",
                        "ec2:CreateLaunchTemplate",
                        "ec2:DeregisterImage",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstanceAttribute",
                        "ec2:DescribeInstanceStatus",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInstanceTypeOfferings",
                        "ec2:DescribeInstanceTypes",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeTags",
                        "ec2:ModifyImageAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:ModifySnapshotAttribute"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "ec2:ResourceTag/CreatedBy": "EC2 Image Builder"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::snapshot/*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*::image/*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "aws:RequestTag/CreatedBy": "EC2 Image Builder"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "license-manager:UpdateLicenseSpecificationsForResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "sns:Publish"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ssm:ListCommands",
                        "ssm:ListCommandInvocations",
                        "ssm:AddTagsToResource",
                        "ssm:DescribeInstanceInformation",
                        "ssm:GetAutomationExecution",
                        "ssm:StopAutomationExecution",
                        "ssm:ListInventoryEntries",
                        "ssm:SendAutomationSignal",
                        "ssm:DescribeInstanceAssociationsStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ssm:SendCommand",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/AWS-RunPowerShellScript",
                        "arn:aws:ssm:*:*:document/AWS-RunShellScript",
                        "arn:aws:ssm:*:*:document/AWSEC2-RunSysprep",
                        "arn:aws:s3:::*"
                    ]
                },
                {
                    "Action": [
                        "ssm:SendCommand"
                    ],
                    "Condition": {
                        "ForAnyValue:StringEquals": {
                            "ssm:resourceTag/CreatedBy": [
                                "EC2 Image Builder"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": "ssm:StartAutomationExecution",
                    "Effect": "Allow",
                    "Resource": "arn:aws:ssm:*:*:automation-definition/ImageBuilder*"
                },
                {
                    "Action": [
                        "ssm:CreateAssociation",
                        "ssm:DeleteAssociation"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*:*:document/AWS-GatherSoftwareInventory",
                        "arn:aws:ssm:*:*:association/*",
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "kms:Encrypt",
                        "kms:Decrypt",
                        "kms:ReEncryptFrom",
                        "kms:ReEncryptTo",
                        "kms:GenerateDataKeyWithoutPlaintext",
                        "kms:DescribeKey"
                    ],
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "kms:EncryptionContextKeys": [
                                "aws:ebs:id"
                            ]
                        },
                        "StringLike": {
                            "kms:ViaService": [
                                "ec2.*.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "kms:CreateGrant",
                    "Condition": {
                        "Bool": {
                            "kms:GrantIsForAWSResource": true
                        },
                        "StringLike": {
                            "kms:ViaService": [
                                "ec2.*.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/EC2ImageBuilderDistributionCrossAccountRole"
                },
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:CreateLogGroup",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/imagebuilder/*"
                },
                {
                    "Action": [
                        "ec2:CreateLaunchTemplateVersion",
                        "ec2:DescribeLaunchTemplates",
                        "ec2:ModifyLaunchTemplate"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "ssm.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4NE22WISEW",
        "PolicyName": "AWSServiceRoleForImageBuilder",
        "UpdateDate": "2020-12-04T23:27:05+00:00",
        "VersionId": "v12"
    },
    "AWSServiceRoleForIoTSiteWise": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForIoTSiteWise",
        "AttachmentCount": 0,
        "CreateDate": "2018-11-14T19:19:17+00:00",
        "DefaultVersionId": "v7",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "greengrass:GetAssociatedRole",
                        "greengrass:GetCoreDefinition",
                        "greengrass:GetCoreDefinitionVersion",
                        "greengrass:GetGroup",
                        "greengrass:GetGroupVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:DescribeLogGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/iotsitewise*"
                },
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:DescribeLogStreams",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/aws/iotsitewise*:log-stream:*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJGQU4DZIQP6HLYQPE",
        "PolicyName": "AWSServiceRoleForIoTSiteWise",
        "UpdateDate": "2020-04-25T02:15:01+00:00",
        "VersionId": "v7"
    },
    "AWSServiceRoleForLogDeliveryPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForLogDeliveryPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-10-04T17:31:19+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "firehose:PutRecord",
                        "firehose:PutRecordBatch",
                        "firehose:ListTagsForDeliveryStream"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "firehose:ResourceTag/LogDeliveryEnabled": "true"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4EMA7ANTDG",
        "PolicyName": "AWSServiceRoleForLogDeliveryPolicy",
        "UpdateDate": "2020-07-27T19:38:52+00:00",
        "VersionId": "v2"
    },
    "AWSServiceRoleForMonitronPolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForMonitronPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-02T19:06:08+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "sso:GetManagedApplicationInstance",
                        "sso:GetProfile",
                        "sso:ListProfiles",
                        "sso:AssociateProfile",
                        "sso:ListDirectoryAssociations",
                        "sso-directory:DescribeUsers",
                        "sso-directory:SearchUsers"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4NYRIH2RCH",
        "PolicyName": "AWSServiceRoleForMonitronPolicy",
        "UpdateDate": "2020-12-02T19:06:08+00:00",
        "VersionId": "v1"
    },
    "AWSServiceRoleForSMS": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSServiceRoleForSMS",
        "AttachmentCount": 0,
        "CreateDate": "2019-08-06T18:39:29+00:00",
        "DefaultVersionId": "v10",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudformation:CreateChangeSet",
                        "cloudformation:CreateStack"
                    ],
                    "Condition": {
                        "ForAllValues:StringEquals": {
                            "cloudformation:ResourceTypes": [
                                "AWS::EC2::Instance",
                                "AWS::ApplicationInsights::Application",
                                "AWS::ResourceGroups::Group"
                            ]
                        },
                        "Null": {
                            "cloudformation:ResourceTypes": "false"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/sms-app-*/*"
                },
                {
                    "Action": [
                        "cloudformation:DeleteStack",
                        "cloudformation:ExecuteChangeSet",
                        "cloudformation:DeleteChangeSet",
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:DescribeStacks",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStackResource",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:GetTemplate"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:cloudformation:*:*:stack/sms-app-*/*"
                },
                {
                    "Action": [
                        "cloudformation:ValidateTemplate",
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "s3:CreateBucket",
                        "s3:DeleteBucket",
                        "s3:DeleteObject",
                        "s3:GetBucketAcl",
                        "s3:GetBucketLocation",
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:PutObject",
                        "s3:PutObjectAcl",
                        "s3:PutLifecycleConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:s3:::sms-app-*"
                },
                {
                    "Action": [
                        "sms:CreateReplicationJob",
                        "sms:DeleteReplicationJob",
                        "sms:GetReplicationJobs",
                        "sms:GetReplicationRuns",
                        "sms:GetServers",
                        "sms:ImportServerCatalog",
                        "sms:StartOnDemandReplicationRun",
                        "sms:UpdateReplicationJob"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ssm:SendCommand",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ssm:*::document/AWS-RunRemoteScript",
                        "arn:aws:s3:::sms-app-*"
                    ]
                },
                {
                    "Action": "ssm:SendCommand",
                    "Condition": {
                        "StringEquals": {
                            "ssm:resourceTag/UseForSMSApplicationValidation": [
                                "true"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": [
                        "ssm:CancelCommand",
                        "ssm:GetCommandInvocation"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:CreateTags",
                    "Condition": {
                        "StringEquals": {
                            "ec2:CreateAction": "CopySnapshot"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:snapshot/*"
                },
                {
                    "Action": "ec2:CopySnapshot",
                    "Condition": {
                        "StringLike": {
                            "aws:RequestTag/SMSJobId": [
                                "sms-*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:snapshot/*"
                },
                {
                    "Action": [
                        "ec2:ModifySnapshotAttribute",
                        "ec2:DeleteSnapshot"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/SMSJobId": [
                                "sms-*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:snapshot/*"
                },
                {
                    "Action": [
                        "ec2:CopyImage",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeSnapshots",
                        "ec2:DescribeSnapshotAttribute",
                        "ec2:DeregisterImage",
                        "ec2:ImportImage",
                        "ec2:DescribeImportImageTasks",
                        "ec2:GetEbsEncryptionByDefault"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "iam:GetInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:DisassociateIamInstanceProfile",
                        "ec2:AssociateIamInstanceProfile",
                        "ec2:ReplaceIamInstanceProfileAssociation"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-id": "arn:aws:cloudformation:*:*:stack/sms-app-*/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "ec2.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEqualsIfExists": {
                            "iam:PassedToService": "cloudformation.amazonaws.com"
                        },
                        "StringLike": {
                            "iam:AssociatedResourceArn": "arn:aws:cloudformation:*:*:stack/sms-app-*/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": [
                        "ec2:ModifyInstanceAttribute",
                        "ec2:StopInstances",
                        "ec2:StartInstances",
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:cloudformation:stack-id": "arn:aws:cloudformation:*:*:stack/sms-app-*/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "applicationinsights:Describe*",
                        "applicationinsights:List*",
                        "cloudformation:ListStackResources"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "applicationinsights:CreateApplication",
                        "applicationinsights:CreateComponent",
                        "applicationinsights:UpdateApplication",
                        "applicationinsights:DeleteApplication",
                        "applicationinsights:UpdateComponentConfiguration",
                        "applicationinsights:DeleteComponent"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:applicationinsights:*:*:application/resource-group/sms-app-*"
                },
                {
                    "Action": [
                        "resource-groups:CreateGroup",
                        "resource-groups:GetGroup",
                        "resource-groups:UpdateGroup",
                        "resource-groups:DeleteGroup"
                    ],
                    "Condition": {
                        "StringLike": {
                            "aws:ResourceTag/aws:cloudformation:stack-id": "arn:aws:cloudformation:*:*:stack/sms-app-*/*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:resource-groups:*:*:group/sms-app-*"
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": "application-insights.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/application-insights.amazonaws.com/AWSServiceRoleForApplicationInsights"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OSYRD2VJZ",
        "PolicyName": "AWSServiceRoleForSMS",
        "UpdateDate": "2020-10-15T17:28:13+00:00",
        "VersionId": "v10"
    },
    "AWSShieldDRTAccessPolicy": {
        "Arn": "arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2018-06-05T22:29:39+00:00",
        "DefaultVersionId": "v6",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "cloudfront:List*",
                        "route53:List*",
                        "elasticloadbalancing:Describe*",
                        "cloudwatch:Describe*",
                        "cloudwatch:Get*",
                        "cloudwatch:List*",
                        "cloudfront:GetDistribution*",
                        "globalaccelerator:ListAccelerators",
                        "globalaccelerator:DescribeAccelerator",
                        "ec2:DescribeRegions",
                        "ec2:DescribeAddresses"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SRTAccessProtectedResources"
                },
                {
                    "Action": [
                        "shield:*",
                        "waf:*",
                        "wafv2:*",
                        "waf-regional:*",
                        "elasticloadbalancing:SetWebACL",
                        "cloudfront:UpdateDistribution",
                        "apigateway:SetWebACL"
                    ],
                    "Effect": "Allow",
                    "Resource": "*",
                    "Sid": "SRTManageProtections"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJWNCSZ4PARLO37VVY",
        "PolicyName": "AWSShieldDRTAccessPolicy",
        "UpdateDate": "2020-12-15T17:28:15+00:00",
        "VersionId": "v6"
    },
    "AWSStepFunctionsConsoleFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSStepFunctionsConsoleFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-01-11T21:54:31+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": "states:*",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:ListRoles",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/service-role/StatesExecutionRole*"
                },
                {
                    "Action": "lambda:ListFunctions",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJIYC52YWRX6OSMJWK",
        "PolicyName": "AWSStepFunctionsConsoleFullAccess",
        "UpdateDate": "2017-01-12T00:19:34+00:00",
        "VersionId": "v2"
    },
    "AWSStepFunctionsFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSStepFunctionsFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-01-11T21:51:32+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "states:*",
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJXKA6VP3UFBVHDPPA",
        "PolicyName": "AWSStepFunctionsFullAccess",
        "UpdateDate": "2017-01-11T21:51:32+00:00",
        "VersionId": "v1"
    },
    "AWSStepFunctionsReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSStepFunctionsReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2017-01-11T21:46:19+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "states:ListStateMachines",
                        "states:ListActivities",
                        "states:DescribeStateMachine",
                        "states:DescribeStateMachineForExecution",
                        "states:ListExecutions",
                        "states:DescribeExecution",
                        "states:GetExecutionHistory",
                        "states:DescribeActivity"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJONHB2TJQDJPFW5TM",
        "PolicyName": "AWSStepFunctionsReadOnlyAccess",
        "UpdateDate": "2017-11-10T22:03:49+00:00",
        "VersionId": "v2"
    },
    "AWSStorageGatewayFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSStorageGatewayFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:09+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "storagegateway:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:DescribeSnapshots",
                        "ec2:DeleteSnapshot"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJG5SSPAVOGK3SIDGU",
        "PolicyName": "AWSStorageGatewayFullAccess",
        "UpdateDate": "2015-02-06T18:41:09+00:00",
        "VersionId": "v1"
    },
    "AWSStorageGatewayReadOnlyAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSStorageGatewayReadOnlyAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:10+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "storagegateway:List*",
                        "storagegateway:Describe*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:DescribeSnapshots"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAIFKCTUVOPD5NICXJK",
        "PolicyName": "AWSStorageGatewayReadOnlyAccess",
        "UpdateDate": "2015-02-06T18:41:10+00:00",
        "VersionId": "v1"
    },
    "AWSStorageGatewayServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSStorageGatewayServiceRolePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2021-02-17T19:03:19+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "fsx:ListTagsForResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:fsx:*:*:backup/*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4E4ZEKWU2U",
        "PolicyName": "AWSStorageGatewayServiceRolePolicy",
        "UpdateDate": "2021-02-17T19:03:19+00:00",
        "VersionId": "v1"
    },
    "AWSSupportAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSSupportAccess",
        "AttachmentCount": 0,
        "CreateDate": "2015-02-06T18:41:11+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "support:*"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJSNKQX2OW67GF4S7E",
        "PolicyName": "AWSSupportAccess",
        "UpdateDate": "2015-02-06T18:41:11+00:00",
        "VersionId": "v1"
    },
    "AWSSupportServiceRolePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSSupportServiceRolePolicy",
        "AttachmentCount": 1,
        "CreateDate": "2018-04-19T18:04:44+00:00",
        "DefaultVersionId": "v14",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "apigateway:GET"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:apigateway:*::/account",
                        "arn:aws:apigateway:*::/apis",
                        "arn:aws:apigateway:*::/apis/*",
                        "arn:aws:apigateway:*::/apis/*/authorizers",
                        "arn:aws:apigateway:*::/apis/*/authorizers/*",
                        "arn:aws:apigateway:*::/apis/*/deployments",
                        "arn:aws:apigateway:*::/apis/*/deployments/*",
                        "arn:aws:apigateway:*::/apis/*/integrations",
                        "arn:aws:apigateway:*::/apis/*/integrations/*",
                        "arn:aws:apigateway:*::/apis/*/integrations/*/integrationresponses",
                        "arn:aws:apigateway:*::/apis/*/integrations/*/integrationresponses/*",
                        "arn:aws:apigateway:*::/apis/*/models",
                        "arn:aws:apigateway:*::/apis/*/models/*",
                        "arn:aws:apigateway:*::/apis/*/routes",
                        "arn:aws:apigateway:*::/apis/*/routes/*",
                        "arn:aws:apigateway:*::/apis/*/routes/*/routeresponses",
                        "arn:aws:apigateway:*::/apis/*/routes/*/routeresponses/*",
                        "arn:aws:apigateway:*::/apis/*/stages",
                        "arn:aws:apigateway:*::/apis/*/stages/*",
                        "arn:aws:apigateway:*::/clientcertificates",
                        "arn:aws:apigateway:*::/clientcertificates/*",
                        "arn:aws:apigateway:*::/domainnames",
                        "arn:aws:apigateway:*::/domainnames/*",
                        "arn:aws:apigateway:*::/domainnames/*/apimappings",
                        "arn:aws:apigateway:*::/domainnames/*/apimappings/*",
                        "arn:aws:apigateway:*::/domainnames/*/basepathmappings",
                        "arn:aws:apigateway:*::/domainnames/*/basepathmappings/*",
                        "arn:aws:apigateway:*::/restapis",
                        "arn:aws:apigateway:*::/restapis/*",
                        "arn:aws:apigateway:*::/restapis/*/authorizers",
                        "arn:aws:apigateway:*::/restapis/*/authorizers/*",
                        "arn:aws:apigateway:*::/restapis/*/deployments",
                        "arn:aws:apigateway:*::/restapis/*/deployments/*",
                        "arn:aws:apigateway:*::/restapis/*/models",
                        "arn:aws:apigateway:*::/restapis/*/models/*",
                        "arn:aws:apigateway:*::/restapis/*/models/*/default_template",
                        "arn:aws:apigateway:*::/restapis/*/resources",
                        "arn:aws:apigateway:*::/restapis/*/resources/*",
                        "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*/integration/responses/*",
                        "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*/responses/*",
                        "arn:aws:apigateway:*::/restapis/*/stages/*/sdks/*",
                        "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*",
                        "arn:aws:apigateway:*::/restapis/*/resources/*/methods/*/integration",
                        "arn:aws:apigateway:*::/restapis/*/stages",
                        "arn:aws:apigateway:*::/restapis/*/stages/*"
                    ]
                },
                {
                    "Action": [
                        "iam:DeleteRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/support.amazonaws.com/AWSServiceRoleForSupport"
                    ]
                },
                {
                    "Action": [
                        "a4b:getDevice",
                        "a4b:getProfile",
                        "a4b:getRoom",
                        "a4b:getRoomSkillParameter",
                        "a4b:getSkillGroup",
                        "a4b:searchDevices",
                        "a4b:searchProfiles",
                        "a4b:searchRooms",
                        "a4b:searchSkillGroups",
                        "access-analyzer:getFinding",
                        "access-analyzer:listAnalyzers",
                        "access-analyzer:listArchiveRules",
                        "access-analyzer:listFindings",
                        "acm-pca:describeCertificateAuthority",
                        "acm-pca:describeCertificateAuthorityAuditReport",
                        "acm-pca:getCertificate",
                        "acm-pca:getCertificateAuthorityCertificate",
                        "acm-pca:getCertificateAuthorityCsr",
                        "acm-pca:listCertificateAuthorities",
                        "acm-pca:listTags",
                        "acm:describeCertificate",
                        "acm:getCertificate",
                        "acm:listCertificates",
                        "acm:listTagsForCertificate",
                        "amplify:getApp",
                        "amplify:getBranch",
                        "amplify:getDomainAssociation",
                        "amplify:getJob",
                        "amplify:getWebhook",
                        "amplify:listApps",
                        "amplify:listWebhooks",
                        "application-autoscaling:describeScalableTargets",
                        "application-autoscaling:describeScalingActivities",
                        "application-autoscaling:describeScalingPolicies",
                        "application-autoscaling:describeScheduledActions",
                        "appmesh:describeMesh",
                        "appmesh:describeRoute",
                        "appmesh:describeVirtualNode",
                        "appmesh:describeVirtualRouter",
                        "appmesh:describeVirtualService",
                        "appmesh:listMeshes",
                        "appmesh:listRoutes",
                        "appmesh:listVirtualNodes",
                        "appmesh:listVirtualRouters",
                        "appmesh:listVirtualServices",
                        "appstream:describeDirectoryConfigs",
                        "appstream:describeFleets",
                        "appstream:describeImageBuilders",
                        "appstream:describeImages",
                        "appstream:describeSessions",
                        "appstream:describeStacks",
                        "appstream:listAssociatedFleets",
                        "appstream:listAssociatedStacks",
                        "appstream:listTagsForResource",
                        "appsync:getFunction",
                        "appsync:getGraphqlApi",
                        "appsync:getIntrospectionSchema",
                        "appsync:getResolver",
                        "appsync:getSchemaCreationStatus",
                        "appsync:getType",
                        "appsync:listDataSources",
                        "appsync:listFunctions",
                        "appsync:listGraphqlApis",
                        "appsync:listResolvers",
                        "appsync:listTypes",
                        "athena:batchGetNamedQuery",
                        "athena:batchGetQueryExecution",
                        "athena:getNamedQuery",
                        "athena:getQueryExecution",
                        "athena:getWorkGroup",
                        "athena:listNamedQueries",
                        "athena:listQueryExecutions",
                        "athena:listTagsForResource",
                        "athena:listWorkGroups",
                        "autoscaling-plans:describeScalingPlanResources",
                        "autoscaling-plans:describeScalingPlans",
                        "autoscaling-plans:getScalingPlanResourceForecastData",
                        "autoscaling:describeAccountLimits",
                        "autoscaling:describeAdjustmentTypes",
                        "autoscaling:describeAutoScalingGroups",
                        "autoscaling:describeAutoScalingInstances",
                        "autoscaling:describeAutoScalingNotificationTypes",
                        "autoscaling:describeLaunchConfigurations",
                        "autoscaling:describeLifecycleHookTypes",
                        "autoscaling:describeLifecycleHooks",
                        "autoscaling:describeLoadBalancerTargetGroups",
                        "autoscaling:describeLoadBalancers",
                        "autoscaling:describeMetricCollectionTypes",
                        "autoscaling:describeNotificationConfigurations",
                        "autoscaling:describePolicies",
                        "autoscaling:describeScalingActivities",
                        "autoscaling:describeScalingProcessTypes",
                        "autoscaling:describeScheduledActions",
                        "autoscaling:describeTags",
                        "autoscaling:describeTerminationPolicyTypes",
                        "backup:describeBackupJob",
                        "backup:describeBackupVault",
                        "backup:describeProtectedResource",
                        "backup:describeRecoveryPoint",
                        "backup:describeRestoreJob",
                        "backup:getBackupPlan",
                        "backup:getBackupPlanFromJSON",
                        "backup:getBackupPlanFromTemplate",
                        "backup:getBackupSelection",
                        "backup:getBackupVaultAccessPolicy",
                        "backup:getBackupVaultNotifications",
                        "backup:getRecoveryPointRestoreMetadata",
                        "backup:getSupportedResourceTypes",
                        "backup:listBackupJobs",
                        "backup:listBackupPlanTemplates",
                        "backup:listBackupPlanVersions",
                        "backup:listBackupPlans",
                        "backup:listBackupSelections",
                        "backup:listBackupVaults",
                        "backup:listProtectedResources",
                        "backup:listRecoveryPointsByBackupVault",
                        "backup:listRecoveryPointsByResource",
                        "backup:listRestoreJobs",
                        "backup:listTags",
                        "batch:describeComputeEnvironments",
                        "batch:describeJobDefinitions",
                        "batch:describeJobQueues",
                        "batch:describeJobs",
                        "batch:listJobs",
                        "braket:getDevice",
                        "braket:getQuantumTask",
                        "braket:searchDevices",
                        "braket:searchQuantumTasks",
                        "budgets:viewBudget",
                        "ce:getCostAndUsage",
                        "ce:getDimensionValues",
                        "ce:getReservationCoverage",
                        "ce:getReservationUtilization",
                        "ce:getTags",
                        "cloud9:describeEnvironmentMemberships",
                        "cloud9:describeEnvironments",
                        "cloud9:listEnvironments",
                        "clouddirectory:getDirectory",
                        "clouddirectory:listDirectories",
                        "cloudformation:describeAccountLimits",
                        "cloudformation:describeChangeSet",
                        "cloudformation:describeStackEvents",
                        "cloudformation:describeStackInstance",
                        "cloudformation:describeStackResource",
                        "cloudformation:describeStackResources",
                        "cloudformation:describeStackSet",
                        "cloudformation:describeStackSetOperation",
                        "cloudformation:describeStacks",
                        "cloudformation:estimateTemplateCost",
                        "cloudformation:getStackPolicy",
                        "cloudformation:getTemplate",
                        "cloudformation:getTemplateSummary",
                        "cloudformation:listChangeSets",
                        "cloudformation:listExports",
                        "cloudformation:listImports",
                        "cloudformation:listStackInstances",
                        "cloudformation:listStackResources",
                        "cloudformation:listStackSetOperationResults",
                        "cloudformation:listStackSetOperations",
                        "cloudformation:listStackSets",
                        "cloudformation:listStacks",
                        "cloudfront:getCloudFrontOriginAccessIdentity",
                        "cloudfront:getCloudFrontOriginAccessIdentityConfig",
                        "cloudfront:getDistribution",
                        "cloudfront:getDistributionConfig",
                        "cloudfront:getInvalidation",
                        "cloudfront:getStreamingDistribution",
                        "cloudfront:getStreamingDistributionConfig",
                        "cloudfront:listCloudFrontOriginAccessIdentities",
                        "cloudfront:listDistributions",
                        "cloudfront:listDistributionsByWebACLId",
                        "cloudfront:listInvalidations",
                        "cloudfront:listStreamingDistributions",
                        "cloudhsm:describeBackups",
                        "cloudhsm:describeClusters",
                        "cloudsearch:describeAnalysisSchemes",
                        "cloudsearch:describeAvailabilityOptions",
                        "cloudsearch:describeDomains",
                        "cloudsearch:describeExpressions",
                        "cloudsearch:describeIndexFields",
                        "cloudsearch:describeScalingParameters",
                        "cloudsearch:describeServiceAccessPolicies",
                        "cloudsearch:describeSuggesters",
                        "cloudsearch:listDomainNames",
                        "cloudtrail:describeTrails",
                        "cloudtrail:getEventSelectors",
                        "cloudtrail:getInsightSelectors",
                        "cloudtrail:getTrail",
                        "cloudtrail:getTrailStatus",
                        "cloudtrail:listPublicKeys",
                        "cloudtrail:listTags",
                        "cloudtrail:listTrails",
                        "cloudtrail:lookupEvents",
                        "cloudwatch:describeAlarmHistory",
                        "cloudwatch:describeAlarms",
                        "cloudwatch:describeAlarmsForMetric",
                        "cloudwatch:getDashboard",
                        "cloudwatch:getMetricData",
                        "cloudwatch:getMetricStatistics",
                        "cloudwatch:listDashboards",
                        "cloudwatch:listMetrics",
                        "codeartifact:describeDomain",
                        "codeartifact:describePackageVersion",
                        "codeartifact:describeRepository",
                        "codeartifact:getDomainPermissionsPolicy",
                        "codeartifact:getRepositoryEndPoint",
                        "codeartifact:getRepositoryPermissionsPolicy",
                        "codeartifact:listDomains",
                        "codeartifact:listPackageVersionAssets",
                        "codeartifact:listPackageVersions",
                        "codeartifact:listPackages",
                        "codeartifact:listRepositories",
                        "codeartifact:listRepositoriesInDomain",
                        "codebuild:batchGetBuildBatches",
                        "codebuild:batchGetBuilds",
                        "codebuild:batchGetProjects",
                        "codebuild:listBuildBatches",
                        "codebuild:listBuildBatchesForProject",
                        "codebuild:listBuilds",
                        "codebuild:listBuildsForProject",
                        "codebuild:listCuratedEnvironmentImages",
                        "codebuild:listProjects",
                        "codebuild:listSourceCredentials",
                        "codecommit:batchGetRepositories",
                        "codecommit:getBranch",
                        "codecommit:getRepository",
                        "codecommit:getRepositoryTriggers",
                        "codecommit:listBranches",
                        "codecommit:listRepositories",
                        "codedeploy:batchGetApplicationRevisions",
                        "codedeploy:batchGetApplications",
                        "codedeploy:batchGetDeploymentGroups",
                        "codedeploy:batchGetDeploymentInstances",
                        "codedeploy:batchGetDeploymentTargets",
                        "codedeploy:batchGetDeployments",
                        "codedeploy:batchGetOnPremisesInstances",
                        "codedeploy:getApplication",
                        "codedeploy:getApplicationRevision",
                        "codedeploy:getDeployment",
                        "codedeploy:getDeploymentConfig",
                        "codedeploy:getDeploymentGroup",
                        "codedeploy:getDeploymentInstance",
                        "codedeploy:getDeploymentTarget",
                        "codedeploy:getOnPremisesInstance",
                        "codedeploy:listApplicationRevisions",
                        "codedeploy:listApplications",
                        "codedeploy:listDeploymentConfigs",
                        "codedeploy:listDeploymentGroups",
                        "codedeploy:listDeploymentInstances",
                        "codedeploy:listDeploymentTargets",
                        "codedeploy:listDeployments",
                        "codedeploy:listGitHubAccountTokenNames",
                        "codedeploy:listOnPremisesInstances",
                        "codepipeline:getJobDetails",
                        "codepipeline:getPipeline",
                        "codepipeline:getPipelineExecution",
                        "codepipeline:getPipelineState",
                        "codepipeline:listActionExecutions",
                        "codepipeline:listActionTypes",
                        "codepipeline:listPipelineExecutions",
                        "codepipeline:listPipelines",
                        "codepipeline:listWebhooks",
                        "codestar:describeProject",
                        "codestar:listProjects",
                        "codestar:listResources",
                        "codestar:listTeamMembers",
                        "codestar:listUserProfiles",
                        "cognito-identity:describeIdentityPool",
                        "cognito-identity:getIdentityPoolRoles",
                        "cognito-identity:listIdentities",
                        "cognito-identity:listIdentityPools",
                        "cognito-idp:adminGetUser",
                        "cognito-idp:describeIdentityProvider",
                        "cognito-idp:describeResourceServer",
                        "cognito-idp:describeRiskConfiguration",
                        "cognito-idp:describeUserImportJob",
                        "cognito-idp:describeUserPool",
                        "cognito-idp:describeUserPoolClient",
                        "cognito-idp:describeUserPoolDomain",
                        "cognito-idp:getGroup",
                        "cognito-idp:getUICustomization",
                        "cognito-idp:getUser",
                        "cognito-idp:getUserPoolMfaConfig",
                        "cognito-idp:listGroups",
                        "cognito-idp:listIdentityProviders",
                        "cognito-idp:listResourceServers",
                        "cognito-idp:listUserImportJobs",
                        "cognito-idp:listUserPoolClients",
                        "cognito-idp:listUserPools",
                        "cognito-sync:describeDataset",
                        "cognito-sync:describeIdentityPoolUsage",
                        "cognito-sync:describeIdentityUsage",
                        "cognito-sync:getCognitoEvents",
                        "cognito-sync:getIdentityPoolConfiguration",
                        "cognito-sync:listDatasets",
                        "cognito-sync:listIdentityPoolUsage",
                        "compute-optimizer:getAutoScalingGroupRecommendations",
                        "compute-optimizer:getEC2InstanceRecommendations",
                        "compute-optimizer:getEC2RecommendationProjectedMetrics",
                        "compute-optimizer:getEnrollmentStatus",
                        "compute-optimizer:getRecommendationSummaries",
                        "config:describeConfigRuleEvaluationStatus",
                        "config:describeConfigRules",
                        "config:describeConfigurationRecorderStatus",
                        "config:describeConfigurationRecorders",
                        "config:describeDeliveryChannelStatus",
                        "config:describeDeliveryChannels",
                        "config:getResourceConfigHistory",
                        "config:listDiscoveredResources",
                        "connect:describeUser",
                        "connect:getCurrentMetricData",
                        "connect:getMetricData",
                        "connect:listRoutingProfiles",
                        "connect:listSecurityProfiles",
                        "connect:listUsers",
                        "controltower:describeAccountFactoryConfig",
                        "controltower:describeCoreService",
                        "controltower:describeGuardrail",
                        "controltower:describeGuardrailForTarget",
                        "controltower:describeManagedAccount",
                        "controltower:describeSingleSignOn",
                        "controltower:getAvailableUpdates",
                        "controltower:getHomeRegion",
                        "controltower:getLandingZoneStatus",
                        "controltower:listDirectoryGroups",
                        "controltower:listGuardrailViolations",
                        "controltower:listGuardrailsForTarget",
                        "controltower:listManagedAccounts",
                        "controltower:listManagedAccountsForGuardrail",
                        "controltower:listManagedAccountsForParent",
                        "controltower:listManagedOrganizationalUnits",
                        "controltower:listManagedOrganizationalUnitsForGuardrail",
                        "datapipeline:describeObjects",
                        "datapipeline:describePipelines",
                        "datapipeline:getPipelineDefinition",
                        "datapipeline:listPipelines",
                        "datapipeline:queryObjects",
                        "datasync:describeAgent",
                        "datasync:describeLocationEfs",
                        "datasync:describeLocationFsxWindows",
                        "datasync:describeLocationNfs",
                        "datasync:describeLocationS3",
                        "datasync:describeLocationSmb",
                        "datasync:describeTask",
                        "datasync:describeTaskExecution",
                        "datasync:listAgents",
                        "datasync:listLocations",
                        "datasync:listTaskExecutions",
                        "datasync:listTasks",
                        "dax:describeClusters",
                        "dax:describeDefaultParameters",
                        "dax:describeEvents",
                        "dax:describeParameterGroups",
                        "dax:describeParameters",
                        "dax:describeSubnetGroups",
                        "detective:getMembers",
                        "detective:listGraphs",
                        "detective:listInvitations",
                        "detective:listMembers",
                        "devicefarm:getAccountSettings",
                        "devicefarm:getDevice",
                        "devicefarm:getDevicePool",
                        "devicefarm:getDevicePoolCompatibility",
                        "devicefarm:getJob",
                        "devicefarm:getProject",
                        "devicefarm:getRemoteAccessSession",
                        "devicefarm:getRun",
                        "devicefarm:getSuite",
                        "devicefarm:getTest",
                        "devicefarm:getTestGridProject",
                        "devicefarm:getTestGridSession",
                        "devicefarm:getUpload",
                        "devicefarm:listArtifacts",
                        "devicefarm:listDevicePools",
                        "devicefarm:listDevices",
                        "devicefarm:listJobs",
                        "devicefarm:listProjects",
                        "devicefarm:listRemoteAccessSessions",
                        "devicefarm:listRuns",
                        "devicefarm:listSamples",
                        "devicefarm:listSuites",
                        "devicefarm:listTestGridProjects",
                        "devicefarm:listTestGridSessionActions",
                        "devicefarm:listTestGridSessionArtifacts",
                        "devicefarm:listTestGridSessions",
                        "devicefarm:listTests",
                        "devicefarm:listUniqueProblems",
                        "devicefarm:listUploads",
                        "directconnect:describeConnections",
                        "directconnect:describeConnectionsOnInterconnect",
                        "directconnect:describeInterconnects",
                        "directconnect:describeLocations",
                        "directconnect:describeVirtualGateways",
                        "directconnect:describeVirtualInterfaces",
                        "dlm:getLifecyclePolicies",
                        "dlm:getLifecyclePolicy",
                        "dms:describeAccountAttributes",
                        "dms:describeConnections",
                        "dms:describeEndpointTypes",
                        "dms:describeEndpoints",
                        "dms:describeOrderableReplicationInstances",
                        "dms:describeRefreshSchemasStatus",
                        "dms:describeReplicationInstances",
                        "dms:describeReplicationSubnetGroups",
                        "ds:describeConditionalForwarders",
                        "ds:describeDirectories",
                        "ds:describeEventTopics",
                        "ds:describeSnapshots",
                        "ds:describeTrusts",
                        "ds:getDirectoryLimits",
                        "ds:getSnapshotLimits",
                        "ds:listIpRoutes",
                        "ds:listSchemaExtensions",
                        "ds:listTagsForResource",
                        "dynamodb:describeBackup",
                        "dynamodb:describeContinuousBackups",
                        "dynamodb:describeGlobalTable",
                        "dynamodb:describeLimits",
                        "dynamodb:describeStream",
                        "dynamodb:describeTable",
                        "dynamodb:describeTimeToLive",
                        "dynamodb:listBackups",
                        "dynamodb:listGlobalTables",
                        "dynamodb:listStreams",
                        "dynamodb:listTables",
                        "dynamodb:listTagsOfResource",
                        "ec2:acceptReservedInstancesExchangeQuote",
                        "ec2:cancelReservedInstancesListing",
                        "ec2:createReservedInstancesListing",
                        "ec2:describeAccountAttributes",
                        "ec2:describeAddresses",
                        "ec2:describeAvailabilityZones",
                        "ec2:describeBundleTasks",
                        "ec2:describeByoipCidrs",
                        "ec2:describeCapacityReservations",
                        "ec2:describeClassicLinkInstances",
                        "ec2:describeClientVpnAuthorizationRules",
                        "ec2:describeClientVpnConnections",
                        "ec2:describeClientVpnEndpoints",
                        "ec2:describeClientVpnRoutes",
                        "ec2:describeClientVpnTargetNetworks",
                        "ec2:describeCoipPools",
                        "ec2:describeConversionTasks",
                        "ec2:describeCustomerGateways",
                        "ec2:describeDhcpOptions",
                        "ec2:describeElasticGpus",
                        "ec2:describeExportImageTasks",
                        "ec2:describeExportTasks",
                        "ec2:describeFastSnapshotRestores",
                        "ec2:describeFleetHistory",
                        "ec2:describeFleetInstances",
                        "ec2:describeFleets",
                        "ec2:describeFlowLogs",
                        "ec2:describeHostReservationOfferings",
                        "ec2:describeHostReservations",
                        "ec2:describeHosts",
                        "ec2:describeIdFormat",
                        "ec2:describeIdentityIdFormat",
                        "ec2:describeImageAttribute",
                        "ec2:describeImages",
                        "ec2:describeImportImageTasks",
                        "ec2:describeImportSnapshotTasks",
                        "ec2:describeInstanceAttribute",
                        "ec2:describeInstanceStatus",
                        "ec2:describeInstances",
                        "ec2:describeInternetGateways",
                        "ec2:describeKeyPairs",
                        "ec2:describeLaunchTemplateVersions",
                        "ec2:describeLaunchTemplates",
                        "ec2:describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
                        "ec2:describeLocalGatewayRouteTableVpcAssociations",
                        "ec2:describeLocalGatewayRouteTables",
                        "ec2:describeLocalGatewayVirtualInterfaceGroups",
                        "ec2:describeLocalGatewayVirtualInterfaces",
                        "ec2:describeLocalGateways",
                        "ec2:describeMovingAddresses",
                        "ec2:describeNatGateways",
                        "ec2:describeNetworkAcls",
                        "ec2:describeNetworkInterfaceAttribute",
                        "ec2:describeNetworkInterfaces",
                        "ec2:describePlacementGroups",
                        "ec2:describePrefixLists",
                        "ec2:describePublicIpv4Pools",
                        "ec2:describeRegions",
                        "ec2:describeReservedInstances",
                        "ec2:describeReservedInstancesListings",
                        "ec2:describeReservedInstancesModifications",
                        "ec2:describeReservedInstancesOfferings",
                        "ec2:describeRouteTables",
                        "ec2:describeScheduledInstances",
                        "ec2:describeSecurityGroups",
                        "ec2:describeSnapshotAttribute",
                        "ec2:describeSnapshots",
                        "ec2:describeSpotDatafeedSubscription",
                        "ec2:describeSpotFleetInstances",
                        "ec2:describeSpotFleetRequestHistory",
                        "ec2:describeSpotFleetRequests",
                        "ec2:describeSpotInstanceRequests",
                        "ec2:describeSpotPriceHistory",
                        "ec2:describeSubnets",
                        "ec2:describeTags",
                        "ec2:describeTrafficMirrorFilters",
                        "ec2:describeTrafficMirrorSessions",
                        "ec2:describeTrafficMirrorTargets",
                        "ec2:describeTransitGatewayAttachments",
                        "ec2:describeTransitGatewayRouteTables",
                        "ec2:describeTransitGatewayVpcAttachments",
                        "ec2:describeTransitGateways",
                        "ec2:describeVolumeAttribute",
                        "ec2:describeVolumeStatus",
                        "ec2:describeVolumes",
                        "ec2:describeVolumesModifications",
                        "ec2:describeVpcAttribute",
                        "ec2:describeVpcClassicLink",
                        "ec2:describeVpcClassicLinkDnsSupport",
                        "ec2:describeVpcEndpointConnectionNotifications",
                        "ec2:describeVpcEndpointConnections",
                        "ec2:describeVpcEndpointServiceConfigurations",
                        "ec2:describeVpcEndpointServicePermissions",
                        "ec2:describeVpcEndpointServices",
                        "ec2:describeVpcEndpoints",
                        "ec2:describeVpcPeeringConnections",
                        "ec2:describeVpcs",
                        "ec2:describeVpnConnections",
                        "ec2:describeVpnGateways",
                        "ec2:getCoipPoolUsage",
                        "ec2:getConsoleScreenshot",
                        "ec2:getReservedInstancesExchangeQuote",
                        "ec2:getTransitGatewayAttachmentPropagations",
                        "ec2:getTransitGatewayRouteTableAssociations",
                        "ec2:getTransitGatewayRouteTablePropagations",
                        "ec2:modifyReservedInstances",
                        "ec2:purchaseReservedInstancesOffering",
                        "ec2:searchLocalGatewayRoutes",
                        "ecr:batchCheckLayerAvailability",
                        "ecr:describeImages",
                        "ecr:describeRepositories",
                        "ecr:getRepositoryPolicy",
                        "ecr:listImages",
                        "ecs:describeClusters",
                        "ecs:describeContainerInstances",
                        "ecs:describeServices",
                        "ecs:describeTaskDefinition",
                        "ecs:describeTasks",
                        "ecs:listClusters",
                        "ecs:listContainerInstances",
                        "ecs:listServices",
                        "ecs:listTaskDefinitions",
                        "ecs:listTasks",
                        "eks:describeCluster",
                        "eks:describeFargateProfile",
                        "eks:describeNodegroup",
                        "eks:describeUpdate",
                        "eks:listClusters",
                        "eks:listFargateProfiles",
                        "eks:listNodegroups",
                        "eks:listUpdates",
                        "elasticache:describeCacheClusters",
                        "elasticache:describeCacheEngineVersions",
                        "elasticache:describeCacheParameterGroups",
                        "elasticache:describeCacheParameters",
                        "elasticache:describeCacheSecurityGroups",
                        "elasticache:describeCacheSubnetGroups",
                        "elasticache:describeEngineDefaultParameters",
                        "elasticache:describeEvents",
                        "elasticache:describeReplicationGroups",
                        "elasticache:describeReservedCacheNodes",
                        "elasticache:describeReservedCacheNodesOfferings",
                        "elasticache:describeSnapshots",
                        "elasticache:listAllowedNodeTypeModifications",
                        "elasticache:listTagsForResource",
                        "elasticbeanstalk:checkDNSAvailability",
                        "elasticbeanstalk:describeApplicationVersions",
                        "elasticbeanstalk:describeApplications",
                        "elasticbeanstalk:describeConfigurationOptions",
                        "elasticbeanstalk:describeConfigurationSettings",
                        "elasticbeanstalk:describeEnvironmentHealth",
                        "elasticbeanstalk:describeEnvironmentManagedActionHistory",
                        "elasticbeanstalk:describeEnvironmentManagedActions",
                        "elasticbeanstalk:describeEnvironmentResources",
                        "elasticbeanstalk:describeEnvironments",
                        "elasticbeanstalk:describeEvents",
                        "elasticbeanstalk:describeInstancesHealth",
                        "elasticbeanstalk:describePlatformVersion",
                        "elasticbeanstalk:listAvailableSolutionStacks",
                        "elasticbeanstalk:listPlatformVersions",
                        "elasticbeanstalk:validateConfigurationSettings",
                        "elasticfilesystem:describeAccessPoints",
                        "elasticfilesystem:describeFileSystemPolicy",
                        "elasticfilesystem:describeFileSystems",
                        "elasticfilesystem:describeLifecycleConfiguration",
                        "elasticfilesystem:describeMountTargetSecurityGroups",
                        "elasticfilesystem:describeMountTargets",
                        "elasticfilesystem:describeTags",
                        "elasticfilesystem:listTagsForResource",
                        "elasticloadbalancing:describeInstanceHealth",
                        "elasticloadbalancing:describeListenerCertificates",
                        "elasticloadbalancing:describeListeners",
                        "elasticloadbalancing:describeLoadBalancerAttributes",
                        "elasticloadbalancing:describeLoadBalancerPolicies",
                        "elasticloadbalancing:describeLoadBalancerPolicyTypes",
                        "elasticloadbalancing:describeLoadBalancers",
                        "elasticloadbalancing:describeRules",
                        "elasticloadbalancing:describeSSLPolicies",
                        "elasticloadbalancing:describeTags",
                        "elasticloadbalancing:describeTargetGroupAttributes",
                        "elasticloadbalancing:describeTargetGroups",
                        "elasticloadbalancing:describeTargetHealth",
                        "elasticmapreduce:describeCluster",
                        "elasticmapreduce:describeSecurityConfiguration",
                        "elasticmapreduce:describeStep",
                        "elasticmapreduce:listBootstrapActions",
                        "elasticmapreduce:listClusters",
                        "elasticmapreduce:listInstanceGroups",
                        "elasticmapreduce:listInstances",
                        "elasticmapreduce:listSecurityConfigurations",
                        "elasticmapreduce:listSteps",
                        "elastictranscoder:listJobsByPipeline",
                        "elastictranscoder:listJobsByStatus",
                        "elastictranscoder:listPipelines",
                        "elastictranscoder:listPresets",
                        "elastictranscoder:readPipeline",
                        "elastictranscoder:readPreset",
                        "es:describeElasticsearchDomain",
                        "es:describeElasticsearchDomainConfig",
                        "es:describeElasticsearchDomains",
                        "es:listDomainNames",
                        "es:listTags",
                        "events:describeEventBus",
                        "events:describeRule",
                        "events:listRuleNamesByTarget",
                        "events:listRules",
                        "events:listTargetsByRule",
                        "events:testEventPattern",
                        "firehose:describeDeliveryStream",
                        "firehose:listDeliveryStreams",
                        "fms:getAdminAccount",
                        "fms:getComplianceDetail",
                        "fms:getNotificationChannel",
                        "fms:getPolicy",
                        "fms:getProtectionStatus",
                        "fms:listComplianceStatus",
                        "fms:listMemberAccounts",
                        "fms:listPolicies",
                        "forecast:describeDataset",
                        "forecast:describeDatasetGroup",
                        "forecast:describeDatasetImportJob",
                        "forecast:describeForecast",
                        "forecast:describeForecastExportJob",
                        "forecast:describePredictor",
                        "forecast:getAccuracyMetrics",
                        "forecast:listDatasetGroups",
                        "forecast:listDatasetImportJobs",
                        "forecast:listDatasets",
                        "forecast:listForecastExportJobs",
                        "forecast:listForecasts",
                        "forecast:listPredictors",
                        "fsx:describeBackups",
                        "fsx:describeFileSystems",
                        "fsx:listTagsForResource",
                        "glacier:describeJob",
                        "glacier:describeVault",
                        "glacier:getDataRetrievalPolicy",
                        "glacier:getVaultAccessPolicy",
                        "glacier:getVaultLock",
                        "glacier:getVaultNotifications",
                        "glacier:listJobs",
                        "glacier:listTagsForVault",
                        "glacier:listVaults",
                        "globalaccelerator:describeAccelerator",
                        "globalaccelerator:describeAcceleratorAttributes",
                        "globalaccelerator:describeEndpointGroup",
                        "globalaccelerator:describeListener",
                        "globalaccelerator:listAccelerators",
                        "globalaccelerator:listEndpointGroups",
                        "globalaccelerator:listListeners",
                        "glue:batchGetPartition",
                        "glue:getCatalogImportStatus",
                        "glue:getClassifier",
                        "glue:getClassifiers",
                        "glue:getCrawler",
                        "glue:getCrawlerMetrics",
                        "glue:getCrawlers",
                        "glue:getDatabase",
                        "glue:getDatabases",
                        "glue:getDataflowGraph",
                        "glue:getDevEndpoint",
                        "glue:getDevEndpoints",
                        "glue:getJob",
                        "glue:getJobRun",
                        "glue:getJobRuns",
                        "glue:getJobs",
                        "glue:getMapping",
                        "glue:getPartition",
                        "glue:getPartitions",
                        "glue:getTable",
                        "glue:getTableVersions",
                        "glue:getTables",
                        "glue:getTrigger",
                        "glue:getTriggers",
                        "glue:getUserDefinedFunction",
                        "glue:getUserDefinedFunctions",
                        "greengrass:getConnectivityInfo",
                        "greengrass:getCoreDefinition",
                        "greengrass:getCoreDefinitionVersion",
                        "greengrass:getDeploymentStatus",
                        "greengrass:getDeviceDefinition",
                        "greengrass:getDeviceDefinitionVersion",
                        "greengrass:getFunctionDefinition",
                        "greengrass:getFunctionDefinitionVersion",
                        "greengrass:getGroup",
                        "greengrass:getGroupCertificateAuthority",
                        "greengrass:getGroupVersion",
                        "greengrass:getLoggerDefinition",
                        "greengrass:getLoggerDefinitionVersion",
                        "greengrass:getResourceDefinitionVersion",
                        "greengrass:getServiceRoleForAccount",
                        "greengrass:getSubscriptionDefinition",
                        "greengrass:getSubscriptionDefinitionVersion",
                        "greengrass:listCoreDefinitionVersions",
                        "greengrass:listCoreDefinitions",
                        "greengrass:listDeployments",
                        "greengrass:listDeviceDefinitionVersions",
                        "greengrass:listDeviceDefinitions",
                        "greengrass:listFunctionDefinitionVersions",
                        "greengrass:listFunctionDefinitions",
                        "greengrass:listGroupVersions",
                        "greengrass:listGroups",
                        "greengrass:listLoggerDefinitionVersions",
                        "greengrass:listLoggerDefinitions",
                        "greengrass:listResourceDefinitionVersions",
                        "greengrass:listResourceDefinitions",
                        "greengrass:listSubscriptionDefinitionVersions",
                        "greengrass:listSubscriptionDefinitions",
                        "guardduty:getDetector",
                        "guardduty:getFindings",
                        "guardduty:getFindingsStatistics",
                        "guardduty:getIPSet",
                        "guardduty:getInvitationsCount",
                        "guardduty:getMasterAccount",
                        "guardduty:getMembers",
                        "guardduty:getThreatIntelSet",
                        "guardduty:listDetectors",
                        "guardduty:listFindings",
                        "guardduty:listIPSets",
                        "guardduty:listInvitations",
                        "guardduty:listMembers",
                        "guardduty:listThreatIntelSets",
                        "health:describeAffectedEntities",
                        "health:describeEntityAggregates",
                        "health:describeEventAggregates",
                        "health:describeEventDetails",
                        "health:describeEventTypes",
                        "health:describeEvents",
                        "iam:getAccessKeyLastUsed",
                        "iam:getAccountAuthorizationDetails",
                        "iam:getAccountPasswordPolicy",
                        "iam:getAccountSummary",
                        "iam:getContextKeysForCustomPolicy",
                        "iam:getContextKeysForPrincipalPolicy",
                        "iam:getCredentialReport",
                        "iam:getGroup",
                        "iam:getGroupPolicy",
                        "iam:getInstanceProfile",
                        "iam:getLoginProfile",
                        "iam:getOpenIDConnectProvider",
                        "iam:getPolicy",
                        "iam:getPolicyVersion",
                        "iam:getRole",
                        "iam:getRolePolicy",
                        "iam:getSAMLProvider",
                        "iam:getSSHPublicKey",
                        "iam:getServerCertificate",
                        "iam:getUser",
                        "iam:getUserPolicy",
                        "iam:listAccessKeys",
                        "iam:listAccountAliases",
                        "iam:listAttachedGroupPolicies",
                        "iam:listAttachedRolePolicies",
                        "iam:listAttachedUserPolicies",
                        "iam:listEntitiesForPolicy",
                        "iam:listGroupPolicies",
                        "iam:listGroups",
                        "iam:listGroupsForUser",
                        "iam:listInstanceProfiles",
                        "iam:listInstanceProfilesForRole",
                        "iam:listMFADevices",
                        "iam:listOpenIDConnectProviders",
                        "iam:listPolicies",
                        "iam:listPolicyVersions",
                        "iam:listRolePolicies",
                        "iam:listRoles",
                        "iam:listSAMLProviders",
                        "iam:listSSHPublicKeys",
                        "iam:listServerCertificates",
                        "iam:listSigningCertificates",
                        "iam:listUserPolicies",
                        "iam:listUsers",
                        "iam:listVirtualMFADevices",
                        "iam:simulateCustomPolicy",
                        "iam:simulatePrincipalPolicy",
                        "imagebuilder:getComponent",
                        "imagebuilder:getComponentPolicy",
                        "imagebuilder:getDistributionConfiguration",
                        "imagebuilder:getImage",
                        "imagebuilder:getImagePipeline",
                        "imagebuilder:getImagePolicy",
                        "imagebuilder:getImageRecipe",
                        "imagebuilder:getImageRecipePolicy",
                        "imagebuilder:getInfrastructureConfiguration",
                        "imagebuilder:listComponentBuildVersions",
                        "imagebuilder:listComponents",
                        "imagebuilder:listDistributionConfigurations",
                        "imagebuilder:listImageBuildVersions",
                        "imagebuilder:listImagePipelineImages",
                        "imagebuilder:listImagePipelines",
                        "imagebuilder:listImageRecipes",
                        "imagebuilder:listImages",
                        "imagebuilder:listInfrastructureConfigurations",
                        "imagebuilder:listTagsForResource",
                        "importexport:getStatus",
                        "importexport:listJobs",
                        "inspector:describeAssessmentRuns",
                        "inspector:describeAssessmentTargets",
                        "inspector:describeAssessmentTemplates",
                        "inspector:describeCrossAccountAccessRole",
                        "inspector:describeResourceGroups",
                        "inspector:describeRulesPackages",
                        "inspector:getTelemetryMetadata",
                        "inspector:listAssessmentRunAgents",
                        "inspector:listAssessmentRuns",
                        "inspector:listAssessmentTargets",
                        "inspector:listAssessmentTemplates",
                        "inspector:listEventSubscriptions",
                        "inspector:listRulesPackages",
                        "inspector:listTagsForResource",
                        "iot:describeAuthorizer",
                        "iot:describeCACertificate",
                        "iot:describeCertificate",
                        "iot:describeDefaultAuthorizer",
                        "iot:describeEndpoint",
                        "iot:describeIndex",
                        "iot:describeJobExecution",
                        "iot:describeThing",
                        "iot:describeThingGroup",
                        "iot:describeTunnel",
                        "iot:getEffectivePolicies",
                        "iot:getIndexingConfiguration",
                        "iot:getLoggingOptions",
                        "iot:getPolicy",
                        "iot:getPolicyVersion",
                        "iot:getTopicRule",
                        "iot:getV2LoggingOptions",
                        "iot:listAttachedPolicies",
                        "iot:listAuthorizers",
                        "iot:listCACertificates",
                        "iot:listCertificates",
                        "iot:listCertificatesByCA",
                        "iot:listJobExecutionsForJob",
                        "iot:listJobExecutionsForThing",
                        "iot:listJobs",
                        "iot:listOutgoingCertificates",
                        "iot:listPolicies",
                        "iot:listPolicyPrincipals",
                        "iot:listPolicyVersions",
                        "iot:listPrincipalPolicies",
                        "iot:listPrincipalThings",
                        "iot:listRoleAliases",
                        "iot:listTargetsForPolicy",
                        "iot:listThingGroups",
                        "iot:listThingGroupsForThing",
                        "iot:listThingPrincipals",
                        "iot:listThingRegistrationTasks",
                        "iot:listThingTypes",
                        "iot:listThings",
                        "iot:listTopicRules",
                        "iot:listTunnels",
                        "iot:listV2LoggingLevels",
                        "iotevents:describeDetector",
                        "iotevents:describeDetectorModel",
                        "iotevents:describeInput",
                        "iotevents:describeLoggingOptions",
                        "iotevents:listDetectorModelVersions",
                        "iotevents:listDetectorModels",
                        "iotevents:listDetectors",
                        "iotevents:listInputs",
                        "iotsitewise:describeAccessPolicy",
                        "iotsitewise:describeAsset",
                        "iotsitewise:describeAssetModel",
                        "iotsitewise:describeAssetProperty",
                        "iotsitewise:describeDashboard",
                        "iotsitewise:describeGateway",
                        "iotsitewise:describeGatewayCapabilityConfiguration",
                        "iotsitewise:describeLoggingOptions",
                        "iotsitewise:describePortal",
                        "iotsitewise:describeProject",
                        "iotsitewise:listAccessPolicies",
                        "iotsitewise:listAssetModels",
                        "iotsitewise:listAssociatedAssets",
                        "iotsitewise:listDashboards",
                        "iotsitewise:listGateways",
                        "iotsitewise:listPortals",
                        "iotsitewise:listProjectAssets",
                        "iotsitewise:listProjects",
                        "kafka:describeCluster",
                        "kafka:getBootstrapBrokers",
                        "kafka:listClusters",
                        "kafka:listNodes",
                        "kendra:describeDataSource",
                        "kendra:describeFaq",
                        "kendra:describeIndex",
                        "kendra:getDataSourceSyncJobHistory",
                        "kendra:listDataSources",
                        "kendra:listFaqs",
                        "kendra:listIndices",
                        "kinesis:describeStream",
                        "kinesis:listStreams",
                        "kinesis:listTagsForStream",
                        "kinesisanalytics:describeApplication",
                        "kinesisanalytics:listApplications",
                        "kms:describeKey",
                        "kms:getKeyPolicy",
                        "kms:getKeyRotationStatus",
                        "kms:listAliases",
                        "kms:listGrants",
                        "kms:listKeyPolicies",
                        "kms:listKeys",
                        "kms:listResourceTags",
                        "kms:listRetirableGrants",
                        "lambda:getAccountSettings",
                        "lambda:getAlias",
                        "lambda:getEventSourceMapping",
                        "lambda:getFunction",
                        "lambda:getFunctionConcurrency",
                        "lambda:getFunctionConfiguration",
                        "lambda:getFunctionEventInvokeConfig",
                        "lambda:getLayerVersion",
                        "lambda:getLayerVersionPolicy",
                        "lambda:getPolicy",
                        "lambda:getProvisionedConcurrencyConfig",
                        "lambda:listAliases",
                        "lambda:listEventSourceMappings",
                        "lambda:listFunctionEventInvokeConfigs",
                        "lambda:listFunctions",
                        "lambda:listLayerVersions",
                        "lambda:listLayers",
                        "lambda:listProvisionedConcurrencyConfigs",
                        "lambda:listVersionsByFunction",
                        "launchwizard:describeProvisionedApp",
                        "launchwizard:describeProvisioningEvents",
                        "launchwizard:listProvisionedApps",
                        "lex:getBot",
                        "lex:getBotAlias",
                        "lex:getBotAliases",
                        "lex:getBotChannelAssociation",
                        "lex:getBotChannelAssociations",
                        "lex:getBotVersions",
                        "lex:getBots",
                        "lex:getBuiltinIntent",
                        "lex:getBuiltinIntents",
                        "lex:getBuiltinSlotTypes",
                        "lex:getIntent",
                        "lex:getIntentVersions",
                        "lex:getIntents",
                        "lex:getSlotType",
                        "lex:getSlotTypeVersions",
                        "lex:getSlotTypes",
                        "license-manager:getLicenseConfiguration",
                        "license-manager:getServiceSettings",
                        "license-manager:listAssociationsForLicenseConfiguration",
                        "license-manager:listFailuresForLicenseConfigurationOperations",
                        "license-manager:listLicenseConfigurations",
                        "license-manager:listLicenseSpecificationsForResource",
                        "license-manager:listResourceInventory",
                        "license-manager:listUsageForLicenseConfiguration",
                        "lightsail:getActiveNames",
                        "lightsail:getBlueprints",
                        "lightsail:getBundles",
                        "lightsail:getDomain",
                        "lightsail:getDomains",
                        "lightsail:getInstance",
                        "lightsail:getInstanceMetricData",
                        "lightsail:getInstancePortStates",
                        "lightsail:getInstanceSnapshot",
                        "lightsail:getInstanceSnapshots",
                        "lightsail:getInstanceState",
                        "lightsail:getInstances",
                        "lightsail:getKeyPair",
                        "lightsail:getKeyPairs",
                        "lightsail:getOperation",
                        "lightsail:getOperations",
                        "lightsail:getOperationsForResource",
                        "lightsail:getRegions",
                        "lightsail:getStaticIp",
                        "lightsail:getStaticIps",
                        "logs:describeDestinations",
                        "logs:describeExportTasks",
                        "logs:describeLogGroups",
                        "logs:describeLogStreams",
                        "logs:describeMetricFilters",
                        "logs:describeQueries",
                        "logs:describeSubscriptionFilters",
                        "logs:testMetricFilter",
                        "machinelearning:describeBatchPredictions",
                        "machinelearning:describeDataSources",
                        "machinelearning:describeEvaluations",
                        "machinelearning:describeMLModels",
                        "machinelearning:getBatchPrediction",
                        "machinelearning:getDataSource",
                        "machinelearning:getEvaluation",
                        "machinelearning:getMLModel",
                        "managedblockchain:getMember",
                        "managedblockchain:getNetwork",
                        "managedblockchain:getNode",
                        "managedblockchain:listMembers",
                        "managedblockchain:listNetworks",
                        "managedblockchain:listNodes",
                        "mediaconvert:describeEndpoints",
                        "mediaconvert:getJob",
                        "mediaconvert:getJobTemplate",
                        "mediaconvert:getPreset",
                        "mediaconvert:getQueue",
                        "mediaconvert:listJobTemplates",
                        "mediaconvert:listJobs",
                        "medialive:describeChannel",
                        "medialive:describeInput",
                        "medialive:describeInputDevice",
                        "medialive:describeInputSecurityGroup",
                        "medialive:describeMultiplex",
                        "medialive:describeOffering",
                        "medialive:describeReservation",
                        "medialive:describeSchedule",
                        "medialive:listChannels",
                        "medialive:listInputDevices",
                        "medialive:listInputSecurityGroups",
                        "medialive:listInputs",
                        "medialive:listMultiplexes",
                        "medialive:listOfferings",
                        "medialive:listReservations",
                        "mediapackage:describeChannel",
                        "mediapackage:describeOriginEndpoint",
                        "mediapackage:listChannels",
                        "mediapackage:listOriginEndpoints",
                        "mediastore:describeContainer",
                        "mediastore:describeObject",
                        "mediastore:getContainerPolicy",
                        "mediastore:getCorsPolicy",
                        "mediastore:listContainers",
                        "mediastore:listItems",
                        "mediatailor:getPlaybackConfiguration",
                        "mediatailor:listPlaybackConfigurations",
                        "mobiletargeting:getAdmChannel",
                        "mobiletargeting:getApnsChannel",
                        "mobiletargeting:getApnsSandboxChannel",
                        "mobiletargeting:getApnsVoipChannel",
                        "mobiletargeting:getApnsVoipSandboxChannel",
                        "mobiletargeting:getApp",
                        "mobiletargeting:getApplicationSettings",
                        "mobiletargeting:getApps",
                        "mobiletargeting:getBaiduChannel",
                        "mobiletargeting:getCampaign",
                        "mobiletargeting:getCampaignActivities",
                        "mobiletargeting:getCampaignVersion",
                        "mobiletargeting:getCampaignVersions",
                        "mobiletargeting:getCampaigns",
                        "mobiletargeting:getEmailChannel",
                        "mobiletargeting:getEndpoint",
                        "mobiletargeting:getEventStream",
                        "mobiletargeting:getExportJob",
                        "mobiletargeting:getExportJobs",
                        "mobiletargeting:getGcmChannel",
                        "mobiletargeting:getImportJob",
                        "mobiletargeting:getImportJobs",
                        "mobiletargeting:getSegment",
                        "mobiletargeting:getSegmentImportJobs",
                        "mobiletargeting:getSegmentVersion",
                        "mobiletargeting:getSegmentVersions",
                        "mobiletargeting:getSegments",
                        "mobiletargeting:getSmsChannel",
                        "mq:describeBroker",
                        "mq:describeConfiguration",
                        "mq:describeConfigurationRevision",
                        "mq:describeUser",
                        "mq:listBrokers",
                        "mq:listConfigurationRevisions",
                        "mq:listConfigurations",
                        "mq:listUsers",
                        "networkmanager:describeGlobalNetworks",
                        "networkmanager:getCustomerGatewayAssociations",
                        "networkmanager:getDevices",
                        "networkmanager:getLinkAssociations",
                        "networkmanager:getLinks",
                        "networkmanager:getSites",
                        "networkmanager:getTransitGatewayRegistrations",
                        "opsworks-cm:describeAccountAttributes",
                        "opsworks-cm:describeBackups",
                        "opsworks-cm:describeEvents",
                        "opsworks-cm:describeNodeAssociationStatus",
                        "opsworks-cm:describeServers",
                        "opsworks:describeAgentVersions",
                        "opsworks:describeApps",
                        "opsworks:describeCommands",
                        "opsworks:describeDeployments",
                        "opsworks:describeEcsClusters",
                        "opsworks:describeElasticIps",
                        "opsworks:describeElasticLoadBalancers",
                        "opsworks:describeInstances",
                        "opsworks:describeLayers",
                        "opsworks:describeLoadBasedAutoScaling",
                        "opsworks:describeMyUserProfile",
                        "opsworks:describePermissions",
                        "opsworks:describeRaidArrays",
                        "opsworks:describeRdsDbInstances",
                        "opsworks:describeServiceErrors",
                        "opsworks:describeStackProvisioningParameters",
                        "opsworks:describeStackSummary",
                        "opsworks:describeStacks",
                        "opsworks:describeTimeBasedAutoScaling",
                        "opsworks:describeUserProfiles",
                        "opsworks:describeVolumes",
                        "opsworks:getHostnameSuggestion",
                        "outposts:getOutpost",
                        "outposts:getOutpostInstanceTypes",
                        "outposts:listOutposts",
                        "outposts:listSites",
                        "personalize:describeAlgorithm",
                        "personalize:describeCampaign",
                        "personalize:describeDataset",
                        "personalize:describeDatasetGroup",
                        "personalize:describeDatasetImportJob",
                        "personalize:describeEventTracker",
                        "personalize:describeFeatureTransformation",
                        "personalize:describeRecipe",
                        "personalize:describeSchema",
                        "personalize:describeSolution",
                        "personalize:describeSolutionVersion",
                        "personalize:listCampaigns",
                        "personalize:listDatasetGroups",
                        "personalize:listDatasetImportJobs",
                        "personalize:listDatasets",
                        "personalize:listEventTrackers",
                        "personalize:listRecipes",
                        "personalize:listSchemas",
                        "personalize:listSolutionVersions",
                        "personalize:listSolutions",
                        "polly:describeVoices",
                        "polly:getLexicon",
                        "polly:listLexicons",
                        "pricing:describeServices",
                        "pricing:getAttributeValues",
                        "pricing:getProducts",
                        "quicksight:describeDashboard",
                        "quicksight:describeDashboardPermissions",
                        "quicksight:describeGroup",
                        "quicksight:describeIAMPolicyAssignment",
                        "quicksight:describeTemplate",
                        "quicksight:describeTemplateAlias",
                        "quicksight:describeTemplatePermissions",
                        "quicksight:describeUser",
                        "quicksight:listDashboards",
                        "quicksight:listGroupMemberships",
                        "quicksight:listGroups",
                        "quicksight:listIAMPolicyAssignments",
                        "quicksight:listIAMPolicyAssignmentsForUser",
                        "quicksight:listTemplateAliases",
                        "quicksight:listTemplateVersions",
                        "quicksight:listTemplates",
                        "quicksight:listUserGroups",
                        "quicksight:listUsers",
                        "rds:describeAccountAttributes",
                        "rds:describeCertificates",
                        "rds:describeDBClusterParameterGroups",
                        "rds:describeDBClusterParameters",
                        "rds:describeDBClusterSnapshots",
                        "rds:describeDBClusters",
                        "rds:describeDBEngineVersions",
                        "rds:describeDBInstances",
                        "rds:describeDBParameterGroups",
                        "rds:describeDBParameters",
                        "rds:describeDBSecurityGroups",
                        "rds:describeDBSnapshotAttributes",
                        "rds:describeDBSnapshots",
                        "rds:describeDBSubnetGroups",
                        "rds:describeEngineDefaultClusterParameters",
                        "rds:describeEngineDefaultParameters",
                        "rds:describeEventCategories",
                        "rds:describeEventSubscriptions",
                        "rds:describeEvents",
                        "rds:describeOptionGroupOptions",
                        "rds:describeOptionGroups",
                        "rds:describeOrderableDBInstanceOptions",
                        "rds:describePendingMaintenanceActions",
                        "rds:describeReservedDBInstances",
                        "rds:describeReservedDBInstancesOfferings",
                        "rds:listTagsForResource",
                        "redshift:describeClusterParameterGroups",
                        "redshift:describeClusterParameters",
                        "redshift:describeClusterSecurityGroups",
                        "redshift:describeClusterSnapshots",
                        "redshift:describeClusterSubnetGroups",
                        "redshift:describeClusterVersions",
                        "redshift:describeClusters",
                        "redshift:describeDefaultClusterParameters",
                        "redshift:describeEventCategories",
                        "redshift:describeEventSubscriptions",
                        "redshift:describeEvents",
                        "redshift:describeHsmClientCertificates",
                        "redshift:describeHsmConfigurations",
                        "redshift:describeLoggingStatus",
                        "redshift:describeOrderableClusterOptions",
                        "redshift:describeReservedNodeOfferings",
                        "redshift:describeReservedNodes",
                        "redshift:describeResize",
                        "redshift:describeSnapshotCopyGrants",
                        "redshift:describeStorage",
                        "redshift:describeTableRestoreStatus",
                        "redshift:describeTags",
                        "rekognition:listCollections",
                        "rekognition:listFaces",
                        "resource-groups:getGroup",
                        "resource-groups:getGroupQuery",
                        "resource-groups:getTags",
                        "resource-groups:listGroupResources",
                        "resource-groups:listGroups",
                        "resource-groups:searchResources",
                        "robomaker:batchDescribeSimulationJob",
                        "robomaker:describeDeploymentJob",
                        "robomaker:describeFleet",
                        "robomaker:describeRobot",
                        "robomaker:describeRobotApplication",
                        "robomaker:describeSimulationApplication",
                        "robomaker:describeSimulationJob",
                        "robomaker:listDeploymentJobs",
                        "robomaker:listFleets",
                        "robomaker:listRobotApplications",
                        "robomaker:listRobots",
                        "robomaker:listSimulationApplications",
                        "robomaker:listSimulationJobs",
                        "route53:getChange",
                        "route53:getCheckerIpRanges",
                        "route53:getGeoLocation",
                        "route53:getHealthCheck",
                        "route53:getHealthCheckCount",
                        "route53:getHealthCheckLastFailureReason",
                        "route53:getHealthCheckStatus",
                        "route53:getHostedZone",
                        "route53:getHostedZoneCount",
                        "route53:getReusableDelegationSet",
                        "route53:getTrafficPolicy",
                        "route53:getTrafficPolicyInstance",
                        "route53:getTrafficPolicyInstanceCount",
                        "route53:listGeoLocations",
                        "route53:listHealthChecks",
                        "route53:listHostedZones",
                        "route53:listHostedZonesByName",
                        "route53:listResourceRecordSets",
                        "route53:listReusableDelegationSets",
                        "route53:listTagsForResource",
                        "route53:listTagsForResources",
                        "route53:listTrafficPolicies",
                        "route53:listTrafficPolicyInstances",
                        "route53:listTrafficPolicyInstancesByHostedZone",
                        "route53:listTrafficPolicyInstancesByPolicy",
                        "route53:listTrafficPolicyVersions",
                        "route53domains:checkDomainAvailability",
                        "route53domains:getContactReachabilityStatus",
                        "route53domains:getDomainDetail",
                        "route53domains:getOperationDetail",
                        "route53domains:listDomains",
                        "route53domains:listOperations",
                        "route53domains:listTagsForDomain",
                        "route53domains:viewBilling",
                        "route53resolver:getResolverRulePolicy",
                        "route53resolver:listResolverEndpointIpAddresses",
                        "route53resolver:listResolverEndpoints",
                        "route53resolver:listResolverRuleAssociations",
                        "route53resolver:listResolverRules",
                        "route53resolver:listTagsForResource",
                        "s3:getAccelerateConfiguration",
                        "s3:getAnalyticsConfiguration",
                        "s3:getBucketAcl",
                        "s3:getBucketCORS",
                        "s3:getBucketLocation",
                        "s3:getBucketLogging",
                        "s3:getBucketNotification",
                        "s3:getBucketPolicy",
                        "s3:getBucketRequestPayment",
                        "s3:getBucketTagging",
                        "s3:getBucketVersioning",
                        "s3:getBucketWebsite",
                        "s3:getEncryptionConfiguration",
                        "s3:getInventoryConfiguration",
                        "s3:getLifecycleConfiguration",
                        "s3:getMetricsConfiguration",
                        "s3:getReplicationConfiguration",
                        "s3:listAllMyBuckets",
                        "s3:listBucket",
                        "s3:listBucketMultipartUploads",
                        "sagemaker:describeAlgorithm",
                        "sagemaker:describeApp",
                        "sagemaker:describeAutoMLJob",
                        "sagemaker:describeCompilationJob",
                        "sagemaker:describeDomain",
                        "sagemaker:describeEndpoint",
                        "sagemaker:describeEndpointConfig",
                        "sagemaker:describeExperiment",
                        "sagemaker:describeHumanTaskUi",
                        "sagemaker:describeHyperParameterTuningJob",
                        "sagemaker:describeLabelingJob",
                        "sagemaker:describeModel",
                        "sagemaker:describeModelPackage",
                        "sagemaker:describeMonitoringSchedule",
                        "sagemaker:describeNotebookInstance",
                        "sagemaker:describeNotebookInstanceLifecycleConfig",
                        "sagemaker:describeProcessingJob",
                        "sagemaker:describeSubscribedWorkteam",
                        "sagemaker:describeTrainingJob",
                        "sagemaker:describeTransformJob",
                        "sagemaker:describeTrial",
                        "sagemaker:describeTrialComponent",
                        "sagemaker:describeUserProfile",
                        "sagemaker:describeWorkteam",
                        "sagemaker:listAlgorithms",
                        "sagemaker:listApps",
                        "sagemaker:listAutoMLJobs",
                        "sagemaker:listCandidatesForAutoMLJob",
                        "sagemaker:listCodeRepositories",
                        "sagemaker:listCompilationJobs",
                        "sagemaker:listDomains",
                        "sagemaker:listEndpointConfigs",
                        "sagemaker:listEndpoints",
                        "sagemaker:listExperiments",
                        "sagemaker:listFlowDefinitions",
                        "sagemaker:listHumanTaskUis",
                        "sagemaker:listHyperParameterTuningJobs",
                        "sagemaker:listLabelingJobs",
                        "sagemaker:listLabelingJobsForWorkteam",
                        "sagemaker:listModelPackages",
                        "sagemaker:listModels",
                        "sagemaker:listMonitoringExecutions",
                        "sagemaker:listMonitoringSchedules",
                        "sagemaker:listNotebookInstanceLifecycleConfigs",
                        "sagemaker:listNotebookInstances",
                        "sagemaker:listProcessingJobs",
                        "sagemaker:listSubscribedWorkteams",
                        "sagemaker:listTags",
                        "sagemaker:listTrainingJobs",
                        "sagemaker:listTrainingJobsForHyperParameterTuningJob",
                        "sagemaker:listTransformJobs",
                        "sagemaker:listTrialComponents",
                        "sagemaker:listTrials",
                        "sagemaker:listUserProfiles",
                        "sagemaker:listWorkteams",
                        "sdb:domainMetadata",
                        "sdb:listDomains",
                        "secretsmanager:describeSecret",
                        "secretsmanager:getResourcePolicy",
                        "secretsmanager:listSecretVersionIds",
                        "secretsmanager:listSecrets",
                        "securityhub:getEnabledStandards",
                        "securityhub:getFindings",
                        "securityhub:getInsightResults",
                        "securityhub:getInsights",
                        "securityhub:getMasterAccount",
                        "securityhub:getMembers",
                        "securityhub:listEnabledProductsForImport",
                        "securityhub:listInvitations",
                        "securityhub:listMembers",
                        "servicecatalog:describeConstraint",
                        "servicecatalog:describePortfolio",
                        "servicecatalog:describeProduct",
                        "servicecatalog:describeProductAsAdmin",
                        "servicecatalog:describeProductView",
                        "servicecatalog:describeProvisioningArtifact",
                        "servicecatalog:describeProvisioningParameters",
                        "servicecatalog:describeRecord",
                        "servicecatalog:listAcceptedPortfolioShares",
                        "servicecatalog:listConstraintsForPortfolio",
                        "servicecatalog:listLaunchPaths",
                        "servicecatalog:listPortfolioAccess",
                        "servicecatalog:listPortfolios",
                        "servicecatalog:listPortfoliosForProduct",
                        "servicecatalog:listPrincipalsForPortfolio",
                        "servicecatalog:listProvisioningArtifacts",
                        "servicecatalog:listRecordHistory",
                        "servicecatalog:scanProvisionedProducts",
                        "servicecatalog:searchProducts",
                        "servicequotas:getAWSDefaultServiceQuota",
                        "servicequotas:getAssociationForServiceQuotaTemplate",
                        "servicequotas:getRequestedServiceQuotaChange",
                        "servicequotas:getServiceQuota",
                        "servicequotas:getServiceQuotaIncreaseRequestFromTemplate",
                        "servicequotas:listAWSDefaultServiceQuotas",
                        "servicequotas:listRequestedServiceQuotaChangeHistory",
                        "servicequotas:listRequestedServiceQuotaChangeHistoryByQuota",
                        "servicequotas:listServiceQuotaIncreaseRequestsInTemplate",
                        "servicequotas:listServiceQuotas",
                        "servicequotas:listServices",
                        "ses:describeActiveReceiptRuleSet",
                        "ses:describeReceiptRule",
                        "ses:describeReceiptRuleSet",
                        "ses:getAccount",
                        "ses:getBlacklistReports",
                        "ses:getConfigurationSet",
                        "ses:getConfigurationSetEventDestinations",
                        "ses:getDedicatedIp",
                        "ses:getDedicatedIps",
                        "ses:getDeliverabilityDashboardOptions",
                        "ses:getDeliverabilityTestReport",
                        "ses:getDomainDeliverabilityCampaign",
                        "ses:getDomainStatisticsReport",
                        "ses:getEmailIdentity",
                        "ses:getIdentityDkimAttributes",
                        "ses:getIdentityMailFromDomainAttributes",
                        "ses:getIdentityNotificationAttributes",
                        "ses:getIdentityPolicies",
                        "ses:getIdentityVerificationAttributes",
                        "ses:getSendQuota",
                        "ses:getSendStatistics",
                        "ses:listConfigurationSets",
                        "ses:listDedicatedIpPools",
                        "ses:listDeliverabilityTestReports",
                        "ses:listDomainDeliverabilityCampaigns",
                        "ses:listEmailIdentities",
                        "ses:listIdentities",
                        "ses:listIdentityPolicies",
                        "ses:listReceiptFilters",
                        "ses:listReceiptRuleSets",
                        "ses:listTagsForResource",
                        "ses:listVerifiedEmailAddresses",
                        "shield:describeAttack",
                        "shield:describeProtection",
                        "shield:describeSubscription",
                        "shield:listAttacks",
                        "shield:listProtections",
                        "sms-voice:getConfigurationSetEventDestinations",
                        "sms:getConnectors",
                        "sms:getReplicationJobs",
                        "sms:getReplicationRuns",
                        "sms:getServers",
                        "snowball:describeAddress",
                        "snowball:describeAddresses",
                        "snowball:describeJob",
                        "snowball:getSnowballUsage",
                        "snowball:listJobs",
                        "sns:checkIfPhoneNumberIsOptedOut",
                        "sns:getEndpointAttributes",
                        "sns:getPlatformApplicationAttributes",
                        "sns:getSMSAttributes",
                        "sns:getSubscriptionAttributes",
                        "sns:getTopicAttributes",
                        "sns:listEndpointsByPlatformApplication",
                        "sns:listPhoneNumbersOptedOut",
                        "sns:listPlatformApplications",
                        "sns:listSubscriptions",
                        "sns:listSubscriptionsByTopic",
                        "sns:listTopics",
                        "sqs:getQueueAttributes",
                        "sqs:getQueueUrl",
                        "sqs:listDeadLetterSourceQueues",
                        "sqs:listQueues",
                        "ssm:describeActivations",
                        "ssm:describeAssociation",
                        "ssm:describeAssociationExecutionTargets",
                        "ssm:describeAssociationExecutions",
                        "ssm:describeAutomationExecutions",
                        "ssm:describeAutomationStepExecutions",
                        "ssm:describeAvailablePatches",
                        "ssm:describeDocument",
                        "ssm:describeDocumentPermission",
                        "ssm:describeEffectiveInstanceAssociations",
                        "ssm:describeEffectivePatchesForPatchBaseline",
                        "ssm:describeInstanceAssociationsStatus",
                        "ssm:describeInstanceInformation",
                        "ssm:describeInstancePatchStates",
                        "ssm:describeInstancePatchStatesForPatchGroup",
                        "ssm:describeInstancePatches",
                        "ssm:describeInventoryDeletions",
                        "ssm:describeMaintenanceWindowExecutionTaskInvocations",
                        "ssm:describeMaintenanceWindowExecutionTasks",
                        "ssm:describeMaintenanceWindowExecutions",
                        "ssm:describeMaintenanceWindowSchedule",
                        "ssm:describeMaintenanceWindowTargets",
                        "ssm:describeMaintenanceWindowTasks",
                        "ssm:describeMaintenanceWindows",
                        "ssm:describeMaintenanceWindowsForTarget",
                        "ssm:describeParameters",
                        "ssm:describePatchBaselines",
                        "ssm:describePatchGroupState",
                        "ssm:describePatchGroups",
                        "ssm:describePatchProperties",
                        "ssm:describeSessions",
                        "ssm:getAutomationExecution",
                        "ssm:getCommandInvocation",
                        "ssm:getConnectionStatus",
                        "ssm:getDefaultPatchBaseline",
                        "ssm:getDeployablePatchSnapshotForInstance",
                        "ssm:getInventorySchema",
                        "ssm:getMaintenanceWindow",
                        "ssm:getMaintenanceWindowExecution",
                        "ssm:getMaintenanceWindowExecutionTask",
                        "ssm:getMaintenanceWindowExecutionTaskInvocation",
                        "ssm:getMaintenanceWindowTask",
                        "ssm:getPatchBaseline",
                        "ssm:getPatchBaselineForPatchGroup",
                        "ssm:getServiceSetting",
                        "ssm:labelParameterVersion",
                        "ssm:listAssociationVersions",
                        "ssm:listAssociations",
                        "ssm:listCommandInvocations",
                        "ssm:listCommands",
                        "ssm:listComplianceItems",
                        "ssm:listComplianceSummaries",
                        "ssm:listDocumentVersions",
                        "ssm:listDocuments",
                        "ssm:listResourceComplianceSummaries",
                        "ssm:listResourceDataSync",
                        "ssm:listTagsForResource",
                        "states:describeActivity",
                        "states:describeExecution",
                        "states:describeStateMachine",
                        "states:describeStateMachineForExecution",
                        "states:getExecutionHistory",
                        "states:listActivities",
                        "states:listExecutions",
                        "states:listStateMachines",
                        "storagegateway:describeBandwidthRateLimit",
                        "storagegateway:describeCache",
                        "storagegateway:describeCachediSCSIVolumes",
                        "storagegateway:describeGatewayInformation",
                        "storagegateway:describeMaintenanceStartTime",
                        "storagegateway:describeNFSFileShares",
                        "storagegateway:describeSMBFileShares",
                        "storagegateway:describeSMBSettings",
                        "storagegateway:describeSnapshotSchedule",
                        "storagegateway:describeStorediSCSIVolumes",
                        "storagegateway:describeTapeArchives",
                        "storagegateway:describeTapeRecoveryPoints",
                        "storagegateway:describeTapes",
                        "storagegateway:describeUploadBuffer",
                        "storagegateway:describeVTLDevices",
                        "storagegateway:describeWorkingStorage",
                        "storagegateway:listFileShares",
                        "storagegateway:listGateways",
                        "storagegateway:listLocalDisks",
                        "storagegateway:listTagsForResource",
                        "storagegateway:listTapes",
                        "storagegateway:listVolumeInitiators",
                        "storagegateway:listVolumeRecoveryPoints",
                        "storagegateway:listVolumes",
                        "swf:countClosedWorkflowExecutions",
                        "swf:countOpenWorkflowExecutions",
                        "swf:countPendingActivityTasks",
                        "swf:countPendingDecisionTasks",
                        "swf:describeActivityType",
                        "swf:describeDomain",
                        "swf:describeWorkflowExecution",
                        "swf:describeWorkflowType",
                        "swf:getWorkflowExecutionHistory",
                        "swf:listActivityTypes",
                        "swf:listClosedWorkflowExecutions",
                        "swf:listDomains",
                        "swf:listOpenWorkflowExecutions",
                        "swf:listWorkflowTypes",
                        "transfer:describeServer",
                        "transfer:describeUser",
                        "transfer:listServers",
                        "transfer:listTagsForResource",
                        "transfer:listUsers",
                        "waf-regional:getByteMatchSet",
                        "waf-regional:getChangeTokenStatus",
                        "waf-regional:getIPSet",
                        "waf-regional:getRule",
                        "waf-regional:getSqlInjectionMatchSet",
                        "waf-regional:getWebACL",
                        "waf-regional:getWebACLForResource",
                        "waf-regional:listByteMatchSets",
                        "waf-regional:listIPSets",
                        "waf-regional:listResourcesForWebACL",
                        "waf-regional:listRules",
                        "waf-regional:listSqlInjectionMatchSets",
                        "waf-regional:listWebACLs",
                        "waf:getByteMatchSet",
                        "waf:getChangeTokenStatus",
                        "waf:getIPSet",
                        "waf:getRule",
                        "waf:getSampledRequests",
                        "waf:getSizeConstraintSet",
                        "waf:getSqlInjectionMatchSet",
                        "waf:getWebACL",
                        "waf:getXssMatchSet",
                        "waf:listByteMatchSets",
                        "waf:listIPSets",
                        "waf:listRules",
                        "waf:listSizeConstraintSets",
                        "waf:listSqlInjectionMatchSets",
                        "waf:listWebACLs",
                        "waf:listXssMatchSets",
                        "wafv2:checkCapacity",
                        "wafv2:describeManagedRuleGroup",
                        "wafv2:getIPSet",
                        "wafv2:getLoggingConfiguration",
                        "wafv2:getPermissionPolicy",
                        "wafv2:getRateBasedStatementManagedKeys",
                        "wafv2:getRegexPatternSet",
                        "wafv2:getRuleGroup",
                        "wafv2:getSampledRequests",
                        "wafv2:getWebACL",
                        "wafv2:getWebACLForResource",
                        "wafv2:listAvailableManagedRuleGroups",
                        "wafv2:listIPSets",
                        "wafv2:listLoggingConfigurations",
                        "wafv2:listRegexPatternSets",
                        "wafv2:listResourcesForWebACL",
                        "wafv2:listRuleGroups",
                        "wafv2:listTagsForResource",
                        "wafv2:listWebACLs",
                        "workdocs:checkAlias",
                        "workdocs:describeAvailableDirectories",
                        "workdocs:describeInstances",
                        "worklink:describeAuditStreamConfiguration",
                        "worklink:describeCompanyNetworkConfiguration",
                        "worklink:describeDevice",
                        "worklink:describeDevicePolicyConfiguration",
                        "worklink:describeDomain",
                        "worklink:describeFleetMetadata",
                        "worklink:describeIdentityProviderConfiguration",
                        "worklink:describeWebsiteCertificateAuthority",
                        "worklink:listDevices",
                        "worklink:listDomains",
                        "worklink:listFleets",
                        "worklink:listWebsiteAuthorizationProviders",
                        "worklink:listWebsiteCertificateAuthorities",
                        "workmail:describeGroup",
                        "workmail:describeOrganization",
                        "workmail:describeResource",
                        "workmail:describeUser",
                        "workmail:listAliases",
                        "workmail:listGroupMembers",
                        "workmail:listGroups",
                        "workmail:listMailboxPermissions",
                        "workmail:listOrganizations",
                        "workmail:listResourceDelegates",
                        "workmail:listResources",
                        "workmail:listUsers",
                        "workspaces:describeAccount",
                        "workspaces:describeAccountModifications",
                        "workspaces:describeIpGroups",
                        "workspaces:describeTags",
                        "workspaces:describeWorkspaceBundles",
                        "workspaces:describeWorkspaceDirectories",
                        "workspaces:describeWorkspaceImages",
                        "workspaces:describeWorkspaces",
                        "workspaces:describeWorkspacesConnectionStatus"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAJ7W6266ELXF5MISDS",
        "PolicyName": "AWSSupportServiceRolePolicy",
        "UpdateDate": "2021-01-28T20:00:15+00:00",
        "VersionId": "v14"
    },
    "AWSSystemsManagerAccountDiscoveryServicePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSSystemsManagerAccountDiscoveryServicePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2019-10-24T17:21:05+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "organizations:DescribeAccount",
                        "organizations:DescribeOrganization",
                        "organizations:ListAccounts",
                        "organizations:ListAWSServiceAccessForOrganization",
                        "organizations:ListChildren",
                        "organizations:ListParents",
                        "organizations:ListDelegatedServicesForAccount",
                        "organizations:ListDelegatedAdministrators"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BPDSHIWK5",
        "PolicyName": "AWSSystemsManagerAccountDiscoveryServicePolicy",
        "UpdateDate": "2020-05-27T18:04:51+00:00",
        "VersionId": "v2"
    },
    "AWSSystemsManagerChangeManagementServicePolicy": {
        "Arn": "arn:aws:iam::aws:policy/aws-service-role/AWSSystemsManagerChangeManagementServicePolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-07T22:21:57+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ssm:CreateAssociation",
                        "ssm:DeleteAssociation",
                        "ssm:CreateOpsItem",
                        "ssm:GetOpsItem",
                        "ssm:UpdateOpsItem",
                        "ssm:StartAutomationExecution",
                        "ssm:StopAutomationExecution",
                        "ssm:GetAutomationExecution",
                        "ssm:GetCalendarState",
                        "ssm:GetDocument"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "cloudwatch:DescribeAlarms"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "sso:ListDirectoryAssociations"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "sso-directory:DescribeUsers",
                        "sso-directory:IsMemberInGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": "iam:GetGroup",
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ssm.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/aws-service-role/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MZTL6DXTC",
        "PolicyName": "AWSSystemsManagerChangeManagementServicePolicy",
        "UpdateDate": "2020-12-07T22:21:57+00:00",
        "VersionId": "v1"
    },
    "AWSThinkboxAWSPortalAdminPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxAWSPortalAdminPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:41:02+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:AttachInternetGateway",
                        "ec2:AssociateAddress",
                        "ec2:AssociateRouteTable",
                        "ec2:AllocateAddress",
                        "ec2:AuthorizeSecurityGroupIngress",
                        "ec2:CreateFleet",
                        "ec2:CreateLaunchTemplate",
                        "ec2:CreateInternetGateway",
                        "ec2:CreateNatGateway",
                        "ec2:CreatePlacementGroup",
                        "ec2:CreateRoute",
                        "ec2:CreateRouteTable",
                        "ec2:CreateSecurityGroup",
                        "ec2:CreateSubnet",
                        "ec2:CreateVpc",
                        "ec2:CreateVpcEndpoint",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeFleets",
                        "ec2:DescribeFleetHistory",
                        "ec2:DescribeFleetInstances",
                        "ec2:DescribeImages",
                        "ec2:DescribeInstances",
                        "ec2:DescribeInternetGateways",
                        "ec2:DescribeLaunchTemplates",
                        "ec2:DescribeRouteTables",
                        "ec2:DescribeNatGateways",
                        "ec2:DescribeTags",
                        "ec2:DescribeKeyPairs",
                        "ec2:DescribePlacementGroups",
                        "ec2:DescribeInstanceTypeOfferings",
                        "ec2:DescribeRegions",
                        "ec2:DescribeSpotFleetRequestHistory",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSpotFleetInstances",
                        "ec2:DescribeSpotFleetRequests",
                        "ec2:DescribeSpotPriceHistory",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeVpcEndpoints",
                        "ec2:GetConsoleOutput",
                        "ec2:ImportKeyPair",
                        "ec2:ReleaseAddress",
                        "ec2:RequestSpotFleet",
                        "ec2:CancelSpotFleetRequests",
                        "ec2:DisassociateAddress",
                        "ec2:DeleteFleets",
                        "ec2:DeleteLaunchTemplate",
                        "ec2:DeleteVpc",
                        "ec2:DeletePlacementGroup",
                        "ec2:DeleteVpcEndpoints",
                        "ec2:DeleteInternetGateway",
                        "ec2:DeleteSecurityGroup",
                        "ec2:RevokeSecurityGroupIngress",
                        "ec2:DeleteRoute",
                        "ec2:DeleteRouteTable",
                        "ec2:DisassociateRouteTable",
                        "ec2:DeleteSubnet",
                        "ec2:DeleteNatGateway",
                        "ec2:DetachInternetGateway",
                        "ec2:ModifyInstanceAttribute",
                        "ec2:ModifyFleet",
                        "ec2:ModifySpotFleetRequest",
                        "ec2:ModifyVpcAttribute"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:RunInstances",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:subnet/*",
                        "arn:aws:ec2:*:*:key-pair/*",
                        "arn:aws:ec2:*::snapshot/*",
                        "arn:aws:ec2:*:*:launch-template/*",
                        "arn:aws:ec2:*:*:volume/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:placement-group/*",
                        "arn:aws:ec2:*:*:network-interface/*",
                        "arn:aws:ec2:*::image/*"
                    ]
                },
                {
                    "Action": "ec2:RunInstances",
                    "Condition": {
                        "StringLike": {
                            "ec2:InstanceProfile": "arn:aws:iam::*:instance-profile/AWSPortal*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": "ec2:TerminateInstances",
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/aws:cloudformation:logical-id": "ReverseForwarder"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:TerminateInstances",
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:ec2spot:fleet-request-id": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": "ec2:TerminateInstances",
                    "Condition": {
                        "StringLike": {
                            "ec2:PlacementGroup": "*DeadlinePlacementGroup*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:PlacementGroup": "*DeadlinePlacementGroup*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:ec2:*:*:instance/*"
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:CreateAction": "RunInstances"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "ec2:CreateTags",
                        "ec2:DeleteTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:subnet/*",
                        "arn:aws:ec2:*:*:security-group/*",
                        "arn:aws:ec2:*:*:internet-gateway/*",
                        "arn:aws:ec2:*:*:route-table/*",
                        "arn:aws:ec2:*:*:volume/*",
                        "arn:aws:ec2:*:*:vpc/*",
                        "arn:aws:ec2:*:*:natgateway/*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetUser"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "iam:GetInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:instance-profile/AWSPortal*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetPolicy",
                        "iam:ListEntitiesForPolicy",
                        "iam:ListPolicyVersions"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:policy/AWSPortal*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "iam:GetRolePolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSPortal*",
                        "arn:aws:iam::*:role/DeadlineSpot*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "ec2.amazonaws.com",
                                "ec2fleet.amazonaws.com",
                                "spot.amazonaws.com",
                                "spotfleet.amazonaws.com",
                                "cloudformation.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/AWSPortal*",
                        "arn:aws:iam::*:role/DeadlineSpot*"
                    ]
                },
                {
                    "Action": "iam:CreateServiceLinkedRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "ec2fleet.amazonaws.com",
                                "spot.amazonaws.com",
                                "spotfleet.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "arn:aws:iam::*:role/aws-service-role/*"
                },
                {
                    "Action": [
                        "s3:CreateBucket",
                        "s3:GetBucketLocation",
                        "s3:GetBucketLogging",
                        "s3:GetBucketVersioning",
                        "s3:PutBucketAcl",
                        "s3:PutBucketCORS",
                        "s3:PutBucketVersioning",
                        "s3:GetBucketAcl",
                        "s3:GetObject",
                        "s3:PutBucketLogging",
                        "s3:PutBucketTagging",
                        "s3:PutObject",
                        "s3:ListBucket",
                        "s3:ListBucketVersions",
                        "s3:PutEncryptionConfiguration",
                        "s3:PutLifecycleConfiguration",
                        "s3:DeleteBucket",
                        "s3:DeleteObject",
                        "s3:DeleteBucketPolicy",
                        "s3:DeleteObjectVersion"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3::*:awsportal*",
                        "arn:aws:s3::*:stack*",
                        "arn:aws:s3::*:aws-portal-cache*",
                        "arn:aws:s3::*:logs-for-aws-portal-cache*",
                        "arn:aws:s3::*:logs-for-stack*"
                    ]
                },
                {
                    "Action": [
                        "s3:ListAllMyBuckets"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "dynamodb:Scan"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DescribeStackEvents",
                        "cloudformation:DescribeStackResources",
                        "cloudformation:DeleteStack",
                        "cloudformation:DeleteChangeSet",
                        "cloudformation:ListStackResources",
                        "cloudformation:CreateChangeSet",
                        "cloudformation:DescribeChangeSet",
                        "cloudformation:ExecuteChangeSet",
                        "cloudformation:UpdateTerminationProtection"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/stack*/*",
                        "arn:aws:cloudformation:*:*:stack/Deadline*/*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:EstimateTemplateCost",
                        "cloudformation:DescribeStacks"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "logs:DescribeLogStreams",
                        "logs:GetLogEvents",
                        "logs:PutRetentionPolicy",
                        "logs:DeleteRetentionPolicy"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:logs:*:*:log-group:/thinkbox*"
                },
                {
                    "Action": [
                        "logs:DescribeLogGroups",
                        "logs:CreateLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "kms:Encrypt",
                        "kms:GenerateDataKey"
                    ],
                    "Condition": {
                        "StringLike": {
                            "kms:ViaService": [
                                "s3.*.amazonaws.com",
                                "secretsmanager.*.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "secretsmanager:CreateSecret"
                    ],
                    "Condition": {
                        "StringLike": {
                            "secretsmanager:Name": [
                                "rcs-tls-pw*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "secretsmanager:DeleteSecret",
                        "secretsmanager:UpdateSecret",
                        "secretsmanager:DescribeSecret",
                        "secretsmanager:TagResource"
                    ],
                    "Effect": "Allow",
                    "Resource": "arn:aws:secretsmanager:*:*:secret:rcs-tls-pw*"
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4BVM3T5TP2",
        "PolicyName": "AWSThinkboxAWSPortalAdminPolicy",
        "UpdateDate": "2020-08-20T17:16:03+00:00",
        "VersionId": "v4"
    },
    "AWSThinkboxAWSPortalGatewayPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxAWSPortalGatewayPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:05:00+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:PutLogEvents",
                        "logs:DescribeLogStreams",
                        "logs:DescribeLogGroups",
                        "logs:CreateLogStream"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/thinkbox*"
                    ]
                },
                {
                    "Action": [
                        "logs:CreateLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-portal-cache*"
                    ]
                },
                {
                    "Action": "dynamodb:Scan",
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
                    ]
                },
                {
                    "Action": [
                        "s3:ListBucket",
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::stack*"
                    ]
                },
                {
                    "Action": [
                        "s3:PutObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::stack*/gateway_certs/*"
                    ]
                },
                {
                    "Action": [
                        "secretsmanager:GetSecretValue"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:secretsmanager:*:*:secret:rcs-tls-pw-stack*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FP27FM4BH",
        "PolicyName": "AWSThinkboxAWSPortalGatewayPolicy",
        "UpdateDate": "2020-06-30T16:02:07+00:00",
        "VersionId": "v2"
    },
    "AWSThinkboxAWSPortalWorkerPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxAWSPortalWorkerPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:15:05+00:00",
        "DefaultVersionId": "v4",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/DeadlineRole": "DeadlineRenderNode"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-portal-cache*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::stack*/gateway_certs/*"
                    ]
                },
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                        "logs:DescribeLogStreams",
                        "logs:DescribeLogGroups"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/thinkbox*"
                    ]
                },
                {
                    "Action": [
                        "logs:CreateLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "sqs:SendMessage",
                        "sqs:GetQueueUrl"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sqs:*:*:DeadlineAWS*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4PI3G53MMS",
        "PolicyName": "AWSThinkboxAWSPortalWorkerPolicy",
        "UpdateDate": "2020-12-07T23:27:47+00:00",
        "VersionId": "v4"
    },
    "AWSThinkboxAssetServerPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxAssetServerPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:18:53+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "logs:DescribeLogGroups",
                        "logs:DescribeLogStreams",
                        "logs:GetLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/thinkbox*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject",
                        "s3:PutObject",
                        "s3:ListBucket"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::aws-portal-cache*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4KDWZE3HCT",
        "PolicyName": "AWSThinkboxAssetServerPolicy",
        "UpdateDate": "2020-05-27T19:18:53+00:00",
        "VersionId": "v1"
    },
    "AWSThinkboxDeadlineResourceTrackerAccessPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxDeadlineResourceTrackerAccessPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:25:05+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "dynamodb:ListStreams"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "dynamodb:BatchWriteItem",
                        "dynamodb:DeleteItem",
                        "dynamodb:DescribeStream",
                        "dynamodb:DescribeTable",
                        "dynamodb:GetItem",
                        "dynamodb:GetRecords",
                        "dynamodb:GetShardIterator",
                        "dynamodb:PutItem",
                        "dynamodb:Scan",
                        "dynamodb:UpdateItem",
                        "dynamodb:UpdateTable"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeHealth*",
                        "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeInfo*",
                        "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CancelSpotFleetRequests",
                        "ec2:DeleteFleets",
                        "ec2:DescribeFleetInstances",
                        "ec2:DescribeFleets",
                        "ec2:DescribeInstances",
                        "ec2:DescribeSpotFleetInstances",
                        "ec2:DescribeSpotFleetRequests"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:RebootInstances",
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/DeadlineTrackedAWSResource": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "events:PutEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:events:*:*:event-bus/default"
                    ]
                },
                {
                    "Action": [
                        "lambda:InvokeFunction"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
                    ]
                },
                {
                    "Action": [
                        "logs:CreateLogGroup"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "logs:CreateLogStream",
                        "logs:PutLogEvents"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:logs:*:*:log-group:/aws/lambda/DeadlineResourceTracker*"
                    ]
                },
                {
                    "Action": [
                        "sqs:DeleteMessage",
                        "sqs:GetQueueAttributes",
                        "sqs:ReceiveMessage"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sqs:*:*:DeadlineAWSComputeNodeStateMessageQueue*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4OUKJ73IOS",
        "PolicyName": "AWSThinkboxDeadlineResourceTrackerAccessPolicy",
        "UpdateDate": "2020-05-27T19:25:05+00:00",
        "VersionId": "v1"
    },
    "AWSThinkboxDeadlineResourceTrackerAdminPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxDeadlineResourceTrackerAdminPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:29:09+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "application-autoscaling:DeleteScalingPolicy",
                        "application-autoscaling:DeregisterScalableTarget",
                        "application-autoscaling:DescribeScalableTargets",
                        "application-autoscaling:DescribeScalingPolicies",
                        "application-autoscaling:PutScalingPolicy",
                        "application-autoscaling:RegisterScalableTarget"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:ListStacks"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "cloudformation:CreateStack",
                        "cloudformation:DeleteStack",
                        "cloudformation:UpdateStack",
                        "cloudformation:DescribeStacks",
                        "cloudformation:UpdateTerminationProtection"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:cloudformation:*:*:stack/DeadlineResourceTracker*"
                    ]
                },
                {
                    "Action": [
                        "dynamodb:CreateTable",
                        "dynamodb:DeleteTable",
                        "dynamodb:DescribeTable",
                        "dynamodb:ListTagsOfResource",
                        "dynamodb:TagResource",
                        "dynamodb:UntagResource"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeHealth*",
                        "arn:aws:dynamodb:*:*:table/DeadlineEC2ComputeNodeInfo*",
                        "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
                    ]
                },
                {
                    "Action": [
                        "dynamodb:BatchWriteItem",
                        "dynamodb:Scan"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:dynamodb:*:*:table/DeadlineFleetHealth*"
                    ]
                },
                {
                    "Action": [
                        "events:DeleteRule",
                        "events:DescribeRule",
                        "events:PutRule",
                        "events:PutTargets",
                        "events:RemoveTargets"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:events:*:*:rule/DeadlineResourceTracker*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetRole",
                        "iam:ListAttachedRolePolicies"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/DeadlineResourceTracker*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetUser"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "dynamodb.application-autoscaling.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "lambda.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/DeadlineResourceTrackerAccess*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": [
                                "application-autoscaling.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/dynamodb.application-autoscaling.amazonaws.com/AWSServiceRoleForApplicationAutoScaling_DynamoDBTable"
                    ]
                },
                {
                    "Action": [
                        "lambda:GetEventSourceMapping"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "lambda:CreateEventSourceMapping",
                        "lambda:DeleteEventSourceMapping"
                    ],
                    "Condition": {
                        "StringLike": {
                            "lambda:FunctionArn": [
                                "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "lambda:AddPermission",
                        "lambda:RemovePermission"
                    ],
                    "Condition": {
                        "StringLike": {
                            "lambda:Principal": "events.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
                    ]
                },
                {
                    "Action": [
                        "lambda:CreateFunction",
                        "lambda:DeleteFunction",
                        "lambda:GetFunction",
                        "lambda:GetFunctionConfiguration"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:lambda:*:*:function:DeadlineResourceTracker*"
                    ]
                },
                {
                    "Action": [
                        "s3:GetObject"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:s3:::*/deadline_aws_resource_tracker-*.zip",
                        "arn:aws:s3:::*/DeadlineAWSResourceTrackerTemplate-*.yaml"
                    ]
                },
                {
                    "Action": [
                        "sqs:CreateQueue",
                        "sqs:DeleteQueue",
                        "sqs:GetQueueAttributes",
                        "sqs:ListQueueTags",
                        "sqs:TagQueue",
                        "sqs:UntagQueue"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sqs:*:*:DeadlineAWSComputeNodeState*",
                        "arn:aws:sqs:*:*:DeadlineResourceTracker*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4FKWWNUOP2",
        "PolicyName": "AWSThinkboxDeadlineResourceTrackerAdminPolicy",
        "UpdateDate": "2020-10-06T19:06:57+00:00",
        "VersionId": "v2"
    },
    "AWSThinkboxDeadlineSpotEventPluginAdminPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxDeadlineSpotEventPluginAdminPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:38:34+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:CancelSpotFleetRequests",
                        "ec2:DescribeSpotFleetInstances",
                        "ec2:DescribeSpotFleetRequests",
                        "ec2:ModifySpotFleetRequest",
                        "ec2:RequestSpotFleet"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:CreateTags"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:CreateAction": "RunInstances"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:RunInstances"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringLike": {
                            "ec2:ResourceTag/aws:ec2spot:fleet-request-id": "*"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "iam:CreateServiceLinkedRole"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "iam:AWSServiceName": [
                                "spot.amazonaws.com",
                                "spotfleet.amazonaws.com"
                            ]
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-service-role/*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetInstanceProfile"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:instance-profile/*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetRole"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-ec2-spot-fleet-tagging-role",
                        "arn:aws:iam::*:role/DeadlineSpot*"
                    ]
                },
                {
                    "Action": [
                        "iam:GetUser"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "iam:PassRole"
                    ],
                    "Condition": {
                        "StringLike": {
                            "iam:PassedToService": "ec2.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:iam::*:role/aws-ec2-spot-fleet-tagging-role",
                        "arn:aws:iam::*:role/DeadlineSpot*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4MNSGMZZZZ",
        "PolicyName": "AWSThinkboxDeadlineSpotEventPluginAdminPolicy",
        "UpdateDate": "2020-05-27T19:38:34+00:00",
        "VersionId": "v1"
    },
    "AWSThinkboxDeadlineSpotEventPluginWorkerPolicy": {
        "Arn": "arn:aws:iam::aws:policy/AWSThinkboxDeadlineSpotEventPluginWorkerPolicy",
        "AttachmentCount": 0,
        "CreateDate": "2020-05-27T19:35:00+00:00",
        "DefaultVersionId": "v2",
        "Document": {
            "Statement": [
                {
                    "Action": [
                        "ec2:DescribeInstances",
                        "ec2:DescribeTags"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/DeadlineTrackedAWSResource": "SpotEventPlugin"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "ec2:TerminateInstances"
                    ],
                    "Condition": {
                        "StringEquals": {
                            "ec2:ResourceTag/DeadlineResourceTracker": "SpotEventPlugin"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:ec2:*:*:instance/*"
                    ]
                },
                {
                    "Action": [
                        "sqs:GetQueueUrl",
                        "sqs:SendMessage"
                    ],
                    "Effect": "Allow",
                    "Resource": [
                        "arn:aws:sqs:*:*:DeadlineAWSComputeNodeState*"
                    ]
                }
            ],
            "Version": "2012-10-17"
        },
        "IsAttachable": true,
        "IsDefaultVersion": true,
        "Path": "/",
        "PermissionsBoundaryUsageCount": 0,
        "PolicyId": "ANPAZKAPJZG4JS2KSV4B2",
        "PolicyName": "AWSThinkboxDeadlineSpotEventPluginWorkerPolicy",
        "UpdateDate": "2020-12-07T23:31:31+00:00",
        "VersionId": "v2"
    },
    "AWSTransferConsoleFullAccess": {
        "Arn": "arn:aws:iam::aws:policy/AWSTransferConsoleFullAccess",
        "AttachmentCount": 0,
        "CreateDate": "2020-12-14T19:33:25+00:00",
        "DefaultVersionId": "v1",
        "Document": {
            "Statement": [
                {
                    "Action": "iam:PassRole",
                    "Condition": {
                        "StringEquals": {
                            "iam:PassedToService": "transfer.amazonaws.com"
                        }
                    },
                    "Effect": "Allow",
                    "Resource": "*"
                },
                {
                    "Action": [
                        "acm:ListCertificates",
                        "ec2:DescribeAddresses",
                        "ec2:DescribeAvailabilityZones",
                        "ec2:DescribeNetworkInterfaces",
                        "ec2:DescribeSecurityGroups",
                        "ec2:DescribeSubnets",
                        "ec2:DescribeVpcs",
                        "ec2:DescribeVpcEndpoints",
                        