from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Interface import *
from OCC.Core.TColStd import *
from OCC.Core.TCollection import *
from OCC.Core.MoniTool import *


class IFSelect_SequenceOfAppliedModifiers:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IFSelect_SequenceOfGeneralModifier:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IFSelect_SequenceOfInterfaceModel:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IFSelect_TSeqOfDispatch:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IFSelect_TSeqOfSelection:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class IFSelect_PrintFail(IntEnum):
	IFSelect_FailOnly: int = ...
	IFSelect_FailAndWarn: int = ...
IFSelect_FailOnly = IFSelect_PrintFail.IFSelect_FailOnly
IFSelect_FailAndWarn = IFSelect_PrintFail.IFSelect_FailAndWarn

class IFSelect_RemainMode(IntEnum):
	IFSelect_RemainForget: int = ...
	IFSelect_RemainCompute: int = ...
	IFSelect_RemainDisplay: int = ...
	IFSelect_RemainUndo: int = ...
IFSelect_RemainForget = IFSelect_RemainMode.IFSelect_RemainForget
IFSelect_RemainCompute = IFSelect_RemainMode.IFSelect_RemainCompute
IFSelect_RemainDisplay = IFSelect_RemainMode.IFSelect_RemainDisplay
IFSelect_RemainUndo = IFSelect_RemainMode.IFSelect_RemainUndo

class IFSelect_EditValue(IntEnum):
	IFSelect_Optional: int = ...
	IFSelect_Editable: int = ...
	IFSelect_EditProtected: int = ...
	IFSelect_EditComputed: int = ...
	IFSelect_EditRead: int = ...
	IFSelect_EditDynamic: int = ...
IFSelect_Optional = IFSelect_EditValue.IFSelect_Optional
IFSelect_Editable = IFSelect_EditValue.IFSelect_Editable
IFSelect_EditProtected = IFSelect_EditValue.IFSelect_EditProtected
IFSelect_EditComputed = IFSelect_EditValue.IFSelect_EditComputed
IFSelect_EditRead = IFSelect_EditValue.IFSelect_EditRead
IFSelect_EditDynamic = IFSelect_EditValue.IFSelect_EditDynamic

class IFSelect_ReturnStatus(IntEnum):
	IFSelect_RetVoid: int = ...
	IFSelect_RetDone: int = ...
	IFSelect_RetError: int = ...
	IFSelect_RetFail: int = ...
	IFSelect_RetStop: int = ...
IFSelect_RetVoid = IFSelect_ReturnStatus.IFSelect_RetVoid
IFSelect_RetDone = IFSelect_ReturnStatus.IFSelect_RetDone
IFSelect_RetError = IFSelect_ReturnStatus.IFSelect_RetError
IFSelect_RetFail = IFSelect_ReturnStatus.IFSelect_RetFail
IFSelect_RetStop = IFSelect_ReturnStatus.IFSelect_RetStop

class IFSelect_PrintCount(IntEnum):
	IFSelect_ItemsByEntity: int = ...
	IFSelect_CountByItem: int = ...
	IFSelect_ShortByItem: int = ...
	IFSelect_ListByItem: int = ...
	IFSelect_EntitiesByItem: int = ...
	IFSelect_CountSummary: int = ...
	IFSelect_GeneralInfo: int = ...
	IFSelect_Mapping: int = ...
	IFSelect_ResultCount: int = ...
IFSelect_ItemsByEntity = IFSelect_PrintCount.IFSelect_ItemsByEntity
IFSelect_CountByItem = IFSelect_PrintCount.IFSelect_CountByItem
IFSelect_ShortByItem = IFSelect_PrintCount.IFSelect_ShortByItem
IFSelect_ListByItem = IFSelect_PrintCount.IFSelect_ListByItem
IFSelect_EntitiesByItem = IFSelect_PrintCount.IFSelect_EntitiesByItem
IFSelect_CountSummary = IFSelect_PrintCount.IFSelect_CountSummary
IFSelect_GeneralInfo = IFSelect_PrintCount.IFSelect_GeneralInfo
IFSelect_Mapping = IFSelect_PrintCount.IFSelect_Mapping
IFSelect_ResultCount = IFSelect_PrintCount.IFSelect_ResultCount

class ifselect:
	@staticmethod
	def RestoreSession(WS: IFSelect_WorkSession, file: str) -> bool: ...
	@staticmethod
	def SaveSession(WS: IFSelect_WorkSession, file: str) -> bool: ...

class IFSelect_Activator(Standard_Transient):
	def Add(self, number: int, command: str) -> None: ...
	def AddSet(self, number: int, command: str) -> None: ...
	@staticmethod
	def Adding(actor: IFSelect_Activator, number: int, command: str, mode: int) -> None: ...
	@staticmethod
	def Commands(mode: Optional[int] = -1, command: Optional[str] = "") -> TColStd_HSequenceOfAsciiString: ...
	def Do(self, number: int, pilot: IFSelect_SessionPilot) -> IFSelect_ReturnStatus: ...
	def File(self) -> str: ...
	def Group(self) -> str: ...
	def Help(self, number: int) -> str: ...
	@staticmethod
	def Mode(command: str) -> int: ...
	@staticmethod
	def Remove(command: str) -> None: ...
	@staticmethod
	def Select(command: str, actor: IFSelect_Activator) -> Tuple[bool, int]: ...
	def SetForGroup(self, group: str, file: Optional[str] = "") -> None: ...

class IFSelect_AppliedModifiers(Standard_Transient):
	def __init__(self, nbmax: int, nbent: int) -> None: ...
	def AddModif(self, modif: IFSelect_GeneralModifier) -> bool: ...
	def AddNum(self, nument: int) -> bool: ...
	def Count(self) -> int: ...
	def IsForAll(self) -> bool: ...
	def Item(self, num: int, modif: IFSelect_GeneralModifier) -> Tuple[bool, int]: ...
	def ItemList(self) -> TColStd_HSequenceOfInteger: ...
	def ItemNum(self, nument: int) -> int: ...

class IFSelect_ContextModif:
	@overload
	def __init__(self, graph: Interface_Graph, TC: Interface_CopyTool, filename: Optional[str] = "") -> None: ...
	@overload
	def __init__(self, graph: Interface_Graph, filename: Optional[str] = "") -> None: ...
	def AddCheck(self, check: Interface_Check) -> None: ...
	def AddFail(self, start: Standard_Transient, mess: str, orig: Optional[str] = "") -> None: ...
	def AddWarning(self, start: Standard_Transient, mess: str, orig: Optional[str] = "") -> None: ...
	@overload
	def CCheck(self, num: Optional[int] = 0) -> Interface_Check: ...
	@overload
	def CCheck(self, start: Standard_Transient) -> Interface_Check: ...
	def CheckList(self) -> Interface_CheckIterator: ...
	def Control(self) -> Interface_CopyControl: ...
	def FileName(self) -> str: ...
	def HasFileName(self) -> bool: ...
	def IsForAll(self) -> bool: ...
	def IsForNone(self) -> bool: ...
	def IsSelected(self, ent: Standard_Transient) -> bool: ...
	def IsTransferred(self, ent: Standard_Transient) -> bool: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def OriginalGraph(self) -> Interface_Graph: ...
	def OriginalModel(self) -> Interface_InterfaceModel: ...
	def Protocol(self) -> Interface_Protocol: ...
	def Select(self, list: Interface_EntityIterator) -> None: ...
	def SelectedCount(self) -> int: ...
	def SelectedOriginal(self) -> Interface_EntityIterator: ...
	def SelectedResult(self) -> Interface_EntityIterator: ...
	def SetProtocol(self, proto: Interface_Protocol) -> None: ...
	def Start(self) -> None: ...
	def Trace(self, mess: Optional[str] = "") -> None: ...
	def TraceModifier(self, modif: IFSelect_GeneralModifier) -> None: ...
	def ValueOriginal(self) -> Standard_Transient: ...
	def ValueResult(self) -> Standard_Transient: ...

class IFSelect_ContextWrite:
	@overload
	def __init__(self, model: Interface_InterfaceModel, proto: Interface_Protocol, applieds: IFSelect_AppliedModifiers, filename: str) -> None: ...
	@overload
	def __init__(self, hgraph: Interface_HGraph, proto: Interface_Protocol, applieds: IFSelect_AppliedModifiers, filename: str) -> None: ...
	def AddCheck(self, check: Interface_Check) -> None: ...
	def AddFail(self, start: Standard_Transient, mess: str, orig: Optional[str] = "") -> None: ...
	def AddWarning(self, start: Standard_Transient, mess: str, orig: Optional[str] = "") -> None: ...
	def AppliedModifiers(self) -> IFSelect_AppliedModifiers: ...
	@overload
	def CCheck(self, num: Optional[int] = 0) -> Interface_Check: ...
	@overload
	def CCheck(self, start: Standard_Transient) -> Interface_Check: ...
	def CheckList(self) -> Interface_CheckIterator: ...
	def FileModifier(self) -> IFSelect_GeneralModifier: ...
	def FileName(self) -> str: ...
	def Graph(self) -> Interface_Graph: ...
	def IsForAll(self) -> bool: ...
	def IsForNone(self) -> bool: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def More(self) -> bool: ...
	def NbEntities(self) -> int: ...
	def NbModifiers(self) -> int: ...
	def Next(self) -> None: ...
	def Protocol(self) -> Interface_Protocol: ...
	def SetModifier(self, numod: int) -> bool: ...
	def Start(self) -> None: ...
	def Value(self) -> Standard_Transient: ...

class IFSelect_Dispatch(Standard_Transient):
	def CanHaveRemainder(self) -> bool: ...
	def FinalSelection(self) -> IFSelect_Selection: ...
	def GetEntities(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def HasRootName(self) -> bool: ...
	def Label(self) -> TCollection_AsciiString: ...
	def LimitedMax(self, nbent: int) -> Tuple[bool, int]: ...
	def Packeted(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def Remainder(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def RootName(self) -> TCollection_HAsciiString: ...
	def Selections(self) -> IFSelect_SelectionIterator: ...
	def SetFinalSelection(self, sel: IFSelect_Selection) -> None: ...
	def SetRootName(self, name: TCollection_HAsciiString) -> None: ...

class IFSelect_EditForm(Standard_Transient):
	@overload
	def __init__(self, editor: IFSelect_Editor, readonly: bool, undoable: bool, label: Optional[str] = "") -> None: ...
	@overload
	def __init__(self, editor: IFSelect_Editor, nums: TColStd_SequenceOfInteger, readonly: bool, undoable: bool, label: Optional[str] = "") -> None: ...
	def Apply(self) -> bool: ...
	def ApplyData(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def ClearData(self) -> None: ...
	def ClearEdit(self, num: Optional[int] = 0) -> None: ...
	def GetEditKeepStatus(self) -> bool: ...
	def SetEditKeepStatus(self, value: bool) -> None: ...
	def EditedList(self, num: int) -> TColStd_HSequenceOfHAsciiString: ...
	def EditedValue(self, num: int) -> TCollection_HAsciiString: ...
	def Editor(self) -> IFSelect_Editor: ...
	def Entity(self) -> Standard_Transient: ...
	def IsComplete(self) -> bool: ...
	def IsLoaded(self) -> bool: ...
	def IsModified(self, num: int) -> bool: ...
	def IsTouched(self, num: int) -> bool: ...
	def Label(self) -> str: ...
	def ListEditor(self, num: int) -> IFSelect_ListEditor: ...
	@overload
	def LoadData(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	@overload
	def LoadData(self) -> bool: ...
	def LoadDefault(self) -> None: ...
	def LoadEntity(self, ent: Standard_Transient) -> bool: ...
	def LoadList(self, num: int, list: TColStd_HSequenceOfHAsciiString) -> None: ...
	def LoadModel(self, model: Interface_InterfaceModel) -> bool: ...
	def LoadValue(self, num: int, val: TCollection_HAsciiString) -> None: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def Modify(self, num: int, newval: TCollection_HAsciiString, enforce: Optional[bool] = False) -> bool: ...
	def ModifyList(self, num: int, edited: IFSelect_ListEditor, enforce: Optional[bool] = False) -> bool: ...
	def ModifyListValue(self, num: int, list: TColStd_HSequenceOfHAsciiString, enforce: Optional[bool] = False) -> bool: ...
	def NameNumber(self, name: str) -> int: ...
	def NameRank(self, name: str) -> int: ...
	def NbValues(self, editable: bool) -> int: ...
	def NumberFromRank(self, rank: int) -> int: ...
	def OriginalList(self, num: int) -> TColStd_HSequenceOfHAsciiString: ...
	def OriginalValue(self, num: int) -> TCollection_HAsciiString: ...
	def RankFromNumber(self, number: int) -> int: ...
	def Recognize(self) -> bool: ...
	def SetData(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> None: ...
	def SetEntity(self, ent: Standard_Transient) -> None: ...
	def SetModel(self, model: Interface_InterfaceModel) -> None: ...
	def Touch(self, num: int, newval: TCollection_HAsciiString) -> bool: ...
	def TouchList(self, num: int, newlist: TColStd_HSequenceOfHAsciiString) -> bool: ...
	def Undo(self) -> bool: ...

class IFSelect_Editor(Standard_Transient):
	def Apply(self, form: IFSelect_EditForm, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def EditMode(self, num: int) -> IFSelect_EditValue: ...
	def Form(self, readonly: bool, undoable: Optional[bool] = True) -> IFSelect_EditForm: ...
	def IsList(self, num: int) -> bool: ...
	def Label(self) -> TCollection_AsciiString: ...
	def ListEditor(self, num: int) -> IFSelect_ListEditor: ...
	def ListValue(self, form: IFSelect_EditForm, num: int) -> TColStd_HSequenceOfHAsciiString: ...
	def Load(self, form: IFSelect_EditForm, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def MaxList(self, num: int) -> int: ...
	def MaxNameLength(self, what: int) -> int: ...
	def Name(self, num: int, isshort: Optional[bool] = False) -> str: ...
	def NameNumber(self, name: str) -> int: ...
	def NbValues(self) -> int: ...
	def Recognize(self, form: IFSelect_EditForm) -> bool: ...
	def SetList(self, num: int, max: Optional[int] = 0) -> None: ...
	def SetValue(self, num: int, typval: Interface_TypedValue, shortname: Optional[str] = "", accessmode: Optional[IFSelect_EditValue] = IFSelect_Editable) -> None: ...
	def StringValue(self, form: IFSelect_EditForm, num: int) -> TCollection_HAsciiString: ...
	def TypedValue(self, num: int) -> Interface_TypedValue: ...
	def Update(self, form: IFSelect_EditForm, num: int, newval: TCollection_HAsciiString, enforce: bool) -> bool: ...
	def UpdateList(self, form: IFSelect_EditForm, num: int, newlist: TColStd_HSequenceOfHAsciiString, enforce: bool) -> bool: ...

class IFSelect_Functions:
	@staticmethod
	def GiveDispatch(WS: IFSelect_WorkSession, name: str, mode: Optional[bool] = True) -> IFSelect_Dispatch: ...
	@staticmethod
	def GiveEntity(WS: IFSelect_WorkSession, name: Optional[str] = "") -> Standard_Transient: ...
	@staticmethod
	def GiveEntityNumber(WS: IFSelect_WorkSession, name: Optional[str] = "") -> int: ...
	@staticmethod
	def GiveList(WS: IFSelect_WorkSession, first: Optional[str] = "", second: Optional[str] = "") -> TColStd_HSequenceOfTransient: ...
	@staticmethod
	def Init() -> None: ...

class IFSelect_GeneralModifier(Standard_Transient):
	def Applies(self, disp: IFSelect_Dispatch) -> bool: ...
	def Dispatch(self) -> IFSelect_Dispatch: ...
	def HasSelection(self) -> bool: ...
	def Label(self) -> TCollection_AsciiString: ...
	def MayChangeGraph(self) -> bool: ...
	def ResetSelection(self) -> None: ...
	def Selection(self) -> IFSelect_Selection: ...
	def SetDispatch(self, disp: IFSelect_Dispatch) -> None: ...
	def SetSelection(self, sel: IFSelect_Selection) -> None: ...

class IFSelect_IntParam(Standard_Transient):
	def __init__(self) -> None: ...
	def SetStaticName(self, statname: str) -> None: ...
	def SetValue(self, val: int) -> None: ...
	def Value(self) -> int: ...

class IFSelect_ListEditor(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, def_: Interface_TypedValue, max: Optional[int] = 0) -> None: ...
	def AddValue(self, val: TCollection_HAsciiString, atnum: Optional[int] = 0) -> bool: ...
	def ClearEdit(self) -> None: ...
	def EditedValues(self) -> TColStd_HSequenceOfHAsciiString: ...
	def IsAdded(self, num: int) -> bool: ...
	def IsChanged(self, num: int) -> bool: ...
	def IsModified(self, num: int) -> bool: ...
	def IsTouched(self) -> bool: ...
	def LoadEdited(self, list: TColStd_HSequenceOfHAsciiString) -> bool: ...
	def LoadModel(self, model: Interface_InterfaceModel) -> None: ...
	def LoadValues(self, vals: TColStd_HSequenceOfHAsciiString) -> None: ...
	def NbValues(self, edited: Optional[bool] = True) -> int: ...
	def OriginalValues(self) -> TColStd_HSequenceOfHAsciiString: ...
	def Remove(self, num: Optional[int] = 0, howmany: Optional[int] = 1) -> bool: ...
	def SetTouched(self) -> None: ...
	def SetValue(self, num: int, val: TCollection_HAsciiString) -> bool: ...
	def Value(self, num: int, edited: Optional[bool] = True) -> TCollection_HAsciiString: ...

class IFSelect_ModelCopier(Standard_Transient):
	def __init__(self) -> None: ...
	def AddFile(self, filename: TCollection_AsciiString, content: Interface_InterfaceModel) -> bool: ...
	def AddSentFile(self, filename: str) -> None: ...
	def AppliedModifiers(self, num: int) -> IFSelect_AppliedModifiers: ...
	def BeginSentFiles(self, sho: IFSelect_ShareOut, record: bool) -> None: ...
	def ClearAppliedModifiers(self, num: int) -> bool: ...
	def ClearFile(self, num: int) -> bool: ...
	def ClearResult(self) -> None: ...
	def CopiedRemaining(self, G: Interface_Graph, WL: IFSelect_WorkLibrary, TC: Interface_CopyTool, newmod: Interface_InterfaceModel) -> None: ...
	def Copy(self, eval: IFSelect_ShareOutResult, WL: IFSelect_WorkLibrary, protocol: Interface_Protocol) -> Interface_CheckIterator: ...
	def FileModel(self, num: int) -> Interface_InterfaceModel: ...
	def FileName(self, num: int) -> TCollection_AsciiString: ...
	def NameFile(self, num: int, filename: TCollection_AsciiString) -> bool: ...
	def NbFiles(self) -> int: ...
	def Send(self, eval: IFSelect_ShareOutResult, WL: IFSelect_WorkLibrary, protocol: Interface_Protocol) -> Interface_CheckIterator: ...
	def SendAll(self, filename: str, G: Interface_Graph, WL: IFSelect_WorkLibrary, protocol: Interface_Protocol) -> Interface_CheckIterator: ...
	def SendCopied(self, WL: IFSelect_WorkLibrary, protocol: Interface_Protocol) -> Interface_CheckIterator: ...
	def SendSelected(self, filename: str, G: Interface_Graph, WL: IFSelect_WorkLibrary, protocol: Interface_Protocol, iter: Interface_EntityIterator) -> Interface_CheckIterator: ...
	def SentFiles(self) -> TColStd_HSequenceOfHAsciiString: ...
	def SetAppliedModifiers(self, num: int, applied: IFSelect_AppliedModifiers) -> bool: ...
	def SetRemaining(self, CG: Interface_Graph) -> bool: ...
	def SetShareOut(self, sho: IFSelect_ShareOut) -> None: ...

class IFSelect_PacketList(Standard_Transient):
	def __init__(self, model: Interface_InterfaceModel) -> None: ...
	def Add(self, ent: Standard_Transient) -> None: ...
	def AddList(self, list: TColStd_HSequenceOfTransient) -> None: ...
	def AddPacket(self) -> None: ...
	def Duplicated(self, count: int, andmore: bool) -> Interface_EntityIterator: ...
	def Entities(self, numpack: int) -> Interface_EntityIterator: ...
	def HighestDuplicationCount(self) -> int: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def Name(self) -> str: ...
	def NbDuplicated(self, count: int, andmore: bool) -> int: ...
	def NbEntities(self, numpack: int) -> int: ...
	def NbPackets(self) -> int: ...
	def SetName(self, name: str) -> None: ...

class IFSelect_Selection(Standard_Transient):
	def CompleteResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def FillIterator(self, iter: IFSelect_SelectionIterator) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def UniqueResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectionIterator:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, sel: IFSelect_Selection) -> None: ...
	def AddFromIter(self, iter: IFSelect_SelectionIterator) -> None: ...
	def AddItem(self, sel: IFSelect_Selection) -> None: ...
	def AddList(self, list: IFSelect_TSeqOfSelection) -> None: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def Value(self) -> IFSelect_Selection: ...

class IFSelect_SessionDumper(Standard_Transient):
	@staticmethod
	def First() -> IFSelect_SessionDumper: ...
	def Next(self) -> IFSelect_SessionDumper: ...
	def ReadOwn(self, file: IFSelect_SessionFile, type: TCollection_AsciiString, item: Standard_Transient) -> bool: ...
	def WriteOwn(self, file: IFSelect_SessionFile, item: Standard_Transient) -> bool: ...

class IFSelect_SessionFile:
	@overload
	def __init__(self, WS: IFSelect_WorkSession) -> None: ...
	@overload
	def __init__(self, WS: IFSelect_WorkSession, filename: str) -> None: ...
	def AddItem(self, item: Standard_Transient, active: Optional[bool] = True) -> None: ...
	def AddLine(self, line: str) -> None: ...
	def ClearLines(self) -> None: ...
	def Destroy(self) -> None: ...
	def IsDone(self) -> bool: ...
	def IsText(self, num: int) -> bool: ...
	def IsVoid(self, num: int) -> bool: ...
	def ItemValue(self, num: int) -> Standard_Transient: ...
	def Line(self, num: int) -> TCollection_AsciiString: ...
	def NbLines(self) -> int: ...
	def NbParams(self) -> int: ...
	def NewItem(self, ident: int, par: Standard_Transient) -> None: ...
	def ParamValue(self, num: int) -> TCollection_AsciiString: ...
	def Read(self, filename: str) -> int: ...
	def ReadEnd(self) -> int: ...
	def ReadFile(self, name: str) -> bool: ...
	def ReadLine(self) -> bool: ...
	def ReadOwn(self, item: Standard_Transient) -> bool: ...
	def ReadSession(self) -> int: ...
	def RecognizeFile(self, headerline: str) -> bool: ...
	def RemoveLastLine(self) -> None: ...
	def SendItem(self, par: Standard_Transient) -> None: ...
	def SendText(self, text: str) -> None: ...
	def SendVoid(self) -> None: ...
	def SetLastGeneral(self, lastgen: int) -> None: ...
	def SetOwn(self, mode: bool) -> None: ...
	def SplitLine(self, line: str) -> None: ...
	def TextValue(self, num: int) -> TCollection_AsciiString: ...
	def WorkSession(self) -> IFSelect_WorkSession: ...
	def Write(self, filename: str) -> int: ...
	def WriteEnd(self) -> int: ...
	def WriteFile(self, name: str) -> bool: ...
	def WriteLine(self, line: str, follow: Optional[str] = 0) -> None: ...
	def WriteOwn(self, item: Standard_Transient) -> bool: ...
	def WriteSession(self) -> int: ...

class IFSelect_ShareOut(Standard_Transient):
	def __init__(self) -> None: ...
	def AddDispatch(self, disp: IFSelect_Dispatch) -> None: ...
	def AddModif(self, modifier: IFSelect_GeneralModifier, formodel: bool, atnum: Optional[int] = 0) -> None: ...
	@overload
	def AddModifier(self, modifier: IFSelect_GeneralModifier, atnum: int) -> None: ...
	@overload
	def AddModifier(self, modifier: IFSelect_GeneralModifier, dispnum: int, atnum: int) -> None: ...
	def ChangeModifierRank(self, formodel: bool, befor: int, after: int) -> bool: ...
	def Clear(self, onlydisp: bool) -> None: ...
	def ClearResult(self, alsoname: bool) -> None: ...
	def DefaultRootName(self) -> TCollection_HAsciiString: ...
	def Dispatch(self, num: int) -> IFSelect_Dispatch: ...
	def DispatchRank(self, disp: IFSelect_Dispatch) -> int: ...
	def Extension(self) -> TCollection_HAsciiString: ...
	def FileName(self, dnum: int, pnum: int, nbpack: Optional[int] = 0) -> TCollection_AsciiString: ...
	def GeneralModifier(self, formodel: bool, num: int) -> IFSelect_GeneralModifier: ...
	def HasRootName(self, num: int) -> bool: ...
	def LastRun(self) -> int: ...
	def ModelModifier(self, num: int) -> IFSelect_Modifier: ...
	def ModifierRank(self, modifier: IFSelect_GeneralModifier) -> int: ...
	def NbDispatches(self) -> int: ...
	def NbModifiers(self, formodel: bool) -> int: ...
	def Prefix(self) -> TCollection_HAsciiString: ...
	def RemoveDispatch(self, rank: int) -> bool: ...
	def RemoveItem(self, item: Standard_Transient) -> bool: ...
	def RemoveModifier(self, formodel: bool, num: int) -> bool: ...
	def RootName(self, num: int) -> TCollection_HAsciiString: ...
	def RootNumber(self, name: TCollection_HAsciiString) -> int: ...
	def SetDefaultRootName(self, defrt: TCollection_HAsciiString) -> bool: ...
	def SetExtension(self, ext: TCollection_HAsciiString) -> None: ...
	def SetLastRun(self, last: int) -> None: ...
	def SetPrefix(self, pref: TCollection_HAsciiString) -> None: ...
	def SetRootName(self, num: int, name: TCollection_HAsciiString) -> bool: ...

class IFSelect_ShareOutResult:
	@overload
	def __init__(self, sho: IFSelect_ShareOut, mod: Interface_InterfaceModel) -> None: ...
	@overload
	def __init__(self, sho: IFSelect_ShareOut, G: Interface_Graph) -> None: ...
	@overload
	def __init__(self, disp: IFSelect_Dispatch, mod: Interface_InterfaceModel) -> None: ...
	@overload
	def __init__(self, disp: IFSelect_Dispatch, G: Interface_Graph) -> None: ...
	def Dispatch(self) -> IFSelect_Dispatch: ...
	def DispatchRank(self) -> int: ...
	def Evaluate(self) -> None: ...
	def FileName(self) -> TCollection_AsciiString: ...
	def Graph(self) -> Interface_Graph: ...
	def More(self) -> bool: ...
	def NbPackets(self) -> int: ...
	def Next(self) -> None: ...
	def NextDispatch(self) -> None: ...
	def PacketContent(self) -> Interface_EntityIterator: ...
	def PacketRoot(self) -> Interface_EntityIterator: ...
	def Packets(self, complete: Optional[bool] = True) -> IFSelect_PacketList: ...
	def PacketsInDispatch(self) -> Tuple[int, int]: ...
	def Prepare(self) -> None: ...
	def Reset(self) -> None: ...
	def ShareOut(self) -> IFSelect_ShareOut: ...

class IFSelect_Signature(Interface_SignType):
	def AddCase(self, acase: str) -> None: ...
	def CaseList(self) -> TColStd_HSequenceOfAsciiString: ...
	@staticmethod
	def IntValue(val: int) -> str: ...
	def IsIntCase(self) -> Tuple[bool, bool, int, bool, int]: ...
	def Label(self) -> TCollection_AsciiString: ...
	@staticmethod
	def MatchValue(val: str, text: TCollection_AsciiString, exact: bool) -> bool: ...
	def Matches(self, ent: Standard_Transient, model: Interface_InterfaceModel, text: TCollection_AsciiString, exact: bool) -> bool: ...
	def Name(self) -> str: ...
	def SetIntCase(self, hasmin: bool, valmin: int, hasmax: bool, valmax: int) -> None: ...

class IFSelect_SignatureList(Standard_Transient):
	def __init__(self, withlist: Optional[bool] = False) -> None: ...
	def Add(self, ent: Standard_Transient, sign: str) -> None: ...
	def Clear(self) -> None: ...
	def Entities(self, sign: str) -> TColStd_HSequenceOfTransient: ...
	def HasEntities(self) -> bool: ...
	def LastValue(self) -> str: ...
	def List(self, root: Optional[str] = "") -> TColStd_HSequenceOfHAsciiString: ...
	def GetModeSignOnly(self) -> bool: ...
	def SetModeSignOnly(self, value: bool) -> None: ...
	def Name(self) -> str: ...
	def NbNulls(self) -> int: ...
	def NbTimes(self, sign: str) -> int: ...
	def SetList(self, withlist: bool) -> None: ...
	def SetName(self, name: str) -> None: ...

class IFSelect_Transformer(Standard_Transient):
	def ChangeProtocol(self, newproto: Interface_Protocol) -> bool: ...
	def Label(self) -> TCollection_AsciiString: ...
	def Perform(self, G: Interface_Graph, protocol: Interface_Protocol, checks: Interface_CheckIterator, newmod: Interface_InterfaceModel) -> bool: ...
	def Updated(self, entfrom: Standard_Transient, entto: Standard_Transient) -> bool: ...

class IFSelect_WorkLibrary(Standard_Transient):
	def CopyModel(self, original: Interface_InterfaceModel, newmodel: Interface_InterfaceModel, list: Interface_EntityIterator, TC: Interface_CopyTool) -> bool: ...
	def DumpHelp(self, level: int) -> str: ...
	def DumpLevels(self) -> Tuple[int, int]: ...
	def ReadFile(self, name: str, model: Interface_InterfaceModel, protocol: Interface_Protocol) -> int: ...
	def SetDumpHelp(self, level: int, help: str) -> None: ...
	def SetDumpLevels(self, def_: int, max: int) -> None: ...
	def WriteFile(self, ctx: IFSelect_ContextWrite) -> bool: ...

class IFSelect_WorkSession(Standard_Transient):
	def __init__(self) -> None: ...
	def AddItem(self, item: Standard_Transient, active: Optional[bool] = True) -> int: ...
	def AddNamedItem(self, name: str, item: Standard_Transient, active: Optional[bool] = True) -> int: ...
	def AppliedDispatches(self) -> TColStd_HSequenceOfInteger: ...
	def BeginSentFiles(self, record: bool) -> None: ...
	def CategoryName(self, ent: Standard_Transient) -> str: ...
	def CategoryNumber(self, ent: Standard_Transient) -> int: ...
	def ChangeModifierRank(self, formodel: bool, before: int, after: int) -> bool: ...
	def CheckOne(self, ent: Standard_Transient, complete: Optional[bool] = True) -> Interface_CheckIterator: ...
	def ClearData(self, mode: int) -> None: ...
	def ClearFile(self) -> None: ...
	def ClearFinalModifiers(self) -> None: ...
	def ClearItems(self) -> None: ...
	def ClearShareOut(self, onlydisp: bool) -> None: ...
	def CombineAdd(self, selcomb: IFSelect_Selection, seladd: IFSelect_Selection, atnum: Optional[int] = 0) -> int: ...
	def CombineRemove(self, selcomb: IFSelect_Selection, selrem: IFSelect_Selection) -> bool: ...
	def ComputeCheck(self, enforce: Optional[bool] = False) -> bool: ...
	def ComputeCounter(self, counter: IFSelect_SignCounter, forced: Optional[bool] = False) -> bool: ...
	def ComputeCounterFromList(self, counter: IFSelect_SignCounter, list: TColStd_HSequenceOfTransient, clear: Optional[bool] = True) -> bool: ...
	def ComputeGraph(self, enforce: Optional[bool] = False) -> bool: ...
	def DefaultFileRoot(self) -> TCollection_HAsciiString: ...
	def Dispatch(self, id: int) -> IFSelect_Dispatch: ...
	def DispatchRank(self, disp: IFSelect_Dispatch) -> int: ...
	def DumpSelection(self, sel: IFSelect_Selection) -> None: ...
	def DumpShare(self) -> None: ...
	def EntityLabel(self, ent: Standard_Transient) -> TCollection_HAsciiString: ...
	def EntityName(self, ent: Standard_Transient) -> TCollection_HAsciiString: ...
	def ErrorHandle(self) -> bool: ...
	def EvalSelection(self, sel: IFSelect_Selection) -> Interface_EntityIterator: ...
	def EvalSplit(self) -> IFSelect_PacketList: ...
	def EvaluateComplete(self, mode: Optional[int] = 0) -> None: ...
	def EvaluateDispatch(self, disp: IFSelect_Dispatch, mode: Optional[int] = 0) -> None: ...
	def EvaluateFile(self) -> None: ...
	def EvaluateSelection(self, sel: IFSelect_Selection) -> None: ...
	def FileExtension(self) -> TCollection_HAsciiString: ...
	def FileModel(self, num: int) -> Interface_InterfaceModel: ...
	def FileName(self, num: int) -> TCollection_AsciiString: ...
	def FilePrefix(self) -> TCollection_HAsciiString: ...
	def FileRoot(self, disp: IFSelect_Dispatch) -> TCollection_HAsciiString: ...
	def FinalModifierIdents(self, formodel: bool) -> TColStd_HSequenceOfInteger: ...
	def GeneralModifier(self, id: int) -> IFSelect_GeneralModifier: ...
	def GetModeStat(self) -> bool: ...
	def GiveFileComplete(self, file: str) -> str: ...
	def GiveFileRoot(self, file: str) -> str: ...
	@overload
	def GiveList(self, obj: Standard_Transient) -> TColStd_HSequenceOfTransient: ...
	@overload
	def GiveList(self, first: str, second: Optional[str] = "") -> TColStd_HSequenceOfTransient: ...
	def GiveListCombined(self, l1: TColStd_HSequenceOfTransient, l2: TColStd_HSequenceOfTransient, mode: int) -> TColStd_HSequenceOfTransient: ...
	def GiveListFromList(self, selname: str, ent: Standard_Transient) -> TColStd_HSequenceOfTransient: ...
	def GiveSelection(self, selname: str) -> IFSelect_Selection: ...
	def Graph(self) -> Interface_Graph: ...
	def HGraph(self) -> Interface_HGraph: ...
	def HasModel(self) -> bool: ...
	def HasName(self, item: Standard_Transient) -> bool: ...
	def IntParam(self, id: int) -> IFSelect_IntParam: ...
	def IntValue(self, it: IFSelect_IntParam) -> int: ...
	def IsLoaded(self) -> bool: ...
	def IsReversedSelectExtract(self, sel: IFSelect_Selection) -> bool: ...
	def Item(self, id: int) -> Standard_Transient: ...
	def ItemIdent(self, item: Standard_Transient) -> int: ...
	def ItemIdents(self, type: Standard_Type) -> TColStd_HSequenceOfInteger: ...
	def ItemLabel(self, id: int) -> TCollection_HAsciiString: ...
	def ItemNames(self, type: Standard_Type) -> TColStd_HSequenceOfHAsciiString: ...
	def ItemNamesForLabel(self, label: str) -> TColStd_HSequenceOfHAsciiString: ...
	def ItemSelection(self, item: Standard_Transient) -> IFSelect_Selection: ...
	def LastRunCheckList(self) -> Interface_CheckIterator: ...
	def ListFinalModifiers(self, formodel: bool) -> None: ...
	def ListItems(self, label: Optional[str] = "") -> None: ...
	def LoadedFile(self) -> str: ...
	def MaxIdent(self) -> int: ...
	def MaxSendingCount(self) -> int: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def ModelCheckList(self, complete: Optional[bool] = True) -> Interface_CheckIterator: ...
	def ModelCopier(self) -> IFSelect_ModelCopier: ...
	def ModelModifier(self, id: int) -> IFSelect_Modifier: ...
	def ModifierRank(self, item: IFSelect_GeneralModifier) -> int: ...
	def Name(self, item: Standard_Transient) -> TCollection_HAsciiString: ...
	def NameIdent(self, name: str) -> int: ...
	@overload
	def NamedItem(self, name: str) -> Standard_Transient: ...
	@overload
	def NamedItem(self, name: TCollection_HAsciiString) -> Standard_Transient: ...
	def NbFiles(self) -> int: ...
	def NbFinalModifiers(self, formodel: bool) -> int: ...
	def NbSources(self, sel: IFSelect_Selection) -> int: ...
	def NbStartingEntities(self) -> int: ...
	def NewIntParam(self, name: Optional[str] = "") -> IFSelect_IntParam: ...
	def NewParamFromStatic(self, statname: str, name: Optional[str] = "") -> Standard_Transient: ...
	def NewSelectPointed(self, list: TColStd_HSequenceOfTransient, name: str) -> IFSelect_Selection: ...
	def NewTextParam(self, name: Optional[str] = "") -> TCollection_HAsciiString: ...
	def NewTransformStandard(self, copy: bool, name: Optional[str] = "") -> IFSelect_Transformer: ...
	def NextIdentForLabel(self, label: str, id: int, mode: Optional[int] = 0) -> int: ...
	def NumberFromLabel(self, val: str, afternum: Optional[int] = 0) -> int: ...
	def Protocol(self) -> Interface_Protocol: ...
	def QueryCheckList(self, chl: Interface_CheckIterator) -> None: ...
	def QueryCheckStatus(self, ent: Standard_Transient) -> int: ...
	def QueryParent(self, entdad: Standard_Transient, entson: Standard_Transient) -> int: ...
	def ReadFile(self, filename: str) -> IFSelect_ReturnStatus: ...
	def RemoveItem(self, item: Standard_Transient) -> bool: ...
	def RemoveName(self, name: str) -> bool: ...
	def RemoveNamedItem(self, name: str) -> bool: ...
	def ResetAppliedModifier(self, modif: IFSelect_GeneralModifier) -> bool: ...
	def ResetItemSelection(self, item: Standard_Transient) -> bool: ...
	def RunModifier(self, modif: IFSelect_Modifier, copy: bool) -> int: ...
	def RunModifierSelected(self, modif: IFSelect_Modifier, sel: IFSelect_Selection, copy: bool) -> int: ...
	def RunTransformer(self, transf: IFSelect_Transformer) -> int: ...
	def Selection(self, id: int) -> IFSelect_Selection: ...
	def SelectionResult(self, sel: IFSelect_Selection) -> TColStd_HSequenceOfTransient: ...
	def SelectionResultFromList(self, sel: IFSelect_Selection, list: TColStd_HSequenceOfTransient) -> TColStd_HSequenceOfTransient: ...
	def SendAll(self, filename: str, computegraph: Optional[bool] = False) -> IFSelect_ReturnStatus: ...
	def SendSelected(self, filename: str, sel: IFSelect_Selection, computegraph: Optional[bool] = False) -> IFSelect_ReturnStatus: ...
	def SendSplit(self) -> bool: ...
	def SentFiles(self) -> TColStd_HSequenceOfHAsciiString: ...
	def SentList(self, count: Optional[int] = -1) -> Interface_EntityIterator: ...
	def SetActive(self, item: Standard_Transient, mode: bool) -> bool: ...
	def SetAppliedModifier(self, modif: IFSelect_GeneralModifier, item: Standard_Transient) -> bool: ...
	def SetControl(self, sel: IFSelect_Selection, sc: IFSelect_Selection, formain: Optional[bool] = True) -> bool: ...
	def SetDefaultFileRoot(self, name: str) -> bool: ...
	def SetErrorHandle(self, toHandle: bool) -> None: ...
	def SetFileExtension(self, name: str) -> None: ...
	def SetFilePrefix(self, name: str) -> None: ...
	def SetFileRoot(self, disp: IFSelect_Dispatch, name: str) -> bool: ...
	def SetInputSelection(self, sel: IFSelect_Selection, input: IFSelect_Selection) -> bool: ...
	def SetIntValue(self, it: IFSelect_IntParam, val: int) -> bool: ...
	def SetItemSelection(self, item: Standard_Transient, sel: IFSelect_Selection) -> bool: ...
	def SetLibrary(self, theLib: IFSelect_WorkLibrary) -> None: ...
	def SetLoadedFile(self, theFileName: str) -> None: ...
	def SetModeStat(self, theMode: bool) -> None: ...
	def SetModel(self, model: Interface_InterfaceModel, clearpointed: Optional[bool] = True) -> None: ...
	def SetModelContent(self, sel: IFSelect_Selection, keep: bool) -> bool: ...
	def SetModelCopier(self, copier: IFSelect_ModelCopier) -> None: ...
	def SetProtocol(self, protocol: Interface_Protocol) -> None: ...
	def SetRemaining(self, mode: IFSelect_RemainMode) -> bool: ...
	def SetSelectPointed(self, sel: IFSelect_Selection, list: TColStd_HSequenceOfTransient, mode: int) -> bool: ...
	def SetShareOut(self, shareout: IFSelect_ShareOut) -> None: ...
	def SetSignType(self, signtype: IFSelect_Signature) -> None: ...
	def SetTextValue(self, par: TCollection_HAsciiString, val: str) -> bool: ...
	def ShareOut(self) -> IFSelect_ShareOut: ...
	def Shareds(self, ent: Standard_Transient) -> TColStd_HSequenceOfTransient: ...
	def Sharings(self, ent: Standard_Transient) -> TColStd_HSequenceOfTransient: ...
	def SignCounter(self, id: int) -> IFSelect_SignCounter: ...
	def SignType(self) -> IFSelect_Signature: ...
	def SignValue(self, sign: IFSelect_Signature, ent: Standard_Transient) -> str: ...
	def Signature(self, id: int) -> IFSelect_Signature: ...
	def Source(self, sel: IFSelect_Selection, num: Optional[int] = 1) -> IFSelect_Selection: ...
	def Sources(self, sel: IFSelect_Selection) -> IFSelect_SelectionIterator: ...
	def StartingEntity(self, num: int) -> Standard_Transient: ...
	def StartingNumber(self, ent: Standard_Transient) -> int: ...
	def TextParam(self, id: int) -> TCollection_HAsciiString: ...
	def TextValue(self, par: TCollection_HAsciiString) -> TCollection_AsciiString: ...
	def ToggleSelectExtract(self, sel: IFSelect_Selection) -> bool: ...
	def TraceDumpEntity(self, ent: Standard_Transient, level: int) -> None: ...
	def TraceDumpModel(self, mode: int) -> None: ...
	def TraceStatics(self, use: int, mode: Optional[int] = 0) -> None: ...
	def Transformer(self, id: int) -> IFSelect_Transformer: ...
	def UsesAppliedModifier(self, modif: IFSelect_GeneralModifier) -> Standard_Transient: ...
	def ValidityName(self, ent: Standard_Transient) -> str: ...
	def WorkLibrary(self) -> IFSelect_WorkLibrary: ...
	@overload
	def WriteFile(self, filename: str) -> IFSelect_ReturnStatus: ...
	@overload
	def WriteFile(self, filename: str, sel: IFSelect_Selection) -> IFSelect_ReturnStatus: ...

class IFSelect_Act(IFSelect_Activator):
	def __init__(self, name: str, help: str, func: IFSelect_ActFunc) -> None: ...
	@staticmethod
	def AddFSet(name: str, help: str, func: IFSelect_ActFunc) -> None: ...
	@staticmethod
	def AddFunc(name: str, help: str, func: IFSelect_ActFunc) -> None: ...
	def Do(self, number: int, pilot: IFSelect_SessionPilot) -> IFSelect_ReturnStatus: ...
	def Help(self, number: int) -> str: ...
	@staticmethod
	def SetGroup(group: str, file: Optional[str] = "") -> None: ...

class IFSelect_BasicDumper(IFSelect_SessionDumper):
	def __init__(self) -> None: ...
	def ReadOwn(self, file: IFSelect_SessionFile, type: TCollection_AsciiString, item: Standard_Transient) -> bool: ...
	def WriteOwn(self, file: IFSelect_SessionFile, item: Standard_Transient) -> bool: ...

class IFSelect_CheckCounter(IFSelect_SignatureList):
	def __init__(self, withlist: Optional[bool] = False) -> None: ...
	def Analyse(self, list: Interface_CheckIterator, model: Interface_InterfaceModel, original: Optional[bool] = False, failsonly: Optional[bool] = False) -> None: ...
	def SetSignature(self, sign: MoniTool_SignText) -> None: ...
	def Signature(self) -> MoniTool_SignText: ...

class IFSelect_DispGlobal(IFSelect_Dispatch):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def LimitedMax(self, nbent: int) -> Tuple[bool, int]: ...

class IFSelect_DispPerCount(IFSelect_Dispatch):
	def __init__(self) -> None: ...
	def Count(self) -> IFSelect_IntParam: ...
	def CountValue(self) -> int: ...
	def Label(self) -> TCollection_AsciiString: ...
	def LimitedMax(self, nbent: int) -> Tuple[bool, int]: ...
	def SetCount(self, count: IFSelect_IntParam) -> None: ...

class IFSelect_DispPerFiles(IFSelect_Dispatch):
	def __init__(self) -> None: ...
	def Count(self) -> IFSelect_IntParam: ...
	def CountValue(self) -> int: ...
	def Label(self) -> TCollection_AsciiString: ...
	def LimitedMax(self, nbent: int) -> Tuple[bool, int]: ...
	def SetCount(self, count: IFSelect_IntParam) -> None: ...

class IFSelect_DispPerOne(IFSelect_Dispatch):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def LimitedMax(self, nbent: int) -> Tuple[bool, int]: ...

class IFSelect_DispPerSignature(IFSelect_Dispatch):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def LimitedMax(self, nbent: int) -> Tuple[bool, int]: ...
	def SetSignCounter(self, sign: IFSelect_SignCounter) -> None: ...
	def SignCounter(self) -> IFSelect_SignCounter: ...
	def SignName(self) -> str: ...

class IFSelect_Modifier(IFSelect_GeneralModifier):
	def Perform(self, ctx: IFSelect_ContextModif, target: Interface_InterfaceModel, protocol: Interface_Protocol, TC: Interface_CopyTool) -> None: ...

class IFSelect_ParamEditor(IFSelect_Editor):
	def __init__(self, nbmax: Optional[int] = 100, label: Optional[str] = "") -> None: ...
	def AddConstantText(self, val: str, shortname: str, completename: Optional[str] = "") -> None: ...
	def AddValue(self, val: Interface_TypedValue, shortname: Optional[str] = "") -> None: ...
	def Apply(self, form: IFSelect_EditForm, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def Label(self) -> TCollection_AsciiString: ...
	def Load(self, form: IFSelect_EditForm, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def Recognize(self, form: IFSelect_EditForm) -> bool: ...
	@staticmethod
	def StaticEditor(list: TColStd_HSequenceOfHAsciiString, label: Optional[str] = "") -> IFSelect_ParamEditor: ...
	def StringValue(self, form: IFSelect_EditForm, num: int) -> TCollection_HAsciiString: ...

class IFSelect_SelectBase(IFSelect_Selection):
	def FillIterator(self, iter: IFSelect_SelectionIterator) -> None: ...

class IFSelect_SelectCombine(IFSelect_Selection):
	def Add(self, sel: IFSelect_Selection, atnum: Optional[int] = 0) -> None: ...
	def FillIterator(self, iter: IFSelect_SelectionIterator) -> None: ...
	def Input(self, num: int) -> IFSelect_Selection: ...
	def InputRank(self, sel: IFSelect_Selection) -> int: ...
	def NbInputs(self) -> int: ...
	@overload
	def Remove(self, sel: IFSelect_Selection) -> bool: ...
	@overload
	def Remove(self, num: int) -> bool: ...

class IFSelect_SelectControl(IFSelect_Selection):
	def FillIterator(self, iter: IFSelect_SelectionIterator) -> None: ...
	def HasSecondInput(self) -> bool: ...
	def MainInput(self) -> IFSelect_Selection: ...
	def SecondInput(self) -> IFSelect_Selection: ...
	def SetMainInput(self, sel: IFSelect_Selection) -> None: ...
	def SetSecondInput(self, sel: IFSelect_Selection) -> None: ...

class IFSelect_SelectDeduct(IFSelect_Selection):
	def Alternate(self) -> IFSelect_SelectPointed: ...
	def FillIterator(self, iter: IFSelect_SelectionIterator) -> None: ...
	def HasAlternate(self) -> bool: ...
	def HasInput(self) -> bool: ...
	def Input(self) -> IFSelect_Selection: ...
	def InputResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def SetInput(self, sel: IFSelect_Selection) -> None: ...

class IFSelect_SessionPilot(IFSelect_Activator):
	def __init__(self, prompt: Optional[str] = "") -> None: ...
	def Arg(self, num: int) -> str: ...
	def Clear(self) -> None: ...
	def Command(self, num: int) -> TCollection_AsciiString: ...
	def CommandLine(self) -> TCollection_AsciiString: ...
	def CommandPart(self, numarg: Optional[int] = 0) -> str: ...
	def Do(self, number: int, session: IFSelect_SessionPilot) -> IFSelect_ReturnStatus: ...
	def Execute(self, command: TCollection_AsciiString) -> IFSelect_ReturnStatus: ...
	def ExecuteAlias(self, aliasname: TCollection_AsciiString) -> IFSelect_ReturnStatus: ...
	def ExecuteCounter(self, counter: IFSelect_SignCounter, numword: int, mode: Optional[IFSelect_PrintCount] = IFSelect_CountByItem) -> IFSelect_ReturnStatus: ...
	def Help(self, number: int) -> str: ...
	def Library(self) -> IFSelect_WorkLibrary: ...
	def NbCommands(self) -> int: ...
	def NbWords(self) -> int: ...
	def Number(self, val: str) -> int: ...
	def Perform(self) -> IFSelect_ReturnStatus: ...
	def ReadScript(self, file: Optional[str] = "") -> IFSelect_ReturnStatus: ...
	def RecordItem(self, item: Standard_Transient) -> IFSelect_ReturnStatus: ...
	def RecordMode(self) -> bool: ...
	def RecordedItem(self) -> Standard_Transient: ...
	def RemoveWord(self, num: int) -> bool: ...
	def Session(self) -> IFSelect_WorkSession: ...
	def SetCommandLine(self, command: TCollection_AsciiString) -> None: ...
	def SetLibrary(self, WL: IFSelect_WorkLibrary) -> None: ...
	def SetRecordMode(self, mode: bool) -> None: ...
	def SetSession(self, WS: IFSelect_WorkSession) -> None: ...
	def Word(self, num: int) -> TCollection_AsciiString: ...

class IFSelect_SignCategory(IFSelect_Signature):
	def __init__(self) -> None: ...
	def Value(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> str: ...

class IFSelect_SignCounter(IFSelect_SignatureList):
	@overload
	def __init__(self, withmap: Optional[bool] = True, withlist: Optional[bool] = False) -> None: ...
	@overload
	def __init__(self, matcher: IFSelect_Signature, withmap: Optional[bool] = True, withlist: Optional[bool] = False) -> None: ...
	def AddEntity(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def AddFromSelection(self, sel: IFSelect_Selection, G: Interface_Graph) -> None: ...
	def AddList(self, list: TColStd_HSequenceOfTransient, model: Interface_InterfaceModel) -> None: ...
	def AddModel(self, model: Interface_InterfaceModel) -> None: ...
	def AddSign(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> None: ...
	def AddWithGraph(self, list: TColStd_HSequenceOfTransient, graph: Interface_Graph) -> None: ...
	def ComputeSelected(self, G: Interface_Graph, forced: Optional[bool] = False) -> bool: ...
	def ComputedSign(self, ent: Standard_Transient, G: Interface_Graph) -> str: ...
	def SelMode(self) -> int: ...
	def Selection(self) -> IFSelect_Selection: ...
	def SetMap(self, withmap: bool) -> None: ...
	def SetSelMode(self, selmode: int) -> None: ...
	def SetSelection(self, sel: IFSelect_Selection) -> None: ...
	def Sign(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> TCollection_HAsciiString: ...
	def Signature(self) -> IFSelect_Signature: ...

class IFSelect_SignMultiple(IFSelect_Signature):
	def __init__(self, name: str) -> None: ...
	def Add(self, subsign: IFSelect_Signature, width: Optional[int] = 0, maxi: Optional[bool] = False) -> None: ...
	def Matches(self, ent: Standard_Transient, model: Interface_InterfaceModel, text: TCollection_AsciiString, exact: bool) -> bool: ...
	def Value(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> str: ...

class IFSelect_SignType(IFSelect_Signature):
	def __init__(self, nopk: Optional[bool] = False) -> None: ...
	def Value(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> str: ...

class IFSelect_SignValidity(IFSelect_Signature):
	def __init__(self) -> None: ...
	@staticmethod
	def CVal(ent: Standard_Transient, model: Interface_InterfaceModel) -> str: ...
	def Value(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> str: ...

class IFSelect_TransformStandard(IFSelect_Transformer):
	def __init__(self) -> None: ...
	def AddModifier(self, modif: IFSelect_Modifier, atnum: Optional[int] = 0) -> bool: ...
	def ApplyModifiers(self, G: Interface_Graph, protocol: Interface_Protocol, TC: Interface_CopyTool, checks: Interface_CheckIterator, newmod: Interface_InterfaceModel) -> bool: ...
	def Copy(self, G: Interface_Graph, TC: Interface_CopyTool, newmod: Interface_InterfaceModel) -> None: ...
	def CopyOption(self) -> bool: ...
	def Label(self) -> TCollection_AsciiString: ...
	def Modifier(self, num: int) -> IFSelect_Modifier: ...
	def ModifierRank(self, modif: IFSelect_Modifier) -> int: ...
	def NbModifiers(self) -> int: ...
	def OnTheSpot(self, G: Interface_Graph, TC: Interface_CopyTool, newmod: Interface_InterfaceModel) -> None: ...
	def Perform(self, G: Interface_Graph, protocol: Interface_Protocol, checks: Interface_CheckIterator, newmod: Interface_InterfaceModel) -> bool: ...
	@overload
	def RemoveModifier(self, modif: IFSelect_Modifier) -> bool: ...
	@overload
	def RemoveModifier(self, num: int) -> bool: ...
	def Selection(self) -> IFSelect_Selection: ...
	def SetCopyOption(self, option: bool) -> None: ...
	def SetSelection(self, sel: IFSelect_Selection) -> None: ...
	def StandardCopy(self, G: Interface_Graph, TC: Interface_CopyTool, newmod: Interface_InterfaceModel) -> None: ...
	def Updated(self, entfrom: Standard_Transient, entto: Standard_Transient) -> bool: ...

class IFSelect_GraphCounter(IFSelect_SignCounter):
	def __init__(self, withmap: Optional[bool] = True, withlist: Optional[bool] = False) -> None: ...
	def AddWithGraph(self, list: TColStd_HSequenceOfTransient, graph: Interface_Graph) -> None: ...
	def Applied(self) -> IFSelect_SelectDeduct: ...
	def SetApplied(self, sel: IFSelect_SelectDeduct) -> None: ...

class IFSelect_ModifEditForm(IFSelect_Modifier):
	def __init__(self, editform: IFSelect_EditForm) -> None: ...
	def EditForm(self) -> IFSelect_EditForm: ...
	def Label(self) -> TCollection_AsciiString: ...
	def Perform(self, ctx: IFSelect_ContextModif, target: Interface_InterfaceModel, protocol: Interface_Protocol, TC: Interface_CopyTool) -> None: ...

class IFSelect_ModifReorder(IFSelect_Modifier):
	def __init__(self, rootlast: Optional[bool] = True) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def Perform(self, ctx: IFSelect_ContextModif, target: Interface_InterfaceModel, protocol: Interface_Protocol, TC: Interface_CopyTool) -> None: ...

class IFSelect_SelectAnyList(IFSelect_SelectDeduct):
	def FillResult(self, n1: int, n2: int, ent: Standard_Transient, res: Interface_EntityIterator) -> None: ...
	def HasLower(self) -> bool: ...
	def HasUpper(self) -> bool: ...
	def KeepInputEntity(self, iter: Interface_EntityIterator) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def ListLabel(self) -> TCollection_AsciiString: ...
	def Lower(self) -> IFSelect_IntParam: ...
	def LowerValue(self) -> int: ...
	def NbItems(self, ent: Standard_Transient) -> int: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def SetFrom(self, rankfrom: IFSelect_IntParam) -> None: ...
	def SetOne(self, rank: IFSelect_IntParam) -> None: ...
	def SetRange(self, rankfrom: IFSelect_IntParam, rankto: IFSelect_IntParam) -> None: ...
	def SetUntil(self, rankto: IFSelect_IntParam) -> None: ...
	def Upper(self) -> IFSelect_IntParam: ...
	def UpperValue(self) -> int: ...

class IFSelect_SelectDiff(IFSelect_SelectControl):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectEntityNumber(IFSelect_SelectBase):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def Number(self) -> IFSelect_IntParam: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def SetNumber(self, num: IFSelect_IntParam) -> None: ...

class IFSelect_SelectExplore(IFSelect_SelectDeduct):
	def Explore(self, level: int, ent: Standard_Transient, G: Interface_Graph, explored: Interface_EntityIterator) -> bool: ...
	def ExploreLabel(self) -> TCollection_AsciiString: ...
	def Label(self) -> TCollection_AsciiString: ...
	def Level(self) -> int: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectExtract(IFSelect_SelectDeduct):
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def IsDirect(self) -> bool: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def SetDirect(self, direct: bool) -> None: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def SortInGraph(self, rank: int, ent: Standard_Transient, G: Interface_Graph) -> bool: ...

class IFSelect_SelectIntersection(IFSelect_SelectCombine):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectModelEntities(IFSelect_SelectBase):
	def __init__(self) -> None: ...
	def CompleteResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectModelRoots(IFSelect_SelectBase):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectPointed(IFSelect_SelectBase):
	def __init__(self) -> None: ...
	def Add(self, item: Standard_Transient) -> bool: ...
	def AddList(self, list: TColStd_HSequenceOfTransient) -> bool: ...
	def Clear(self) -> None: ...
	def IsSet(self) -> bool: ...
	def Item(self, num: int) -> Standard_Transient: ...
	def Label(self) -> TCollection_AsciiString: ...
	def NbItems(self) -> int: ...
	def Rank(self, item: Standard_Transient) -> int: ...
	def Remove(self, item: Standard_Transient) -> bool: ...
	def RemoveList(self, list: TColStd_HSequenceOfTransient) -> bool: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def SetEntity(self, item: Standard_Transient) -> None: ...
	def SetList(self, list: TColStd_HSequenceOfTransient) -> None: ...
	def Toggle(self, item: Standard_Transient) -> bool: ...
	def ToggleList(self, list: TColStd_HSequenceOfTransient) -> bool: ...
	@overload
	def Update(self, control: Interface_CopyControl) -> None: ...
	@overload
	def Update(self, trf: IFSelect_Transformer) -> None: ...

class IFSelect_SelectShared(IFSelect_SelectDeduct):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectSharing(IFSelect_SelectDeduct):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SelectSuite(IFSelect_SelectDeduct):
	def __init__(self) -> None: ...
	def AddInput(self, item: IFSelect_Selection) -> bool: ...
	def AddNext(self, item: IFSelect_SelectDeduct) -> None: ...
	def AddPrevious(self, item: IFSelect_SelectDeduct) -> None: ...
	def Item(self, num: int) -> IFSelect_SelectDeduct: ...
	def Label(self) -> TCollection_AsciiString: ...
	def NbItems(self) -> int: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def SetLabel(self, lab: str) -> None: ...

class IFSelect_SelectUnion(IFSelect_SelectCombine):
	def __init__(self) -> None: ...
	def Label(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...

class IFSelect_SignAncestor(IFSelect_SignType):
	def __init__(self, nopk: Optional[bool] = False) -> None: ...
	def Matches(self, ent: Standard_Transient, model: Interface_InterfaceModel, text: TCollection_AsciiString, exact: bool) -> bool: ...

class IFSelect_SelectAnyType(IFSelect_SelectExtract):
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def TypeForMatch(self) -> Standard_Type: ...

class IFSelect_SelectErrorEntities(IFSelect_SelectExtract):
	def __init__(self) -> None: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...

class IFSelect_SelectFlag(IFSelect_SelectExtract):
	def __init__(self, flagname: str) -> None: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def FlagName(self) -> str: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...

class IFSelect_SelectInList(IFSelect_SelectAnyList):
	def FillResult(self, n1: int, n2: int, ent: Standard_Transient, result: Interface_EntityIterator) -> None: ...
	def ListedEntity(self, num: int, ent: Standard_Transient) -> Standard_Transient: ...

class IFSelect_SelectRange(IFSelect_SelectExtract):
	def __init__(self) -> None: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def HasLower(self) -> bool: ...
	def HasUpper(self) -> bool: ...
	def Lower(self) -> IFSelect_IntParam: ...
	def LowerValue(self) -> int: ...
	def SetFrom(self, rankfrom: IFSelect_IntParam) -> None: ...
	def SetOne(self, rank: IFSelect_IntParam) -> None: ...
	def SetRange(self, rankfrom: IFSelect_IntParam, rankto: IFSelect_IntParam) -> None: ...
	def SetUntil(self, rankto: IFSelect_IntParam) -> None: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def Upper(self) -> IFSelect_IntParam: ...
	def UpperValue(self) -> int: ...

class IFSelect_SelectRootComps(IFSelect_SelectExtract):
	def __init__(self) -> None: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...

class IFSelect_SelectRoots(IFSelect_SelectExtract):
	def __init__(self) -> None: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...

class IFSelect_SelectSent(IFSelect_SelectExtract):
	def __init__(self, sentcount: Optional[int] = 1, atleast: Optional[bool] = True) -> None: ...
	def AtLeast(self) -> bool: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def RootResult(self, G: Interface_Graph) -> Interface_EntityIterator: ...
	def SentCount(self) -> int: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...

class IFSelect_SelectSignature(IFSelect_SelectExtract):
	@overload
	def __init__(self, matcher: IFSelect_Signature, signtext: str, exact: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, matcher: IFSelect_Signature, signtext: TCollection_AsciiString, exact: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, matcher: IFSelect_SignCounter, signtext: str, exact: Optional[bool] = True) -> None: ...
	def Counter(self) -> IFSelect_SignCounter: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def IsExact(self) -> bool: ...
	def Signature(self) -> IFSelect_Signature: ...
	def SignatureText(self) -> TCollection_AsciiString: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...
	def SortInGraph(self, rank: int, ent: Standard_Transient, G: Interface_Graph) -> bool: ...

class IFSelect_SelectSignedShared(IFSelect_SelectExplore):
	def __init__(self, matcher: IFSelect_Signature, signtext: str, exact: Optional[bool] = True, level: Optional[int] = 0) -> None: ...
	def Explore(self, level: int, ent: Standard_Transient, G: Interface_Graph, explored: Interface_EntityIterator) -> bool: ...
	def ExploreLabel(self) -> TCollection_AsciiString: ...
	def IsExact(self) -> bool: ...
	def Signature(self) -> IFSelect_Signature: ...
	def SignatureText(self) -> TCollection_AsciiString: ...

class IFSelect_SelectSignedSharing(IFSelect_SelectExplore):
	def __init__(self, matcher: IFSelect_Signature, signtext: str, exact: Optional[bool] = True, level: Optional[int] = 0) -> None: ...
	def Explore(self, level: int, ent: Standard_Transient, G: Interface_Graph, explored: Interface_EntityIterator) -> bool: ...
	def ExploreLabel(self) -> TCollection_AsciiString: ...
	def IsExact(self) -> bool: ...
	def Signature(self) -> IFSelect_Signature: ...
	def SignatureText(self) -> TCollection_AsciiString: ...

class IFSelect_SelectUnknownEntities(IFSelect_SelectExtract):
	def __init__(self) -> None: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def Sort(self, rank: int, ent: Standard_Transient, model: Interface_InterfaceModel) -> bool: ...

class IFSelect_SelectIncorrectEntities(IFSelect_SelectFlag):
	def __init__(self) -> None: ...

class IFSelect_SelectType(IFSelect_SelectAnyType):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, atype: Standard_Type) -> None: ...
	def ExtractLabel(self) -> TCollection_AsciiString: ...
	def SetType(self, atype: Standard_Type) -> None: ...
	def TypeForMatch(self) -> Standard_Type: ...

# harray1 classes
# harray2 classes
# hsequence classes

class IFSelect_HSeqOfSelection(IFSelect_TSeqOfSelection, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: IFSelect_TSeqOfSelection) -> None: ...
    def Sequence(self) -> IFSelect_TSeqOfSelection: ...
    def Append(self, theSequence: IFSelect_TSeqOfSelection) -> None: ...


ifselect_RestoreSession = ifselect.RestoreSession
ifselect_SaveSession = ifselect.SaveSession
IFSelect_Activator_Adding = IFSelect_Activator.Adding
IFSelect_Activator_Commands = IFSelect_Activator.Commands
IFSelect_Activator_Mode = IFSelect_Activator.Mode
IFSelect_Activator_Remove = IFSelect_Activator.Remove
IFSelect_Activator_Select = IFSelect_Activator.Select
IFSelect_Functions_GiveDispatch = IFSelect_Functions.GiveDispatch
IFSelect_Functions_GiveEntity = IFSelect_Functions.GiveEntity
IFSelect_Functions_GiveEntityNumber = IFSelect_Functions.GiveEntityNumber
IFSelect_Functions_GiveList = IFSelect_Functions.GiveList
IFSelect_Functions_Init = IFSelect_Functions.Init
IFSelect_SessionDumper_First = IFSelect_SessionDumper.First
IFSelect_Signature_IntValue = IFSelect_Signature.IntValue
IFSelect_Signature_MatchValue = IFSelect_Signature.MatchValue
IFSelect_Act_AddFSet = IFSelect_Act.AddFSet
IFSelect_Act_AddFunc = IFSelect_Act.AddFunc
IFSelect_Act_SetGroup = IFSelect_Act.SetGroup
IFSelect_ParamEditor_StaticEditor = IFSelect_ParamEditor.StaticEditor
IFSelect_SignValidity_CVal = IFSelect_SignValidity.CVal
