#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2020 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_firewall_ldbmonitor
short_description: Configure server load balancing health monitors.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.10"
author:
    - Link Zheng (@chillancezen)
    - Jie Xue (@JieX19)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    bypass_validation:
        description: only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters
        required: false
        type: bool
        default: false
    workspace_locking_adom:
        description: the adom to lock for FortiManager running in workspace mode, the value can be global and others including root
        required: false
        type: str
    workspace_locking_timeout:
        description: the maximum time in seconds to wait for other user to release the workspace lock
        required: false
        type: int
        default: 300
    state:
        description: the directive to create, update or delete an object
        type: str
        required: true
        choices:
          - present
          - absent
    rc_succeeded:
        description: the rc codes list with which the conditions to succeed will be overriden
        type: list
        required: false
    rc_failed:
        description: the rc codes list with which the conditions to fail will be overriden
        type: list
        required: false
    adom:
        description: the parameter (adom) in requested url
        type: str
        required: true
    firewall_ldbmonitor:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            http-get:
                type: str
                description: 'URL used to send a GET request to check the health of an HTTP server.'
            http-match:
                type: str
                description: 'String to match the value expected in response to an HTTP-GET request.'
            http-max-redirects:
                type: int
                description: 'The maximum number of HTTP redirects to be allowed (0 - 5, default = 0).'
            interval:
                type: int
                description: 'Time between health checks (5 - 65635 sec, default = 10).'
            name:
                type: str
                description: 'Monitor name.'
            port:
                type: int
                description: 'Service port used to perform the health check. If 0, health check monitor inherits port configured for the server (0 - 65635, ...'
            retry:
                type: int
                description: 'Number health check attempts before the server is considered down (1 - 255, default = 3).'
            timeout:
                type: int
                description: 'Time to wait to receive response to a health check from a server. Reaching the timeout means the health check failed (1 - 255 ...'
            type:
                type: str
                description: 'Select the Monitor type used by the health check monitor to check the health of the server (PING | TCP | HTTP).'
                choices:
                    - 'ping'
                    - 'tcp'
                    - 'http'
                    - 'passive-sip'

'''

EXAMPLES = '''
 - hosts: fortimanager-inventory
   collections:
     - fortinet.fortimanager
   connection: httpapi
   vars:
      ansible_httpapi_use_ssl: True
      ansible_httpapi_validate_certs: False
      ansible_httpapi_port: 443
   tasks:
    - name: Configure server load balancing health monitors.
      fmgr_firewall_ldbmonitor:
         bypass_validation: False
         workspace_locking_adom: <value in [global, custom adom including root]>
         workspace_locking_timeout: 300
         rc_succeeded: [0, -2, -3, ...]
         rc_failed: [-2, -3, ...]
         adom: <your own value>
         state: <value in [present, absent]>
         firewall_ldbmonitor:
            http-get: <value of string>
            http-match: <value of string>
            http-max-redirects: <value of integer>
            interval: <value of integer>
            name: <value of string>
            port: <value of integer>
            retry: <value of integer>
            timeout: <value of integer>
            type: <value in [ping, tcp, http, ...]>

'''

RETURN = '''
request_url:
    description: The full url requested
    returned: always
    type: str
    sample: /sys/login/user
response_code:
    description: The status of api request
    returned: always
    type: int
    sample: 0
response_message:
    description: The descriptive message of the api response
    type: str
    returned: always
    sample: OK.

'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/pm/config/adom/{adom}/obj/firewall/ldb-monitor',
        '/pm/config/global/obj/firewall/ldb-monitor'
    ]

    perobject_jrpc_urls = [
        '/pm/config/adom/{adom}/obj/firewall/ldb-monitor/{ldb-monitor}',
        '/pm/config/global/obj/firewall/ldb-monitor/{ldb-monitor}'
    ]

    url_params = ['adom']
    module_primary_key = 'name'
    module_arg_spec = {
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list'
        },
        'rc_failed': {
            'required': False,
            'type': 'list'
        },
        'state': {
            'type': 'str',
            'required': True,
            'choices': [
                'present',
                'absent'
            ]
        },
        'adom': {
            'required': True,
            'type': 'str'
        },
        'firewall_ldbmonitor': {
            'required': False,
            'type': 'dict',
            'options': {
                'http-get': {
                    'required': False,
                    'type': 'str'
                },
                'http-match': {
                    'required': False,
                    'type': 'str'
                },
                'http-max-redirects': {
                    'required': False,
                    'type': 'int'
                },
                'interval': {
                    'required': False,
                    'type': 'int'
                },
                'name': {
                    'required': True,
                    'type': 'str'
                },
                'port': {
                    'required': False,
                    'type': 'int'
                },
                'retry': {
                    'required': False,
                    'type': 'int'
                },
                'timeout': {
                    'required': False,
                    'type': 'int'
                },
                'type': {
                    'required': False,
                    'choices': [
                        'ping',
                        'tcp',
                        'http',
                        'passive-sip'
                    ],
                    'type': 'str'
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'firewall_ldbmonitor'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, module_primary_key, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_curd()
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
