/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.common.popup.JColorSelectorPopupMenu;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicColorSelectorComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorComponentUI;

public class JColorSelectorComponent
extends JComponent {
    private Color color;
    private List<JColorSelectorPopupMenu.ColorSelectorCallback> colorChooserCallbacks;
    private boolean isTopOpen;
    private boolean isBottomOpen;
    public static final String uiClassID = "ColorSelectorComponentUI";

    public JColorSelectorComponent(Color color, JColorSelectorPopupMenu.ColorSelectorCallback colorChooserCallback) {
        this.setOpaque(true);
        this.color = color;
        this.colorChooserCallbacks = new ArrayList<JColorSelectorPopupMenu.ColorSelectorCallback>();
        this.colorChooserCallbacks.add(colorChooserCallback);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((ColorSelectorComponentUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicColorSelectorComponentUI.createUI(this));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Color getColor() {
        return this.color;
    }

    public synchronized void addColorSelectorCallback(JColorSelectorPopupMenu.ColorSelectorCallback callback) {
        this.colorChooserCallbacks.add(callback);
    }

    public synchronized void onColorSelected(Color selected) {
        for (JColorSelectorPopupMenu.ColorSelectorCallback callback : this.colorChooserCallbacks) {
            callback.onColorSelected(selected);
        }
    }

    public synchronized void onColorRollover(Color rollover) {
        for (JColorSelectorPopupMenu.ColorSelectorCallback callback : this.colorChooserCallbacks) {
            callback.onColorRollover(rollover);
        }
    }

    public void setTopOpen(boolean isTopOpen) {
        this.isTopOpen = isTopOpen;
    }

    public void setBottomOpen(boolean isBottomOpen) {
        this.isBottomOpen = isBottomOpen;
    }

    public boolean isTopOpen() {
        return this.isTopOpen;
    }

    public boolean isBottomOpen() {
        return this.isBottomOpen;
    }
}

