/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gephi.desktop.preview.PreviewSketch;
import org.gephi.desktop.preview.api.PreviewUIController;
import org.gephi.desktop.preview.api.PreviewUIModel;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.ui.components.JColorButton;
import org.gephi.ui.utils.UIUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PreviewTopComponent", iconBase="org/gephi/desktop/preview/resources/preview.png", persistenceType=0)
public final class PreviewTopComponent
extends TopComponent
implements PropertyChangeListener {
    private transient PreviewUIModel model;
    private transient G2DTarget target;
    private transient PreviewSketch sketch;
    private JButton backgroundButton;
    private JLabel bannerLabel;
    private JPanel bannerPanel;
    private JLabel busyLabel;
    private JButton minusButton;
    private JButton plusButton;
    private JPanel previewPanel;
    private JButton refreshButton;
    private JPanel refreshPanel;
    private JButton resetZoomButton;
    private JPanel sketchPanel;
    private JLabel southBusyLabel;
    private JToolBar southToolbar;

    public PreviewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(PreviewTopComponent.class, (String)"CTL_PreviewTopComponent"));
        if (UIUtils.isAquaLookAndFeel()) {
            this.previewPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        if (UIUtils.isAquaLookAndFeel()) {
            this.southToolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.bannerPanel.setVisible(false);
        ((JColorButton)this.backgroundButton).addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
                previewController.getModel().getProperties().putValue("background-color", (Object)((Color)evt.getNewValue()));
                PreviewUIController previewUIController = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
                previewUIController.refreshPreview();
            }
        });
        this.southBusyLabel.setVisible(false);
        this.resetZoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTopComponent.this.sketch.resetZoom();
            }
        });
        this.plusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTopComponent.this.sketch.zoomPlus();
            }
        });
        this.minusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewTopComponent.this.sketch.zoomMinus();
            }
        });
        PreviewUIController controller = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        controller.addPropertyChangeListener(this);
        PreviewUIModel m = controller.getModel();
        if (m != null) {
            this.model = m;
            this.initTarget(this.model);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("select")) {
            this.model = (PreviewUIModel)evt.getNewValue();
            this.initTarget(this.model);
        } else if (evt.getPropertyName().equals("refreshed")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreviewTopComponent.this.target.refresh();
                }
            });
        } else if (evt.getPropertyName().equals("refreshing")) {
            this.setRefresh((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("graph_changed")) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.showBannerPanel();
            } else {
                this.hideBannerPanel();
            }
        }
    }

    public void setRefresh(final boolean refresh) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CardLayout cl = (CardLayout)PreviewTopComponent.this.previewPanel.getLayout();
                cl.show(PreviewTopComponent.this.previewPanel, refresh ? "refreshCard" : "previewCard");
                ((JXBusyLabel)PreviewTopComponent.this.busyLabel).setBusy(refresh);
            }
        });
    }

    protected Dimension getSketchDimensions() {
        int width = this.sketchPanel.getWidth();
        int height = this.sketchPanel.getHeight();
        if (width > 1 && height > 1) {
            if (PreviewTopComponent.isRetina()) {
                width = (int)((double)width * 2.0);
                height = (int)((double)height * 2.0);
            }
            return new Dimension(width, height);
        }
        return new Dimension(1, 1);
    }

    public void initTarget(PreviewUIModel previewUIModel) {
        if (previewUIModel != null && this.target == null) {
            PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
            PreviewModel previewModel = previewUIModel.getPreviewModel();
            Color background = previewModel.getProperties().getColorValue("background-color");
            if (background != null) {
                this.setBackgroundColor(background);
            }
            Dimension dimensions = this.getSketchDimensions();
            previewModel.getProperties().putValue("width", (Object)((int)dimensions.getWidth()));
            previewModel.getProperties().putValue("height", (Object)((int)dimensions.getHeight()));
            this.target = (G2DTarget)previewController.getRenderTarget("g2d");
            if (this.target != null) {
                this.sketch = new PreviewSketch(this.target);
                this.sketchPanel.add((Component)this.sketch, "Center");
            }
        } else if (previewUIModel == null) {
            this.sketchPanel.remove(this.sketch);
            this.target = null;
        }
    }

    public void showBannerPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreviewTopComponent.this.bannerPanel.setVisible(true);
            }
        });
    }

    public void setBackgroundColor(Color color) {
        ((JColorButton)this.backgroundButton).setColor(color);
    }

    public void hideBannerPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreviewTopComponent.this.bannerPanel.setVisible(false);
            }
        });
    }

    private void initComponents() {
        this.southBusyLabel = new JXBusyLabel(new Dimension(14, 14));
        this.bannerPanel = new JPanel();
        this.bannerLabel = new JLabel();
        this.refreshButton = new JButton();
        this.previewPanel = new JPanel();
        this.sketchPanel = new JPanel();
        this.refreshPanel = new JPanel();
        this.busyLabel = new JXBusyLabel(new Dimension(20, 20));
        this.southToolbar = new JToolBar();
        this.backgroundButton = new JColorButton(Color.WHITE);
        this.resetZoomButton = new JButton();
        this.minusButton = new JButton();
        this.plusButton = new JButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add(this.southBusyLabel, gridBagConstraints);
        this.bannerPanel.setBackground(new Color(178, 223, 240));
        this.bannerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        this.bannerPanel.setLayout(new GridBagLayout());
        this.bannerLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/preview/resources/info.png")));
        Mnemonics.setLocalizedText((JLabel)this.bannerLabel, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.bannerLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.bannerPanel.add((Component)this.bannerLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.refreshButton.text"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreviewTopComponent.this.refreshButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.bannerPanel.add((Component)this.refreshButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.add(this.bannerPanel, gridBagConstraints);
        this.previewPanel.setLayout(new CardLayout());
        this.sketchPanel.setBackground(new Color(255, 255, 255));
        this.sketchPanel.setPreferredSize(new Dimension(500, 500));
        this.sketchPanel.setLayout(new BorderLayout());
        this.previewPanel.add((Component)this.sketchPanel, "previewCard");
        this.refreshPanel.setOpaque(false);
        this.refreshPanel.setLayout(new GridBagLayout());
        this.busyLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.busyLabel, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.busyLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.refreshPanel.add((Component)this.busyLabel, gridBagConstraints);
        this.previewPanel.add((Component)this.refreshPanel, "refreshCard");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.previewPanel, gridBagConstraints);
        this.southToolbar.setFloatable(false);
        this.southToolbar.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.backgroundButton, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.backgroundButton.text"));
        this.backgroundButton.setFocusable(false);
        this.southToolbar.add(this.backgroundButton);
        Mnemonics.setLocalizedText((AbstractButton)this.resetZoomButton, (String)NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.resetZoomButton.text"));
        this.resetZoomButton.setFocusable(false);
        this.resetZoomButton.setHorizontalTextPosition(0);
        this.resetZoomButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.resetZoomButton);
        Mnemonics.setLocalizedText((AbstractButton)this.minusButton, (String)"-");
        this.minusButton.setToolTipText(NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.minusButton.toolTipText"));
        this.minusButton.setFocusable(false);
        this.minusButton.setHorizontalTextPosition(0);
        this.minusButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.minusButton);
        Mnemonics.setLocalizedText((AbstractButton)this.plusButton, (String)"+");
        this.plusButton.setToolTipText(NbBundle.getMessage(PreviewTopComponent.class, (String)"PreviewTopComponent.plusButton.toolTipText"));
        this.plusButton.setFocusable(false);
        this.plusButton.setHorizontalTextPosition(0);
        this.plusButton.setVerticalTextPosition(3);
        this.southToolbar.add(this.plusButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.southToolbar, gridBagConstraints);
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        ((PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class)).refreshPreview();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    protected static boolean isRetina() {
        boolean isRetina = false;
        try {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                Object scale = field.get(graphicsDevice);
                if (scale instanceof Integer && (Integer)scale == 2) {
                    isRetina = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isRetina;
    }
}

