/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tim.prune.I18nManager;
import tim.prune.config.ColourScheme;
import tim.prune.config.Config;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.profile.AltitudeData;
import tim.prune.gui.profile.ArbitraryData;
import tim.prune.gui.profile.ProfileData;
import tim.prune.gui.profile.SpeedData;
import tim.prune.gui.profile.VerticalSpeedData;

public class ProfileChart
extends GenericDisplay
implements MouseListener {
    private double _xScaleFactor = 0.0;
    private ProfileData _data = null;
    private JLabel _label = null;
    private JPopupMenu _popup = null;
    private ChartParameters _previousParameters = new ChartParameters();
    private static final int[] LINE_SCALES = new int[]{10000, 5000, 2000, 1000, 500, 200, 100, 50, 10, 5, 2, 1};
    private static final int BORDER_WIDTH = 6;
    private static final Dimension MINIMUM_SIZE = new Dimension(200, 110);
    private static final Color COLOR_NODATA_TEXT = Color.GRAY;

    public ProfileChart(TrackInfo trackInfo) {
        super(trackInfo);
        this._data = new AltitudeData(trackInfo.getTrack());
        this.addMouseListener(this);
        this.setLayout(new FlowLayout(0));
        this._label = new JLabel("Altitude");
        this.add(this._label);
        this.makePopup();
    }

    @Override
    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, Config.getConfigBoolean("prune.antialias") ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        ColourScheme colourScheme = Config.getColourScheme();
        this.paintBackground(graphics, colourScheme);
        if (this._track == null || this._track.getNumPoints() <= 0) {
            return;
        }
        this._label.setText(this._data.getLabel());
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Color color = colourScheme.getColour(1);
        Color color2 = colourScheme.getColour(2);
        Color color3 = colourScheme.getColour(4);
        Color color4 = colourScheme.getColour(5);
        Color color5 = colourScheme.getColour(7);
        if (!this._data.hasData()) {
            graphics.setColor(color5);
            graphics.drawString(I18nManager.getText(this._data.getNoDataKey()), 50, (n3 + this._label.getHeight()) / 2);
            this.paintChildren(graphics);
            return;
        }
        double d = this._data.getMinValue();
        double d2 = this._data.getMaxValue();
        if (d2 <= d) {
            d2 = d + 1.0;
            d -= 1.0;
        }
        int n4 = this._track.getNumPoints();
        this._xScaleFactor = 1.0 * (double)(n2 - 12 - 1) / (double)n4;
        int n5 = n3 - 12 - this._label.getHeight();
        double d3 = 1.0 * (double)n5 / (d2 - d);
        int n6 = (int)(this._xScaleFactor + 1.0);
        int n7 = this._trackInfo.getSelection().getCurrentPointIndex();
        int n8 = -1;
        int n9 = -1;
        if (this._trackInfo.getSelection().hasRangeSelected()) {
            n8 = this._trackInfo.getSelection().getStart();
            n9 = this._trackInfo.getSelection().getEnd();
        }
        int n10 = 0;
        double d4 = 0.0;
        int n11 = this.getLineScale(d, d2);
        double d5 = Math.ceil(d / (double)n11) * (double)n11;
        int n12 = n3 - 6 - (int)(d3 * (0.0 - d));
        graphics.setColor(color5);
        if (n11 >= 1) {
            while (d5 < d2) {
                n10 = n3 - 6 - (int)(d3 * (d5 - d));
                graphics.drawLine(7, n10, n2 - 6 - 1, n10);
                d5 += (double)n11;
            }
        } else if (d < 0.0) {
            n10 = n12;
            graphics.drawLine(7, n10, n2 - 6 - 1, n10);
        }
        try {
            graphics.setColor(color);
            n = 0;
            while (n < n4) {
                if (n == n8) {
                    graphics.setColor(color2);
                } else if (n == n9 + 1) {
                    graphics.setColor(color);
                }
                int n13 = (int)(this._xScaleFactor * (double)n) + 1;
                if (this._data.hasData(n)) {
                    d4 = this._data.getData(n);
                    if (d >= 0.0) {
                        n10 = (int)(d3 * (d4 - d));
                        graphics.fillRect(6 + n13, n3 - 6 - n10, n6, n10);
                    } else if (d4 >= 0.0) {
                        n10 = n3 - 6 - (int)(d3 * (d4 - d));
                        graphics.fillRect(6 + n13, n10, n6, n12 - n10);
                    } else {
                        int n14 = (int)(d3 * d4);
                        graphics.fillRect(6 + n13, n12, n6, -n14);
                    }
                }
                ++n;
            }
            if (n7 >= 0) {
                n = (int)(this._xScaleFactor * (double)n7) + 1;
                graphics.setColor(color4);
                graphics.fillRect(6 + n, n3 - n5 - 6 + 1, n6, n5 - 2);
                if (this._data.hasData(n7)) {
                    graphics.setColor(color3);
                    d4 = this._data.getData(n7);
                    n10 = (int)(d3 * (d4 - d));
                    graphics.fillRect(6 + n, n3 - 6 - n10, n6, n10);
                }
            }
        }
        catch (NullPointerException nullPointerException) {}
        if (n11 >= 1) {
            n = graphics.getFontMetrics().getHeight();
            d5 = (int)(d / (double)n11 + 1.0) * n11;
            if (d < 0.0) {
                d5 -= (double)n11;
            }
            n10 = 0;
            graphics.setColor(color3);
            while (d5 < d2) {
                n10 = n3 - 6 - (int)(d3 * (d5 - d));
                if (n10 < 6 + n) {
                    n10 = 6 + n;
                }
                graphics.drawString("" + (int)d5, 11, n10);
                d5 += (double)n11;
            }
        }
        this.paintChildren(graphics);
    }

    private void paintBackground(Graphics graphics, ColourScheme colourScheme) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = colourScheme.getColour(6);
        Color color2 = colourScheme.getColour(0);
        graphics.setColor(color2);
        graphics.fillRect(0, 0, n, n2);
        if (n < 12 || n2 < 12) {
            return;
        }
        if (this._track == null || this._track.getNumPoints() <= 0) {
            graphics.setColor(COLOR_NODATA_TEXT);
            graphics.drawString(I18nManager.getText("display.nodata"), 50, n2 / 2);
        } else {
            graphics.setColor(color);
            graphics.drawRect(6, 6 + this._label.getHeight(), n - 12, n2 - 12 - this._label.getHeight());
        }
    }

    private synchronized void makePopup() {
        if (this._track.getNumPoints() < 1) {
            this._popup = null;
            return;
        }
        this._popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("fieldname.altitude"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileChart.this.changeView(Field.ALTITUDE);
            }
        });
        this._popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("fieldname.speed"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileChart.this.changeView(Field.SPEED);
            }
        });
        this._popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("fieldname.verticalspeed"));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfileChart.this.changeView(Field.VERTICAL_SPEED);
            }
        });
        this._popup.add(jMenuItem3);
        boolean bl = true;
        FieldList fieldList = this._track.getFieldList();
        int n = 0;
        while (n < fieldList.getNumFields()) {
            Field field = fieldList.getField(n);
            if (!field.isBuiltIn()) {
                if (bl) {
                    this._popup.addSeparator();
                }
                bl = false;
                JMenuItem jMenuItem4 = new JMenuItem(field.getName());
                jMenuItem4.addActionListener(new MenuClicker(field));
                this._popup.add(jMenuItem4);
            }
            ++n;
        }
    }

    private int getLineScale(double d, double d2) {
        if (d2 - d < 2.0) {
            return -1;
        }
        int n = LINE_SCALES.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = LINE_SCALES[n2];
            int n4 = (int)(d2 / (double)n3) - (int)(d / (double)n3);
            if (n4 > 10) {
                return -1;
            }
            if (n4 > 1) {
                return n3;
            }
            ++n2;
        }
        return LINE_SCALES[n - 1];
    }

    @Override
    public void dataUpdated(byte by) {
        if (by != 4) {
            this._data.init(Config.getUnitSet());
            this._previousParameters.clear();
        }
        if ((by & 1) > 0) {
            this.makePopup();
        }
        ChartParameters chartParameters = new ChartParameters();
        chartParameters.selectedPoint.set(this._trackInfo.getSelection().getCurrentPointIndex());
        if (this._trackInfo.getSelection().hasRangeSelected()) {
            chartParameters.rangeStart.set(this._trackInfo.getSelection().getStart());
            chartParameters.rangeEnd.set(this._trackInfo.getSelection().getEnd());
        }
        if (by == 4) {
            this.triggerPartialRepaint(chartParameters);
        } else {
            this.repaint();
        }
        this._previousParameters = chartParameters;
    }

    private void triggerPartialRepaint(ChartParameters chartParameters) {
        int n = chartParameters.getMinChangedIndex(this._previousParameters);
        n = Math.max(n, 0);
        int n2 = chartParameters.getMaxChangedIndex(this._previousParameters);
        if (n2 < n) {
            n2 = this._trackInfo.getTrack().getNumPoints() - 1;
        }
        int n3 = (int)(this._xScaleFactor * (double)n) + 6 - 2;
        int n4 = (int)(this._xScaleFactor * (double)(n2 - n + 2)) + 6;
        this.repaint(n3, 0, n4, this.getHeight());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._track == null || this._track.getNumPoints() < 1) {
            return;
        }
        if (!mouseEvent.isMetaDown()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > 6 && n2 > 6 && n < this.getWidth() - 6 && n2 < this.getHeight() - 6) {
                int n3 = (int)((double)(mouseEvent.getX() - 6) / this._xScaleFactor);
                if (mouseEvent.isShiftDown()) {
                    this._trackInfo.extendSelection(n3);
                } else {
                    this._trackInfo.selectPoint(n3);
                }
            }
        } else if (this._popup != null) {
            this._popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void changeView(Field field) {
        if (field == Field.ALTITUDE) {
            if (!(this._data instanceof AltitudeData)) {
                this._data = new AltitudeData(this._track);
            }
        } else if (field == Field.SPEED) {
            if (!(this._data instanceof SpeedData)) {
                this._data = new SpeedData(this._track);
            }
        } else if (field == Field.VERTICAL_SPEED) {
            if (!(this._data instanceof VerticalSpeedData)) {
                this._data = new VerticalSpeedData(this._track);
            }
        } else if (!(this._data instanceof ArbitraryData) || ((ArbitraryData)this._data).getField() != field) {
            this._data = new ArbitraryData(this._track, field);
        }
        this._data.init(Config.getUnitSet());
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class ChartParameters {
        public PointIndex selectedPoint;
        public PointIndex rangeStart;
        public PointIndex rangeEnd;

        ChartParameters() {
            this.selectedPoint = new PointIndex();
            this.rangeStart = new PointIndex();
            this.rangeEnd = new PointIndex();
        }

        public void clear() {
            this.selectedPoint.hasValue = false;
            this.rangeStart.hasValue = false;
            this.rangeEnd.hasValue = false;
        }

        public int getMinChangedIndex(ChartParameters chartParameters) {
            PointIndex pointIndex = new PointIndex();
            if (!this.selectedPoint.equals(chartParameters.selectedPoint)) {
                pointIndex.setMin(this.selectedPoint);
                pointIndex.setMin(chartParameters.selectedPoint);
            }
            if (!this.rangeStart.equals(chartParameters.rangeStart)) {
                pointIndex.setMin(this.rangeStart);
                pointIndex.setMin(chartParameters.rangeStart);
            }
            if (!this.rangeEnd.equals(chartParameters.rangeEnd)) {
                pointIndex.setMin(this.rangeEnd);
                pointIndex.setMin(chartParameters.rangeEnd);
            }
            return pointIndex.index;
        }

        public int getMaxChangedIndex(ChartParameters chartParameters) {
            PointIndex pointIndex = new PointIndex();
            if (!this.selectedPoint.equals(chartParameters.selectedPoint)) {
                pointIndex.setMax(this.selectedPoint);
                pointIndex.setMax(chartParameters.selectedPoint);
            }
            if (!this.rangeStart.equals(chartParameters.rangeStart)) {
                pointIndex.setMax(this.rangeStart);
                pointIndex.setMax(chartParameters.rangeStart);
            }
            if (!this.rangeEnd.equals(chartParameters.rangeEnd)) {
                pointIndex.setMax(this.rangeEnd);
                pointIndex.setMax(chartParameters.rangeEnd);
            }
            return pointIndex.index;
        }

        public boolean isEmpty() {
            return !this.selectedPoint.hasValue && !this.rangeStart.hasValue && !this.rangeEnd.hasValue;
        }
    }

    class MenuClicker
    implements ActionListener {
        private Field _field = null;

        MenuClicker(Field field) {
            this._field = field;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProfileChart.this.changeView(this._field);
        }
    }

    class PointIndex {
        public int index = -1;
        public boolean hasValue = false;

        public void set(int n) {
            this.index = n;
            this.hasValue = n != -1;
        }

        public void setMin(PointIndex pointIndex) {
            if (!pointIndex.hasValue) {
                return;
            }
            if (!this.hasValue) {
                this.index = pointIndex.index;
                this.hasValue = true;
            } else {
                this.index = Math.min(this.index, pointIndex.index);
            }
        }

        public void setMax(PointIndex pointIndex) {
            if (!pointIndex.hasValue) {
                return;
            }
            if (!this.hasValue) {
                this.index = pointIndex.index;
                this.hasValue = true;
            } else {
                this.index = Math.max(this.index, pointIndex.index);
            }
        }

        public boolean equals(PointIndex pointIndex) {
            if (!this.hasValue || !pointIndex.hasValue) {
                return this.hasValue == pointIndex.hasValue;
            }
            return this.index == pointIndex.index;
        }
    }
}

