/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveKeywordRestArgInstr
extends ReceiveArgBase
implements FixedArityInstr {
    public final int required;

    public ReceiveKeywordRestArgInstr(Variable result2, int required) {
        super(Operation.RECV_KW_REST_ARG, result2, -1);
        this.required = required;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"req: " + this.required};
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        scope.setReceivesKeywordArgs();
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ReceiveKeywordRestArgInstr(ii.getRenamedVariable(this.result), this.required);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.required);
    }

    public static ReceiveKeywordRestArgInstr decode(IRReaderDecoder d) {
        return new ReceiveKeywordRestArgInstr(d.decodeVariable(), d.decodeInt());
    }

    @Override
    public IRubyObject receiveArg(ThreadContext context, IRubyObject[] args2, boolean keywordArgumentSupplied) {
        return IRRuntimeHelpers.receiveKeywordRestArg(context, args2, this.required, keywordArgumentSupplied);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveKeywordRestArgInstr(this);
    }
}

