/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class AmalgamateSubClassAxioms
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public AmalgamateSubClassAxioms(@Nonnull OWLDataFactory dataFactory, @Nonnull Set<OWLOntology> ontologies) {
        super(dataFactory);
        for (OWLOntology ont : OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null")) {
            for (OWLClass cls : ont.getClassesInSignature()) {
                assert (cls != null);
                Set<OWLSubClassOfAxiom> axioms = ont.getSubClassAxiomsForSubClass(cls);
                if (axioms.size() <= 1) continue;
                HashSet<OWLClassExpression> superClasses = new HashSet<OWLClassExpression>();
                for (OWLSubClassOfAxiom ax : axioms) {
                    assert (ax != null);
                    this.addChange(new RemoveAxiom(ont, ax));
                    superClasses.add(ax.getSuperClass());
                }
                OWLObjectIntersectionOf combinedSuperClass = this.getDataFactory().getOWLObjectIntersectionOf(superClasses);
                this.addChange(new AddAxiom(ont, this.getDataFactory().getOWLSubClassOfAxiom(cls, combinedSuperClass)));
            }
        }
    }
}

