
#ifndef KITEMMODELS_EXPORT_H
#define KITEMMODELS_EXPORT_H

#ifdef KITEMMODELS_STATIC_DEFINE
#  define KITEMMODELS_EXPORT
#  define KITEMMODELS_NO_EXPORT
#else
#  ifndef KITEMMODELS_EXPORT
#    ifdef KF5ItemModels_EXPORTS
        /* We are building this library */
#      define KITEMMODELS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KITEMMODELS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KITEMMODELS_NO_EXPORT
#    define KITEMMODELS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KITEMMODELS_DECL_DEPRECATED
#  define KITEMMODELS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KITEMMODELS_DECL_DEPRECATED_EXPORT
#  define KITEMMODELS_DECL_DEPRECATED_EXPORT KITEMMODELS_EXPORT KITEMMODELS_DECL_DEPRECATED
#endif

#ifndef KITEMMODELS_DECL_DEPRECATED_NO_EXPORT
#  define KITEMMODELS_DECL_DEPRECATED_NO_EXPORT KITEMMODELS_NO_EXPORT KITEMMODELS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KITEMMODELS_NO_DEPRECATED
#    define KITEMMODELS_NO_DEPRECATED
#  endif
#endif

#define KITEMMODELS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KITEMMODELS_NO_DEPRECATED) && !defined(KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KITEMMODELS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KITEMMODELS_NO_DEPRECATED_WARNINGS) && !defined(KITEMMODELS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KITEMMODELS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KITEMMODELS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KITEMMODELS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KITEMMODELS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KITEMMODELS_NO_DEPRECATED)
#  undef KITEMMODELS_DEPRECATED
#  define KITEMMODELS_DEPRECATED_EXPORT KITEMMODELS_EXPORT
#  define KITEMMODELS_DEPRECATED_NO_EXPORT KITEMMODELS_NO_EXPORT
#elif defined(KITEMMODELS_NO_DEPRECATED_WARNINGS)
#  define KITEMMODELS_DEPRECATED
#  define KITEMMODELS_DEPRECATED_EXPORT KITEMMODELS_EXPORT
#  define KITEMMODELS_DEPRECATED_NO_EXPORT KITEMMODELS_NO_EXPORT
#else
#  define KITEMMODELS_DEPRECATED KITEMMODELS_DECL_DEPRECATED
#  define KITEMMODELS_DEPRECATED_EXPORT KITEMMODELS_DECL_DEPRECATED_EXPORT
#  define KITEMMODELS_DEPRECATED_NO_EXPORT KITEMMODELS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KITEMMODELS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KITEMMODELS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KITEMMODELS_NO_DEPRECATED
#  define KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55200
#endif
#ifdef KITEMMODELS_NO_DEPRECATED_WARNINGS
#  define KITEMMODELS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KITEMMODELS_DEPRECATED_WARNINGS_SINCE
#  ifdef KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KITEMMODELS_DEPRECATED_WARNINGS_SINCE KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KITEMMODELS_DEPRECATED_WARNINGS_SINCE 0x55200
#  endif
#endif

#ifndef KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KITEMMODELS_DEPRECATED
#  define KITEMMODELS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KITEMMODELS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KITEMMODELS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KITEMMODELS_DEPRECATED_WARNINGS_SINCE >= 0x40800
#  define KITEMMODELS_DEPRECATED_VERSION_4_8(text) KITEMMODELS_DECL_DEPRECATED_TEXT(text)
#else
#  define KITEMMODELS_DEPRECATED_VERSION_4_8(text)
#endif

#if KITEMMODELS_DEPRECATED_WARNINGS_SINCE >= 0x54100
#  define KITEMMODELS_DEPRECATED_VERSION_5_65(text) KITEMMODELS_DECL_DEPRECATED_TEXT(text)
#else
#  define KITEMMODELS_DEPRECATED_VERSION_5_65(text)
#endif

#if KITEMMODELS_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KITEMMODELS_DEPRECATED_VERSION_5_80(text) KITEMMODELS_DECL_DEPRECATED_TEXT(text)
#else
#  define KITEMMODELS_DEPRECATED_VERSION_5_80(text)
#endif
#define KITEMMODELS_DEPRECATED_VERSION_4(minor, text)      KITEMMODELS_DEPRECATED_VERSION_4_##minor(text)
#define KITEMMODELS_DEPRECATED_VERSION_5(minor, text)      KITEMMODELS_DEPRECATED_VERSION_5_##minor(text)
#define KITEMMODELS_DEPRECATED_VERSION(major, minor, text) KITEMMODELS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KITEMMODELS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KITEMMODELS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KITEMMODELS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KITEMMODELS_DEPRECATED_VERSION(major, minor, text)
#  define KITEMMODELS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KITEMMODELS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KITEMMODELS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KITEMMODELS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KITEMMODELS_EXPORT_H */
