'''OpenGL extension EXT.sRGB

This module customises the behaviour of the 
OpenGL.raw.GLES1.EXT.sRGB to provide a more 
Python-friendly API

Overview (from the spec)
	
	The sRGB color space is based on typical (non-linear) response of the human
	eye.  It has been standardized by the International Electrotechnical 
	Commission (IEC) as IEC 61966-2-1.  The transfer function of sRGB roughly
	corresponds to a power function with a gamma of 2.2.
	
	FRAMEBUFFERS
	
	OpenGL assumes framebuffer color components are stored in a linear color
	space.  In particular, framebuffer blending is a linear operation.
	
	This extension adds a framebuffer capability for sRGB framebuffer update
	and blending.  When blending is disabled but the new sRGB updated mode is
	enabled (assume the framebuffer supports the capability), high-precision 
	linear color component values for red, green, and blue generated by
	fragment coloring are encoded for sRGB prior to being written into the
	framebuffer.  When blending is enabled along with the new sRGB update mode,
	red, green, and blue framebuffer color components are treated as sRGB
	values that are converted to linear color values, blended with the high-
	precision color values generated by fragment coloring, and then the blend
	result is encoded for sRGB just prior to being written into the 
	framebuffer.
	
	TEXTURES
	
	Conventional texture formats assume a linear color space.  So for a 
	conventional internal texture format such as GL_RGB8, the 256 discrete
	values for each 8-bit color component map linearly and uniformly to the
	[0,1] range.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/sRGB.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.EXT.sRGB import *
from OpenGL.raw.GLES1.EXT.sRGB import _EXTENSION_NAME

def glInitSrgbEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION