/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.File;
import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.realm.DataSourceRealm;
import org.apache.catalina.realm.JDBCRealm;
import org.apache.catalina.realm.JNDIRealm;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.UserDatabaseRealm;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MBeanFactory {
    private static final Log log = LogFactory.getLog(MBeanFactory.class);
    private static MBeanServer mserver = MBeanUtils.createServer();
    private Object container;

    public void setContainer(Object object) {
        this.container = object;
    }

    @Deprecated
    public String findObjectName(String string) {
        if (string.equals("org.apache.catalina.core.StandardContext")) {
            return "StandardContext";
        }
        if (string.equals("org.apache.catalina.core.StandardEngine")) {
            return "Engine";
        }
        if (string.equals("org.apache.catalina.core.StandardHost")) {
            return "Host";
        }
        return null;
    }

    private final String getPathStr(String string) {
        if (string == null || string.equals("/")) {
            return "";
        }
        return string;
    }

    private ContainerBase getParentContainerFromParent(ObjectName objectName) throws Exception {
        String string = objectName.getKeyProperty("type");
        String string2 = objectName.getKeyProperty("j2eeType");
        Service service = this.getService(objectName);
        StandardEngine standardEngine = (StandardEngine)service.getContainer();
        if (string2 != null && string2.equals("WebModule")) {
            String string3 = objectName.getKeyProperty("name");
            string3 = string3.substring(2);
            int n = string3.indexOf(47);
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n);
            Host host = (Host)standardEngine.findChild(string4);
            String string6 = this.getPathStr(string5);
            StandardContext standardContext = (StandardContext)host.findChild(string6);
            return standardContext;
        }
        if (string != null) {
            if (string.equals("Engine")) {
                return standardEngine;
            }
            if (string.equals("Host")) {
                String string7 = objectName.getKeyProperty("host");
                StandardHost standardHost = (StandardHost)standardEngine.findChild(string7);
                return standardHost;
            }
        }
        return null;
    }

    private ContainerBase getParentContainerFromChild(ObjectName objectName) throws Exception {
        String string = objectName.getKeyProperty("host");
        String string2 = objectName.getKeyProperty("path");
        Service service = this.getService(objectName);
        StandardEngine standardEngine = (StandardEngine)service.getContainer();
        if (string == null) {
            return standardEngine;
        }
        if (string2 == null) {
            StandardHost standardHost = (StandardHost)standardEngine.findChild(string);
            return standardHost;
        }
        StandardHost standardHost = (StandardHost)standardEngine.findChild(string);
        string2 = this.getPathStr(string2);
        StandardContext standardContext = (StandardContext)standardHost.findChild(string2);
        return standardContext;
    }

    private Service getService(ObjectName objectName) throws Exception {
        if (this.container instanceof Service) {
            return (Service)this.container;
        }
        LifecycleMBeanBase lifecycleMBeanBase = null;
        String string = objectName.getDomain();
        if (this.container instanceof Server) {
            Service service;
            Service[] serviceArray;
            Service[] serviceArray2 = serviceArray = ((Server)this.container).findServices();
            int n = serviceArray2.length;
            for (int i = 0; i < n && !string.equals((lifecycleMBeanBase = (StandardService)(service = serviceArray2[i])).getObjectName().getDomain()); ++i) {
            }
        }
        if (lifecycleMBeanBase == null || !lifecycleMBeanBase.getObjectName().getDomain().equals(string)) {
            throw new Exception("Service with the domain is not found");
        }
        return lifecycleMBeanBase;
    }

    @Deprecated
    public String createAccessLoggerValve(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        AccessLogValve accessLogValve = new AccessLogValve();
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.getPipeline().addValve(accessLogValve);
        ObjectName objectName2 = accessLogValve.getObjectName();
        return objectName2.toString();
    }

    public String createAjpConnector(String string, String string2, int n) throws Exception {
        return this.createConnector(string, string2, n, true, false);
    }

    public String createDataSourceRealm(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        DataSourceRealm dataSourceRealm = new DataSourceRealm();
        dataSourceRealm.setDataSourceName(string2);
        dataSourceRealm.setRoleNameCol(string3);
        dataSourceRealm.setUserCredCol(string4);
        dataSourceRealm.setUserNameCol(string5);
        dataSourceRealm.setUserRoleTable(string6);
        dataSourceRealm.setUserTable(string7);
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.setRealm(dataSourceRealm);
        ObjectName objectName2 = dataSourceRealm.getObjectName();
        if (objectName2 != null) {
            return objectName2.toString();
        }
        return null;
    }

    public String createHttpConnector(String string, String string2, int n) throws Exception {
        return this.createConnector(string, string2, n, false, false);
    }

    private String createConnector(String string, String string2, int n, boolean bl, boolean bl2) throws Exception {
        Connector connector = new Connector();
        if (string2 != null && string2.length() > 0) {
            connector.setProperty("address", string2);
        }
        connector.setPort(n);
        connector.setProtocol(bl ? "AJP/1.3" : "HTTP/1.1");
        connector.setSecure(bl2);
        connector.setScheme(bl2 ? "https" : "http");
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        service.addConnector(connector);
        ObjectName objectName2 = connector.getObjectName();
        return objectName2.toString();
    }

    public String createHttpsConnector(String string, String string2, int n) throws Exception {
        return this.createConnector(string, string2, n, false, true);
    }

    @Deprecated
    public String createJDBCRealm(String string, String string2, String string3, String string4, String string5) throws Exception {
        JDBCRealm jDBCRealm = new JDBCRealm();
        jDBCRealm.setDriverName(string2);
        jDBCRealm.setConnectionName(string3);
        jDBCRealm.setConnectionPassword(string4);
        jDBCRealm.setConnectionURL(string5);
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.setRealm(jDBCRealm);
        ObjectName objectName2 = jDBCRealm.getObjectName();
        if (objectName2 != null) {
            return objectName2.toString();
        }
        return null;
    }

    public String createJNDIRealm(String string) throws Exception {
        JNDIRealm jNDIRealm = new JNDIRealm();
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.setRealm(jNDIRealm);
        ObjectName objectName2 = jNDIRealm.getObjectName();
        if (objectName2 != null) {
            return objectName2.toString();
        }
        return null;
    }

    public String createMemoryRealm(String string) throws Exception {
        MemoryRealm memoryRealm = new MemoryRealm();
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.setRealm(memoryRealm);
        ObjectName objectName2 = memoryRealm.getObjectName();
        if (objectName2 != null) {
            return objectName2.toString();
        }
        return null;
    }

    @Deprecated
    public String createRemoteAddrValve(String string) throws Exception {
        RemoteAddrValve remoteAddrValve = new RemoteAddrValve();
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.getPipeline().addValve(remoteAddrValve);
        ObjectName objectName2 = remoteAddrValve.getObjectName();
        return objectName2.toString();
    }

    @Deprecated
    public String createRemoteHostValve(String string) throws Exception {
        RemoteHostValve remoteHostValve = new RemoteHostValve();
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.getPipeline().addValve(remoteHostValve);
        ObjectName objectName2 = remoteHostValve.getObjectName();
        return objectName2.toString();
    }

    @Deprecated
    public String createSingleSignOn(String string) throws Exception {
        SingleSignOn singleSignOn = new SingleSignOn();
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.getPipeline().addValve(singleSignOn);
        ObjectName objectName2 = singleSignOn.getObjectName();
        return objectName2.toString();
    }

    public String createStandardContext(String string, String string2, String string3) throws Exception {
        return this.createStandardContext(string, string2, string3, false, false, false, false);
    }

    public String createStandardContext(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        StandardContext standardContext = new StandardContext();
        string2 = this.getPathStr(string2);
        standardContext.setPath(string2);
        standardContext.setDocBase(string3);
        standardContext.setXmlValidation(bl);
        standardContext.setXmlNamespaceAware(bl2);
        standardContext.setTldValidation(bl3);
        standardContext.setTldNamespaceAware(bl4);
        ContextConfig contextConfig = new ContextConfig();
        standardContext.addLifecycleListener(contextConfig);
        ObjectName objectName = new ObjectName(string);
        ObjectName objectName2 = new ObjectName(objectName.getDomain() + ":type=Deployer,host=" + objectName.getKeyProperty("host"));
        if (mserver.isRegistered(objectName2)) {
            String string4 = standardContext.getName();
            mserver.invoke(objectName2, "addServiced", new Object[]{string4}, new String[]{"java.lang.String"});
            String string5 = (String)mserver.getAttribute(objectName2, "configBaseName");
            String string6 = standardContext.getBaseName();
            File file = new File(new File(string5), string6 + ".xml");
            if (file.isFile()) {
                standardContext.setConfigFile(file.toURI().toURL());
            }
            mserver.invoke(objectName2, "manageApp", new Object[]{standardContext}, new String[]{"org.apache.catalina.Context"});
            mserver.invoke(objectName2, "removeServiced", new Object[]{string4}, new String[]{"java.lang.String"});
        } else {
            log.warn((Object)("Deployer not found for " + objectName.getKeyProperty("host")));
            Service service = this.getService(objectName);
            Engine engine = (Engine)service.getContainer();
            Host host = (Host)engine.findChild(objectName.getKeyProperty("host"));
            host.addChild(standardContext);
        }
        return standardContext.getObjectName().toString();
    }

    public String createStandardHost(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        StandardHost standardHost = new StandardHost();
        standardHost.setName(string2);
        standardHost.setAppBase(string3);
        standardHost.setAutoDeploy(bl);
        standardHost.setDeployOnStartup(bl2);
        standardHost.setDeployXML(bl3);
        standardHost.setUnpackWARs(bl4);
        HostConfig hostConfig = new HostConfig();
        standardHost.addLifecycleListener(hostConfig);
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        Engine engine = (Engine)service.getContainer();
        engine.addChild(standardHost);
        return standardHost.getObjectName().toString();
    }

    public String createStandardServiceEngine(String string, String string2, String string3) throws Exception {
        if (!(this.container instanceof Server)) {
            throw new Exception("Container not Server");
        }
        StandardEngine standardEngine = new StandardEngine();
        standardEngine.setDomain(string);
        standardEngine.setName(string);
        standardEngine.setDefaultHost(string2);
        standardEngine.setBaseDir(string3);
        StandardService standardService = new StandardService();
        standardService.setContainer(standardEngine);
        standardService.setName(string);
        ((Server)this.container).addService(standardService);
        return standardEngine.getObjectName().toString();
    }

    public String createStandardManager(String string) throws Exception {
        ObjectName objectName;
        StandardManager standardManager = new StandardManager();
        ObjectName objectName2 = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName2);
        if (containerBase != null) {
            containerBase.setManager(standardManager);
        }
        if ((objectName = standardManager.getObjectName()) != null) {
            return objectName.toString();
        }
        return null;
    }

    public String createUserDatabaseRealm(String string, String string2) throws Exception {
        UserDatabaseRealm userDatabaseRealm = new UserDatabaseRealm();
        userDatabaseRealm.setResourceName(string2);
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        containerBase.setRealm(userDatabaseRealm);
        ObjectName objectName2 = userDatabaseRealm.getObjectName();
        if (objectName2 != null) {
            return objectName2.toString();
        }
        return null;
    }

    public String createValve(String string, String string2) throws Exception {
        ObjectName objectName = new ObjectName(string2);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        if (containerBase == null) {
            throw new IllegalArgumentException();
        }
        Valve valve = (Valve)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        containerBase.getPipeline().addValve(valve);
        if (valve instanceof JmxEnabled) {
            return ((JmxEnabled)((Object)valve)).getObjectName().toString();
        }
        return null;
    }

    public String createWebappLoader(String string) throws Exception {
        WebappLoader webappLoader = new WebappLoader();
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromParent(objectName);
        if (containerBase != null) {
            containerBase.setLoader(webappLoader);
        }
        ObjectName objectName2 = MBeanUtils.createObjectName(objectName.getDomain(), webappLoader);
        return objectName2.toString();
    }

    public void removeConnector(String string) throws Exception {
        Connector[] connectorArray;
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        String string2 = objectName.getKeyProperty("port");
        String string3 = objectName.getKeyProperty("address");
        if (string3 != null) {
            string3 = ObjectName.unquote(string3);
        }
        for (Connector connector : connectorArray = service.findConnectors()) {
            String string4 = null;
            Object object = connector.getProperty("address");
            if (object != null) {
                string4 = ((InetAddress)object).getHostAddress();
            }
            String string5 = "" + connector.getPort();
            if (string3 == null) {
                if (string4 != null || !string2.equals(string5)) continue;
                service.removeConnector(connector);
                connector.destroy();
                break;
            }
            if (!string3.equals(string4) || !string2.equals(string5)) continue;
            service.removeConnector(connector);
            connector.destroy();
            break;
        }
    }

    public void removeContext(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        String string2 = objectName.getDomain();
        StandardService standardService = (StandardService)this.getService(objectName);
        Engine engine = (Engine)standardService.getContainer();
        String string3 = objectName.getKeyProperty("name");
        string3 = string3.substring(2);
        int n = string3.indexOf(47);
        String string4 = string3.substring(0, n);
        String string5 = string3.substring(n);
        ObjectName objectName2 = new ObjectName(string2 + ":type=Deployer,host=" + string4);
        String string6 = this.getPathStr(string5);
        if (mserver.isRegistered(objectName2)) {
            mserver.invoke(objectName2, "addServiced", new Object[]{string6}, new String[]{"java.lang.String"});
            mserver.invoke(objectName2, "unmanageApp", new Object[]{string6}, new String[]{"java.lang.String"});
            mserver.invoke(objectName2, "removeServiced", new Object[]{string6}, new String[]{"java.lang.String"});
        } else {
            log.warn((Object)("Deployer not found for " + string4));
            Host host = (Host)engine.findChild(string4);
            Context context = (Context)host.findChild(string6);
            host.removeChild(context);
            if (context instanceof StandardContext) {
                try {
                    ((StandardContext)context).destroy();
                }
                catch (Exception exception) {
                    log.warn((Object)("Error during context [" + context.getName() + "] destroy "), (Throwable)exception);
                }
            }
        }
    }

    public void removeHost(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        String string2 = objectName.getKeyProperty("host");
        Service service = this.getService(objectName);
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(string2);
        if (host != null) {
            engine.removeChild(host);
        }
    }

    public void removeLoader(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromChild(objectName);
        containerBase.setLoader(null);
    }

    public void removeManager(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromChild(objectName);
        containerBase.setManager(null);
    }

    public void removeRealm(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromChild(objectName);
        containerBase.setRealm(null);
    }

    public void removeService(String string) throws Exception {
        if (!(this.container instanceof Server)) {
            throw new Exception();
        }
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        ((Server)this.container).removeService(service);
    }

    public void removeValve(String string) throws Exception {
        Valve[] valveArray;
        ObjectName objectName = new ObjectName(string);
        ContainerBase containerBase = this.getParentContainerFromChild(objectName);
        for (Valve valve : valveArray = containerBase.getPipeline().getValves()) {
            ObjectName objectName2 = ((JmxEnabled)((Object)valve)).getObjectName();
            if (!objectName2.equals(objectName)) continue;
            containerBase.getPipeline().removeValve(valve);
        }
    }
}

