/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.dbcp.pool2.impl.CallStack;

public class SecurityManagerCallStack
implements CallStack {
    private final String messageFormat;
    private final DateFormat dateFormat;
    private final PrivateSecurityManager securityManager;
    private volatile Snapshot snapshot;

    public SecurityManagerCallStack(String string, boolean bl) {
        this.messageFormat = string;
        this.dateFormat = bl ? new SimpleDateFormat(string) : null;
        this.securityManager = AccessController.doPrivileged(new PrivilegedAction<PrivateSecurityManager>(){

            @Override
            public PrivateSecurityManager run() {
                return new PrivateSecurityManager();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean printStackTrace(PrintWriter printWriter) {
        String string;
        Snapshot snapshot = this.snapshot;
        if (snapshot == null) {
            return false;
        }
        if (this.dateFormat == null) {
            string = this.messageFormat;
        } else {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                string = this.dateFormat.format(snapshot.timestamp);
            }
        }
        printWriter.println(string);
        for (WeakReference weakReference : snapshot.stack) {
            printWriter.println(weakReference.get());
        }
        return true;
    }

    @Override
    public void fillInStackTrace() {
        this.snapshot = new Snapshot(this.securityManager.getCallStack());
    }

    @Override
    public void clear() {
        this.snapshot = null;
    }

    private static class Snapshot {
        private final long timestamp = System.currentTimeMillis();
        private final List<WeakReference<Class<?>>> stack;

        private Snapshot(List<WeakReference<Class<?>>> list) {
            this.stack = list;
        }
    }

    private static class PrivateSecurityManager
    extends SecurityManager {
        private PrivateSecurityManager() {
        }

        private List<WeakReference<Class<?>>> getCallStack() {
            Class<?>[] classArray = this.getClassContext();
            ArrayList arrayList = new ArrayList(classArray.length);
            for (Class<?> clazz : classArray) {
                arrayList.add(new WeakReference(clazz));
            }
            return arrayList;
        }
    }
}

