/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Flags;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Setting;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.res.StringManager;

class Http2Parser {
    private static final Log log = LogFactory.getLog(Http2Parser.class);
    private static final StringManager sm = StringManager.getManager(Http2Parser.class);
    static final byte[] CLIENT_PREFACE_START = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private final String connectionId;
    private final Input input;
    private final Output output;
    private final byte[] frameHeaderBuffer = new byte[9];
    private volatile HpackDecoder hpackDecoder;
    private volatile ByteBuffer headerReadBuffer = ByteBuffer.allocate(1024);
    private volatile int headersCurrentStream = -1;
    private volatile boolean headersEndStream = false;

    Http2Parser(String string, Input input, Output output) {
        this.connectionId = string;
        this.input = input;
        this.output = output;
    }

    boolean readFrame(boolean bl) throws Http2Exception, IOException {
        return this.readFrame(bl, null);
    }

    private boolean readFrame(boolean bl, FrameType frameType) throws IOException, Http2Exception {
        if (!this.input.fill(bl, this.frameHeaderBuffer)) {
            return false;
        }
        int n = ByteUtil.getThreeBytes(this.frameHeaderBuffer, 0);
        int n2 = ByteUtil.getOneByte(this.frameHeaderBuffer, 3);
        FrameType frameType2 = FrameType.valueOf(n2);
        int n3 = ByteUtil.getOneByte(this.frameHeaderBuffer, 4);
        int n4 = ByteUtil.get31Bits(this.frameHeaderBuffer, 5);
        try {
            this.validateFrame(frameType, frameType2, n4, n3, n);
        }
        catch (StreamException streamException) {
            this.swallowPayload(n4, n2, n, false);
            throw streamException;
        }
        switch (frameType2) {
            case DATA: {
                this.readDataFrame(n4, n3, n);
                break;
            }
            case HEADERS: {
                this.readHeadersFrame(n4, n3, n);
                break;
            }
            case PRIORITY: {
                this.readPriorityFrame(n4);
                break;
            }
            case RST: {
                this.readRstFrame(n4);
                break;
            }
            case SETTINGS: {
                this.readSettingsFrame(n3, n);
                break;
            }
            case PUSH_PROMISE: {
                this.readPushPromiseFrame(n4);
                break;
            }
            case PING: {
                this.readPingFrame(n3);
                break;
            }
            case GOAWAY: {
                this.readGoawayFrame(n);
                break;
            }
            case WINDOW_UPDATE: {
                this.readWindowUpdateFrame(n4);
                break;
            }
            case CONTINUATION: {
                this.readContinuationFrame(n4, n3, n);
                break;
            }
            case UNKNOWN: {
                this.readUnknownFrame(n4, n2, n3, n);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDataFrame(int n, int n2, int n3) throws Http2Exception, IOException {
        int n4;
        Object object;
        int n5 = 0;
        boolean bl = Flags.isEndOfStream(n2);
        if (Flags.hasPadding(n2)) {
            object = new byte[1];
            this.input.fill(true, (byte[])object);
            n5 = object[0] & 0xFF;
            if (n5 >= n3) {
                throw new ConnectionException(sm.getString("http2Parser.processFrame.tooMuchPadding", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n5), Integer.toString(n3)}), Http2Error.PROTOCOL_ERROR);
            }
            n4 = n3 - (n5 + 1);
        } else {
            n4 = n3;
        }
        if (log.isDebugEnabled()) {
            object = Flags.hasPadding(n2) ? (Object)Integer.toString(n5) : (Object)"none";
            log.debug((Object)sm.getString("http2Parser.processFrameData.lengths", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n4), object}));
        }
        if ((object = (Object)this.output.startRequestBodyFrame(n, n3, bl)) == null) {
            this.swallowPayload(n, FrameType.DATA.getId(), n4, false);
            if (Flags.hasPadding(n2)) {
                this.swallowPayload(n, FrameType.DATA.getId(), n5, true);
            }
            if (bl) {
                this.output.receivedEndOfStream(n);
            }
        } else {
            Object object2 = object;
            synchronized (object2) {
                if (((Buffer)object).remaining() < n3) {
                    this.swallowPayload(n, FrameType.DATA.getId(), n4, false);
                    if (Flags.hasPadding(n2)) {
                        this.swallowPayload(n, FrameType.DATA.getId(), n5, true);
                    }
                    throw new StreamException(sm.getString("http2Parser.processFrameData.window", new Object[]{this.connectionId}), Http2Error.FLOW_CONTROL_ERROR, n);
                }
                this.input.fill(true, (ByteBuffer)object, n4);
                if (Flags.hasPadding(n2)) {
                    this.swallowPayload(n, FrameType.DATA.getId(), n5, true);
                }
                if (bl) {
                    this.output.receivedEndOfStream(n);
                }
                this.output.endRequestBodyFrame(n, n4);
            }
        }
    }

    private void readHeadersFrame(int n, int n2, int n3) throws Http2Exception, IOException {
        this.headersEndStream = Flags.isEndOfStream(n2);
        if (this.hpackDecoder == null) {
            this.hpackDecoder = this.output.getHpackDecoder();
        }
        try {
            this.hpackDecoder.setHeaderEmitter(this.output.headersStart(n, this.headersEndStream));
        }
        catch (StreamException streamException) {
            this.swallowPayload(n, FrameType.HEADERS.getId(), n3, false);
            throw streamException;
        }
        int n4 = 0;
        boolean bl = Flags.hasPadding(n2);
        boolean bl2 = Flags.hasPriority(n2);
        int n5 = 0;
        if (bl) {
            n5 = 1;
        }
        if (bl2) {
            n5 += 5;
        }
        if (n5 > 0) {
            byte[] byArray = new byte[n5];
            this.input.fill(true, byArray);
            int n6 = 0;
            if (bl && (n4 = ByteUtil.getOneByte(byArray, n6++)) >= n3) {
                throw new ConnectionException(sm.getString("http2Parser.processFrame.tooMuchPadding", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n4), Integer.toString(n3)}), Http2Error.PROTOCOL_ERROR);
            }
            if (bl2) {
                boolean bl3 = ByteUtil.isBit7Set(byArray[n6]);
                int n7 = ByteUtil.get31Bits(byArray, n6);
                int n8 = ByteUtil.getOneByte(byArray, n6 + 4) + 1;
                this.output.reprioritise(n, n7, bl3, n8);
            }
            n3 -= n5;
            n3 -= n4;
        }
        this.readHeaderPayload(n, n3);
        this.swallowPayload(n, FrameType.HEADERS.getId(), n4, true);
        if (Flags.isEndOfHeaders(n2)) {
            this.onHeadersComplete(n);
        } else {
            this.headersCurrentStream = n;
        }
    }

    private void readPriorityFrame(int n) throws Http2Exception, IOException {
        byte[] byArray = new byte[5];
        this.input.fill(true, byArray);
        boolean bl = ByteUtil.isBit7Set(byArray[0]);
        int n2 = ByteUtil.get31Bits(byArray, 0);
        int n3 = ByteUtil.getOneByte(byArray, 4) + 1;
        if (n == n2) {
            throw new StreamException(sm.getString("http2Parser.processFramePriority.invalidParent", new Object[]{this.connectionId, n}), Http2Error.PROTOCOL_ERROR, n);
        }
        this.output.reprioritise(n, n2, bl, n3);
    }

    private void readRstFrame(int n) throws Http2Exception, IOException {
        byte[] byArray = new byte[4];
        this.input.fill(true, byArray);
        long l = ByteUtil.getFourBytes(byArray, 0);
        this.output.reset(n, l);
        this.headersCurrentStream = -1;
        this.headersEndStream = false;
    }

    private void readSettingsFrame(int n, int n2) throws Http2Exception, IOException {
        boolean bl = Flags.isAck(n);
        if (n2 > 0 && bl) {
            throw new ConnectionException(sm.getString("http2Parser.processFrameSettings.ackWithNonZeroPayload"), Http2Error.FRAME_SIZE_ERROR);
        }
        if (n2 == 0 && !bl) {
            this.output.setting(null, 0L);
        } else {
            byte[] byArray = new byte[6];
            for (int i = 0; i < n2 / 6; ++i) {
                this.input.fill(true, byArray);
                int n3 = ByteUtil.getTwoBytes(byArray, 0);
                long l = ByteUtil.getFourBytes(byArray, 2);
                this.output.setting(Setting.valueOf(n3), l);
            }
        }
        this.output.settingsEnd(bl);
    }

    private void readPushPromiseFrame(int n) throws Http2Exception {
        throw new ConnectionException(sm.getString("http2Parser.processFramePushPromise", new Object[]{this.connectionId, n}), Http2Error.PROTOCOL_ERROR);
    }

    private void readPingFrame(int n) throws IOException {
        byte[] byArray = new byte[8];
        this.input.fill(true, byArray);
        this.output.pingReceive(byArray, Flags.isAck(n));
    }

    private void readGoawayFrame(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.input.fill(true, byArray);
        int n2 = ByteUtil.get31Bits(byArray, 0);
        long l = ByteUtil.getFourBytes(byArray, 4);
        String string = null;
        if (n > 8) {
            string = new String(byArray, 8, n - 8, StandardCharsets.UTF_8);
        }
        this.output.goaway(n2, l, string);
    }

    private void readWindowUpdateFrame(int n) throws Http2Exception, IOException {
        byte[] byArray = new byte[4];
        this.input.fill(true, byArray);
        int n2 = ByteUtil.get31Bits(byArray, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("http2Parser.processFrameWindowUpdate.debug", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n2)}));
        }
        if (n2 == 0) {
            if (n == 0) {
                throw new ConnectionException(sm.getString("http2Parser.processFrameWindowUpdate.invalidIncrement"), Http2Error.PROTOCOL_ERROR);
            }
            throw new StreamException(sm.getString("http2Parser.processFrameWindowUpdate.invalidIncrement"), Http2Error.PROTOCOL_ERROR, n);
        }
        this.output.incrementWindowSize(n, n2);
    }

    private void readContinuationFrame(int n, int n2, int n3) throws Http2Exception, IOException {
        if (this.headersCurrentStream == -1) {
            throw new ConnectionException(sm.getString("http2Parser.processFrameContinuation.notExpected", new Object[]{this.connectionId, Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
        }
        boolean bl = Flags.isEndOfHeaders(n2);
        this.output.headersContinue(n3, bl);
        this.readHeaderPayload(n, n3);
        if (bl) {
            this.headersCurrentStream = -1;
            this.onHeadersComplete(n);
        }
    }

    private void readHeaderPayload(int n, int n2) throws Http2Exception, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("http2Parser.processFrameHeaders.payload", new Object[]{this.connectionId, n, n2}));
        }
        int n3 = n2;
        while (n3 > 0) {
            StreamException streamException;
            int n4;
            if (this.headerReadBuffer.remaining() == 0) {
                n4 = this.headerReadBuffer.capacity() < n2 ? n2 : this.headerReadBuffer.capacity() * 2;
                this.headerReadBuffer = ByteBufferUtils.expand((ByteBuffer)this.headerReadBuffer, (int)n4);
            }
            n4 = Math.min(this.headerReadBuffer.remaining(), n3);
            this.input.fill(true, this.headerReadBuffer, n4);
            this.headerReadBuffer.flip();
            try {
                this.hpackDecoder.decode(this.headerReadBuffer);
            }
            catch (HpackException hpackException) {
                throw new ConnectionException(sm.getString("http2Parser.processFrameHeaders.decodingFailed"), Http2Error.COMPRESSION_ERROR, hpackException);
            }
            this.headerReadBuffer.compact();
            n3 -= n4;
            if (this.hpackDecoder.isHeaderCountExceeded()) {
                streamException = new StreamException(sm.getString("http2Parser.headerLimitCount", new Object[]{this.connectionId, n}), Http2Error.ENHANCE_YOUR_CALM, n);
                this.hpackDecoder.getHeaderEmitter().setHeaderException(streamException);
            }
            if (this.hpackDecoder.isHeaderSizeExceeded(this.headerReadBuffer.position())) {
                streamException = new StreamException(sm.getString("http2Parser.headerLimitSize", new Object[]{this.connectionId, n}), Http2Error.ENHANCE_YOUR_CALM, n);
                this.hpackDecoder.getHeaderEmitter().setHeaderException(streamException);
            }
            if (!this.hpackDecoder.isHeaderSwallowSizeExceeded(this.headerReadBuffer.position())) continue;
            throw new ConnectionException(sm.getString("http2Parser.headerLimitSize", new Object[]{this.connectionId, n}), Http2Error.ENHANCE_YOUR_CALM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readUnknownFrame(int n, int n2, int n3, int n4) throws IOException {
        try {
            this.swallowPayload(n, n2, n4, false);
        }
        catch (ConnectionException connectionException) {
        }
        finally {
            this.output.onSwallowedUnknownFrame(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swallowPayload(int n, int n2, int n3, boolean bl) throws IOException, ConnectionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("http2Parser.swallow.debug", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n3)}));
        }
        int n4 = 0;
        try {
            if (n3 == 0) {
                return;
            }
            byte[] byArray = new byte[1024];
            for (int i = 0; i < n3; i += n4) {
                n4 = Math.min(byArray.length, n3 - i);
                this.input.fill(true, byArray, 0, n4);
                if (!bl) continue;
                for (int j = 0; j < n4; ++j) {
                    if (byArray[j] == 0) continue;
                    throw new ConnectionException(sm.getString("http2Parser.nonZeroPadding", new Object[]{this.connectionId, Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
                }
            }
        }
        finally {
            if (FrameType.DATA.getIdByte() == n2) {
                if (bl) {
                    ++n3;
                }
                if (n3 > 0) {
                    this.output.onSwallowedDataFramePayload(n, n3);
                }
            }
            i += n4;
        }
    }

    private void onHeadersComplete(int n) throws Http2Exception {
        if (this.headerReadBuffer.position() > 0) {
            throw new ConnectionException(sm.getString("http2Parser.processFrameHeaders.decodingDataLeft"), Http2Error.COMPRESSION_ERROR);
        }
        this.hpackDecoder.getHeaderEmitter().validateHeaders();
        this.output.headersEnd(n);
        if (this.headersEndStream) {
            this.output.receivedEndOfStream(n);
            this.headersEndStream = false;
        }
        if (this.headerReadBuffer.capacity() > 1024) {
            this.headerReadBuffer = ByteBuffer.allocate(1024);
        }
    }

    private void validateFrame(FrameType frameType, FrameType frameType2, int n, int n2, int n3) throws Http2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("http2Parser.processFrame", new Object[]{this.connectionId, Integer.toString(n), frameType2, Integer.toString(n2), Integer.toString(n3)}));
        }
        if (frameType != null && frameType2 != frameType) {
            throw new StreamException(sm.getString("http2Parser.processFrame.unexpectedType", new Object[]{frameType, frameType2}), Http2Error.PROTOCOL_ERROR, n);
        }
        int n4 = this.input.getMaxFrameSize();
        if (n3 > n4) {
            throw new ConnectionException(sm.getString("http2Parser.payloadTooBig", new Object[]{Integer.toString(n3), Integer.toString(n4)}), Http2Error.FRAME_SIZE_ERROR);
        }
        if (this.headersCurrentStream != -1) {
            if (this.headersCurrentStream != n) {
                throw new ConnectionException(sm.getString("http2Parser.headers.wrongStream", new Object[]{this.connectionId, Integer.toString(this.headersCurrentStream), Integer.toString(n)}), Http2Error.COMPRESSION_ERROR);
            }
            if (frameType2 != FrameType.RST && frameType2 != FrameType.CONTINUATION) {
                throw new ConnectionException(sm.getString("http2Parser.headers.wrongFrameType", new Object[]{this.connectionId, Integer.toString(this.headersCurrentStream), frameType2}), Http2Error.COMPRESSION_ERROR);
            }
        }
        frameType2.check(n, n3);
    }

    void readConnectionPreface() throws Http2Exception {
        byte[] byArray = new byte[CLIENT_PREFACE_START.length];
        try {
            this.input.fill(true, byArray);
            for (int i = 0; i < CLIENT_PREFACE_START.length; ++i) {
                if (CLIENT_PREFACE_START[i] == byArray[i]) continue;
                throw new ProtocolException(sm.getString("http2Parser.preface.invalid"));
            }
            this.readFrame(true, FrameType.SETTINGS);
        }
        catch (IOException iOException) {
            throw new ProtocolException(sm.getString("http2Parser.preface.io"), iOException);
        }
    }

    static interface Output {
        public HpackDecoder getHpackDecoder();

        public ByteBuffer startRequestBodyFrame(int var1, int var2, boolean var3) throws Http2Exception;

        public void endRequestBodyFrame(int var1, int var2) throws Http2Exception, IOException;

        public void receivedEndOfStream(int var1) throws ConnectionException;

        public void onSwallowedDataFramePayload(int var1, int var2) throws ConnectionException, IOException;

        public HpackDecoder.HeaderEmitter headersStart(int var1, boolean var2) throws Http2Exception, IOException;

        public void headersContinue(int var1, boolean var2);

        public void headersEnd(int var1) throws Http2Exception;

        public void reprioritise(int var1, int var2, boolean var3, int var4) throws Http2Exception;

        public void reset(int var1, long var2) throws Http2Exception;

        public void setting(Setting var1, long var2) throws ConnectionException;

        public void settingsEnd(boolean var1) throws IOException;

        public void pingReceive(byte[] var1, boolean var2) throws IOException;

        public void goaway(int var1, long var2, String var4);

        public void incrementWindowSize(int var1, int var2) throws Http2Exception;

        public void onSwallowedUnknownFrame(int var1, int var2, int var3, int var4) throws IOException;
    }

    static interface Input {
        public boolean fill(boolean var1, byte[] var2, int var3, int var4) throws IOException;

        public boolean fill(boolean var1, byte[] var2) throws IOException;

        public boolean fill(boolean var1, ByteBuffer var2, int var3) throws IOException;

        public int getMaxFrameSize();
    }
}

