/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Response;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.res.StringManager;

public class ResponseFacade
implements HttpServletResponse {
    protected static final StringManager sm = StringManager.getManager(ResponseFacade.class);
    protected Response response = null;

    public ResponseFacade(Response response) {
        this.response = response;
    }

    public void clear() {
        this.response = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void finish() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.isSuspended();
    }

    public long getContentWritten() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getContentWritten();
    }

    public String getCharacterEncoding() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream servletOutputStream = this.response.getOutputStream();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter printWriter = this.response.getWriter();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return printWriter;
    }

    public void setContentLength(int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(n);
    }

    public void setContentLengthLong(long l) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLengthLong(l);
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(string));
        } else {
            this.response.setContentType(string);
        }
    }

    public void setBufferSize(int n) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.setBufferSize.ise"));
        }
        this.response.setBufferSize(n);
    }

    public int getBufferSize() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getBufferSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flushBuffer() throws IOException {
        if (this.isFinished()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new FlushBufferPrivilegedAction(this.response));
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (!(exception instanceof IOException)) return;
                throw (IOException)exception;
            }
        } else {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
        }
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.resetBuffer.ise"));
        }
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.isAppCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.reset.ise"));
        }
        this.response.reset();
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(locale);
    }

    public Locale getLocale() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getLocale();
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addCookie(cookie);
    }

    public boolean containsHeader(String string) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.containsHeader(string);
    }

    public String encodeURL(String string) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeURL(string);
    }

    public String encodeRedirectURL(String string) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeRedirectURL(string);
    }

    public String encodeUrl(String string) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeRedirectURL(string);
    }

    public void sendError(int n, String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendError.ise"));
        }
        this.response.setAppCommitted(true);
        this.response.sendError(n, string);
    }

    public void sendError(int n) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendError.ise"));
        }
        this.response.setAppCommitted(true);
        this.response.sendError(n);
    }

    public void sendRedirect(String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendRedirect.ise"));
        }
        this.response.setAppCommitted(true);
        this.response.sendRedirect(string);
    }

    public void setDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new DateHeaderPrivilegedAction(string, l, false));
        } else {
            this.response.setDateHeader(string, l);
        }
    }

    public void addDateHeader(String string, long l) {
        if (this.isCommitted()) {
            return;
        }
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new DateHeaderPrivilegedAction(string, l, true));
        } else {
            this.response.addDateHeader(string, l);
        }
    }

    public void setHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(string, n);
    }

    public void addIntHeader(String string, int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(string, n);
    }

    public void setStatus(int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(n);
    }

    public void setStatus(int n, String string) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(n, string);
    }

    public String getContentType() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getContentType();
    }

    public void setCharacterEncoding(String string) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        this.response.setCharacterEncoding(string);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getHeader(String string) {
        return this.response.getHeader(string);
    }

    public Collection<String> getHeaderNames() {
        return this.response.getHeaderNames();
    }

    public Collection<String> getHeaders(String string) {
        return this.response.getHeaders(string);
    }

    private static class FlushBufferPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private final Response response;

        public FlushBufferPrivilegedAction(Response response) {
            this.response = response;
        }

        @Override
        public Void run() throws IOException {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
            return null;
        }
    }

    private final class DateHeaderPrivilegedAction
    implements PrivilegedAction<Void> {
        private final String name;
        private final long value;
        private final boolean add;

        DateHeaderPrivilegedAction(String string, long l, boolean bl) {
            this.name = string;
            this.value = l;
            this.add = bl;
        }

        @Override
        public Void run() {
            if (this.add) {
                ResponseFacade.this.response.addDateHeader(this.name, this.value);
            } else {
                ResponseFacade.this.response.setDateHeader(this.name, this.value);
            }
            return null;
        }
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction<Void> {
        private final String contentType;

        public SetContentTypePrivilegedAction(String string) {
            this.contentType = string;
        }

        @Override
        public Void run() {
            ResponseFacade.this.response.setContentType(this.contentType);
            return null;
        }
    }
}

