"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = __importDefault(require("util"));
const saml = __importStar(require("./saml"));
const inmemory_cache_provider_1 = require("./inmemory-cache-provider");
const strategy_1 = __importDefault(require("./strategy"));
function MultiSamlStrategy(options, verify) {
    if (!options || typeof options.getSamlOptions != 'function') {
        throw new Error('Please provide a getSamlOptions function');
    }
    if (!options.requestIdExpirationPeriodMs) {
        options.requestIdExpirationPeriodMs = 28800000; // 8 hours
    }
    if (!options.cacheProvider) {
        options.cacheProvider = new inmemory_cache_provider_1.CacheProvider({ keyExpirationPeriodMs: options.requestIdExpirationPeriodMs });
    }
    strategy_1.default.call(this, options, verify);
    this._options = options;
}
util_1.default.inherits(MultiSamlStrategy, strategy_1.default);
MultiSamlStrategy.prototype.authenticate = function (req, options) {
    this._options.getSamlOptions(req, (err, samlOptions) => {
        if (err) {
            return this.error(err);
        }
        const samlService = new saml.SAML(Object.assign({}, this._options, samlOptions));
        const strategy = Object.assign({}, this, { _saml: samlService });
        Object.setPrototypeOf(strategy, this);
        this.constructor.super_.prototype.authenticate.call(strategy, req, options);
    });
};
MultiSamlStrategy.prototype.logout = function (req, callback) {
    this._options.getSamlOptions(req, (err, samlOptions) => {
        if (err) {
            return callback(err);
        }
        const samlService = new saml.SAML(Object.assign({}, this._options, samlOptions));
        const strategy = Object.assign({}, this, { _saml: samlService });
        Object.setPrototypeOf(strategy, this);
        this.constructor.super_.prototype.logout.call(strategy, req, callback);
    });
};
MultiSamlStrategy.prototype.generateServiceProviderMetadata = function (req, decryptionCert, signingCert, callback) {
    if (typeof callback !== 'function') {
        throw new Error("Metadata can't be provided synchronously for MultiSamlStrategy.");
    }
    return this._options.getSamlOptions(req, (err, samlOptions) => {
        if (err) {
            return callback(err);
        }
        const samlService = new saml.SAML(Object.assign({}, this._options, samlOptions));
        const strategy = Object.assign({}, this, { _saml: samlService });
        Object.setPrototypeOf(strategy, this);
        return callback(null, this.constructor.super_.prototype.generateServiceProviderMetadata.call(strategy, decryptionCert, signingCert));
    });
};
module.exports = MultiSamlStrategy;
//# sourceMappingURL=multiSamlStrategy.js.map