/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.security.Escape;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class JspUtil {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags/";
    private static final String META_INF_TAGS = "/META-INF/tags/";
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String[] javaKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    static final int JSP_INPUT_STREAM_BUFFER_SIZE = 1024;
    public static final int CHUNKSIZE = 1024;

    public static String getExprInXml(String string) {
        int n = string.length();
        String string2 = string.startsWith(OPEN_EXPR) && string.endsWith(CLOSE_EXPR) ? string.substring(1, n - 1) : string;
        return Escape.xml((String)string2);
    }

    public static void checkScope(String string, Node node, ErrorDispatcher errorDispatcher) throws JasperException {
        if (!(string == null || string.equals("page") || string.equals("request") || string.equals("session") || string.equals("application"))) {
            errorDispatcher.jspError(node, "jsp.error.invalid.scope", string);
        }
    }

    public static void checkAttributes(String string, Node node, ValidAttribute[] validAttributeArray, ErrorDispatcher errorDispatcher) throws JasperException {
        int n;
        Attributes attributes = node.getAttributes();
        Mark mark = node.getStart();
        boolean bl = true;
        int n2 = attributes == null ? 0 : attributes.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i = 0; i < n2; ++i) {
            String string2 = attributes.getQName(i);
            if (string2.equals("xmlns") || string2.startsWith("xmlns:")) continue;
            arrayList.add(string2);
        }
        Node.Nodes nodes = node.getBody();
        if (nodes != null) {
            Node node2;
            int n3 = nodes.size();
            for (int i = 0; i < n3 && (node2 = nodes.getNode(i)) instanceof Node.NamedAttribute; ++i) {
                String string3 = node2.getAttributeValue("name");
                arrayList.add(string3);
                if (node.getAttributeValue(string3) == null) continue;
                errorDispatcher.jspError(node, "jsp.error.duplicate.name.jspattribute", string3);
            }
        }
        String string4 = null;
        for (ValidAttribute validAttributeArray2 : validAttributeArray) {
            if (!validAttributeArray2.mandatory) continue;
            int n3 = arrayList.indexOf(validAttributeArray2.name);
            if (n3 != -1) {
                arrayList.remove(n3);
                bl = true;
                continue;
            }
            bl = false;
            string4 = validAttributeArray2.name;
            break;
        }
        if (!bl) {
            errorDispatcher.jspError(mark, "jsp.error.mandatory.attribute", string, string4);
        }
        if ((n = arrayList.size()) == 0) {
            return;
        }
        for (String string5 : arrayList) {
            bl = false;
            for (ValidAttribute validAttribute : validAttributeArray) {
                if (!string5.equals(validAttribute.name)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            errorDispatcher.jspError(mark, "jsp.error.invalid.attribute", string, string5);
        }
    }

    public static boolean booleanValue(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.equalsIgnoreCase("yes") ? true : Boolean.parseBoolean(string);
        }
        return bl;
    }

    public static Class<?> toClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<Object> clazz = null;
        int n = string.indexOf(91);
        int n2 = 0;
        if (n > 0) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '[') continue;
                ++n2;
            }
            string = string.substring(0, n);
        }
        clazz = "boolean".equals(string) ? Boolean.TYPE : ("char".equals(string) ? Character.TYPE : ("byte".equals(string) ? Byte.TYPE : ("short".equals(string) ? Short.TYPE : ("int".equals(string) ? Integer.TYPE : ("long".equals(string) ? Long.TYPE : ("float".equals(string) ? Float.TYPE : ("double".equals(string) ? Double.TYPE : ("void".equals(string) ? Void.TYPE : classLoader.loadClass(string)))))))));
        if (n2 == 0) {
            return clazz;
        }
        if (n2 == 1) {
            return Array.newInstance(clazz, 1).getClass();
        }
        return Array.newInstance(clazz, new int[n2]).getClass();
    }

    public static String interpreterCall(boolean bl, String string, Class<?> clazz, String string2) {
        String string3;
        String string4 = null;
        string4 = bl ? "this.getJspContext()" : "_jspx_page_context";
        String string5 = string3 = clazz.getCanonicalName();
        String string6 = null;
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                string3 = Boolean.class.getName();
                string6 = "booleanValue";
            } else if (clazz.equals(Byte.TYPE)) {
                string3 = Byte.class.getName();
                string6 = "byteValue";
            } else if (clazz.equals(Character.TYPE)) {
                string3 = Character.class.getName();
                string6 = "charValue";
            } else if (clazz.equals(Short.TYPE)) {
                string3 = Short.class.getName();
                string6 = "shortValue";
            } else if (clazz.equals(Integer.TYPE)) {
                string3 = Integer.class.getName();
                string6 = "intValue";
            } else if (clazz.equals(Long.TYPE)) {
                string3 = Long.class.getName();
                string6 = "longValue";
            } else if (clazz.equals(Float.TYPE)) {
                string3 = Float.class.getName();
                string6 = "floatValue";
            } else if (clazz.equals(Double.TYPE)) {
                string3 = Double.class.getName();
                string6 = "doubleValue";
            }
        }
        string5 = JspUtil.toJavaSourceType(string5);
        StringBuilder stringBuilder = new StringBuilder("(" + string3 + ") org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate(" + Generator.quote(string) + ", " + string5 + ".class, (javax.servlet.jsp.PageContext)" + string4 + ", " + string2 + ")");
        if (string6 != null) {
            stringBuilder.insert(0, "(");
            stringBuilder.append(")." + string6 + "()");
        }
        return stringBuilder.toString();
    }

    public static String coerceToPrimitiveBoolean(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToBoolean(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "false";
        }
        return Boolean.valueOf(string).toString();
    }

    public static String coerceToBoolean(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Boolean) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", java.lang.Boolean.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Boolean(false)";
        }
        return "new java.lang.Boolean(" + Boolean.valueOf(string).toString() + ")";
    }

    public static String coerceToPrimitiveByte(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToByte(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(byte) 0";
        }
        return "((byte)" + Byte.valueOf(string).toString() + ")";
    }

    public static String coerceToByte(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Byte) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", java.lang.Byte.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Byte((byte) 0)";
        }
        return "new java.lang.Byte((byte)" + Byte.valueOf(string).toString() + ")";
    }

    public static String coerceToChar(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToChar(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(char) 0";
        }
        char c = string.charAt(0);
        return "((char) " + c + ")";
    }

    public static String coerceToCharacter(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Character) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", java.lang.Character.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Character((char) 0)";
        }
        char c = string.charAt(0);
        return "new java.lang.Character((char) " + c + ")";
    }

    public static String coerceToPrimitiveDouble(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToDouble(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(double) 0";
        }
        return Double.valueOf(string).toString();
    }

    public static String coerceToDouble(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Double) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", Double.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Double(0)";
        }
        return "new java.lang.Double(" + Double.valueOf(string).toString() + ")";
    }

    public static String coerceToPrimitiveFloat(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToFloat(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(float) 0";
        }
        return Float.valueOf(string).toString() + "f";
    }

    public static String coerceToFloat(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Float) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", java.lang.Float.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Float(0)";
        }
        return "new java.lang.Float(" + Float.valueOf(string).toString() + "f)";
    }

    public static String coerceToInt(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToInt(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "0";
        }
        return Integer.valueOf(string).toString();
    }

    public static String coerceToInteger(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Integer) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", java.lang.Integer.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Integer(0)";
        }
        return "new java.lang.Integer(" + Integer.valueOf(string).toString() + ")";
    }

    public static String coerceToPrimitiveShort(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToShort(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(short) 0";
        }
        return "((short) " + Short.valueOf(string).toString() + ")";
    }

    public static String coerceToShort(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Short) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", java.lang.Short.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Short((short) 0)";
        }
        return "new java.lang.Short(\"" + Short.valueOf(string).toString() + "\")";
    }

    public static String coerceToPrimitiveLong(String string, boolean bl) {
        if (bl) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToLong(" + string + ")";
        }
        if (string == null || string.length() == 0) {
            return "(long) 0";
        }
        return Long.valueOf(string).toString() + "l";
    }

    public static String coerceToLong(String string, boolean bl) {
        if (bl) {
            return "(java.lang.Long) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + string + ", java.lang.Long.class)";
        }
        if (string == null || string.length() == 0) {
            return "new java.lang.Long(0)";
        }
        return "new java.lang.Long(" + Long.valueOf(string).toString() + "l)";
    }

    public static BufferedInputStream getInputStream(String string, Jar jar, JspCompilationContext jspCompilationContext) throws IOException {
        InputStream inputStream = null;
        if (jar != null) {
            String string2 = string.substring(1);
            inputStream = jar.getInputStream(string2);
        } else {
            inputStream = jspCompilationContext.getResourceAsStream(string);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(Localizer.getMessage("jsp.error.file.not.found", string));
        }
        return new BufferedInputStream(inputStream, 1024);
    }

    public static InputSource getInputSource(String string, Jar jar, JspCompilationContext jspCompilationContext) throws IOException {
        InputSource inputSource;
        if (jar != null) {
            String string2 = string.substring(1);
            inputSource = new InputSource(jar.getInputStream(string2));
            inputSource.setSystemId(jar.getURL(string2));
        } else {
            inputSource = new InputSource(jspCompilationContext.getResourceAsStream(string));
            inputSource.setSystemId(jspCompilationContext.getResource(string).toExternalForm());
        }
        return inputSource;
    }

    public static String getTagHandlerClassName(String string, String string2, ErrorDispatcher errorDispatcher) throws JasperException {
        String string3 = null;
        int n = 0;
        int n2 = string.lastIndexOf(".tag");
        if (n2 == -1) {
            errorDispatcher.jspError("jsp.error.tagfile.badSuffix", string);
        }
        if ((n2 = string.indexOf(WEB_INF_TAGS)) != -1) {
            string3 = Constants.TAG_FILE_PACKAGE_NAME + ".web.";
            n = n2 + WEB_INF_TAGS.length();
        } else {
            n2 = string.indexOf(META_INF_TAGS);
            if (n2 != -1) {
                string3 = JspUtil.getClassNameBase(string2);
                n = n2 + META_INF_TAGS.length();
            } else {
                errorDispatcher.jspError("jsp.error.tagfile.illegalPath", string);
            }
        }
        string3 = string3 + JspUtil.makeJavaPackage(string.substring(n));
        return string3;
    }

    private static String getClassNameBase(String string) {
        StringBuilder stringBuilder = new StringBuilder(Constants.TAG_FILE_PACKAGE_NAME + ".meta.");
        if (string != null) {
            stringBuilder.append(JspUtil.makeJavaPackage(string));
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    public static final String makeJavaPackage(String string) {
        String[] stringArray = string.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(JspUtil.makeJavaIdentifier(string2));
        }
        return stringBuilder.toString();
    }

    public static final String makeJavaIdentifier(String string) {
        return JspUtil.makeJavaIdentifier(string, true);
    }

    public static final String makeJavaIdentifierForAttribute(String string) {
        return JspUtil.makeJavaIdentifier(string, false);
    }

    private static final String makeJavaIdentifier(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuilder.append('_');
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) && (c != '_' || !bl)) {
                stringBuilder.append(c);
                continue;
            }
            if (c == '.' && bl) {
                stringBuilder.append('_');
                continue;
            }
            stringBuilder.append(JspUtil.mangleChar(c));
        }
        if (JspUtil.isJavaKeyword(stringBuilder.toString())) {
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    public static final String mangleChar(char c) {
        char[] cArray = new char[]{'_', Character.forDigit(c >> 12 & 0xF, 16), Character.forDigit(c >> 8 & 0xF, 16), Character.forDigit(c >> 4 & 0xF, 16), Character.forDigit(c & 0xF, 16)};
        return new String(cArray);
    }

    public static boolean isJavaKeyword(String string) {
        int n = 0;
        int n2 = javaKeywords.length;
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            int n4 = javaKeywords[n3].compareTo(string);
            if (n4 == 0) {
                return true;
            }
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return false;
    }

    static InputStreamReader getReader(String string, String string2, Jar jar, JspCompilationContext jspCompilationContext, ErrorDispatcher errorDispatcher) throws JasperException, IOException {
        return JspUtil.getReader(string, string2, jar, jspCompilationContext, errorDispatcher, 0);
    }

    static InputStreamReader getReader(String string, String string2, Jar jar, JspCompilationContext jspCompilationContext, ErrorDispatcher errorDispatcher, int n) throws JasperException, IOException {
        InputStreamReader inputStreamReader = null;
        BufferedInputStream bufferedInputStream = JspUtil.getInputStream(string, jar, jspCompilationContext);
        try {
            for (int i = 0; i < n; ++i) {
                ((InputStream)bufferedInputStream).read();
            }
        }
        catch (IOException iOException) {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        try {
            inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            errorDispatcher.jspError("jsp.error.unsupported.encoding", string2);
        }
        return inputStreamReader;
    }

    public static String toJavaSourceTypeFromTld(String string) {
        if (string == null || "void".equals(string)) {
            return "java.lang.Void.TYPE";
        }
        return string + ".class";
    }

    public static String toJavaSourceType(String string) {
        if (string.charAt(0) != '[') {
            return string;
        }
        int n = 1;
        String string2 = null;
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) == '[') {
                ++n;
                continue;
            }
            switch (string.charAt(i)) {
                case 'Z': {
                    string2 = "boolean";
                    break;
                }
                case 'B': {
                    string2 = "byte";
                    break;
                }
                case 'C': {
                    string2 = "char";
                    break;
                }
                case 'D': {
                    string2 = "double";
                    break;
                }
                case 'F': {
                    string2 = "float";
                    break;
                }
                case 'I': {
                    string2 = "int";
                    break;
                }
                case 'J': {
                    string2 = "long";
                    break;
                }
                case 'S': {
                    string2 = "short";
                    break;
                }
                case 'L': {
                    string2 = string.substring(i + 1, string.indexOf(59));
                }
            }
            break;
        }
        if (string2 == null) {
            throw new IllegalArgumentException(Localizer.getMessage("jsp.error.unable.getType", string));
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        while (n > 0) {
            stringBuilder.append("[]");
            --n;
        }
        return stringBuilder.toString();
    }

    public static class ValidAttribute {
        private final String name;
        private final boolean mandatory;

        public ValidAttribute(String string, boolean bl) {
            this.name = string;
            this.mandatory = bl;
        }

        public ValidAttribute(String string) {
            this(string, false);
        }
    }
}

