/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.threads;

import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.views.threads.ThreadsViewSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class JFRSnapshotThreadsView
extends DataSourceView {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/threads.png";
    private JFRModel model;

    JFRSnapshotThreadsView(JFRSnapshot dataSource) {
        super((DataSource)dataSource, NbBundle.getMessage(JFRSnapshotThreadsView.class, (String)"LBL_Threads"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 30, false);
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
    }

    protected DataViewComponent createComponent() {
        final ThreadsViewSupport.TimelineViewSupport timelineView = new ThreadsViewSupport.TimelineViewSupport(this.model);
        ThreadsViewSupport.MasterViewSupport masterView = new ThreadsViewSupport.MasterViewSupport(this.model){

            @Override
            void firstShown() {
                JFRSnapshotThreadsView.this.initialize(this, timelineView);
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(this.model == null));
        if (this.model != null) {
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotThreadsView.class, (String)"LBL_Threads_visualization"), true), 1);
            dvc.addDetailsView(timelineView.getDetailsView(), 1);
        }
        return dvc;
    }

    private void initialize(final ThreadsViewSupport.MasterViewSupport masterView, final ThreadsViewSupport.TimelineViewSupport timelineView) {
        new RequestProcessor("JFR Threads Initializer").post(new Runnable(){

            @Override
            public void run() {
                JFRSnapshotThreadsView.this.model.visitEvents(timelineView);
                masterView.initialized(timelineView.getActiveTypes(), timelineView.getThreadsCount());
            }
        });
    }
}

