/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.JavaTypeFilter;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.profiling.presets.PresetsUtils;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class SamplerCPUPanel
extends JPanel {
    private JRadioButton inclFilterRadioButton;
    private JRadioButton exclFilterRadioButton;
    private TextAreaComponent filtersArea;
    private JLabel sampleRateLabel;
    private JComboBox sampleRateCombo;
    private JLabel sampleRateUnitsLabel;
    private JLabel refreshRateLabel;
    private JLabel refreshUnitsLabel;
    private JComboBox refreshRateCombo;
    private final Runnable validator;
    private boolean filtersValid = true;
    private boolean internalChange;

    public SamplerCPUPanel() {
        this((Runnable)null, false);
    }

    SamplerCPUPanel(Runnable validator, boolean mnemonics) {
        this.validator = validator;
        this.initComponents(mnemonics);
    }

    public ProfilingSettings getSettings() {
        ProfilingSettings settings = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
        settings.setProfilingType(64);
        settings.setCPUProfilingType(2);
        String filter = this.getFilterValue();
        if (filter.isEmpty() || "*".equals(filter) || "**".equals(filter)) {
            settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
        } else {
            int filterType = this.inclFilterRadioButton.isSelected() ? 10 : 20;
            String filterValue = PresetsUtils.normalizeValue(filter);
            settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(filterValue, filterType));
        }
        return settings;
    }

    public int getSamplingRate() {
        return (Integer)this.sampleRateCombo.getSelectedItem();
    }

    public int getRefreshRate() {
        return (Integer)this.refreshRateCombo.getSelectedItem();
    }

    public boolean settingsValid() {
        return this.filtersValid;
    }

    public void loadFromPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        this.internalChange = true;
        this.inclFilterRadioButton.setSelected(!preset.getFilterModeS());
        this.exclFilterRadioButton.setSelected(preset.getFilterModeS());
        this.filtersArea.getTextArea().setText(preset.getFilterS());
        this.sampleRateCombo.setSelectedItem(preset.getSamplingRateS());
        this.refreshRateCombo.setSelectedItem(preset.getRefreshRateS());
        this.internalChange = false;
        this.checkFilterValidity();
    }

    public void saveToPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        preset.setFilterModeS(this.exclFilterRadioButton.isSelected());
        preset.setFilterS(this.filtersArea.getTextArea().getText());
        preset.setSamplingRateS((Integer)this.sampleRateCombo.getSelectedItem());
        preset.setRefreshRateS((Integer)this.refreshRateCombo.getSelectedItem());
    }

    public abstract void settingsChanged();

    private void syncUI() {
        if (this.internalChange) {
            return;
        }
        this.settingsChanged();
    }

    private void checkFilterValidity() {
        this.filtersValid = this.isFilterValueValid();
        this.filtersArea.getTextArea().setForeground(this.filtersValid ? UIManager.getColor("TextArea.foreground") : Color.RED);
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public boolean isFilterValueValid() {
        String filterValue = PresetsUtils.normalizeValue(this.getFilterValue());
        return PresetsUtils.isValidJavaValue(filterValue, true, false);
    }

    private String getFilterValue() {
        return this.filtersArea.getTextArea().getText().trim();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void initComponents(boolean mnemonics) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        ButtonGroup filterRadiosGroup = new ButtonGroup();
        JLabel referenceLabel = new JLabel("X");
        JPanel radiosPanel = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        radiosPanel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)radiosPanel, constraints);
        this.inclFilterRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SamplerCPUPanel.this.syncUI();
            }
        };
        SamplerCPUPanel.setText(this.inclFilterRadioButton, NbBundle.getMessage(SamplerCPUPanel.class, (String)"LBL_Profile_Incl_S"), mnemonics);
        this.inclFilterRadioButton.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Inclusive_Filter_S"));
        this.inclFilterRadioButton.setOpaque(false);
        this.inclFilterRadioButton.setBorder(referenceLabel.getBorder());
        Dimension d1 = this.inclFilterRadioButton.getPreferredSize();
        d1.height = Math.max(d1.height, referenceLabel.getPreferredSize().height);
        this.inclFilterRadioButton.setPreferredSize(d1);
        filterRadiosGroup.add(this.inclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 5, 5);
        radiosPanel.add((Component)this.inclFilterRadioButton, constraints);
        this.exclFilterRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SamplerCPUPanel.this.syncUI();
            }
        };
        SamplerCPUPanel.setText(this.exclFilterRadioButton, NbBundle.getMessage(SamplerCPUPanel.class, (String)"LBL_Profile_Excl_S"), mnemonics);
        this.exclFilterRadioButton.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Exclusive_Filter_S"));
        this.exclFilterRadioButton.setOpaque(false);
        this.exclFilterRadioButton.setBorder(referenceLabel.getBorder());
        Dimension d2 = this.exclFilterRadioButton.getPreferredSize();
        d2.height = Math.max(d2.height, referenceLabel.getPreferredSize().height);
        this.exclFilterRadioButton.setPreferredSize(d2);
        filterRadiosGroup.add(this.exclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 5, 5, 10);
        radiosPanel.add((Component)this.exclFilterRadioButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 0, 5, 0);
        radiosPanel.add((Component)Spacer.create(), constraints);
        this.filtersArea = SamplerCPUPanel.createTextArea(2);
        this.filtersArea.getTextArea().setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Instrumentation_Filter_S"));
        this.filtersArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SamplerCPUPanel.this.checkFilterValidity();
                SamplerCPUPanel.this.syncUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SamplerCPUPanel.this.checkFilterValidity();
                SamplerCPUPanel.this.syncUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SamplerCPUPanel.this.checkFilterValidity();
                SamplerCPUPanel.this.syncUI();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.filtersArea, constraints);
        this.sampleRateLabel = new JLabel();
        SamplerCPUPanel.setText(this.sampleRateLabel, NbBundle.getMessage(SamplerCPUPanel.class, (String)"LBL_Sampling_rate"), mnemonics);
        this.sampleRateLabel.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Sampling_rate"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 5, 5);
        this.add((Component)this.sampleRateLabel, constraints);
        Object[] samplingRates = new Integer[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000};
        this.sampleRateCombo = new JComboBox(samplingRates){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.sampleRateLabel.setLabelFor(this.sampleRateCombo);
        this.sampleRateCombo.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Sampling_rate"));
        this.sampleRateCombo.setEditable(false);
        this.sampleRateCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SamplerCPUPanel.this.syncUI();
            }
        });
        this.sampleRateCombo.setRenderer(new ComboRenderer(this.sampleRateCombo));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.sampleRateCombo, constraints);
        this.sampleRateUnitsLabel = new JLabel(NbBundle.getMessage(SamplerCPUPanel.class, (String)"LBL_units_ms"));
        this.sampleRateUnitsLabel.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Sampling_rate"));
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.sampleRateUnitsLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)Spacer.create(), constraints);
        this.refreshRateLabel = new JLabel();
        SamplerCPUPanel.setText(this.refreshRateLabel, NbBundle.getMessage(SamplerCPUPanel.class, (String)"LBL_Refresh_rate"), mnemonics);
        this.refreshRateLabel.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Refresh_rate"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(1, 10, 10, 5);
        this.add((Component)this.refreshRateLabel, constraints);
        Object[] refreshRates = new Integer[]{100, 200, 500, 1000, 2000, 5000, 10000};
        this.refreshRateCombo = new JComboBox(refreshRates){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.refreshRateLabel.setLabelFor(this.refreshRateCombo);
        this.refreshRateCombo.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Refresh_rate"));
        this.refreshRateCombo.setEditable(false);
        this.refreshRateCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SamplerCPUPanel.this.syncUI();
            }
        });
        this.refreshRateCombo.setRenderer(new ComboRenderer(this.refreshRateCombo));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 7;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(1, 0, 10, 5);
        this.add((Component)this.refreshRateCombo, constraints);
        this.refreshUnitsLabel = new JLabel(NbBundle.getMessage(SamplerCPUPanel.class, (String)"LBL_units_ms"));
        this.refreshUnitsLabel.setToolTipText(NbBundle.getMessage(SamplerCPUPanel.class, (String)"TOOLTIP_Refresh_rate"));
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 7;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(1, 0, 10, 5);
        this.add((Component)this.refreshUnitsLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 7;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(1, 0, 10, 0);
        this.add((Component)Spacer.create(), constraints);
    }

    private static void setText(JLabel l, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((JLabel)l, (String)text);
        } else {
            l.setText(text.replace("&", ""));
        }
    }

    private static void setText(AbstractButton b, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((AbstractButton)b, (String)text);
        } else {
            b.setText(text.replace("&", ""));
        }
    }

    private static TextAreaComponent createTextArea(int rows) {
        final JTextArea rootsArea = new JTextArea();
        rootsArea.setFont(new Font("Monospaced", 0, UIManager.getFont("Label.font").getSize()));
        TextAreaComponent rootsAreaScrollPane = new TextAreaComponent(rootsArea, 20, 30){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                rootsArea.setEnabled(enabled);
            }
        };
        rootsAreaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JTextArea referenceArea = new JTextArea("X");
        referenceArea.setFont(rootsArea.getFont());
        referenceArea.setRows(rows);
        Insets insets = rootsAreaScrollPane.getInsets();
        rootsAreaScrollPane.setPreferredSize(new Dimension(1, referenceArea.getPreferredSize().height + (insets != null ? insets.top + insets.bottom : 0)));
        return rootsAreaScrollPane;
    }

    private static class ComboRenderer
    implements ListCellRenderer {
        private ListCellRenderer renderer;

        ComboRenderer(JComboBox combo) {
            this.renderer = combo.getRenderer();
            if (this.renderer instanceof JLabel) {
                ((JLabel)((Object)this.renderer)).setHorizontalAlignment(11);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.renderer.getListCellRendererComponent(list, NumberFormat.getInstance().format(value), index, isSelected, cellHasFocus);
        }
    }

    private static class TextAreaComponent
    extends JScrollPane {
        public TextAreaComponent(JTextArea textArea, int vPolicy, int hPolicy) {
            super(textArea, vPolicy, hPolicy);
        }

        public JTextArea getTextArea() {
            return (JTextArea)this.getViewport().getView();
        }
    }
}

