/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Random;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.replacements.BASE64Encoder;

public class CertificateUtils {
    public static final void addToKeyStore(File file, KeyStore ks) throws CertificateException, IOException, KeyStoreException {
        OutputController.getLogger().log("Importing certificate from " + file + " into " + ks);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)cf.generateCertificate(bis);
        }
        catch (ClassCastException cce) {
            throw new CertificateException("Input file is not an X509 Certificate", cce);
        }
        CertificateUtils.addToKeyStore(cert, ks);
    }

    public static final void addToKeyStore(X509Certificate cert, KeyStore ks) throws KeyStoreException {
        OutputController.getLogger().log("Importing " + cert.getSubjectX500Principal().getName());
        String alias = ks.getCertificateAlias(cert);
        if (alias != null) {
            return;
        }
        Random random = new Random();
        while (ks.getCertificate(alias = new BigInteger(20, random).toString()) != null) {
        }
        ks.setCertificateEntry(alias, cert);
    }

    public static void addPKCS12ToKeyStore(File file, KeyStore ks, char[] password) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(bis, password);
        Enumeration<String> aliasList = keyStore.aliases();
        while (aliasList.hasMoreElements()) {
            String alias = aliasList.nextElement();
            Certificate[] certChain = keyStore.getCertificateChain(alias);
            Key key = keyStore.getKey(alias, password);
            CertificateUtils.addPKCS12ToKeyStore(certChain, key, ks);
        }
    }

    public static void addPKCS12ToKeyStore(Certificate[] certChain, Key key, KeyStore ks) throws KeyStoreException {
        String alias = ks.getCertificateAlias(certChain[0]);
        if (alias != null) {
            return;
        }
        Random random = new Random();
        while (ks.getCertificate(alias = new BigInteger(20, random).toString()) != null) {
        }
        SecurityUtil.setKeyEntry(ks, alias, key, certChain);
    }

    public static final boolean inKeyStores(X509Certificate c, KeyStore[] keyStores) {
        for (KeyStore keyStore : keyStores) {
            try {
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!c.equals(keyStore.getCertificate(alias))) continue;
                    OutputController.getLogger().log(Translator.R("LCertFoundIn", c.getSubjectX500Principal().getName(), KeyStores.getPathToKeystore(keyStore.hashCode())));
                    return true;
                }
            }
            catch (KeyStoreException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        return false;
    }

    public static void dump(Certificate cert, PrintStream out) throws IOException, CertificateException {
        BASE64Encoder encoder = new BASE64Encoder();
        out.println("-----BEGIN CERTIFICATE-----");
        encoder.encodeBuffer(cert.getEncoded(), (OutputStream)out);
        out.println("-----END CERTIFICATE-----");
    }

    public static void dumpPKCS12(String alias, File file, KeyStore ks, char[] password) throws Exception {
        Certificate[] certChain = ks.getCertificateChain(alias);
        Key key = SecurityUtil.getKey(ks, alias);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry(alias, key, password, certChain);
        keyStore.store(bos, password);
    }
}

