/*
 * Copyright (C)2005-2019 Haxe Foundation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

// This file is generated from mozilla\MediaKeySession.webidl. Do not edit!

package js.html.eme;

import js.lib.Promise;

/**
	The `MediaKeySession` interface of the EncryptedMediaExtensions API represents a context for message exchange with a content decryption module (CDM).

	Documentation [MediaKeySession](https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession) by [Mozilla Contributors](https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession$history), licensed under [CC-BY-SA 2.5](https://creativecommons.org/licenses/by-sa/2.5/).

	@see <https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession>
**/
@:native("MediaKeySession")
extern class MediaKeySession extends js.html.EventTarget {
	var error(default,null) : MediaKeyError;

	/**
		Contains a unique string generated by the CDM for the current media object and its associated keys or licenses.
	**/
	var sessionId(default,null) : String;

	/**
		The time after which the keys in the current session can no longer be used to decrypt media data, or `NaN` if no such time exists. This value is determined by the CDM and measured in milliseconds since January 1, 1970, UTC. This value may change during a session lifetime, such as when an action triggers the start of a window.
	**/
	var expiration(default,null) : Float;

	/**
		Returns a `Promise` signaling when a `MediaKeySession` closes. This promise can only be fulfilled and is never rejected. Closing a session means that licenses and keys associated with it are no longer valid for decrypting media data. 
	**/
	var closed(default,null) : Promise<Void>;

	/**
		Contains a reference to a read-only `MediaKeyStatusMap` of the current session's keys and their statuses.
	**/
	var keyStatuses(default,null) : MediaKeyStatusMap;

	/**
		Sets the `EventHandler` called when there has been a change in the keys in a session or their statuses.
	**/
	var onkeystatuseschange : haxe.Constraints.Function;

	/**
		Sets the `EventHandler` called when the content decryption module has generated a message for the session.
	**/
	var onmessage : haxe.Constraints.Function;


	/**
		Returns a `Promise` after generating a media request based on initialization data.
	**/
	@:overload( function( initDataType : String, initData : js.lib.ArrayBuffer) : Promise<Void> {} )
	function generateRequest( initDataType : String, initData : js.lib.ArrayBufferView ) : Promise<Void>;

	/**
		Returns a `Promise` that resolves to a boolean value after loading data for a specified session object. 
	**/
	function load( sessionId : String ) : Promise<Bool>;

	/**
		Returns a `Promise` after loading messages and licenses to the CDM.
	**/
	@:overload( function( response : js.lib.ArrayBuffer) : Promise<Void> {} )
	function update( response : js.lib.ArrayBufferView ) : Promise<Void>;

	/**

		 Returns a `Promise` after notifying the current media session is no longer needed and that the CDM should release any resources associated with this object and close it.

	**/
	function close() : Promise<Void>;

	/**
		Returns a `Promise` after removing any session data associated with the current object.
	**/
	function remove() : Promise<Void>;
}