/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Arrays;
import java.util.function.BiConsumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import mediathek.tool.GermanStringSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DatenAbo
implements Comparable<DatenAbo> {
    public static final int ABO_NR = 0;
    public static final int ABO_EINGESCHALTET = 1;
    public static final int ABO_NAME = 2;
    public static final int ABO_SENDER = 3;
    public static final int ABO_THEMA = 4;
    public static final int ABO_TITEL = 5;
    public static final int ABO_THEMA_TITEL = 6;
    public static final int ABO_IRGENDWO = 7;
    public static final int ABO_MINDESTDAUER = 8;
    public static final int ABO_MIN = 9;
    public static final int ABO_ZIELPFAD = 10;
    public static final int ABO_DOWN_DATUM = 11;
    public static final int ABO_PSET = 12;
    public static final String[] COLUMN_NAMES = new String[]{"Nr", "aktiv", "Name", "Sender", "Thema", "Titel", "Thema-Titel", "Irgendwo", "Dauer", "min/max", "Zielpfad", "letztes Abo", "Programmset"};
    private static final String[] XML_NAMES = new String[]{"Nr", "aktiv", "Name", "Sender", "Thema", "Titel", "Thema-Titel", "Irgendwo", "Mindestdauer", "min_max", "Zielpfad", "letztes_Abo", "Programmset"};
    public static final int MAX_ELEM = 13;
    public static final String TAG = "Abonnement";
    private static final Logger logger = LogManager.getLogger(DatenAbo.class);
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    public static boolean[] spaltenAnzeigen = new boolean[13];
    public int mindestdauerMinuten;
    public boolean min = true;
    public String[] arr;
    public String[] titel;
    public String[] thema;
    public String[] irgendwo;
    private int nr;

    public DatenAbo() {
        this.initialize();
    }

    public DatenAbo(String name, String sender, String thema, String titel, String themaTitel, String irgendwo, int mmindestdauerMinuten, boolean min2, String ziel, String pset) {
        this.initialize();
        this.arr[2] = name;
        this.arr[3] = sender;
        this.arr[4] = thema;
        this.arr[5] = titel;
        this.arr[6] = themaTitel;
        this.arr[7] = irgendwo;
        this.setMindestDauerMinuten(mmindestdauerMinuten);
        this.arr[9] = Boolean.toString(min2);
        this.min = min2;
        this.arr[10] = ziel;
        this.arr[12] = pset;
    }

    public static boolean anzeigen(int i) {
        return spaltenAnzeigen == null || spaltenAnzeigen[i];
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int nr) {
        this.nr = nr;
    }

    public DatenAbo getCopy() {
        DatenAbo ret = new DatenAbo();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.mindestdauerMinuten = this.mindestdauerMinuten;
        ret.min = this.min;
        return ret;
    }

    public boolean isEmpty() {
        return this.arr[3].isEmpty() && this.arr[4].isEmpty() && this.arr[5].isEmpty() && this.arr[6].isEmpty() && this.arr[7].isEmpty();
    }

    public final void setMindestDauerMinuten(int d) {
        this.mindestdauerMinuten = d;
        this.arr[8] = String.valueOf(d);
    }

    public void setMindestDauerMinuten() {
        if (this.arr[8].isEmpty()) {
            this.mindestdauerMinuten = 0;
            this.arr[8] = "0";
        }
        try {
            this.mindestdauerMinuten = Integer.parseInt(this.arr[8]);
        }
        catch (Exception ex) {
            logger.error("setMindestDauerMinuten()", (Throwable)ex);
            this.mindestdauerMinuten = 0;
            this.arr[8] = "0";
        }
    }

    public boolean aboIstEingeschaltet() {
        if (this.arr[1].isEmpty()) {
            this.aboEin();
            return true;
        }
        return Boolean.parseBoolean(this.arr[1]);
    }

    private void aboEin() {
        this.arr[1] = String.valueOf(true);
    }

    private void initialize() {
        this.arr = new String[13];
        Arrays.fill(this.arr, "");
        this.aboEin();
    }

    public void writeToConfig(@NotNull XMLStreamWriter writer) {
        BiConsumer<String, String> writeElement = (tagName, content) -> {
            try {
                writer.writeCharacters("\t");
                writer.writeStartElement((String)tagName);
                writer.writeCharacters((String)content);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            catch (XMLStreamException e) {
                logger.error("writeElement failed", (Throwable)e);
            }
        };
        try {
            writer.writeStartElement(TAG);
            writer.writeCharacters("\n");
            writeElement.accept(XML_NAMES[1], this.arr[1]);
            writeElement.accept(XML_NAMES[2], this.arr[2]);
            writeElement.accept(XML_NAMES[3], this.arr[3]);
            writeElement.accept(XML_NAMES[4], this.arr[4]);
            writeElement.accept(XML_NAMES[5], this.arr[5]);
            writeElement.accept(XML_NAMES[6], this.arr[6]);
            writeElement.accept(XML_NAMES[7], this.arr[7]);
            writeElement.accept(XML_NAMES[8], this.arr[8]);
            writeElement.accept(XML_NAMES[9], this.arr[9]);
            writeElement.accept(XML_NAMES[10], this.arr[10]);
            writeElement.accept(XML_NAMES[11], this.arr[11]);
            writeElement.accept(XML_NAMES[12], this.arr[12]);
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            logger.error("writeToConfig", (Throwable)ex);
        }
    }

    public void readFromConfig(@NotNull XMLStreamReader parser) throws XMLStreamException {
        int event;
        block0: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(TAG))) {
            if (event != 1) continue;
            for (int i = 0; i < this.arr.length; ++i) {
                if (!parser.getLocalName().equals(XML_NAMES[i])) continue;
                this.arr[i] = parser.getElementText();
                continue block0;
            }
        }
    }

    @Override
    public int compareTo(@NotNull DatenAbo arg0) {
        return sorter.compare(this.arr[2], arg0.arr[2]);
    }
}

