/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public class ServiceName
extends Name {
    private static final long serialVersionUID = 201305151047L;
    private static final byte[][] PROTOCOLS;
    private static final byte[] SUB_SERVICE_INDICATOR;
    private String instance;
    private String fullSubType;
    private String subType;
    private String fullType;
    private String type;
    private String domain;
    private String protocol;
    private String application;
    private final Name serviceTypeName;
    private final Name serviceRRName;

    public ServiceName(String s2) throws TextParseException {
        this(new Name(s2));
    }

    public ServiceName(String s2, Name name) throws TextParseException {
        this(new Name(s2, name));
    }

    ServiceName(Name name) throws TextParseException {
        super(name, 0);
        byte[] super_name = null;
        try {
            Class<Name> cls = Name.class;
            Field field = cls.getDeclaredField("name");
            field.setAccessible(true);
            super_name = (byte[])field.get(name);
        }
        catch (NoSuchFieldException cls) {
        }
        catch (IllegalArgumentException cls) {
        }
        catch (IllegalAccessException cls) {
            // empty catch block
        }
        int labelCount = name.labels();
        if (super_name == null) {
            super_name = new byte[name.length()];
            int current = 0;
            for (int index = 0; index < labelCount; ++index) {
                byte[] label = name.getLabel(index);
                System.arraycopy(label, 0, super_name, current, label[0] + 1);
                current += label[0] + 1;
            }
        }
        short[] offsets = new short[labelCount];
        short offset = 0;
        int serviceParts = 0;
        int serviceStartIndex = -1;
        int subTypeIndex = -1;
        int serviceEndIndex = -1;
        for (int index = 0; index < labelCount; ++index) {
            offsets[index] = offset;
            short length = (short)(super_name[offsets[index]] & 0xFF);
            offset = (short)(offsets[index] + length + 1);
            if (super_name[offsets[index]] <= 0 || super_name[offsets[index] + 1] != 95) continue;
            if (serviceEndIndex < 0) {
                serviceEndIndex = index;
            }
            if (subTypeIndex < 0 && ServiceName.arrayEquals(SUB_SERVICE_INDICATOR, super_name, offsets[index])) {
                subTypeIndex = index;
            }
            serviceStartIndex = index;
            ++serviceParts;
        }
        if (serviceParts > 0) {
            byte length;
            int index;
            StringBuilder builder = new StringBuilder();
            if (serviceEndIndex > 0) {
                for (index = 0; index < serviceEndIndex; ++index) {
                    length = super_name[offsets[index]];
                    if (length <= 0) continue;
                    builder.append(new String(super_name, offsets[index] + 1, (int)length)).append('.');
                }
                this.instance = builder.substring(0, builder.length() - 1);
                builder.setLength(0);
            }
            block7: for (index = serviceEndIndex; index <= serviceStartIndex; ++index) {
                length = super_name[offsets[index]];
                if (length <= 0) continue;
                String temp = new String(super_name, offsets[index] + 1, (int)length);
                if (index < subTypeIndex) {
                    builder.append(temp);
                } else if (index == subTypeIndex) {
                    this.subType = builder.substring(0, builder.length() - 1);
                    builder.append(temp);
                    this.fullSubType = builder.toString();
                } else {
                    if (index == serviceStartIndex) {
                        builder.append(temp);
                        for (byte[] PROTOCOL : PROTOCOLS) {
                            if (!ServiceName.arrayEquals(PROTOCOL, super_name, offsets[index])) continue;
                            this.protocol = temp;
                            break block7;
                        }
                        break;
                    }
                    builder.append(temp);
                }
                builder.append('.');
            }
            if (this.fullSubType != null) {
                this.type = builder.substring(this.fullSubType.length() + 1, builder.length());
                this.fullType = builder.toString();
                this.application = this.protocol != null ? builder.substring(this.fullSubType.length() + 1, builder.length() - this.protocol.length() - 1) : this.type;
            } else {
                this.type = this.fullType = builder.toString();
                this.application = this.protocol != null ? builder.substring(0, builder.length() - this.protocol.length() - 1) : this.type;
            }
            builder.setLength(0);
            for (index = serviceStartIndex + 1; index < offsets.length; ++index) {
                length = super_name[offsets[index]];
                if (length <= 0) continue;
                builder.append(new String(super_name, offsets[index] + 1, (int)length)).append('.');
            }
            this.domain = builder.substring(0, builder.length());
            builder.setLength(0);
            this.serviceTypeName = new Name(this.type + (this.domain != null ? "." + this.domain : ""));
            this.serviceRRName = this.instance != null && this.instance.length() > 0 ? new Name(this.instance, this.serviceTypeName) : null;
        } else {
            throw new TextParseException("Name \"" + name + "\" is not an IETF RFC 2782 or IETF RFC 6763 compliant service name.");
        }
    }

    private static final boolean arrayEquals(byte[] test, byte[] src, short offset) {
        int length = src[offset];
        if (length == test[0] && src.length > offset + length) {
            for (int index = 1; index < length; ++index) {
                if (test[index] == src[offset + index]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getApplication() {
        return this.application;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getFullSubType() {
        return this.fullSubType;
    }

    public String getFullType() {
        return this.fullType;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Name getServiceTypeName() {
        return this.serviceTypeName;
    }

    public Name getServiceRRName() {
        return this.serviceRRName;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public static void main(String ... args2) throws TextParseException {
        Name serviceName = new Name(args2.length > 0 ? args2[0] : "Steve Posick's Work MacBook Pro._test._sub._syncmate._tcp.local.");
        ServiceName name = new ServiceName(serviceName);
        System.out.println("Service Name = " + name);
        System.out.println("Instance: " + name.instance);
        System.out.println("Full Type: " + name.fullType);
        System.out.println("Sub Type: " + name.subType);
        System.out.println("Type: " + name.type);
        System.out.println("Application: " + name.application);
        System.out.println("Protocol: " + name.protocol);
        System.out.println("Domain: " + name.domain);
        int iterations = 100000;
        long startNanos = System.nanoTime();
        for (int index = 0; index < iterations; ++index) {
            name = new ServiceName(serviceName);
        }
        long tookNanos = System.nanoTime() - startNanos;
        System.out.println("Took " + (double)tookNanos / 1000000.0 + " milliseconds to parse " + iterations + " service names at " + (double)(tookNanos / (long)iterations) / 1000000.0 + " millis / " + tookNanos / (long)iterations + " nanoseconds each name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        byte[][] DEFAULTS;
        SUB_SERVICE_INDICATOR = new byte[]{4, 95, 115, 117, 98};
        ArrayList<byte[]> protocols = new ArrayList<byte[]>();
        for (byte[] value : DEFAULTS = new byte[][]{{4, 95, 116, 99, 112}, {4, 95, 117, 100, 112}, {5, 95, 115, 99, 116, 112}}) {
            protocols.add(value);
        }
        URL url = ServiceName.class.getResource("ServiceName.protocol");
        BufferedReader data = null;
        try {
            data = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            while ((line = data.readLine()) != null) {
                byte[] bytes = line.trim().getBytes();
                byte[] protocol = new byte[bytes.length + 1];
                protocol[0] = (byte)bytes.length;
                System.arraycopy(bytes, 0, protocol, 1, bytes.length);
                protocols.add(protocol);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.FINE, "Could not find Protocols file \"" + url + "\"", e);
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (IOException iOException) {}
            }
        }
        PROTOCOLS = (byte[][])protocols.toArray((T[])new byte[protocols.size()][]);
    }
}

