/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.mission;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.mission.AbstractMission;
import net.sf.freecol.common.model.mission.Mission;
import org.w3c.dom.Element;

public class GoToMission
extends AbstractMission {
    private int blockedCount;
    private Location destination;
    private static final String BLOCKED_COUNT_TAG = "blockedCount";
    private static final String DESTINATION_TAG = "destination";

    public GoToMission(Game game) {
        super(game);
    }

    public GoToMission(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    public GoToMission(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public GoToMission(Game game, String id) {
        super(game, id);
    }

    public final Location getDestination() {
        return this.destination;
    }

    public final void setDestination(Location newDestination) {
        this.destination = newDestination;
    }

    public final int getBlockedCount() {
        return this.blockedCount;
    }

    public final void setBlockedCount(int newBlockedCount) {
        this.blockedCount = newBlockedCount;
    }

    @Override
    public Mission.MissionState doMission() {
        return Mission.MissionState.OK;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.destination != null && this.destination.canAdd(this.getUnit());
    }

    public static boolean isValidFor(Unit unit) {
        return unit.getInitialMovesLeft() > 0;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(DESTINATION_TAG, this.destination);
        xw.writeAttribute(BLOCKED_COUNT_TAG, this.blockedCount);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.destination = xr.getLocationAttribute(this.getGame(), DESTINATION_TAG, false);
        this.blockedCount = xr.getAttribute(BLOCKED_COUNT_TAG, 0);
    }

    @Override
    public String getXMLTagName() {
        return GoToMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "goToMission";
    }
}

