include(CMakeFindDependencyMacro)

set(_mgard_required_vars)
if(ON)
  find_dependency(ZLIB)
  list(APPEND _mgard_required_vars ZLIB_FOUND)
endif()

if(_mgard_required_vars)
  list(INSERT _mgard_required_vars 0 REQUIRED_VARS)
endif()

include(FindPackageHandleStandardArgs)
set(${CMAKE_FIND_PACKAGE_NAME}_CONFIG ${CMAKE_CURRENT_LIST_FILE})
find_package_handle_standard_args(${CMAKE_FIND_PACKAGE_NAME} CONFIG_MODE
  ${_mgard_required_vars})

if(NOT TARGET mgard::mgard)
  include("${CMAKE_CURRENT_LIST_DIR}/mgard-targets.cmake")
endif()

set(MGARD_LIBRARIES mgard::mgard)
set(MGARD_INCLUDE_DIRS
  $<TARGET_PROPERTY:mgard::mgard,INTERFACE_INCLUDE_DIRECTORIES>
)
