/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host.model;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.host.model.HostOverview;
import org.openide.util.NbBundle;

class LocalHostOverview
extends HostOverview {
    OperatingSystemMXBean osMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    boolean loadAverageAvailable = this.osMXBean.getSystemLoadAverage() >= 0.0;

    LocalHostOverview() {
    }

    @Override
    public String getName() {
        return this.osMXBean.getName();
    }

    @Override
    public String getVersion() {
        return this.osMXBean.getVersion();
    }

    @Override
    public String getPatchLevel() {
        return System.getProperty("sun.os.patch.level", "");
    }

    @Override
    public int getAvailableProcessors() {
        return this.osMXBean.getAvailableProcessors();
    }

    @Override
    public String getArch() {
        String arch = this.osMXBean.getArch();
        String bits = System.getProperty("sun.arch.data.model");
        if (bits != null) {
            arch = arch + " " + bits + "bit";
        }
        return arch;
    }

    @Override
    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return NbBundle.getMessage(Host.class, (String)"LBL_Unknown");
        }
    }

    @Override
    public double getSystemLoadAverage() {
        if (this.loadAverageAvailable) {
            return this.osMXBean.getSystemLoadAverage();
        }
        return -1.0;
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        return this.osMXBean.getTotalPhysicalMemorySize();
    }

    @Override
    public long getFreePhysicalMemorySize() {
        return this.osMXBean.getFreePhysicalMemorySize();
    }

    @Override
    public long getTotalSwapSpaceSize() {
        return this.osMXBean.getTotalSwapSpaceSize();
    }

    @Override
    public long getFreeSwapSpaceSize() {
        return this.osMXBean.getFreeSwapSpaceSize();
    }

    @Override
    public String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "127.0.0.1";
        }
    }
}

