/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.actions;

import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;

public class FindAction
extends AbstractAction {
    private final ControllerAdapter controller;
    private ArrayList findNodesUnfoldedByLastFind;
    private MindMapNode findFromNode;
    private String searchTerm;
    private Collection subterms;
    private boolean findCaseSensitive;
    private LinkedList findNodeQueue;
    private JDialog mDialog;
    private int mResult;
    private JCheckBox mFindInNotesTooBox;
    private JTextField mSearchField;
    private String mLastSearchString;

    public Collection getSubterms() {
        return this.subterms;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public String getFindFromText() {
        String plainNodeText = HtmlTools.htmlToPlain(this.findFromNode.toString()).replaceAll("\n", " ");
        return plainNodeText.length() <= 30 ? plainNodeText : plainNodeText.substring(0, 30) + "...";
    }

    public FindAction(ControllerAdapter controller) {
        super(controller.getText("find"), new ImageIcon(controller.getResource("images/filefind.png")));
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.displayDialog();
        if (this.mResult != 0) {
            return;
        }
        String what = this.mSearchField.getText();
        if (what == null || what.equals("")) {
            return;
        }
        Collection subterms = this.breakSearchTermIntoSubterms(what);
        this.searchTerm = what;
        boolean found = this.find(this.controller.getSelected(), subterms, false);
        this.controller.getView().repaint();
        if (!found) {
            String messageText = this.controller.getText("no_found_from");
            String searchTerm = this.getSearchTermAsEscapedString(messageText);
            this.controller.getController().informationMessage(messageText.replaceAll("\\$1", searchTerm).replaceAll("\\$2", this.getFindFromText()), this.controller.getView().getSelected());
        }
    }

    private void close(int pResult) {
        this.mResult = pResult;
        this.mDialog.setVisible(false);
        this.mDialog.dispose();
        if (pResult == 0) {
            Resources.getInstance().getProperties().setProperty("resources_search_in_notes_too", this.mFindInNotesTooBox.isSelected() ? "true" : "false");
            this.mLastSearchString = this.mSearchField.getText();
        }
    }

    void displayDialog() {
        this.mDialog = null;
        this.mDialog = new JDialog((Frame)this.controller.getFrame().getJFrame(), this.controller.getText("find"));
        this.mDialog.setModal(true);
        this.mDialog.setDefaultCloseOperation(0);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                FindAction.this.close(2);
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                FindAction.this.close(0);
            }
        };
        Tools.addEscapeActionToDialog(this.mDialog, cancelAction);
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pE) {
                FindAction.this.close(2);
            }
        });
        Container contentPane = this.mDialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)new JLabel(this.controller.getText("find_what")), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.mSearchField = new JTextField(this.mLastSearchString);
        this.mSearchField.selectAll();
        this.mSearchField.setMinimumSize(new Dimension(500, 14));
        contentPane.add((Component)this.mSearchField, new GridBagConstraints(2, 0, 10, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        ImageIcon findImage = new ImageIcon(Resources.getInstance().getResource("images/filefind_big.png"));
        contentPane.add((Component)new JLabel(findImage), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.mFindInNotesTooBox = new JCheckBox(this.controller.getText("ExtendedFindDialog.find_search_in_notes_too"));
        this.mFindInNotesTooBox.setSelected(Resources.getInstance().getBoolProperty("resources_search_in_notes_too"));
        Tools.setLabelAndMnemonic(this.mFindInNotesTooBox, null);
        contentPane.add((Component)this.mFindInNotesTooBox, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        JButton okButton = new JButton(this.controller.getText("ExtendedFindDialog.ok"));
        Tools.setLabelAndMnemonic(okButton, null);
        okButton.addActionListener(okAction);
        contentPane.add((Component)okButton, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        JButton cancelButton = new JButton(this.controller.getText("ExtendedFindDialog.cancel"));
        Tools.setLabelAndMnemonic(cancelButton, null);
        cancelButton.addActionListener(cancelAction);
        contentPane.add((Component)cancelButton, new GridBagConstraints(3, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.mDialog.getRootPane().setDefaultButton(okButton);
        this.mDialog.pack();
        Tools.setDialogLocationRelativeTo(this.mDialog, this.controller.getSelectedView());
        this.mDialog.setVisible(true);
    }

    private String getSearchTermAsEscapedString(String messageText) {
        String searchTerm = messageText.startsWith("<html>") ? HtmlTools.toXMLEscapedText(this.getSearchTerm()) : this.getSearchTerm();
        searchTerm = searchTerm.replace("$", "\\$");
        return searchTerm;
    }

    public boolean find(MindMapNode node, Collection subterms, boolean caseSensitive) {
        ArrayList<String> finalizedSubterms;
        this.findNodesUnfoldedByLastFind = new ArrayList();
        LinkedList<MindMapNode> nodes = new LinkedList<MindMapNode>();
        nodes.addFirst(node);
        this.findFromNode = node;
        if (!caseSensitive) {
            finalizedSubterms = new ArrayList<String>();
            Iterator i = subterms.iterator();
            while (i.hasNext()) {
                finalizedSubterms.add(((String)i.next()).toLowerCase());
            }
        } else {
            finalizedSubterms = subterms;
        }
        return this.find(nodes, finalizedSubterms, caseSensitive);
    }

    private boolean find(LinkedList nodes, Collection subterms, boolean caseSensitive) {
        boolean thereWereNodesToBeFolded;
        boolean searchInNotesToo = Resources.getInstance().getBoolProperty("resources_search_in_notes_too");
        boolean bl = thereWereNodesToBeFolded = !this.findNodesUnfoldedByLastFind.isEmpty();
        if (!this.findNodesUnfoldedByLastFind.isEmpty()) {
            ListIterator i = this.findNodesUnfoldedByLastFind.listIterator(this.findNodesUnfoldedByLastFind.size());
            while (i.hasPrevious()) {
                MindMapNode node = (MindMapNode)i.previous();
                try {
                    this.controller.setFolded(node, true);
                }
                catch (Exception e) {}
            }
            this.findNodesUnfoldedByLastFind = new ArrayList();
        }
        while (!nodes.isEmpty()) {
            MindMapNode node = (MindMapNode)nodes.removeFirst();
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                nodes.addLast(i.next());
            }
            if (!node.isVisible()) continue;
            String nodeText = node.toString();
            nodeText = this.prepareTextContent(caseSensitive, nodeText);
            String noteText = node.getNoteText();
            noteText = this.prepareTextContent(caseSensitive, noteText);
            boolean found = true;
            boolean foundInNotes = false;
            Iterator i2 = subterms.iterator();
            while (i2.hasNext()) {
                if (nodeText.indexOf((String)i2.next()) >= 0) continue;
                found = false;
                break;
            }
            if (!found && searchInNotesToo) {
                found = true;
                i2 = subterms.iterator();
                while (i2.hasNext()) {
                    if (noteText.indexOf((String)i2.next()) >= 0) continue;
                    found = false;
                    break;
                }
                foundInNotes = true;
            }
            if (!found) continue;
            this.displayNode(node, this.findNodesUnfoldedByLastFind);
            this.centerNode(node);
            if (foundInNotes) {
                // empty if block
            }
            this.subterms = subterms;
            this.findCaseSensitive = caseSensitive;
            this.findNodeQueue = nodes;
            return true;
        }
        this.centerNode(this.findFromNode);
        return false;
    }

    public String prepareTextContent(boolean caseSensitive, String nodeText) {
        if (nodeText == null) {
            nodeText = "";
        }
        if (HtmlTools.isHtmlNode(nodeText)) {
            nodeText = HtmlTools.removeHtmlTagsFromString(nodeText);
            nodeText = HtmlTools.unescapeHTMLUnicodeEntity(nodeText);
        }
        if (!caseSensitive) {
            nodeText = nodeText.toLowerCase();
        }
        return nodeText;
    }

    private Collection breakSearchTermIntoSubterms(String searchTerm) {
        ArrayList<String> subterms = new ArrayList<String>();
        StringBuffer subterm = new StringBuffer();
        int len = searchTerm.length();
        int previousChar = 97;
        boolean withinQuotes = false;
        for (int i = 0; i < len; ++i) {
            char myChar = searchTerm.charAt(i);
            if (myChar == ' ' && withinQuotes) {
                subterm.append(myChar);
            } else if (myChar == ' ' && !withinQuotes) {
                subterms.add(subterm.toString());
                subterm.setLength(0);
            } else if (myChar == '\"' && i > 0 && i < len - 1 && searchTerm.charAt(i - 1) != ' ' && searchTerm.charAt(i + 1) != ' ') {
                subterm.append(myChar);
            } else if (myChar == '\"' && withinQuotes) {
                withinQuotes = false;
            } else if (myChar == '\"' && !withinQuotes) {
                withinQuotes = true;
            } else {
                subterm.append(myChar);
            }
            previousChar = myChar;
        }
        subterms.add(subterm.toString());
        return subterms;
    }

    public void displayNode(MindMapNode node, ArrayList nodesUnfoldedByDisplay) {
        TreeNode[] path = this.controller.getMap().getPathToRoot(node);
        for (int i = 0; i < path.length - 1; ++i) {
            MindMapNode nodeOnPath = (MindMapNode)path[i];
            if (!nodeOnPath.isFolded()) continue;
            if (nodesUnfoldedByDisplay != null) {
                nodesUnfoldedByDisplay.add(nodeOnPath);
            }
            this.controller.setFolded(nodeOnPath, false);
        }
    }

    public boolean findNext() {
        if (this.subterms != null) {
            return this.find(this.findNodeQueue, this.subterms, this.findCaseSensitive);
        }
        return false;
    }

    private void centerNode(MindMapNode node) {
        this.controller.centerNode(node);
    }

    public static class FindNextAction
    extends AbstractAction {
        private final ControllerAdapter controller;
        private final FindAction find;

        public FindNextAction(ControllerAdapter controller, FindAction find) {
            super(controller.getText("find_next"));
            this.controller = controller;
            this.find = find;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection subterms = this.find.getSubterms();
            if (subterms == null) {
                this.controller.getController().informationMessage(this.controller.getText("no_previous_find"), this.controller.getView().getSelected());
                return;
            }
            boolean found = this.find.findNext();
            this.controller.getView().repaint();
            if (!found) {
                String messageText = this.controller.getText("no_more_found_from");
                String searchTerm = this.find.getSearchTermAsEscapedString(messageText);
                this.controller.getController().informationMessage(messageText.replaceAll("\\$1", searchTerm).replaceAll("\\$2", this.find.getFindFromText()), this.controller.getView().getSelected());
            }
        }
    }
}

