/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Horario do meridiano de Greenwich",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "Horario est\u00e1ndar de Apia",
               "",
               "Horario de ver\u00e1n de Apia",
               "",
               "Horario de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Horario est\u00e1ndar das Illas Cook",
               "",
               "Horario de ver\u00e1n medio das Illas Cook",
               "",
               "Horario das Illas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Horario est\u00e1ndar de Cuba",
               "",
               "Horario de ver\u00e1n de Cuba",
               "",
               "Horario de Cuba",
               "",
            };
        final String[] Fiji = new String[] {
               "Horario est\u00e1ndar de Fixi",
               "",
               "Horario de ver\u00e1n de Fixi",
               "",
               "Horario de Fixi",
               "",
            };
        final String[] Gulf = new String[] {
               "Horario do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Horario est\u00e1ndar de Hovd",
               "",
               "Horario de ver\u00e1n de Hovd",
               "",
               "Horario de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Horario est\u00e1ndar de Ir\u00e1n",
               "",
               "Horario de ver\u00e1n de Ir\u00e1n",
               "",
               "Horario de Ir\u00e1n",
               "",
            };
        final String[] Niue = new String[] {
               "Horario de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Horario est\u00e1ndar de Omsk",
               "",
               "Horario de ver\u00e1n de Omsk",
               "",
               "Horario de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Horario est\u00e1ndar do Per\u00fa",
               "",
               "Horario de ver\u00e1n do Per\u00fa",
               "",
               "Horario do Per\u00fa",
               "",
            };
        final String[] Truk = new String[] {
               "Horario de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Horario da Illa Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Horario est\u00e1ndar de Chile",
               "",
               "Horario de ver\u00e1n de Chile",
               "",
               "Horario de Chile",
               "",
            };
        final String[] China = new String[] {
               "Horario est\u00e1ndar da China",
               "",
               "Horario de ver\u00e1n da China",
               "",
               "Horario da China",
               "",
            };
        final String[] Cocos = new String[] {
               "Horario das Illas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Horario de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Horario da India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Horario est\u00e1ndar do Xap\u00f3n",
               "",
               "Horario de ver\u00e1n do Xap\u00f3n",
               "",
               "Horario do Xap\u00f3n",
               "",
            };
        final String[] Korea = new String[] {
               "Horario est\u00e1ndar de Corea",
               "",
               "Horario de ver\u00e1n de Corea",
               "",
               "Horario de Corea",
               "",
            };
        final String[] Nauru = new String[] {
               "Horario de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Horario de Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Horario de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Horario est\u00e1ndar de Samoa",
               "",
               "Horario de ver\u00e1n de Samoa",
               "",
               "Horario de Samoa",
               "",
            };
        final String[] Syowa = new String[] {
               "Horario de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Horario est\u00e1ndar de Tonga",
               "",
               "Horario de ver\u00e1n de Tonga",
               "",
               "Horario de Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "Horario est\u00e1ndar de Alasca",
               "",
               "Horario de ver\u00e1n de Alasca",
               "",
               "Horario de Alasca",
               "",
            };
        final String[] Amazon = new String[] {
               "Horario est\u00e1ndar do Amazonas",
               "",
               "Horario de ver\u00e1n do Amazonas",
               "",
               "Horario do Amazonas",
               "",
            };
        final String[] Anadyr = new String[] {
               "Horario est\u00e1ndar de Anadir",
               "",
               "Horario de ver\u00e1n de Anadir",
               "",
               "Horario de Anadir",
               "",
            };
        final String[] Azores = new String[] {
               "Horario est\u00e1ndar dos Azores",
               "",
               "Horario de ver\u00e1n dos Azores",
               "",
               "Horario dos Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Horario de But\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Horario de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Horario est\u00e1ndar da Illa de Pascua",
               "",
               "Horario de ver\u00e1n da Illa de Pascua",
               "",
               "Horario da Illa de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "Horario da G\u00fciana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Horario est\u00e1ndar de Israel",
               "",
               "Horario de ver\u00e1n de Israel",
               "",
               "Horario de Israel",
               "",
            };
        final String[] Kosrae = new String[] {
               "Horario de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Horario de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Horario est\u00e1ndar de Moscova",
               "",
               "Horario de ver\u00e1n de Moscova",
               "",
               "Horario de Moscova",
               "",
            };
        final String[] Ponape = new String[] {
               "Horario de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Horario est\u00e1ndar de Samara",
               "",
               "Horario de ver\u00e1n de Samara",
               "",
               "Horario de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Horario de Tahit\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Horario est\u00e1ndar de Taipei",
               "",
               "Horario de ver\u00e1n de Taipei",
               "",
               "Horario de Taipei",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Horario de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Horario de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Horario de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Horario est\u00e1ndar \u00e1rabe",
               "",
               "Horario de ver\u00e1n \u00e1rabe",
               "",
               "Horario \u00e1rabe",
               "",
            };
        final String[] Armenia = new String[] {
               "Horario est\u00e1ndar de Armenia",
               "",
               "Horario de ver\u00e1n de Armenia",
               "",
               "Horario de Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Horario de Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Horario est\u00e1ndar de Chatham",
               "",
               "Horario de ver\u00e1n de Chatham",
               "",
               "Horario de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Horario universal coordinado",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Horario de Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Horario de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Horario est\u00e1ndar de Xeorxia",
               "",
               "Horario de ver\u00e1n de Xeorxia",
               "",
               "Horario de Xeorxia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Horario est\u00e1ndar de Irkutsk",
               "",
               "Horario de ver\u00e1n de Irkutsk",
               "",
               "Horario de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Horario est\u00e1ndar de Magadan",
               "",
               "Horario de ver\u00e1n de Magadan",
               "",
               "Horario de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Horario de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Horario est\u00e1ndar da Illa Norfolk",
               "",
               "Horario de ver\u00e1n da Illa Norfolk",
               "",
               "Horario da Illa Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Horario est\u00e1ndar de Fernando de Noronha",
               "",
               "Horario de ver\u00e1n de Fernando de Noronha",
               "",
               "Horario de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Horario de Reuni\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Horario de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Horario das Illas Salom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Horario de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Horario est\u00e1ndar do Uruguai",
               "",
               "Horario de ver\u00e1n do Uruguai",
               "",
               "Horario do Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Horario est\u00e1ndar de Vanuatu",
               "",
               "Horario de ver\u00e1n de Vanuatu",
               "",
               "Horario de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Horario est\u00e1ndar de Iakutsk",
               "",
               "Horario de ver\u00e1n de Iakutsk",
               "",
               "Horario de Iakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Horario est\u00e1ndar do Atl\u00e1ntico",
               "",
               "Horario de ver\u00e1n do Atl\u00e1ntico",
               "",
               "Horario do Atl\u00e1ntico",
               "",
            };
        final String[] Brasilia = new String[] {
               "Horario est\u00e1ndar de Brasilia",
               "",
               "Horario de ver\u00e1n de Brasilia",
               "",
               "Horario de Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Horario est\u00e1ndar chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Horario est\u00e1ndar de Colombia",
               "",
               "Horario de ver\u00e1n de Colombia",
               "",
               "Horario de Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Horario est\u00e1ndar das Illas Malvinas",
               "",
               "Horario de ver\u00e1n das Illas Malvinas",
               "",
               "Horario das Illas Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "Horario de Malaisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Horario das Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Horario est\u00e1ndar de Ulaanbaatar",
               "",
               "Horario de ver\u00e1n de Ulaanbaatar",
               "",
               "Horario de Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Horario est\u00e1ndar de Paquist\u00e1n",
               "",
               "Horario de ver\u00e1n de Paquist\u00e1n",
               "",
               "Horario de Paquist\u00e1n",
               "",
            };
        final String[] Paraguay = new String[] {
               "Horario est\u00e1ndar do Paraguai",
               "",
               "Horario de ver\u00e1n do Paraguai",
               "",
               "Horario do Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Horario de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Horario est\u00e1ndar de Sakhal\u00edn",
               "",
               "Horario de ver\u00e1n de Sakhal\u00edn",
               "",
               "Horario de Sakhal\u00edn",
               "",
            };
        final String[] Suriname = new String[] {
               "Horario de Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Horario est\u00e1ndar da Arxentina",
               "",
               "Horario de ver\u00e1n da Arxentina",
               "",
               "Horario da Arxentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Horario da Illa Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Horario das Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Horario est\u00e1ndar de Hong Kong",
               "",
               "Horario de ver\u00e1n de Hong Kong",
               "",
               "Horario de Hong Kong",
               "",
            };
        final String[] Indochina = new String[] {
               "Horario de Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Horario est\u00e1ndar de Petrop\u00e1vlovsk-Kamchatski",
               "",
               "Horario de ver\u00e1n de Petrop\u00e1vlovsk-Kamchatski",
               "",
               "Horario de Petrop\u00e1vlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Horario de Kirguizist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Horario est\u00e1ndar de Lord Howe",
               "",
               "Horario de ver\u00e1n de Lord Howe",
               "",
               "Horario de Lord Howe",
               "",
            };
        final String[] Macquarie = new String[] {
               "Horario da Illa Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "Horario das Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Horario est\u00e1ndar de Mauricio",
               "",
               "Horario de ver\u00e1n de Mauricio",
               "",
               "Horario de Mauricio",
               "",
            };
        final String[] Singapore = new String[] {
               "Horario de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Horario de Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Horario est\u00e1ndar de Volgogrado",
               "",
               "Horario de ver\u00e1n de Volgogrado",
               "",
               "Horario de Volgogrado",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Horario est\u00e1ndar de Acerbaix\u00e1n",
               "",
               "Horario de ver\u00e1n de Acerbaix\u00e1n",
               "",
               "Horario de Acerbaix\u00e1n",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Horario est\u00e1ndar de Bangladesh",
               "",
               "Horario de ver\u00e1n de Bangladesh",
               "",
               "Horario de Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Horario est\u00e1ndar de Cabo Verde",
               "",
               "Horario de ver\u00e1n de Cabo Verde",
               "",
               "Horario de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Horario de Timor Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Horario das Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Horario de Taxiquist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Horario est\u00e1ndar de Uzbekist\u00e1n",
               "",
               "Horario de ver\u00e1n de Uzbekist\u00e1n",
               "",
               "Horario de Uzbekist\u00e1n",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Horario de Afganist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Horario est\u00e1ndar de Krasnoiarsk",
               "",
               "Horario de ver\u00e1n de Krasnoiarsk",
               "",
               "Horario de Krasnoiarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Horario est\u00e1ndar de Nova Zelandia",
               "",
               "Horario de ver\u00e1n de Nova Zelandia",
               "",
               "Horario de Nova Zelandia",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Horario est\u00e1ndar de Novosibirsk",
               "",
               "Horario de ver\u00e1n de Novosibirsk",
               "",
               "Horario de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Horario est\u00e1ndar de Filipinas",
               "",
               "Horario de ver\u00e1n de Filipinas",
               "",
               "Horario de Filipinas",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Horario est\u00e1ndar de Vladivostok",
               "",
               "Horario de ver\u00e1n de Vladivostok",
               "",
               "Horario de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Horario do Oc\u00e9ano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Horario das Illas da Li\u00f1a",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Horario est\u00e1ndar de Terra Nova",
               "",
               "Horario de ver\u00e1n de Terra Nova",
               "",
               "Horario de Terra Nova",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Horario est\u00e1ndar de Turkmenist\u00e1n",
               "",
               "Horario de ver\u00e1n de Turkmenist\u00e1n",
               "",
               "Horario de Turkmenist\u00e1n",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Horario da G\u00fciana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Horario est\u00e1ndar de Nova Caledonia",
               "",
               "Horario de ver\u00e1n de Nova Caledonia",
               "",
               "Horario de Nova Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Horario de Xeorxia do Sur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Horario est\u00e1ndar de Ekaterimburgo",
               "",
               "Horario de ver\u00e1n de Ekaterimburgo",
               "",
               "Horario de Ekaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Horario de \u00c1frica Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Horario de \u00c1frica Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Horario est\u00e1ndar de \u00c1frica Occidental",
               "",
               "Horario de ver\u00e1n de \u00c1frica Occidental",
               "",
               "Horario de \u00c1frica Occidental",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Horario de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Horario est\u00e1ndar de Europa Central",
               "CET",
               "Horario de ver\u00e1n de Europa Central",
               "CEST",
               "Horario de Europa Central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Horario est\u00e1ndar de Europa Oriental",
               "EET",
               "Horario de ver\u00e1n de Europa Oriental",
               "EEST",
               "Horario de Europa Oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Horario est\u00e1ndar de Europa Occidental",
               "WET",
               "Horario de ver\u00e1n de Europa Occidental",
               "WEST",
               "Horario de Europa Occidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Horario est\u00e1ndar do Pac\u00edfico mexicano",
               "",
               "Horario de ver\u00e1n do Pac\u00edfico mexicano",
               "",
               "Horario do Pac\u00edfico mexicano",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Horario de \u00c1frica Meridional",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Horario est\u00e1ndar central, Norteam\u00e9rica",
               "",
               "Horario de ver\u00e1n central, Norteam\u00e9rica",
               "",
               "Horario central, Norteam\u00e9rica",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Horario est\u00e1ndar do leste, Am\u00e9rica do Norte",
               "",
               "Horario de ver\u00e1n do leste, Am\u00e9rica do Norte",
               "",
               "Horario do leste, Am\u00e9rica do Norte",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Horario est\u00e1ndar do Pac\u00edfico, Am\u00e9rica do Norte",
               "",
               "Horario de ver\u00e1n do Pac\u00edfico, Am\u00e9rica do Norte",
               "",
               "Horario do Pac\u00edfico, Am\u00e9rica do Norte",
               "",
            };
        final String[] French_Southern = new String[] {
               "Horario das Terras Austrais e Ant\u00e1rticas Francesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Horario das Illas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Horario est\u00e1ndar de Hawai-illas Aleutianas",
               "",
               "Horario de ver\u00e1n de Hawai-illas Aleutianas",
               "",
               "Horario de Hawai-illas Aleutianas",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Horario das Illas F\u00e9nix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Horario est\u00e1ndar de Saint Pierre et Miquelon",
               "",
               "Horario de ver\u00e1n de Saint Pierre et Miquelon",
               "",
               "Horario de Saint Pierre et Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Horario est\u00e1ndar da monta\u00f1a, Am\u00e9rica do Norte",
               "",
               "Horario de ver\u00e1n da monta\u00f1a, Am\u00e9rica do Norte",
               "",
               "Horario da monta\u00f1a, Am\u00e9rica do Norte",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Horario das Illas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Horario est\u00e1ndar do noroeste de M\u00e9xico",
               "",
               "Horario de ver\u00e1n do noroeste de M\u00e9xico",
               "",
               "Horario do noroeste de M\u00e9xico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Horario de Pap\u00faa-Nova Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Horario est\u00e1ndar de Australia Central",
               "",
               "Horario de ver\u00e1n de Australia Central",
               "",
               "Horario de Australia Central",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Horario est\u00e1ndar de Australia Oriental",
               "",
               "Horario de ver\u00e1n de Australia Oriental",
               "",
               "Horario de Australia Oriental",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Horario est\u00e1ndar de Australia Occidental",
               "",
               "Horario de ver\u00e1n de Australia Occidental",
               "",
               "Horario de Australia Occidental",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Horario est\u00e1ndar de Groenlandia Oriental",
               "",
               "Horario de ver\u00e1n de Groenlandia Oriental",
               "",
               "Horario de Groenlandia Oriental",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Horario est\u00e1ndar de Groenlandia Occidental",
               "",
               "Horario de ver\u00e1n de Groenlandia Occidental",
               "",
               "Horario de Groenlandia Occidental",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Horario de Indonesia Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Horario de Indonesia Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Horario de Indonesia Occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Horario de Kazakist\u00e1n Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Horario de Kazakist\u00e1n Occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Horario est\u00e1ndar de Australia Occidental Central",
               "",
               "Horario de ver\u00e1n de Australia Occidental Central",
               "",
               "Horario de Australia Occidental Central",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Horario do meridiano de Greenwich",
                    "GMT",
                    "Horario est\u00e1ndar irland\u00e9s",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Horario do meridiano de Greenwich",
                    "GMT",
                    "Horario de ver\u00e1n brit\u00e1nico",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", America_Pacific },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Horario do meridiano de Greenwich",
                    "GMT",
                    "Horario de ver\u00e1n brit\u00e1nico",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Pacific },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Ad\u00e9n" },
            { "timezone.excity.Asia/Baku", "Bac\u00fa" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Am\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Chit\u00e1" },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "timezone.excity.Asia/Kabul", "Cabul" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.Asia/Seoul", "Se\u00fal" },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Asia/Hebron", "Hebr\u00f3n" },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "Cidade desco\u00f1ecida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Cairo", "O Cairo" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "Tunes" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "Iacarta" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Yakutsk", "Iakutsk" },
            { "timezone.excity.Asia/Yerevan", "Ierev\u00e1n" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Sofia", "Sof\u00eda" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fixi" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamaco" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaca" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Ba\u00eda" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "Achkhabad" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "timezone.excity.Asia/Qostanay", "Qostanai" },
            { "timezone.excity.Asia/Sakhalin", "Sakhal\u00edn" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Dublin", "Dubl\u00edn" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "M\u00f3naco" },
            { "timezone.excity.Europe/Moscow", "Moscova" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Alxer" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.America/Cayman", "Illas Caim\u00e1n" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "G\u00fciana" },
            { "timezone.excity.America/Havana", "A Habana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "A Paz" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.Asia/Jerusalem", "Xerusal\u00e9n" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Europe/Vatican", "Vaticano" },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00f3n" },
            { "timezone.excity.Pacific/Easter", "Illa de Pascua" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Tahit\u00ed" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.Africa/El_Aaiun", "O Ai\u00fan" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Khart\u00fan" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.Africa/Sao_Tome", "San Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Xamaica" },
            { "timezone.excity.America/Managua", "Managua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "T\u00f3rtola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Atlantic/Azores", "Azores" },
            { "timezone.excity.Atlantic/Canary", "Illas Canarias" },
            { "timezone.excity.Atlantic/Faeroe", "Feroe" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruxelas" },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.Europe/Helsinki", "Helsinqui" },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Saraievo" },
            { "timezone.excity.Europe/Uzhgorod", "Uzghorod" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadixo" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "Nova York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Santa Luc\u00eda" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Illas Bermudas" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sidney" },
            { "timezone.excity.Europe/Amsterdam", "\u00c1msterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrak\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Xibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Christmas", "Illa Christmas" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Mauricio" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolul\u00fa" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simfer\u00f3pol" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporizhia" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Illas Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Ad\u00eds Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugu" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "R\u00edo Branco" },
            { "timezone.excity.America/St_Vincent", "San Vicente" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Reiquiavik" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Illa de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Xohanesburgo" },
            { "timezone.excity.America/El_Salvador", "O Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Os \u00c1nxeles" },
            { "timezone.excity.America/Mexico_City", "Cidade de M\u00e9xico" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indian\u00e1polis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Porto Espa\u00f1a" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Porto Pr\u00edncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Xeorxia do Sur" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont-d\u2019Urville" },
            { "timezone.excity.America/Argentina/La_Rioja", "A Rioxa" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dacota do Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dacota do Norte" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dacota do Norte" },
        };
        return data;
    }
}
