/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hsb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gujarati";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "sbp", "sangu" },
            { "nyn", "nyankole" },
            { "luo", "luo" },
            { "Zsym", "symbole" },
            { "fil", "filipin\u0161\u0107ina" },
            { "luy", "luhya" },
            { "es_ES", "europska \u0161pani\u0161\u0107ina" },
            { "scn", "sicil\u0161\u0107ina" },
            { "teo", "teso" },
            { "aa", "afar\u0161\u0107ina" },
            { "ab", "abchazi\u0161\u0107ina" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Zjedno\u0107ene arabske emiraty" },
            { "nl_BE", "flam\u0161\u0107ina" },
            { "AF", "Afghanistan" },
            { "af", "afrikaan\u0161\u0107ina" },
            { "AG", "Antigua a Barbuda" },
            { "type.ca.ethiopic", "etiopiska protyka" },
            { "AI", "Anguilla" },
            { "ak", "akan\u0161\u0107ina" },
            { "AL", "Albanska" },
            { "AM", "Armenska" },
            { "am", "amhar\u0161\u0107ina" },
            { "an", "aragon\u0161\u0107ina" },
            { "Arab", "arabsce" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "Jpan", "japansce" },
            { "AR", "Argentinska" },
            { "ar", "arab\u0161\u0107ina" },
            { "AS", "Ameriska Samoa" },
            { "as", "asam\u0161\u0107ina" },
            { "AT", "Awstriska" },
            { "AU", "Awstralska" },
            { "av", "awar\u0161\u0107ina" },
            { "AW", "Aruba" },
            { "en_US", "ameriska jend\u017ael\u0161\u0107ina" },
            { "AX", "\u00c5land" },
            { "ay", "aymar\u0161\u0107ina" },
            { "AZ", "Azerbajd\u017aan" },
            { "az", "azerbajd\u017aan\u0161\u0107ina" },
            { "BA", "Bosniska a Hercegowina" },
            { "ba", "ba\u0161kir\u0161\u0107ina" },
            { "BB", "Barbados" },
            { "BD", "Banglade\u0161" },
            { "BE", "Belgiska" },
            { "be", "b\u011b\u0142oru\u0161\u0107ina" },
            { "BF", "Burkina Faso" },
            { "BG", "Bo\u0142harska" },
            { "bg", "bo\u0142har\u0161\u0107ina" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "bi", "bislam\u0161\u0107ina" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermudy" },
            { "bm", "bambara" },
            { "BN", "Brunei" },
            { "bn", "bengal\u0161\u0107ina" },
            { "BO", "Boliwiska" },
            { "bo", "tibet\u0161\u0107ina" },
            { "BQ", "Karibiska Ni\u017eozemska" },
            { "BR", "Brazilska" },
            { "br", "breton\u0161\u0107ina" },
            { "BS", "Bahamy" },
            { "bs", "bosni\u0161\u0107ina" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetowa kupa" },
            { "BW", "Botswana" },
            { "Mymr", "burmasce" },
            { "type.nu.laoo", "laoske cyfry" },
            { "BY", "B\u011b\u0142oruska" },
            { "seh", "sena" },
            { "BZ", "Belize" },
            { "type.ca.persian", "persiska protyka" },
            { "type.nu.hebr", "hebrejske cyfry" },
            { "CA", "Kanada" },
            { "ca", "katalan\u0161\u0107ina" },
            { "CC", "Kokosowe kupy" },
            { "ses", "koyra senni" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralnoafriska republika" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "\u0160wicarska" },
            { "ch", "\u010damor\u0161\u0107ina" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cookowe kupy" },
            { "CL", "Chilska" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbiska" },
            { "co", "korsi\u0161\u0107ina" },
            { "CP", "Clippertonowa kupa" },
            { "Orya", "oriya" },
            { "CR", "Kosta Rika" },
            { "cr", "kri" },
            { "cs", "\u010d\u011b\u0161\u0107ina" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Hodowna kupa" },
            { "CY", "Cypern" },
            { "cy", "walizi\u0161\u0107ina" },
            { "CZ", "\u010c\u011bska republika" },
            { "type.nu.ethi", "etiopiske cyfry" },
            { "da", "dan\u0161\u0107ina" },
            { "pt_PT", "europska portugal\u0161\u0107ina" },
            { "DE", "N\u011bmska" },
            { "de", "n\u011bm\u010dina" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "devanagari-cyfry" },
            { "DJ", "D\u017aibuti" },
            { "DK", "Danska" },
            { "Brai", "Braillowe pismo" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "armenske cyfry, ma\u0142e pisane" },
            { "DO", "Dominikanska republika" },
            { "bem", "bemba" },
            { "got", "got\u0161\u0107ina" },
            { "dv", "divehi" },
            { "es_419", "\u0142a\u0107onskoameriska \u0161pani\u0161\u0107ina" },
            { "DZ", "Algeriska" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "chinska protyka" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ekwador" },
            { "dje", "zarma" },
            { "type.nu.grek", "grjekske cyfry" },
            { "EE", "Estiska" },
            { "ee", "ewe" },
            { "EG", "Egyptowska" },
            { "EH", "Zapadna Sahara" },
            { "ro_MD", "moldaw\u0161\u0107ina" },
            { "el", "grjek\u0161\u0107ina" },
            { "en", "jend\u017ael\u0161\u0107ina" },
            { "eo", "esperanto" },
            { "cho", "choctaw\u0161\u0107ina" },
            { "chr", "cherokee" },
            { "ER", "Eritreja" },
            { "ES", "\u0160paniska" },
            { "es", "\u0161pani\u0161\u0107ina" },
            { "ET", "Etiopiska" },
            { "et", "esti\u0161\u0107ina" },
            { "EU", "Europska unija" },
            { "eu", "baski\u0161\u0107ina" },
            { "Hang", "hangul" },
            { "type.ca.gregorian", "gregorianska protyka" },
            { "shi", "ta\u0161elhit" },
            { "type.nu.gujr", "gujarati-cyfry" },
            { "hsb", "hornjoserb\u0161\u0107ina" },
            { "Hani", "chinsce" },
            { "fa", "persi\u0161\u0107ina" },
            { "Hans", "zjednorjene" },
            { "type.nu.latn", "arabske cyfry" },
            { "Hant", "tradicionalne" },
            { "FI", "Finska" },
            { "fi", "fin\u0161\u0107ina" },
            { "FJ", "Fid\u017ai" },
            { "fj", "fid\u017ai\u0161\u0107ina" },
            { "FK", "Falklandske kupy" },
            { "FM", "Mikroneziska" },
            { "FO", "F\u00e4r\u00f6ske kupy" },
            { "fo", "f\u00e4r\u00f6\u0161\u0107ina" },
            { "Taml", "tamilsce" },
            { "FR", "Francoska" },
            { "fr", "franco\u0161\u0107ina" },
            { "fy", "frizi\u0161\u0107ina" },
            { "GA", "Gabun" },
            { "ga", "ir\u0161\u0107ina" },
            { "GB", "Zjedno\u0107ene kralestwo" },
            { "GD", "Grenada" },
            { "gd", "\u0161otiska gel\u0161\u0107ina" },
            { "GE", "Georgiska" },
            { "GF", "Francoska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nlandska" },
            { "gl", "galici\u0161\u0107ina" },
            { "GM", "Gambija" },
            { "GN", "Gineja" },
            { "gn", "guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekwatorialna Gineja" },
            { "und", "njeznata r\u011b\u010d" },
            { "GR", "Grjekska" },
            { "GS", "Ju\u017ena Georgiska a Ju\u017ene Sandwichowe kupy" },
            { "GT", "Guatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "man\u0161\u0107ina" },
            { "GW", "Gineja-Bissau" },
            { "GY", "Guyana" },
            { "ha", "hausa" },
            { "ckb", "sorani" },
            { "zxx", "\u017eadyn r\u011b\u010dny wobsah" },
            { "he", "hebrej\u0161\u0107ina" },
            { "hi", "hindi\u0161\u0107ina" },
            { "de_AT", "awstriska n\u011bm\u010dina" },
            { "HK", "Wosebita zarjadniska cona Hongkong" },
            { "HM", "Heardowa kupa a McDonaldowe kupy" },
            { "HN", "Honduras" },
            { "HR", "Chorwatska" },
            { "hr", "chorwat\u0161\u0107ina" },
            { "agq", "aghem\u0161\u0107ina" },
            { "gsw", "\u0161wicarska n\u011bm\u010dina" },
            { "HT", "Haiti" },
            { "ht", "haiti\u0161\u0107ina" },
            { "HU", "Mad\u017aarska" },
            { "hu", "mad\u017aar\u0161\u0107ina" },
            { "hy", "armen\u0161\u0107ina" },
            { "ia", "interlingua" },
            { "IC", "Kanariske kupy" },
            { "ID", "Indoneska" },
            { "id", "indone\u0161\u0107ina" },
            { "type.nu.tibt", "tibetske cyfry" },
            { "IE", "Irska" },
            { "ig", "igbo" },
            { "naq", "nama" },
            { "ii", "sichuan yi" },
            { "ik", "inupiak" },
            { "IL", "Israel" },
            { "IM", "Man" },
            { "IN", "Indiska" },
            { "IO", "Britiski teritorij w Indiskim oceanje" },
            { "io", "ido" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandska" },
            { "is", "island\u0161\u0107ina" },
            { "IT", "Italska" },
            { "it", "ital\u0161\u0107ina" },
            { "iu", "inuit\u0161\u0107ina" },
            { "type.nu.thai", "thailandske cyfry" },
            { "type.nu.beng", "bengalske cyfry" },
            { "ja", "japan\u0161\u0107ina" },
            { "Mlym", "malayalamsce" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamska protyka" },
            { "JM", "Jamaika" },
            { "Beng", "bengalsce" },
            { "JO", "Jordaniska" },
            { "JP", "Japanska" },
            { "sma", "ju\u017enosami\u0161\u0107ina" },
            { "jv", "java\u0161\u0107ina" },
            { "guz", "gusii" },
            { "type.nu.knda", "kannadske cyfry" },
            { "smj", "lule-sami\u0161\u0107ina" },
            { "de_CH", "\u0161wicarska wysokon\u011bm\u010dina" },
            { "smn", "inari-sami\u0161\u0107ina" },
            { "ka", "georgi\u0161\u0107ina" },
            { "type.ca.buddhist", "buddhistiska protyka" },
            { "sms", "skolt-sami\u0161\u0107ina" },
            { "KE", "Kenija" },
            { "419", "\u0141a\u0107onska Amerika" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambod\u017aa" },
            { "KI", "Kiribati" },
            { "ki", "kikuyu" },
            { "mas", "masai\u0161\u0107ina" },
            { "kk", "kazach\u0161\u0107ina" },
            { "kl", "gr\u00f6ndland\u0161\u0107ina" },
            { "KM", "Komory" },
            { "km", "khmer\u0161\u0107ina" },
            { "KN", "St. Kitts a Nevis" },
            { "kn", "kannad\u0161\u0107ina" },
            { "Knda", "kannadsce" },
            { "fr_CA", "kanadiska franco\u0161\u0107ina" },
            { "ko", "korej\u0161\u0107ina" },
            { "KP", "Sewjerna Koreja" },
            { "KR", "Ju\u017ena Koreja" },
            { "ks", "ka\u0161mir\u0161\u0107ina" },
            { "ku", "kurdi\u0161\u0107ina" },
            { "fr_CH", "\u0161wicarska franco\u0161\u0107ina" },
            { "KW", "Kuwait" },
            { "kw", "korni\u0161\u0107ina" },
            { "KY", "Kajmanske kupy" },
            { "ky", "kirgi\u0161\u0107ina" },
            { "KZ", "Kazachstan" },
            { "Cyrl", "kyrilisce" },
            { "LA", "Laos" },
            { "la", "\u0142a\u0107on\u0161\u0107ina" },
            { "LB", "Libanon" },
            { "lb", "luxemburg\u0161\u0107ina" },
            { "LC", "St. Lucia" },
            { "type.nu.mlym", "malayalamske cyfry" },
            { "lg", "gand\u0161\u0107ina" },
            { "nds", "delnjon\u011bm\u010dina" },
            { "LI", "Liechtenstein" },
            { "li", "limbur\u0161\u0107ina" },
            { "LK", "Sri Lanka" },
            { "Tibt", "tibetsce" },
            { "ln", "lingala" },
            { "lo", "lao\u0161\u0107ina" },
            { "LR", "Liberija" },
            { "LS", "Lesotho" },
            { "LT", "Litawska" },
            { "lt", "litaw\u0161\u0107ina" },
            { "LU", "Luxemburgska" },
            { "lu", "luba-katanga" },
            { "LV", "Letiska" },
            { "lv", "leti\u0161\u0107ina" },
            { "Kana", "katakana" },
            { "LY", "Libyska" },
            { "vun", "vunjo" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldawska" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "mg", "malagassi\u0161\u0107ina" },
            { "MH", "Marshallowe kupy" },
            { "Thai", "thailandsce" },
            { "type.co.ducet", "rjadowanski sl\u011bd po Unicode" },
            { "mi", "maor\u0161\u0107ina" },
            { "MK", "Makedonska" },
            { "mk", "makedon\u0161\u0107ina" },
            { "ML", "Mali" },
            { "ml", "malajam\u0161\u0107ina" },
            { "MM", "Myanmar" },
            { "MN", "Mongolska" },
            { "mn", "mongol\u0161\u0107ina" },
            { "MO", "Wosebita zarjadniska cona Macao" },
            { "MP", "Sewjerne Mariany" },
            { "MQ", "Martinique" },
            { "MR", "Mawretanska" },
            { "mr", "marati\u0161\u0107ina" },
            { "MS", "Montserrat" },
            { "ms", "malaj\u0161\u0107ina" },
            { "MT", "Malta" },
            { "mt", "malta\u0161\u0107ina" },
            { "MU", "Mauritius" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "japanska protyka" },
            { "MY", "Malajzija" },
            { "my", "burma\u0161\u0107ina" },
            { "MZ", "Mosambik" },
            { "Armn", "armensce" },
            { "dsb", "delnjoserb\u0161\u0107ina" },
            { "NA", "Namibija" },
            { "na", "nauru\u0161\u0107ina" },
            { "type.co.search", "pow\u0161itkowne pytanje" },
            { "nb", "norweg\u0161\u0107ina (bokm\u00e5l)" },
            { "type.ca.hebrew", "\u017eidowska protyka" },
            { "NC", "Nowa Kaledoniska" },
            { "nd", "sewjero-ndebele" },
            { "NE", "Niger" },
            { "ne", "nepal\u0161\u0107ina" },
            { "NF", "Norfolkowa kupa" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragua" },
            { "NL", "Ni\u017eozemska" },
            { "nl", "ni\u017eozem\u0161\u0107ina" },
            { "nn", "norweg\u0161\u0107ina (nynorsk)" },
            { "NO", "Norwegska" },
            { "no", "norweg\u0161\u0107ina" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "nv", "navaho" },
            { "rof", "rombo" },
            { "NZ", "Nowoseelandska" },
            { "kab", "kabyl\u0161\u0107ina" },
            { "oc", "okcitan\u0161\u0107ina" },
            { "kam", "kamba" },
            { "ang", "anglosak\u0161\u0107ina" },
            { "mer", "meru" },
            { "type.nu.armn", "armenske cyfry" },
            { "OM", "Oman" },
            { "om", "oromo" },
            { "or", "orij\u0161\u0107ina" },
            { "mfe", "mauriciska kreol\u0161\u0107ina" },
            { "PA", "Panama" },
            { "pa", "pand\u017aab\u0161\u0107ina" },
            { "dua", "duala" },
            { "en_GB", "britiska jend\u017ael\u0161\u0107ina" },
            { "PE", "Peru" },
            { "PF", "Francoska Polyneziska" },
            { "PG", "Papuwa-Nowa Gineja" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "P\u00f3lska" },
            { "pl", "p\u00f3l\u0161\u0107ina" },
            { "PM", "St. Pierre a Miquelon" },
            { "PN", "Pitcairnowe kupy" },
            { "type.ca.dangi", "dangi-protyka" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinski awtonomny teritorij" },
            { "ps", "pa\u0161tun\u0161\u0107ina" },
            { "PT", "Portugalska" },
            { "pt", "portugal\u0161\u0107ina" },
            { "key.co", "rjadowanski sl\u011bd" },
            { "PW", "Palau" },
            { "type.nu.greklow", "grjekske cyfry, ma\u0142e pisane" },
            { "PY", "Paraguay" },
            { "pt_BR", "brazilska portugal\u0161\u0107ina" },
            { "mgh", "makhuwa-meetto" },
            { "Hebr", "hebrejsce" },
            { "QA", "Katar" },
            { "key.ca", "protyka" },
            { "Laoo", "laosce" },
            { "mgo", "meta\u2019" },
            { "type.nu.mymr", "burmaske cyfry" },
            { "QO", "Wonkowna Oceaniska" },
            { "qu", "ke\u010dua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "001", "sw\u011bt" },
            { "stq", "saterfrizi\u0161\u0107ina" },
            { "Ethi", "etiopisce" },
            { "002", "Afrika" },
            { "003", "Sewjerna Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Ju\u017ena Amerika" },
            { "009", "Oceaniska" },
            { "rm", "retoroman\u0161\u0107ina" },
            { "rn", "kirundi\u0161\u0107ina" },
            { "key.cu", "m\u011bna" },
            { "RO", "Rumunska" },
            { "ro", "rumun\u0161\u0107ina" },
            { "RS", "Serbiska" },
            { "type.nu.orya", "oriya-cyfry" },
            { "type.nu.hanidec", "chinske decimalne li\u010dby" },
            { "RU", "Ruska" },
            { "ru", "ru\u0161\u0107ina" },
            { "RW", "Ruanda" },
            { "rw", "kinjarwanda" },
            { "kea", "kapverd\u0161\u0107ina" },
            { "en_AU", "awstralska jend\u017ael\u0161\u0107ina" },
            { "SA", "Sawdi-Arabska" },
            { "sa", "sanskrit" },
            { "SB", "Salomony" },
            { "twq", "tasawaq" },
            { "011", "zapadna Afrika" },
            { "SC", "Seychelle" },
            { "sc", "sardin\u0161\u0107ina" },
            { "SD", "Sudan" },
            { "sd", "sindhi\u0161\u0107ina" },
            { "013", "Srjed\u017ana Amerika" },
            { "SE", "\u0160wedska" },
            { "se", "sewjerosami\u0161\u0107ina" },
            { "014", "wuchodna Afrika" },
            { "015", "sewjerna Afrika" },
            { "SG", "Singapur" },
            { "sg", "sango" },
            { "SH", "St. Helena" },
            { "sh", "serbochorwat\u0161\u0107ina" },
            { "017", "srjed\u017ana Afrika" },
            { "SI", "S\u0142owjenska" },
            { "si", "singhal\u0161\u0107ina" },
            { "018", "ju\u017ena Afrika" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "S\u0142owakska" },
            { "sk", "s\u0142owak\u0161\u0107ina" },
            { "SL", "Sierra Leone" },
            { "sl", "s\u0142owjen\u0161\u0107ina" },
            { "SM", "San Marino" },
            { "sm", "samoa\u0161\u0107ina" },
            { "SN", "Senegal" },
            { "sn", "\u0161ona\u0161\u0107ina" },
            { "SO", "Somalija" },
            { "so", "somali\u0161\u0107ina" },
            { "arn", "arawkan\u0161\u0107ina" },
            { "type.nu.arab", "arabsko-indiske cyfry" },
            { "sq", "alban\u0161\u0107ina" },
            { "type.nu.taml", "tradicionalne tamilske cyfry" },
            { "SR", "Surinam" },
            { "sr", "serbi\u0161\u0107ina" },
            { "SS", "Ju\u017eny Sudan" },
            { "ss", "siswati" },
            { "ST", "S\u00e3o Tom\u00e9 a Pr\u00edncipe" },
            { "st", "ju\u017enosot\u0161\u0107ina (Sesotho)" },
            { "su", "sundanezi\u0161\u0107ina" },
            { "SV", "El Salvador" },
            { "sv", "\u0161wed\u0161\u0107ina" },
            { "sw", "suahel\u0161\u0107ina" },
            { "SX", "Sint Maarten" },
            { "SY", "Syriska" },
            { "type.nu.hantfin", "tradicionalne chinske financne cyfry" },
            { "SZ", "Swaziska" },
            { "TA", "Tristan da Cunha" },
            { "ta", "tamil\u0161\u0107ina" },
            { "asa", "pare" },
            { "021", "sewjerny ameriski kontinent" },
            { "142", "Azija" },
            { "TC", "kupy Turks a Caicos" },
            { "143", "centralna Azija" },
            { "TD", "\u010cad" },
            { "te", metaValue_te },
            { "145", "zapadna Azija" },
            { "TF", "Francoski ju\u017eny a antarktiski teritorij" },
            { "TG", "Togo" },
            { "tg", "tad\u017aik\u0161\u0107ina" },
            { "TH", "Thailandska" },
            { "th", "thailand\u0161\u0107ina" },
            { "ti", "tigrin\u0161\u0107ina" },
            { "bug", "buginezi\u0161\u0107ina" },
            { "TJ", "Tad\u017aikistan" },
            { "en_CA", "kanadiska jend\u017ael\u0161\u0107ina" },
            { "029", "Karibika" },
            { "TK", "Tokelau" },
            { "tk", "turkmen\u0161\u0107ina" },
            { "TL", "Timor-Leste" },
            { "tl", "tagalog" },
            { "TM", "Turkmeniska" },
            { "TN", "Tuneziska" },
            { "tn", "tswana" },
            { "TO", "Tonga" },
            { "to", "tonga\u0161\u0107ina" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "japanske cyfry" },
            { "TR", "Turkowska" },
            { "tr", "turkow\u0161\u0107ina" },
            { "ts", "tsonga" },
            { "TT", "Trinidad a Tobago" },
            { "tt", "tatar\u0161\u0107ina" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "tw", "twi" },
            { "ast", "astur\u0161\u0107ina" },
            { "ty", "tahiti\u0161\u0107ina" },
            { "TZ", "Tansanija" },
            { "nmg", "kwasio" },
            { "Zzzz", "njeznate pismo" },
            { "150", "Europa" },
            { "UA", "Ukraina" },
            { "030", "wuchodna Azija" },
            { "151", "wuchodna Europa" },
            { "154", "sewjerna Europa" },
            { "sw_CD", "kongoska suahel\u0161\u0107ina" },
            { "034", "ju\u017ena Azija" },
            { "155", "zapadna Europa" },
            { "035", "juhowuchodna Azija" },
            { "UG", "Uganda" },
            { "ug", "ujgur\u0161\u0107ina" },
            { "Kore", "korejsce" },
            { "Zyyy", "pow\u0161itkowne" },
            { "039", "ju\u017ena Europa" },
            { "uk", "ukrain\u0161\u0107ina" },
            { "Sinh", "singhalsce" },
            { "UM", "Ameriska Oceaniska" },
            { "ur", "urdu\u0161\u0107ina" },
            { "US", "Zjedno\u0107ene staty Ameriki" },
            { "haw", "hawaii\u0161\u0107ina" },
            { "UY", "Uruguay" },
            { "prg", "pru\u0161\u0107ina" },
            { "UZ", "Uzbekistan" },
            { "uz", "uzbek\u0161\u0107ina" },
            { "tzm", "tamazight (srjed\u017any Marokko)" },
            { "VA", "Vatikanske m\u011bsto" },
            { "VC", "St. Vincent a Grenadiny" },
            { "VE", "Venezuela" },
            { "type.ca.roc", "protyka republiki China" },
            { "VG", "Britiske knje\u017eniske kupy" },
            { "VI", "Ameriske knje\u017eniske kupy" },
            { "vi", "vietnam\u0161\u0107ina" },
            { "khq", "koyra chiini" },
            { "VN", "Vietnam" },
            { "vo", "volap\u00fck" },
            { "quc", "k\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "rwk", "rwa" },
            { "wa", "walon\u0161\u0107ina" },
            { "gag", "gagauzi\u0161\u0107ina" },
            { "053", "Awstralazija" },
            { "054", "Melaneziska" },
            { "WF", "Wallis a Futuna" },
            { "Grek", "grjeksce" },
            { "057", "Mikroneziska (kupowy region)" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wo", "wolof" },
            { "zgh", "tamazight" },
            { "ar_001", "moderna wysokoarab\u0161\u0107ina" },
            { "WS", "Samoa" },
            { "Mong", "mongolsce" },
            { "061", "Polyneziska" },
            { "Latn", "\u0142a\u0107onsce" },
            { "type.nu.hans", "zjednorjene chinske cyfry" },
            { "type.nu.hant", "tradicionalne chinske cyfry" },
            { "xh", "xhosa" },
            { "XK", "Kosowo" },
            { "type.nu.romanlow", "romske cyfry, ma\u0142e pisane" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "bjez pisma" },
            { "moh", "mohawk\u0161\u0107ina" },
            { "YE", "Jemen" },
            { "nqo", "n\u2019ko" },
            { "type.co.standard", "standardowy rjadowanski sl\u011bd" },
            { "yi", "jidi\u0161\u0107ina" },
            { "yo", "joruba\u0161\u0107ina" },
            { "es_MX", "mexiska \u0161pani\u0161\u0107ina" },
            { "YT", "Mayotte" },
            { "vai", "vai" },
            { "ZA", "Ju\u017ena Afrika (Republika)" },
            { "za", "zhuang" },
            { "kln", "kalenjin" },
            { "Deva", "devanagari" },
            { "zh", "chin\u0161\u0107ina" },
            { "type.nu.geor", "georgiske cyfry" },
            { "Hira", "hiragana" },
            { "ZM", "Sambija" },
            { "Bopo", "bopomofo" },
            { "zu", "zulu\u0161\u0107ina" },
            { "ZW", "Simbabwe" },
            { "ZZ", "njeznaty region" },
            { "Geor", "georgisce" },
            { "type.ca.iso8601", "protyka po iso-8601" },
            { "type.nu.telu", "telugu-cyfry" },
            { "type.nu.jpanfin", "japanske financne cyfry" },
            { "ebu", "embu" },
            { "jmc", "machame" },
            { "zh_Hans", "chin\u0161\u0107ina (zjednorjena)" },
            { "koi", "permska komi\u0161\u0107ina" },
            { "type.nu.hansfin", "zjednorjene chinske financne cyfry" },
            { "kok", "konkani" },
            { "type.nu.arabext", "roz\u0161\u011brjene arabsko-indiske cyfry" },
            { "nus", "nuer" },
            { "type.nu.fullwide", "po\u0142no\u0161\u011broke cyfry" },
            { "dav", "taita" },
            { "zh_Hant", "chin\u0161\u0107ina (tradicionalna)" },
            { "type.nu.khmr", "khmerske cyfry" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmukhi-cyfry" },
            { "Khmr", "khmersce" },
            { "mus", "krik" },
            { "type.nu.roman", "romske cyfry" },
            { "type.nu.tamldec", "tamilske cyfry" },
            { "saq", "samburu" },
            { "key.nu", "li\u010dby" },
            { "Guru", "gurmukhi" },
            { "ksb", "\u0161ambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
