/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.model;

import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ArrayNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ChildrenComputer;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerNodeFactory;

public class PrimitiveArrayNode
extends ArrayNode {
    private static final int MAX_CHAR_ARRAY_STRING_SIZE = 128;

    public PrimitiveArrayNode(PrimitiveArrayInstance instance, String name, HeapWalkerNode parent) {
        super((Instance)instance, name, parent);
    }

    public PrimitiveArrayNode(PrimitiveArrayInstance instance, String name, HeapWalkerNode parent, int mode) {
        super((Instance)instance, name, parent, mode);
    }

    public PrimitiveArrayInstance getInstance() {
        return (PrimitiveArrayInstance)super.getInstance();
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            @Override
            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] children = null;
                if (PrimitiveArrayNode.this.getMode() == 1) {
                    int fieldsSize = PrimitiveArrayNode.this.getInstance().getLength();
                    if (fieldsSize == 0) {
                        children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(PrimitiveArrayNode.this)};
                    } else if (fieldsSize > 500) {
                        int childrenCount = fieldsSize;
                        BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(childrenCount);
                        int containersCount = groupingInfo.containersCount;
                        int collapseUnitSize = groupingInfo.collapseUnitSize;
                        children = new HeapWalkerNode[containersCount];
                        for (int i = 0; i < containersCount; ++i) {
                            int unitStartIndex = collapseUnitSize * i;
                            int unitEndIndex = Math.min(unitStartIndex + collapseUnitSize, childrenCount) - 1;
                            children[i] = HeapWalkerNodeFactory.createArrayItemContainerNode(PrimitiveArrayNode.this, unitStartIndex, unitEndIndex);
                        }
                    } else {
                        List fields = PrimitiveArrayNode.this.getInstance().getValues();
                        children = new HeapWalkerNode[fields.size()];
                        for (int i = 0; i < children.length; ++i) {
                            children[i] = HeapWalkerNodeFactory.createPrimitiveArrayItemNode(PrimitiveArrayNode.this, i, (String)fields.get(i));
                        }
                    }
                } else if (PrimitiveArrayNode.this.getMode() == 2) {
                    children = HeapWalkerNodeFactory.createReferences(PrimitiveArrayNode.this);
                }
                return children;
            }
        };
    }

    public static abstract class RootNode
    extends PrimitiveArrayNode
    implements org.graalvm.visualvm.lib.profiler.heapwalk.model.RootNode {
        public RootNode(PrimitiveArrayInstance instance, String name, HeapWalkerNode parent) {
            super(instance, name, parent);
        }

        public RootNode(PrimitiveArrayInstance instance, String name, HeapWalkerNode parent, int mode) {
            super(instance, name, parent, mode);
        }

        @Override
        public abstract void refreshView();
    }

    public static class ArrayItem
    extends PrimitiveArrayNode
    implements org.graalvm.visualvm.lib.profiler.heapwalk.model.ArrayItem {
        private int itemIndex;

        public ArrayItem(int itemIndex, PrimitiveArrayInstance instance, HeapWalkerNode parent) {
            this(itemIndex, instance, parent, parent == null ? 1 : parent.getMode());
        }

        public ArrayItem(int itemIndex, PrimitiveArrayInstance instance, HeapWalkerNode parent, int mode) {
            super(instance, null, parent, mode);
            this.itemIndex = itemIndex;
        }

        @Override
        public int getItemIndex() {
            return this.itemIndex;
        }

        @Override
        protected String computeName() {
            String name = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                return name + " " + Bundle.PrimitiveArrayNode_LoopToString(BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            return name;
        }

        @Override
        protected String computeType() {
            if (!this.hasInstance()) {
                return BrowserUtils.getArrayItemType(this.getType());
            }
            return super.computeType();
        }

        @Override
        public Object getNodeID() {
            return this.itemIndex;
        }
    }
}

