#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2021 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_dvm_cmd_import_devlist
short_description: Import a list of ADOMs and devices.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.10"
author:
    - Link Zheng (@chillancezen)
    - Jie Xue (@JieX19)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    enable_log:
        description: Enable/Disable logging for task
        required: false
        type: bool
        default: false
    bypass_validation:
        description: only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters
        required: false
        type: bool
        default: false
    workspace_locking_adom:
        description: the adom to lock for FortiManager running in workspace mode, the value can be global and others including root
        required: false
        type: str
    workspace_locking_timeout:
        description: the maximum time in seconds to wait for other user to release the workspace lock
        required: false
        type: int
        default: 300
    rc_succeeded:
        description: the rc codes list with which the conditions to succeed will be overriden
        type: list
        required: false
    rc_failed:
        description: the rc codes list with which the conditions to fail will be overriden
        type: list
        required: false
    dvm_cmd_import_devlist:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            adom:
                type: str
                description: 'Name or ID of the ADOM where the command is to be executed on.'
            flags:
                description: no description
                type: list
                choices:
                 - none
                 - create_task
                 - nonblocking
                 - log_dev
            import-adom-members:
                description: no description
                type: list
                suboptions:
                    adom:
                        type: str
                        description: 'Target ADOM to associate device VDOM with.'
                    dev:
                        type: str
                        description: no description
                    vdom:
                        type: str
                        description: no description
            import-adoms:
                description: no description
                type: list
                suboptions:
                    desc:
                        type: str
                        description: no description
                    flags:
                        description: no description
                        type: list
                        choices:
                         - migration
                         - db_export
                         - no_vpn_console
                         - backup
                         - other_devices
                         - central_sdwan
                         - is_autosync
                         - per_device_wtp
                         - policy_check_on_install
                         - install_on_policy_check_fail
                         - auto_push_cfg
                    log_db_retention_hours:
                        type: int
                        default: 1440
                        description: no description
                    log_disk_quota:
                        type: int
                        description: no description
                    log_disk_quota_alert_thres:
                        type: int
                        default: 90
                        description: no description
                    log_disk_quota_split_ratio:
                        type: int
                        default: 70
                        description: no description
                    log_file_retention_hours:
                        type: int
                        default: 8760
                        description: no description
                    meta fields:
                        description: no description
                        type: dict
                    mig_mr:
                        type: int
                        default: 2
                        description: no description
                    mig_os_ver:
                        type: str
                        default: '6.0'
                        description: no description
                        choices:
                            - 'unknown'
                            - '0.0'
                            - '1.0'
                            - '2.0'
                            - '3.0'
                            - '4.0'
                            - '5.0'
                            - '6.0'
                    mode:
                        type: str
                        default: 'gms'
                        description:
                         - 'ems - (Value no longer used as of 4.3)'
                         - 'provider - Global database.'
                        choices:
                            - 'ems'
                            - 'gms'
                            - 'provider'
                    mr:
                        type: int
                        default: 2
                        description: no description
                    name:
                        type: str
                        description: no description
                    os_ver:
                        type: str
                        default: '6.0'
                        description: no description
                        choices:
                            - 'unknown'
                            - '0.0'
                            - '1.0'
                            - '2.0'
                            - '3.0'
                            - '4.0'
                            - '5.0'
                            - '6.0'
                    restricted_prds:
                        description: no description
                        type: list
                        choices:
                         - fos
                         - foc
                         - fml
                         - fch
                         - fwb
                         - log
                         - fct
                         - faz
                         - fsa
                         - fsw
                         - fmg
                         - fdd
                         - fac
                         - fpx
                    state:
                        type: int
                        default: 1
                        description: no description
                    uuid:
                        type: str
                        description: no description
            import-devices:
                description: no description
                type: list
                suboptions:
                    adm_pass:
                        description: no description
                        type: str
                    adm_usr:
                        type: str
                        description: no description
                    app_ver:
                        type: str
                        description: no description
                    av_ver:
                        type: str
                        description: no description
                    beta:
                        type: int
                        description: no description
                    branch_pt:
                        type: int
                        description: no description
                    build:
                        type: int
                        description: no description
                    checksum:
                        type: str
                        description: no description
                    conf_status:
                        type: str
                        default: 'unknown'
                        description: no description
                        choices:
                            - 'unknown'
                            - 'insync'
                            - 'outofsync'
                    conn_mode:
                        type: str
                        default: 'passive'
                        description: no description
                        choices:
                            - 'active'
                            - 'passive'
                    conn_status:
                        type: str
                        default: 'UNKNOWN'
                        description: no description
                        choices:
                            - 'UNKNOWN'
                            - 'up'
                            - 'down'
                    db_status:
                        type: str
                        default: 'unknown'
                        description: no description
                        choices:
                            - 'unknown'
                            - 'nomod'
                            - 'mod'
                    desc:
                        type: str
                        description: no description
                    dev_status:
                        type: str
                        default: 'unknown'
                        description: no description
                        choices:
                            - 'none'
                            - 'unknown'
                            - 'checkedin'
                            - 'inprogress'
                            - 'installed'
                            - 'aborted'
                            - 'sched'
                            - 'retry'
                            - 'canceled'
                            - 'pending'
                            - 'retrieved'
                            - 'changed_conf'
                            - 'sync_fail'
                            - 'timeout'
                            - 'rev_revert'
                            - 'auto_updated'
                    fap_cnt:
                        type: int
                        description: no description
                    faz.full_act:
                        type: int
                        description: no description
                    faz.perm:
                        type: int
                        description: no description
                    faz.quota:
                        type: int
                        description: no description
                    faz.used:
                        type: int
                        description: no description
                    fex_cnt:
                        type: int
                        description: no description
                    flags:
                        description: no description
                        type: list
                        choices:
                         - has_hdd
                         - vdom_enabled
                         - discover
                         - reload
                         - interim_build
                         - offline_mode
                         - is_model
                         - fips_mode
                         - linked_to_model
                         - ip-conflict
                         - faz-autosync
                    foslic_cpu:
                        type: int
                        description: 'VM Meter vCPU count.'
                    foslic_dr_site:
                        type: str
                        default: 'disable'
                        description: 'VM Meter DR Site status.'
                        choices:
                            - 'disable'
                            - 'enable'
                    foslic_inst_time:
                        type: int
                        description: 'VM Meter first deployment time (in UNIX timestamp).'
                    foslic_last_sync:
                        type: int
                        description: 'VM Meter last synchronized time (in UNIX timestamp).'
                    foslic_ram:
                        type: int
                        description: 'VM Meter device RAM size (in MB).'
                    foslic_type:
                        type: str
                        default: 'temporary'
                        description: 'VM Meter license type.'
                        choices:
                            - 'temporary'
                            - 'trial'
                            - 'regular'
                            - 'trial_expired'
                    foslic_utm:
                        description: no description
                        type: list
                        choices:
                         - fw
                         - av
                         - ips
                         - app
                         - url
                         - utm
                         - fwb
                    fsw_cnt:
                        type: int
                        description: no description
                    ha_group_id:
                        type: int
                        description: no description
                    ha_group_name:
                        type: str
                        description: no description
                    ha_mode:
                        type: str
                        default: 'standalone'
                        description: 'enabled - Value reserved for non-FOS HA devices.'
                        choices:
                            - 'standalone'
                            - 'AP'
                            - 'AA'
                            - 'ELBC'
                            - 'DUAL'
                            - 'enabled'
                            - 'unknown'
                    ha_slave:
                        description: no description
                        type: list
                        suboptions:
                            idx:
                                type: int
                                description: no description
                            name:
                                type: str
                                description: no description
                            prio:
                                type: int
                                description: no description
                            role:
                                type: str
                                default: 'slave'
                                description: no description
                                choices:
                                    - 'slave'
                                    - 'master'
                            sn:
                                type: str
                                description: no description
                            status:
                                type: int
                                description: no description
                    hdisk_size:
                        type: int
                        description: no description
                    hostname:
                        type: str
                        description: no description
                    hw_rev_major:
                        type: int
                        description: no description
                    hw_rev_minor:
                        type: int
                        description: no description
                    ip:
                        type: str
                        description: no description
                    ips_ext:
                        type: int
                        description: no description
                    ips_ver:
                        type: str
                        description: no description
                    last_checked:
                        type: int
                        description: no description
                    last_resync:
                        type: int
                        description: no description
                    latitude:
                        type: str
                        description: no description
                    lic_flags:
                        type: int
                        description: no description
                    lic_region:
                        type: str
                        description: no description
                    location_from:
                        type: str
                        description: no description
                    logdisk_size:
                        type: int
                        description: no description
                    longitude:
                        type: str
                        description: no description
                    maxvdom:
                        type: int
                        default: 10
                        description: no description
                    meta fields:
                        description: no description
                        type: dict
                    mgmt_id:
                        type: int
                        description: no description
                    mgmt_if:
                        type: str
                        description: no description
                    mgmt_mode:
                        type: str
                        default: 'unreg'
                        description: no description
                        choices:
                            - 'unreg'
                            - 'fmg'
                            - 'faz'
                            - 'fmgfaz'
                    mgt_vdom:
                        type: str
                        description: no description
                    mr:
                        type: int
                        default: -1
                        description: no description
                    name:
                        type: str
                        description: 'Unique name for the device.'
                    os_type:
                        type: str
                        default: 'unknown'
                        description: no description
                        choices:
                            - 'unknown'
                            - 'fos'
                            - 'fsw'
                            - 'foc'
                            - 'fml'
                            - 'faz'
                            - 'fwb'
                            - 'fch'
                            - 'fct'
                            - 'log'
                            - 'fmg'
                            - 'fsa'
                            - 'fdd'
                            - 'fac'
                            - 'fpx'
                    os_ver:
                        type: str
                        default: 'unknown'
                        description: no description
                        choices:
                            - 'unknown'
                            - '0.0'
                            - '1.0'
                            - '2.0'
                            - '3.0'
                            - '4.0'
                            - '5.0'
                            - '6.0'
                    patch:
                        type: int
                        description: no description
                    platform_str:
                        type: str
                        description: no description
                    psk:
                        type: str
                        description: no description
                    sn:
                        type: str
                        description: 'Unique value for each device.'
                    vdom:
                        description: no description
                        type: list
                        suboptions:
                            comments:
                                type: str
                                description: no description
                            name:
                                type: str
                                description: no description
                            opmode:
                                type: str
                                default: 'nat'
                                description: no description
                                choices:
                                    - 'nat'
                                    - 'transparent'
                            rtm_prof_id:
                                type: int
                                description: no description
                            status:
                                type: str
                                description: no description
                    version:
                        type: int
                        description: no description
                    vm_cpu:
                        type: int
                        description: no description
                    vm_cpu_limit:
                        type: int
                        description: no description
                    vm_lic_expire:
                        type: int
                        description: no description
                    vm_mem:
                        type: int
                        description: no description
                    vm_mem_limit:
                        type: int
                        description: no description
                    vm_status:
                        type: int
                        description: no description
            import-group-members:
                description: no description
                type: list
                suboptions:
                    adom:
                        type: str
                        description: 'ADOM where the device group is located. Default is "root" if not specified.'
                    dev:
                        type: str
                        description: no description
                    grp:
                        type: str
                        description: 'Target device group to associate device VDOM with.'
                    vdom:
                        type: str
                        description: no description

'''

EXAMPLES = '''
 - hosts: fortimanager-inventory
   collections:
     - fortinet.fortimanager
   connection: httpapi
   vars:
      ansible_httpapi_use_ssl: True
      ansible_httpapi_validate_certs: False
      ansible_httpapi_port: 443
   tasks:
    - name: Import a list of ADOMs and devices.
      fmgr_dvm_cmd_import_devlist:
         bypass_validation: False
         workspace_locking_adom: <value in [global, custom adom including root]>
         workspace_locking_timeout: 300
         rc_succeeded: [0, -2, -3, ...]
         rc_failed: [-2, -3, ...]
         dvm_cmd_import_devlist:
            adom: <value of string>
            flags:
              - none
              - create_task
              - nonblocking
              - log_dev
            import-adom-members:
              -
                  adom: <value of string>
                  dev: <value of string>
                  vdom: <value of string>
            import-adoms:
              -
                  desc: <value of string>
                  flags:
                    - migration
                    - db_export
                    - no_vpn_console
                    - backup
                    - other_devices
                    - central_sdwan
                    - is_autosync
                    - per_device_wtp
                    - policy_check_on_install
                    - install_on_policy_check_fail
                    - auto_push_cfg
                  log_db_retention_hours: <value of integer>
                  log_disk_quota: <value of integer>
                  log_disk_quota_alert_thres: <value of integer>
                  log_disk_quota_split_ratio: <value of integer>
                  log_file_retention_hours: <value of integer>
                  meta fields: <value of dict>
                  mig_mr: <value of integer>
                  mig_os_ver: <value in [unknown, 0.0, 1.0, ...]>
                  mode: <value in [ems, gms, provider]>
                  mr: <value of integer>
                  name: <value of string>
                  os_ver: <value in [unknown, 0.0, 1.0, ...]>
                  restricted_prds:
                    - fos
                    - foc
                    - fml
                    - fch
                    - fwb
                    - log
                    - fct
                    - faz
                    - fsa
                    - fsw
                    - fmg
                    - fdd
                    - fac
                    - fpx
                  state: <value of integer>
                  uuid: <value of string>
            import-devices:
              -
                  adm_pass: <value of string>
                  adm_usr: <value of string>
                  app_ver: <value of string>
                  av_ver: <value of string>
                  beta: <value of integer>
                  branch_pt: <value of integer>
                  build: <value of integer>
                  checksum: <value of string>
                  conf_status: <value in [unknown, insync, outofsync]>
                  conn_mode: <value in [active, passive]>
                  conn_status: <value in [UNKNOWN, up, down]>
                  db_status: <value in [unknown, nomod, mod]>
                  desc: <value of string>
                  dev_status: <value in [none, unknown, checkedin, ...]>
                  fap_cnt: <value of integer>
                  faz.full_act: <value of integer>
                  faz.perm: <value of integer>
                  faz.quota: <value of integer>
                  faz.used: <value of integer>
                  fex_cnt: <value of integer>
                  flags:
                    - has_hdd
                    - vdom_enabled
                    - discover
                    - reload
                    - interim_build
                    - offline_mode
                    - is_model
                    - fips_mode
                    - linked_to_model
                    - ip-conflict
                    - faz-autosync
                  foslic_cpu: <value of integer>
                  foslic_dr_site: <value in [disable, enable]>
                  foslic_inst_time: <value of integer>
                  foslic_last_sync: <value of integer>
                  foslic_ram: <value of integer>
                  foslic_type: <value in [temporary, trial, regular, ...]>
                  foslic_utm:
                    - fw
                    - av
                    - ips
                    - app
                    - url
                    - utm
                    - fwb
                  fsw_cnt: <value of integer>
                  ha_group_id: <value of integer>
                  ha_group_name: <value of string>
                  ha_mode: <value in [standalone, AP, AA, ...]>
                  ha_slave:
                    -
                        idx: <value of integer>
                        name: <value of string>
                        prio: <value of integer>
                        role: <value in [slave, master]>
                        sn: <value of string>
                        status: <value of integer>
                  hdisk_size: <value of integer>
                  hostname: <value of string>
                  hw_rev_major: <value of integer>
                  hw_rev_minor: <value of integer>
                  ip: <value of string>
                  ips_ext: <value of integer>
                  ips_ver: <value of string>
                  last_checked: <value of integer>
                  last_resync: <value of integer>
                  latitude: <value of string>
                  lic_flags: <value of integer>
                  lic_region: <value of string>
                  location_from: <value of string>
                  logdisk_size: <value of integer>
                  longitude: <value of string>
                  maxvdom: <value of integer>
                  meta fields: <value of dict>
                  mgmt_id: <value of integer>
                  mgmt_if: <value of string>
                  mgmt_mode: <value in [unreg, fmg, faz, ...]>
                  mgt_vdom: <value of string>
                  mr: <value of integer>
                  name: <value of string>
                  os_type: <value in [unknown, fos, fsw, ...]>
                  os_ver: <value in [unknown, 0.0, 1.0, ...]>
                  patch: <value of integer>
                  platform_str: <value of string>
                  psk: <value of string>
                  sn: <value of string>
                  vdom:
                    -
                        comments: <value of string>
                        name: <value of string>
                        opmode: <value in [nat, transparent]>
                        rtm_prof_id: <value of integer>
                        status: <value of string>
                  version: <value of integer>
                  vm_cpu: <value of integer>
                  vm_cpu_limit: <value of integer>
                  vm_lic_expire: <value of integer>
                  vm_mem: <value of integer>
                  vm_mem_limit: <value of integer>
                  vm_status: <value of integer>
            import-group-members:
              -
                  adom: <value of string>
                  dev: <value of string>
                  grp: <value of string>
                  vdom: <value of string>

'''

RETURN = '''
request_url:
    description: The full url requested
    returned: always
    type: str
    sample: /sys/login/user
response_code:
    description: The status of api request
    returned: always
    type: int
    sample: 0
response_message:
    description: The descriptive message of the api response
    type: str
    returned: always
    sample: OK.

'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/dvm/cmd/import/dev-list',
        '/dvm/cmd/import/dev-list'
    ]

    perobject_jrpc_urls = [
        '/dvm/cmd/import/dev-list/{dev-list}',
        '/dvm/cmd/import/dev-list/{dev-list}'
    ]

    url_params = []
    module_arg_spec = {
        'enable_log': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list'
        },
        'rc_failed': {
            'required': False,
            'type': 'list'
        },
        'dvm_cmd_import_devlist': {
            'required': False,
            'type': 'dict',
            'options': {
                'adom': {
                    'required': False,
                    'type': 'str'
                },
                'flags': {
                    'required': False,
                    'type': 'list',
                    'choices': [
                        'none',
                        'create_task',
                        'nonblocking',
                        'log_dev'
                    ]
                },
                'import-adom-members': {
                    'required': False,
                    'type': 'list',
                    'options': {
                        'adom': {
                            'required': False,
                            'type': 'str'
                        },
                        'dev': {
                            'required': False,
                            'type': 'str'
                        },
                        'vdom': {
                            'required': False,
                            'type': 'str'
                        }
                    }
                },
                'import-adoms': {
                    'required': False,
                    'type': 'list',
                    'options': {
                        'desc': {
                            'required': False,
                            'type': 'str'
                        },
                        'flags': {
                            'required': False,
                            'type': 'list',
                            'choices': [
                                'migration',
                                'db_export',
                                'no_vpn_console',
                                'backup',
                                'other_devices',
                                'central_sdwan',
                                'is_autosync',
                                'per_device_wtp',
                                'policy_check_on_install',
                                'install_on_policy_check_fail',
                                'auto_push_cfg'
                            ]
                        },
                        'log_db_retention_hours': {
                            'required': False,
                            'type': 'int'
                        },
                        'log_disk_quota': {
                            'required': False,
                            'type': 'int'
                        },
                        'log_disk_quota_alert_thres': {
                            'required': False,
                            'type': 'int'
                        },
                        'log_disk_quota_split_ratio': {
                            'required': False,
                            'type': 'int'
                        },
                        'log_file_retention_hours': {
                            'required': False,
                            'type': 'int'
                        },
                        'meta fields': {
                            'required': False,
                            'type': 'dict'
                        },
                        'mig_mr': {
                            'required': False,
                            'type': 'int'
                        },
                        'mig_os_ver': {
                            'required': False,
                            'choices': [
                                'unknown',
                                '0.0',
                                '1.0',
                                '2.0',
                                '3.0',
                                '4.0',
                                '5.0',
                                '6.0'
                            ],
                            'type': 'str'
                        },
                        'mode': {
                            'required': False,
                            'choices': [
                                'ems',
                                'gms',
                                'provider'
                            ],
                            'type': 'str'
                        },
                        'mr': {
                            'required': False,
                            'type': 'int'
                        },
                        'name': {
                            'required': False,
                            'type': 'str'
                        },
                        'os_ver': {
                            'required': False,
                            'choices': [
                                'unknown',
                                '0.0',
                                '1.0',
                                '2.0',
                                '3.0',
                                '4.0',
                                '5.0',
                                '6.0'
                            ],
                            'type': 'str'
                        },
                        'restricted_prds': {
                            'required': False,
                            'type': 'list',
                            'choices': [
                                'fos',
                                'foc',
                                'fml',
                                'fch',
                                'fwb',
                                'log',
                                'fct',
                                'faz',
                                'fsa',
                                'fsw',
                                'fmg',
                                'fdd',
                                'fac',
                                'fpx'
                            ]
                        },
                        'state': {
                            'required': False,
                            'type': 'int'
                        },
                        'uuid': {
                            'required': False,
                            'type': 'str'
                        }
                    }
                },
                'import-devices': {
                    'required': False,
                    'type': 'list',
                    'options': {
                        'adm_pass': {
                            'required': False,
                            'type': 'str'
                        },
                        'adm_usr': {
                            'required': False,
                            'type': 'str'
                        },
                        'app_ver': {
                            'required': False,
                            'type': 'str'
                        },
                        'av_ver': {
                            'required': False,
                            'type': 'str'
                        },
                        'beta': {
                            'required': False,
                            'type': 'int'
                        },
                        'branch_pt': {
                            'required': False,
                            'type': 'int'
                        },
                        'build': {
                            'required': False,
                            'type': 'int'
                        },
                        'checksum': {
                            'required': False,
                            'type': 'str'
                        },
                        'conf_status': {
                            'required': False,
                            'choices': [
                                'unknown',
                                'insync',
                                'outofsync'
                            ],
                            'type': 'str'
                        },
                        'conn_mode': {
                            'required': False,
                            'choices': [
                                'active',
                                'passive'
                            ],
                            'type': 'str'
                        },
                        'conn_status': {
                            'required': False,
                            'choices': [
                                'UNKNOWN',
                                'up',
                                'down'
                            ],
                            'type': 'str'
                        },
                        'db_status': {
                            'required': False,
                            'choices': [
                                'unknown',
                                'nomod',
                                'mod'
                            ],
                            'type': 'str'
                        },
                        'desc': {
                            'required': False,
                            'type': 'str'
                        },
                        'dev_status': {
                            'required': False,
                            'choices': [
                                'none',
                                'unknown',
                                'checkedin',
                                'inprogress',
                                'installed',
                                'aborted',
                                'sched',
                                'retry',
                                'canceled',
                                'pending',
                                'retrieved',
                                'changed_conf',
                                'sync_fail',
                                'timeout',
                                'rev_revert',
                                'auto_updated'
                            ],
                            'type': 'str'
                        },
                        'fap_cnt': {
                            'required': False,
                            'type': 'int'
                        },
                        'faz.full_act': {
                            'required': False,
                            'type': 'int'
                        },
                        'faz.perm': {
                            'required': False,
                            'type': 'int'
                        },
                        'faz.quota': {
                            'required': False,
                            'type': 'int'
                        },
                        'faz.used': {
                            'required': False,
                            'type': 'int'
                        },
                        'fex_cnt': {
                            'required': False,
                            'type': 'int'
                        },
                        'flags': {
                            'required': False,
                            'type': 'list',
                            'choices': [
                                'has_hdd',
                                'vdom_enabled',
                                'discover',
                                'reload',
                                'interim_build',
                                'offline_mode',
                                'is_model',
                                'fips_mode',
                                'linked_to_model',
                                'ip-conflict',
                                'faz-autosync'
                            ]
                        },
                        'foslic_cpu': {
                            'required': False,
                            'type': 'int'
                        },
                        'foslic_dr_site': {
                            'required': False,
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'foslic_inst_time': {
                            'required': False,
                            'type': 'int'
                        },
                        'foslic_last_sync': {
                            'required': False,
                            'type': 'int'
                        },
                        'foslic_ram': {
                            'required': False,
                            'type': 'int'
                        },
                        'foslic_type': {
                            'required': False,
                            'choices': [
                                'temporary',
                                'trial',
                                'regular',
                                'trial_expired'
                            ],
                            'type': 'str'
                        },
                        'foslic_utm': {
                            'required': False,
                            'type': 'list',
                            'choices': [
                                'fw',
                                'av',
                                'ips',
                                'app',
                                'url',
                                'utm',
                                'fwb'
                            ]
                        },
                        'fsw_cnt': {
                            'required': False,
                            'type': 'int'
                        },
                        'ha_group_id': {
                            'required': False,
                            'type': 'int'
                        },
                        'ha_group_name': {
                            'required': False,
                            'type': 'str'
                        },
                        'ha_mode': {
                            'required': False,
                            'choices': [
                                'standalone',
                                'AP',
                                'AA',
                                'ELBC',
                                'DUAL',
                                'enabled',
                                'unknown'
                            ],
                            'type': 'str'
                        },
                        'ha_slave': {
                            'required': False,
                            'type': 'list',
                            'options': {
                                'idx': {
                                    'required': False,
                                    'type': 'int'
                                },
                                'name': {
                                    'required': False,
                                    'type': 'str'
                                },
                                'prio': {
                                    'required': False,
                                    'type': 'int'
                                },
                                'role': {
                                    'required': False,
                                    'choices': [
                                        'slave',
                                        'master'
                                    ],
                                    'type': 'str'
                                },
                                'sn': {
                                    'required': False,
                                    'type': 'str'
                                },
                                'status': {
                                    'required': False,
                                    'type': 'int'
                                }
                            }
                        },
                        'hdisk_size': {
                            'required': False,
                            'type': 'int'
                        },
                        'hostname': {
                            'required': False,
                            'type': 'str'
                        },
                        'hw_rev_major': {
                            'required': False,
                            'type': 'int'
                        },
                        'hw_rev_minor': {
                            'required': False,
                            'type': 'int'
                        },
                        'ip': {
                            'required': False,
                            'type': 'str'
                        },
                        'ips_ext': {
                            'required': False,
                            'type': 'int'
                        },
                        'ips_ver': {
                            'required': False,
                            'type': 'str'
                        },
                        'last_checked': {
                            'required': False,
                            'type': 'int'
                        },
                        'last_resync': {
                            'required': False,
                            'type': 'int'
                        },
                        'latitude': {
                            'required': False,
                            'type': 'str'
                        },
                        'lic_flags': {
                            'required': False,
                            'type': 'int'
                        },
                        'lic_region': {
                            'required': False,
                            'type': 'str'
                        },
                        'location_from': {
                            'required': False,
                            'type': 'str'
                        },
                        'logdisk_size': {
                            'required': False,
                            'type': 'int'
                        },
                        'longitude': {
                            'required': False,
                            'type': 'str'
                        },
                        'maxvdom': {
                            'required': False,
                            'type': 'int'
                        },
                        'meta fields': {
                            'required': False,
                            'type': 'dict'
                        },
                        'mgmt_id': {
                            'required': False,
                            'type': 'int'
                        },
                        'mgmt_if': {
                            'required': False,
                            'type': 'str'
                        },
                        'mgmt_mode': {
                            'required': False,
                            'choices': [
                                'unreg',
                                'fmg',
                                'faz',
                                'fmgfaz'
                            ],
                            'type': 'str'
                        },
                        'mgt_vdom': {
                            'required': False,
                            'type': 'str'
                        },
                        'mr': {
                            'required': False,
                            'type': 'int'
                        },
                        'name': {
                            'required': False,
                            'type': 'str'
                        },
                        'os_type': {
                            'required': False,
                            'choices': [
                                'unknown',
                                'fos',
                                'fsw',
                                'foc',
                                'fml',
                                'faz',
                                'fwb',
                                'fch',
                                'fct',
                                'log',
                                'fmg',
                                'fsa',
                                'fdd',
                                'fac',
                                'fpx'
                            ],
                            'type': 'str'
                        },
                        'os_ver': {
                            'required': False,
                            'choices': [
                                'unknown',
                                '0.0',
                                '1.0',
                                '2.0',
                                '3.0',
                                '4.0',
                                '5.0',
                                '6.0'
                            ],
                            'type': 'str'
                        },
                        'patch': {
                            'required': False,
                            'type': 'int'
                        },
                        'platform_str': {
                            'required': False,
                            'type': 'str'
                        },
                        'psk': {
                            'required': False,
                            'type': 'str'
                        },
                        'sn': {
                            'required': False,
                            'type': 'str'
                        },
                        'vdom': {
                            'required': False,
                            'type': 'list',
                            'options': {
                                'comments': {
                                    'required': False,
                                    'type': 'str'
                                },
                                'name': {
                                    'required': False,
                                    'type': 'str'
                                },
                                'opmode': {
                                    'required': False,
                                    'choices': [
                                        'nat',
                                        'transparent'
                                    ],
                                    'type': 'str'
                                },
                                'rtm_prof_id': {
                                    'required': False,
                                    'type': 'int'
                                },
                                'status': {
                                    'required': False,
                                    'type': 'str'
                                }
                            }
                        },
                        'version': {
                            'required': False,
                            'type': 'int'
                        },
                        'vm_cpu': {
                            'required': False,
                            'type': 'int'
                        },
                        'vm_cpu_limit': {
                            'required': False,
                            'type': 'int'
                        },
                        'vm_lic_expire': {
                            'required': False,
                            'type': 'int'
                        },
                        'vm_mem': {
                            'required': False,
                            'type': 'int'
                        },
                        'vm_mem_limit': {
                            'required': False,
                            'type': 'int'
                        },
                        'vm_status': {
                            'required': False,
                            'type': 'int'
                        }
                    }
                },
                'import-group-members': {
                    'required': False,
                    'type': 'list',
                    'options': {
                        'adom': {
                            'required': False,
                            'type': 'str'
                        },
                        'dev': {
                            'required': False,
                            'type': 'str'
                        },
                        'grp': {
                            'required': False,
                            'type': 'str'
                        },
                        'vdom': {
                            'required': False,
                            'type': 'str'
                        }
                    }
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'dvm_cmd_import_devlist'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        connection.set_option('enable_log', module.params['enable_log'] if 'enable_log' in module.params else False)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, None, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_exec()
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
