/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.graalvm.visualvm.application.jvm.HeapHistogram;

class HeapHistogramImpl
extends HeapHistogram {
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final String VOID_TEXT = "void";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char OBJECT_CODE = 'L';
    Set<HeapHistogram.ClassInfo> classes;
    Date time;
    long totalBytes;
    long totalInstances;
    long totalHeapBytes;
    long totalHeapInstances;

    HeapHistogramImpl() {
    }

    HeapHistogramImpl(String histogramText) {
        HashMap<String, ClassInfoImpl> classesMap = new HashMap<String, ClassInfoImpl>(1024);
        HashMap permGenMap = new HashMap(1024);
        this.time = new Date();
        Scanner sc = new Scanner(histogramText);
        sc.useRadix(10);
        while (!sc.hasNext("-+")) {
            sc.nextLine();
        }
        sc.skip("-+");
        sc.nextLine();
        while (sc.hasNext("[0-9]+:")) {
            ClassInfoImpl newClInfo = new ClassInfoImpl(sc);
            this.storeClassInfo(newClInfo, classesMap);
            this.totalHeapBytes += newClInfo.getBytes();
            this.totalHeapInstances += newClInfo.getInstancesCount();
        }
        sc.next("Total");
        this.totalInstances = sc.nextLong();
        this.totalBytes = sc.nextLong();
        this.classes = new HashSet(classesMap.values());
    }

    void storeClassInfo(ClassInfoImpl newClInfo, Map<String, ClassInfoImpl> map) {
        ClassInfoImpl oldClInfo = map.get(newClInfo.getName());
        if (oldClInfo == null) {
            map.put(newClInfo.getName(), newClInfo);
        } else {
            oldClInfo.bytes += newClInfo.getBytes();
            oldClInfo.instances += newClInfo.getInstancesCount();
        }
    }

    public Date getTime() {
        return (Date)this.time.clone();
    }

    public Set<HeapHistogram.ClassInfo> getHeapHistogram() {
        return this.classes;
    }

    public long getTotalInstances() {
        return this.totalInstances;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getTotalHeapInstances() {
        return this.totalHeapInstances;
    }

    public long getTotalHeapBytes() {
        return this.totalHeapBytes;
    }

    public Set<HeapHistogram.ClassInfo> getPermGenHistogram() {
        return Collections.EMPTY_SET;
    }

    public long getTotalPerGenInstances() {
        return -1L;
    }

    public long getTotalPermGenHeapBytes() {
        return -1L;
    }

    static class ClassInfoImpl
    extends HeapHistogram.ClassInfo {
        long instances;
        long bytes;
        String name;

        ClassInfoImpl(Scanner sc) {
            sc.next();
            this.instances = sc.nextLong();
            this.bytes = sc.nextLong();
            String jvmName = sc.next();
            sc.nextLine();
            this.name = this.convertJVMName(jvmName);
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.instances;
        }

        public long getBytes() {
            return this.bytes;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassInfoImpl) {
                return this.getName().equals(((ClassInfoImpl)((Object)obj)).getName());
            }
            return false;
        }

        private String convertJVMName(String jvmName) {
            String className = null;
            int index = jvmName.lastIndexOf(91);
            if (index != -1) {
                switch (jvmName.charAt(index + 1)) {
                    case 'Z': {
                        className = HeapHistogramImpl.BOOLEAN_TEXT;
                        break;
                    }
                    case 'C': {
                        className = HeapHistogramImpl.CHAR_TEXT;
                        break;
                    }
                    case 'B': {
                        className = HeapHistogramImpl.BYTE_TEXT;
                        break;
                    }
                    case 'S': {
                        className = HeapHistogramImpl.SHORT_TEXT;
                        break;
                    }
                    case 'I': {
                        className = HeapHistogramImpl.INT_TEXT;
                        break;
                    }
                    case 'J': {
                        className = HeapHistogramImpl.LONG_TEXT;
                        break;
                    }
                    case 'F': {
                        className = HeapHistogramImpl.FLOAT_TEXT;
                        break;
                    }
                    case 'D': {
                        className = HeapHistogramImpl.DOUBLE_TEXT;
                        break;
                    }
                    case 'L': {
                        className = jvmName.substring(index + 2, jvmName.length() - 1);
                        break;
                    }
                    default: {
                        System.err.println("Uknown name " + jvmName);
                        className = jvmName;
                    }
                }
                for (int i = 0; i <= index; ++i) {
                    className = className + "[]";
                }
            }
            if (className == null) {
                className = jvmName;
            }
            return className.intern();
        }
    }
}

