/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.sampler;

import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventChecker;
import org.graalvm.visualvm.jfr.views.sampler.JFRSnapshotSamplerView;

public final class JFRSnapshotSamplerViewProvider
extends DataSourceViewProvider<JFRSnapshot> {
    static final String EVENT_EXECUTION_SAMPLE = "jdk.ExecutionSample";
    static final String EVENT_NATIVE_SAMPLE = "jdk.NativeMethodSample";
    static final String EVENT_THREAD_CPU = "jdk.ThreadCPULoad";
    static final String EVENT_OBJECT_COUNT = "jdk.ObjectCount";
    static final String EVENT_THREAD_ALLOCATIONS = "jdk.ThreadAllocationStatistics";

    protected boolean supportsViewFor(JFRSnapshot jfrSnapshot) {
        return true;
    }

    protected DataSourceView createView(JFRSnapshot jfrSnapshot) {
        return new JFRSnapshotSamplerView(jfrSnapshot);
    }

    public static final class ThreadAllocationsChecker
    extends JFREventChecker {
        public ThreadAllocationsChecker() {
            super(ThreadAllocationsChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotSamplerViewProvider.EVENT_THREAD_ALLOCATIONS};
        }
    }

    public static final class ObjectCountChecker
    extends JFREventChecker {
        public ObjectCountChecker() {
            super(ObjectCountChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotSamplerViewProvider.EVENT_OBJECT_COUNT};
        }
    }

    public static final class ThreadCPUChecker
    extends JFREventChecker {
        public ThreadCPUChecker() {
            super(ThreadCPUChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotSamplerViewProvider.EVENT_THREAD_CPU};
        }
    }
}

