/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapFactory;
import org.graalvm.visualvm.lib.jfluid.heap.HeapProgress;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.graalvm.visualvm.lib.profiler.heapwalk.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.HeapFragmentWalker;
import org.graalvm.visualvm.lib.profiler.heapwalk.HeapWalkerManager;
import org.graalvm.visualvm.lib.profiler.heapwalk.ui.HeapWalkerUI;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class HeapWalker {
    private File heapDumpFile;
    private HeapFragmentWalker mainHeapWalker;
    private TopComponent heapWalkerUI;
    private Lookup.Provider heapDumpProject;
    private String heapWalkerName = Bundle.ClassesListController_HeapWalkerDefaultName();

    public HeapWalker(Heap heap) {
        this.createMainFragment(heap);
    }

    public HeapWalker(File heapFile) throws FileNotFoundException, IOException {
        this(HeapWalker.createHeap(heapFile));
        this.heapDumpFile = heapFile;
        this.heapDumpProject = HeapWalker.computeHeapDumpProject(this.heapDumpFile);
        String fileName = this.heapDumpFile.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex <= fileName.length() - 2) {
            fileName = fileName.substring(0, dotIndex);
        }
        this.heapWalkerName = ResultsManager.getDefault().getHeapDumpDisplayName(fileName);
    }

    public File getHeapDumpFile() {
        return this.heapDumpFile;
    }

    public Lookup.Provider getHeapDumpProject() {
        return this.heapDumpProject;
    }

    public HeapFragmentWalker getMainHeapWalker() {
        return this.mainHeapWalker;
    }

    public String getName() {
        return this.heapWalkerName;
    }

    public void open() {
        HeapWalkerManager.getDefault().openHeapWalker(this);
    }

    public TopComponent getTopComponent() {
        if (this.heapWalkerUI == null) {
            this.heapWalkerUI = new HeapWalkerUI(this);
        }
        return this.heapWalkerUI;
    }

    void createMainFragment(Heap heap) {
        this.mainHeapWalker = new HeapFragmentWalker(heap, this, true);
    }

    void createReachableFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    void createRetainedFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void computeRetainedSizes() {
        List classes = this.mainHeapWalker.getHeapFragment().getAllClasses();
        if (classes.size() > 0) {
            ProgressHandle pd = ProgressHandle.createHandle((String)Bundle.HeapFragmentWalker_ComputingRetainedMsg());
            pd.start();
            ((JavaClass)classes.get(0)).getRetainedSizeByClass();
            pd.finish();
        }
    }

    private static Lookup.Provider computeHeapDumpProject(File heapDumpFile) {
        if (heapDumpFile == null) {
            return null;
        }
        File heapDumpDir = heapDumpFile.getParentFile();
        if (heapDumpDir == null) {
            return null;
        }
        FileObject heapDumpDirObj = FileUtil.toFileObject((File)heapDumpDir);
        if (heapDumpDirObj == null || !heapDumpDirObj.isValid()) {
            return null;
        }
        return ProfilerStorage.getProjectFromFolder((FileObject)heapDumpDirObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Heap createHeap(File heapFile) throws FileNotFoundException, IOException {
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandle.createHandle((String)Bundle.ClassesListController_LoadingDumpMsg());
            pHandle.setInitialDelay(0);
            pHandle.start(2000);
            HeapWalker.setProgress(pHandle, 0);
            Heap heap = HeapFactory.createHeap((File)heapFile);
            HeapWalker.setProgress(pHandle, 1000);
            heap.getSummary();
            Heap heap2 = heap;
            return heap2;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }

    private static void setProgress(final ProgressHandle pHandle, final int offset) {
        final BoundedRangeModel progress = HeapProgress.getProgress();
        progress.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pHandle.progress(progress.getValue() + offset);
            }
        });
    }
}

