/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/RangeTo;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "rangeTypeToPrimitiveType", "Lorg/jetbrains/org/objectweb/asm/Type;", "rangeType", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend.jvm"})
public final class RangeTo
extends IntrinsicMethod {
    @NotNull
    public static final RangeTo INSTANCE = new RangeTo();

    private RangeTo() {
    }

    private final Type rangeTypeToPrimitiveType(Type rangeType) {
        Type type2;
        String name;
        String fqName2 = rangeType.getInternalName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "fqName");
        switch (name = StringsKt.substringBefore$default(StringsKt.substringAfter$default(fqName2, "kotlin/ranges/", null, 2, null), "Range", null, 2, null)) {
            case "Double": {
                Type type3 = Type.DOUBLE_TYPE;
                Intrinsics.checkNotNullExpressionValue(type3, "DOUBLE_TYPE");
                type2 = type3;
                break;
            }
            case "Float": {
                Type type4 = Type.FLOAT_TYPE;
                Intrinsics.checkNotNullExpressionValue(type4, "FLOAT_TYPE");
                type2 = type4;
                break;
            }
            case "Long": {
                Type type5 = Type.LONG_TYPE;
                Intrinsics.checkNotNullExpressionValue(type5, "LONG_TYPE");
                type2 = type5;
                break;
            }
            case "Int": {
                Type type6 = Type.INT_TYPE;
                Intrinsics.checkNotNullExpressionValue(type6, "INT_TYPE");
                type2 = type6;
                break;
            }
            case "Short": {
                Type type7 = Type.SHORT_TYPE;
                Intrinsics.checkNotNullExpressionValue(type7, "SHORT_TYPE");
                type2 = type7;
                break;
            }
            case "Char": {
                Type type8 = Type.CHAR_TYPE;
                Intrinsics.checkNotNullExpressionValue(type8, "CHAR_TYPE");
                type2 = type8;
                break;
            }
            case "Byte": {
                Type type9 = Type.BYTE_TYPE;
                Intrinsics.checkNotNullExpressionValue(type9, "BYTE_TYPE");
                type2 = type9;
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus("RangeTo intrinsic can only work for primitive types: ", fqName2));
            }
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature2, @NotNull JvmBackendContext context2) {
        Collection<Type> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object object = signature2.getReturnType();
        Intrinsics.checkNotNullExpressionValue(object, "signature.returnType");
        Type argType = this.rangeTypeToPrimitiveType((Type)object);
        Collection collection2 = CollectionsKt.listOf(argType);
        Iterable<JvmMethodParameterSignature> iterable = signature2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(iterable, "signature.valueParameters");
        iterable = iterable;
        Collection collection3 = collection2;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JvmMethodParameterSignature jvmMethodParameterSignature = (JvmMethodParameterSignature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Type type2 = argType;
            collection.add(type2);
        }
        collection = (List)destination$iv$iv;
        object = CollectionsKt.plus(collection3, (Iterable)collection);
        return new IrIntrinsicFunction(signature2, argType, expression2, context2, (List<Type>)object){
            final /* synthetic */ JvmMethodSignature $signature;
            final /* synthetic */ Type $argType;
            final /* synthetic */ IrFunctionAccessExpression $expression;
            final /* synthetic */ JvmBackendContext $context;
            {
                this.$signature = $signature;
                this.$argType = $argType;
                this.$expression = $expression;
                this.$context = $context;
                super($expression, $signature, $context, $super_call_param$1);
            }

            public void genInvokeInstruction(@NotNull InstructionAdapter v) {
                Intrinsics.checkNotNullParameter(v, "v");
                Type[] typeArray = new Type[]{this.$argType, this.$argType};
                v.invokespecial(this.$signature.getReturnType().getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, typeArray), false);
            }

            @NotNull
            public StackValue invoke(@NotNull InstructionAdapter v, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data, @NotNull IrFunctionAccessExpression expression2) {
                Intrinsics.checkNotNullParameter(v, "v");
                Intrinsics.checkNotNullParameter(codegen2, "codegen");
                Intrinsics.checkNotNullParameter(data, "data");
                Intrinsics.checkNotNullParameter(expression2, "expression");
                codegen2.markLineNumber(expression2);
                v.anew(this.getReturnType());
                v.dup();
                return super.invoke(v, codegen2, data, expression2);
            }
        };
    }
}

