(function() {
  var Injections, Scanner, ScopeSelector, _;

  _ = require('underscore-plus');

  Scanner = require('./scanner');

  ScopeSelector = require('./scope-selector');

  module.exports = Injections = (function() {
    function Injections(grammar, injections) {
      var pattern, patterns, regex, selector, values, _i, _len, _ref, _ref1;
      this.grammar = grammar;
      if (injections == null) {
        injections = {};
      }
      this.injections = [];
      this.scanners = {};
      for (selector in injections) {
        values = injections[selector];
        if (!((values != null ? (_ref = values.patterns) != null ? _ref.length : void 0 : void 0) > 0)) {
          continue;
        }
        patterns = [];
        _ref1 = values.patterns;
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          regex = _ref1[_i];
          pattern = this.grammar.createPattern(regex);
          patterns.push.apply(patterns, pattern.getIncludedPatterns(this.grammar, patterns));
        }
        this.injections.push({
          selector: new ScopeSelector(selector),
          patterns: patterns
        });
      }
    }

    Injections.prototype.getScanner = function(injection) {
      var scanner;
      if (injection.scanner != null) {
        return injection.scanner;
      }
      scanner = new Scanner(injection.patterns);
      injection.scanner = scanner;
      return scanner;
    };

    Injections.prototype.getScanners = function(ruleStack) {
      var injection, scanner, scanners, scopes, _i, _len, _ref;
      if (this.injections.length === 0) {
        return [];
      }
      scanners = [];
      scopes = this.grammar.scopesFromStack(ruleStack);
      _ref = this.injections;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        injection = _ref[_i];
        if (!(injection.selector.matches(scopes))) {
          continue;
        }
        scanner = this.getScanner(injection);
        scanners.push(scanner);
      }
      return scanners;
    };

    return Injections;

  })();

}).call(this);
