/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.projection.datum.NTV2Proj4DirGridShiftFileSource;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.PlatformVisitor;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public interface PlatformHook {
    public static final PlatformVisitor<PlatformHook> CONSTRUCT_FROM_PLATFORM = new PlatformVisitor<PlatformHook>(){

        @Override
        public PlatformHook visitUnixoid() {
            return new PlatformHookUnixoid();
        }

        @Override
        public PlatformHook visitWindows() {
            return new PlatformHookWindows();
        }

        @Override
        public PlatformHook visitOsx() {
            return new PlatformHookOsx();
        }
    };

    public Platform getPlatform();

    default public void preStartupHook() {
    }

    default public void afterPrefStartupHook() {
    }

    default public void startupHook(JavaExpirationCallback javaCallback, WebStartMigrationCallback webStartCallback) {
    }

    public void openUrl(String var1) throws IOException;

    public void initSystemShortcuts();

    public String getDefaultStyle();

    default public boolean canFullscreen() {
        return !GraphicsEnvironment.isHeadless() && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    default public boolean rename(File from, File to) {
        return from.renameTo(to);
    }

    public String getOSDescription();

    default public String getOSBuildNumber() {
        return "";
    }

    default public X509Certificate getX509Certificate(CertificateAmendment.NativeCertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return null;
    }

    default public String exec(String ... command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
            String string = Utils.strip(input.readLine());
            return string;
        }
    }

    public File getDefaultCacheDirectory();

    public File getDefaultPrefDirectory();

    public File getDefaultUserDataDirectory();

    default public List<File> getDefaultProj4NadshiftDirectories() {
        return this.getPlatform().accept(NTV2Proj4DirGridShiftFileSource.getInstance());
    }

    default public boolean isOpenJDK() {
        String javaHome = Utils.getSystemProperty("java.home");
        return javaHome != null && javaHome.contains("openjdk");
    }

    default public int getMenuShortcutKeyMaskEx() {
        return 128;
    }

    default public void checkExpiredJava(JavaExpirationCallback callback) {
        Date expiration = Utils.getJavaExpirationDate();
        if (expiration != null && expiration.before(new Date())) {
            String latestVersion = Utils.getJavaLatestVersion();
            String currentVersion = Utils.getSystemProperty("java.version");
            if (latestVersion == null || !latestVersion.equalsIgnoreCase(currentVersion)) {
                callback.askUpdateJava(latestVersion != null ? latestVersion : "latest", Config.getPref().get("java.update.url", "https://www.java.com/download"), DateUtils.getDateFormat(2).format(expiration), false);
            }
        }
    }

    default public void checkWebStartMigration(WebStartMigrationCallback callback) {
        if (Utils.isRunningJavaWebStart()) {
            callback.askMigrateWebStart(Config.getPref().get("openwebstart.download.url", "https://openwebstart.com/download/"));
        }
    }

    default public void setNativeOsCallback(NativeOsCallback callback) {
    }

    default public File resolveFileLink(File file) {
        return file;
    }

    default public Collection<String> getPossiblePreferenceDirs() {
        return Collections.emptyList();
    }

    public static interface NativeOsCallback {
        public void openFiles(List<File> var1);

        public boolean handleQuitRequest();

        public void handleAbout();

        public void handlePreferences();
    }

    @FunctionalInterface
    public static interface WebStartMigrationCallback {
        public void askMigrateWebStart(String var1);
    }

    @FunctionalInterface
    public static interface JavaExpirationCallback {
        public void askUpdateJava(String var1, String var2, String var3, boolean var4);
    }
}

