/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.Normalizer;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TokenQueue;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.CombiningEvaluator;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.Evaluator;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.Selector;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.StructuralEvaluator;

public class QueryParser {
    private static final String[] combinators = new String[]{",", ">", "+", "~", " "};
    private static final String[] AttributeEvals = new String[]{"=", "!=", "^=", "$=", "*=", "~="};
    private TokenQueue tq;
    private String query;
    private List<Evaluator> evals = new ArrayList<Evaluator>();
    private static final Pattern NTH_AB = Pattern.compile("(([+-])?(\\d+)?)n(\\s*([+-])?\\s*\\d+)?", 2);
    private static final Pattern NTH_B = Pattern.compile("([+-])?(\\d+)");

    /*
     * WARNING - void declaration
     */
    private QueryParser(String query) {
        void var1_1;
        Validate.notEmpty(query);
        this.query = query = query.trim();
        this.tq = new TokenQueue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Evaluator parse(String query) {
        try {
            query = new QueryParser((String)query);
            return ((QueryParser)query).parse();
        }
        catch (IllegalArgumentException e) {
            void var0_1;
            throw new Selector.SelectorParseException(var0_1.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    Evaluator parse() {
        this.tq.consumeWhitespace();
        if (this.tq.matchesAny(combinators)) {
            this.evals.add(new StructuralEvaluator.Root());
            QueryParser queryParser = this;
            queryParser.combinator(queryParser.tq.consume());
        } else {
            this.findElements();
        }
        while (!this.tq.isEmpty()) {
            void var1_1;
            boolean seenWhite = this.tq.consumeWhitespace();
            if (this.tq.matchesAny(combinators)) {
                QueryParser queryParser = this;
                queryParser.combinator(queryParser.tq.consume());
                continue;
            }
            if (var1_1 != false) {
                this.combinator(' ');
                continue;
            }
            this.findElements();
        }
        if (this.evals.size() == 1) {
            return this.evals.get(0);
        }
        return new CombiningEvaluator.And(this.evals);
    }

    /*
     * WARNING - void declaration
     */
    private void combinator(char combinator) {
        Evaluator rootEval;
        Evaluator currentEval;
        this.tq.consumeWhitespace();
        String string = this.consumeSubQuery();
        Evaluator newEval = QueryParser.parse(string);
        boolean replaceRightMost = false;
        if (this.evals.size() == 1) {
            currentEval = this.evals.get(0);
            rootEval = currentEval;
            if (currentEval instanceof CombiningEvaluator.Or && combinator != ',') {
                currentEval = ((CombiningEvaluator.Or)currentEval).rightMostEvaluator();
                replaceRightMost = true;
            }
        } else {
            currentEval = new CombiningEvaluator.And(this.evals);
            rootEval = currentEval;
        }
        this.evals.clear();
        if (combinator == '>') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.ImmediateParent(currentEval));
        } else if (combinator == ' ') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.Parent(currentEval));
        } else if (combinator == '+') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.ImmediatePreviousSibling(currentEval));
        } else if (combinator == '~') {
            currentEval = new CombiningEvaluator.And(newEval, new StructuralEvaluator.PreviousSibling(currentEval));
        } else if (combinator == ',') {
            void var1_2;
            CombiningEvaluator.Or or;
            if (currentEval instanceof CombiningEvaluator.Or) {
                or = (CombiningEvaluator.Or)currentEval;
                or.add(newEval);
            } else {
                or = new CombiningEvaluator.Or();
                or.add(currentEval);
                or.add(newEval);
            }
            currentEval = var1_2;
        } else {
            void var1_1;
            throw new Selector.SelectorParseException("Unknown combinator: " + (char)var1_1, new Object[0]);
        }
        if (replaceRightMost) {
            ((CombiningEvaluator.Or)rootEval).replaceRightMostEvaluator(currentEval);
        } else {
            void var3_6;
            rootEval = var3_6;
        }
        this.evals.add((Evaluator)((Object)string));
    }

    /*
     * WARNING - void declaration
     */
    private String consumeSubQuery() {
        void var1_1;
        StringBuilder sq = StringUtil.borrowBuilder();
        while (!this.tq.isEmpty()) {
            if (this.tq.matches("(")) {
                sq.append("(").append(this.tq.chompBalanced('(', ')')).append(")");
                continue;
            }
            if (this.tq.matches("[")) {
                sq.append("[").append(this.tq.chompBalanced('[', ']')).append("]");
                continue;
            }
            if (this.tq.matchesAny(combinators)) break;
            sq.append(this.tq.consume());
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    private void findElements() {
        if (this.tq.matchChomp("#")) {
            this.byId();
            return;
        }
        if (this.tq.matchChomp(".")) {
            this.byClass();
            return;
        }
        if (this.tq.matchesWord() || this.tq.matches("*|")) {
            this.byTag();
            return;
        }
        if (this.tq.matches("[")) {
            this.byAttribute();
            return;
        }
        if (this.tq.matchChomp("*")) {
            this.allElements();
            return;
        }
        if (this.tq.matchChomp(":lt(")) {
            this.indexLessThan();
            return;
        }
        if (this.tq.matchChomp(":gt(")) {
            this.indexGreaterThan();
            return;
        }
        if (this.tq.matchChomp(":eq(")) {
            this.indexEquals();
            return;
        }
        if (this.tq.matches(":has(")) {
            this.has();
            return;
        }
        if (this.tq.matches(":contains(")) {
            this.contains(false);
            return;
        }
        if (this.tq.matches(":containsOwn(")) {
            this.contains(true);
            return;
        }
        if (this.tq.matches(":containsData(")) {
            this.containsData();
            return;
        }
        if (this.tq.matches(":matches(")) {
            this.matches(false);
            return;
        }
        if (this.tq.matches(":matchesOwn(")) {
            this.matches(true);
            return;
        }
        if (this.tq.matches(":not(")) {
            this.not();
            return;
        }
        if (this.tq.matchChomp(":nth-child(")) {
            this.cssNthChild(false, false);
            return;
        }
        if (this.tq.matchChomp(":nth-last-child(")) {
            this.cssNthChild(true, false);
            return;
        }
        if (this.tq.matchChomp(":nth-of-type(")) {
            this.cssNthChild(false, true);
            return;
        }
        if (this.tq.matchChomp(":nth-last-of-type(")) {
            this.cssNthChild(true, true);
            return;
        }
        if (this.tq.matchChomp(":first-child")) {
            this.evals.add(new Evaluator.IsFirstChild());
            return;
        }
        if (this.tq.matchChomp(":last-child")) {
            this.evals.add(new Evaluator.IsLastChild());
            return;
        }
        if (this.tq.matchChomp(":first-of-type")) {
            this.evals.add(new Evaluator.IsFirstOfType());
            return;
        }
        if (this.tq.matchChomp(":last-of-type")) {
            this.evals.add(new Evaluator.IsLastOfType());
            return;
        }
        if (this.tq.matchChomp(":only-child")) {
            this.evals.add(new Evaluator.IsOnlyChild());
            return;
        }
        if (this.tq.matchChomp(":only-of-type")) {
            this.evals.add(new Evaluator.IsOnlyOfType());
            return;
        }
        if (this.tq.matchChomp(":empty")) {
            this.evals.add(new Evaluator.IsEmpty());
            return;
        }
        if (this.tq.matchChomp(":root")) {
            this.evals.add(new Evaluator.IsRoot());
            return;
        }
        if (this.tq.matchChomp(":matchText")) {
            this.evals.add(new Evaluator.MatchText());
            return;
        }
        throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
    }

    /*
     * WARNING - void declaration
     */
    private void byId() {
        void var1_1;
        String id = this.tq.consumeCssIdentifier();
        Validate.notEmpty(id);
        this.evals.add(new Evaluator.Id((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void byClass() {
        void var1_1;
        String className = this.tq.consumeCssIdentifier();
        Validate.notEmpty(className);
        this.evals.add(new Evaluator.Class(var1_1.trim()));
    }

    /*
     * WARNING - void declaration
     */
    private void byTag() {
        void var1_1;
        String tagName = Normalizer.normalize(this.tq.consumeElementSelector());
        Validate.notEmpty(tagName);
        if (tagName.startsWith("*|")) {
            this.evals.add(new CombiningEvaluator.Or(new Evaluator.Tag(tagName), new Evaluator.TagEndsWith(tagName.replace("*|", ":"))));
            return;
        }
        if (tagName.contains("|")) {
            tagName = tagName.replace("|", ":");
        }
        this.evals.add(new Evaluator.Tag((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void byAttribute() {
        void var1_1;
        TokenQueue cq = new TokenQueue(this.tq.chompBalanced('[', ']'));
        String key = cq.consumeToAny(AttributeEvals);
        Validate.notEmpty(key);
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            if (key.startsWith("^")) {
                this.evals.add(new Evaluator.AttributeStarting(key.substring(1)));
                return;
            }
            this.evals.add(new Evaluator.Attribute(key));
            return;
        }
        if (cq.matchChomp("=")) {
            this.evals.add(new Evaluator.AttributeWithValue(key, cq.remainder()));
            return;
        }
        if (cq.matchChomp("!=")) {
            this.evals.add(new Evaluator.AttributeWithValueNot(key, cq.remainder()));
            return;
        }
        if (cq.matchChomp("^=")) {
            this.evals.add(new Evaluator.AttributeWithValueStarting(key, cq.remainder()));
            return;
        }
        if (cq.matchChomp("$=")) {
            this.evals.add(new Evaluator.AttributeWithValueEnding(key, cq.remainder()));
            return;
        }
        if (cq.matchChomp("*=")) {
            this.evals.add(new Evaluator.AttributeWithValueContaining(key, cq.remainder()));
            return;
        }
        if (cq.matchChomp("~=")) {
            void var2_2;
            this.evals.add(new Evaluator.AttributeWithValueMatching((String)var2_2, Pattern.compile(cq.remainder())));
            return;
        }
        throw new Selector.SelectorParseException("Could not parse attribute query '%s': unexpected token at '%s'", this.query, var1_1.remainder());
    }

    private void allElements() {
        this.evals.add(new Evaluator.AllElements());
    }

    private void indexLessThan() {
        this.evals.add(new Evaluator.IndexLessThan(this.consumeIndex()));
    }

    private void indexGreaterThan() {
        this.evals.add(new Evaluator.IndexGreaterThan(this.consumeIndex()));
    }

    private void indexEquals() {
        this.evals.add(new Evaluator.IndexEquals(this.consumeIndex()));
    }

    /*
     * WARNING - void declaration
     */
    private void cssNthChild(boolean backwards, boolean ofType) {
        void var3_4;
        void var1_1;
        void var2_2;
        void b;
        void a2;
        int b2;
        int a2;
        String argS = Normalizer.normalize(this.tq.chompTo(")"));
        Matcher mAB = NTH_AB.matcher(argS);
        Matcher mB = NTH_B.matcher(argS);
        if ("odd".equals(argS)) {
            a2 = 2;
            b2 = 1;
        } else if ("even".equals(a2)) {
            a2 = 2;
            b2 = 0;
        } else if (b.matches()) {
            a2 = b.group(3) != null ? Integer.parseInt(b.group(1).replaceFirst("^\\+", "")) : 1;
            b2 = b.group(4) != null ? Integer.parseInt(b.group(4).replaceFirst("^\\+", "")) : 0;
        } else if (mB.matches()) {
            a2 = 0;
            b2 = Integer.parseInt(mB.group().replaceFirst("^\\+", ""));
        } else {
            throw new Selector.SelectorParseException("Could not parse nth-index '%s': unexpected format", a2);
        }
        if (var2_2 != false) {
            if (backwards) {
                this.evals.add(new Evaluator.IsNthLastOfType(a2, b2));
                return;
            }
            this.evals.add(new Evaluator.IsNthOfType(a2, b2));
            return;
        }
        if (var1_1 != false) {
            this.evals.add(new Evaluator.IsNthLastChild(a2, b2));
            return;
        }
        this.evals.add(new Evaluator.IsNthChild((int)var3_4, b2));
    }

    /*
     * WARNING - void declaration
     */
    private int consumeIndex() {
        void var1_1;
        String indexS = this.tq.chompTo(")").trim();
        Validate.isTrue(StringUtil.isNumeric(indexS), "Index must be numeric");
        return Integer.parseInt((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void has() {
        void var1_1;
        this.tq.consume(":has");
        String subQuery = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(subQuery, ":has(el) subselect must not be empty");
        this.evals.add(new StructuralEvaluator.Has(QueryParser.parse((String)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private void contains(boolean own) {
        void var2_2;
        void var1_1;
        this.tq.consume(own ? ":containsOwn" : ":contains");
        String searchText = TokenQueue.unescape(this.tq.chompBalanced('(', ')'));
        Validate.notEmpty(searchText, ":contains(text) query must not be empty");
        if (var1_1 != false) {
            this.evals.add(new Evaluator.ContainsOwnText(searchText));
            return;
        }
        this.evals.add(new Evaluator.ContainsText((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private void containsData() {
        void var1_1;
        this.tq.consume(":containsData");
        String searchText = TokenQueue.unescape(this.tq.chompBalanced('(', ')'));
        Validate.notEmpty(searchText, ":containsData(text) query must not be empty");
        this.evals.add(new Evaluator.ContainsData((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void matches(boolean own) {
        void var2_2;
        void var1_1;
        this.tq.consume(own ? ":matchesOwn" : ":matches");
        String regex = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(regex, ":matches(regex) query must not be empty");
        if (var1_1 != false) {
            this.evals.add(new Evaluator.MatchesOwn(Pattern.compile(regex)));
            return;
        }
        this.evals.add(new Evaluator.Matches(Pattern.compile((String)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    private void not() {
        void var1_1;
        this.tq.consume(":not");
        String subQuery = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(subQuery, ":not(selector) subselect must not be empty");
        this.evals.add(new StructuralEvaluator.Not(QueryParser.parse((String)var1_1)));
    }
}

