/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.MissingResourceException;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NbDocsStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("nbdocs")) {
            return new NbDocsURLConnection(uRL);
        }
        throw new IOException("mismatched protocol");
    }

    @Override
    protected synchronized InetAddress getHostAddress(URL uRL) {
        if (uRL.getProtocol().equals("nbdocs")) {
            return null;
        }
        return super.getHostAddress(uRL);
    }

    private static final class InfoURLConnection
    extends URLConnection {
        private ByteArrayInputStream stream;
        private String moduleName;

        public InfoURLConnection(URL uRL, String string) {
            super(uRL);
            this.moduleName = string;
        }

        @Override
        public synchronized void connect() throws IOException {
            if (!this.connected) {
                InputStream inputStream = this.url.openStream();
                if (inputStream == null) {
                    throw new IOException("Info file not found.");
                }
                byte[] byArray = this.readData(inputStream);
                String string = new String(byArray, "UTF-8");
                String string2 = string.replaceAll("\\{0\\}", this.moduleName);
                byArray = string2.getBytes("UTF-8");
                this.stream = new ByteArrayInputStream(byArray);
                this.connected = true;
            }
        }

        private byte[] readData(InputStream inputStream) throws IOException {
            int n = 4096;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[]{};
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if ((n2 = inputStream.read(byArray)) == -1) {
                    byte[] byArray3 = new byte[n3];
                    System.arraycopy(byArray2, 0, byArray3, 0, n3);
                    return byArray3;
                }
                if (n4 < n3 + n2) {
                    byte[] byArray4 = new byte[byArray2.length];
                    System.arraycopy(byArray2, 0, byArray4, 0, n3);
                    byArray2 = new byte[n4 + n];
                    n4 += n;
                    System.arraycopy(byArray4, 0, byArray2, 0, n3);
                }
                System.arraycopy(byArray, 0, byArray2, n3, n2);
                n3 += n2;
            }
        }

        private void tryToConnect() {
            if (this.connected) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.stream;
        }

        @Override
        public String getContentType() {
            return "text/html";
        }

        @Override
        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.stream.available();
            }
            return 0;
        }
    }

    private static final class NbDocsURLConnection
    extends URLConnection {
        private URLConnection real = null;
        private IOException exception = null;

        public NbDocsURLConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException iOException = this.exception;
                this.exception = null;
                throw iOException;
            }
            if (!this.connected) {
                URL uRL;
                String string;
                String string2;
                int n;
                Object object;
                String string3 = this.url.getHost();
                if (string3.length() > 0) {
                    object = NbDocsURLConnection.findModule(string3);
                    if (object != null) {
                        if (!object.isEnabled()) {
                            URL uRL2 = new URL("nbdocs:/org/netbeans/modules/javahelp/resources/notEnabledModule.html");
                            String string4 = object.getDisplayName();
                            this.real = new InfoURLConnection(uRL2, string4);
                            this.real.connect();
                            this.connected = true;
                            return;
                        }
                    } else {
                        URL uRL3 = new URL("nbdocs:/org/netbeans/modules/javahelp/resources/notInstalledModule.html");
                        String string5 = "";
                        try {
                            string5 = NbBundle.getMessage(NbDocsStreamHandler.class, (String)string3);
                        }
                        catch (MissingResourceException missingResourceException) {
                            string5 = string3;
                        }
                        this.real = new InfoURLConnection(uRL3, string5);
                        this.real.connect();
                        this.connected = true;
                        return;
                    }
                }
                if (((String)(object = this.url.getFile())).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                if ((n = ((String)object).lastIndexOf(46)) != -1 && n > ((String)object).lastIndexOf(47)) {
                    string2 = ((String)object).substring(n + 1);
                    string = ((String)object).substring(0, n).replace('/', '.');
                } else {
                    string2 = null;
                    string = ((String)object).replace('/', '.');
                }
                try {
                    uRL = NbBundle.getLocalizedFile((String)string, (String)string2);
                }
                catch (MissingResourceException missingResourceException) {
                    File file;
                    if (string3.isEmpty() && ((String)object).equals("org/netbeans/modules/usersguide/ide.css")) {
                        string3 = "org.netbeans.modules.usersguide";
                    }
                    if ((file = InstalledFileLocator.getDefault().locate("docs/" + (String)object, string3.isEmpty() ? null : string3, true)) != null) {
                        uRL = Utilities.toURI((File)file).toURL();
                    }
                    IOException iOException = new IOException("cannot connect to " + this.url + ": " + missingResourceException);
                    iOException.initCause(missingResourceException);
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(NbDocsStreamHandler.class, (String)"EXC_nbdocs_cannot_connect", (Object)this.url));
                    throw iOException;
                }
                this.real = uRL.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private static ModuleInfo findModule(String string) {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
            for (ModuleInfo moduleInfo : result.allInstances()) {
                if (!moduleInfo.getCodeNameBase().equals(string)) continue;
                return moduleInfo;
            }
            return null;
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        @Override
        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        @Override
        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        @Override
        public String getHeaderField(String string) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(string);
            }
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        @Override
        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        @Override
        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }
    }
}

