/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.IWaySegment;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

public final class WaySegment
extends IWaySegment<Node, Way> {
    public WaySegment(Way way, int i) {
        super(way, i);
    }

    public static WaySegment forNodePair(Way way, Node first, Node second) {
        for (int endIndex = way.getNodesCount() - 1; endIndex > 0; --endIndex) {
            int indexOfFirst = way.getNodes().subList(0, endIndex).lastIndexOf(first);
            if (!second.equals(way.getNode(indexOfFirst + 1))) continue;
            return new WaySegment(way, indexOfFirst);
        }
        throw new IllegalArgumentException("Node pair is not part of way!");
    }

    @Override
    public Way toWay() {
        Way w = new Way();
        w.addNode((Node)this.getFirstNode());
        w.addNode((Node)this.getSecondNode());
        return w;
    }

    @Override
    public String toString() {
        return "WaySegment [way=" + ((Way)this.getWay()).getUniqueId() + ", lowerIndex=" + this.getLowerIndex() + ']';
    }
}

