/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.Component;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTransferHandler;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddFromSelectionAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.Logging;

public class PasteMembersAction
extends AddFromSelectionAction
implements FlavorListener {
    private static final long serialVersionUID = 1L;

    public PasteMembersAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, new IRelationEditorUpdateOn[0]);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            new MemberTransferHandler().importData(this.getSupport());
        }
        catch (IllegalStateException ex) {
            Logging.error(ex);
        }
    }

    private TransferHandler.TransferSupport getSupport() {
        return new TransferHandler.TransferSupport((Component)this.editorAccess.getMemberTable(), Optional.ofNullable(ClipboardUtils.getClipboardContent()).orElseThrow(() -> new IllegalStateException("Failed to retrieve clipboard content")));
    }

    @Override
    protected void updateEnabledState() {
        try {
            this.setEnabled(new MemberTransferHandler().canImport(this.getSupport()));
        }
        catch (IllegalStateException ex) {
            Logging.error(ex);
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateEnabledState();
    }
}

