/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangeReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class OsmChangeImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("osc", "osc", I18n.tr("OsmChange File", new Object[0]), true);

    public OsmChangeImporter() {
        super(FILE_FILTER);
    }

    public OsmChangeImporter(ExtensionFileFilter filter) {
        super(filter);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try {
            this.importData(Compression.getUncompressedFileInputStream(file), file, progressMonitor);
        }
        catch (FileNotFoundException e) {
            Logging.error(e);
            throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getName()), e);
        }
    }

    protected void importData(InputStream in, File associatedFile, ProgressMonitor progressMonitor) throws IllegalDataException {
        boolean hasNotes;
        Pair<DataSet, NoteData> p = OsmChangeReader.parseDataSetAndNotes(in, progressMonitor);
        boolean hasOsmData = p.a != null && !((DataSet)p.a).allPrimitives().isEmpty();
        boolean bl = hasNotes = p.b != null && !((NoteData)p.b).getNotes().isEmpty();
        if (hasOsmData) {
            this.addLayer(new OsmDataLayer((DataSet)p.a, associatedFile.getName(), associatedFile));
        }
        if (hasNotes) {
            this.addLayer(new NoteLayer((NoteData)p.b, associatedFile.getName()));
        }
        if (!hasOsmData && !hasNotes) {
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("No data found in file {0}.", associatedFile.getPath()), I18n.tr("Open OsmChange file", new Object[0]), 1));
        }
    }

    protected void addLayer(Layer layer) {
        GuiHelper.runInEDT(() -> {
            MainApplication.getLayerManager().addLayer(layer);
            layer.onPostLoadFromFile();
        });
    }
}

