/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.project.MavenProject;

public class ReactorBuildStatus {
    private final ProjectDependencyGraph projectDependencyGraph;
    private final Collection<String> blackListedProjects = Collections.synchronizedSet(new HashSet());
    private volatile boolean halted = false;

    public ReactorBuildStatus(ProjectDependencyGraph projectDependencyGraph) {
        this.projectDependencyGraph = projectDependencyGraph;
    }

    public boolean isBlackListed(MavenProject project2) {
        return this.blackListedProjects.contains(BuilderCommon.getKey(project2));
    }

    public void blackList(MavenProject project2) {
        if (this.blackListedProjects.add(BuilderCommon.getKey(project2)) && this.projectDependencyGraph != null) {
            for (MavenProject downstreamProject : this.projectDependencyGraph.getDownstreamProjects(project2, true)) {
                this.blackListedProjects.add(BuilderCommon.getKey(downstreamProject));
            }
        }
    }

    public void halt() {
        this.halted = true;
    }

    public boolean isHalted() {
        return this.halted;
    }

    public boolean isHaltedOrBlacklisted(MavenProject mavenProject) {
        return this.isBlackListed(mavenProject) || this.isHalted();
    }
}

