/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jnati.config.ResolvingProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private Map<String, String> parameters;
    private ResolvingProperties base;
    private ResolvingProperties loaded;
    private ResolvingProperties runtime;

    public Configuration() {
        this(null);
    }

    public Configuration(Map<String, String> params) {
        if (params != null) {
            this.parameters = new HashMap<String, String>(params);
        }
        this.base = new ResolvingProperties(this.parameters);
        this.loaded = new ResolvingProperties(this.base, this.parameters);
        this.runtime = new ResolvingProperties(this.loaded, this.parameters);
        this.runtime.putAll((Map<?, ?>)System.getProperties());
    }

    public Configuration(Configuration parentConfig, Map<String, String> params) {
        if (parentConfig.parameters != null) {
            this.parameters = new HashMap<String, String>(parentConfig.parameters);
            if (params != null) {
                this.parameters.putAll(params);
            }
        } else if (params != null) {
            this.parameters = new HashMap<String, String>(params);
        }
        this.base = new ResolvingProperties(this.parameters);
        this.base.putAll((Map<?, ?>)parentConfig.base);
        this.loaded = new ResolvingProperties(this.base, this.parameters);
        this.loaded.putAll((Map<?, ?>)parentConfig.loaded);
        this.runtime = new ResolvingProperties(this.loaded, this.parameters);
        this.runtime.putAll((Map<?, ?>)parentConfig.runtime);
        this.runtime.putAll((Map<?, ?>)System.getProperties());
    }

    public void loadDefaults(InputStream in) throws IOException {
        this.base.load(in);
    }

    public void setDefaults(Map<String, String> defaults) {
        this.base.putAll(defaults);
    }

    public void loadConfiguration(InputStream in) throws IOException {
        this.loaded.load(in);
    }

    public void setConfiguration(Map<String, String> config) {
        this.loaded.putAll(config);
    }

    public String getProperty(String key) {
        return this.runtime.getProperty(key);
    }
}

