/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pcm extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_GE = "J\u1ecd\u0301jia";
        final String metaValue_JP = "Japan";
        final String metaValue_MN = "M\u1ecdng\u00f3lia";
        final String metaValue_TR = "T\u1ecd\u0301ki";
        final String metaValue_th = "Ta\u00ed";
        final String metaValue_Hans = "\u00cdz\u00ed Chain\u00edz L\u00e1ngwej";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "ksh", "K\u1ecdl\u00f3ni\u00e1n L\u00e1ngwej" },
            { "nyn", "Nyank\u00f3l\u1eb9" },
            { "luo", "Lu\u00f3 L\u00e1ngwej" },
            { "Zsym", "S\u00edmbuls" },
            { "fil", "Filip\u00edn\u00f3 L\u00e1ngwej" },
            { "hmn", "M\u1ecd\u0301ng L\u00e1ngwej" },
            { "Zsye", "\u1eb8\u0301m\u00f3ji" },
            { "ccp", "Ch\u00e1kma L\u00e1ngwej" },
            { "luy", "Luyia L\u00e1ngwej" },
            { "bas", "B\u00e1saa L\u00e1ngwej" },
            { "es_ES", "Y\u00farop Sp\u00e1nish" },
            { "teo", "T\u1eb9\u0301so" },
            { "AC", "As\u1eb9\u0301nsh\u1ecd\u0301n A\u00edland" },
            { "AD", "And\u1ecd\u0301ra" },
            { "AE", "Yuna\u00edt\u1eb9\u0301d \u00c1r\u00e1b \u1eb8\u0301m\u00edrets" },
            { "nl_BE", "Fl\u1eb9\u0301mish L\u00e1ngwej" },
            { "AF", "Afg\u00e1n\u00edstan" },
            { "af", "\u00c1fr\u00edkaans L\u00e1ngwej" },
            { "AG", "Ant\u00edgwua & Barb\u00fada" },
            { "type.ca.ethiopic", "\u1eb8ti\u00f3pi\u00e1 Kal\u1eb9\u0301nda" },
            { "AI", "Angw\u00edla" },
            { "ak", "Akan L\u00e1ngwej" },
            { "AL", "Alb\u00e9nia" },
            { "AM", "Arm\u1eb9\u0301ni\u00e1" },
            { "am", "Amh\u00e1r\u00edk L\u00e1ngwej" },
            { "Arab", "Ar\u00e1b\u00edk" },
            { "AO", "Ang\u00f3la" },
            { "Jpan", metaValue_JP },
            { "AQ", "Ant\u00e1kt\u00edka" },
            { "AR", "Aj\u1eb9nt\u00edna" },
            { "ar", "Ar\u00e1b\u00edk L\u00e1ngwej" },
            { "Hrkt", "P\u00e1t \u1ecdf Jap\u00e1n Ra\u00edt\u00edn S\u00edst\u1eb9m" },
            { "AS", "Am\u1eb9\u0301r\u00edk\u00e1 Samoa" },
            { "as", "Asam\u00edz L\u00e1ngwej" },
            { "AT", "\u1ecc\u0301stria" },
            { "AU", "\u1eccstr\u00e9lia" },
            { "AW", "Ar\u00faba" },
            { "en_US", "Am\u1eb9\u0301r\u00edka \u00cdnglish" },
            { "AX", "\u1ecc\u0301l\u00e1nd A\u00edlands" },
            { "AZ", "Az\u1eb9rbaijan" },
            { "az", "Az\u1eb9rbaij\u00e1ni L\u00e1ngwej" },
            { "BA", "B\u1ecd\u0301zni\u00e1 & H\u1eb9z\u1eb9gov\u00edna" },
            { "BB", "Barb\u00e9d\u1ecds" },
            { "ceb", "S\u1eb9bu\u00e1no L\u00e1ngwej" },
            { "BD", "Banglad\u1eb9sh" },
            { "BE", "B\u1eb9\u0301lj\u1ecdm" },
            { "be", "B\u1eb9lar\u00fasi\u00e1 L\u00e1ngwej" },
            { "BF", "Burk\u00edna F\u00e1so" },
            { "BG", "B\u1ecdlg\u00e9ria" },
            { "bg", "B\u1ecdlg\u00e9ri\u00e1 L\u00e1ngwej" },
            { "BH", "Barein" },
            { "BI", "Bur\u00fandi" },
            { "BJ", "Binin" },
            { "BL", "S\u00e9nt Bat\u1eb9l\u1eb9\u0301mi" },
            { "BM", "B\u1eb9mi\u00fada" },
            { "bm", "Bamb\u00e1ra L\u00e1ngwej" },
            { "BN", "Brun\u1eb9i" },
            { "bn", "B\u00e1ngla L\u00e1ngwej" },
            { "BO", "Bol\u00edvia" },
            { "bo", "Tib\u1eb9\u0301tan" },
            { "BQ", "Kar\u00edbi\u00e1n N\u1eb9\u0301dalands" },
            { "BR", "Br\u00e1zil" },
            { "br", "Br\u1eb9\u0301t\u1ecdn L\u00e1ngwej" },
            { "BS", "Bah\u00e1mas" },
            { "bs", "B\u1ecd\u0301sni\u00e1 L\u00e1ngwej" },
            { "xog", "s\u00f3ga" },
            { "BT", "Butan" },
            { "BV", "Buv\u1eb9\u0301 A\u00edland" },
            { "BW", "Botsw\u00e1na" },
            { "Mymr", "Mi\u00e1nmar" },
            { "type.nu.laoo", "Lao N\u1ecd\u0301mba-d\u1eb9m" },
            { "BY", "B\u1eb9\u0301larus" },
            { "seh", "S\u1eb9\u0301n\u00e1" },
            { "BZ", "B\u1eb9liz" },
            { "type.ca.persian", "P\u1eb9\u0301shia Kal\u1eb9\u0301nda" },
            { "type.nu.hebr", "H\u00edbru N\u1ecd\u0301mba-d\u1eb9m" },
            { "CA", "K\u00e1n\u00e1da" },
            { "ca", "K\u00e1t\u00e1la L\u00e1ngwej" },
            { "CC", "K\u00f3k\u00f3s A\u00edlands" },
            { "mzn", "Mazand\u1eb9r\u00e1n\u00ed L\u00e1ngwej" },
            { "ses", "K\u00f3irabor\u00f3 S\u1eb9\u0301nn\u00ed L\u00e1ngwej" },
            { "CD", "K\u00f3ng\u00f3 \u2013 Kinsh\u00e1sa" },
            { "ce", "Ch\u1eb9\u0301ch\u1eb9n L\u00e1ngwej" },
            { "CF", "S\u1eb9\u0301ntr\u00e1l \u00c1fr\u00edk\u00e1n Rip\u1ecd\u0301blik" },
            { "CG", "K\u00f3ngo \u2013 Br\u00e1zavil" },
            { "CH", "Sw\u00edtsaland" },
            { "CI", "A\u00edvri Kost" },
            { "CK", "K\u00fak A\u00edlands" },
            { "CL", "Ch\u00edl\u1eb9" },
            { "CM", "Kam\u1eb9run" },
            { "CN", "Cha\u00edna" },
            { "CO", "Kol\u00f3mbia" },
            { "co", "K\u1ecds\u00edkan L\u00e1ngwej" },
            { "CP", "Klipat\u1ecd\u0301n A\u00edland" },
            { "Orya", "\u00d3dia" },
            { "CR", "K\u00f3sta R\u00edka" },
            { "cs", "Ch\u1eb9\u0301k L\u00e1ngwej" },
            { "CU", "Ki\u00fab\u00e1" },
            { "cu", "Ch\u1ecd\u0301ch Sl\u00e1vik" },
            { "CV", "K\u00e9p V\u1eb9\u0301d" },
            { "CW", "Kiur\u00e1sao" },
            { "CX", "Kr\u00edsm\u00e1s A\u00edland" },
            { "CY", "Sa\u00edpr\u1ecds" },
            { "cy", "W\u1eb9lsh" },
            { "CZ", "Ch\u1eb9\u0301kia" },
            { "type.nu.ethi", "\u1eb8ti\u00f3pi\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "da", "D\u00e9n\u00edsh L\u00e1ngwej" },
            { "pt_PT", "Y\u00far\u00f3p P\u1ecdtiug\u00edz" },
            { "DE", "J\u00e1m\u00e1ni" },
            { "de", "J\u00e1m\u00e1n L\u00e1ngwej" },
            { "cgg", "Ch\u00edga L\u00e1ngwej" },
            { "DG", "Di\u1eb9\u0301g\u00f3 Garsia" },
            { "type.cf.standard", "N\u1ecd\u0301m\u00e1l W\u00e8 To Ar\u00e9nj M\u1ecdn\u00ed" },
            { "type.nu.deva", "D\u1eb9van\u00e1g\u00e1ri N\u1ecd\u0301mba-d\u1eb9m" },
            { "DJ", "Jib\u00fati" },
            { "DK", "D\u1eb9\u0301nmak" },
            { "Brai", "Bla\u00ednd P\u00edpol Ra\u00edt\u00edn S\u00edst\u1eb9m" },
            { "DM", "D\u1ecdm\u00edn\u00edka" },
            { "type.nu.armnlow", "Sm\u1ecd\u0301l Ta\u00edp Arm\u1eb9\u0301ni\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "DO", "D\u1ecdm\u00edn\u00edka Rip\u1ecd\u0301blik" },
            { "bem", "B\u1eb9\u0301mba L\u00e1ngwej" },
            { "es_419", "L\u00e1t\u00edn Am\u1eb9\u0301r\u00edka Sp\u00e1nish" },
            { "DZ", "Alj\u00edria" },
            { "dz", "Z\u1ecd\u0301ngka L\u00e1ngwej" },
            { "bez", "B\u1eb9\u0301na L\u00e1ngwej" },
            { "type.ca.chinese", "Cha\u00edn\u00edz Kal\u1eb9\u0301nda" },
            { "EA", "S\u1eb9\u00fata & M\u1eb9\u0301l\u00edla" },
            { "EC", "\u1eb8\u0301kwu\u00e1d\u1ecd" },
            { "dje", "Z\u00e1rm\u00e1" },
            { "type.nu.grek", "Gr\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "EE", "\u1eb8st\u00f3nia" },
            { "ee", "\u1eb8\u0301w\u1eb9\u0301 L\u00e1ngwej" },
            { "type.lb.normal", "N\u1ecd\u0301m\u00e1l La\u00edn Br\u1eb9k Sta\u00edl" },
            { "EG", "\u00cdjipt" },
            { "EH", "W\u1eb9\u0301st\u00e1n Sah\u00e1ra" },
            { "el", "Gr\u00edk L\u00e1ngwej" },
            { "en", "\u00cdnglish" },
            { "eo", "\u1eb8sper\u00e1nto L\u00e1ngwej" },
            { "chr", "Ch\u1eb9\u0301r\u00f3kii L\u00e1ngwej" },
            { "ER", "\u1eb8ritr\u1eb9\u0301a" },
            { "ES", "Spen" },
            { "es", "Sp\u00e1nish L\u00e1ngwej" },
            { "ET", "\u1eb8ti\u00f3pia" },
            { "et", "\u1eb8st\u00f3ni\u00e1 L\u00e1ngwej" },
            { "Hanb", "Han Wit Bopom\u00f3fo" },
            { "EU", "Yur\u00f3pi\u00e1n Y\u00fani\u1ecd\u0301n" },
            { "eu", "B\u00e1sk L\u00e1ngwej" },
            { "Hang", "H\u00e1ngul" },
            { "type.ca.gregorian", "Gr\u1eb9\u0301g\u00f3r\u00ed Kal\u1eb9\u0301nda" },
            { "EZ", "Y\u00far\u00f3\u00e9ria" },
            { "shi", "T\u00e1ch\u1eb9\u0301lit" },
            { "type.nu.gujr", "Gujar\u00e1t\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "hsb", "S\u00f3bi\u00e1 L\u00e1ngwej di \u1ecd\u0301p-\u1ecd\u0301p wan" },
            { "Hani", "Chainiz" },
            { "fa", "P\u1eb9\u0301shi\u00e1 L\u00e1ngwej" },
            { "Hans", metaValue_Hans },
            { "type.nu.latn", "W\u1eb9\u0301st\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "Hant", "N\u1ecd\u0301mal" },
            { "ff", "F\u00falan\u00ed L\u00e1ngwej" },
            { "FI", "F\u00ednland" },
            { "fi", "F\u00edn\u00edsh L\u00e1ngwej" },
            { "FJ", "F\u00edji" },
            { "FK", "F\u1ecd\u0301kl\u00e1nd A\u00edlands" },
            { "FM", "Maikron\u00edshia" },
            { "yue", "K\u00e1nt\u1ecdn L\u00e1ngwej" },
            { "FO", "F\u00e1ro A\u00edlands" },
            { "fo", "F\u00e1r\u00f3\u00eds L\u00e1ngwej" },
            { "Taml", "T\u00e1mil" },
            { "FR", "Frans" },
            { "fr", "Fr\u1eb9\u0301nch L\u00e1ngwej" },
            { "fy", "W\u1eb9\u0301st\u00e1n Fr\u00edsi\u00e1 L\u00e1ngwej" },
            { "GA", "Gab\u1ecdn" },
            { "ga", "A\u00edr\u00edsh L\u00e1ngwej" },
            { "GB", "Yun\u00e1\u00edt\u1eb9\u0301d K\u00ednd\u1ecdm" },
            { "pcm", "Naij\u00edri\u00e1 P\u00edjin" },
            { "GD", "Gr\u1eb9n\u00e9da" },
            { "gd", "Gael\u00edk L\u00e1ngwej \u1ecdf Gael P\u00edpol f\u1ecd Sk\u1ecd\u0301tland" },
            { "GE", metaValue_GE },
            { "GF", "Fr\u1eb9\u0301nch Gi\u00e1na" },
            { "GG", "Gu\u1eb9nzi" },
            { "GH", "G\u00e1na" },
            { "GI", "Jibr\u1ecd\u0301lta" },
            { "GL", "Gr\u00ednland" },
            { "gl", "Gal\u00edsi\u00e1 L\u00e1ngwej" },
            { "GM", "G\u00e1mbia" },
            { "GN", "G\u00edni" },
            { "GP", "Guadal\u00fap\u1eb9" },
            { "GQ", "Ikw\u00e9t\u00f3ri\u00e1l G\u00edni" },
            { "und", "L\u00e1ngwej w\u00e9 n\u00f3b\u1ecd\u0301di sabi" },
            { "GR", "Gris" },
            { "GS", "Sa\u00fat J\u1ecd\u0301jia an Sa\u00fat S\u00e1ndw\u00edch A\u00edlands" },
            { "GT", "Gu\u00e1t\u1eb9m\u00e1la" },
            { "GU", "Guam" },
            { "gu", "Gujar\u00e1t\u00ed L\u00e1ngwej" },
            { "gv", "M\u00e1nks L\u00e1ngwej" },
            { "GW", "G\u00edn\u00ed-Bis\u00e1u" },
            { "GY", "Gay\u00e1na" },
            { "ha", "H\u00e1us\u00e1 L\u00e1ngwej" },
            { "ckb", "M\u00edd\u00fal K\u1ecd\u0301dish L\u00e1ngwej" },
            { "zxx", "N\u00f3 L\u00e1ngw\u00e9j K\u1ecd\u0301nt\u1eb9nt" },
            { "he", "H\u00edbru L\u00e1ngwej" },
            { "hi", "H\u00edndi L\u00e1ngwej" },
            { "de_AT", "\u1ecc\u0301stria J\u00e1m\u00e1n" },
            { "HK", "H\u1ecdng K\u1ecdng SAR" },
            { "HM", "Hi\u00e1d & MakD\u00f3n\u00e1ld A\u00edlands" },
            { "HN", "H\u1ecdnd\u00faras" },
            { "HR", "Kro\u00e9shia" },
            { "hr", "Kro\u00e9shia L\u00e1ngwej" },
            { "agq", "Agh\u1eb9\u0301m L\u00e1ngwej" },
            { "gsw", "J\u00e1m\u00e1n Swis" },
            { "HT", "Ha\u00edti" },
            { "ht", "Ha\u00edt\u00ed Kriol" },
            { "HU", "H\u1ecd\u0301ng\u00e1ri" },
            { "hu", "H\u1ecdng\u00e1ri L\u00e1ngwej" },
            { "hy", "Arm\u1eb9\u0301ni\u00e1 L\u00e1ngwej" },
            { "ia", "Intal\u00edngwu\u00e1 L\u00e1ngwej" },
            { "IC", "Kener\u00ed A\u00edlands" },
            { "Jamo", "J\u00e1mo" },
            { "ID", "Indon\u00edshia" },
            { "id", "Indon\u00edshia L\u00e1ngwej" },
            { "type.nu.tibt", "T\u00edb\u1eb9t N\u1ecd\u0301mba-d\u1eb9m" },
            { "IE", "Ayaland" },
            { "ig", "Igbo L\u00e1ngwej" },
            { "naq", "Na\u00e1m\u00e1 L\u00e1ngwej" },
            { "ii", "S\u00edchuan Yi" },
            { "IL", "\u00cdzr\u1eb9l" },
            { "IM", "A\u00edl \u1ecdf Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Br\u00edt\u00edsh \u00cdndi\u00e1n \u00d3shen T\u1eb9\u0301r\u1eb9\u0301tri" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "A\u00edsland" },
            { "is", "A\u00edsl\u00e1nd L\u00e1ngwej" },
            { "IT", "\u00cdt\u00e1li" },
            { "it", "\u00cdt\u00e1li L\u00e1ngwej" },
            { "Zmth", "Matim\u00e1tiks Sains" },
            { "type.nu.thai", "Ta\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.beng", "B\u00e1ngl\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "ja", "Japan L\u00e1ngwej" },
            { "Mlym", "Mal\u00e9y\u00e1lam" },
            { "JE", "J\u1eb9\u0301si" },
            { "type.ca.islamic", "M\u00fasl\u00edm Kal\u1eb9\u0301nda" },
            { "JM", "Jama\u00edka" },
            { "Beng", "B\u00e1ngla" },
            { "JO", "J\u1ecd\u0301dan" },
            { "JP", metaValue_JP },
            { "jv", "Jav\u00e1n\u00edz L\u00e1ngwej" },
            { "guz", "Gus\u00ed L\u00e1ngwej" },
            { "type.nu.knda", "K\u00e1nn\u00e1d N\u1ecd\u0301mba-d\u1eb9m" },
            { "de_CH", "Sw\u00edtzaland Ha\u00ed J\u00e1m\u00e1n" },
            { "mai", "Ma\u00edt\u00edli" },
            { "smn", "\u00cdn\u00e1r\u00ed S\u00e1m\u00ed L\u00e1ngwej" },
            { "ka", "J\u1ecd\u0301ji\u00e1 L\u00e1ngwej" },
            { "type.ca.buddhist", "B\u00fad\u00edst Kal\u1eb9\u0301nda" },
            { "KE", "K\u1eb9\u0301nya" },
            { "419", "L\u00e1t\u00edn Am\u1eb9\u0301r\u00edka" },
            { "KG", "K\u1eb9j\u00edstan" },
            { "KH", "Kamb\u00f3dia" },
            { "KI", "Kirib\u00e1ti" },
            { "ki", "Kik\u00fay\u00fa L\u00e1ngwej" },
            { "mas", "Masa\u00ed L\u00e1ngwej" },
            { "kk", "Kaz\u00e1k L\u00e1ngwej" },
            { "kl", "Kal\u00e1l\u00eds\u00fat L\u00e1ngwej" },
            { "KM", "K\u1ecd\u0301m\u1ecd\u0301ros" },
            { "km", "Kma\u00ed L\u00e1ngwej" },
            { "KN", "Sent Kits & N\u1eb9\u0301vis" },
            { "kn", "K\u00e1nn\u00e1da L\u00e1ngwej" },
            { "Knda", "K\u00e1nnad Ra\u00edt\u00edn S\u00edst\u1eb9m" },
            { "fr_CA", "K\u00e1n\u00e1d\u00e1 Fr\u1eb9nch" },
            { "ko", "Kori\u00e1 L\u00e1ngwej" },
            { "KP", "N\u1ecd\u0301t Koria" },
            { "KR", "Sa\u00fat Koria" },
            { "ks", "Kashm\u00edr\u00ed L\u00e1ngwej" },
            { "ku", "K\u1ecd\u0301d\u00edsh L\u00e1ngwej" },
            { "fr_CH", "Sw\u00edtzal\u00e1nd Fr\u1eb9nch" },
            { "KW", "Kuw\u00e9t" },
            { "kw", "K\u1ecd\u0301nish L\u00e1ngwej" },
            { "KY", "K\u00e9man A\u00edlands" },
            { "ky", "Ki\u1eb9\u0301g\u00edz L\u00e1ngwej" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "S\u00edr\u00edlik" },
            { "LA", "Laos" },
            { "la", "L\u00e1t\u00edn L\u00e1ngwej" },
            { "LB", "L\u1eb9\u0301b\u00e1n\u1ecdn" },
            { "lb", "L\u1ecd\u0301ks\u00e9mb\u1ecd\u0301g L\u00e1ngwej" },
            { "LC", "Sent L\u00fashia" },
            { "type.nu.mlym", "Mal\u00e9y\u00e1lam N\u1ecd\u0301mba-d\u1eb9m" },
            { "lg", "G\u00e1nda L\u00e1ngwej" },
            { "nds", "L\u00f3 J\u00e1m\u00e1n L\u00e1ngwej" },
            { "LI", "L\u00edkt\u1eb9\u0301nstain" },
            { "LK", "Sri L\u00e1nka" },
            { "Tibt", "T\u00edb\u1eb9t" },
            { "ln", "Ling\u00e1l\u00e1 L\u00e1ngwej" },
            { "fur", "Fri\u00fali\u00e1n L\u00e1ngwej" },
            { "lo", "L\u00e1o L\u00e1ngwej" },
            { "type.ms.uksystem", "Imp\u1eb9\u0301ri\u00e1l S\u00edst\u1eb9m f\u1ecd M\u1eb9\u0301zh\u1ecd\u0301m\u1eb9nt" },
            { "LR", "Laib\u1eb9\u0301ria" },
            { "LS", "L\u1eb9s\u00f3to" },
            { "LT", "Litu\u00e9nia" },
            { "lt", "Litu\u00e9ni\u00e1 L\u00e1ngwej" },
            { "LU", "L\u1ecd\u0301ks\u1eb9\u0301mb\u1ecdg" },
            { "lu", "L\u00fab\u00e1-Kat\u00e1ng\u00e1 L\u00e1ngwej" },
            { "LV", "L\u00e1tvia" },
            { "lv", "L\u00e1tvi\u00e1n L\u00e1ngwej" },
            { "Kana", "Kat\u00e1k\u00e1na" },
            { "LY", "L\u00edbia" },
            { "vun", "V\u00fanjo" },
            { "lag", "Langi L\u00e1ngwej" },
            { "Thaa", "T\u00e1na" },
            { "MA", "Mor\u1ecdko" },
            { "MC", "M\u1ecd\u0301n\u00e1ko" },
            { "MD", "M\u1ecdld\u00f3va" },
            { "ME", "M\u1ecdntin\u00edgro" },
            { "MF", "Sent M\u00e1tin" },
            { "MG", "Madag\u00e1ska" },
            { "mg", "Malag\u00e1s\u00ed L\u00e1ngwej" },
            { "Thai", metaValue_th },
            { "MH", "M\u00e1sh\u00e1l A\u00edlands" },
            { "type.co.ducet", "Y\u00fan\u00edk\u00f3d M\u00e9n W\u00e8 To Ar\u00e9nj Tins W\u1eb9l" },
            { "mi", "Ma\u00f3r\u00ed L\u00e1ngwej" },
            { "MK", "N\u1ecd\u0301t Masid\u00f3nia" },
            { "mk", "Mas\u1eb9d\u00f3ni\u00e1 L\u00e1ngwej" },
            { "ML", "M\u00e1li" },
            { "ml", "Mal\u00e9y\u00e1l\u00e1m L\u00e1ngwej" },
            { "MM", "Mi\u00e1nma (B\u1ecd\u0301ma)" },
            { "MN", metaValue_MN },
            { "mn", "M\u1ecdng\u00f3li\u00e1 L\u00e1ngwej" },
            { "MO", "Mak\u00e1o SAR Cha\u00edna" },
            { "MP", "N\u1ecd\u0301t\u00e1n Mari\u00e1na A\u00edlands" },
            { "MQ", "Mat\u00ednik" },
            { "MR", "M\u1ecdrit\u00e9nia" },
            { "mr", "Mar\u00e1t\u00ed L\u00e1ngwej" },
            { "MS", "M\u1ecdnts\u1eb9rat" },
            { "ms", "Mal\u00e9 L\u00e1ngwej" },
            { "MT", "M\u1ecd\u0301lta" },
            { "mt", "M\u1ecd\u0301lt\u00e1 L\u00e1ngwej" },
            { "MU", "M\u1ecdr\u00edsh\u1ecds" },
            { "MV", "M\u1ecd\u0301ldivs" },
            { "MW", "Mal\u00e1wi" },
            { "MX", "M\u1eb9\u0301ks\u00edko" },
            { "type.ca.japanese", "Jap\u00e1n Kal\u1eb9\u0301nda" },
            { "MY", "Mal\u00e9shia" },
            { "my", "B\u1ecd\u0301ma L\u00e1ngwej" },
            { "MZ", "Moz\u00e1mbik" },
            { "Armn", "Arm\u1eb9\u0301nia" },
            { "dsb", "L\u00f3w\u00e1 Sorbi\u00e1" },
            { "NA", "Nam\u00edbia" },
            { "type.co.search", "J\u1eb9\u0301n\u00e1r\u00e1l Sachin" },
            { "202", "\u00c1fr\u00edka \u00c9ria Bil\u00f3 Sah\u00e1ra" },
            { "nb", "N\u1ecdw\u1eb9\u0301ji\u00e1 Bokm\u00e1l L\u00e1ngwej" },
            { "type.ca.hebrew", "H\u00edbr\u00fa Kal\u1eb9\u0301nda" },
            { "NC", "Ni\u00fa Kal\u1eb9d\u00f3nia" },
            { "nd", "N\u1ecd\u0301t\u00e1n Nd\u1eb9b\u1eb9l\u1eb9 L\u00e1ngwej" },
            { "NE", "Nizh\u1eb9r" },
            { "ne", "N\u1eb9p\u00e1l\u00ed L\u00e1ngwej" },
            { "NF", "N\u1ecd\u0301f\u1ecdlk A\u00edland" },
            { "NG", "Naij\u00edria" },
            { "NI", "Nikar\u00e1gwua" },
            { "NL", "N\u1eb9\u0301dalands" },
            { "nl", "D\u1ecdch L\u00e1ngwej" },
            { "nn", "N\u1ecdw\u1eb9\u0301ji\u00e1 Ni\u00fan\u1ecdsk" },
            { "NO", "N\u1ecd\u0301we" },
            { "NP", "N\u1eb9\u0301pal" },
            { "NR", "N\u00e1uru" },
            { "NU", "Ni\u00fa\u1eb9" },
            { "rof", "R\u00f3mbo" },
            { "ny", "Ny\u00e1nja" },
            { "NZ", "Ni\u00fa Z\u00edland" },
            { "kab", "Kabail L\u00e1ngwej" },
            { "kam", "K\u00e1mb\u00e1 L\u00e1ngwej" },
            { "mer", "M\u1eb9\u0301r\u00fa L\u00e1ngwej" },
            { "type.nu.armn", "Arm\u1eb9\u0301ni\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "OM", "Oman" },
            { "om", "Or\u00f3m\u00f3" },
            { "or", "\u00d3di\u00e1" },
            { "os", "Os\u1eb9\u0301tik" },
            { "mfe", "Mor\u00edsi\u1eb9\u0301n L\u00e1ngwej" },
            { "PA", "P\u00e1n\u00e1ma" },
            { "pa", "Punj\u00e1bi" },
            { "dua", "Du\u00e1la L\u00e1ngwej" },
            { "en_GB", "Br\u00edt\u00edsh \u00cdnglish" },
            { "PE", "P\u1eb9\u0301ru" },
            { "PF", "Fr\u1eb9\u0301nch Polin\u00edshia" },
            { "PG", "P\u00e1pu\u00e1 Ni\u00fa G\u00edni" },
            { "PH", "F\u00edl\u00edpins" },
            { "PK", "Pak\u00edstan" },
            { "PL", "P\u00f3land" },
            { "pl", "P\u00f3l\u00e1nd L\u00e1ngwej" },
            { "ewo", "\u1eb8wondo L\u00e1ngwej" },
            { "PM", "Sent Pi\u1eb9r & M\u00edk\u1eb9l\u1ecdn" },
            { "PN", "P\u00edtk\u00e9n A\u00edlands" },
            { "type.ca.dangi", "Dangi Kal\u1eb9\u0301nda" },
            { "PR", "Pu\u1eb9\u0301rto R\u00edk\u1ecd" },
            { "PS", "P\u00e1l\u1eb9\u0301sta\u00edn \u00c9ria-d\u1eb9m" },
            { "ps", "P\u00e1shto" },
            { "PT", "P\u1ecd\u0301t\u00fagal" },
            { "pt", "P\u1ecdtiugiz" },
            { "key.co", "Ar\u00e9nj Tins W\u1eb9l" },
            { "PW", "Palau" },
            { "type.nu.greklow", "Sm\u1ecd\u0301l Ta\u00edp Gr\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "PY", "P\u00e1r\u00e1gwue" },
            { "pt_BR", "Braz\u00edl P\u1ecdtiug\u00edz" },
            { "mgh", "Mak\u00faw\u00e1-M\u00edt\u00f3" },
            { "Hebr", "H\u00edbr\u00fa" },
            { "key.cf", "Ha\u00fa To Ar\u00e9nj M\u1ecdn\u00ed" },
            { "QA", "Kata" },
            { "key.ca", "Kal\u1eb9\u0301nda" },
            { "Laoo", "Lao" },
            { "mgo", "M\u1eb9ta\u2019 L\u00e1ngwej" },
            { "type.hc.h23", "24 \u00c1wa S\u00edst\u1eb9m (0\u201323)" },
            { "type.hc.h24", "24 \u00c1wa S\u00edst\u1eb9m (1\u201324)" },
            { "type.nu.mymr", "Mi\u00e1nma N\u1ecd\u0301mba-d\u1eb9m" },
            { "QO", "Rim\u00f3t P\u00e1t \u1ecdf Osh\u1eb9\u0301nia" },
            { "qu", "K\u1eb9chu\u00e1" },
            { "brx", "B\u00f3do L\u00e1ngwej" },
            { "kde", "Mak\u1ecd\u0301nd\u1eb9\u0301 L\u00e1ngwej" },
            { "001", "W\u1ecdld" },
            { "Ethi", "\u1eb8ti\u00f3pik" },
            { "002", "\u00c1fr\u00edka" },
            { "003", "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edka" },
            { "RE", "R\u00e9y\u00fani\u1ecdn" },
            { "type.hc.h12", "12 \u00c1wa S\u00edst\u1eb9m (1\u201312)" },
            { "005", "Sa\u00fat Am\u1eb9\u0301r\u00edka" },
            { "type.hc.h11", "12 \u00c1wa S\u00edst\u1eb9m (0\u201311)" },
            { "009", "Osh\u1eb9nia" },
            { "rm", "Rom\u00e1nsh" },
            { "rn", "R\u00fandi" },
            { "key.cu", "M\u1ecdn\u00ed" },
            { "RO", "Rum\u00e9nia" },
            { "ro", "Rom\u00e1ni\u00e1 L\u00e1ngwej" },
            { "RS", "S\u1eb9\u0301bia" },
            { "type.nu.orya", "\u00d3dia N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hanidec", "Chain\u00edz N\u1ecd\u0301mba-d\u1eb9m" },
            { "RU", "R\u1ecd\u0301shia" },
            { "ru", "R\u1ecdshi\u00e1 L\u00e1ngwej" },
            { "RW", "Ruw\u00e1nda" },
            { "rw", "Kinyarw\u00e1nda L\u00e1ngwej" },
            { "kea", "K\u00e1b\u00fav\u1eb9rdi\u00e1nu L\u00e1ngwej" },
            { "en_AU", "\u1eccstr\u00e9li\u00e1 \u00cdnglish" },
            { "SA", "Sa\u00fad\u00ed Ar\u00e9bia" },
            { "sa", "S\u00e1nskrit" },
            { "SB", "S\u00f3l\u00f3m\u1ecd\u0301n A\u00edlands" },
            { "twq", "Tasawak" },
            { "011", "W\u1eb9\u0301st\u00e1n \u00c1fr\u00edka" },
            { "SC", "S\u1eb9\u0301ch\u1eb9ls" },
            { "SD", "Sudan" },
            { "sd", "S\u00ednd\u00ed" },
            { "013", "M\u00edd\u00fal Am\u1eb9\u0301r\u00edka" },
            { "SE", "Sw\u00edd\u1eb9n" },
            { "se", "N\u1ecd\u0301t\u00e1n S\u00e1m\u00ed L\u00e1ngwej" },
            { "014", "\u00cdst\u00e1n \u00c1fr\u00edk\u00e1" },
            { "015", "N\u1ecd\u0301t\u00e1n \u00c1fr\u00edka" },
            { "SG", "Singap\u1ecd" },
            { "sg", "s\u00e0ngo" },
            { "SH", "Sent H\u1eb9l\u1eb9\u0301na" },
            { "type.lb.strict", "F\u00edksd La\u00edn Br\u1eb9k Sta\u00edl" },
            { "017", "M\u00edd\u00fal \u00c1fr\u00edka" },
            { "SI", "Slov\u1eb9\u0301nia" },
            { "si", "S\u00ednhala" },
            { "018", "Sa\u00fat\u00e1n \u00c1fr\u00edka" },
            { "SJ", "Sv\u00e1lbad & J\u00e9n Mey\u1eb9n" },
            { "019", "Am\u1eb9\u0301r\u00edkas" },
            { "SK", "Slov\u00e9kia" },
            { "sk", "Sl\u00f3vak" },
            { "SL", "Si\u1eb9\u0301ra L\u00edon" },
            { "sl", "Slov\u1eb9\u0301ni\u00e1 L\u00e1ngwej" },
            { "SM", "San Mar\u00edno" },
            { "sm", "Sam\u00f3\u00e1 L\u00e1ngwej" },
            { "SN", "S\u1eb9\u0301n\u1eb9\u0301gal" },
            { "sn", "Sh\u00f3na" },
            { "SO", "S\u1ecdm\u00e1lia" },
            { "so", "S\u1ecdm\u00e1li" },
            { "type.nu.arab", "Ar\u00e1b\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "sq", "Alb\u00e9ni\u00e1 L\u00e1ngwej" },
            { "type.nu.taml", "N\u1ecd\u0301m\u00e1l T\u00e1m\u00edl N\u1ecd\u0301mba-d\u1eb9m" },
            { "SR", "S\u00far\u00ednam" },
            { "sr", "S\u1eb9rbi\u00e1 L\u00e1ngwej" },
            { "SS", "Sa\u00fat Sudan" },
            { "type.cf.account", "Ak\u00e1unt To T\u00e9k Ar\u00e9nj M\u1ecdn\u00ed" },
            { "ST", "Sao T\u00f3m\u00e9 & Pr\u00edns\u00edp\u1eb9" },
            { "st", "Sa\u00fat\u00e1n S\u00f3to" },
            { "su", "S\u1ecd\u0301ndaniz" },
            { "SV", "El S\u00e1lv\u00e1d\u1ecd" },
            { "sv", "Suw\u00edd\u1eb9\u0301n L\u00e1ngwej" },
            { "sw", "Swah\u00edli" },
            { "SX", "Sint M\u00e1tin" },
            { "SY", "S\u00edria" },
            { "type.nu.hantfin", "N\u1ecd\u0301m\u00e1l Chain\u00edz M\u1ecdn\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "SZ", "\u1eb8swat\u00edni" },
            { "TA", "Tr\u00edst\u00e1n da K\u00fana" },
            { "ta", "t\u00e0mil" },
            { "asa", "Asu L\u00e1ngwej" },
            { "type.ms.ussystem", "US S\u00edst\u1eb9m f\u1ecd M\u1eb9\u0301zh\u1ecd\u0301m\u1eb9nt" },
            { "021", "N\u1ecd\u0301t\u00e1n Am\u1eb9\u0301r\u00edka" },
            { "142", "\u00c9shia" },
            { "TC", "T\u1ecdks an Ka\u00edk\u1ecd\u0301s A\u00edlands" },
            { "yav", "Yangb\u1eb9n" },
            { "143", "M\u00edd\u00fal \u00c9shia" },
            { "TD", "Chad" },
            { "te", "T\u1eb9lugu" },
            { "145", "W\u1eb9\u0301st\u00e1n \u00c9shia" },
            { "TF", "Fr\u1eb9\u0301nch Sa\u00fat\u00e1n T\u1eb9\u0301r\u1eb9\u0301tris" },
            { "TG", "T\u00f3go" },
            { "tg", "T\u00e1jik" },
            { "th", metaValue_th },
            { "TH", "Ta\u00edland" },
            { "ti", "Tigr\u00edny\u00e1" },
            { "TJ", "Taj\u00edkstan" },
            { "en_CA", "K\u00e1n\u00e1da \u00cdnglish" },
            { "029", "Kar\u00edbi\u00e1n" },
            { "TK", "T\u00f3k\u1eb9\u0301lau" },
            { "tk", "T\u1ecd\u0301km\u1eb9n" },
            { "TL", "\u00cdst T\u00edm\u1ecd" },
            { "TM", "T\u1ecdkm\u1eb9\u0301n\u00edstan" },
            { "TN", "Tun\u00edshia" },
            { "TO", "T\u00f3nga" },
            { "to", "T\u00f3ngan" },
            { "dyo", "J\u00f3la-F\u00f3nyi L\u00e1ngwej" },
            { "type.nu.jpan", "Jap\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "TT", "Tr\u00edn\u00eddad & Tob\u00e1go" },
            { "tt", "Tat\u00e1" },
            { "TV", "Tuv\u00e1lu" },
            { "TW", "Taiwan" },
            { "ast", "Ast\u00fari\u00e1 L\u00e1ngwej" },
            { "TZ", "Tanz\u00e1nia" },
            { "nmg", "Kwasi\u00f3 L\u00e1ngwej" },
            { "Zzzz", "Ra\u00edt\u00edn S\u00edst\u1eb9m W\u00e9 N\u00f3b\u1ecd\u0301di Sab\u00ed" },
            { "150", "Y\u00farop" },
            { "UA", "Yukrein" },
            { "030", "\u00cdst\u00e1n \u00c9shia" },
            { "151", "\u00cdst\u00e1n Y\u00farop" },
            { "154", "N\u1ecd\u0301t\u00e1n Y\u00farop" },
            { "034", "Sa\u00fat\u00e1n \u00c9shia" },
            { "155", "W\u1eb9\u0301st\u00e1n Y\u00farop" },
            { "035", "Sa\u00fat\u00edst \u00c9shi\u00e1" },
            { "UG", "Yug\u00e1nda" },
            { "ug", "Wi\u00fag\u1ecd" },
            { "Kore", "Koria" },
            { "Zyyy", "J\u1eb9\u0301n\u00e1ral" },
            { "039", "Sa\u00fat\u00e1n Y\u00farop" },
            { "uk", "Yukr\u00e9nia" },
            { "Sinh", "Sinh\u00e1la" },
            { "UM", "U.S. Fa\u00e1 Fa\u00e1 A\u00edlands" },
            { "UN", "Yuna\u00edt\u1eb9d N\u00e9sh\u1ecdns" },
            { "ur", "\u00dard\u00fa" },
            { "US", "Yuna\u00edt\u1eb9\u0301d Stets" },
            { "haw", "Hawaii L\u00e1ngwej" },
            { "UY", "Y\u00farugwue" },
            { "prg", "Pr\u00fashia" },
            { "UZ", "Uzb\u1eb9\u0301kistan" },
            { "uz", "\u00dazb\u1eb9k" },
            { "tzm", "M\u00edd\u00fal Atl\u00e1s T\u00e1maz\u00edgt L\u00e1ngwej" },
            { "nnh", "Ngi\u1eb9\u0301mb\u1ecdn L\u00e1ngwej" },
            { "VA", "V\u00e1t\u00edk\u00e1n S\u00edti" },
            { "VC", "Sent V\u00edns\u1eb9nt & Gr\u1eb9\u0301n\u00e1dians" },
            { "VE", "V\u1eb9n\u1eb9zu\u1eb9\u0301la" },
            { "type.ca.roc", "Rip\u1ecd\u0301bl\u00edk \u1ecdf Cha\u00edn\u00e1 Kal\u1eb9\u0301nda" },
            { "VG", "Br\u00edt\u00edsh V\u00e1j\u00edn A\u00edlands" },
            { "VI", "U.S. V\u00e1j\u00edn A\u00edlands" },
            { "vi", "Vi\u1eb9\u0301tn\u00e1m L\u00e1ngwej" },
            { "khq", "Koyra Ch\u00edn\u00ed L\u00e1ngwej" },
            { "key.hc", "Aw\u00e1 Sa\u00edkul (12 vs 24)" },
            { "VN", "Vi\u1eb9\u0301tnam" },
            { "vo", "V\u00f3lapiuk" },
            { "VU", "Vanu\u00e1tu" },
            { "rwk", "Rwa" },
            { "053", "\u1eccstral\u00e9shia" },
            { "054", "M\u1eb9lan\u1eb9\u00edshia" },
            { "WF", "W\u1ecd\u0301lis & Fiut\u00fana" },
            { "Grek", "Gr\u00edk" },
            { "057", "Maikron\u00edshia R\u00edj\u1ecdn" },
            { "jgo", "Ng\u00f3mb\u00e1 L\u00e1ngwej" },
            { "lkt", "Lak\u00f3t\u00e1 L\u00e1ngwej" },
            { "wo", "W\u00f3lof" },
            { "wae", "W\u1ecd\u0301lsa" },
            { "zgh", "G\u1eb9\u0301n\u00e1r\u00e1l Mor\u00f3k\u00f3 T\u00e1maz\u00edgt L\u00e1ngwej" },
            { "ar_001", "G\u1eb9\u0301n\u00e1r\u00e1l Ar\u00e1b\u00edk L\u00e1ngwej f\u1ecd d\u00eds taim" },
            { "WS", "Sam\u00f3a" },
            { "Mong", metaValue_MN },
            { "XA", "To y\u00faz atif\u00edsh\u00e1l v\u1ecdis w\u1eb9\u0301n yu de t\u1ecdk" },
            { "mni", "Man\u00edpuri" },
            { "XB", "At\u00edf\u00edsh\u00e1l T\u00fa-W\u00e9 Dair\u1eb9\u0301ksh\u1ecdn" },
            { "061", "Polin\u00edshi\u00e1" },
            { "Latn", "L\u00e1tin" },
            { "type.nu.hans", "\u00cdz\u00ed Chain\u00edz N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hant", "N\u1ecd\u0301m\u00e1l Chain\u00edz N\u1ecd\u0301mba-d\u1eb9m" },
            { "xh", "K\u1ecd\u0301sa" },
            { "XK", "K\u00f3s\u00f3vo" },
            { "type.nu.romanlow", "Sm\u1ecd\u0301l Ta\u00edp R\u00f3m\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "Gujr", "Gujar\u00e1ti" },
            { "Zxxx", "W\u00e9t\u00edn D\u1eb9m N\u00f3 Rait" },
            { "kkj", "K\u00e1k\u00f3 L\u00e1ngwej" },
            { "YE", "Y\u1eb9\u0301m\u1eb9n" },
            { "type.co.standard", "N\u1ecd\u0301m\u00e1l W\u00e8 To Ar\u00e9nj Tins W\u1eb9l" },
            { "yi", "Y\u00eddish" },
            { "yo", "Yorub\u00e1" },
            { "es_MX", "M\u1eb9\u0301ksiko Sp\u00e1nish" },
            { "YT", "Mey\u1ecdt" },
            { "vai", "Va\u00ed" },
            { "ZA", "Sa\u00fat \u00c1fr\u00edka" },
            { "type.lb.loose", "L\u00faz La\u00edn Br\u1eb9k Sta\u00edl" },
            { "kln", "K\u00e1l\u1eb9\u0301nj\u00edn L\u00e1ngwej" },
            { "Deva", "D\u1eb9van\u00e1g\u00e1ri" },
            { "zh", "Mandar\u00edn Chain\u00edz L\u00e1ngwej" },
            { "type.nu.geor", "J\u1ecd\u0301ji\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "Hira", "Hiag\u00e1na" },
            { "ZM", "Z\u00e1mbia" },
            { "Bopo", "Bopom\u00f3fo" },
            { "key.lb", "La\u00edn Br\u1eb9k Sta\u00edl" },
            { "zu", "Z\u00falu" },
            { "ZW", "Zimb\u00e1bw\u1eb9" },
            { "Geor", metaValue_GE },
            { "ZZ", "R\u00edj\u1ecdn W\u00e9 N\u00f3b\u1ecd\u0301di Sab\u00ed" },
            { "type.ms.metric", "M\u1eb9\u0301tr\u00edk S\u00edst\u1eb9m" },
            { "type.ca.iso8601", "ISO-8601 Kal\u1eb9\u0301nda" },
            { "type.nu.telu", "T\u1eb9\u0301l\u00fagu N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.jpanfin", "Jap\u00e1n M\u1ecdn\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "ebu", "\u1eb8mbu L\u00e1ngwej" },
            { "jmc", "Mach\u00e1m\u1eb9\u0301 L\u00e1ngwej" },
            { "zh_Hans", metaValue_Hans },
            { "type.nu.hansfin", "\u00cdz\u00ed Chain\u00edz M\u1ecdn\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "kok", "K\u00f3nk\u00e9n\u00ed L\u00e1ngwej" },
            { "type.nu.arabext", "\u1eb8str\u00e1 Ar\u00e1b\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "nus", "N\u00faa" },
            { "type.nu.fullwide", "F\u00fal-Waid N\u1ecd\u0301mba-d\u1eb9m" },
            { "dav", "Ta\u00edta" },
            { "lrc", "N\u1ecd\u0301t\u00e1n L\u00far\u00ed L\u00e1ngwej" },
            { "zh_Hant", "Trad\u00edsh\u1ecd\u0301n\u00e1l Chain\u00edz L\u00e1ngwej" },
            { "type.nu.khmr", "Kmai N\u1ecd\u0301mba-d\u1eb9m" },
            { "mua", "Mund\u00e1ng L\u00e1ngwej" },
            { "type.nu.guru", "G\u00farmukhi N\u1ecd\u0301mba-d\u1eb9m" },
            { "Khmr", "Kem\u1eb9\u1eb9" },
            { "mul", "Pl\u1eb9\u0301nt\u00ed L\u00e1ngwej-d\u1eb9m" },
            { "key.ms", "S\u00edst\u1eb9m f\u1ecd M\u1eb9\u0301zh\u1ecd\u0301m\u1eb9nt" },
            { "type.nu.roman", "R\u00f3m\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "sah", "Sakh\u00e1" },
            { "type.nu.tamldec", "T\u00e1m\u00edl N\u1ecd\u0301mba-d\u1eb9m" },
            { "saq", "Samb\u00faru" },
            { "fa_AF", "D\u00e1ri" },
            { "sat", "S\u00e1nt\u00e1li" },
            { "key.nu", "N\u1ecd\u0301mba-d\u1eb9m" },
            { "Guru", "G\u00farmukhi" },
            { "ksb", "Shambala" },
            { "Telu", "T\u1eb9\u0301l\u00fagu" },
            { "ksf", "Bafi\u00e1 L\u00e1ngwej" },
        };
        return data;
    }
}
