/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.util.Internal;

@Internal
public class EntryUtils {
    @Internal
    public static void copyNodeRecursively(Entry entry, DirectoryEntry target) throws IOException {
        DirectoryEntry newTarget = null;
        if (entry.isDirectoryEntry()) {
            DirectoryEntry dirEntry = (DirectoryEntry)entry;
            newTarget = target.createDirectory(entry.getName());
            newTarget.setStorageClsid(dirEntry.getStorageClsid());
            Iterator<Entry> entries = dirEntry.getEntries();
            while (entries.hasNext()) {
                EntryUtils.copyNodeRecursively(entries.next(), newTarget);
            }
        } else {
            DocumentEntry dentry = (DocumentEntry)entry;
            DocumentInputStream dstream = new DocumentInputStream(dentry);
            target.createDocument(dentry.getName(), dstream);
            dstream.close();
        }
    }

    public static void copyNodes(DirectoryEntry sourceRoot, DirectoryEntry targetRoot) throws IOException {
        for (Entry entry : sourceRoot) {
            EntryUtils.copyNodeRecursively(entry, targetRoot);
        }
    }

    public static void copyNodes(FilteringDirectoryNode filteredSource, FilteringDirectoryNode filteredTarget) throws IOException {
        EntryUtils.copyNodes((DirectoryEntry)filteredSource, (DirectoryEntry)filteredTarget);
    }

    public static void copyNodes(OPOIFSFileSystem source, OPOIFSFileSystem target) throws IOException {
        EntryUtils.copyNodes(source.getRoot(), target.getRoot());
    }

    public static void copyNodes(NPOIFSFileSystem source, NPOIFSFileSystem target) throws IOException {
        EntryUtils.copyNodes(source.getRoot(), target.getRoot());
    }

    public static void copyNodes(OPOIFSFileSystem source, OPOIFSFileSystem target, List<String> excepts) throws IOException {
        EntryUtils.copyNodes(new FilteringDirectoryNode(source.getRoot(), excepts), new FilteringDirectoryNode(target.getRoot(), excepts));
    }

    public static void copyNodes(NPOIFSFileSystem source, NPOIFSFileSystem target, List<String> excepts) throws IOException {
        EntryUtils.copyNodes(new FilteringDirectoryNode(source.getRoot(), excepts), new FilteringDirectoryNode(target.getRoot(), excepts));
    }

    public static boolean areDirectoriesIdentical(DirectoryEntry dirA, DirectoryEntry dirB) {
        if (!dirA.getName().equals(dirB.getName())) {
            return false;
        }
        if (dirA.getEntryCount() != dirB.getEntryCount()) {
            return false;
        }
        HashMap<String, Integer> aSizes = new HashMap<String, Integer>();
        int isDirectory = -12345;
        for (Entry a : dirA) {
            String aName = a.getName();
            if (a.isDirectoryEntry()) {
                aSizes.put(aName, -12345);
                continue;
            }
            aSizes.put(aName, ((DocumentNode)a).getSize());
        }
        for (Entry b : dirB) {
            String bName = b.getName();
            if (!aSizes.containsKey(bName)) {
                return false;
            }
            int size = b.isDirectoryEntry() ? -12345 : ((DocumentNode)b).getSize();
            if (size != (Integer)aSizes.get(bName)) {
                return false;
            }
            aSizes.remove(bName);
        }
        if (!aSizes.isEmpty()) {
            return false;
        }
        for (Entry a : dirA) {
            try {
                Entry b = dirB.getEntry(a.getName());
                boolean match = a.isDirectoryEntry() ? EntryUtils.areDirectoriesIdentical((DirectoryEntry)a, (DirectoryEntry)b) : EntryUtils.areDocumentsIdentical((DocumentEntry)a, (DocumentEntry)b);
                if (match) continue;
                return false;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areDocumentsIdentical(DocumentEntry docA, DocumentEntry docB) throws IOException {
        if (!docA.getName().equals(docB.getName())) {
            return false;
        }
        if (docA.getSize() != docB.getSize()) {
            return false;
        }
        boolean matches = true;
        DocumentInputStream inpA = null;
        DocumentInputStream inpB = null;
        try {
            int readB;
            int readA;
            inpA = new DocumentInputStream(docA);
            inpB = new DocumentInputStream(docB);
            do {
                if ((readA = inpA.read()) == (readB = inpB.read())) continue;
                matches = false;
                break;
            } while (readA != -1 && readB != -1);
        }
        finally {
            if (inpA != null) {
                inpA.close();
            }
            if (inpB != null) {
                inpB.close();
            }
        }
        return matches;
    }
}

