/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Vec3f;

public class Vec3d {
    private double x;
    private double y;
    private double z;

    public Vec3d() {
    }

    public Vec3d(Vec3d arg) {
        this.set(arg);
    }

    public Vec3d(double x, double y, double z) {
        this.set(x, y, z);
    }

    public Vec3d copy() {
        return new Vec3d(this);
    }

    public Vec3f toFloat() {
        return new Vec3f((float)this.x, (float)this.y, (float)this.z);
    }

    public void set(Vec3d arg) {
        this.set(arg.x, arg.y, arg.z);
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(int i, double val) {
        switch (i) {
            case 0: {
                this.x = val;
                break;
            }
            case 1: {
                this.y = val;
                break;
            }
            case 2: {
                this.z = val;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double dot(Vec3d arg) {
        return this.x * arg.x + this.y * arg.y + this.z * arg.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        double len = this.length();
        if (len == 0.0) {
            return;
        }
        this.scale(1.0 / len);
    }

    public Vec3d times(double val) {
        Vec3d tmp = new Vec3d(this);
        tmp.scale(val);
        return tmp;
    }

    public void scale(double val) {
        this.x *= val;
        this.y *= val;
        this.z *= val;
    }

    public Vec3d plus(Vec3d arg) {
        Vec3d tmp = new Vec3d();
        tmp.add(this, arg);
        return tmp;
    }

    public void add(Vec3d b) {
        this.add(this, b);
    }

    public void add(Vec3d a, Vec3d b) {
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        this.z = a.z + b.z;
    }

    public Vec3d addScaled(double s, Vec3d arg) {
        Vec3d tmp = new Vec3d();
        tmp.addScaled(this, s, arg);
        return tmp;
    }

    public void addScaled(Vec3d a, double s, Vec3d b) {
        this.x = a.x + s * b.x;
        this.y = a.y + s * b.y;
        this.z = a.z + s * b.z;
    }

    public Vec3d minus(Vec3d arg) {
        Vec3d tmp = new Vec3d();
        tmp.sub(this, arg);
        return tmp;
    }

    public void sub(Vec3d b) {
        this.sub(this, b);
    }

    public void sub(Vec3d a, Vec3d b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    public Vec3d cross(Vec3d arg) {
        Vec3d tmp = new Vec3d();
        tmp.cross(this, arg);
        return tmp;
    }

    public void cross(Vec3d a, Vec3d b) {
        this.x = a.y * b.z - a.z * b.y;
        this.y = a.z * b.x - a.x * b.z;
        this.z = a.x * b.y - a.y * b.x;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

